/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: uninsaxi.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:31:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

//svdraw.hxx
//#define _SVDRAW_HXX
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
//#define _SDR_NOOBJECTS
//#define _SDR_NOVIEWS
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV


#pragma hdrstop

#include "schdll.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "uninsaxi.hxx"

// ============================================================
//
// class SchUndoInsertAxis
//
// ============================================================

TYPEINIT1( SchUndoInsertAxis, SchUndoAction);

void SchUndoInsertAxis::Undo()
{
	rDoc.ChangeAxis( bOldShowXAxis, bOldShowXDescr,
					 bOldShowYAxis, bOldShowYDescr,
					 bOldShowZAxis, bOldShowZDescr,
					 bOldShow2YAxis,bOldShow2YDescr,
					 bOldShow2XAxis,bOldShow2XDescr, TRUE );
}

void SchUndoInsertAxis::Redo()
{
	rDoc.ChangeAxis( bNewShowXAxis, bNewShowXDescr,
					 bNewShowYAxis, bNewShowYDescr,
					 bNewShowZAxis, bNewShowZDescr,
					 bNewShow2YAxis,bNewShow2YDescr,
					 bNewShow2XAxis,bNewShow2XDescr, TRUE );
}

BOOL SchUndoInsertAxis::CanRepeat(SfxRepeatTarget& rView) const
{
	return FALSE;
}

// ============================================================
//
// class SchUndoInsertGrid
//
// ============================================================

TYPEINIT1( SchUndoInsertGrid, SchUndoAction);

void SchUndoInsertGrid::Undo()
{
	rDoc.ChangeGrid( bOldShowXGridMain, bOldShowXGridHelp,
					 bOldShowYGridMain, bOldShowYGridHelp,
					 bOldShowZGridMain, bOldShowZGridHelp, TRUE );
}

void SchUndoInsertGrid::Redo()
{
	rDoc.ChangeGrid( bNewShowXGridMain, bNewShowXGridHelp,
					 bNewShowYGridMain, bNewShowYGridHelp,
					 bNewShowZGridMain, bNewShowZGridHelp, TRUE );
}

BOOL SchUndoInsertGrid::CanRepeat(SfxRepeatTarget& rView) const
{
	return FALSE;
}



