/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AccDataPoint.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:55:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "AccDataPoint.hxx"

// for SolarMutex
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif
#ifndef _SVDITER_HXX
#include <svx/svditer.hxx>
#endif

#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#ifndef _SCH_SDWINDOW_HXX
#include "chwindow.hxx"
#endif
#ifndef _DEFINES_HXX
#include "defines.hxx"
#endif
#ifndef _SCH_OBJID_HXX
#include "objid.hxx"
#endif
#ifndef _SCH_DATAROW_HXX
#include "datarow.hxx"
#endif
#ifndef _SCH_DATAPOIN_HXX
#include "datapoin.hxx"
#endif

#if OSL_DEBUG_LEVEL > 0
#include <stdio.h>
#endif

using ::rtl::OUString;
using ::rtl::OUStringBuffer;

namespace accessibility
{

DataPoint::DataPoint( AccessibleBase * pParent,
                      sal_uInt16 nSeriesIndex,
                      sal_uInt16 nPointIndex ) :

        AccessibleChartElement( AccessibleUniqueId( CHOBJID_DIAGRAM_DATA, nSeriesIndex, nPointIndex ),
                                pParent,
                                false /* has no children */ ),

            m_nSeriesIndex( nSeriesIndex ),
            m_nPointIndex( nPointIndex )
{
    ChartModel * pModel = GetChartModel();
    OSL_ASSERT( pModel );

    // /-- solar
    ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
    SetItemSet( pModel->GetFullDataPointAttr( nPointIndex, nSeriesIndex ) );
    // \-- solar
}

OUString SAL_CALL DataPoint::getAccessibleName()
    throw (::com::sun::star::uno::RuntimeException)
{
    static const OUString aBaseName( RTL_CONSTASCII_USTRINGPARAM( "DataPoint " ) );
    OUStringBuffer aBuf( aBaseName );
    aBuf.append( static_cast< sal_Int32 >( m_nPointIndex + 1 ));
    aBuf.append( static_cast< sal_Unicode >( '/') );
    aBuf.append( static_cast< sal_Int32 >( m_nSeriesIndex + 1 ));

    return aBuf.makeStringAndClear();
}

DataPoint::~DataPoint()
{
#if OSL_DEBUG_LEVEL > 0
    char pBuf[ 256 ];
    snprintf( pBuf, sizeof(pBuf), "DataPoint %d in Series %d: DTOR called", m_nPointIndex, m_nSeriesIndex );
    OSL_TRACE( pBuf );
#endif
}

OUString SAL_CALL DataPoint::getToolTipText()
    throw (::com::sun::star::uno::RuntimeException)
{
    CheckDisposeState();

    ChartModel* pModel = NULL;
    SchWindow * pWin   = NULL;

    {
        ::osl::MutexGuard aGuard( GetMutex());

        pModel = GetChartModel();
        pWin = GetWindow();
    }

    if( pModel != NULL &&
        pWin != NULL )
    {
        // /-- solar
        ::vos::OGuard aGuard( Application::GetSolarMutex() );
        return OUString( pWin->GetQuickHelpText( CHOBJID_DIAGRAM_DATA, pModel, FALSE, m_nSeriesIndex, m_nPointIndex ));
        // \-- solar
    }
    else
        return OUString();
}

SdrObject * DataPoint::GetDrawObject() const
{
    SdrObject * pShape = NULL;

    ChartModel * pModel = GetChartModel();
    if( ! pModel )
        return pShape;

    bool bHasRowGroup = ! ( pModel->IsPieChart() || pModel->IsDonutChart() );

    const SdrObjList & rObjList = *(pModel->GetPage( 0 ));

#if 1
    SdrObjListIter aIterator( rObjList, IM_FLAT );

    while( aIterator.IsMore())
    {
        pShape = aIterator.Next();
        if( GetObjectIdNum( *pShape ) == CHOBJID_DIAGRAM )
        {
            SdrObject * pParent = pShape;

            if( bHasRowGroup )
            {
                SdrObjListIter aDiagramIter( *(pShape->GetSubList()), IM_FLAT );
                while( aDiagramIter.IsMore())
                {
                    pShape = aDiagramIter.Next();
                    if( GetObjectIdNum( *pShape ) == CHOBJID_DIAGRAM_ROWGROUP )
                    {
                        SchDataRow* pDataRow = GetDataRow( *pShape );
                        if( pDataRow &&
                            pDataRow->GetRow() == m_nSeriesIndex )
                        {
                            pParent = pShape;
                            break;
                        }
                    }
                }
            }

            // search data point object in series or diagram
            SdrObjListIter aLastIter( *(pParent->GetSubList()), IM_FLAT );
            while( aLastIter.IsMore())
            {
                pShape = aLastIter.Next();
                if( GetObjectIdNum( *pShape ) == CHOBJID_DIAGRAM_DATA )
                {
                    SchDataPoint* pDataPoint = GetDataPoint( *pShape );
                    if( pDataPoint &&
                        pDataPoint->GetCol() == m_nPointIndex &&
                        pDataPoint->GetRow() == m_nSeriesIndex )
                    {
                        return pShape;
                    }
                }
            }
        }
    }
#else
    // less performant
    SdrObjListIter aIterator( rObjList, IM_DEEPWITHGROUPS );

    while( aIterator.IsMore())
    {
        pShape = aIterator.Next();
        if( GetObjectIdNum( *pShape ) == CHOBJID_DIAGRAM_DATA )
        {
            SchDataPoint* pDataPoint = GetDataPoint( *pShape );
            if( pDataPoint &&
                pDataPoint->GetCol() == m_nPointIndex &&
                pDataPoint->GetRow() == m_nSeriesIndex )
            {
                return pShape;
            }
        }
    }
#endif

    return 0;
}

OUString SAL_CALL DataPoint::getImplementationName()
    throw (::com::sun::star::uno::RuntimeException)
{
    return OUString( RTL_CONSTASCII_USTRINGPARAM( "AccDataPoint" ));
}

}  // namespace accessibility
