/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SchPersistentObjectPointer.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:42:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
 
#include	"SchPersistentObjectPointer.hxx"

#ifndef _SCH_DATAPOIN_HXX
# include	"datapoin.hxx"
#endif
#ifndef _SCH_DATAROW_HXX
# include	"datarow.hxx"
#endif
#ifndef _SCH_OBJID_HXX
# include	"objid.hxx"
#endif
#ifndef	_DEFINES_HXX
# include	"defines.hxx"
#endif
#ifndef	_TOOLS_DEBUG_HXX
# include	<tools/debug.hxx>
#endif
#ifndef _CHTMODEL_HXX
# include	"chtmodel.hxx"
#endif


//	Id for invalid persistent object pointer.  Largest defined CHOBJID_...
//	is CHOBJID_DIAGRAM_TITLE_C_AXIS == 70.
const	UINT16	CHOBJID_INVALID = 666;

SchPersistentObjectPointer::SchPersistentObjectPointer	(
		UINT16		nObjectId, 
		long 		nSeries,
		long		nIndex)
	:	mnObjectId (nObjectId),
		mnSeries (nSeries),
		mnIndex (nIndex)
{
}




SchPersistentObjectPointer::SchPersistentObjectPointer	(
		const SdrObject * pObject)
	:	mnSeries (-1),
		mnIndex (-1)
{
	mnObjectId = CHOBJID_INVALID;
	
	//	Determine marked object if no valid object is given.
	if (pObject == NULL)
		return;

	//	Determine the id of the object.
	SchObjectId * pId = ::GetObjectId (*pObject);
	if (pId == NULL)
		return;
	mnObjectId = pId->GetObjId ();
	
	//	For certain objects we need more information to describe the object
	//	unambiguously.
	switch (mnObjectId)
	{
		case	CHOBJID_DIAGRAM_DATA:		//	31: a single data point
		{
			SchDataPoint * pDataPoint = GetDataPoint (*pObject);
			if (pDataPoint == NULL)
				mnObjectId = CHOBJID_INVALID;
			else
			{
				mnSeries = pDataPoint->GetRow();
				mnIndex = pDataPoint->GetCol();
			}
			break;
		}
		
		case	CHOBJID_DIAGRAM_ROWS			:	//	29
		case	CHOBJID_DIAGRAM_ROWGROUP		:	//	28: a data row
		case	CHOBJID_DIAGRAM_SPECIAL_GROUP	:	//	55
		{
			SchDataRow * pDataRow = GetDataRow (*pObject);
			if (pDataRow == NULL)
				mnObjectId = CHOBJID_INVALID;
			else
				mnSeries = pDataRow->GetRow();
			break;
		}
	}
}



		
SchPersistentObjectPointer::~SchPersistentObjectPointer	(void)
{
}



	
UINT16	SchPersistentObjectPointer::GetObjectId	(void)	const	
{
	if (mnObjectId == CHOBJID_INVALID)
		//	This id is not known outside this file.  Should be transformed to
		//	something.
		return mnObjectId;
	else
		return mnObjectId;
}




long	SchPersistentObjectPointer::GetSeries	(void)	const
{
	return mnSeries;
}




long	SchPersistentObjectPointer::GetIndex	(void)	const
{
	return mnIndex;
}




/**
	@decr	Use methods of the given chart model to transform the
		object id and indices into a list of valid object pointers.
*/
const std::vector<SdrObject*>	&	SchPersistentObjectPointer::GetPointers	(
	ChartModel	*	pModel)
{
	maObjectList.clear();
	
	switch (mnObjectId)
	{
		//	Data row.
		case	CHOBJID_DIAGRAM_ROWS			:
		case	CHOBJID_DIAGRAM_ROWGROUP		:
		case	CHOBJID_DIAGRAM_SPECIAL_GROUP	:
			{
				//	Iteratate recursively over all objects of the model's page.
				SdrPage * pPage = pModel->GetPage (0);
				SdrObjListIter aIterator (*pPage, IM_DEEPWITHGROUPS);
				while (aIterator.IsMore())
				{
					SdrObject * pObj = aIterator.Next();
					SchObjectId* pObjId = ::GetObjectId(*pObj);
					SchDataRow * pDataRow = GetDataRow(*pObj);
					if (pObjId && pObjId->GetObjId() == mnObjectId)
						//CHOBJID_DIAGRAM_SPECIAL_GROUP))
						if (pDataRow != NULL && pDataRow->GetRow() == mnSeries)
								maObjectList.push_back (pObj);
				}
			}
			break;
		
		//	Data point.
		case	CHOBJID_DIAGRAM_DATA:
			maObjectList.push_back (pModel->GetDataPointObj (mnIndex, mnSeries));
			break;
		
		//	Unknown object.
		case	CHOBJID_INVALID:
			break;
			
		//	Everything else.
		default	:
			maObjectList.push_back (pModel->GetChartObj (mnObjectId));
			break;
	}
	
	return maObjectList;
}
