
package org.netbeans.modules.openoffice.wizard.nodes;

import java.beans.FeatureDescriptor;
import org.netbeans.modules.openoffice.wizard.panels.idl.*;
import org.netbeans.modules.openoffice.wizard.keys.*;
import org.openide.nodes.AbstractNode;
import java.util.Vector;
import org.openide.nodes.Node;


public class ConstantNode extends LeafNode
{

    public ConstantNode(NameKey namedkey)
    {
        super(namedkey);
        setName(namedkey.getName());
        setIconBase("org/netbeans/modules/openoffice/wizard/ui/const");
    }

    public String generateSelf(int i)
    {
        String s = new String();
        String s1 = new String();
        for(int j = 0; j < i; j++)
            s1 = s1 + "    ";

        ConstKey constkey = (ConstKey)key;
        String s2 = constkey.getType();
        String s3 = constkey.getValue();
        if("char".equals(s2) && !s3.startsWith("'"))
            s3 = "'" + s3 + "'";
        else
        if("string".equals(s2) && !s3.startsWith("\""))
            s3 = "\"" + s3 + "\"";
        else
        if("wchar".equals(s2) && !s3.startsWith("L'"))
            s3 = "L'" + s3 + "'";
        else
        if("wstring".equals(s2) && !s3.startsWith("L\""))
            s3 = "L\"" + s3 + "\"";
        s = s1 + "const " + s2 + " " + getName() + " = " + s3 + ";\n";
        return s;
    }

    public BasePanel getEditPanel()
    {
        ConstPanel constpanel = new ConstPanel();
        constpanel.setName(getName());
        constpanel.setType(((ConstKey)key).getType());
        constpanel.setValue(((ConstKey)key).getValue());
        return constpanel;
    }

    public void reInit(BasePanel BasePanel)
    {
        if(BasePanel instanceof ConstPanel)
        {
            String s = ((ConstPanel)BasePanel).getName();
            String s1 = ((ConstPanel)BasePanel).getValue();
            String s2 = ((ConstPanel)BasePanel).getType();
            ConstKey constkey = (ConstKey)key;
            if(!constkey.getName().equals(s))
            {
                constkey.setName(s);
                setName(s);
            }
            if(!constkey.getValue().equals(s1))
                constkey.setValue(s1);
            if(!constkey.getType().equals(s2))
                constkey.setType(s2);
        }
    }

    
    public void generateImports(Vector Imports1)
    {  
        Node anode[] = getChildren().getNodes();
        for(int l = 0; l < anode.length; l++)
        {
            ((BaseNode)anode[l]).generateImports(Imports1);
            
        }  
    }        
 
    
    private static final String ICON_BASE = "org/netbeans/modules/openoffice/wizard/ui/const";
}
