/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: regtools.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 19:35:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef __INETSET_REGTOOLS_HXX__
#define __INETSET_REGTOOLS_HXX__


#if _MSC_VER >= 1200
#include <tools/prewin.h>
#else
#include <tools/presys.h>
#endif
#include <windows.h>
#include <shlobj.h>
#if _MSC_VER >= 1200
#include <tools/postwin.h>
#else
#include <tools/postsys.h>
#endif

#include <rtl/string.hxx>

sal_Bool getRegKey(HKEY rKey, const ::rtl::OString name, HKEY &result);
sal_Bool getRegValue(HKEY rKey, const ::rtl::OString name, DWORD &type,
                 void *buf, DWORD &len);
sal_Bool getRegDWORD(HKEY rKey, const ::rtl::OString name, DWORD &result);
sal_Bool getRegSTRING(HKEY rKey, const ::rtl::OString name, ::rtl::OString &result);

sal_Bool createRegKey(HKEY rKey, const char *rSubKey, const char* rName);
sal_Bool delRegKey(HKEY rKey, const char *rSubKey, const char* rName);
char *getRegValue(HKEY rKey, const char *rSubKey, const char* rName);
sal_Bool isRegKeyAvailable(HKEY rKey, const char *rSubKey, const char* rName);
sal_Bool setRegValue(HKEY rKey, const char *rSubKey,
                 const char *rName, const char *rValue);
sal_Bool setRegDWORD(HKEY rKey, const char *rSubKey,
                 const char *rName, const DWORD &rValue);
sal_Bool setRegBINARY(HKEY rKey, const char *rSubKey, const char *rName,
                  const void *rValue, const int len);

#endif
