/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ifcc_ce.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:17:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#include <precomp.h>
#include <store/ifcc_ce.hxx>


// NOT FULLY DEFINED SERVICES
#include <cosv/template/tpltools.hxx>
#include <ary/cpp/c_namesp.hxx>
#include <ary/cpp/c_class.hxx>
#include <ary/cpp/c_enum.hxx>
#include <ary/cpp/c_tydef.hxx>
#include <ary/cpp/c_funct.hxx>
#include <ary/cpp/c_vari.hxx>
#include <ary/cpp/c_enuval.hxx>
#include <nametree.hxx>
#include "manip.hxx"
#include "sto_cpp.hxx"
#include "ti_storg.hxx"


namespace ary
{
namespace store
{
namespace cpp
{

//********************		CheshireCat		**************//

struct CodeEntity_Ifc::CheshireCat
{
	typedef std::map< uintt, CodeEntity * > CeIndex;
    enum E_NameTask
    {
        nt_type = 0,
        nt_operation,
        nt_data,
        nt_MAX
    };

	ary::store::Cpp *	pStorageCpp;
    ary::NameTree       aIndex_Names[nt_MAX];

	ary::cpp::Namespace *
    					pGlobalNamespace;

						CheshireCat(
							ary::store::Cpp &	io_rStorageCpp );
						~CheshireCat();

    void                Add_Ce(
                            DYN ary::CodeEntity &
                                                let_drCe,
                            E_NameTask          i_eNameTask );

};

void
CodeEntity_Ifc::
CheshireCat::Add_Ce( DYN ary::CodeEntity & let_drCe,
                     E_NameTask            i_eNameTask )
{
    pStorageCpp->Ces()
            .Add(       let_drCe.Id(),
                        let_drCe );
    aIndex_Names[i_eNameTask]
            .insert(    let_drCe.LocalName(),
                        let_drCe.Id() );
}


CodeEntity_Ifc::
CheshireCat::CheshireCat(ary::store::Cpp &	io_rStorageCpp)
	:	pStorageCpp(&io_rStorageCpp),
		pGlobalNamespace(0)
{
}

CodeEntity_Ifc::
CheshireCat::~CheshireCat()
{
}



//********************		CodeEntity_Ifc		**************//

CodeEntity_Ifc::CodeEntity_Ifc( ary::store::Cpp & io_rStorageCpp )
	:	pi( new CheshireCat(io_rStorageCpp) )
{
}

CodeEntity_Ifc::~CodeEntity_Ifc()
{
}

void
CodeEntity_Ifc::Init_GlobalNamespace( DYN ary::cpp::Namespace & let_drNamespace )
{
	Add_Namespace( let_drNamespace );
	pi->pGlobalNamespace = &let_drNamespace;
}

void
CodeEntity_Ifc::Add_Namespace( DYN ary::cpp::Namespace & let_drNamespace )
{
	pi->Add_Ce( let_drNamespace, CheshireCat::nt_type );
}

void
CodeEntity_Ifc::Add_Class( DYN ary::cpp::Class & let_drClass )
{
	pi->Add_Ce( let_drClass, CheshireCat::nt_type );
}

void
CodeEntity_Ifc::Add_Enum( DYN ary::cpp::Enum & let_drEnum )
{
	pi->Add_Ce( let_drEnum, CheshireCat::nt_type );
}

void
CodeEntity_Ifc::Add_Typedef( DYN ary::cpp::Typedef & let_drTypedef )
{
	pi->Add_Ce( let_drTypedef, CheshireCat::nt_type );
}

void
CodeEntity_Ifc::Add_Operation( DYN ary::cpp::Function & let_drFunction )
{
	pi->Add_Ce( let_drFunction, CheshireCat::nt_operation );
}

void
CodeEntity_Ifc::Add_Variable( DYN ary::cpp::Variable & let_drVariable )
{
	pi->Add_Ce( let_drVariable, CheshireCat::nt_data );
}

void
CodeEntity_Ifc::Add_EnumValue( DYN ary::cpp::EnumValue & let_drEnumValue )
{
	pi->Add_Ce( let_drEnumValue, CheshireCat::nt_data );
}

const ary::cpp::Namespace &
CodeEntity_Ifc::GlobalNamespace() const
{
	csv_assert( pi->pGlobalNamespace != 0 );
	return *pi->pGlobalNamespace;
}

uintt
CodeEntity_Ifc::ForEachClass( const Manipulator< ary::CodeEntity > & i_rManip )
{
    return pi->pStorageCpp->Ces().ForEach( i_rManip );
}

const CodeEntity *
CodeEntity_Ifc::Find_Ce( Cid i_nId ) const
{
	return pi->pStorageCpp->Ces().Find( i_nId );
}

const InstanceList &
CodeEntity_Ifc::Search_TypeName( const udmstri & i_sName ) const
{
 	return pi->aIndex_Names[CheshireCat::nt_type][i_sName];
}

const InstanceList &
CodeEntity_Ifc::Search_OperationName( const udmstri & i_sName ) const
{
 	return pi->aIndex_Names[CheshireCat::nt_operation][i_sName];
}

const InstanceList &
CodeEntity_Ifc::Search_DataName( const udmstri & i_sName ) const
{
 	return pi->aIndex_Names[CheshireCat::nt_data][i_sName];
}

const ary::cpp::Namespace *
CodeEntity_Ifc::Find_Namespace( Cid i_nId ) const
{
    ary::CodeEntity * ret = pi->pStorageCpp->Ces().Find( i_nId );
    if ( ret != 0 ? ret->RC() == ary::cpp::Namespace::RC_() : false )
        return static_cast< ary::cpp::Namespace* >(ret);
    return 0;
}

const ary::cpp::Class *
CodeEntity_Ifc::Find_Class( Cid i_nId ) const
{
    ary::CodeEntity * ret = pi->pStorageCpp->Ces().Find( i_nId );
    if ( ret != 0 ? ret->RC() == ary::cpp::Class::RC_() : false )
        return static_cast< ary::cpp::Class* >(ret);
    return 0;
}

const ary::cpp::Enum *
CodeEntity_Ifc::Find_Enum( Cid i_nId ) const
{
    ary::CodeEntity * ret = pi->pStorageCpp->Ces().Find( i_nId );
    if ( ret != 0 ? ret->RC() == ary::cpp::Enum::RC_() : false )
        return static_cast< ary::cpp::Enum* >(ret);
    return 0;
}

const ary::cpp::Typedef *
CodeEntity_Ifc::Find_Typedef( Cid i_nId ) const
{
    ary::CodeEntity * ret = pi->pStorageCpp->Ces().Find( i_nId );
    if ( ret != 0 ? ret->RC() == ary::cpp::Typedef::RC_() : false )
        return static_cast< ary::cpp::Typedef* >(ret);
    return 0;
}

const ary::cpp::Function *
CodeEntity_Ifc::Find_Operation( Cid i_nId ) const
{
    ary::CodeEntity * ret = pi->pStorageCpp->Ces().Find( i_nId );
    if ( ret != 0 ? ret->RC() == ary::cpp::Function::RC_() : false )
        return static_cast< ary::cpp::Function* >(ret);
    return 0;
}

const ary::cpp::Variable *
CodeEntity_Ifc::Find_Variable( Cid i_nId ) const
{
    ary::CodeEntity * ret = pi->pStorageCpp->Ces().Find( i_nId );
    if ( ret != 0 ? ret->RC() == ary::cpp::Variable::RC_() : false )
        return static_cast< ary::cpp::Variable* >(ret);
    return 0;
}

const ary::cpp::EnumValue *
CodeEntity_Ifc::Find_EnumValue( Cid i_nId ) const
{
    ary::CodeEntity * ret = pi->pStorageCpp->Ces().Find( i_nId );
    if ( ret != 0 ? ret->RC() == ary::cpp::EnumValue::RC_() : false )
        return static_cast< ary::cpp::EnumValue* >(ret);
    return 0;
}

ary::NameTree::const_iterator
CodeEntity_Ifc::LowerBound_Type( const char * i_sSearch ) const
{
    return pi->aIndex_Names[CheshireCat::nt_type].lower_bound( udmstri(i_sSearch) );
}

ary::NameTree::const_iterator
CodeEntity_Ifc::LowerBound_Operation( const char * i_sSearch ) const
{
    return pi->aIndex_Names[CheshireCat::nt_operation].lower_bound( udmstri(i_sSearch) );
}

ary::NameTree::const_iterator
CodeEntity_Ifc::LowerBound_Data( const char * i_sSearch ) const
{
    return pi->aIndex_Names[CheshireCat::nt_data].lower_bound( udmstri(i_sSearch) );
}

ary::cpp::Namespace &
CodeEntity_Ifc::GlobalNamespace()
{
	csv_assert( pi->pGlobalNamespace != 0 );
	return *pi->pGlobalNamespace;
}

ary::cpp::Class *
CodeEntity_Ifc::Find_Class(	Cid	i_nId )
{

	return const_cast< ary::cpp::Class * >(
            const_cast< const CodeEntity_Ifc* >(this)
                ->Find_Class(i_nId) );
}





} // namespace cpp
} // namespace store
} // namespace ary


