/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: cg_proj.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:36:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#include <precomp.h>
#include <ary/cpp/cg_proj.hxx>


// NOT FULLY DEFINED SERVICES
#include <ary/docu.hxx>
#include <ary/cpp/cpp_disp.hxx>
#include <slots.hxx>
#include "rcids.hxx"



namespace ary
{
namespace cpp
{


ProjectGroup::ProjectGroup( Gid                 i_nId,
                            const udmstri &     i_sName,
                            Lid                 i_nRootDir )
    :   nId(i_nId),
        sName(i_sName),
        nRootDir(i_nRootDir),
        // aMyNamespaces,
        // aMyFiles,
        pDocu(0)
{
}

ProjectGroup::~ProjectGroup()
{
}

void
ProjectGroup::CheckIn_Namespace( Cid i_nNamespace )
{
    aMyNamespaces.insert(i_nNamespace);
}

void
ProjectGroup::Add_File( Lid i_nFile )
{
    aMyFiles.insert(i_nFile);
}

bool
ProjectGroup::HasNamespace( Cid i_nNamespace ) const
{
    return aMyNamespaces.count(i_nNamespace) == 1;
}

Gid
ProjectGroup::inq_Id_Group() const
{
    return nId;
}

const RepositoryEntity &
ProjectGroup::inq_RE_Group() const
{
    return *this;
}

const group::SlotList &
ProjectGroup::inq_Slots() const
{
    static const SlotAccessId aProjectSlotData[]
            = { SLOT_Namespaces, SLOT_Files };
    static const std::vector< SlotAccessId >
            aSlots( &aProjectSlotData[0],
                      &aProjectSlotData[0]
                        + sizeof aProjectSlotData / sizeof (SlotAccessId) );
    return aSlots;
}

DYN Slot *
ProjectGroup::inq_Create_Slot( SlotAccessId i_nSlot ) const
{
    switch ( i_nSlot )
    {
     	case SLOT_Namespaces:   return new Slot_RidSet(aMyNamespaces);
        case SLOT_Files:        return new Slot_LidSet(aMyFiles);
        default:
                                return new Slot_Null;
    }   // end switch
}

const udmstri &
ProjectGroup::inq_Name() const
{
 	return sName;
}

void
ProjectGroup::do_StoreAt( ary::Display & o_rOut ) const
{
    ary::cpp::Display * pD = dynamic_cast< ary::cpp::Display* >(&o_rOut);
    if (pD != 0)
    {
     	pD->Display_ProjectGroup(*this);
    }
}

Rid
ProjectGroup::inq_Id() const
{
    return nId;
}

RCid
ProjectGroup::inq_RC() const
{
    return RCID_PROJECTGROUP;
}

const ary::Documentation &
ProjectGroup::inq_Info() const
{
    return pDocu ? *pDocu : ary::Documentation::Null_();
}

void
ProjectGroup::do_Add_Documentation( DYN ary::Documentation & let_drInfo )
{
    pDocu = &let_drInfo;
}



}   // namespace cpp
}   // namespace ary



