/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: cg_file.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:02:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_CPP_CG_FILE_HXX
#define ARY_CPP_CG_FILE_HXX


// USED SERVICES
	// BASE CLASSES
#include <ary/arygroup.hxx>
#include <ary/re.hxx>
	// COMPONENTS
#include <ary/idlists.hxx>
	// PARAMETERS


namespace ary
{
namespace cpp
{

class FileGroup : public ary::AryGroup,
                  public ary::RepositoryEntity
{
  public:
    enum E_Slots
    {
        SLOT_Classes = 1,
        SLOT_Enums,
        SLOT_Typedefs,
        SLOT_Operations,
        SLOT_Variables,
        SLOT_Constants
    };

	// LIFECYCLE
                        FileGroup(
                            Rid                 i_nId,
                            Lid                 i_nFile,
                            const udmstri &     i_sFileName,
                            Rid                 i_nProjectGroup );
	virtual			   	~FileGroup();

    // OPERATIONS
    void                Add_Class(
                            Cid                 i_nId );
    void                Add_Enum(
                            Cid                 i_nId );
    void                Add_Typedef(
                            Cid                 i_nId );
    void                Add_Operation(
                            Cid                 i_nId );
    void                Add_Variable(
                            Cid                 i_nId );
    void                Add_Constant(
                            Cid                 i_nId );
    // INQUIRY
    Lid                 AssociatedFile() const  { return nFile; }
    Rid                 OwningProject() const   { return nProjectGroup; }
    const udmstri &     FileName() const        { return sFileName; }

  private:
        // Interface AryGroup
	virtual Gid 		inq_Id_Group() const;
    virtual const RepositoryEntity &
                        inq_RE_Group() const;
	virtual const group::SlotList &
                        inq_Slots() const;
    virtual DYN Slot *  inq_Create_Slot(
                            SlotAccessId        i_nSlot ) const;

    // Interface ary::RepositoryEntity
    virtual void        do_StoreAt(
                            ary::Display &      o_rOut ) const;
	virtual Rid 		inq_Id() const;
	virtual RCid 		inq_RC() const;
	virtual const ary::Documentation &
            	        inq_Info() const;
    virtual void        do_Add_Documentation(
	                        DYN ary::Documentation &
                                                let_drInfo );
    // DATA
    udmstri             sFileName;
    Gid                 nId;
    Lid                 nFile;
    Rid                 nProjectGroup;
    Set_Rid             aMyClasses;
    Set_Lid             aMyEnums;
    Set_Lid             aMyTypedefs;
    Set_Lid             aMyOperations;
    Set_Lid             aMyVariables;
    Set_Lid             aMyConstants;
    Dyn< ary::Documentation >
                        pDocu;
};


}   // namespace cpp
}   // namespace ary


#endif



