/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tbxmgr.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: kz $ $Date: 2006/01/05 17:52:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFXTBXMGR_HXX
#define _SFXTBXMGR_HXX

#ifndef _TOOLBOX_HXX //autogen
#include <vcl/toolbox.hxx>
#endif

#include <vcl/bitmap.hxx>
#include <framework/toolboxconfiguration.hxx>

#include <bf_sfx2/sfx.hrc>
#include <bf_sfx2/app.hxx>
#include <bf_sfx2/cfgitem.hxx>
#include <bf_sfx2/imgmgr.hxx>
namespace binfilter {

//--------------------------------------------------------------------

class SfxToolBoxControl;
class SfxToolBoxControlArr_Impl;
class SfxViewFrame;
class SfxBindings;
class SfxInterface;

#define SFXTOOLBOX_RUNTIMEITEM_COUNT	1

//--------------------------------------------------------------------

class SfxToolBoxManager: public SfxConfigItem
{
friend class SfxToolbox;

	static USHORT			nRuntimeIDs[SFXTOOLBOX_RUNTIMEITEM_COUNT];

	SfxViewFrame*			pFrame;
	Window*                 pParent;
	ToolBox*				pBox;
	SfxToolBoxControlArr_Impl* pControls;
	SfxBindings*			pBindings;
	USHORT					nIteratorPos;
	SfxSymbolsSize			eSymbolsSize;
	ResMgr* 				pResMgr;
	SfxInterface*			pIFace;
    BOOL                    bInternal : 1;
	BOOL					bHiContrast : 1;
	BOOL					bConfigMode : 1;

private:
	void            Construct();
	void			Align();
	void            CreateFromSVToolBox();
	SfxToolBoxControl* FindControl_Impl( USHORT nId ) const;
	void			CreateRuntimeItems();
	void			AppendAddOnsItems();

					// only for internal purposes
					SfxToolBoxManager( SfxConfigManager*, USHORT );

public:
					// ctor f"ur ToolBoxManager, die keine Objectbars sind
					SfxToolBoxManager( Window*, SfxBindings&, const ResId& );

					// ctoren f"ur ObjectBars
					SfxToolBoxManager( Window*, SfxBindings&, const ResId& rId,
						SfxInterface*, USHORT nPos, SfxShell* pTask );
					SfxToolBoxManager( Window*, SfxBindings&, const ResId& rId,
						SfxInterface*, USHORT nPos, SfxShell* pTask, BOOL bConfigMode );
					SfxToolBoxManager( const ResId& rId, SfxInterface*, const String&,
						SfxToolBoxManager*, SfxShell* pTask );
					~SfxToolBoxManager();

	void			SetFrame(SfxViewFrame* pFr) { pFrame = pFr;}
	SfxViewFrame*   GetFrame() const {return pFrame; }
//	void			SetResMgr(ResMgr* pMgr)  {pResMgr = pMgr; }

	SfxBindings&	GetBindings() { return *pBindings; }
	const SfxBindings&	GetBindings() const { return *pBindings; }

	static void		CreateConfiguration( SfxConfigManager*, USHORT );
	static void		RemoveConfiguration( SfxConfigManager*, USHORT );
	static BOOL     Import( SvStream& rInStream, SvStream& rOutStream );
    static BOOL     Export( SvStream& rInStream, SvStream& rOutStream );
    static int      LoadToolBox( SvStream&, ::framework::ToolBoxDescriptor& );
    static BOOL     StoreToolBox( SvStream&, ::framework::ToolBoxDescriptor& );

	virtual int     Load(SotStorage&);
	virtual BOOL    Store(SotStorage&);
	virtual void    UseDefault();
    virtual String  GetStreamName() const;

	DECL_LINK( Activate, ToolBox * );
	DECL_LINK( Deactivate, ToolBox * );
	DECL_LINK( Select, ToolBox * );

					// interface forward to the ToolBox
	Size			CalcWindowSizePixel() const
						{ return pBox->CalcWindowSizePixel(); }
	void            SetPosSizePixel( const Point& rPos, const Size& rSize )
						{ pBox->SetPosSizePixel( rPos, rSize ); }
	void			SetBackground( const Wallpaper& rBackground )
						{ pBox->SetBackground( rBackground ); }

	// reading out the toolbox
	void			Clear();
	BOOL			FirstItem();		 // resets the item iterator, FALSE if none
	BOOL			NextItem(); 		 // skips to the next item, FALSE if no more
//STRIP001 	BOOL			IsBinding() const;	 // TRUE if current item is a binding
//STRIP001 	BOOL			IsSeparator() const; // TRUE if current item is a separator
//STRIP001 	USHORT			GetId() const;		 // id of current binding if IsBinding()

	ToolBox&		GetToolBox() const { return *pBox; }
	SfxSymbolsSize    GetSymbolsSize() const
					{return eSymbolsSize; }
	void			SetSymbolsSize(SfxSymbolsSize eNewSet);
	ButtonType      GetButtonType() const
					{ return pBox->GetButtonType(); }
	void			SetButtonType( ButtonType eNewType);
	WindowAlign		GetAlign() const { return pBox->GetAlign(); }
	void			SetItemText( USHORT, const String& );

	void            Show();
	void            Hide();
	BOOL			IsVisible() const { return pBox && pBox->IsVisible(); }
	void			SetHiContrast( BOOL bSet = TRUE ) { bHiContrast = bSet; }
	BOOL			IsHiContrast() { return bHiContrast; }

	void            SetFloatingModeData (const Point&, USHORT, long);
	void            Customize( const ToolBoxCustomizeEvent& rCEvt );
	void			InsertItem( USHORT nId, Image& aImage, USHORT nTargetPos, USHORT nHelpId, String aItemText );
	void			RemoveItem( USHORT nId, USHORT nPos );
    virtual BOOL    ReInitialize();
	void			Delete();
//STRIP001 	void 			NextToolBox();
    BOOL            IsInternal();
    BOOL			IsRuntimeItem( USHORT nId );

#if _SOLAR__PRIVATE
	void 			RefreshImages_Impl();
	void            UpdateControls_Impl();
	static BOOL		IsUserDefToolBox_Impl(USHORT nId);
	static USHORT	GetUserDefToolBoxId_Impl();
//STRIP001 	void			ReInitControllers_Impl();
	USHORT			GetNextToolBox_Impl( String *pStr = 0 );
	void			Reconfigure_Impl( SfxToolBoxConfig*  );
#endif

#undef C_VERSION
};

}//end of namespace binfilter
#endif // #ifndef _SFXTBXMGR_HXX

