/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_scroll.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:47:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

// auto strip #include "swtypes.hxx"
// auto strip #include "swrect.hxx"
#include "scroll.hxx"
namespace binfilter {

#define SCROLL_LINE_SIZE 250


/*N*/ SwScrollbar::SwScrollbar( Window *pWin, int bHoriz ) :
/*N*/ 	ScrollBar( pWin,
/*N*/ 	WinBits( WB_3DLOOK | WB_HIDE | ( bHoriz ? WB_HSCROLL : WB_VSCROLL)  ) ),
/*N*/ 	bHori( bHoriz ),
/*N*/ 	bAuto( FALSE ),
/*N*/ 	bThumbEnabled( TRUE ),
/*N*/ 	bVisible(FALSE),
/*N*/ 	bSizeSet(FALSE)
/*N*/ {
/*M*/     // SSA: --- RTL --- no mirroring for horizontal scrollbars
/*M*/     if( bHoriz )
/*M*/         EnableRTL( FALSE );
/*N*/ }


/*N*/  SwScrollbar::~SwScrollbar() {}

/*------------------------------------------------------------------------
 Beschreibung:	wird nach einer Aenderung der Dokumentgroesse gerufen, um den
				Range des Scrollbars neu einzustellen.
------------------------------------------------------------------------*/

//STRIP001 void SwScrollbar::DocSzChgd( const Size &rSize )
//STRIP001 {
//STRIP001 	aDocSz = rSize;
//STRIP001 	SetRange( Range( 0, bHori ? rSize.Width() : rSize.Height()) );
//STRIP001 	const ULONG nVisSize = GetVisibleSize();
//STRIP001     SetLineSize( SCROLL_LINE_SIZE );
//STRIP001 //    SetLineSize( nVisSize * 10 / 100 );
//STRIP001 	SetPageSize( nVisSize * 77 / 100 );
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:	wird nach einer Veraenderung des sichtbaren Ausschnittes
				gerufen.
------------------------------------------------------------------------*/


//STRIP001 void SwScrollbar::ViewPortChgd( const Rectangle &rRect )
//STRIP001 {
//STRIP001     long nThumb, nVisible;
//STRIP001 	if( bHori )
//STRIP001 	{
//STRIP001 		nThumb = rRect.Left();
//STRIP001 		nVisible = rRect.GetWidth();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nThumb = rRect.Top();
//STRIP001 		nVisible = rRect.GetHeight();
//STRIP001 	}
//STRIP001 
//STRIP001 	SetVisibleSize( nVisible );
//STRIP001 	DocSzChgd(aDocSz);
//STRIP001 	if ( bThumbEnabled )
//STRIP001 		SetThumbPos( nThumb );
//STRIP001 	long nVis = GetVisibleSize();
//STRIP001 	long nLen = GetRange().Len();
//STRIP001 	if(bAuto)
//STRIP001 		AutoShow();
//STRIP001 }

//STRIP001 void SwScrollbar::EnableThumbPos( BOOL bEnable, const SwRect &rVisArea )
//STRIP001 {
//STRIP001 	bThumbEnabled = bEnable;
//STRIP001 	if ( bEnable )
//STRIP001 	{
//STRIP001 		long nThumb = bHori ? rVisArea.Left() : rVisArea.Top();
//STRIP001 		SetThumbPos( nThumb );
//STRIP001 	}
//STRIP001 }

/*-----------------10/21/97 02:48pm-----------------

--------------------------------------------------*/
/*N*/ void SwScrollbar::Show( BOOL bSet )
/*N*/ {
/*N*/ 	bVisible = bSet;
/*N*/ 	if( (!bSet ||  !bAuto) && IsUpdateMode() && bSizeSet)
/*N*/ 		ScrollBar::Show(bSet);
/*N*/ }

/*-----------------10/21/97 03:23pm-----------------

--------------------------------------------------*/
//STRIP001 void SwScrollbar::SetPosSizePixel( const Point& rNewPos, const Size& rNewSize )
//STRIP001 {
//STRIP001 	ScrollBar::SetPosSizePixel(rNewPos, rNewSize);
//STRIP001 	bSizeSet = TRUE;
//STRIP001 	if(bVisible)
//STRIP001 		Show();
//STRIP001 
//STRIP001 }

/*-----------------10/21/97 04:47pm-----------------

--------------------------------------------------*/
//STRIP001 void SwScrollbar::SetUpdateMode( BOOL bUpdate )
//STRIP001 {
//STRIP001     ScrollBar::SetUpdateMode( bUpdate );
//STRIP001 	if(bUpdate &&
//STRIP001 		bVisible != ScrollBar::IsVisible())
//STRIP001 	{
//STRIP001 		if(bAuto)
//STRIP001 			AutoShow();
//STRIP001 		else
//STRIP001 			ScrollBar::Show(bVisible);
//STRIP001 	}
//STRIP001 }
/*-----------------14.04.98 11:38-------------------

--------------------------------------------------*/
/*N*/ void SwScrollbar::SetAuto(BOOL bSet)
/*N*/ {
/*N*/     if(bAuto != bSet)
/*N*/ 	{
/*N*/ 		bAuto = bSet;
/*N*/ 
/*N*/ 		// automatisch versteckt - dann anzeigen
/*N*/ 		if(!bAuto && bVisible && !ScrollBar::IsVisible())
/*?*/ 			Show(TRUE);
/*N*/ 		else if(bAuto)
/*N*/ 			AutoShow();	// oder automatisch verstecken
/*N*/ 	}
/*N*/ }
/*-----------------14.04.98 11:43-------------------

--------------------------------------------------*/
/*N*/ void SwScrollbar::AutoShow()
/*N*/ {
/*N*/ 	long nVis = GetVisibleSize();
/*N*/ 	long nLen = GetRange().Len();
/*N*/ 	{
/*N*/ 		if( nVis >= nLen - 1)
/*N*/ 		{
/*?*/ 			if(ScrollBar::IsVisible())
/*?*/ 				ScrollBar::Show(FALSE);
/*N*/ 		}
/*N*/ 		else if ( !ScrollBar::IsVisible() &&
/*N*/ 				  (!bHori || nVis) )		//Optimierung fuer Browser.
/*N*/ 											//Horizontaler Scrollbar per
/*N*/ 											//default aus.
/*N*/ 		{
/*?*/ 			ScrollBar::Show(TRUE);
/*N*/ 		}
/*N*/ 	}
/*N*/ }
}
