/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_edtwin3.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 04:49:04 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

// auto strip #include <hintids.hxx>
// auto strip #include "uiparam.hxx"
// auto strip #ifndef _SV_SETTINGS_HXX
// auto strip #include <vcl/settings.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_RULER_HXX //autogen
// auto strip #include <bf_svx/ruler.hxx>
// auto strip #endif

// auto strip #ifndef _VIEWOPT_HXX //autogen
// auto strip #include <viewopt.hxx>
// auto strip #endif
#include "view.hxx"

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

#include "wrtsh.hxx"
// auto strip #include "basesh.hxx"
#include "pview.hxx"
#include "mdiexp.hxx"
// auto strip #include "edtwin.hxx"
#include "swmodule.hxx"
#include "modcfg.hxx"
// auto strip #include "swtable.hxx"
// auto strip #include "docsh.hxx"
// auto strip #include "pagedesc.hxx"     // Aktuelles Seitenformat
#ifndef _FRMATR_HXX
#include <frmatr.hxx>
#endif
// auto strip #ifndef _SVX_FRMDIRITEM_HXX
// auto strip #include <bf_svx/frmdiritem.hxx>
// auto strip #endif
namespace binfilter {


/*--------------------------------------------------------------------
	Beschreibung:	Core-Notify
 --------------------------------------------------------------------*/



/*N*/ void ScrollMDI( ViewShell* pVwSh, const SwRect &rRect,
/*N*/ 				USHORT nRangeX, USHORT nRangeY)
/*N*/ {
/*N*/ 	SfxViewShell *pSfxVwSh = pVwSh->GetSfxViewShell();
/*N*/ 	if (pSfxVwSh && pSfxVwSh->ISA(SwView))
/*N*/ 		((SwView *)pSfxVwSh)->Scroll( rRect.SVRect(), nRangeX, nRangeY );
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:	Docmdi - verschiebbar
 --------------------------------------------------------------------*/



/*N*/ BOOL IsScrollMDI( ViewShell* pVwSh, const SwRect &rRect )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	SfxViewShell *pSfxVwSh = pVwSh->GetSfxViewShell();
//STRIP001 	if (pSfxVwSh && pSfxVwSh->ISA(SwView))
//STRIP001 		return (((SwView *)pSfxVwSh)->IsScroll(rRect.SVRect()));
/*N*/ 	return FALSE;
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:	Notify fuer Groessen-Aenderung
 --------------------------------------------------------------------*/



/*N*/ void SizeNotify(ViewShell* pVwSh, const Size &rSize)
/*N*/ {
/*N*/ 	SfxViewShell *pSfxVwSh = pVwSh->GetSfxViewShell();
/*N*/ 	if (pSfxVwSh)
/*N*/ 	{
/*N*/ 		if (pSfxVwSh->ISA(SwView))
/*N*/ 			((SwView *)pSfxVwSh)->DocSzChgd(rSize);
/*N*/ 		else if (pSfxVwSh->ISA(SwPagePreView))
/*N*/			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 			((SwPagePreView *)pSfxVwSh)->DocSzChgd( rSize );
/*N*/ 	}
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:	Notify fuer Seitenzahl-Update
 --------------------------------------------------------------------*/



/*N*/ void PageNumNotify( ViewShell* pVwSh, USHORT nPhyNum, USHORT nVirtNum,
/*N*/ 													const String& rPgStr)
/*N*/ {
/*N*/ 	SfxViewShell *pSfxVwSh = pVwSh->GetSfxViewShell();
/*N*/ 	if ( pSfxVwSh && pSfxVwSh->ISA(SwView) &&
/*N*/ 		 ((SwView*)pSfxVwSh)->GetCurShell() )
/*N*/ 			((SwView *)pSfxVwSh)->UpdatePageNums(nPhyNum, nVirtNum, rPgStr);
/*N*/ }

/******************************************************************************
 *	Methode		:	void FrameNotify( DocMDIBase *pWin, FlyMode eMode )
 *	Beschreibung:
 *	Erstellt	:	OK 08.02.94 13:49
 *	Aenderung	:
 ******************************************************************************/



/*N*/ void FrameNotify( ViewShell* pVwSh, FlyMode eMode )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( pVwSh->ISA(SwCrsrShell) )
//STRIP001 		SwBaseShell::SetFrmMode( eMode, (SwWrtShell*)pVwSh );
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:	Notify fuer Seitenzahl-Update
 --------------------------------------------------------------------*/
//STRIP001 BOOL SwEditWin::RulerColumnDrag( SwView& rView , const MouseEvent& rMEvt, BOOL bVerticalMode)
//STRIP001 {
//STRIP001     SvxRuler& rRuler = bVerticalMode ?  rView.GetVLineal() : rView.GetHLineal();
//STRIP001     return (!rRuler.StartDocDrag( rMEvt, RULER_TYPE_BORDER ) &&
//STRIP001             !rRuler.StartDocDrag( rMEvt, RULER_TYPE_MARGIN1) &&
//STRIP001             !rRuler.StartDocDrag( rMEvt, RULER_TYPE_MARGIN2));
//STRIP001 }
//STRIP001 
//STRIP001 Dialog* GetSearchDialog()
//STRIP001 {
//STRIP001 	return SwView::GetSearchDialog();
//STRIP001 }



//STRIP001 void JavaScriptScrollMDI( SfxFrame* pFrame, INT32 nX, INT32 nY )
//STRIP001 {
//STRIP001 	SfxViewShell *pSfxVwSh = pFrame->GetCurrentViewFrame()->GetViewShell();
//STRIP001 	if( pSfxVwSh && pSfxVwSh->ISA( SwView ))
//STRIP001 	{
//STRIP001 		SwView* pView = (SwView *)pSfxVwSh;
//STRIP001 
//STRIP001 		Size aSz( nX, nY );
//STRIP001 		aSz = pView->GetEditWin().PixelToLogic( aSz );
//STRIP001 
//STRIP001 		Point aTopLeft( aSz.Width(), aSz.Height() );
//STRIP001 		if( aTopLeft.X() < DOCUMENTBORDER )	aTopLeft.X() = DOCUMENTBORDER;
//STRIP001 		if( aTopLeft.Y() < DOCUMENTBORDER )	aTopLeft.Y() = DOCUMENTBORDER;
//STRIP001 
//STRIP001 		const Size& rVisSize = pView->GetVisArea().GetSize();
//STRIP001 		Size aDocSize( pView->GetDocSz() );
//STRIP001 		aDocSize.Width() += DOCUMENTBORDER;
//STRIP001 		aDocSize.Height() += DOCUMENTBORDER;
//STRIP001 
//STRIP001 		if( aTopLeft.X() + rVisSize.Width() > aDocSize.Width() )
//STRIP001 			aTopLeft.X() = rVisSize.Width() > aDocSize.Width()
//STRIP001 								? DOCUMENTBORDER
//STRIP001 								: aDocSize.Width() - rVisSize.Width();
//STRIP001 
//STRIP001 		if( aTopLeft.Y() + rVisSize.Height() > aDocSize.Height() )
//STRIP001 			aTopLeft.Y() = rVisSize.Height() > aDocSize.Height()
//STRIP001 								? DOCUMENTBORDER
//STRIP001 								: aDocSize.Height() - rVisSize.Height();
//STRIP001 
//STRIP001 		pView->SetVisArea( aTopLeft );
//STRIP001 	}
//STRIP001 }



/*N*/ USHORT GetTblChgDefaultMode()
/*N*/ {
/*N*/ 	SwModuleOptions* pOpt = SW_MOD()->GetModuleConfig();
/*N*/ 	return pOpt ? pOpt->GetTblMode() : TBLVAR_CHGABS;
/*N*/ }



/*N*/ void RepaintPagePreview( ViewShell* pVwSh, const SwRect& rRect )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	SfxViewShell *pSfxVwSh = pVwSh->GetSfxViewShell();
//STRIP001 	if (pSfxVwSh && pSfxVwSh->ISA( SwPagePreView ))
//STRIP001 		((SwPagePreView *)pSfxVwSh)->RepaintCoreRect( rRect );
/*N*/ }

//STRIP001 BOOL JumpToSwMark( ViewShell* pVwSh, const String& rMark )
//STRIP001 {
//STRIP001 	SfxViewShell *pSfxVwSh = pVwSh->GetSfxViewShell();
//STRIP001 	if( pSfxVwSh && pSfxVwSh->ISA( SwView ) )
//STRIP001 		return ((SwView *)pSfxVwSh)->JumpToSwMark( rMark );
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 void SwEditWin::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	Window::DataChanged( rDCEvt );
//STRIP001 
//STRIP001     SwWrtShell* pSh = GetView().GetWrtShellPtr();
//STRIP001     //#99906#   DataChanged() is sometimes called prior to creating
//STRIP001     //          the SwWrtShell
//STRIP001     if(!pSh)
//STRIP001         return;
//STRIP001     BOOL bViewWasLocked = pSh->IsViewLocked(), bUnlockPaint = FALSE;
//STRIP001     pSh->LockView( TRUE );
//STRIP001 	switch( rDCEvt.GetType() )
//STRIP001 	{
//STRIP001 	case DATACHANGED_SETTINGS:
//STRIP001 		// ScrollBars neu anordnen bzw. Resize ausloesen, da sich
//STRIP001 		// ScrollBar-Groesse geaendert haben kann. Dazu muss dann im
//STRIP001 		// Resize-Handler aber auch die Groesse der ScrollBars aus
//STRIP001 		// den Settings abgefragt werden.
//STRIP001 		if( rDCEvt.GetFlags() & SETTINGS_STYLE )
//STRIP001 		{
//STRIP001             pSh->LockPaint();
//STRIP001 			bUnlockPaint = TRUE;
//STRIP001 			GetView().InvalidateBorder();				//Scrollbarbreiten
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case DATACHANGED_PRINTER:
//STRIP001 	case DATACHANGED_DISPLAY:
//STRIP001 	case DATACHANGED_FONTS:
//STRIP001 	case DATACHANGED_FONTSUBSTITUTION:
//STRIP001         pSh->LockPaint();
//STRIP001 		bUnlockPaint = TRUE;
//STRIP001 		GetView().GetDocShell()->UpdateFontList();	//z.B. Druckerwechsel
//STRIP001 		break;
//STRIP001 	}
//STRIP001     pSh->LockView( bViewWasLocked );
//STRIP001 	if( bUnlockPaint )
//STRIP001         pSh->UnlockPaint();
//STRIP001 }


}
