/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_unnum.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:45:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif
// auto strip #ifndef _SVX_LRSPITEM_HXX //autogen
// auto strip #include <bf_svx/lrspitem.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif
// auto strip #ifndef _DOC_HXX
// auto strip #include <doc.hxx>
// auto strip #endif
#ifndef _SWUNDO_HXX
#include <swundo.hxx>			// fuer die UndoIds
#endif
#ifndef _ERRHDL_HXX
#include <errhdl.hxx>
#endif
#ifndef _PAM_HXX
#include <pam.hxx>
#endif
#ifndef _NDTXT_HXX
#include <ndtxt.hxx>
#endif
#ifndef _UNDOBJ_HXX
#include <undobj.hxx>
#endif
// auto strip #ifndef _NUMRULE_HXX
// auto strip #include <numrule.hxx>
// auto strip #endif
#ifndef _ROLBCK_HXX
#include <rolbck.hxx>
#endif
namespace binfilter {


//STRIP001 SV_DECL_PTRARR_DEL( _SfxPoolItems, SfxPoolItem*, 16, 16 )//STRIP008 ;
//STRIP001 SV_IMPL_PTRARR( _SfxPoolItems, SfxPoolItem* );

//STRIP001 inline SwDoc& SwUndoIter::GetDoc() const { return *pAktPam->GetDoc(); }

/*?*/ SwUndoInsNum::SwUndoInsNum( const SwNumRule& rOldRule,
/*?*/ 							const SwNumRule& rNewRule )
/*?*/ 	: SwUndo( UNDO_INSNUM ),
/*?*/ 	aNumRule( rNewRule ), pHistory( 0 ), nLRSavePos( 0 ),
/*?*/ 	nSttSet( ULONG_MAX ), pOldNumRule( new SwNumRule( rOldRule ))
/*?*/ {
/*?*/ 	ASSERT( rOldRule.IsAutoRule(),
/*?*/ 			"darf nur fuer AutoNumRules gerufen werden" );
/*?*/ }

/*N*/ SwUndoInsNum::SwUndoInsNum( const SwPaM& rPam, const SwNumRule& rRule )
/*N*/ 	: SwUndo( UNDO_INSNUM ), SwUndRng( rPam ),
/*N*/ 	aNumRule( rRule ), pHistory( 0 ), nLRSavePos( 0 ),
/*N*/ 	nSttSet( ULONG_MAX ), pOldNumRule( 0 )
/*N*/ {
/*N*/ }

/*?*/ SwUndoInsNum::SwUndoInsNum( const SwPosition& rPos, const SwNumRule& rRule,
/*?*/ 							const String& rReplaceRule )
/*?*/ 	: SwUndo( UNDO_INSNUM ),
/*?*/ 	aNumRule( rRule ), pHistory( 0 ), nLRSavePos( 0 ),
/*?*/ 	nSttSet( ULONG_MAX ), pOldNumRule( 0 ),
/*?*/ 	sReplaceRule( rReplaceRule )
/*?*/ {
/*?*/ 	// keine Selektion !!
/*?*/ 	nEndNode = 0, nEndCntnt = USHRT_MAX;
/*?*/ 	nSttNode = rPos.nNode.GetIndex();
/*?*/ 	nSttCntnt = rPos.nContent.GetIndex();
/*?*/ }

/*N*/ SwUndoInsNum::~SwUndoInsNum()
/*N*/ {
/*N*/ 	delete pHistory;
/*N*/ 	delete pOldNumRule;
/*N*/ }

//STRIP001 void SwUndoInsNum::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 	if( nSttNode )
//STRIP001 		SetPaM( rUndoIter );
//STRIP001 
//STRIP001 	BOOL bUndo = rDoc.DoesUndo();
//STRIP001 	rDoc.DoUndo( FALSE );
//STRIP001 
//STRIP001 	if( pOldNumRule )
//STRIP001 		rDoc.ChgNumRuleFmts( *pOldNumRule );
//STRIP001 
//STRIP001 	if( pHistory )
//STRIP001 	{
//STRIP001 		SwTxtNode* pNd;
//STRIP001 		if( ULONG_MAX != nSttSet &&
//STRIP001 			0 != ( pNd = rDoc.GetNodes()[ nSttSet ]->GetTxtNode() ) &&
//STRIP001 			pNd->GetNum() )
//STRIP001 				((SwNodeNum*)pNd->GetNum())->SetStart( TRUE );
//STRIP001 		else
//STRIP001 			pNd = 0;
//STRIP001 
//STRIP001 
//STRIP001 		if( nLRSavePos )
//STRIP001 		{
//STRIP001 			// sofort Updaten, damit eventuell "alte" LRSpaces wieder
//STRIP001 			// gueltig werden.
//STRIP001 			// !!! Dafuer suche aber erstmal den richtigen NumRule - Namen!
//STRIP001 			if( !pNd && nSttNode )
//STRIP001 				pNd = rDoc.GetNodes()[ nSttNode ]->GetTxtNode();
//STRIP001 
//STRIP001 			const SwNumRule* pNdRule;
//STRIP001 			if( pNd )
//STRIP001 				pNdRule = pNd->GetNumRule();
//STRIP001 			else
//STRIP001 				pNdRule = rDoc.FindNumRulePtr( aNumRule.GetName() );
//STRIP001 
//STRIP001 			pHistory->TmpRollback( &rDoc, nLRSavePos );
//STRIP001 			if( pNdRule )
//STRIP001 				rDoc.UpdateNumRule( pNdRule->GetName(), ULONG_MAX );
//STRIP001 		}
//STRIP001 		pHistory->TmpRollback( &rDoc, 0 );
//STRIP001 		pHistory->SetTmpEnd( pHistory->Count() );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( nSttNode )
//STRIP001 		SetPaM( rUndoIter );
//STRIP001 	rDoc.DoUndo( bUndo );
//STRIP001 }


//STRIP001 void SwUndoInsNum::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 
//STRIP001 	if( pOldNumRule )
//STRIP001 		rDoc.ChgNumRuleFmts( aNumRule );
//STRIP001 	else if( pHistory )
//STRIP001 	{
//STRIP001 		SetPaM( rUndoIter );
//STRIP001 		if( sReplaceRule.Len() )
//STRIP001 			rDoc.ReplaceNumRule( *rUndoIter.pAktPam->GetPoint(),
//STRIP001 								sReplaceRule, aNumRule.GetName() );
//STRIP001 		else
//STRIP001 			rDoc.SetNumRule( *rUndoIter.pAktPam, aNumRule, FALSE );
//STRIP001 	}
//STRIP001 }

//STRIP001 void SwUndoInsNum::SetLRSpaceEndPos()
//STRIP001 {
//STRIP001 	if( pHistory )
//STRIP001 		nLRSavePos = pHistory->Count();
//STRIP001 }

//STRIP001 void SwUndoInsNum::Repeat( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	if( nSttNode )
//STRIP001 	{
//STRIP001 		if( !sReplaceRule.Len() )
//STRIP001 			rUndoIter.GetDoc().SetNumRule( *rUndoIter.pAktPam, aNumRule, FALSE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rUndoIter.GetDoc().ChgNumRuleFmts( aNumRule );
//STRIP001 }

//STRIP001 SwHistory* SwUndoInsNum::GetHistory()
//STRIP001 {
//STRIP001 	if( !pHistory )
//STRIP001 		pHistory = new SwHistory;
//STRIP001 	return pHistory;
//STRIP001 }

//STRIP001 void SwUndoInsNum::SaveOldNumRule( const SwNumRule& rOld )
//STRIP001 {
//STRIP001 	if( !pOldNumRule )
//STRIP001 		pOldNumRule = new SwNumRule( rOld );
//STRIP001 }

/*  */


//STRIP001 SwUndoDelNum::SwUndoDelNum( const SwPaM& rPam )
//STRIP001 	: SwUndo( UNDO_DELNUM ), SwUndRng( rPam ),
//STRIP001 	aNodeIdx( BYTE( nEndNode - nSttNode > 255 ? 255 : nEndNode - nSttNode )),
//STRIP001 	aLevels( BYTE( nEndNode - nSttNode > 255 ? 255 : nEndNode - nSttNode ))
//STRIP001 #ifndef NUM_RELSPACE
//STRIP001 	, aRstLRSpaces( BYTE( nEndNode - nSttNode > 255 ? 255 : nEndNode - nSttNode ))
//STRIP001 #endif
//STRIP001 {
//STRIP001 	pHistory = new SwHistory;
//STRIP001 }


//STRIP001 SwUndoDelNum::~SwUndoDelNum()
//STRIP001 {
//STRIP001 	delete pHistory;
//STRIP001 }


//STRIP001 void SwUndoDelNum::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 	SetPaM( rUndoIter );
//STRIP001 
//STRIP001 	BOOL bUndo = rDoc.DoesUndo();
//STRIP001 	rDoc.DoUndo( FALSE );
//STRIP001 
//STRIP001 	pHistory->TmpRollback( &rDoc, 0 );
//STRIP001 	pHistory->SetTmpEnd( pHistory->Count() );
//STRIP001 
//STRIP001 	for( USHORT n = 0; n < aNodeIdx.Count(); ++n )
//STRIP001 	{
//STRIP001 		SwTxtNode* pNd = rDoc.GetNodes()[ aNodeIdx[ n ] ]->GetTxtNode();
//STRIP001 		ASSERT( pNd, "wo ist der TextNode geblieben?" );
//STRIP001 		pNd->UpdateNum( SwNodeNum( aLevels[ n ] ));
//STRIP001 
//STRIP001 #ifndef NUM_RELSPACE
//STRIP001 		pNd->SetNumLSpace( aRstLRSpaces[ n ] );
//STRIP001 #endif
//STRIP001 
//STRIP001 		if( pNd->GetCondFmtColl() )
//STRIP001 			pNd->ChkCondColl();
//STRIP001 	}
//STRIP001 
//STRIP001 	SetPaM( rUndoIter );
//STRIP001 	rDoc.DoUndo( bUndo );
//STRIP001 }


//STRIP001 void SwUndoDelNum::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SetPaM( rUndoIter );
//STRIP001 	rUndoIter.GetDoc().DelNumRules( *rUndoIter.pAktPam );
//STRIP001 }


//STRIP001 void SwUndoDelNum::Repeat( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SetPaM( rUndoIter );
//STRIP001 	rUndoIter.GetDoc().DelNumRules( *rUndoIter.pAktPam );
//STRIP001 }

//STRIP001 void SwUndoDelNum::AddNode( const SwTxtNode& rNd, BOOL bFlag )
//STRIP001 {
//STRIP001 	if( rNd.GetNum() && NO_NUMBERING != rNd.GetNum()->GetLevel() )
//STRIP001 	{
//STRIP001 		register USHORT nIns = aNodeIdx.Count();
//STRIP001 		aNodeIdx.Insert( rNd.GetIndex(), nIns );
//STRIP001 		aLevels.Insert( rNd.GetNum()->GetLevel(), nIns );
//STRIP001 #ifndef NUM_RELSPACE
//STRIP001 		aRstLRSpaces.Insert( bFlag, nIns );
//STRIP001 #endif
//STRIP001 	}
//STRIP001 }


/*  */


//STRIP001 SwUndoMoveNum::SwUndoMoveNum( const SwPaM& rPam, long nOff, BOOL bIsOutlMv )
//STRIP001 	: SwUndo( bIsOutlMv ? UNDO_OUTLINE_UD : UNDO_MOVENUM ),
//STRIP001 	SwUndRng( rPam ), nOffset( nOff ),
//STRIP001 	nNewStt( 0 )
//STRIP001 {
//STRIP001 	// nOffset: nach unten 	=>  1
//STRIP001 	//			nach oben	=> -1
//STRIP001 }


//STRIP001 void SwUndoMoveNum::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	ULONG nTmpStt = nSttNode, nTmpEnd = nEndNode;
//STRIP001 
//STRIP001 	if( nEndNode || USHRT_MAX != nEndCntnt )		// Bereich ?
//STRIP001 	{
//STRIP001 		if( nNewStt < nSttNode )		// nach vorne verschoben
//STRIP001 			nEndNode = nEndNode - ( nSttNode - nNewStt );
//STRIP001 		else
//STRIP001 			nEndNode = nEndNode + ( nNewStt - nSttNode );
//STRIP001 	}
//STRIP001 	nSttNode = nNewStt;
//STRIP001 
//STRIP001 //JP 22.06.95: wird wollen die Bookmarks/Verzeichnisse behalten, oder?
//STRIP001 //	SetPaM( rUndoIter );
//STRIP001 //	RemoveIdxFromRange( *rUndoIter.pAktPam, TRUE );
//STRIP001 
//STRIP001 	SetPaM( rUndoIter );
//STRIP001 	rUndoIter.GetDoc().MoveParagraph( *rUndoIter.pAktPam, -nOffset,
//STRIP001 										UNDO_OUTLINE_UD == GetId() );
//STRIP001 	nSttNode = nTmpStt;
//STRIP001 	nEndNode = nTmpEnd;
//STRIP001 }


//STRIP001 void SwUndoMoveNum::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 //JP 22.06.95: wird wollen die Bookmarks/Verzeichnisse behalten, oder?
//STRIP001 //	SetPaM( rUndoIter );
//STRIP001 //	RemoveIdxFromRange( *rUndoIter.pAktPam, TRUE );
//STRIP001 
//STRIP001 	SetPaM( rUndoIter );
//STRIP001 	rUndoIter.GetDoc().MoveParagraph( *rUndoIter.pAktPam, nOffset,
//STRIP001 										UNDO_OUTLINE_UD == GetId() );
//STRIP001 }


//STRIP001 void SwUndoMoveNum::Repeat( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	if( UNDO_OUTLINE_UD == GetId() )
//STRIP001 		rUndoIter.GetDoc().MoveOutlinePara( *rUndoIter.pAktPam,
//STRIP001 											0 < nOffset ? 1 : -1 );
//STRIP001 	else
//STRIP001 		rUndoIter.GetDoc().MoveParagraph( *rUndoIter.pAktPam, nOffset, FALSE );
//STRIP001 }

/*  */


/*N*/ SwUndoNumUpDown::SwUndoNumUpDown( const SwPaM& rPam, short nOff )
/*N*/ 	: SwUndo( UNDO_NUMUPDOWN ), SwUndRng( rPam ), nOffset( nOff )
/*N*/ {
/*N*/ 	// nOffset: Down 	=>  1
/*N*/ 	//			Up 		=> -1
/*N*/ }


//STRIP001 void SwUndoNumUpDown::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SetPaM( rUndoIter );
//STRIP001 	rUndoIter.GetDoc().NumUpDown( *rUndoIter.pAktPam, 1 != nOffset );
//STRIP001 }


//STRIP001 void SwUndoNumUpDown::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SetPaM( rUndoIter );
//STRIP001 	rUndoIter.GetDoc().NumUpDown( *rUndoIter.pAktPam, 1 == nOffset );
//STRIP001 }


//STRIP001 void SwUndoNumUpDown::Repeat( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	rUndoIter.GetDoc().NumUpDown( *rUndoIter.pAktPam, 1 == nOffset );
//STRIP001 }

/*  */


//STRIP001 SwUndoNumOrNoNum::SwUndoNumOrNoNum( const SwNodeIndex& rIdx, BOOL bDelete,
//STRIP001 									BOOL bOutln )
//STRIP001 	: SwUndo( UNDO_NUMORNONUM ), nIdx( rIdx.GetIndex() ), bDel( bDelete ),
//STRIP001 	bOutline( bOutln )
//STRIP001 {
//STRIP001 }


//STRIP001 void SwUndoNumOrNoNum::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwNodeIndex aIdx( rUndoIter.GetDoc().GetNodes(), nIdx );
//STRIP001 	rUndoIter.GetDoc().NumOrNoNum( aIdx, !bDel, bOutline );
//STRIP001 }


//STRIP001 void SwUndoNumOrNoNum::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 	SwNodeIndex aIdx( rDoc.GetNodes(), nIdx );
//STRIP001 	rDoc.NumOrNoNum( aIdx, bDel, bOutline );
//STRIP001 }


//STRIP001 void SwUndoNumOrNoNum::Repeat( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	rUndoIter.GetDoc().NumOrNoNum( rUndoIter.pAktPam->GetPoint()->nNode,
//STRIP001 									bDel, bOutline );
//STRIP001 }

/*  */

/*?*/ SwUndoNumRuleStart::SwUndoNumRuleStart( const SwPosition& rPos, BOOL bFlg )
/*?*/ 	: SwUndo( UNDO_SETNUMRULESTART ),
/*?*/ 	nIdx( rPos.nNode.GetIndex() ), bFlag( bFlg ), bSetSttValue( FALSE ),
/*?*/ 	nNewStt( USHRT_MAX ), nOldStt( USHRT_MAX )
/*?*/ {
/*?*/ }

/*N*/ SwUndoNumRuleStart::SwUndoNumRuleStart( const SwPosition& rPos, USHORT nStt )
/*N*/ 	: SwUndo( UNDO_SETNUMRULESTART ),
/*N*/ 	nIdx( rPos.nNode.GetIndex() ), bSetSttValue( TRUE ),
/*N*/ 	nNewStt( nStt ), nOldStt( USHRT_MAX )
/*N*/ {
/*N*/ 	SwTxtNode* pTxtNd = rPos.nNode.GetNode().GetTxtNode();
/*N*/ 	if( pTxtNd && pTxtNd->GetNum() )
/*N*/ 		nOldStt = pTxtNd->GetNum()->GetSetValue();
/*N*/ }


//STRIP001 void SwUndoNumRuleStart::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwPosition aPos( *rUndoIter.GetDoc().GetNodes()[ nIdx ] );
//STRIP001 	if( bSetSttValue )
//STRIP001 		rUndoIter.GetDoc().SetNodeNumStart( aPos, nOldStt );
//STRIP001 	else
//STRIP001 		rUndoIter.GetDoc().SetNumRuleStart( aPos, !bFlag );
//STRIP001 }


//STRIP001 void SwUndoNumRuleStart::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 
//STRIP001 	SwPosition aPos( *rDoc.GetNodes()[ nIdx ] );
//STRIP001 	if( bSetSttValue )
//STRIP001 		rDoc.SetNodeNumStart( aPos, nNewStt );
//STRIP001 	else
//STRIP001 		rDoc.SetNumRuleStart( aPos, bFlag );
//STRIP001 }


//STRIP001 void SwUndoNumRuleStart::Repeat( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	if( bSetSttValue )
//STRIP001 		rUndoIter.GetDoc().SetNodeNumStart( *rUndoIter.pAktPam->GetPoint(), nNewStt );
//STRIP001 	else
//STRIP001 		rUndoIter.GetDoc().SetNumRuleStart( *rUndoIter.pAktPam->GetPoint(), bFlag );
//STRIP001 }


}
