/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_xattr2.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 07:39:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#pragma hdrstop

#ifndef _COM_SUN_STAR_DRAWING_LINEJOINT_HPP_
#include <com/sun/star/drawing/LineJoint.hpp>
#endif
// auto strip #ifndef _COM_SUN_STAR_UNO_ANY_HXX_
// auto strip #include <com/sun/star/uno/Any.hxx>
// auto strip #endif

#include "dialogs.hrc"

#ifndef _XDEF_HXX
#include <bf_svx/xdef.hxx>
#endif

#include "xattr.hxx"
// auto strip #include "xtable.hxx"
// auto strip #include "xoutx.hxx"
// auto strip #include "dialmgr.hxx"
// auto strip #include "itemtype.hxx"
// auto strip #include "xdef.hxx"
namespace binfilter {

#define GLOBALOVERFLOW

/************************************************************************/

//------------------------------
// class XLineTransparenceItem
//------------------------------
/*N*/ TYPEINIT1_AUTOFACTORY(XLineTransparenceItem, SfxUInt16Item);

/*************************************************************************
|*
|*	  XLineTransparenceItem::XLineTransparenceItem(USHORT)
|*
|*	  Beschreibung
|*	  Ersterstellung	07.11.95 KA
|*	  Letzte Aenderung	07.11.95 KA
|*
*************************************************************************/

/*N*/ XLineTransparenceItem::XLineTransparenceItem(USHORT nLineTransparence) :
/*N*/ 	SfxUInt16Item(XATTR_LINETRANSPARENCE, nLineTransparence)
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|*	  XLineTransparenceItem::XLineTransparenceItem(SvStream& rIn)
|*
|*	  Beschreibung
|*	  Ersterstellung	07.11.95 KA
|*	  Letzte Aenderung	07.11.95 KA
|*
*************************************************************************/

/*N*/ XLineTransparenceItem::XLineTransparenceItem(SvStream& rIn) :
/*N*/ 	SfxUInt16Item(XATTR_LINETRANSPARENCE, rIn)
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|*	  XLineTransparenceItem::Clone(SfxItemPool* pPool) const
|*
|*	  Beschreibung
|*	  Ersterstellung	07.11.95 KA
|*	  Letzte Aenderung	07.11.95 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XLineTransparenceItem::Clone(SfxItemPool* pPool) const
/*N*/ {
/*N*/ 	return new XLineTransparenceItem(*this);
/*N*/ }

/*************************************************************************
|*
|*	  SfxPoolItem* XLineTransparenceItem::Create(SvStream& rIn, USHORT nVer) const
|*
|*	  Beschreibung
|*	  Ersterstellung	07.11.95 KA
|*	  Letzte Aenderung	07.11.95 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XLineTransparenceItem::Create(SvStream& rIn, USHORT nVer) const
/*N*/ {
/*N*/ 	return new XLineTransparenceItem(rIn);
/*N*/ }

//------------------------------------------------------------------------

//STRIP001 SfxItemPresentation XLineTransparenceItem::GetPresentation
//STRIP001 (
//STRIP001 	SfxItemPresentation ePres,
//STRIP001 	SfxMapUnit			eCoreUnit,
//STRIP001 	SfxMapUnit			ePresUnit,
//STRIP001     XubString&          rText, const IntlWrapper *
//STRIP001 )	const
//STRIP001 {
//STRIP001 	rText.Erase();
//STRIP001 
//STRIP001 	switch ( ePres )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_PRESENTATION_NONE:
//STRIP001 			return ePres;
//STRIP001 		case SFX_ITEM_PRESENTATION_COMPLETE:
//STRIP001 			rText = XubString( ResId( RID_SVXSTR_TRANSPARENCE, DIALOG_MGR() ) );
//STRIP001 			rText.AppendAscii(": ");
//STRIP001 		case SFX_ITEM_PRESENTATION_NAMELESS:
//STRIP001 			rText += XubString( UniString::CreateFromInt32((USHORT) GetValue()) );
//STRIP001 			rText += sal_Unicode('%');
//STRIP001 			return ePres;
//STRIP001 	}
//STRIP001 	return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 }

//-----------------------
// class XLineJointItem	-
//-----------------------

/*N*/ TYPEINIT1_AUTOFACTORY(XLineJointItem, SfxEnumItem);

// -----------------------------------------------------------------------------

/*N*/ XLineJointItem::XLineJointItem( XLineJoint eLineJoint ) :
/*N*/ 	SfxEnumItem(XATTR_LINEJOINT, eLineJoint)
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------------

/*N*/ XLineJointItem::XLineJointItem( SvStream& rIn ) :
/*N*/ 	SfxEnumItem( XATTR_LINEJOINT, rIn )
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------------

/*N*/ USHORT XLineJointItem::GetVersion( USHORT nFileFormatVersion ) const
/*N*/ {
/*N*/ 	return 1;
/*N*/ }

// -----------------------------------------------------------------------------

/*N*/ SfxPoolItem* XLineJointItem::Create( SvStream& rIn, USHORT nVer ) const
/*N*/ {
/*N*/ 	XLineJointItem* pRet = new XLineJointItem( rIn );
/*N*/ 
/*N*/ 	if(nVer < 1)
/*?*/ 		pRet->SetValue(XLINEJOINT_ROUND);
/*N*/ 
/*N*/ 	return pRet;
/*N*/ }

// -----------------------------------------------------------------------------

/*N*/ SfxPoolItem* XLineJointItem::Clone(SfxItemPool* pPool) const
/*N*/ {
/*N*/ 	return new XLineJointItem( *this );
/*N*/ }

// -----------------------------------------------------------------------------

//STRIP001 SfxItemPresentation XLineJointItem::GetPresentation( SfxItemPresentation ePres,	SfxMapUnit eCoreUnit,
//STRIP001                                                      SfxMapUnit ePresUnit, XubString& rText, const IntlWrapper*) const
//STRIP001 {
//STRIP001 	rText.Erase();
//STRIP001 
//STRIP001 	switch( ePres )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_PRESENTATION_NONE: return ePres;
//STRIP001 
//STRIP001 		case SFX_ITEM_PRESENTATION_COMPLETE:
//STRIP001 		case SFX_ITEM_PRESENTATION_NAMELESS:
//STRIP001 		{
//STRIP001 			USHORT nId = 0;
//STRIP001 
//STRIP001 			switch( GetValue() )
//STRIP001 			{
//STRIP001 				case( XLINEJOINT_NONE ):
//STRIP001 					nId = RID_SVXSTR_LINEJOINT_NONE;
//STRIP001 				break;
//STRIP001 
//STRIP001 				case( XLINEJOINT_MIDDLE ):
//STRIP001 					nId = RID_SVXSTR_LINEJOINT_MIDDLE;
//STRIP001 				break;
//STRIP001 
//STRIP001 
//STRIP001 				case( XLINEJOINT_BEVEL ):
//STRIP001 					nId = RID_SVXSTR_LINEJOINT_BEVEL;
//STRIP001 				break;
//STRIP001 
//STRIP001 
//STRIP001 				case( XLINEJOINT_MITER ):
//STRIP001 					nId = RID_SVXSTR_LINEJOINT_MITER;
//STRIP001 				break;
//STRIP001 
//STRIP001 
//STRIP001 				case( XLINEJOINT_ROUND ):
//STRIP001 					nId = RID_SVXSTR_LINEJOINT_ROUND;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 
//STRIP001 			if( nId )
//STRIP001 				rText = SVX_RESSTR( nId );
//STRIP001 
//STRIP001 			return ePres;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 }

// -----------------------------------------------------------------------------

/*N*/ sal_Bool XLineJointItem::QueryValue( ::com::sun::star::uno::Any& rVal, BYTE nMemberId ) const
/*N*/ {
/*N*/ 	::com::sun::star::drawing::LineJoint eJoint = ::com::sun::star::drawing::LineJoint_NONE;
/*N*/ 
/*N*/ 	switch( GetValue() )
/*N*/ 	{
/*N*/ 	case XLINEJOINT_NONE:
/*N*/ 		break;
/*N*/ 	case XLINEJOINT_MIDDLE:
/*N*/ 		eJoint = ::com::sun::star::drawing::LineJoint_MIDDLE;
/*N*/ 		break;
/*N*/ 	case XLINEJOINT_BEVEL:
/*N*/ 		eJoint = ::com::sun::star::drawing::LineJoint_BEVEL;
/*N*/ 		break;
/*N*/ 	case XLINEJOINT_MITER:
/*N*/ 		eJoint = ::com::sun::star::drawing::LineJoint_MITER;
/*N*/ 		break;
/*N*/ 	case XLINEJOINT_ROUND:
/*N*/ 		eJoint = ::com::sun::star::drawing::LineJoint_ROUND;
/*N*/ 		break;
/*N*/ 	default:
/*N*/ 		DBG_ERROR( "Unknown LineJoint enum value!" );
/*N*/ 	}
/*N*/ 
/*N*/ 	rVal <<= eJoint;
/*N*/ 	return sal_True;
/*N*/ }

// -----------------------------------------------------------------------------

/*N*/ BOOL XLineJointItem::PutValue( const ::com::sun::star::uno::Any& rVal, BYTE nMemberId )
/*N*/ {
/*N*/ 	XLineJoint eJoint = XLINEJOINT_NONE;
/*N*/ 	::com::sun::star::drawing::LineJoint eUnoJoint;
/*N*/ 
/*N*/ 	if(!(rVal >>= eUnoJoint))
/*N*/     {
/*?*/         // also try an int (for Basic)
/*?*/         sal_Int32 nLJ;
/*?*/         if(!(rVal >>= nLJ))
/*?*/             return sal_False;
/*?*/         eUnoJoint = (::com::sun::star::drawing::LineJoint)nLJ;
/*N*/     }

/*N*/ 	switch( eUnoJoint )
/*N*/ 	{
/*N*/ 	case ::com::sun::star::drawing::LineJoint_NONE:
/*N*/ 		break;
/*N*/ 	case ::com::sun::star::drawing::LineJoint_MIDDLE:
/*N*/ 		eJoint = XLINEJOINT_MIDDLE;
/*N*/ 		break;
/*N*/ 	case ::com::sun::star::drawing::LineJoint_BEVEL:
/*N*/ 		eJoint = XLINEJOINT_BEVEL;
/*N*/ 		break;
/*N*/ 	case ::com::sun::star::drawing::LineJoint_MITER:
/*N*/ 		eJoint = XLINEJOINT_MITER;
/*N*/ 		break;
/*N*/ 	case ::com::sun::star::drawing::LineJoint_ROUND:
/*N*/ 		eJoint = XLINEJOINT_ROUND;
/*N*/ 		break;
/*N*/ 	}
/*N*/ 
/*N*/ 	SetValue( eJoint );
/*N*/ 
/*N*/ 	return sal_True;
/*N*/ }

// -----------------------------------------------------------------------------

/*N*/ USHORT XLineJointItem::GetValueCount() const
/*N*/ {
/*N*/ 	// don't forget to update the api interface also
/*N*/ 	return 5;
/*N*/ }

//------------------------------
// class XFillTransparenceItem
//------------------------------
/*N*/ TYPEINIT1_AUTOFACTORY(XFillTransparenceItem, SfxUInt16Item);

/*************************************************************************
|*
|*	  XFillTransparenceItem::XFillTransparenceItem(USHORT)
|*
|*	  Beschreibung
|*	  Ersterstellung	07.11.95 KA
|*	  Letzte Aenderung	07.11.95 KA
|*
*************************************************************************/

/*N*/ XFillTransparenceItem::XFillTransparenceItem(USHORT nFillTransparence) :
/*N*/ 	SfxUInt16Item(XATTR_FILLTRANSPARENCE, nFillTransparence)
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|*	  XFillTransparenceItem::XFillTransparenceItem(SvStream& rIn)
|*
|*	  Beschreibung
|*	  Ersterstellung	07.11.95 KA
|*	  Letzte Aenderung	07.11.95 KA
|*
*************************************************************************/

/*N*/ XFillTransparenceItem::XFillTransparenceItem(SvStream& rIn) :
/*N*/ 	SfxUInt16Item(XATTR_FILLTRANSPARENCE, rIn)
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|*	  XFillTransparenceItem::Clone(SfxItemPool* pPool) const
|*
|*	  Beschreibung
|*	  Ersterstellung	07.11.95 KA
|*	  Letzte Aenderung	07.11.95 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillTransparenceItem::Clone(SfxItemPool* pPool) const
/*N*/ {
/*N*/ 	return new XFillTransparenceItem(*this);
/*N*/ }

/*************************************************************************
|*
|*	  SfxPoolItem* XFillTransparenceItem::Create(SvStream& rIn, USHORT nVer) const
|*
|*	  Beschreibung
|*	  Ersterstellung	07.11.95 KA
|*	  Letzte Aenderung	07.11.95 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillTransparenceItem::Create(SvStream& rIn, USHORT nVer) const
/*N*/ {
/*N*/ 	return new XFillTransparenceItem(rIn);
/*N*/ }

//------------------------------------------------------------------------

//STRIP001 SfxItemPresentation XFillTransparenceItem::GetPresentation
//STRIP001 (
//STRIP001 	SfxItemPresentation ePres,
//STRIP001 	SfxMapUnit			eCoreUnit,
//STRIP001 	SfxMapUnit			ePresUnit,
//STRIP001     XubString&          rText, const IntlWrapper *
//STRIP001 )	const
//STRIP001 {
//STRIP001 	rText.Erase();
//STRIP001 
//STRIP001 	switch ( ePres )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_PRESENTATION_NONE:
//STRIP001 			return ePres;
//STRIP001 		case SFX_ITEM_PRESENTATION_COMPLETE:
//STRIP001 			rText = XubString( ResId( RID_SVXSTR_TRANSPARENCE, DIALOG_MGR() ) );
//STRIP001 			rText.AppendAscii(": ");
//STRIP001 		case SFX_ITEM_PRESENTATION_NAMELESS:
//STRIP001 			rText += XubString( UniString::CreateFromInt32((USHORT) GetValue() ));
//STRIP001 			rText += sal_Unicode('%');
//STRIP001 			return ePres;
//STRIP001 	}
//STRIP001 	return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 }

//------------------------------
// class XFormTextShadowTranspItem
//------------------------------
/*N*/ TYPEINIT1_AUTOFACTORY(XFormTextShadowTranspItem, SfxUInt16Item);

/*************************************************************************
|*
|*	  XFormTextShadowTranspItem::XFormTextShadowTranspItem(USHORT)
|*
|*	  Beschreibung
|*	  Ersterstellung	09.11.95 KA
|*	  Letzte Aenderung	09.11.95 KA
|*
*************************************************************************/

/*N*/ XFormTextShadowTranspItem::XFormTextShadowTranspItem(USHORT nShdwTransparence) :
/*N*/ 	SfxUInt16Item(XATTR_FORMTXTSHDWTRANSP, nShdwTransparence)
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|*	  XFormTextShadowTranspItem::XFormTextShadowTranspItem(SvStream& rIn)
|*
|*	  Beschreibung
|*	  Ersterstellung	09.11.95 KA
|*	  Letzte Aenderung	09.11.95 KA
|*
*************************************************************************/

/*N*/ XFormTextShadowTranspItem::XFormTextShadowTranspItem(SvStream& rIn) :
/*N*/ 	SfxUInt16Item(XATTR_FORMTXTSHDWTRANSP, rIn)
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|*	  XFormTextShadowTranspItem::Clone(SfxItemPool* pPool) const
|*
|*	  Beschreibung
|*	  Ersterstellung	09.11.95 KA
|*	  Letzte Aenderung	09.11.95 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFormTextShadowTranspItem::Clone(SfxItemPool* pPool) const
/*N*/ {
/*N*/ 	return new XFormTextShadowTranspItem(*this);
/*N*/ }

/*************************************************************************
|*
|*	  SfxPoolItem* XFormTextShadowTranspItem::Create(SvStream& rIn, USHORT nVer) const
|*
|*	  Beschreibung
|*	  Ersterstellung	09.11.95 KA
|*	  Letzte Aenderung	09.11.95 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFormTextShadowTranspItem::Create(SvStream& rIn, USHORT nVer) const
/*N*/ {
/*N*/ 	return new XFormTextShadowTranspItem(rIn);
/*N*/ }


//------------------------------
// class XFillGradientStepCountItem
//------------------------------
/*N*/ TYPEINIT1_AUTOFACTORY(XGradientStepCountItem, SfxUInt16Item);

/*************************************************************************
|*
|*	  XGradientStepCountItem::XGradientStepCountItem( USHORT )
|*
|*	  Beschreibung
|*	  Ersterstellung	23.01.96 KA
|*	  Letzte Aenderung	23.01.96 KA
|*
*************************************************************************/

/*N*/ XGradientStepCountItem::XGradientStepCountItem( USHORT nStepCount ) :
/*N*/ 	SfxUInt16Item( XATTR_GRADIENTSTEPCOUNT, nStepCount )
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|*	  XGradientStepCountItem::XGradientStepCountItem( SvStream& rIn )
|*
|*	  Beschreibung
|*	  Ersterstellung	23.01.96 KA
|*	  Letzte Aenderung	23.01.96 KA
|*
*************************************************************************/

/*N*/ XGradientStepCountItem::XGradientStepCountItem( SvStream& rIn ) :
/*N*/ 	SfxUInt16Item( XATTR_GRADIENTSTEPCOUNT, rIn )
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|*	  XGradientStepCountItem::Clone( SfxItemPool* pPool ) const
|*
|*	  Beschreibung
|*	  Ersterstellung	23.01.96 KA
|*	  Letzte Aenderung	23.01.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XGradientStepCountItem::Clone( SfxItemPool* pPool ) const
/*N*/ {
/*N*/ 	return new XGradientStepCountItem( *this );
/*N*/ }

/*************************************************************************
|*
|*	  SfxPoolItem* XGradientStepCountItem::Create(SvStream& rIn, USHORT nVer) const
|*
|*	  Beschreibung
|*	  Ersterstellung	23.01.96 KA
|*	  Letzte Aenderung	23.01.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XGradientStepCountItem::Create(SvStream& rIn, USHORT nVer) const
/*N*/ {
/*N*/ 	return new XGradientStepCountItem( rIn );
/*N*/ }

//------------------------------------------------------------------------

//STRIP001 SfxItemPresentation XGradientStepCountItem::GetPresentation
//STRIP001 (
//STRIP001 	SfxItemPresentation ePres,
//STRIP001 	SfxMapUnit			eCoreUnit,
//STRIP001 	SfxMapUnit			ePresUnit,
//STRIP001     XubString&          rText, const IntlWrapper *
//STRIP001 )	const
//STRIP001 {
//STRIP001 	rText.Erase();
//STRIP001 
//STRIP001 	switch ( ePres )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_PRESENTATION_NONE:
//STRIP001 			return ePres;
//STRIP001 		case SFX_ITEM_PRESENTATION_COMPLETE:
//STRIP001 //			rText = XubString( ResId( RID_SVXSTR_GRADIENTSTEPCOUNT, DIALOG_MGR() ) );
//STRIP001 //			rText += ": ";
//STRIP001 		case SFX_ITEM_PRESENTATION_NAMELESS:
//STRIP001 			rText += XubString( UniString::CreateFromInt32((USHORT) GetValue() ));
//STRIP001 			return ePres;
//STRIP001 	}
//STRIP001 	return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 }


//------------------------------
// class XFillBmpTileItem
//------------------------------
/*N*/ TYPEINIT1_AUTOFACTORY( XFillBmpTileItem, SfxBoolItem );

/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ XFillBmpTileItem::XFillBmpTileItem( BOOL bTile ) :
/*N*/ 			SfxBoolItem( XATTR_FILLBMP_TILE, bTile )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ XFillBmpTileItem::XFillBmpTileItem( SvStream& rIn ) :
/*N*/ 			SfxBoolItem( XATTR_FILLBMP_TILE, rIn )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpTileItem::Clone( SfxItemPool* pPool ) const
/*N*/ {
/*N*/ 	return new XFillBmpTileItem( *this );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpTileItem::Create( SvStream& rIn, USHORT nVer ) const
/*N*/ {
/*N*/ 	return new XFillBmpTileItem( rIn );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

//STRIP001 SfxItemPresentation XFillBmpTileItem::GetPresentation
//STRIP001 (
//STRIP001 	SfxItemPresentation ePres,
//STRIP001 	SfxMapUnit			eCoreUnit,
//STRIP001 	SfxMapUnit			ePresUnit,
//STRIP001     XubString&          rText, const IntlWrapper *
//STRIP001 )	const
//STRIP001 {
//STRIP001 	rText.Erase();
//STRIP001 
//STRIP001 	switch ( ePres )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_PRESENTATION_NONE:
//STRIP001 			return ePres;
//STRIP001 		case SFX_ITEM_PRESENTATION_COMPLETE:
//STRIP001 		case SFX_ITEM_PRESENTATION_NAMELESS:
//STRIP001 			return ePres;
//STRIP001 	}
//STRIP001 
//STRIP001 	return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 }


//------------------------------
// class XFillBmpTilePosItem
//------------------------------
/*N*/ TYPEINIT1_AUTOFACTORY( XFillBmpPosItem, SfxEnumItem );

/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ XFillBmpPosItem::XFillBmpPosItem( RECT_POINT eRP ) :
/*N*/ 			SfxEnumItem( XATTR_FILLBMP_POS, eRP )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ XFillBmpPosItem::XFillBmpPosItem( SvStream& rIn ) :
/*N*/ 			SfxEnumItem( XATTR_FILLBMP_POS, rIn )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpPosItem::Clone( SfxItemPool* pPool ) const
/*N*/ {
/*N*/ 	return new XFillBmpPosItem( *this );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpPosItem::Create( SvStream& rIn, USHORT nVer ) const
/*N*/ {
/*N*/ 	return new XFillBmpPosItem( rIn );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

//STRIP001 SfxItemPresentation XFillBmpPosItem::GetPresentation
//STRIP001 (
//STRIP001 	SfxItemPresentation ePres,
//STRIP001 	SfxMapUnit			eCoreUnit,
//STRIP001 	SfxMapUnit			ePresUnit,
//STRIP001     XubString&          rText, const IntlWrapper *
//STRIP001 )	const
//STRIP001 {
//STRIP001 	rText.Erase();
//STRIP001 
//STRIP001 	switch ( ePres )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_PRESENTATION_NONE:
//STRIP001 			return ePres;
//STRIP001 		case SFX_ITEM_PRESENTATION_COMPLETE:
//STRIP001 		case SFX_ITEM_PRESENTATION_NAMELESS:
//STRIP001 			return ePres;
//STRIP001 	}
//STRIP001 
//STRIP001 	return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 }

/******************************************************************************
|*
|*
|*
\******************************************************************************/

/*N*/ USHORT XFillBmpPosItem::GetValueCount() const
/*N*/ {
/*N*/ 	return 9;
/*N*/ }


//------------------------------
// class XFillBmpTileSizeXItem
//------------------------------
/*N*/ TYPEINIT1_AUTOFACTORY( XFillBmpSizeXItem, SfxMetricItem );

/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ XFillBmpSizeXItem::XFillBmpSizeXItem( long nSizeX ) :
/*N*/ 			SfxMetricItem( XATTR_FILLBMP_SIZEX, nSizeX )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ XFillBmpSizeXItem::XFillBmpSizeXItem( SvStream& rIn ) :
/*N*/ 			SfxMetricItem( XATTR_FILLBMP_SIZEX, rIn )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpSizeXItem::Clone( SfxItemPool* pPool ) const
/*N*/ {
/*N*/ 	return new XFillBmpSizeXItem( *this );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpSizeXItem::Create( SvStream& rIn, USHORT nVer ) const
/*N*/ {
/*N*/ 	return new XFillBmpSizeXItem( rIn );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

//STRIP001 SfxItemPresentation XFillBmpSizeXItem::GetPresentation
//STRIP001 (
//STRIP001 	SfxItemPresentation ePres,
//STRIP001 	SfxMapUnit			eCoreUnit,
//STRIP001 	SfxMapUnit			ePresUnit,
//STRIP001     XubString&          rText, const IntlWrapper *
//STRIP001 )	const
//STRIP001 {
//STRIP001 	rText.Erase();
//STRIP001 
//STRIP001 	switch ( ePres )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_PRESENTATION_NONE:
//STRIP001 			return ePres;
//STRIP001 		case SFX_ITEM_PRESENTATION_COMPLETE:
//STRIP001 		case SFX_ITEM_PRESENTATION_NAMELESS:
//STRIP001 			return ePres;
//STRIP001 	}
//STRIP001 
//STRIP001 	return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 }


/*************************************************************************
|*
|*	  Beschreibung
|*	  Ersterstellung	05.11.96 KA
|*	  Letzte Aenderung	05.11.96 KA
|*
\*************************************************************************/

//STRIP001 FASTBOOL XFillBmpSizeXItem::HasMetrics() const
//STRIP001 {
//STRIP001 	return GetValue() > 0L;
//STRIP001 }


//------------------------------
// class XFillBmpTileSizeYItem
//------------------------------
/*N*/ TYPEINIT1_AUTOFACTORY( XFillBmpSizeYItem, SfxMetricItem );

/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ XFillBmpSizeYItem::XFillBmpSizeYItem( long nSizeY ) :
/*N*/ 			SfxMetricItem( XATTR_FILLBMP_SIZEY, nSizeY )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ XFillBmpSizeYItem::XFillBmpSizeYItem( SvStream& rIn ) :
/*N*/ 			SfxMetricItem( XATTR_FILLBMP_SIZEY, rIn )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpSizeYItem::Clone( SfxItemPool* pPool ) const
/*N*/ {
/*N*/ 	return new XFillBmpSizeYItem( *this );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpSizeYItem::Create( SvStream& rIn, USHORT nVer ) const
/*N*/ {
/*N*/ 	return new XFillBmpSizeYItem( rIn );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

//STRIP001 SfxItemPresentation XFillBmpSizeYItem::GetPresentation
//STRIP001 (
//STRIP001 	SfxItemPresentation ePres,
//STRIP001 	SfxMapUnit			eCoreUnit,
//STRIP001 	SfxMapUnit			ePresUnit,
//STRIP001     XubString&          rText, const IntlWrapper *
//STRIP001 )	const
//STRIP001 {
//STRIP001 	rText.Erase();
//STRIP001 
//STRIP001 	switch ( ePres )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_PRESENTATION_NONE:
//STRIP001 			return ePres;
//STRIP001 		case SFX_ITEM_PRESENTATION_COMPLETE:
//STRIP001 		case SFX_ITEM_PRESENTATION_NAMELESS:
//STRIP001 			return ePres;
//STRIP001 	}
//STRIP001 
//STRIP001 	return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 }


/*************************************************************************
|*
|*	  Beschreibung
|*	  Ersterstellung	05.11.96 KA
|*	  Letzte Aenderung	05.11.96 KA
|*
\*************************************************************************/

//STRIP001 FASTBOOL XFillBmpSizeYItem::HasMetrics() const
//STRIP001 {
//STRIP001 	return GetValue() > 0L;
//STRIP001 }


//------------------------------
// class XFillBmpTileLogItem
//------------------------------
/*N*/ TYPEINIT1_AUTOFACTORY( XFillBmpSizeLogItem, SfxBoolItem );

/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ XFillBmpSizeLogItem::XFillBmpSizeLogItem( BOOL bLog ) :
/*N*/ 			SfxBoolItem( XATTR_FILLBMP_SIZELOG, bLog )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ XFillBmpSizeLogItem::XFillBmpSizeLogItem( SvStream& rIn ) :
/*N*/ 			SfxBoolItem( XATTR_FILLBMP_SIZELOG, rIn )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpSizeLogItem::Clone( SfxItemPool* pPool ) const
/*N*/ {
/*N*/ 	return new XFillBmpSizeLogItem( *this );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpSizeLogItem::Create( SvStream& rIn, USHORT nVer ) const
/*N*/ {
/*N*/ 	return new XFillBmpSizeLogItem( rIn );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

//STRIP001 SfxItemPresentation XFillBmpSizeLogItem::GetPresentation
//STRIP001 (
//STRIP001 	SfxItemPresentation ePres,
//STRIP001 	SfxMapUnit			eCoreUnit,
//STRIP001 	SfxMapUnit			ePresUnit,
//STRIP001     XubString&          rText, const IntlWrapper *
//STRIP001 )	const
//STRIP001 {
//STRIP001 	rText.Erase();
//STRIP001 
//STRIP001 	switch ( ePres )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_PRESENTATION_NONE:
//STRIP001 			return ePres;
//STRIP001 		case SFX_ITEM_PRESENTATION_COMPLETE:
//STRIP001 		case SFX_ITEM_PRESENTATION_NAMELESS:
//STRIP001 			return ePres;
//STRIP001 	}
//STRIP001 
//STRIP001 	return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 }


//------------------------------
// class XFillBmpTileOffXItem
//------------------------------
/*N*/ TYPEINIT1_AUTOFACTORY( XFillBmpTileOffsetXItem, SfxUInt16Item );

/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ XFillBmpTileOffsetXItem::XFillBmpTileOffsetXItem( USHORT nOffX ) :
/*N*/ 			SfxUInt16Item( XATTR_FILLBMP_TILEOFFSETX, nOffX )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ XFillBmpTileOffsetXItem::XFillBmpTileOffsetXItem( SvStream& rIn ) :
/*N*/ 			SfxUInt16Item( XATTR_FILLBMP_TILEOFFSETX, rIn )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpTileOffsetXItem::Clone( SfxItemPool* pPool ) const
/*N*/ {
/*N*/ 	return new XFillBmpTileOffsetXItem( *this );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpTileOffsetXItem::Create( SvStream& rIn, USHORT nVer ) const
/*N*/ {
/*N*/ 	return new XFillBmpTileOffsetXItem( rIn );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

//STRIP001 SfxItemPresentation XFillBmpTileOffsetXItem::GetPresentation
//STRIP001 (
//STRIP001 	SfxItemPresentation ePres,
//STRIP001 	SfxMapUnit			eCoreUnit,
//STRIP001 	SfxMapUnit			ePresUnit,
//STRIP001     XubString&          rText, const IntlWrapper *
//STRIP001 )	const
//STRIP001 {
//STRIP001 	rText.Erase();
//STRIP001 
//STRIP001 	switch ( ePres )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_PRESENTATION_NONE:
//STRIP001 			return ePres;
//STRIP001 		case SFX_ITEM_PRESENTATION_COMPLETE:
//STRIP001 		case SFX_ITEM_PRESENTATION_NAMELESS:
//STRIP001 			return ePres;
//STRIP001 	}
//STRIP001 
//STRIP001 	return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 }


//------------------------------
// class XFillBmpTileOffYItem
//------------------------------
/*N*/ TYPEINIT1_AUTOFACTORY( XFillBmpTileOffsetYItem, SfxUInt16Item );

/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ XFillBmpTileOffsetYItem::XFillBmpTileOffsetYItem( USHORT nOffY ) :
/*N*/ 			SfxUInt16Item( XATTR_FILLBMP_TILEOFFSETY, nOffY )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ XFillBmpTileOffsetYItem::XFillBmpTileOffsetYItem( SvStream& rIn ) :
/*N*/ 			SfxUInt16Item( XATTR_FILLBMP_TILEOFFSETY, rIn )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpTileOffsetYItem::Clone( SfxItemPool* pPool ) const
/*N*/ {
/*N*/ 	return new XFillBmpTileOffsetYItem( *this );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpTileOffsetYItem::Create( SvStream& rIn, USHORT nVer ) const
/*N*/ {
/*N*/ 	return new XFillBmpTileOffsetYItem( rIn );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

//STRIP001 SfxItemPresentation XFillBmpTileOffsetYItem::GetPresentation
//STRIP001 (
//STRIP001 	SfxItemPresentation ePres,
//STRIP001 	SfxMapUnit			eCoreUnit,
//STRIP001 	SfxMapUnit			ePresUnit,
//STRIP001     XubString&          rText, const IntlWrapper *
//STRIP001 )	const
//STRIP001 {
//STRIP001 	rText.Erase();
//STRIP001 
//STRIP001 	switch ( ePres )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_PRESENTATION_NONE:
//STRIP001 			return ePres;
//STRIP001 		case SFX_ITEM_PRESENTATION_COMPLETE:
//STRIP001 		case SFX_ITEM_PRESENTATION_NAMELESS:
//STRIP001 			return ePres;
//STRIP001 	}
//STRIP001 
//STRIP001 	return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 }


//------------------------------
// class XFillBmpStretchItem
//------------------------------
/*N*/ TYPEINIT1_AUTOFACTORY( XFillBmpStretchItem, SfxBoolItem );

/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ XFillBmpStretchItem::XFillBmpStretchItem( BOOL bStretch ) :
/*N*/ 			SfxBoolItem( XATTR_FILLBMP_STRETCH, bStretch )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ XFillBmpStretchItem::XFillBmpStretchItem( SvStream& rIn ) :
/*N*/ 			SfxBoolItem( XATTR_FILLBMP_STRETCH, rIn )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpStretchItem::Clone( SfxItemPool* pPool ) const
/*N*/ {
/*N*/ 	return new XFillBmpStretchItem( *this );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpStretchItem::Create( SvStream& rIn, USHORT nVer ) const
/*N*/ {
/*N*/ 	return new XFillBmpStretchItem( rIn );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	28.02.96 KA
|*	  Letzte Aenderung	28.02.96 KA
|*
*************************************************************************/

//STRIP001 SfxItemPresentation XFillBmpStretchItem::GetPresentation
//STRIP001 (
//STRIP001 	SfxItemPresentation ePres,
//STRIP001 	SfxMapUnit			eCoreUnit,
//STRIP001 	SfxMapUnit			ePresUnit,
//STRIP001     XubString&          rText, const IntlWrapper *
//STRIP001 )	const
//STRIP001 {
//STRIP001 	rText.Erase();
//STRIP001 
//STRIP001 	switch ( ePres )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_PRESENTATION_NONE:
//STRIP001 			return ePres;
//STRIP001 		case SFX_ITEM_PRESENTATION_COMPLETE:
//STRIP001 		case SFX_ITEM_PRESENTATION_NAMELESS:
//STRIP001 			return ePres;
//STRIP001 	}
//STRIP001 
//STRIP001 	return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 }


//------------------------------
// class XFillBmpTileOffPosXItem
//------------------------------
/*N*/ TYPEINIT1_AUTOFACTORY( XFillBmpPosOffsetXItem, SfxUInt16Item );

/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	KA 29.04.96
|*	  Letzte Aenderung	KA 29.04.96
|*
*************************************************************************/

/*N*/ XFillBmpPosOffsetXItem::XFillBmpPosOffsetXItem( USHORT nOffPosX ) :
/*N*/ 			SfxUInt16Item( XATTR_FILLBMP_POSOFFSETX, nOffPosX )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	KA 29.04.96
|*	  Letzte Aenderung	KA 29.04.96
|*
*************************************************************************/

/*N*/ XFillBmpPosOffsetXItem::XFillBmpPosOffsetXItem( SvStream& rIn ) :
/*N*/ 			SfxUInt16Item( XATTR_FILLBMP_POSOFFSETX, rIn )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	KA 29.04.96
|*	  Letzte Aenderung	KA 29.04.96
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpPosOffsetXItem::Clone( SfxItemPool* pPool ) const
/*N*/ {
/*N*/ 	return new XFillBmpPosOffsetXItem( *this );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	KA 29.04.96
|*	  Letzte Aenderung	KA 29.04.96
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpPosOffsetXItem::Create( SvStream& rIn, USHORT nVer ) const
/*N*/ {
/*N*/ 	return new XFillBmpPosOffsetXItem( rIn );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	KA 29.04.96
|*	  Letzte Aenderung	KA 29.04.96
|*
*************************************************************************/

//STRIP001 SfxItemPresentation XFillBmpPosOffsetXItem::GetPresentation
//STRIP001 (
//STRIP001 	SfxItemPresentation ePres,
//STRIP001 	SfxMapUnit			eCoreUnit,
//STRIP001 	SfxMapUnit			ePresUnit,
//STRIP001     XubString&          rText, const IntlWrapper *
//STRIP001 )	const
//STRIP001 {
//STRIP001 	rText.Erase();
//STRIP001 
//STRIP001 	switch ( ePres )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_PRESENTATION_NONE:
//STRIP001 			return ePres;
//STRIP001 		case SFX_ITEM_PRESENTATION_COMPLETE:
//STRIP001 		case SFX_ITEM_PRESENTATION_NAMELESS:
//STRIP001 			return ePres;
//STRIP001 	}
//STRIP001 
//STRIP001 	return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 }


//------------------------------
// class XFillBmpTileOffPosYItem
//------------------------------
/*N*/ TYPEINIT1_AUTOFACTORY( XFillBmpPosOffsetYItem, SfxUInt16Item );

/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	KA 29.04.96
|*	  Letzte Aenderung	KA 29.04.96
|*
*************************************************************************/

/*N*/ XFillBmpPosOffsetYItem::XFillBmpPosOffsetYItem( USHORT nOffPosY ) :
/*N*/ 			SfxUInt16Item( XATTR_FILLBMP_POSOFFSETY, nOffPosY )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	KA 29.04.96
|*	  Letzte Aenderung	KA 29.04.96
|*
*************************************************************************/

/*N*/ XFillBmpPosOffsetYItem::XFillBmpPosOffsetYItem( SvStream& rIn ) :
/*N*/ 			SfxUInt16Item( XATTR_FILLBMP_POSOFFSETY, rIn )
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	KA 29.04.96
|*	  Letzte Aenderung	KA 29.04.96
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpPosOffsetYItem::Clone( SfxItemPool* pPool ) const
/*N*/ {
/*N*/ 	return new XFillBmpPosOffsetYItem( *this );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	KA 29.04.96
|*	  Letzte Aenderung	KA 29.04.96
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBmpPosOffsetYItem::Create( SvStream& rIn, USHORT nVer ) const
/*N*/ {
/*N*/ 	return new XFillBmpPosOffsetYItem( rIn );
/*N*/ }


/*************************************************************************
|*
|*
|*
|*	  Beschreibung
|*	  Ersterstellung	KA 29.04.96
|*	  Letzte Aenderung	KA 29.04.96
|*
*************************************************************************/

//STRIP001 SfxItemPresentation XFillBmpPosOffsetYItem::GetPresentation
//STRIP001 (
//STRIP001 	SfxItemPresentation ePres,
//STRIP001 	SfxMapUnit			eCoreUnit,
//STRIP001 	SfxMapUnit			ePresUnit,
//STRIP001     XubString&          rText, const IntlWrapper *
//STRIP001 )	const
//STRIP001 {
//STRIP001 	rText.Erase();
//STRIP001 
//STRIP001 	switch ( ePres )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_PRESENTATION_NONE:
//STRIP001 			return ePres;
//STRIP001 		case SFX_ITEM_PRESENTATION_COMPLETE:
//STRIP001 		case SFX_ITEM_PRESENTATION_NAMELESS:
//STRIP001 			return ePres;
//STRIP001 	}
//STRIP001 
//STRIP001 	return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 }

//--------------------------
// class XFillBackgroundItem
//--------------------------
/*N*/ TYPEINIT1_AUTOFACTORY(XFillBackgroundItem, SfxBoolItem);

/*************************************************************************
|*
|*	  XFillBackgroundItem::XFillBackgroundItem( BOOL )
|*
|*	  Beschreibung
|*	  Ersterstellung	19.11.96 KA
|*	  Letzte Aenderung
|*
*************************************************************************/

/*N*/ XFillBackgroundItem::XFillBackgroundItem( BOOL bFill ) :
/*N*/ 	SfxBoolItem( XATTR_FILLBACKGROUND, bFill )
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|*	  XFillBackgroundItem::XFillBackgroundItem( SvStream& rIn )
|*
|*	  Beschreibung
|*	  Ersterstellung	23.01.96 KA
|*	  Letzte Aenderung	23.01.96 KA
|*
*************************************************************************/

/*N*/ XFillBackgroundItem::XFillBackgroundItem( SvStream& rIn ) :
/*N*/ 	SfxBoolItem( XATTR_FILLBACKGROUND, rIn )
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|*	  XFillBackgroundItem::Clone( SfxItemPool* pPool ) const
|*
|*	  Beschreibung
|*	  Ersterstellung	23.01.96 KA
|*	  Letzte Aenderung	23.01.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBackgroundItem::Clone( SfxItemPool* pPool ) const
/*N*/ {
/*N*/ 	return new XFillBackgroundItem( *this );
/*N*/ }

/*************************************************************************
|*
|*	  SfxPoolItem* XFillBackgroundItem::Create(SvStream& rIn, USHORT nVer) const
|*
|*	  Beschreibung
|*	  Ersterstellung	23.01.96 KA
|*	  Letzte Aenderung	23.01.96 KA
|*
*************************************************************************/

/*N*/ SfxPoolItem* XFillBackgroundItem::Create(SvStream& rIn, USHORT nVer) const
/*N*/ {
/*N*/ 	return new XFillBackgroundItem( rIn );
/*N*/ }

//------------------------------------------------------------------------

//STRIP001 SfxItemPresentation XFillBackgroundItem::GetPresentation( SfxItemPresentation ePres, SfxMapUnit eCoreUnit,
//STRIP001                                                           SfxMapUnit ePresUnit, XubString& rText, const IntlWrapper*) const
//STRIP001 {
//STRIP001 	rText.Erase();
//STRIP001 
//STRIP001 	switch( ePres )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_PRESENTATION_NONE:
//STRIP001 			return ePres;
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SFX_ITEM_PRESENTATION_COMPLETE:
//STRIP001 		case SFX_ITEM_PRESENTATION_NAMELESS:
//STRIP001 			return ePres;
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 }



}
