/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_tpline.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:11:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------
#ifndef _SVX_SIZEITEM_HXX //autogen
#define ITEMID_SIZE 0
#include <sizeitem.hxx>
#endif
#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _SFXAPP_HXX
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif
#pragma hdrstop

#define _SVX_TPLINE_CXX

#include "dialogs.hrc"
#include "tabline.hrc"
#include "dlgname.hrc"

#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE
#define ITEMID_DASH_LIST		SID_DASH_LIST
#define ITEMID_LINEEND_LIST		SID_LINEEND_LIST

#include "xattr.hxx"
#include "xpool.hxx"
#include "xtable.hxx"
#include "xoutx.hxx"

#include "drawitem.hxx"
#include "tabline.hxx"
#include "dlgname.hxx"
#include "dialmgr.hxx"
#include "dlgutil.hxx"
#include "svdmodel.hxx"

#include "linectrl.hrc"
namespace binfilter {

//#58425# Symbole auf einer Linie (z.B. StarChart) Includes:


//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001 #define SVX_TRACE(b,a)												 \
//STRIP001 	{																 \
//STRIP001 		ByteString _aStr( RTL_CONSTASCII_STRINGPARAM( "SvxTrace" ) );\
//STRIP001 		_aStr.Append( ByteString::CreateFromInt32( b ) );			 \
//STRIP001 		_aStr.Append( "->" );										 \
//STRIP001 		_aStr.Append( ByteString::CreateFromInt32( (sal_Int32) this ) );	 \
//STRIP001 		_aStr.Append( '@' );										 \
//STRIP001 		_aStr.Append( a );											 \
//STRIP001 		DBG_TRACE( _aStr.GetBuffer() );						 \
//STRIP001 	}
//STRIP001 #else
//STRIP001 #define SVX_TRACE(b,a)
//STRIP001 #endif
//STRIP001 
//STRIP001 
//STRIP001 #ifndef _SVDOBJ_HXX //autogen
//STRIP001 #include <svdobj.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVDVIEW_HXX //autogen
//STRIP001 #include <svdview.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVDMODEL_HXX //autogen
//STRIP001 #include <svdmodel.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SVX_NUMVSET_HXX //autogen
//STRIP001 #include <numvset.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_MSGBOX_HXX //autogen
//STRIP001 #include <vcl/msgbox.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_NUMITEM_HXX //autogen
//STRIP001 #include <numitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_SVXENUM_HXX //autogen
//STRIP001 #include <svxenum.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFX_OBJSH_HXX //autogen
//STRIP001 #include <bf_sfx2/objsh.hxx>
//STRIP001 #endif
//STRIP001 #define ITEMID_BRUSH SID_ATTR_BRUSH
//STRIP001 #ifndef _SVX_BRSHITEM_HXX //autogen
//STRIP001 #include <brshitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _GALLERY_HXX_ //autogen
//STRIP001 #include <gallery.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_XBITMAP_HXX //autogen
//STRIP001 #include <xbitmap.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _UNOTOOLS_LOCALFILEHELPER_HXX
//STRIP001 #include <unotools/localfilehelper.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #include "opengrf.hxx"
//STRIP001 
//STRIP001 #define MAX_BMP_WIDTH 	16
//STRIP001 #define MAX_BMP_HEIGHT  16
//STRIP001 // define ----------------------------------------------------------------
//STRIP001 
//STRIP001 #define DLGWIN this->GetParent()->GetParent()
//STRIP001 
//STRIP001 #define BITMAP_WIDTH   32
//STRIP001 #define BITMAP_HEIGHT  12
//STRIP001 #define XOUT_WIDTH    150
//STRIP001 
//STRIP001 // static ----------------------------------------------------------------
//STRIP001 
//STRIP001 static USHORT pLineRanges[] =
//STRIP001 {
//STRIP001 	XATTR_LINETRANSPARENCE,
//STRIP001 	XATTR_LINETRANSPARENCE,
//STRIP001 	SID_ATTR_LINE_STYLE,
//STRIP001 	SID_ATTR_LINE_ENDCENTER,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Dialog zum Aendern der Linien
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxLineTabPage::SvxLineTabPage
//STRIP001 (
//STRIP001 	Window* pParent,
//STRIP001 	const SfxItemSet& rInAttrs
//STRIP001 ) :
//STRIP001 	SvxTabPage			( pParent, SVX_RES( RID_SVXPAGE_LINE ), rInAttrs ),
//STRIP001 	pXPool				( (XOutdevItemPool*) rInAttrs.GetPool() ),
//STRIP001 	XOut				( &aCtlPreview ),
//STRIP001 	aXLineAttr			( pXPool ),
//STRIP001 	rXLSet				( aXLineAttr.GetItemSet() ),
//STRIP001 
//STRIP001 	aXLStyle			( XLINE_DASH ),
//STRIP001 	aXWidth				( 1 ),
//STRIP001 	aXColor				( String(), COL_LIGHTRED ),
//STRIP001 	aXDash				( String(), XDash( XDASH_RECT, 3, 7, 2, 40, 15 ) ),
//STRIP001 
//STRIP001 	aFtColor			( this, ResId( FT_COLOR ) ),
//STRIP001 	aLbColor			( this, ResId( LB_COLOR ) ),
//STRIP001 	aFtLineStyle		( this, ResId( FT_LINE_STYLE ) ),
//STRIP001 	aLbLineStyle		( this, ResId( LB_LINE_STYLE ) ),
//STRIP001 	aFtLineWidth		( this, ResId( FT_LINE_WIDTH ) ),
//STRIP001 	aMtrLineWidth		( this, ResId( MTR_FLD_LINE_WIDTH ) ),
//STRIP001 	aFtTransparent  	( this, ResId( FT_TRANSPARENT ) ),
//STRIP001 	aMtrTransparent  	( this, ResId( MTR_LINE_TRANSPARENT ) ),
//STRIP001 	aFlLine				( this, ResId( FL_LINE ) ),
//STRIP001 	aFtLineEndsStyle	( this, ResId( FT_LINE_ENDS_STYLE ) ),
//STRIP001 	aFtLineEndsWidth	( this, ResId( FT_LINE_ENDS_WIDTH ) ),
//STRIP001 	aLbStartStyle		( this, ResId( LB_START_STYLE ) ),
//STRIP001 	aMtrStartWidth		( this, ResId( MTR_FLD_START_WIDTH ) ),
//STRIP001 	aTsbCenterStart		( this, ResId( TSB_CENTER_START ) ),
//STRIP001 	aLbEndStyle			( this, ResId( LB_END_STYLE ) ),
//STRIP001 	aMtrEndWidth		( this, ResId( MTR_FLD_END_WIDTH ) ),
//STRIP001 	aTsbCenterEnd  		( this, ResId( TSB_CENTER_END ) ),
//STRIP001 	aCbxSynchronize		( this, ResId( CBX_SYNCHRONIZE ) ),
//STRIP001 	aFlLineEnds			( this, ResId( FL_LINE_ENDS ) ),
//STRIP001 	aCtlPreview			( this, ResId( CTL_PREVIEW ), &XOut ),
//STRIP001 		aFLSeparator		( this, ResId( FL_SEPARATOR ) ),
//STRIP001 	//#58425# Symbole auf einer Linie (z.B. StarChart) ->
//STRIP001 	aSymbolWidthFT		( this, ResId(FT_SYMBOL_WIDTH)),
//STRIP001 	aSymbolWidthMF		( this, ResId(MF_SYMBOL_WIDTH)),
//STRIP001 	aSymbolHeightFT		( this, ResId(FT_SYMBOL_HEIGHT)),
//STRIP001 	aSymbolHeightMF		( this, ResId(MF_SYMBOL_HEIGHT)),
//STRIP001 	aFlSymbol			( this, ResId(FL_SYMBOL_FORMAT)),
//STRIP001 	aSymbolRatioCB		( this, ResId(CB_SYMBOL_RATIO)),
//STRIP001 	aSymbolMB		    ( this, ResId(MB_SYMBOL_BITMAP)),
//STRIP001 	nSymbolType(SVX_SYMBOLTYPE_UNKNOWN), //unbekannt bzw. unchanged
//STRIP001 	bLastWidthModified(FALSE),
//STRIP001 	aSymbolLastSize(Size(0,0)),
//STRIP001 	bSymbols(FALSE),
//STRIP001 	pSymbolList(NULL),
//STRIP001 	nNumMenuGalleryItems(0),
//STRIP001 	pSymbolAttr(NULL),
//STRIP001 	bNewSize(FALSE),
//STRIP001 	//#58425# Symbole auf einer Linie (z.B. StarChart) <-
//STRIP001 
//STRIP001 	pPageType			( NULL ),
//STRIP001 	rOutAttrs			( rInAttrs )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	// Metrik einstellen
//STRIP001 	FieldUnit eFUnit = GetModuleFieldUnit( &rInAttrs );
//STRIP001 
//STRIP001 	switch ( eFUnit )
//STRIP001 	{
//STRIP001 		case FUNIT_M:
//STRIP001 		case FUNIT_KM:
//STRIP001 			eFUnit = FUNIT_MM;
//STRIP001 			// no break -> we now have mm
//STRIP001 		case FUNIT_MM:
//STRIP001 			aMtrLineWidth.SetSpinSize( 50 );
//STRIP001 			aMtrStartWidth.SetSpinSize( 50 );
//STRIP001 			aMtrEndWidth.SetSpinSize( 50 );
//STRIP001 			break;
//STRIP001 
//STRIP001 			case FUNIT_INCH:
//STRIP001 			aMtrLineWidth.SetSpinSize( 2 );
//STRIP001 			aMtrStartWidth.SetSpinSize( 2 );
//STRIP001 			aMtrEndWidth.SetSpinSize( 2 );
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	SetFieldUnit( aMtrLineWidth, eFUnit );
//STRIP001 	SetFieldUnit( aMtrStartWidth, eFUnit );
//STRIP001 	SetFieldUnit( aMtrEndWidth, eFUnit );
//STRIP001 
//STRIP001 	// PoolUnit ermitteln
//STRIP001 	SfxItemPool* pPool = rOutAttrs.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool?" );
//STRIP001 	ePoolUnit = pPool->GetMetric( SID_ATTR_LINE_WIDTH );
//STRIP001 
//STRIP001 	aLbLineStyle.SetSelectHdl(
//STRIP001 		LINK( this, SvxLineTabPage, ClickInvisibleHdl_Impl ) );
//STRIP001 	aLbColor.SetSelectHdl(
//STRIP001 		LINK( this, SvxLineTabPage, ChangePreviewHdl_Impl ) );
//STRIP001 	aMtrLineWidth.SetModifyHdl(
//STRIP001 		LINK( this, SvxLineTabPage, ChangePreviewHdl_Impl ) );
//STRIP001 	aMtrTransparent.SetModifyHdl(
//STRIP001 		LINK( this, SvxLineTabPage, ChangeTransparentHdl_Impl ) );
//STRIP001 
//STRIP001 	Link aStart = LINK( this, SvxLineTabPage, ChangeStartHdl_Impl );
//STRIP001 	Link aEnd = LINK( this, SvxLineTabPage, ChangeEndHdl_Impl );
//STRIP001 	aLbStartStyle.SetSelectHdl( aStart );
//STRIP001 	aLbEndStyle.SetSelectHdl( aEnd );
//STRIP001 	aMtrStartWidth.SetModifyHdl( aStart );
//STRIP001 	aMtrEndWidth.SetModifyHdl( aEnd );
//STRIP001 	aTsbCenterStart.SetClickHdl( aStart );
//STRIP001 	aTsbCenterEnd.SetClickHdl( aEnd );
//STRIP001 
//STRIP001 	pColorTab = NULL;
//STRIP001 	pDashList = NULL;
//STRIP001 	pLineEndList = NULL;
//STRIP001 
//STRIP001 
//STRIP001 	//#58425# Symbole auf einer Linie (z.B. StarChart) , MB-Handler setzen
//STRIP001 	aSymbolMB.SetSelectHdl(LINK(this, SvxLineTabPage, GraphicHdl_Impl));
//STRIP001     aSymbolMB.SetActivateHdl(LINK(this, SvxLineTabPage, MenuCreateHdl_Impl));
//STRIP001 	aSymbolWidthMF.SetModifyHdl(LINK(this, SvxLineTabPage, SizeHdl_Impl));
//STRIP001 	aSymbolHeightMF.SetModifyHdl(LINK(this, SvxLineTabPage, SizeHdl_Impl));
//STRIP001 	aSymbolRatioCB.SetClickHdl(LINK(this, SvxLineTabPage, RatioHdl_Impl));
//STRIP001 
//STRIP001 	aSymbolRatioCB.Check(TRUE);
//STRIP001 	ShowSymbolControls(FALSE);
//STRIP001 
//STRIP001 	// #63083#
//STRIP001 	nActLineWidth = -1;
//STRIP001 }
//STRIP001 //#58425# Symbole auf einer Linie (z.B. StarChart) , Symbol-Controls aktivieren
//STRIP001 void SvxLineTabPage::ShowSymbolControls(BOOL bOn)
//STRIP001 {
//STRIP001 	bSymbols=bOn;
//STRIP001 	aSymbolWidthFT.Show(bOn);
//STRIP001 	aSymbolWidthMF.Show(bOn);
//STRIP001 	aSymbolHeightFT.Show(bOn);
//STRIP001 	aSymbolHeightMF.Show(bOn);
//STRIP001 	aFlSymbol.Show(bOn);
//STRIP001 	aSymbolRatioCB.Show(bOn);
//STRIP001 	aSymbolMB.Show(bOn);
//STRIP001 	aCtlPreview.ShowSymbol(bOn);
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 //#58425# Symbole auf einer Linie (z.B. StarChart) , dtor neu!
//STRIP001 SvxLineTabPage::~SvxLineTabPage()
//STRIP001 {
//STRIP001 	delete aSymbolMB.GetPopupMenu()->GetPopupMenu( MN_GALLERY );
//STRIP001 
//STRIP001 	if(pSymbolList)
//STRIP001 		delete aSymbolMB.GetPopupMenu()->GetPopupMenu( MN_SYMBOLS );
//STRIP001 
//STRIP001 	String* pStr = (String*)aGrfNames.First();
//STRIP001 	while( pStr )
//STRIP001 	{
//STRIP001 		delete pStr;
//STRIP001 		pStr = (String*)aGrfNames.Next();
//STRIP001 	}
//STRIP001 	SvxBmpItemInfo* pInfo = (SvxBmpItemInfo*)aGrfBrushItems.First();
//STRIP001 	while( pInfo )
//STRIP001 	{
//STRIP001 		delete pInfo->pBrushItem;
//STRIP001 		delete pInfo;
//STRIP001 		pInfo = (SvxBmpItemInfo*)aGrfBrushItems.Next();
//STRIP001 	}
//STRIP001 }
//STRIP001 void SvxLineTabPage::Construct()
//STRIP001 {
//STRIP001 	// Farbtabelle
//STRIP001 	aLbColor.Fill( pColorTab );
//STRIP001 	FillListboxes();
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLineTabPage::FillListboxes()
//STRIP001 {
//STRIP001 //	aCtlPreview.SetDrawMode( GetDisplayBackground().GetColor().IsDark() ? OUTPUT_DRAWMODE_CONTRAST : OUTPUT_DRAWMODE_COLOR );
//STRIP001 
//STRIP001 	ResMgr* pMgr = DIALOG_MGR();
//STRIP001 
//STRIP001 	// Linienstile
//STRIP001 	USHORT nOldSelect = aLbLineStyle.GetSelectEntryPos();
//STRIP001 	aLbLineStyle.Clear();
//STRIP001 	aLbLineStyle.InsertEntry( String( ResId( RID_SVXSTR_INVISIBLE, pMgr ) ) );
//STRIP001 
//STRIP001 	const StyleSettings& rStyles = Application::GetSettings().GetStyleSettings();
//STRIP001 	Bitmap aBitmap ( SVX_RES ( RID_SVXCTRL_LINECTRL ) );
//STRIP001 	Color aSourceColors[2];
//STRIP001 	Color aDestColors[2];
//STRIP001 
//STRIP001 	aSourceColors[0] = Color( COL_WHITE );
//STRIP001 	aSourceColors[1] = Color( COL_BLACK );
//STRIP001 
//STRIP001 	aDestColors[0] = rStyles.GetFieldColor();
//STRIP001 	aDestColors[1] = rStyles.GetFieldTextColor();
//STRIP001 
//STRIP001 	aBitmap.Replace ( aSourceColors, aDestColors, 2 );
//STRIP001 	Image aSolidLine ( aBitmap );
//STRIP001 	aLbLineStyle.InsertEntry( String( ResId( RID_SVXSTR_SOLID, pMgr ) ), aSolidLine );
//STRIP001 	aLbLineStyle.Fill( pDashList );
//STRIP001 	aLbLineStyle.SelectEntryPos( nOldSelect );
//STRIP001 
//STRIP001 	// LinienEndenStile
//STRIP001 	String sNone( ResId( RID_SVXSTR_NONE, pMgr ) );
//STRIP001 	nOldSelect = aLbStartStyle.GetSelectEntryPos();
//STRIP001 	aLbStartStyle.Clear();
//STRIP001 	aLbStartStyle.InsertEntry( sNone );
//STRIP001 	aLbStartStyle.Fill( pLineEndList );
//STRIP001 	aLbStartStyle.SelectEntryPos( nOldSelect );
//STRIP001 	nOldSelect = aLbEndStyle.GetSelectEntryPos();
//STRIP001 	aLbEndStyle.Clear();
//STRIP001 	aLbEndStyle.InsertEntry( sNone );
//STRIP001 	aLbEndStyle.Fill( pLineEndList, FALSE );
//STRIP001 	aLbEndStyle.SelectEntryPos( nOldSelect );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxLineTabPage::ActivatePage( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	if( *pDlgType == 0 && pDashList ) // Linien-Dialog
//STRIP001 	{
//STRIP001 		ResMgr* pMgr = DIALOG_MGR();
//STRIP001 		int nPos;
//STRIP001 		int nCount;
//STRIP001 
//STRIP001 		// Dashliste
//STRIP001 		if( ( *pnDashListState & CT_MODIFIED ) ||
//STRIP001 			( *pnDashListState & CT_CHANGED ) )
//STRIP001 		{
//STRIP001 			if( *pnDashListState & CT_CHANGED )
//STRIP001 				pDashList = ( (SvxLineTabDialog*) DLGWIN )->
//STRIP001 										GetNewDashList();
//STRIP001 			*pnDashListState = CT_NONE;
//STRIP001 
//STRIP001 			// Styleliste
//STRIP001 			nPos = aLbLineStyle.GetSelectEntryPos();
//STRIP001 
//STRIP001 			aLbLineStyle.Clear();
//STRIP001 			aLbLineStyle.InsertEntry(
//STRIP001 				String( ResId( RID_SVXSTR_INVISIBLE, pMgr ) ) );
//STRIP001 			aLbLineStyle.InsertEntry(
//STRIP001 				String( ResId( RID_SVXSTR_SOLID, pMgr ) ) );
//STRIP001 			aLbLineStyle.Fill( pDashList );
//STRIP001 			nCount = aLbLineStyle.GetEntryCount();
//STRIP001 
//STRIP001 			if ( nCount == 0 )
//STRIP001 				; // Dieser Fall sollte nicht auftreten
//STRIP001 			else if( nCount <= nPos )
//STRIP001 				aLbLineStyle.SelectEntryPos( 0 );
//STRIP001 			else
//STRIP001 				aLbLineStyle.SelectEntryPos( nPos );
//STRIP001 			// SelectStyleHdl_Impl( this );
//STRIP001 		}
//STRIP001 
//STRIP001 		INetURLObject	aDashURL( pDashList->GetPath() );
//STRIP001 
//STRIP001 		aDashURL.Append( pDashList->GetName() );
//STRIP001 		DBG_ASSERT( aDashURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 /*		// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 		// der GroupBox darstellen
//STRIP001 		String			aString( ResId( RID_SVXSTR_TABLE, pMgr ) ); aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 
//STRIP001 		if ( aDashURL.getBase().Len() > 18 )
//STRIP001 		{
//STRIP001 			aString += aDashURL.getBase().Copy( 0, 15 );
//STRIP001 			aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aString += aDashURL.getBase();
//STRIP001 
//STRIP001 		aGrpLine.SetText( aString );
//STRIP001 */
//STRIP001 		// LineEndliste
//STRIP001 		if( ( *pnLineEndListState & CT_MODIFIED ) ||
//STRIP001 			( *pnLineEndListState & CT_CHANGED ) )
//STRIP001 		{
//STRIP001 			if( *pnLineEndListState & CT_CHANGED )
//STRIP001 				pLineEndList = ( (SvxLineTabDialog*) DLGWIN )->
//STRIP001 										GetNewLineEndList();
//STRIP001 			*pnLineEndListState = CT_NONE;
//STRIP001 
//STRIP001 			nPos = aLbLineStyle.GetSelectEntryPos();
//STRIP001 			String sNone( ResId( RID_SVXSTR_NONE, pMgr ) );
//STRIP001 			aLbStartStyle.Clear();
//STRIP001 			aLbStartStyle.InsertEntry( sNone );
//STRIP001 
//STRIP001 			aLbStartStyle.Fill( pLineEndList );
//STRIP001 			nCount = aLbStartStyle.GetEntryCount();
//STRIP001 			if( nCount == 0 )
//STRIP001 				; // Dieser Fall sollte nicht auftreten
//STRIP001 			else if( nCount <= nPos )
//STRIP001 				aLbStartStyle.SelectEntryPos( 0 );
//STRIP001 			else
//STRIP001 				aLbStartStyle.SelectEntryPos( nPos );
//STRIP001 
//STRIP001 			aLbEndStyle.Clear();
//STRIP001 			aLbEndStyle.InsertEntry( sNone );
//STRIP001 
//STRIP001 			aLbEndStyle.Fill( pLineEndList, FALSE );
//STRIP001 			nCount = aLbEndStyle.GetEntryCount();
//STRIP001 
//STRIP001 			if( nCount == 0 )
//STRIP001 				; // Dieser Fall sollte nicht auftreten
//STRIP001 			else if( nCount <= nPos )
//STRIP001 				aLbEndStyle.SelectEntryPos( 0 );
//STRIP001 			else
//STRIP001 				aLbEndStyle.SelectEntryPos( nPos );
//STRIP001 		}
//STRIP001 		INetURLObject aLineURL( pLineEndList->GetPath() );
//STRIP001 
//STRIP001 		aLineURL.Append( pLineEndList->GetName() );
//STRIP001 		DBG_ASSERT( aLineURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 /*		// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 		// der GroupBox darstellen
//STRIP001 		aString = String( ResId( RID_SVXSTR_TABLE, pMgr ) ); aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 
//STRIP001 		if ( aLineURL.getBase().Len() > 18 )
//STRIP001 		{
//STRIP001 			aString += aLineURL.getBase().Copy( 0, 15 );
//STRIP001 			aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aString += aLineURL.getBase();
//STRIP001 
//STRIP001 		aGrpLineEnds.SetText( aString );
//STRIP001 */
//STRIP001 		// Auswertung, ob von einer anderen TabPage ein anderer Fuelltyp gesetzt wurde
//STRIP001 		if( aLbLineStyle.GetSelectEntryPos() != 0 )
//STRIP001 		{
//STRIP001 			if( *pPageType == 2 ) // 1
//STRIP001 			{
//STRIP001 				aLbLineStyle.SelectEntryPos( *pPosDashLb + 2 ); // +2 wegen SOLID und INVLISIBLE
//STRIP001 				ChangePreviewHdl_Impl( this );
//STRIP001 			}
//STRIP001 			if( *pPageType == 3 )
//STRIP001 			{
//STRIP001 				aLbStartStyle.SelectEntryPos( *pPosLineEndLb + 1 );// +1 wegen SOLID
//STRIP001 				aLbEndStyle.SelectEntryPos( *pPosLineEndLb + 1 );// +1 wegen SOLID
//STRIP001 				ChangePreviewHdl_Impl( this );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		*pPageType = 0;
//STRIP001 	}
//STRIP001 	// Seite existiert im Ctor noch nicht, deswegen hier!
//STRIP001 
//STRIP001 	else if ( *pDlgType == 1100 || // Chart-Dialog
//STRIP001 			  *pDlgType == 1101 )
//STRIP001 	{
//STRIP001 		aFtLineEndsStyle.Hide();
//STRIP001 		aFtLineEndsWidth.Hide();
//STRIP001 		aLbStartStyle.Hide();
//STRIP001 		aMtrStartWidth.Hide();
//STRIP001 		aTsbCenterStart.Hide();
//STRIP001 		aLbEndStyle.Hide();
//STRIP001 		aMtrEndWidth.Hide();
//STRIP001 		aTsbCenterEnd.Hide();
//STRIP001 		aCbxSynchronize.Hide();
//STRIP001 		aFlLineEnds.Hide();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxLineTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if( *pDlgType == 0 ) // Linien-Dialog
//STRIP001 	{
//STRIP001 		*pPageType = 1; // evtl. fuer Erweiterungen
//STRIP001 		*pPosDashLb = aLbLineStyle.GetSelectEntryPos() - 2;// erster Eintrag SOLID !!!
//STRIP001 		USHORT nPos = aLbStartStyle.GetSelectEntryPos();
//STRIP001 		if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 			nPos--;
//STRIP001 		*pPosLineEndLb = nPos;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 
//STRIP001 	return( LEAVE_PAGE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxLineTabPage::FillItemSet( SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	const SfxPoolItem* pOld = NULL;
//STRIP001 	USHORT	nPos;
//STRIP001 	BOOL	bModified = FALSE;
//STRIP001 
//STRIP001 	// Um evtl. Modifikationen der Liste vorzubeugen
//STRIP001 	// werden Items anderer Seiten nicht gesetzt
//STRIP001 	if( *pDlgType != 0 || *pPageType != 2 )
//STRIP001 	{
//STRIP001 		nPos = aLbLineStyle.GetSelectEntryPos();
//STRIP001 		if( nPos != LISTBOX_ENTRY_NOTFOUND &&
//STRIP001 			nPos != aLbLineStyle.GetSavedValue() )
//STRIP001 		{
//STRIP001 			XLineStyleItem*	pStyleItem = NULL;
//STRIP001 
//STRIP001 			if( nPos == 0 )
//STRIP001 				pStyleItem = new XLineStyleItem( XLINE_NONE );
//STRIP001 			else if( nPos == 1 )
//STRIP001 				pStyleItem = new XLineStyleItem( XLINE_SOLID );
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pStyleItem = new XLineStyleItem( XLINE_DASH );
//STRIP001 
//STRIP001 				// Zusaetzliche Sicherheit
//STRIP001 				if( pDashList->Count() > (long) ( nPos - 2 ) )
//STRIP001 				{
//STRIP001 					XLineDashItem aDashItem( aLbLineStyle.GetSelectEntry(),
//STRIP001 										pDashList->Get( nPos - 2 )->GetDash() );
//STRIP001 					pOld = GetOldItem( rAttrs, XATTR_LINEDASH );
//STRIP001 					if ( !pOld || !( *(const XLineDashItem*)pOld == aDashItem ) )
//STRIP001 					{
//STRIP001 						rAttrs.Put( aDashItem );
//STRIP001 						bModified = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			pOld = GetOldItem( rAttrs, XATTR_LINESTYLE );
//STRIP001 			if ( !pOld || !( *(const XLineStyleItem*)pOld == *pStyleItem ) )
//STRIP001 			{
//STRIP001 				rAttrs.Put( *pStyleItem );
//STRIP001 				bModified = TRUE;
//STRIP001 			}
//STRIP001 			delete pStyleItem;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	// Linienbreite
//STRIP001 	// GetSavedValue() liefert String!
//STRIP001 	if( aMtrLineWidth.GetText() != aMtrLineWidth.GetSavedValue() )
//STRIP001 	{
//STRIP001 		XLineWidthItem aItem( GetCoreValue( aMtrLineWidth, ePoolUnit ) );
//STRIP001 		pOld = GetOldItem( rAttrs, XATTR_LINEWIDTH );
//STRIP001 		if ( !pOld || !( *(const XLineWidthItem*)pOld == aItem ) )
//STRIP001 		{
//STRIP001 			rAttrs.Put( aItem );
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	//Breite Linienanfang
//STRIP001 	if( aMtrStartWidth.GetText() != aMtrStartWidth.GetSavedValue() )
//STRIP001 	{
//STRIP001 		XLineStartWidthItem aItem( GetCoreValue( aMtrStartWidth, ePoolUnit ) );
//STRIP001 		pOld = GetOldItem( rAttrs, XATTR_LINESTARTWIDTH );
//STRIP001 		if ( !pOld || !( *(const XLineStartWidthItem*)pOld == aItem ) )
//STRIP001 		{
//STRIP001 			rAttrs.Put( aItem );
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	//Breite Linienende
//STRIP001 	if( aMtrEndWidth.GetText() != aMtrEndWidth.GetSavedValue() )
//STRIP001 	{
//STRIP001 		XLineEndWidthItem aItem( GetCoreValue( aMtrEndWidth, ePoolUnit ) );
//STRIP001 		pOld = GetOldItem( rAttrs, XATTR_LINEENDWIDTH );
//STRIP001 		if ( !pOld || !( *(const XLineEndWidthItem*)pOld == aItem ) )
//STRIP001 		{
//STRIP001 			rAttrs.Put( aItem );
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Linienfarbe
//STRIP001 	if( aLbColor.GetSelectEntryPos() != aLbColor.GetSavedValue() )
//STRIP001 	{
//STRIP001 		XLineColorItem aItem( aLbColor.GetSelectEntry(),
//STRIP001 							  aLbColor.GetSelectEntryColor() );
//STRIP001 		pOld = GetOldItem( rAttrs, XATTR_LINECOLOR );
//STRIP001 		if ( !pOld || !( *(const XLineColorItem*)pOld == aItem ) )
//STRIP001 		{
//STRIP001 			rAttrs.Put( aItem );
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( *pDlgType != 0 || *pPageType != 3 )
//STRIP001 	{
//STRIP001 		// Linienanfang
//STRIP001 		nPos = aLbStartStyle.GetSelectEntryPos();
//STRIP001 		if( nPos != LISTBOX_ENTRY_NOTFOUND &&
//STRIP001 			nPos != aLbStartStyle.GetSavedValue() )
//STRIP001 		{
//STRIP001 			XLineStartItem* pItem = NULL;
//STRIP001 			if( nPos == 0 )
//STRIP001 				pItem = new XLineStartItem();
//STRIP001 			else if( pLineEndList->Count() > (long) ( nPos - 1 ) )
//STRIP001 				pItem = new XLineStartItem( aLbStartStyle.GetSelectEntry(),
//STRIP001 							pLineEndList->Get( nPos - 1 )->GetLineEnd() );
//STRIP001 			pOld = GetOldItem( rAttrs, XATTR_LINESTART );
//STRIP001 			if( pItem &&
//STRIP001 				( !pOld || !( *(const XLineEndItem*)pOld == *pItem ) ) )
//STRIP001 			{
//STRIP001 				rAttrs.Put( *pItem );
//STRIP001 				bModified = TRUE;
//STRIP001 			}
//STRIP001 			delete pItem;
//STRIP001 		}
//STRIP001 		// Linienende
//STRIP001 		nPos = aLbEndStyle.GetSelectEntryPos();
//STRIP001 		if( nPos != LISTBOX_ENTRY_NOTFOUND &&
//STRIP001 			nPos != aLbEndStyle.GetSavedValue() )
//STRIP001 		{
//STRIP001 			XLineEndItem* pItem = NULL;
//STRIP001 			if( nPos == 0 )
//STRIP001 				pItem = new XLineEndItem();
//STRIP001 			else if( pLineEndList->Count() > (long) ( nPos - 1 ) )
//STRIP001 				pItem = new XLineEndItem( aLbEndStyle.GetSelectEntry(),
//STRIP001 							pLineEndList->Get( nPos - 1 )->GetLineEnd() );
//STRIP001 			pOld = GetOldItem( rAttrs, XATTR_LINEEND );
//STRIP001 			if( pItem &&
//STRIP001 				( !pOld || !( *(const XLineEndItem*)pOld == *pItem ) ) )
//STRIP001 			{
//STRIP001 				rAttrs.Put( *pItem );
//STRIP001 				bModified = TRUE;
//STRIP001 			}
//STRIP001 			delete pItem;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Linienenden zentriert
//STRIP001 	TriState eState = aTsbCenterStart.GetState();
//STRIP001 	if( eState != aTsbCenterStart.GetSavedValue() )
//STRIP001 	{
//STRIP001 		XLineStartCenterItem aItem( eState );
//STRIP001 		pOld = GetOldItem( rAttrs, XATTR_LINESTARTCENTER );
//STRIP001 		if ( !pOld || !( *(const XLineStartCenterItem*)pOld == aItem ) )
//STRIP001 		{
//STRIP001 			rAttrs.Put( aItem );
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	eState = aTsbCenterEnd.GetState();
//STRIP001 	if( eState != aTsbCenterEnd.GetSavedValue() )
//STRIP001 	{
//STRIP001 		XLineEndCenterItem aItem( eState );
//STRIP001 		pOld = GetOldItem( rAttrs, XATTR_LINEENDCENTER );
//STRIP001 		if ( !pOld || !( *(const XLineEndCenterItem*)pOld == aItem ) )
//STRIP001 		{
//STRIP001 			rAttrs.Put( aItem );
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//Breite Linienanfang
//STRIP001 	if( aMtrStartWidth.GetText() != aMtrStartWidth.GetSavedValue() )
//STRIP001 	{
//STRIP001 		XLineStartWidthItem aItem( GetCoreValue( aMtrStartWidth, ePoolUnit ) );
//STRIP001 		pOld = GetOldItem( rAttrs, XATTR_LINESTARTWIDTH );
//STRIP001 		if ( !pOld || !( *(const XLineStartWidthItem*)pOld == aItem ) )
//STRIP001 		{
//STRIP001 			rAttrs.Put( aItem );
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	//Breite Linienende
//STRIP001 	if( aMtrEndWidth.GetText() != aMtrEndWidth.GetSavedValue() )
//STRIP001 	{
//STRIP001 		XLineEndWidthItem aItem( GetCoreValue( aMtrEndWidth, ePoolUnit ) );
//STRIP001 		pOld = GetOldItem( rAttrs, XATTR_LINEENDWIDTH );
//STRIP001 		if ( !pOld || !( *(const XLineEndWidthItem*)pOld == aItem ) )
//STRIP001 		{
//STRIP001 			rAttrs.Put( aItem );
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Transparenz
//STRIP001 	UINT16 nVal = (UINT16)aMtrTransparent.GetValue();
//STRIP001 	if( nVal != (UINT16)aMtrTransparent.GetSavedValue().ToInt32() )
//STRIP001 	{
//STRIP001 		XLineTransparenceItem aItem( nVal );
//STRIP001 		pOld = GetOldItem( rAttrs, XATTR_LINETRANSPARENCE );
//STRIP001 		if ( !pOld || !( *(const XLineTransparenceItem*)pOld == aItem ) )
//STRIP001 		{
//STRIP001 			rAttrs.Put( aItem );
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if(nSymbolType!=SVX_SYMBOLTYPE_UNKNOWN || bNewSize)
//STRIP001 	{
//STRIP001 		//wurde also per Auswahl gesetzt oder Gre ist anders
//STRIP001 		SvxSizeItem  aSItem(rAttrs.GetPool()->GetWhich(SID_ATTR_SYMBOLSIZE),aSymbolSize);
//STRIP001 		const SfxPoolItem* pSOld = GetOldItem( rAttrs, rAttrs.GetPool()->GetWhich(SID_ATTR_SYMBOLSIZE) );
//STRIP001 		bNewSize  = pSOld ? *(const SvxSizeItem *)pSOld != aSItem : bNewSize ;
//STRIP001 		if(bNewSize)
//STRIP001 		{
//STRIP001 			rAttrs.Put(aSItem);
//STRIP001 			bModified=TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 		SfxInt32Item aTItem(rAttrs.GetPool()->GetWhich(SID_ATTR_SYMBOLTYPE),nSymbolType);
//STRIP001 		const SfxPoolItem* pTOld = GetOldItem( rAttrs, rAttrs.GetPool()->GetWhich(SID_ATTR_SYMBOLTYPE) );
//STRIP001 		BOOL bNewType  = pTOld ? *(const SfxInt32Item*)pTOld != aTItem : TRUE;
//STRIP001 		if(bNewType && nSymbolType==SVX_SYMBOLTYPE_UNKNOWN)
//STRIP001 			bNewType=FALSE;//kleine Korrektur, Typ wurde garnicht gesetzt -> kein Type-Item erzeugen!
//STRIP001 		if(bNewType)
//STRIP001 		{
//STRIP001 			rAttrs.Put(aTItem);
//STRIP001 			bModified=TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 		if(nSymbolType!=SVX_SYMBOLTYPE_NONE)
//STRIP001 		{
//STRIP001 			SvxBrushItem aBItem(aSymbolGraphic,GPOS_MM,rAttrs.GetPool()->GetWhich(SID_ATTR_BRUSH));
//STRIP001 			const SfxPoolItem* pBOld = GetOldItem( rAttrs, rAttrs.GetPool()->GetWhich(SID_ATTR_BRUSH) );
//STRIP001 			BOOL bNewBrush = pBOld ? *(const SvxBrushItem*)pBOld != aBItem : TRUE;
//STRIP001 			if(bNewBrush)
//STRIP001 			{
//STRIP001 				rAttrs.Put(aBItem);
//STRIP001 				bModified=TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return( bModified );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxLineTabPage::FillXLSet_Impl()
//STRIP001 {
//STRIP001 	USHORT nPos;
//STRIP001 
//STRIP001 	if( aLbLineStyle.GetSelectEntryPos() == LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		//rXLSet.Put( XLineDashItem ( rOutAttrs.Get( GetWhich( XATTR_LINEDASH ) ) ) );
//STRIP001 		rXLSet.Put( XLineStyleItem( XLINE_NONE ) );
//STRIP001 	}
//STRIP001 	else if( aLbLineStyle.IsEntryPosSelected( 0 ) )
//STRIP001 		rXLSet.Put( XLineStyleItem( XLINE_NONE ) );
//STRIP001 	else if( aLbLineStyle.IsEntryPosSelected( 1 ) )
//STRIP001 		rXLSet.Put( XLineStyleItem( XLINE_SOLID ) );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		rXLSet.Put( XLineStyleItem( XLINE_DASH ) );
//STRIP001 
//STRIP001 		nPos = aLbLineStyle.GetSelectEntryPos();
//STRIP001 		if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		{
//STRIP001 			rXLSet.Put( XLineDashItem( aLbLineStyle.GetSelectEntry(),
//STRIP001 							pDashList->Get( nPos - 2 )->GetDash() ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	nPos = aLbStartStyle.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		if( nPos == 0 )
//STRIP001 			rXLSet.Put( XLineStartItem() );
//STRIP001 		else
//STRIP001 			rXLSet.Put( XLineStartItem( aLbStartStyle.GetSelectEntry(),
//STRIP001 						pLineEndList->Get( nPos - 1 )->GetLineEnd() ) );
//STRIP001 	}
//STRIP001 	nPos = aLbEndStyle.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		if( nPos == 0 )
//STRIP001 			rXLSet.Put( XLineEndItem() );
//STRIP001 		else
//STRIP001 			rXLSet.Put( XLineEndItem( aLbEndStyle.GetSelectEntry(),
//STRIP001 						pLineEndList->Get( nPos - 1 )->GetLineEnd() ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	rXLSet.Put( XLineStartWidthItem( GetCoreValue( aMtrStartWidth, ePoolUnit ) ) );
//STRIP001 	rXLSet.Put( XLineEndWidthItem( GetCoreValue( aMtrEndWidth, ePoolUnit ) ) );
//STRIP001 
//STRIP001 	rXLSet.Put( XLineWidthItem( GetCoreValue( aMtrLineWidth, ePoolUnit ) ) );
//STRIP001 	rXLSet.Put( XLineColorItem( aLbColor.GetSelectEntry(),
//STRIP001 									aLbColor.GetSelectEntryColor() ) );
//STRIP001 
//STRIP001 	// Linienenden zentriert
//STRIP001 	if( aTsbCenterStart.GetState() == STATE_CHECK )
//STRIP001 		rXLSet.Put( XLineStartCenterItem( TRUE ) );
//STRIP001 	else if( aTsbCenterStart.GetState() == STATE_NOCHECK )
//STRIP001 		rXLSet.Put( XLineStartCenterItem( FALSE ) );
//STRIP001 
//STRIP001 	if( aTsbCenterEnd.GetState() == STATE_CHECK )
//STRIP001 		rXLSet.Put( XLineEndCenterItem( TRUE ) );
//STRIP001 	else if( aTsbCenterEnd.GetState() == STATE_NOCHECK )
//STRIP001 		rXLSet.Put( XLineEndCenterItem( FALSE ) );
//STRIP001 
//STRIP001 	// Transparenz
//STRIP001 	UINT16 nVal = (UINT16)aMtrTransparent.GetValue();
//STRIP001 	rXLSet.Put( XLineTransparenceItem( nVal ) );
//STRIP001 
//STRIP001 	XOut.SetLineAttr( aXLineAttr.GetItemSet() );
//STRIP001 
//STRIP001 	return( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxLineTabPage::Reset( const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	String		aString;
//STRIP001 	XLineStyle	eXLS; // XLINE_NONE, XLINE_SOLID, XLINE_DASH
//STRIP001 
//STRIP001 	// Linienstil
//STRIP001 /*
//STRIP001 	if( bObjSelected &&
//STRIP001 		rAttrs.GetItemState( GetWhich( XATTR_LINESTYLE ) ) == SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		aLbLineStyle.Disable();
//STRIP001 	}
//STRIP001 */
//STRIP001 	const SfxPoolItem *pPoolItem;
//STRIP001 	long nSymType=SVX_SYMBOLTYPE_UNKNOWN;
//STRIP001 	BOOL bPrevSym=FALSE;
//STRIP001 	BOOL bEnable=TRUE;
//STRIP001 	BOOL bIgnoreGraphic=FALSE;
//STRIP001 	BOOL bIgnoreSize=FALSE;
//STRIP001 	if(rAttrs.GetItemState(rAttrs.GetPool()->GetWhich(SID_ATTR_SYMBOLTYPE),TRUE,&pPoolItem) == SFX_ITEM_SET)
//STRIP001 	{
//STRIP001 		nSymType=((const SfxInt32Item *)pPoolItem)->GetValue();
//STRIP001 	}
//STRIP001 
//STRIP001 	if(nSymType == SVX_SYMBOLTYPE_AUTO)
//STRIP001 	{
//STRIP001 		aSymbolGraphic=aAutoSymbolGraphic;
//STRIP001 		aSymbolSize=aSymbolLastSize=aAutoSymbolGraphic.GetPrefSize();
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001 		ByteString aStr( "SVX_SYMBOLTYPE_AUTO AutoSymbolSize is " );
//STRIP001 		aStr.Append( ByteString::CreateFromInt32( aSymbolSize.Width() ) );
//STRIP001 		aStr.Append( ' ' );
//STRIP001 		aStr.Append( ByteString::CreateFromInt32( aSymbolSize.Height() ) );
//STRIP001 		SVX_TRACE( 213, aStr );
//STRIP001 #endif
//STRIP001 		bPrevSym=TRUE;
//STRIP001 		bEnable=FALSE;
//STRIP001 		bIgnoreGraphic=TRUE;
//STRIP001 		bIgnoreSize=TRUE;
//STRIP001 	}
//STRIP001 	else if(nSymType == SVX_SYMBOLTYPE_NONE)
//STRIP001 	{
//STRIP001 		bEnable=FALSE;
//STRIP001 		bIgnoreGraphic=TRUE;
//STRIP001 		bIgnoreSize=TRUE;
//STRIP001 		SVX_TRACE(213, ByteString( "SVX_SYMBOLTYPE_NONE" ) );
//STRIP001 	}
//STRIP001 	else if(nSymType >= 0)
//STRIP001 	{
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001 		ByteString aStr( "SVX_SYMBOLTYPE = " );
//STRIP001 		aStr.Append( ByteString::CreateFromInt32( nSymType ) );
//STRIP001 		SVX_TRACE(213, aStr );
//STRIP001 #endif
//STRIP001 		VirtualDevice aVDev;
//STRIP001 		aVDev.SetMapMode(MapMode(MAP_100TH_MM));
//STRIP001 		SdrModel* pModel = new SdrModel(NULL, NULL, LOADREFCOUNTS);
//STRIP001 		pModel->GetItemPool().FreezeIdRanges();
//STRIP001 		SdrPage* pPage = new SdrPage( *pModel, FALSE );
//STRIP001 		pPage->SetSize(Size(1000,1000));
//STRIP001 		pModel->InsertPage( pPage, 0 );
//STRIP001 		SdrView* pView = new SdrView( pModel, &aVDev );
//STRIP001 		pView->SetMarkHdlHidden( TRUE );
//STRIP001 		SdrPageView* pPageView = pView->ShowPage(pPage, Point());
//STRIP001 		SdrObject *pObj=NULL;
//STRIP001 		long nSymTmp=nSymType;
//STRIP001 		if(pSymbolList)
//STRIP001 		{
//STRIP001 			if(pSymbolList->GetObjCount())
//STRIP001 			{
//STRIP001 				nSymTmp=nSymTmp%pSymbolList->GetObjCount(); //Liste wird als cyclisch betrachtet!!!
//STRIP001 				pObj=pSymbolList->GetObj(nSymTmp);
//STRIP001 				if(pObj)
//STRIP001 				{
//STRIP001 					pObj=pObj->Clone();
//STRIP001 					pPage->NbcInsertObject(pObj);
//STRIP001 					pView->MarkObj(pObj,pPageView);
//STRIP001 					if(pSymbolAttr)
//STRIP001 					{
//STRIP001 //-/						pObj->NbcSetAttributes(*pSymbolAttr,FALSE);
//STRIP001 						pObj->SetItemSet(*pSymbolAttr);
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 //-/						pObj->NbcSetAttributes(rOutAttrs,FALSE);
//STRIP001 						pObj->SetItemSet(rOutAttrs);
//STRIP001 					}
//STRIP001 					GDIMetaFile aMeta(pView->GetAllMarkedMetaFile());
//STRIP001 
//STRIP001 					aSymbolGraphic=Graphic(aMeta);
//STRIP001 					aSymbolSize=pObj->GetSnapRect().GetSize();
//STRIP001 					aSymbolGraphic.SetPrefSize(aSymbolSize);
//STRIP001 					aSymbolGraphic.SetPrefMapMode(MAP_100TH_MM);
//STRIP001 					bPrevSym=TRUE;
//STRIP001 					bEnable=TRUE;
//STRIP001 					bIgnoreGraphic=TRUE;
//STRIP001 
//STRIP001 					pView->UnmarkAll();
//STRIP001 					pObj=pPage->RemoveObject(0);
//STRIP001 					if(pObj)
//STRIP001 						delete pObj;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		delete pView;
//STRIP001 		delete pModel;
//STRIP001 	}
//STRIP001 	if(rAttrs.GetItemState(rAttrs.GetPool()->GetWhich(SID_ATTR_BRUSH),TRUE,&pPoolItem) == SFX_ITEM_SET)
//STRIP001 	{
//STRIP001 		SVX_TRACE(213, ByteString( "SVX_SYMBOLTYPE_BRUSH Item for Brush found" ) );
//STRIP001 		const Graphic* pGraphic = ((const SvxBrushItem *)pPoolItem)->GetGraphic();
//STRIP001 		if(!bIgnoreGraphic)
//STRIP001 		{
//STRIP001 			SVX_TRACE(213, ByteString( "SVX_SYMBOLTYPE_BRUSH Item setting Graphic" ) );
//STRIP001 			aSymbolGraphic=*pGraphic;
//STRIP001 		}
//STRIP001 		if(!bIgnoreSize)
//STRIP001 		{
//STRIP001 			SVX_TRACE(213, ByteString( "SVX_SYMBOLTYPE_BRUSH Item setting Size" ) );
//STRIP001 			aSymbolSize=OutputDevice::LogicToLogic( pGraphic->GetPrefSize(),
//STRIP001 													pGraphic->GetPrefMapMode(),
//STRIP001 													MAP_100TH_MM );
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001 			ByteString aStr( "SVX_SYMBOLTYPE_BRUSH Item setting Size: " );
//STRIP001 			aStr.Append( ByteString::CreateFromInt32( aSymbolSize.Width() ) );
//STRIP001 			aStr.Append( ByteString::CreateFromInt32( aSymbolSize.Height() ) );
//STRIP001 			SVX_TRACE( 213, aStr );
//STRIP001 #endif
//STRIP001 		}
//STRIP001 		bPrevSym=TRUE;
//STRIP001 	}
//STRIP001 	if(rAttrs.GetItemState(rAttrs.GetPool()->GetWhich(SID_ATTR_SYMBOLSIZE),TRUE,&pPoolItem) == SFX_ITEM_SET)
//STRIP001 	{
//STRIP001 		aSymbolSize = ((const SvxSizeItem *)pPoolItem)->GetSize();
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	aSymbolRatioCB.Enable(bEnable);
//STRIP001 	aSymbolHeightFT.Enable(bEnable);
//STRIP001 	aSymbolWidthFT.Enable(bEnable);
//STRIP001 	aSymbolWidthMF.Enable(bEnable);
//STRIP001 	aSymbolHeightMF.Enable(bEnable);
//STRIP001 	if(bPrevSym)
//STRIP001 	{
//STRIP001 		SetMetricValue(aSymbolWidthMF,  aSymbolSize.Width(), ePoolUnit);
//STRIP001 		SetMetricValue(aSymbolHeightMF, aSymbolSize.Height(),ePoolUnit);
//STRIP001 		aCtlPreview.SetSymbol(&aSymbolGraphic,aSymbolSize);
//STRIP001 		aSymbolLastSize=aSymbolSize;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( rAttrs.GetItemState( XATTR_LINESTYLE ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		eXLS = (XLineStyle) ( ( const XLineStyleItem& ) rAttrs.Get( XATTR_LINESTYLE ) ).GetValue();
//STRIP001 
//STRIP001 		switch( eXLS )
//STRIP001 		{
//STRIP001 			case XLINE_NONE:
//STRIP001 				aLbLineStyle.SelectEntryPos( 0 );
//STRIP001 				break;
//STRIP001 			case XLINE_SOLID:
//STRIP001 				aLbLineStyle.SelectEntryPos( 1 );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case XLINE_DASH:
//STRIP001 				aLbLineStyle.SetNoSelection();
//STRIP001 				aLbLineStyle.SelectEntry( ( ( const XLineDashItem& ) rAttrs.
//STRIP001 								Get( XATTR_LINEDASH ) ).GetName() );
//STRIP001 				break;
//STRIP001 
//STRIP001 			default:
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aLbLineStyle.SetNoSelection();
//STRIP001 	}
//STRIP001 
//STRIP001 	// Linienstaerke
//STRIP001 /*
//STRIP001 	if( bObjSelected &&
//STRIP001 		rAttrs.GetItemState( GetWhich( XATTR_LINEWIDTH ) ) == SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		aMtrLineWidth.Disable();
//STRIP001 	}
//STRIP001 */
//STRIP001 	if( rAttrs.GetItemState( XATTR_LINEWIDTH ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		SetMetricValue( aMtrLineWidth, ( ( const XLineWidthItem& ) rAttrs.
//STRIP001 							Get( XATTR_LINEWIDTH ) ).GetValue(), ePoolUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aMtrLineWidth.SetText( String() );
//STRIP001 
//STRIP001 	// Linienfarbe
//STRIP001 /*
//STRIP001 	if( bObjSelected &&
//STRIP001 		rAttrs.GetItemState( GetWhich( XATTR_LINECOLOR ) ) == SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		aLbColor.Disable();
//STRIP001 	}
//STRIP001 */
//STRIP001 	aLbColor.SetNoSelection();
//STRIP001 
//STRIP001 	if ( rAttrs.GetItemState( XATTR_LINECOLOR ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		Color aCol = ( ( const XLineColorItem& ) rAttrs.Get( XATTR_LINECOLOR ) ).GetValue();
//STRIP001 		aLbColor.SelectEntry( aCol );
//STRIP001 		if( aLbColor.GetSelectEntryCount() == 0 )
//STRIP001 		{
//STRIP001 			aLbColor.InsertEntry( aCol, String() );
//STRIP001 			aLbColor.SelectEntry( aCol );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// LinienAnfang
//STRIP001 	if( bObjSelected &&
//STRIP001 		rAttrs.GetItemState( XATTR_LINESTART ) == SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		aLbStartStyle.Disable();
//STRIP001 	}
//STRIP001 	else if( rAttrs.GetItemState( XATTR_LINESTART ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		// #86265# select entry using list and polygon, not string
//STRIP001 		sal_Bool bSelected(FALSE);
//STRIP001 		const XPolygon& rItemPolygon = ((const XLineStartItem&)rAttrs.Get(XATTR_LINESTART)).GetValue();
//STRIP001 
//STRIP001 		for(sal_Int32 a(0);!bSelected &&  a < pLineEndList->Count(); a++)
//STRIP001 		{
//STRIP001 			XLineEndEntry* pEntry = pLineEndList->Get(a);
//STRIP001 			const XPolygon& rEntryPolygon = pEntry->GetLineEnd();
//STRIP001 
//STRIP001 			if(rItemPolygon == rEntryPolygon)
//STRIP001 			{
//STRIP001 				// select this entry
//STRIP001 				aLbStartStyle.SelectEntryPos(a + 1);
//STRIP001 				bSelected = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if(!bSelected)
//STRIP001 			aLbStartStyle.SelectEntryPos( 0 );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aLbStartStyle.SetNoSelection();
//STRIP001 	}
//STRIP001 
//STRIP001 	// LinienEnde
//STRIP001 	if( bObjSelected &&
//STRIP001 		rAttrs.GetItemState( XATTR_LINEEND ) == SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		aLbEndStyle.Disable();
//STRIP001 	}
//STRIP001 	else if( rAttrs.GetItemState( XATTR_LINEEND ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		// #86265# select entry using list and polygon, not string
//STRIP001 		sal_Bool bSelected(FALSE);
//STRIP001 		const XPolygon& rItemPolygon = ((const XLineEndItem&)rAttrs.Get(XATTR_LINEEND)).GetValue();
//STRIP001 
//STRIP001 		for(sal_Int32 a(0);!bSelected &&  a < pLineEndList->Count(); a++)
//STRIP001 		{
//STRIP001 			XLineEndEntry* pEntry = pLineEndList->Get(a);
//STRIP001 			const XPolygon& rEntryPolygon = pEntry->GetLineEnd();
//STRIP001 
//STRIP001 			if(rItemPolygon == rEntryPolygon)
//STRIP001 			{
//STRIP001 				// select this entry
//STRIP001 				aLbEndStyle.SelectEntryPos(a + 1);
//STRIP001 				bSelected = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if(!bSelected)
//STRIP001 			aLbEndStyle.SelectEntryPos( 0 );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aLbEndStyle.SetNoSelection();
//STRIP001 	}
//STRIP001 
//STRIP001 	// LinienAnfang St"arke
//STRIP001 	if( bObjSelected &&
//STRIP001 		rAttrs.GetItemState( XATTR_LINESTARTWIDTH ) == SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		aMtrStartWidth.Disable();
//STRIP001 	}
//STRIP001 	else if( rAttrs.GetItemState( XATTR_LINESTARTWIDTH ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		SetMetricValue( aMtrStartWidth, ( ( const XLineStartWidthItem& ) rAttrs.
//STRIP001 							Get( XATTR_LINESTARTWIDTH ) ).GetValue(), ePoolUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aMtrStartWidth.SetText( String() );
//STRIP001 
//STRIP001 	// LinienEnde St"arke
//STRIP001 	if( bObjSelected &&
//STRIP001 		rAttrs.GetItemState( XATTR_LINEENDWIDTH ) == SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		aMtrEndWidth.Disable();
//STRIP001 	}
//STRIP001 	else if( rAttrs.GetItemState( XATTR_LINEENDWIDTH ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		SetMetricValue( aMtrEndWidth, ( ( const XLineEndWidthItem& ) rAttrs.
//STRIP001 							Get( XATTR_LINEENDWIDTH ) ).GetValue(), ePoolUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aMtrEndWidth.SetText( String() );
//STRIP001 
//STRIP001 	// Linienenden zentriert (Start)
//STRIP001 	if( bObjSelected &&
//STRIP001 		rAttrs.GetItemState( XATTR_LINESTARTCENTER ) == SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		aTsbCenterStart.Disable();
//STRIP001 	}
//STRIP001 	else if( rAttrs.GetItemState( XATTR_LINESTARTCENTER ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		aTsbCenterStart.EnableTriState( FALSE );
//STRIP001 
//STRIP001 		if( ( ( const XLineStartCenterItem& ) rAttrs.Get( XATTR_LINESTARTCENTER ) ).GetValue() )
//STRIP001 			aTsbCenterStart.SetState( STATE_CHECK );
//STRIP001 		else
//STRIP001 			aTsbCenterStart.SetState( STATE_NOCHECK );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aTsbCenterStart.SetState( STATE_DONTKNOW );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Linienenden zentriert (Ende)
//STRIP001 	if( bObjSelected &&
//STRIP001 		rAttrs.GetItemState( XATTR_LINEENDCENTER ) == SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		aTsbCenterEnd.Disable();
//STRIP001 	}
//STRIP001 	else if( rAttrs.GetItemState( XATTR_LINEENDCENTER ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		aTsbCenterEnd.EnableTriState( FALSE );
//STRIP001 
//STRIP001 		if( ( ( const XLineEndCenterItem& ) rAttrs.Get( XATTR_LINEENDCENTER ) ).GetValue() )
//STRIP001 			aTsbCenterEnd.SetState( STATE_CHECK );
//STRIP001 		else
//STRIP001 			aTsbCenterEnd.SetState( STATE_NOCHECK );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aTsbCenterEnd.SetState( STATE_DONTKNOW );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Transparenz
//STRIP001 	if( rAttrs.GetItemState( XATTR_LINETRANSPARENCE ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		USHORT nTransp = ( ( const XLineTransparenceItem& ) rAttrs.
//STRIP001 								Get( XATTR_LINETRANSPARENCE ) ).GetValue();
//STRIP001 		aMtrTransparent.SetValue( nTransp );
//STRIP001 		ChangeTransparentHdl_Impl( NULL );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aMtrTransparent.SetText( String() );
//STRIP001 
//STRIP001 	if( !aLbStartStyle.IsEnabled()	&&
//STRIP001 		!aLbEndStyle.IsEnabled()	&&
//STRIP001 		!aMtrStartWidth.IsEnabled() &&
//STRIP001 		!aMtrEndWidth.IsEnabled()	&&
//STRIP001 		!aTsbCenterStart.IsEnabled()&&
//STRIP001 		!aTsbCenterEnd.IsEnabled() )
//STRIP001 	{
//STRIP001 		aCbxSynchronize.Disable();
//STRIP001 		aFtLineEndsStyle.Disable();
//STRIP001 		aFtLineEndsWidth.Disable();
//STRIP001 		aFlLineEnds.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	// Synchronisieren
//STRIP001 	// Jetzt wird der Wert aus der INI-Datei geholt (#42258#)
//STRIP001 	String aStr = GetUserData();
//STRIP001 	aCbxSynchronize.Check( (BOOL)aStr.ToInt32() );
//STRIP001 
//STRIP001 	/*
//STRIP001 	if( aLbStartStyle.GetSelectEntryPos() == aLbEndStyle.GetSelectEntryPos() &&
//STRIP001 		aMtrStartWidth.GetValue() == aMtrEndWidth.GetValue() &&
//STRIP001 		aTsbCenterStart.GetState() == aTsbCenterEnd.GetState() )
//STRIP001 	{
//STRIP001 		aCbxSynchronize.Check();
//STRIP001 	}
//STRIP001 	*/
//STRIP001 
//STRIP001 	// Werte sichern
//STRIP001 	aLbLineStyle.SaveValue();
//STRIP001 	aMtrLineWidth.SaveValue();
//STRIP001 	aLbColor.SaveValue();
//STRIP001 	aLbStartStyle.SaveValue();
//STRIP001 	aLbEndStyle.SaveValue();
//STRIP001 	aMtrStartWidth.SaveValue();
//STRIP001 	aMtrEndWidth.SaveValue();
//STRIP001 	aTsbCenterStart.SaveValue();
//STRIP001 	aTsbCenterEnd.SaveValue();
//STRIP001 	aMtrTransparent.SaveValue();
//STRIP001 
//STRIP001 
//STRIP001 	ClickInvisibleHdl_Impl( this );
//STRIP001 	//ClickMeasuringHdl_Impl( this );
//STRIP001 	//aCtlPosition.Reset();
//STRIP001 
//STRIP001 	ChangePreviewHdl_Impl( NULL );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SvxLineTabPage::Create( Window* pWindow,
//STRIP001 				const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	return( new SvxLineTabPage( pWindow, rAttrs ) );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT*	SvxLineTabPage::GetRanges()
//STRIP001 {
//STRIP001 	return( pLineRanges );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxLineTabPage, ChangePreviewHdl_Impl, void *, pCntrl )
//STRIP001 {
//STRIP001 	if(pCntrl == &aMtrLineWidth)
//STRIP001 	{
//STRIP001 		// Linienbreite und Start/EndBreite
//STRIP001 		INT32 nNewLineWidth = GetCoreValue( aMtrLineWidth, ePoolUnit );
//STRIP001 		if(nActLineWidth == -1)
//STRIP001 		{
//STRIP001 			// Noch nicht initialisiert, hole den Startwert
//STRIP001 			const SfxPoolItem* pOld = GetOldItem( rXLSet, XATTR_LINEWIDTH );
//STRIP001 			INT32 nStartLineWidth = 0;
//STRIP001 			if(pOld)
//STRIP001 				nStartLineWidth = (( const XLineWidthItem *)pOld)->GetValue();
//STRIP001 			nActLineWidth = nStartLineWidth;
//STRIP001 		}
//STRIP001 
//STRIP001 		if(nActLineWidth != nNewLineWidth)
//STRIP001 		{
//STRIP001 			// Anpassungen Start/EndWidth #63083#
//STRIP001 			INT32 nValAct = GetCoreValue( aMtrStartWidth, ePoolUnit );
//STRIP001 			INT32 nValNew = nValAct + (((nNewLineWidth - nActLineWidth) * 15) / 10);
//STRIP001 			if(nValNew < 0)
//STRIP001 				nValNew = 0;
//STRIP001 			SetMetricValue( aMtrStartWidth, nValNew, ePoolUnit );
//STRIP001 
//STRIP001 			nValAct = GetCoreValue( aMtrEndWidth, ePoolUnit );
//STRIP001 			nValNew = nValAct + (((nNewLineWidth - nActLineWidth) * 15) / 10);
//STRIP001 			if(nValNew < 0)
//STRIP001 				nValNew = 0;
//STRIP001 			SetMetricValue( aMtrEndWidth, nValNew, ePoolUnit );
//STRIP001 		}
//STRIP001 
//STRIP001 		// Aktuellen Wert merken
//STRIP001 		nActLineWidth = nNewLineWidth;
//STRIP001 	}
//STRIP001 
//STRIP001 	FillXLSet_Impl();
//STRIP001 	aCtlPreview.Invalidate();
//STRIP001 
//STRIP001 	// Transparenz entspr. zugaenglich machen
//STRIP001 	if( aLbLineStyle.GetSelectEntryPos() == 0 ) // unsichtbar
//STRIP001 	{
//STRIP001 		aFtTransparent.Disable();
//STRIP001 		aMtrTransparent.Disable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aFtTransparent.Enable();
//STRIP001 		aMtrTransparent.Enable();
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxLineTabPage, ChangeStartHdl_Impl, void *, p )
//STRIP001 {
//STRIP001 	if( aCbxSynchronize.IsChecked() )
//STRIP001 	{
//STRIP001 		if( p == &aMtrStartWidth )
//STRIP001 			aMtrEndWidth.SetValue( aMtrStartWidth.GetValue() );
//STRIP001 		if( p == &aLbStartStyle )
//STRIP001 			aLbEndStyle.SelectEntryPos( aLbStartStyle.GetSelectEntryPos() );
//STRIP001 		if( p == &aTsbCenterStart )
//STRIP001 			aTsbCenterEnd.SetState( aTsbCenterStart.GetState() );
//STRIP001 	}
//STRIP001 
//STRIP001 	ChangePreviewHdl_Impl( this );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxLineTabPage, ChangeEndHdl_Impl, void *, p )
//STRIP001 {
//STRIP001 	if( aCbxSynchronize.IsChecked() )
//STRIP001 	{
//STRIP001 		if( p == &aMtrEndWidth )
//STRIP001 			aMtrStartWidth.SetValue( aMtrEndWidth.GetValue() );
//STRIP001 		if( p == &aLbEndStyle )
//STRIP001 			aLbStartStyle.SelectEntryPos( aLbEndStyle.GetSelectEntryPos() );
//STRIP001 		if( p == &aTsbCenterEnd )
//STRIP001 			aTsbCenterStart.SetState( aTsbCenterEnd.GetState() );
//STRIP001 	}
//STRIP001 
//STRIP001 	ChangePreviewHdl_Impl( this );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxLineTabPage, ClickInvisibleHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	if( aLbLineStyle.GetSelectEntryPos() == 0 ) // unsichtbar
//STRIP001 	{
//STRIP001 		aFtColor.Disable();
//STRIP001 		aLbColor.Disable();
//STRIP001 		aFtLineWidth.Disable();
//STRIP001 		aMtrLineWidth.Disable();
//STRIP001 
//STRIP001 		if( aFlLineEnds.IsEnabled() )
//STRIP001 		{
//STRIP001 			aFtLineEndsStyle.Disable();
//STRIP001 			aFtLineEndsWidth.Disable();
//STRIP001 			aLbStartStyle.Disable();
//STRIP001 			aMtrStartWidth.Disable();
//STRIP001 			aTsbCenterStart.Disable();
//STRIP001 			aLbEndStyle.Disable();
//STRIP001 			aMtrEndWidth.Disable();
//STRIP001 			aTsbCenterEnd.Disable();
//STRIP001 			aCbxSynchronize.Disable();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aFtColor.Enable();
//STRIP001 		aLbColor.Enable();
//STRIP001 		aFtLineWidth.Enable();
//STRIP001 		aMtrLineWidth.Enable();
//STRIP001 
//STRIP001 		if( aFlLineEnds.IsEnabled() )
//STRIP001 		{
//STRIP001 			aFtLineEndsStyle.Enable();
//STRIP001 			aFtLineEndsWidth.Enable();
//STRIP001 			aLbStartStyle.Enable();
//STRIP001 			aMtrStartWidth.Enable();
//STRIP001 			aTsbCenterStart.Enable();
//STRIP001 			aLbEndStyle.Enable();
//STRIP001 			aMtrEndWidth.Enable();
//STRIP001 			aTsbCenterEnd.Enable();
//STRIP001 			aCbxSynchronize.Enable();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	ChangePreviewHdl_Impl( NULL );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 /*
//STRIP001 
//STRIP001 long SvxLineTabPage::ClickMeasuringHdl_Impl( void* )
//STRIP001 {
//STRIP001 	if( aTsbShowMeasuring.GetState() == STATE_NOCHECK )
//STRIP001 	{
//STRIP001 		aFtPosition.Disable();
//STRIP001 		aCtlPosition.Disable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aFtPosition.Enable();
//STRIP001 		aCtlPosition.Enable();
//STRIP001 	}
//STRIP001 	aCtlPosition.Invalidate();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 */
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxLineTabPage, ChangeTransparentHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	UINT16 nVal = (UINT16)aMtrTransparent.GetValue();
//STRIP001 	XLineTransparenceItem aItem( nVal );
//STRIP001 
//STRIP001 	rXLSet.Put( XLineTransparenceItem( aItem ) );
//STRIP001 	XOut.SetLineAttr( aXLineAttr.GetItemSet() );
//STRIP001 
//STRIP001 	aCtlPreview.Invalidate();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxLineTabPage::PointChanged( Window* pWindow, RECT_POINT eRcPt )
//STRIP001 {
//STRIP001 	eRP = eRcPt;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxLineTabPage::FillUserData()
//STRIP001 {
//STRIP001 	// Abgleich wird in der Ini-Datei festgehalten
//STRIP001 	UniString aStrUserData = UniString::CreateFromInt32( (sal_Int32) aCbxSynchronize.IsChecked() );
//STRIP001 	SetUserData( aStrUserData );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 //#58425# Symbole auf einer Linie (z.B. StarChart)
//STRIP001 //Handler fr Popup-Menue der Symbolauswahl (NumMenueButton)
//STRIP001 //der folgende Link stammt urspruenglich aus SvxNumOptionsTabPage
//STRIP001 IMPL_LINK( SvxLineTabPage, MenuCreateHdl_Impl, MenuButton *, pButton )
//STRIP001 {
//STRIP001 	//Popup initialisieren
//STRIP001 	if(!pButton->GetPopupMenu()->GetPopupMenu( MN_GALLERY ))
//STRIP001 	{
//STRIP001 		// Gallery-Eintraege besorgen
//STRIP001 		GalleryExplorer::FillObjList(GALLERY_THEME_BULLETS, aGrfNames);
//STRIP001 
//STRIP001 		PopupMenu* pPopup = new PopupMenu;
//STRIP001 		String aEmptyStr;
//STRIP001 		SfxObjectShell *pDocSh = SfxObjectShell::Current();
//STRIP001 
//STRIP001 		nNumMenuGalleryItems=aGrfNames.Count();
//STRIP001 		for(long i = 0; i < nNumMenuGalleryItems; i++)
//STRIP001 		{
//STRIP001             const String* pGrfName = (const String*)aGrfNames.GetObject(i);
//STRIP001             const String* pUIName = pGrfName;
//STRIP001 
//STRIP001             // convert URL encodings to UI characters (eg %20 for spaces)
//STRIP001             String aPhysicalName;
//STRIP001             if( ::utl::LocalFileHelper::ConvertURLToPhysicalName( *pGrfName, aPhysicalName ))
//STRIP001                 pUIName = &aPhysicalName;
//STRIP001 
//STRIP001 			SvxBrushItem* pBrushItem = new SvxBrushItem(*pGrfName, aEmptyStr, GPOS_AREA);
//STRIP001 			pBrushItem->SetDoneLink(STATIC_LINK(this, SvxLineTabPage, GraphicArrivedHdl_Impl));
//STRIP001 
//STRIP001 			SvxBmpItemInfo* pInfo = new SvxBmpItemInfo();
//STRIP001 			pInfo->pBrushItem = pBrushItem;
//STRIP001 			pInfo->nItemId = (UINT16)(MN_GALLERY_ENTRY + i);
//STRIP001 			aGrfBrushItems.Insert(pInfo, i);
//STRIP001 			const Graphic* pGraphic = pBrushItem->GetGraphic(pDocSh);
//STRIP001 
//STRIP001 			if(pGraphic)
//STRIP001 			{
//STRIP001 				Bitmap aBitmap(pGraphic->GetBitmap());
//STRIP001 				Size aSize(aBitmap.GetSizePixel());
//STRIP001 				if(aSize.Width()  > MAX_BMP_WIDTH ||
//STRIP001 				   aSize.Height() > MAX_BMP_HEIGHT)
//STRIP001 				{
//STRIP001 					BOOL bWidth = aSize.Width() > aSize.Height();
//STRIP001 					double nScale = bWidth ?
//STRIP001 										(double)MAX_BMP_WIDTH / (double)aSize.Width():
//STRIP001 										(double)MAX_BMP_HEIGHT / (double)aSize.Height();
//STRIP001 					aBitmap.Scale(nScale, nScale);
//STRIP001 
//STRIP001 				}
//STRIP001 				Image aImage(aBitmap);
//STRIP001 				pPopup->InsertItem(pInfo->nItemId, *pUIName, aImage );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				Image aImage;
//STRIP001 				pPopup->InsertItem(pInfo->nItemId, *pUIName, aImage );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		aSymbolMB.GetPopupMenu()->SetPopupMenu( MN_GALLERY, pPopup );
//STRIP001 		if(!aGrfNames.Count())
//STRIP001 			aSymbolMB.GetPopupMenu()->EnableItem(MN_GALLERY, FALSE);
//STRIP001 	}
//STRIP001 
//STRIP001 	if(!pButton->GetPopupMenu()->GetPopupMenu( MN_SYMBOLS ) && pSymbolList)
//STRIP001 	{
//STRIP001 		VirtualDevice aVDev;
//STRIP001 		aVDev.SetMapMode(MapMode(MAP_100TH_MM));
//STRIP001 
//STRIP001 		SdrModel* pModel = new SdrModel(NULL, NULL, LOADREFCOUNTS);
//STRIP001 		pModel->GetItemPool().FreezeIdRanges();
//STRIP001 		// Page
//STRIP001 		SdrPage* pPage = new SdrPage( *pModel, FALSE );
//STRIP001 		pPage->SetSize(Size(1000,1000));
//STRIP001 		pModel->InsertPage( pPage, 0 );
//STRIP001 		// 3D View
//STRIP001 		SdrView* pView = new SdrView( pModel, &aVDev );
//STRIP001 		pView->SetMarkHdlHidden( TRUE );
//STRIP001 		SdrPageView* pPageView = pView->ShowPage(pPage, Point());
//STRIP001 
//STRIP001 		PopupMenu* pPopup = new PopupMenu;
//STRIP001 		String aEmptyStr;
//STRIP001 		SfxObjectShell *pDocSh = SfxObjectShell::Current();
//STRIP001 		SdrObject *pObj=NULL;
//STRIP001 		long i=0;
//STRIP001 		while(pObj=pSymbolList->GetObj(i))
//STRIP001 		{
//STRIP001 			pObj=pObj->Clone();
//STRIP001 			//const String* pGrfName = (const String*)aGrfNames.GetObject(i);
//STRIP001 			String *pStr=new String();//String(i));
//STRIP001 			aGrfNames.Insert(pStr,LIST_APPEND);
//STRIP001 			//Rectangle aRect(pObj->GetLogicRect());
//STRIP001 			pPage->NbcInsertObject(pObj);
//STRIP001 			pView->MarkObj(pObj,pPageView);
//STRIP001 			if(pSymbolAttr)
//STRIP001 			{
//STRIP001 //-/				pObj->NbcSetAttributes(*pSymbolAttr,FALSE);
//STRIP001 				pObj->SetItemSet(*pSymbolAttr);
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 //-/				pObj->NbcSetAttributes(rOutAttrs,FALSE);
//STRIP001 				pObj->SetItemSet(rOutAttrs);
//STRIP001 			}
//STRIP001 
//STRIP001 			Bitmap aBitmap(pView->GetAllMarkedBitmap());
//STRIP001 			GDIMetaFile aMeta(pView->GetAllMarkedMetaFile());
//STRIP001 			pView->UnmarkAll();
//STRIP001 			pObj=pPage->RemoveObject(0);
//STRIP001 			if(pObj)
//STRIP001 				delete pObj;
//STRIP001 
//STRIP001 			SvxBrushItem* pBrushItem = new SvxBrushItem(Graphic(aMeta), GPOS_AREA);
//STRIP001 			pBrushItem->SetDoneLink(STATIC_LINK(this, SvxLineTabPage, GraphicArrivedHdl_Impl));
//STRIP001 
//STRIP001 			SvxBmpItemInfo* pInfo = new SvxBmpItemInfo();
//STRIP001 			pInfo->pBrushItem = pBrushItem;
//STRIP001 			pInfo->nItemId = (UINT16)(MN_GALLERY_ENTRY + i + nNumMenuGalleryItems);
//STRIP001 			aGrfBrushItems.Insert(pInfo, nNumMenuGalleryItems + i);
//STRIP001 
//STRIP001 			Size aSize(aBitmap.GetSizePixel());
//STRIP001 			if(aSize.Width() > MAX_BMP_WIDTH || aSize.Height() > MAX_BMP_HEIGHT)
//STRIP001 			{
//STRIP001 				BOOL bWidth = aSize.Width() > aSize.Height();
//STRIP001 				double nScale = bWidth ?
//STRIP001 									(double)MAX_BMP_WIDTH / (double)aSize.Width():
//STRIP001 									(double)MAX_BMP_HEIGHT / (double)aSize.Height();
//STRIP001 				aBitmap.Scale(nScale, nScale);
//STRIP001 			}
//STRIP001 			Image aImage(aBitmap);
//STRIP001 			pPopup->InsertItem(pInfo->nItemId,*pStr,aImage);
//STRIP001 			i++;
//STRIP001 		}
//STRIP001 		aSymbolMB.GetPopupMenu()->SetPopupMenu( MN_SYMBOLS, pPopup );
//STRIP001 		if(!aGrfNames.Count())
//STRIP001 			aSymbolMB.GetPopupMenu()->EnableItem(MN_SYMBOLS, FALSE);
//STRIP001 
//STRIP001 		delete pView;
//STRIP001 		delete pModel;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 //#58425# Symbole auf einer Linie (z.B. StarChart)
//STRIP001 //Handler fr Popup-Menue der Symbolauswahl (NumMenueButton)
//STRIP001 //der folgende Link stammt urspruenglich aus SvxNumOptionsTabPage:
//STRIP001 IMPL_STATIC_LINK(SvxLineTabPage, GraphicArrivedHdl_Impl, SvxBrushItem*, pItem)
//STRIP001 {
//STRIP001 	PopupMenu* pPopup = pThis->aSymbolMB.GetPopupMenu()->GetPopupMenu( MN_GALLERY );
//STRIP001 
//STRIP001 	SvxBmpItemInfo* pBmpInfo = 0;
//STRIP001 	for ( USHORT i = 0; i < pThis->aGrfBrushItems.Count(); i++ )
//STRIP001 	{
//STRIP001 		SvxBmpItemInfo* pInfo = (SvxBmpItemInfo*)pThis->aGrfBrushItems.GetObject(i);
//STRIP001 		if( pInfo->pBrushItem == pItem )
//STRIP001 		{
//STRIP001 			pBmpInfo = pInfo; break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if( pBmpInfo )
//STRIP001 	{
//STRIP001         if( pItem->GetGraphic() )
//STRIP001         {
//STRIP001             Bitmap aBitmap(pItem->GetGraphic()->GetBitmap());
//STRIP001             Size aSize(aBitmap.GetSizePixel());
//STRIP001             if(aSize.Width()  > MAX_BMP_WIDTH ||
//STRIP001                aSize.Height() > MAX_BMP_HEIGHT)
//STRIP001             {
//STRIP001                 BOOL bWidth = aSize.Width() > aSize.Height();
//STRIP001                 double nScale = bWidth ?
//STRIP001                     (double)MAX_BMP_WIDTH / (double)aSize.Width():
//STRIP001                     (double)MAX_BMP_HEIGHT / (double)aSize.Height();
//STRIP001                 aBitmap.Scale(nScale, nScale);
//STRIP001             }
//STRIP001             Image aImage(aBitmap);
//STRIP001             pPopup->SetItemImage( pBmpInfo->nItemId, aImage );
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //#58425# Symbole auf einer Linie (z.B. StarChart)
//STRIP001 //Handler fr Menuebutton
//STRIP001 IMPL_LINK( SvxLineTabPage, GraphicHdl_Impl, MenuButton *, pButton )
//STRIP001 {
//STRIP001 	USHORT nItemId = pButton->GetCurItemId();
//STRIP001 	const Graphic* pGraphic = 0;
//STRIP001 	Graphic aGraphic;
//STRIP001 	String aGrfName;
//STRIP001 	BOOL bDontSetSize=FALSE;
//STRIP001 	BOOL bEnable=TRUE;
//STRIP001 
//STRIP001 	if(nItemId >= MN_GALLERY_ENTRY)
//STRIP001 	{
//STRIP001 		if( (nItemId-MN_GALLERY_ENTRY) >= nNumMenuGalleryItems)
//STRIP001 		{
//STRIP001 			nSymbolType=nItemId-MN_GALLERY_ENTRY-nNumMenuGalleryItems; //Index der Liste
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001 			ByteString aStr( "SVX_SYMBOLTYPE = " );
//STRIP001 			aStr.Append( ByteString::CreateFromInt32( nSymbolType ) );
//STRIP001 			SVX_TRACE(213, aStr);
//STRIP001 #endif
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SVX_TRACE(213,ByteString( "SVX_SYMBOLTYPE_BRUSHITEM") );
//STRIP001 			nSymbolType=SVX_SYMBOLTYPE_BRUSHITEM;
//STRIP001 		}
//STRIP001 		SvxBmpItemInfo* pInfo = (SvxBmpItemInfo*)aGrfBrushItems.GetObject(nItemId - MN_GALLERY_ENTRY);
//STRIP001 		pGraphic = pInfo->pBrushItem->GetGraphic();
//STRIP001 	}
//STRIP001 	else switch(nItemId)
//STRIP001 	{
//STRIP001 		case MN_SYMBOLS_AUTO:
//STRIP001 		{
//STRIP001 			pGraphic=&aAutoSymbolGraphic;
//STRIP001 			aSymbolSize=aAutoSymbolGraphic.GetPrefSize();
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001 			ByteString aStr( "AutoSymbolSize is ");
//STRIP001 			aStr.Append( ByteString::CreateFromInt32( aSymbolSize.Width() ) );
//STRIP001 			aStr.Append( ' ' );
//STRIP001 			aStr.Append( ByteString::CreateFromInt32( aSymbolSize.Height() ) );
//STRIP001 			SVX_TRACE(213, aStr );
//STRIP001 #endif
//STRIP001 			bDontSetSize=TRUE;
//STRIP001 			bNewSize=FALSE; //frhere nderungen gelten nicht in diesem Fall!
//STRIP001 			nSymbolType=SVX_SYMBOLTYPE_AUTO;
//STRIP001 			bEnable=FALSE;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case MN_SYMBOLS_NONE:
//STRIP001 		{
//STRIP001 			SVX_TRACE(213,ByteString( "SVX_SYMBOLTYPE_NONE" ) );
//STRIP001 			nSymbolType=SVX_SYMBOLTYPE_NONE;
//STRIP001 			pGraphic=NULL;
//STRIP001 			bEnable=FALSE;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		default:
//STRIP001 		{
//STRIP001 			SVX_TRACE(213,ByteString( "SVX_SYMBOLTYPE_ Brush lesen, wird aus Datei generiert" ) );
//STRIP001 			nSymbolType=SVX_SYMBOLTYPE_BRUSHITEM;//wie Gallery, Graphic ist im Item enthalten
//STRIP001 			SvxOpenGraphicDialog aGrfDlg(SVX_RES(RID_STR_EDIT_GRAPHIC));
//STRIP001 			aGrfDlg.EnableLink(sal_False);
//STRIP001 			aGrfDlg.AsLink(sal_False);
//STRIP001 			if( !aGrfDlg.Execute() )
//STRIP001 			{
//STRIP001 				// ausgewaehlten Filter merken
//STRIP001 				aGrfName = aGrfDlg.GetPath();
//STRIP001 				if( !aGrfDlg.GetGraphic(aGraphic) )
//STRIP001 					pGraphic = &aGraphic;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if(pGraphic)
//STRIP001 	{
//STRIP001 		Size aSize = SvxNumberFormat::GetGraphicSizeMM100(pGraphic);
//STRIP001 		aSize = OutputDevice::LogicToLogic(aSize, MAP_100TH_MM, (MapUnit)ePoolUnit);
//STRIP001 		aSymbolGraphic=*pGraphic;
//STRIP001 		if(!bDontSetSize)
//STRIP001 		{
//STRIP001 			aSymbolSize=aSize;
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001 			ByteString aStr( "SymbolSize changed to " );
//STRIP001 			aStr.Append( ByteString::CreateFromInt32( aSize.Width() ) );
//STRIP001 			aStr.Append( ' ' );
//STRIP001 			aStr.Append( ByteString::CreateFromInt32( aSize.Height() ) );
//STRIP001 			SVX_TRACE(213, aStr );
//STRIP001 #endif
//STRIP001 		}
//STRIP001 		aCtlPreview.SetSymbol(&aSymbolGraphic,aSymbolSize);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aSymbolGraphic=Graphic();
//STRIP001 		SVX_TRACE(213, ByteString( "setting empty graphic" ) );
//STRIP001 		if(!bDontSetSize)
//STRIP001 		{
//STRIP001 			SVX_TRACE(213, ByteString( "Size set to 0,0" ) );
//STRIP001 			aSymbolSize=Size(0,0);
//STRIP001 		}
//STRIP001 		aCtlPreview.SetSymbol(NULL,aSymbolSize);
//STRIP001 		bEnable=FALSE;
//STRIP001 	}
//STRIP001 	aSymbolLastSize=aSymbolSize;
//STRIP001 	SetMetricValue(aSymbolWidthMF,  aSymbolSize.Width(), ePoolUnit);
//STRIP001 	SetMetricValue(aSymbolHeightMF, aSymbolSize.Height(), ePoolUnit);
//STRIP001 	aSymbolRatioCB.Enable(bEnable);
//STRIP001 	aSymbolHeightFT.Enable(bEnable);
//STRIP001 	aSymbolWidthFT.Enable(bEnable);
//STRIP001 	aSymbolWidthMF.Enable(bEnable);
//STRIP001 	aSymbolHeightMF.Enable(bEnable);
//STRIP001 	aCtlPreview.Invalidate();
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK( SvxLineTabPage, SizeHdl_Impl, MetricField *, pField)
//STRIP001 {
//STRIP001 	bNewSize=TRUE;
//STRIP001 	BOOL bWidth = (BOOL)(pField == &aSymbolWidthMF);
//STRIP001 	bLastWidthModified = bWidth;
//STRIP001 	BOOL bRatio = aSymbolRatioCB.IsChecked();
//STRIP001 	long nWidthVal = aSymbolWidthMF.Denormalize(aSymbolWidthMF.GetValue(FUNIT_100TH_MM));
//STRIP001 	long nHeightVal= aSymbolHeightMF.Denormalize(aSymbolHeightMF.GetValue(FUNIT_100TH_MM));
//STRIP001 	nWidthVal = OutputDevice::LogicToLogic(nWidthVal,MAP_100TH_MM,(MapUnit)ePoolUnit );
//STRIP001 	nHeightVal = OutputDevice::LogicToLogic(nHeightVal,MAP_100TH_MM,(MapUnit)ePoolUnit);
//STRIP001 	aSymbolSize=Size(nWidthVal,nHeightVal);
//STRIP001 	double	fSizeRatio;
//STRIP001 
//STRIP001 	if(bRatio)
//STRIP001 	{
//STRIP001 		if (aSymbolLastSize.Height() && aSymbolLastSize.Width())
//STRIP001 			fSizeRatio = (double)aSymbolLastSize.Width() / aSymbolLastSize.Height();
//STRIP001 		else
//STRIP001 			fSizeRatio = (double)1;
//STRIP001 	}
//STRIP001 
//STRIP001 	//Size aSymbolSize(aSymbolLastSize);
//STRIP001 
//STRIP001 	if(bWidth)
//STRIP001 	{
//STRIP001 		long nDelta = nWidthVal - aSymbolLastSize.Width();
//STRIP001 		aSymbolSize.Width() = nWidthVal;
//STRIP001 		if (bRatio)
//STRIP001 		{
//STRIP001 			aSymbolSize.Height() = aSymbolLastSize.Height() + (long)((double)nDelta / fSizeRatio);
//STRIP001 			aSymbolSize.Height() = OutputDevice::LogicToLogic( aSymbolSize.Height(),(MapUnit)ePoolUnit, MAP_100TH_MM );
//STRIP001 			aSymbolHeightMF.SetUserValue(aSymbolHeightMF.Normalize(aSymbolSize.Height()), FUNIT_100TH_MM);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		long nDelta = nHeightVal - aSymbolLastSize.Height();
//STRIP001 		aSymbolSize.Height() = nHeightVal;
//STRIP001 		if (bRatio)
//STRIP001 		{
//STRIP001 			aSymbolSize.Width() = aSymbolLastSize.Width() + (long)((double)nDelta * fSizeRatio);
//STRIP001 			aSymbolSize.Width() = OutputDevice::LogicToLogic( aSymbolSize.Width(),
//STRIP001 								(MapUnit)ePoolUnit, MAP_100TH_MM );
//STRIP001 			aSymbolWidthMF.SetUserValue(aSymbolWidthMF.Normalize(aSymbolSize.Width()), FUNIT_100TH_MM);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	aCtlPreview.ResizeSymbol(aSymbolSize);
//STRIP001 	aSymbolLastSize=aSymbolSize;
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK( SvxLineTabPage, RatioHdl_Impl, CheckBox *, pBox )
//STRIP001 {
//STRIP001 	if (pBox->IsChecked())
//STRIP001 	{
//STRIP001 		if (bLastWidthModified)
//STRIP001 			SizeHdl_Impl(&aSymbolWidthMF);
//STRIP001 		else
//STRIP001 			SizeHdl_Impl(&aSymbolHeightMF);
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SvxLineTabPage::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	SvxTabPage::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001 	{
//STRIP001 		FillListboxes();
//STRIP001 	}
//STRIP001 }

}
