/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_tparea.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:09:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _SFXAPP_HXX
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif
#pragma hdrstop

#define _SVX_TPAREA_CXX

#if defined (MAC) || defined (UNX) || defined (WTC) || defined (ICC) || defined(WNT)
#include <stdlib.h>
#endif

#include "xattr.hxx"
#include "xpool.hxx"
#include "dialogs.hrc"
#include "tabarea.hrc"
#include "dlgname.hrc"

#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE
#define ITEMID_GRADIENT_LIST	SID_GRADIENT_LIST
#define ITEMID_HATCH_LIST		SID_HATCH_LIST
#define ITEMID_BITMAP_LIST		SID_BITMAP_LIST

#include "xflbckit.hxx"

#include "svdattr.hxx"
#include "xoutx.hxx"
#include "xtable.hxx"
#include "xlineit0.hxx"

#include "drawitem.hxx"
#include "tabarea.hxx"
#include "dlgname.hxx"
#include "dialmgr.hxx"
#include "dlgutil.hxx"
namespace binfilter {

//STRIP001 #define DLGWIN this->GetParent()->GetParent()
//STRIP001 
//STRIP001 // static ----------------------------------------------------------------
//STRIP001 
//STRIP001 static USHORT pAreaRanges[] =
//STRIP001 {
//STRIP001 	XATTR_GRADIENTSTEPCOUNT,
//STRIP001 	XATTR_GRADIENTSTEPCOUNT,
//STRIP001 	SID_ATTR_FILL_STYLE,
//STRIP001 	SID_ATTR_FILL_BITMAP,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 static USHORT pTransparenceRanges[] =
//STRIP001 {
//STRIP001 	XATTR_FILLTRANSPARENCE,
//STRIP001 	XATTR_FILLTRANSPARENCE,
//STRIP001 	SDRATTR_SHADOWTRANSPARENCE,
//STRIP001 	SDRATTR_SHADOWTRANSPARENCE,
//STRIP001 	XATTR_FILLFLOATTRANSPARENCE,
//STRIP001 	XATTR_FILLFLOATTRANSPARENCE,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Dialog for transparence
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK(SvxTransparenceTabPage, ClickTransOffHdl_Impl, void *, EMPTYARG)
//STRIP001 {
//STRIP001 	// disable all other controls
//STRIP001 	ActivateLinear(FALSE);
//STRIP001 	ActivateGradient(FALSE);
//STRIP001 
//STRIP001 	// Preview
//STRIP001 	rXFSet.ClearItem (XATTR_FILLTRANSPARENCE);
//STRIP001 	rXFSet.ClearItem (XATTR_FILLFLOATTRANSPARENCE);
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001     XOutBmp.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 
//STRIP001 	InvalidatePreview( FALSE );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK(SvxTransparenceTabPage, ClickTransLinearHdl_Impl, void *, EMPTYARG)
//STRIP001 {
//STRIP001 	// enable linear, disable other
//STRIP001 	ActivateLinear(TRUE);
//STRIP001 	ActivateGradient(FALSE);
//STRIP001 
//STRIP001 	// preview
//STRIP001 	rXFSet.ClearItem (XATTR_FILLFLOATTRANSPARENCE);
//STRIP001 	ModifyTransparentHdl_Impl (NULL);
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK(SvxTransparenceTabPage, ClickTransGradientHdl_Impl, void *, EMPTYARG)
//STRIP001 {
//STRIP001 	// enable gradient, disable other
//STRIP001 	ActivateLinear(FALSE);
//STRIP001 	ActivateGradient(TRUE);
//STRIP001 
//STRIP001 	// preview
//STRIP001 	rXFSet.ClearItem (XATTR_FILLTRANSPARENCE);
//STRIP001 	ModifiedTrgrHdl_Impl (NULL);
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxTransparenceTabPage::ActivateLinear(BOOL bActivate)
//STRIP001 {
//STRIP001 	aMtrTransparent.Enable(bActivate);
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK(SvxTransparenceTabPage, ModifyTransparentHdl_Impl, void*, EMPTYARG)
//STRIP001 {
//STRIP001 	UINT16 nPos = (UINT16)aMtrTransparent.GetValue();
//STRIP001 	XFillTransparenceItem aItem(nPos);
//STRIP001 	rXFSet.Put(XFillTransparenceItem(aItem));
//STRIP001 
//STRIP001 	// preview
//STRIP001 	InvalidatePreview();
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK(SvxTransparenceTabPage, ModifiedTrgrHdl_Impl, void *, pControl)
//STRIP001 {
//STRIP001 	if(pControl == &aLbTrgrGradientType || pControl == this)
//STRIP001 	{
//STRIP001 		XGradientStyle eXGS = (XGradientStyle)aLbTrgrGradientType.GetSelectEntryPos();
//STRIP001 		SetControlState_Impl( eXGS );
//STRIP001 	}
//STRIP001 
//STRIP001 	// preview
//STRIP001 	UINT8 nStartCol = (UINT8)(((UINT16)aMtrTrgrStartValue.GetValue() * 255) / 100);
//STRIP001 	UINT8 nEndCol = (UINT8)(((UINT16)aMtrTrgrEndValue.GetValue() * 255) / 100);
//STRIP001 	XGradient aTmpGradient(
//STRIP001 				Color(nStartCol, nStartCol, nStartCol),
//STRIP001 				Color(nEndCol, nEndCol, nEndCol),
//STRIP001 				(XGradientStyle)aLbTrgrGradientType.GetSelectEntryPos(),
//STRIP001 				(UINT16)aMtrTrgrAngle.GetValue() * 10,
//STRIP001 				(UINT16)aMtrTrgrCenterX.GetValue(),
//STRIP001 				(UINT16)aMtrTrgrCenterY.GetValue(),
//STRIP001 				(UINT16)aMtrTrgrBorder.GetValue(),
//STRIP001 				100, 100);
//STRIP001 
//STRIP001 	String aString;
//STRIP001 	XFillFloatTransparenceItem aItem( rXFSet.GetPool()/*aString*/, aTmpGradient);
//STRIP001 	rXFSet.Put ( aItem );
//STRIP001 
//STRIP001 	InvalidatePreview();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxTransparenceTabPage::ActivateGradient(BOOL bActivate)
//STRIP001 {
//STRIP001 	aFtTrgrType.Enable(bActivate);
//STRIP001 	aLbTrgrGradientType.Enable(bActivate);
//STRIP001 	aFtTrgrCenterX.Enable(bActivate);
//STRIP001 	aMtrTrgrCenterX.Enable(bActivate);
//STRIP001 	aFtTrgrCenterY.Enable(bActivate);
//STRIP001 	aMtrTrgrCenterY.Enable(bActivate);
//STRIP001 	aFtTrgrAngle.Enable(bActivate);
//STRIP001 	aMtrTrgrAngle.Enable(bActivate);
//STRIP001 	aFtTrgrBorder.Enable(bActivate);
//STRIP001 	aMtrTrgrBorder.Enable(bActivate);
//STRIP001 	aFtTrgrStartValue.Enable(bActivate);
//STRIP001 	aMtrTrgrStartValue.Enable(bActivate);
//STRIP001 	aFtTrgrEndValue.Enable(bActivate);
//STRIP001 	aMtrTrgrEndValue.Enable(bActivate);
//STRIP001 
//STRIP001 	if(bActivate)
//STRIP001 	{
//STRIP001 		XGradientStyle eXGS = (XGradientStyle)aLbTrgrGradientType.GetSelectEntryPos();
//STRIP001 		SetControlState_Impl( eXGS );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK(SvxTransparenceTabPage, ChangeTrgrTypeHdl_Impl, void *, EMPTYARG)
//STRIP001 {
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxTransparenceTabPage::SetControlState_Impl(XGradientStyle eXGS)
//STRIP001 {
//STRIP001 	switch(eXGS)
//STRIP001 	{
//STRIP001 		case XGRAD_LINEAR:
//STRIP001 		case XGRAD_AXIAL:
//STRIP001 			aFtTrgrCenterX.Disable();
//STRIP001 			aMtrTrgrCenterX.Disable();
//STRIP001 			aFtTrgrCenterY.Disable();
//STRIP001 			aMtrTrgrCenterY.Disable();
//STRIP001 			aFtTrgrAngle.Enable();
//STRIP001 			aMtrTrgrAngle.Enable();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case XGRAD_RADIAL:
//STRIP001 			aFtTrgrCenterX.Enable();
//STRIP001 			aMtrTrgrCenterX.Enable();
//STRIP001 			aFtTrgrCenterY.Enable();
//STRIP001 			aMtrTrgrCenterY.Enable();
//STRIP001 			aFtTrgrAngle.Disable();
//STRIP001 			aMtrTrgrAngle.Disable();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case XGRAD_ELLIPTICAL:
//STRIP001 			aFtTrgrCenterX.Enable();
//STRIP001 			aMtrTrgrCenterX.Enable();
//STRIP001 			aFtTrgrCenterY.Enable();
//STRIP001 			aMtrTrgrCenterY.Enable();
//STRIP001 			aFtTrgrAngle.Enable();
//STRIP001 			aMtrTrgrAngle.Enable();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case XGRAD_SQUARE:
//STRIP001 		case XGRAD_RECT:
//STRIP001 			aFtTrgrCenterX.Enable();
//STRIP001 			aMtrTrgrCenterX.Enable();
//STRIP001 			aFtTrgrCenterY.Enable();
//STRIP001 			aMtrTrgrCenterY.Enable();
//STRIP001 			aFtTrgrAngle.Enable();
//STRIP001 			aMtrTrgrAngle.Enable();
//STRIP001 			break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 SvxTransparenceTabPage::SvxTransparenceTabPage(Window* pParent, const SfxItemSet& rInAttrs)
//STRIP001 :	SvxTabPage			( pParent, SVX_RES( RID_SVXPAGE_TRANSPARENCE ), rInAttrs),
//STRIP001 	pXPool				( (XOutdevItemPool*) rInAttrs.GetPool() ),
//STRIP001 	aXFillAttr			( pXPool ),
//STRIP001 	rOutAttrs			( rInAttrs ),
//STRIP001 	rXFSet				( aXFillAttr.GetItemSet() ),
//STRIP001 
//STRIP001     aFlProp             ( this, ResId( FL_PROP ) ),
//STRIP001 	aRbtTransOff		( this, ResId( RBT_TRANS_OFF ) ),
//STRIP001     aRbtTransLinear     ( this, ResId( RBT_TRANS_LINEAR ) ),
//STRIP001 	aRbtTransGradient	( this, ResId( RBT_TRANS_GRADIENT ) ),
//STRIP001 
//STRIP001     aMtrTransparent     ( this, ResId( MTR_TRANSPARENT ) ),
//STRIP001 
//STRIP001 	aFtTrgrType			( this, ResId( FT_TRGR_TYPE ) ),
//STRIP001 	aLbTrgrGradientType	( this, ResId( LB_TRGR_GRADIENT_TYPES ) ),
//STRIP001 	aFtTrgrCenterX		( this, ResId( FT_TRGR_CENTER_X ) ),
//STRIP001 	aMtrTrgrCenterX		( this, ResId( MTR_TRGR_CENTER_X ) ),
//STRIP001 	aFtTrgrCenterY		( this, ResId( FT_TRGR_CENTER_Y ) ),
//STRIP001 	aMtrTrgrCenterY		( this, ResId( MTR_TRGR_CENTER_Y ) ),
//STRIP001 	aFtTrgrAngle		( this, ResId( FT_TRGR_ANGLE ) ),
//STRIP001 	aMtrTrgrAngle		( this, ResId( MTR_TRGR_ANGLE ) ),
//STRIP001 	aFtTrgrBorder		( this, ResId( FT_TRGR_BORDER ) ),
//STRIP001 	aMtrTrgrBorder		( this, ResId( MTR_TRGR_BORDER ) ),
//STRIP001 	aFtTrgrStartValue	( this, ResId( FT_TRGR_START_VALUE ) ),
//STRIP001 	aMtrTrgrStartValue	( this, ResId( MTR_TRGR_START_VALUE ) ),
//STRIP001 	aFtTrgrEndValue		( this, ResId( FT_TRGR_END_VALUE ) ),
//STRIP001 	aMtrTrgrEndValue	( this, ResId( MTR_TRGR_END_VALUE ) ),
//STRIP001 	XOut				( &aCtlXRectPreview ),
//STRIP001 	XOutBmp				( &aCtlBitmapPreview ),
//STRIP001 	aCtlBitmapPreview	( this, ResId( CTL_BITMAP_PREVIEW ), &XOutBmp ),
//STRIP001 	aCtlXRectPreview	( this, ResId( CTL_TRANS_PREVIEW ), &XOut ),
//STRIP001 	bBitmap				( FALSE )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// main selection
//STRIP001 	aRbtTransOff.SetClickHdl(LINK(this, SvxTransparenceTabPage, ClickTransOffHdl_Impl));
//STRIP001     aRbtTransLinear.SetClickHdl(LINK(this, SvxTransparenceTabPage, ClickTransLinearHdl_Impl));
//STRIP001 	aRbtTransGradient.SetClickHdl(LINK(this, SvxTransparenceTabPage, ClickTransGradientHdl_Impl));
//STRIP001 
//STRIP001 	// linear transparency
//STRIP001 	aMtrTransparent.SetValue( 50 );
//STRIP001 	aMtrTransparent.SetModifyHdl(LINK(this, SvxTransparenceTabPage, ModifyTransparentHdl_Impl));
//STRIP001 
//STRIP001 	// gradient transparency
//STRIP001 	aMtrTrgrEndValue.SetValue( 100 );
//STRIP001 	aMtrTrgrStartValue.SetValue( 0 );
//STRIP001 	aLbTrgrGradientType.SetSelectHdl(LINK(this, SvxTransparenceTabPage, ChangeTrgrTypeHdl_Impl));
//STRIP001 	Link aLink = LINK( this, SvxTransparenceTabPage, ModifiedTrgrHdl_Impl);
//STRIP001 	aLbTrgrGradientType.SetSelectHdl( aLink );
//STRIP001 	aMtrTrgrCenterX.SetModifyHdl( aLink );
//STRIP001 	aMtrTrgrCenterY.SetModifyHdl( aLink );
//STRIP001 	aMtrTrgrAngle.SetModifyHdl( aLink );
//STRIP001 	aMtrTrgrBorder.SetModifyHdl( aLink );
//STRIP001 	aMtrTrgrStartValue.SetModifyHdl( aLink );
//STRIP001 	aMtrTrgrEndValue.SetModifyHdl( aLink );
//STRIP001 
//STRIP001 	// this page needs ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 }
//STRIP001 
//STRIP001 void SvxTransparenceTabPage::Construct()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 SfxTabPage* SvxTransparenceTabPage::Create(Window* pWindow, const SfxItemSet& rAttrs)
//STRIP001 {
//STRIP001 	return(new SvxTransparenceTabPage(pWindow, rAttrs));
//STRIP001 }
//STRIP001 
//STRIP001 UINT16* SvxTransparenceTabPage::GetRanges()
//STRIP001 {
//STRIP001 	return(pTransparenceRanges);
//STRIP001 }
//STRIP001 
//STRIP001 BOOL SvxTransparenceTabPage::FillItemSet(SfxItemSet& rAttrs)
//STRIP001 {
//STRIP001 	const SfxPoolItem* pGradientItem = NULL;
//STRIP001 	const SfxPoolItem* pLinearItem = NULL;
//STRIP001 	SfxItemState eStateGradient(rOutAttrs.GetItemState(XATTR_FILLFLOATTRANSPARENCE, TRUE, &pGradientItem));
//STRIP001 	SfxItemState eStateLinear(rOutAttrs.GetItemState(XATTR_FILLTRANSPARENCE, TRUE, &pLinearItem));
//STRIP001 	BOOL bGradActive = (eStateGradient == SFX_ITEM_SET && ((XFillFloatTransparenceItem*)pGradientItem)->IsEnabled());
//STRIP001 	BOOL bLinearActive = (eStateLinear == SFX_ITEM_SET && ((XFillTransparenceItem*)pLinearItem)->GetValue() != 0);
//STRIP001 
//STRIP001 	// #103765#
//STRIP001 	BOOL bGradUsed = (eStateGradient == SFX_ITEM_DONTCARE);
//STRIP001 	BOOL bLinearUsed = (eStateLinear == SFX_ITEM_DONTCARE);
//STRIP001 
//STRIP001 	BOOL bModified(FALSE);
//STRIP001 	BOOL bSwitchOffLinear(FALSE);
//STRIP001 	BOOL bSwitchOffGradient(FALSE);
//STRIP001 
//STRIP001 	if(aMtrTransparent.IsEnabled())
//STRIP001 	{
//STRIP001 		// linear transparence
//STRIP001 		UINT16 nPos = (UINT16)aMtrTransparent.GetValue();
//STRIP001 		if(nPos != (UINT16)aMtrTransparent.GetSavedValue().ToInt32() || !bLinearActive)
//STRIP001 		{
//STRIP001 			XFillTransparenceItem aItem(nPos);
//STRIP001 			SdrShadowTransparenceItem aShadowItem(nPos);
//STRIP001 			const SfxPoolItem* pOld = GetOldItem(rAttrs, XATTR_FILLTRANSPARENCE);
//STRIP001 			if(!pOld || !(*(const XFillTransparenceItem*)pOld == aItem) || !bLinearActive)
//STRIP001 			{
//STRIP001 				rAttrs.Put(aItem);
//STRIP001 				rAttrs.Put(aShadowItem);
//STRIP001 				bModified = TRUE;
//STRIP001 				bSwitchOffGradient = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if(aLbTrgrGradientType.IsEnabled())
//STRIP001 	{
//STRIP001 		// transparence gradient, fill ItemSet from values
//STRIP001 		if(!bGradActive
//STRIP001 			|| (XGradientStyle)aLbTrgrGradientType.GetSelectEntryPos() != (XGradientStyle)aLbTrgrGradientType.GetSavedValue()
//STRIP001 			|| (UINT16)aMtrTrgrAngle.GetValue() != (UINT16)aMtrTrgrAngle.GetSavedValue().ToInt32()
//STRIP001 			|| (UINT16)aMtrTrgrCenterX.GetValue() != (UINT16)aMtrTrgrCenterX.GetSavedValue().ToInt32()
//STRIP001 			|| (UINT16)aMtrTrgrCenterY.GetValue() != (UINT16)aMtrTrgrCenterY.GetSavedValue().ToInt32()
//STRIP001 			|| (UINT16)aMtrTrgrBorder.GetValue() != (UINT16)aMtrTrgrBorder.GetSavedValue().ToInt32()
//STRIP001 			|| (UINT16)aMtrTrgrStartValue.GetValue() != (UINT16)aMtrTrgrStartValue.GetSavedValue().ToInt32()
//STRIP001 			|| (UINT16)aMtrTrgrEndValue.GetValue() != (UINT16)aMtrTrgrEndValue.GetSavedValue().ToInt32() )
//STRIP001 		{
//STRIP001 			UINT8 nStartCol = (UINT8)(((UINT16)aMtrTrgrStartValue.GetValue() * 255) / 100);
//STRIP001 			UINT8 nEndCol = (UINT8)(((UINT16)aMtrTrgrEndValue.GetValue() * 255) / 100);
//STRIP001 			XGradient aTmpGradient(
//STRIP001 						Color(nStartCol, nStartCol, nStartCol),
//STRIP001 						Color(nEndCol, nEndCol, nEndCol),
//STRIP001 						(XGradientStyle)aLbTrgrGradientType.GetSelectEntryPos(),
//STRIP001 						(UINT16)aMtrTrgrAngle.GetValue() * 10,
//STRIP001 						(UINT16)aMtrTrgrCenterX.GetValue(),
//STRIP001 						(UINT16)aMtrTrgrCenterY.GetValue(),
//STRIP001 						(UINT16)aMtrTrgrBorder.GetValue(),
//STRIP001 						100, 100);
//STRIP001 
//STRIP001 			String aString;
//STRIP001 			XFillFloatTransparenceItem aItem( rXFSet.GetPool()/*aString*/, aTmpGradient);
//STRIP001 			const SfxPoolItem* pOld = GetOldItem(rAttrs, XATTR_FILLFLOATTRANSPARENCE);
//STRIP001 
//STRIP001 			if(!pOld || !(*(const XFillFloatTransparenceItem*)pOld == aItem) || !bGradActive)
//STRIP001 			{
//STRIP001 				rAttrs.Put(aItem);
//STRIP001 				bModified = TRUE;
//STRIP001 				bSwitchOffLinear = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// no transparence
//STRIP001 		bSwitchOffGradient = TRUE;
//STRIP001 		bSwitchOffLinear = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// disable unused XFillFloatTransparenceItem
//STRIP001 	if(bSwitchOffGradient && (bGradActive || bGradUsed))
//STRIP001 	{
//STRIP001 		Color aColor(COL_BLACK);
//STRIP001 		XGradient aGrad(aColor, Color(COL_WHITE));
//STRIP001 		aGrad.SetStartIntens(100);
//STRIP001 		aGrad.SetEndIntens(100);
//STRIP001 		String aString;
//STRIP001 		XFillFloatTransparenceItem aItem( rXFSet.GetPool()/*aString*/, aGrad);
//STRIP001 		aItem.SetEnabled(FALSE);
//STRIP001 		rAttrs.Put(aItem);
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// disable unused XFillFloatTransparenceItem
//STRIP001 	if(bSwitchOffLinear && (bLinearActive || bLinearUsed))
//STRIP001 	{
//STRIP001 		XFillTransparenceItem aItem(0);
//STRIP001 		SdrShadowTransparenceItem aShadowItem(0);
//STRIP001 		rAttrs.Put(aItem);
//STRIP001 		rAttrs.Put(aShadowItem);
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxTransparenceTabPage::Reset(const SfxItemSet& rAttrs)
//STRIP001 {
//STRIP001 	const SfxPoolItem* pGradientItem = NULL;
//STRIP001 	SfxItemState eStateGradient(rAttrs.GetItemState(XATTR_FILLFLOATTRANSPARENCE, TRUE, &pGradientItem));
//STRIP001 	if(!pGradientItem)
//STRIP001 		pGradientItem = &rAttrs.Get(XATTR_FILLFLOATTRANSPARENCE);
//STRIP001 	BOOL bGradActive = (eStateGradient == SFX_ITEM_SET && ((XFillFloatTransparenceItem*)pGradientItem)->IsEnabled());
//STRIP001 
//STRIP001 	const SfxPoolItem* pLinearItem = NULL;
//STRIP001 	SfxItemState eStateLinear(rAttrs.GetItemState(XATTR_FILLTRANSPARENCE, TRUE, &pLinearItem));
//STRIP001 	if(!pLinearItem)
//STRIP001 		pLinearItem = &rAttrs.Get(XATTR_FILLTRANSPARENCE);
//STRIP001 	BOOL bLinearActive = (eStateLinear == SFX_ITEM_SET && ((XFillTransparenceItem*)pLinearItem)->GetValue() != 0);
//STRIP001 
//STRIP001 	// transparence gradient
//STRIP001 	const XGradient& rGradient = ((XFillFloatTransparenceItem*)pGradientItem)->GetValue();
//STRIP001 	XGradientStyle eXGS(rGradient.GetGradientStyle());
//STRIP001 	aLbTrgrGradientType.SelectEntryPos(eXGS);
//STRIP001 	aMtrTrgrAngle.SetValue(rGradient.GetAngle() / 10);
//STRIP001 	aMtrTrgrBorder.SetValue(rGradient.GetBorder());
//STRIP001 	aMtrTrgrCenterX.SetValue(rGradient.GetXOffset());
//STRIP001 	aMtrTrgrCenterY.SetValue(rGradient.GetYOffset());
//STRIP001 	aMtrTrgrStartValue.SetValue((UINT16)((((UINT16)rGradient.GetStartColor().GetRed() + 1) * 100) / 255));
//STRIP001 	aMtrTrgrEndValue.SetValue((UINT16)((((UINT16)rGradient.GetEndColor().GetRed() + 1) * 100) / 255));
//STRIP001 
//STRIP001 	// linear transparence
//STRIP001 	UINT16 nTransp = ((XFillTransparenceItem*)pLinearItem)->GetValue();
//STRIP001 	aMtrTransparent.SetValue(bLinearActive ? nTransp : 50);
//STRIP001 	ModifyTransparentHdl_Impl(NULL);
//STRIP001 
//STRIP001 	// select the correct radio button
//STRIP001 	if(bGradActive)
//STRIP001 	{
//STRIP001 		// transparence gradient, set controls appropriate to item
//STRIP001 		aRbtTransGradient.Check();
//STRIP001 		ClickTransGradientHdl_Impl(NULL);
//STRIP001 	}
//STRIP001 	else if(bLinearActive)
//STRIP001 	{
//STRIP001 		// linear transparence
//STRIP001         aRbtTransLinear.Check();
//STRIP001 		ClickTransLinearHdl_Impl(NULL);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// no transparence
//STRIP001 		aRbtTransOff.Check();
//STRIP001 		ClickTransOffHdl_Impl(NULL);
//STRIP001 		ModifiedTrgrHdl_Impl(NULL);
//STRIP001 	}
//STRIP001 
//STRIP001 	// save values
//STRIP001 	aMtrTransparent.SaveValue();
//STRIP001 	aLbTrgrGradientType.SaveValue();
//STRIP001 	aMtrTrgrCenterX.SaveValue();
//STRIP001 	aMtrTrgrCenterY.SaveValue();
//STRIP001 	aMtrTrgrAngle.SaveValue();
//STRIP001 	aMtrTrgrBorder.SaveValue();
//STRIP001 	aMtrTrgrStartValue.SaveValue();
//STRIP001 	aMtrTrgrEndValue.SaveValue();
//STRIP001 
//STRIP001 	BOOL bActive = InitPreview ( rAttrs );
//STRIP001 	InvalidatePreview ( bActive );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxTransparenceTabPage::ActivatePage(const SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	if(*pDlgType == 0) // Flaechen-Dialog
//STRIP001 		*pPageType = PT_TRANSPARENCE;
//STRIP001 
//STRIP001 	InitPreview ( rSet );
//STRIP001 }
//STRIP001 
//STRIP001 int SvxTransparenceTabPage::DeactivatePage(SfxItemSet* pSet)
//STRIP001 {
//STRIP001 	if( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 	return(LEAVE_PAGE);
//STRIP001 }
//STRIP001 
//STRIP001 void SvxTransparenceTabPage::PointChanged(Window* pWindow, RECT_POINT eRcPt)
//STRIP001 {
//STRIP001 	eRP = eRcPt;
//STRIP001 }
//STRIP001 
//STRIP001 //
//STRIP001 // Preview-Methods
//STRIP001 //
//STRIP001 BOOL SvxTransparenceTabPage::InitPreview ( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	// set transparencetyp for preview
//STRIP001 	if ( aRbtTransOff.IsChecked() )
//STRIP001 	{
//STRIP001 		ClickTransOffHdl_Impl(NULL);
//STRIP001     } else if ( aRbtTransLinear.IsChecked() )
//STRIP001     {
//STRIP001         ClickTransLinearHdl_Impl(NULL);
//STRIP001     } else if ( aRbtTransGradient.IsChecked() )
//STRIP001 	{
//STRIP001 		ClickTransGradientHdl_Impl(NULL);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Get fillstyle for preview
//STRIP001 	rXFSet.Put ( ( XFillStyleItem& )    rSet.Get(XATTR_FILLSTYLE) );
//STRIP001 	rXFSet.Put ( ( XFillColorItem& )    rSet.Get(XATTR_FILLCOLOR) );
//STRIP001 	rXFSet.Put ( ( XFillGradientItem& ) rSet.Get(XATTR_FILLGRADIENT) );
//STRIP001 	rXFSet.Put ( ( XFillHatchItem& )    rSet.Get(XATTR_FILLHATCH) );
//STRIP001 	rXFSet.Put ( ( XFillBackgroundItem&)rSet.Get(XATTR_FILLBACKGROUND) );
//STRIP001 	rXFSet.Put ( ( XFillBitmapItem& )   rSet.Get(XATTR_FILLBITMAP) );
//STRIP001 
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 	XOutBmp.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 
//STRIP001 	bBitmap = ( ( ( XFillStyleItem& )rSet.Get(XATTR_FILLSTYLE) ).GetValue() == XFILL_BITMAP );
//STRIP001 
//STRIP001 	// show the right preview window
//STRIP001 	if ( bBitmap )
//STRIP001 	{
//STRIP001 		aCtlBitmapPreview.Show();
//STRIP001 		aCtlXRectPreview.Hide();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aCtlBitmapPreview.Hide();
//STRIP001 		aCtlXRectPreview.Show();
//STRIP001 	}
//STRIP001 
//STRIP001 	return !aRbtTransOff.IsChecked();
//STRIP001 }
//STRIP001 
//STRIP001 void SvxTransparenceTabPage::InvalidatePreview (BOOL bEnable)
//STRIP001 {
//STRIP001 	if ( bBitmap )
//STRIP001 	{
//STRIP001 		if ( bEnable )
//STRIP001 		{
//STRIP001 			aCtlBitmapPreview.Enable();
//STRIP001 			XOutBmp.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aCtlBitmapPreview.Disable();
//STRIP001 		aCtlBitmapPreview.Invalidate();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( bEnable )
//STRIP001 		{
//STRIP001 			aCtlXRectPreview.Enable();
//STRIP001 			XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aCtlXRectPreview.Disable();
//STRIP001 		aCtlXRectPreview.Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Dialog to modify fill-attributes
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxAreaTabPage::SvxAreaTabPage( Window* pParent, const SfxItemSet& rInAttrs ) :
//STRIP001 
//STRIP001 	SvxTabPage			( pParent, SVX_RES( RID_SVXPAGE_AREA ), rInAttrs ),
//STRIP001 
//STRIP001 	pXPool				( (XOutdevItemPool*) rInAttrs.GetPool() ),
//STRIP001 	XOut				( &aCtlXRectPreview ),
//STRIP001 	XOutBmp				( &aCtlBitmapPreview ),
//STRIP001 	aXFillAttr			( pXPool ),
//STRIP001 	rXFSet				( aXFillAttr.GetItemSet() ),
//STRIP001 
//STRIP001     aFlProp             ( this, ResId( FL_PROP ) ),
//STRIP001     aRbtNoFill          ( this, ResId( RBT_FILL_OFF ) ),
//STRIP001     aRbtColor           ( this, ResId( RBT_COLOR ) ),
//STRIP001     aRbtGradient        ( this, ResId( RBT_GRADIENT ) ),
//STRIP001     aRbtHatch           ( this, ResId( RBT_HATCH ) ),
//STRIP001     aRbtBitmap          ( this, ResId( RBT_BITMAP ) ),
//STRIP001 
//STRIP001 	aLbColor			( this, ResId( LB_COLOR ) ),
//STRIP001 	aLbGradient			( this, ResId( LB_GRADIENT ) ),
//STRIP001 	aLbHatching			( this, ResId( LB_HATCHING ) ),
//STRIP001 	aLbBitmap			( this, ResId( LB_BITMAP ) ),
//STRIP001 	aCtlBitmapPreview	( this, ResId( CTL_BITMAP_PREVIEW ), &XOutBmp ),
//STRIP001 
//STRIP001 	aCbxHatchBckgrd		( this, ResId( CB_HATCHBCKGRD ) ),
//STRIP001 	aLbHatchBckgrdColor	( this, ResId( LB_HATCHBCKGRDCOLOR ) ),
//STRIP001 
//STRIP001 	aTsbStepCount  		( this, ResId( TSB_STEPCOUNT ) ),
//STRIP001 	aNumFldStepCount  	( this, ResId( NUM_FLD_STEPCOUNT ) ),
//STRIP001     aFlStepCount        ( this, ResId( FL_STEPCOUNT ) ),
//STRIP001 
//STRIP001 	aTsbTile       		( this, ResId( TSB_TILE ) ),
//STRIP001 	aTsbStretch    		( this, ResId( TSB_STRETCH ) ),
//STRIP001 	aTsbScale      		( this, ResId( TSB_SCALE ) ),
//STRIP001 	aTsbOriginal   		( this, ResId( TSB_ORIGINAL ) ),
//STRIP001 	aFtXSize			( this, ResId( FT_X_SIZE ) ),
//STRIP001 	aMtrFldXSize		( this, ResId( MTR_FLD_X_SIZE ) ),
//STRIP001 	aFtYSize			( this, ResId( FT_Y_SIZE ) ),
//STRIP001 	aMtrFldYSize		( this, ResId( MTR_FLD_Y_SIZE ) ),
//STRIP001     aFlSize             ( this, ResId( FL_SIZE ) ),
//STRIP001 	aRbtRow				( this, ResId( RBT_ROW ) ),
//STRIP001 	aRbtColumn			( this, ResId( RBT_COLUMN ) ),
//STRIP001 	aMtrFldOffset		( this, ResId( MTR_FLD_OFFSET ) ),
//STRIP001     aFlOffset           ( this, ResId( FL_OFFSET ) ),
//STRIP001 	aCtlPosition		( this, ResId( CTL_POSITION ),
//STRIP001 									RP_RM, 110, 80, CS_RECT ),
//STRIP001 	aFtXOffset			( this, ResId( FT_X_OFFSET ) ),
//STRIP001 	aMtrFldXOffset		( this, ResId( MTR_FLD_X_OFFSET ) ),
//STRIP001 	aFtYOffset			( this, ResId( FT_Y_OFFSET ) ),
//STRIP001 	aMtrFldYOffset		( this, ResId( MTR_FLD_Y_OFFSET ) ),
//STRIP001     aFlPosition         ( this, ResId( FL_POSITION ) ),
//STRIP001 
//STRIP001 	aCtlXRectPreview	( this, ResId( CTL_COLOR_PREVIEW ), &XOut ),
//STRIP001 	rOutAttrs			( rInAttrs )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// Gruppen, die sich ueberlagern
//STRIP001 	aLbBitmap.Hide();
//STRIP001 	aCtlBitmapPreview.Hide();
//STRIP001 
//STRIP001     aFlStepCount.Hide();
//STRIP001 	aTsbStepCount.Hide();
//STRIP001 	aNumFldStepCount.Hide();
//STRIP001 
//STRIP001 	aTsbTile.Hide();
//STRIP001 	aTsbStretch.Hide();
//STRIP001 	aTsbScale.Hide();
//STRIP001 	aTsbOriginal.Hide();
//STRIP001 	aFtXSize.Hide();
//STRIP001 	aMtrFldXSize.Hide();
//STRIP001 	aFtYSize.Hide();
//STRIP001 	aMtrFldYSize.Hide();
//STRIP001     aFlSize.Hide();
//STRIP001 	aRbtRow.Hide();
//STRIP001 	aRbtColumn.Hide();
//STRIP001 	aMtrFldOffset.Hide();
//STRIP001     aFlOffset.Hide();
//STRIP001 	aCtlPosition.Hide();
//STRIP001 	aFtXOffset.Hide();
//STRIP001 	aMtrFldXOffset.Hide();
//STRIP001 	aFtYOffset.Hide();
//STRIP001 	aMtrFldYOffset.Hide();
//STRIP001     aFlPosition.Hide();
//STRIP001 	// Controls for Hatch-Background
//STRIP001 	aCbxHatchBckgrd.Hide();
//STRIP001 	aLbHatchBckgrdColor.Hide();
//STRIP001 
//STRIP001 
//STRIP001 	aTsbOriginal.EnableTriState( FALSE );
//STRIP001 
//STRIP001 
//STRIP001 	// this page needs ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	// set Metrics
//STRIP001 	eFUnit = GetModuleFieldUnit( &rInAttrs );
//STRIP001 
//STRIP001 	switch ( eFUnit )
//STRIP001 	{
//STRIP001 		case FUNIT_M:
//STRIP001 		case FUNIT_KM:
//STRIP001 			eFUnit = FUNIT_MM;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	SetFieldUnit( aMtrFldXSize, eFUnit, TRUE );
//STRIP001 	SetFieldUnit( aMtrFldYSize, eFUnit, TRUE );
//STRIP001 
//STRIP001 	// get PoolUnit
//STRIP001 	SfxItemPool* pPool = rOutAttrs.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool?" );
//STRIP001 	ePoolUnit = pPool->GetMetric( XATTR_FILLBMP_SIZEX );
//STRIP001 
//STRIP001 	// Setzen Output-Devices
//STRIP001 	rXFSet.Put( XFillStyleItem( XFILL_SOLID ) );
//STRIP001 	rXFSet.Put( XFillColorItem( String(), COL_BLACK ) );
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 	XOutBmp.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 
//STRIP001     // Set line at the OutputDevice
//STRIP001 	XLineAttrSetItem aXLineAttr( pXPool );
//STRIP001     aXLineAttr.GetItemSet().Put( XLineStyleItem( XLINE_SOLID ) );
//STRIP001     aXLineAttr.GetItemSet().Put( XLineWidthItem( 1 ));
//STRIP001 	XOut.SetLineAttr( aXLineAttr.GetItemSet() );
//STRIP001 	XOutBmp.SetLineAttr( aXLineAttr.GetItemSet() );
//STRIP001 
//STRIP001 	aLbColor.SetSelectHdl( LINK( this, SvxAreaTabPage, ModifyColorHdl_Impl ) );
//STRIP001 	aLbHatchBckgrdColor.SetSelectHdl( LINK( this, SvxAreaTabPage, ModifyHatchBckgrdColorHdl_Impl ) );
//STRIP001 	aCbxHatchBckgrd.SetToggleHdl( LINK( this, SvxAreaTabPage, ToggleHatchBckgrdColorHdl_Impl ) );
//STRIP001 
//STRIP001 	aLbGradient.SetSelectHdl(
//STRIP001 		LINK( this, SvxAreaTabPage, ModifyGradientHdl_Impl ) );
//STRIP001 	aLbHatching.SetSelectHdl(
//STRIP001 		LINK( this, SvxAreaTabPage, ModifyHatchingHdl_Impl ) );
//STRIP001 	aLbBitmap.SetSelectHdl(
//STRIP001 		LINK( this, SvxAreaTabPage, ModifyBitmapHdl_Impl ) );
//STRIP001 
//STRIP001 	aTsbStepCount.SetClickHdl(
//STRIP001 		LINK( this, SvxAreaTabPage, ModifyStepCountHdl_Impl ) );
//STRIP001 	aNumFldStepCount.SetModifyHdl(
//STRIP001 		LINK( this, SvxAreaTabPage, ModifyStepCountHdl_Impl ) );
//STRIP001 
//STRIP001 	Link aLink( LINK( this, SvxAreaTabPage, ModifyTileHdl_Impl ) );
//STRIP001 	aTsbTile.SetClickHdl( aLink );
//STRIP001 	aTsbStretch.SetClickHdl( aLink );
//STRIP001 	aTsbOriginal.SetClickHdl( aLink );
//STRIP001 	aMtrFldXSize.SetModifyHdl( aLink );
//STRIP001 	aMtrFldYSize.SetModifyHdl( aLink );
//STRIP001 	aRbtRow.SetClickHdl( aLink );
//STRIP001 	aRbtColumn.SetClickHdl( aLink );
//STRIP001 	aMtrFldOffset.SetModifyHdl( aLink );
//STRIP001 	aMtrFldXOffset.SetModifyHdl( aLink );
//STRIP001 	aMtrFldYOffset.SetModifyHdl( aLink );
//STRIP001 	aTsbScale.SetClickHdl( LINK( this, SvxAreaTabPage, ClickScaleHdl_Impl ) );
//STRIP001 
//STRIP001     aRbtNoFill.SetClickHdl( LINK( this, SvxAreaTabPage, ClickInvisibleHdl_Impl ) );
//STRIP001     aRbtColor.SetClickHdl( LINK( this, SvxAreaTabPage, ClickColorHdl_Impl ) );
//STRIP001     aRbtGradient.SetClickHdl( LINK( this, SvxAreaTabPage, ClickGradientHdl_Impl ) );
//STRIP001     aRbtHatch.SetClickHdl( LINK( this, SvxAreaTabPage, ClickHatchingHdl_Impl ) );
//STRIP001     aRbtBitmap.SetClickHdl( LINK( this, SvxAreaTabPage, ClickBitmapHdl_Impl ) );
//STRIP001 
//STRIP001 	pColorTab = NULL;
//STRIP001 	pGradientList = NULL;
//STRIP001 	pHatchingList = NULL;
//STRIP001 	pBitmapList = NULL;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxAreaTabPage::Construct()
//STRIP001 {
//STRIP001 	// fill colortables / lists
//STRIP001 	aLbColor.Fill( pColorTab );
//STRIP001 	aLbHatchBckgrdColor.Fill ( pColorTab );
//STRIP001 
//STRIP001 	aLbGradient.Fill( pGradientList );
//STRIP001 	aLbHatching.Fill( pHatchingList );
//STRIP001 	aLbBitmap.Fill( pBitmapList );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxAreaTabPage::ActivatePage( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	int nPos;
//STRIP001 	int nCount;
//STRIP001 
//STRIP001 	if( *pDlgType == 0 ) // Flaechen-Dialog
//STRIP001 	{
//STRIP001 		*pbAreaTP = TRUE;
//STRIP001 
//STRIP001 		if( pColorTab )
//STRIP001 		{
//STRIP001 			// Bitmapliste
//STRIP001 			if( *pnBitmapListState )
//STRIP001 			{
//STRIP001 				if( *pnBitmapListState & CT_CHANGED )
//STRIP001 					pBitmapList = ( (SvxAreaTabDialog*) DLGWIN )->
//STRIP001 											GetNewBitmapList();
//STRIP001 
//STRIP001 				nPos = aLbBitmap.GetSelectEntryPos();
//STRIP001 
//STRIP001 				aLbBitmap.Clear();
//STRIP001 				aLbBitmap.Fill( pBitmapList );
//STRIP001 				nCount = aLbBitmap.GetEntryCount();
//STRIP001 				if( nCount == 0 )
//STRIP001 					; // This case should never occur
//STRIP001 				else if( nCount <= nPos )
//STRIP001 					aLbBitmap.SelectEntryPos( 0 );
//STRIP001 				else
//STRIP001 					aLbBitmap.SelectEntryPos( nPos );
//STRIP001 				ModifyBitmapHdl_Impl( this );
//STRIP001 			}
//STRIP001 			// hatch-liste
//STRIP001 			if( *pnHatchingListState )
//STRIP001 			{
//STRIP001 				if( *pnHatchingListState & CT_CHANGED )
//STRIP001 					pHatchingList = ( (SvxAreaTabDialog*) DLGWIN )->
//STRIP001 											GetNewHatchingList();
//STRIP001 
//STRIP001 				nPos = aLbHatching.GetSelectEntryPos();
//STRIP001 
//STRIP001 				aLbHatching.Clear();
//STRIP001 				aLbHatching.Fill( pHatchingList );
//STRIP001 				nCount = aLbHatching.GetEntryCount();
//STRIP001 				if( nCount == 0 )
//STRIP001 					; // This case should never occur
//STRIP001 				else if( nCount <= nPos )
//STRIP001 					aLbHatching.SelectEntryPos( 0 );
//STRIP001 				else
//STRIP001 					aLbHatching.SelectEntryPos( nPos );
//STRIP001 				ModifyHatchingHdl_Impl( this );
//STRIP001 
//STRIP001 				ModifyHatchBckgrdColorHdl_Impl( this );
//STRIP001 			}
//STRIP001 			// gradient-liste
//STRIP001 			if( *pnGradientListState )
//STRIP001 			{
//STRIP001 				if( *pnGradientListState & CT_CHANGED )
//STRIP001 					pGradientList = ( (SvxAreaTabDialog*) DLGWIN )->
//STRIP001 											GetNewGradientList();
//STRIP001 
//STRIP001 				nPos = aLbGradient.GetSelectEntryPos();
//STRIP001 
//STRIP001 				aLbGradient.Clear();
//STRIP001 				aLbGradient.Fill( pGradientList );
//STRIP001 				nCount = aLbGradient.GetEntryCount();
//STRIP001 				if( nCount == 0 )
//STRIP001 					; // This case should never occur
//STRIP001 				else if( nCount <= nPos )
//STRIP001 					aLbGradient.SelectEntryPos( 0 );
//STRIP001 				else
//STRIP001 					aLbGradient.SelectEntryPos( nPos );
//STRIP001 				ModifyGradientHdl_Impl( this );
//STRIP001 			}
//STRIP001 			// ColorTable
//STRIP001 			if( *pnColorTableState )
//STRIP001 			{
//STRIP001 				if( *pnColorTableState & CT_CHANGED )
//STRIP001 					pColorTab = ( (SvxAreaTabDialog*) DLGWIN )->
//STRIP001 											GetNewColorTable();
//STRIP001 				// aLbColor
//STRIP001 				nPos = aLbColor.GetSelectEntryPos();
//STRIP001 				aLbColor.Clear();
//STRIP001 				aLbColor.Fill( pColorTab );
//STRIP001 				nCount = aLbColor.GetEntryCount();
//STRIP001 				if( nCount == 0 )
//STRIP001 					; // This case should never occur
//STRIP001 				else if( nCount <= nPos )
//STRIP001 					aLbColor.SelectEntryPos( 0 );
//STRIP001 				else
//STRIP001 					aLbColor.SelectEntryPos( nPos );
//STRIP001 
//STRIP001 				ModifyColorHdl_Impl( this );
//STRIP001 
//STRIP001 				// Backgroundcolor of hatch
//STRIP001 				nPos = aLbHatchBckgrdColor.GetSelectEntryPos();
//STRIP001 				aLbHatchBckgrdColor.Clear();
//STRIP001 				aLbHatchBckgrdColor.Fill( pColorTab );
//STRIP001 				nCount = aLbHatchBckgrdColor.GetEntryCount();
//STRIP001 				if( nCount == 0 )
//STRIP001 					; // This case should never occur
//STRIP001 				else if( nCount <= nPos )
//STRIP001 					aLbHatchBckgrdColor.SelectEntryPos( 0 );
//STRIP001 				else
//STRIP001 					aLbHatchBckgrdColor.SelectEntryPos( nPos );
//STRIP001 
//STRIP001 				ModifyHatchBckgrdColorHdl_Impl( this );
//STRIP001 			}
//STRIP001 
//STRIP001 			// evaluate if any other Tabpage set another filltype
//STRIP001             if( ! aRbtNoFill.IsChecked() )
//STRIP001             {
//STRIP001 				switch( *pPageType )
//STRIP001 				{
//STRIP001 					case PT_GRADIENT:
//STRIP001                         aRbtGradient.Check();
//STRIP001 						aLbGradient.SelectEntryPos( *pPos );
//STRIP001                         ClickGradientHdl_Impl( this );
//STRIP001 					break;
//STRIP001 
//STRIP001 					case PT_HATCH:
//STRIP001                         aRbtHatch.Check();
//STRIP001 						aLbHatching.SelectEntryPos( *pPos );
//STRIP001                         ClickHatchingHdl_Impl( this );
//STRIP001 					break;
//STRIP001 
//STRIP001 					case PT_BITMAP:
//STRIP001                         aRbtBitmap.Check();
//STRIP001 						aLbBitmap.SelectEntryPos( *pPos );
//STRIP001                         ClickBitmapHdl_Impl( this );
//STRIP001 					break;
//STRIP001 
//STRIP001 					case PT_COLOR:
//STRIP001                         aRbtColor.Check();
//STRIP001 						aLbColor.SelectEntryPos( *pPos );
//STRIP001 						aLbHatchBckgrdColor.SelectEntryPos( *pPos );
//STRIP001                         ClickColorHdl_Impl( this );
//STRIP001 					break;
//STRIP001                 }
//STRIP001 			}
//STRIP001 			*pPageType = PT_AREA;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxAreaTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if( *pDlgType == 0 ) // Flaechen-Dialog
//STRIP001 	{
//STRIP001         if ( aRbtGradient.IsChecked() )
//STRIP001         {
//STRIP001             *pPageType = PT_GRADIENT;
//STRIP001             *pPos = aLbGradient.GetSelectEntryPos();
//STRIP001         } else if ( aRbtHatch.IsChecked() )
//STRIP001         {
//STRIP001             *pPageType = PT_HATCH;
//STRIP001             *pPos = aLbHatching.GetSelectEntryPos();
//STRIP001         } else if ( aRbtBitmap.IsChecked() )
//STRIP001         {
//STRIP001             *pPageType = PT_BITMAP;
//STRIP001             *pPos = aLbBitmap.GetSelectEntryPos();
//STRIP001         } else if ( aRbtColor.IsChecked() )
//STRIP001         {
//STRIP001             *pPageType = PT_COLOR;
//STRIP001             *pPos = aLbColor.GetSelectEntryPos();
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 
//STRIP001 	return( LEAVE_PAGE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxAreaTabPage::FillItemSet( SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	const SfxPoolItem* pOld = NULL;
//STRIP001 	USHORT	nPos;
//STRIP001 	BOOL	bModified = FALSE;
//STRIP001 
//STRIP001 	if( *pDlgType != 0 || *pbAreaTP )
//STRIP001 	{
//STRIP001         if ( aRbtNoFill.IsChecked() )
//STRIP001         {
//STRIP001             if( ! aRbtNoFill.GetSavedValue() )
//STRIP001             {
//STRIP001                 XFillStyleItem aStyleItem( XFILL_NONE );
//STRIP001                 pOld = GetOldItem( rAttrs, XATTR_FILLSTYLE );
//STRIP001                 if ( !pOld || !( *(const XFillStyleItem*)pOld == aStyleItem ) )
//STRIP001                 {
//STRIP001                     rAttrs.Put( aStyleItem );
//STRIP001                     bModified = TRUE;
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001         else if ( aRbtColor.IsChecked() )
//STRIP001         {
//STRIP001             nPos = aLbColor.GetSelectEntryPos();
//STRIP001             if( nPos != LISTBOX_ENTRY_NOTFOUND &&
//STRIP001                 nPos != aLbColor.GetSavedValue() )
//STRIP001             {
//STRIP001                 XFillColorItem aItem( aLbColor.GetSelectEntry(),
//STRIP001                                       aLbColor.GetSelectEntryColor() );
//STRIP001                 pOld = GetOldItem( rAttrs, XATTR_FILLCOLOR );
//STRIP001                 if ( !pOld || !( *(const XFillColorItem*)pOld == aItem ) )
//STRIP001                 {
//STRIP001                     rAttrs.Put( aItem );
//STRIP001                     bModified = TRUE;
//STRIP001                 }
//STRIP001             }
//STRIP001             // NEU
//STRIP001             if( ! aRbtColor.GetSavedValue() &&
//STRIP001                 ( bModified ||
//STRIP001                   SFX_ITEM_SET == rOutAttrs.GetItemState( GetWhich( XATTR_FILLCOLOR ), TRUE ) ) )
//STRIP001             {
//STRIP001                 XFillStyleItem aStyleItem( XFILL_SOLID );
//STRIP001                 pOld = GetOldItem( rAttrs, XATTR_FILLSTYLE );
//STRIP001                 if ( !pOld || !( *(const XFillStyleItem*)pOld == aStyleItem ) )
//STRIP001                 {
//STRIP001                     rAttrs.Put( aStyleItem );
//STRIP001                     bModified = TRUE;
//STRIP001                 }
//STRIP001             }
//STRIP001         } else if ( aRbtGradient.IsChecked() )
//STRIP001         {
//STRIP001             nPos = aLbGradient.GetSelectEntryPos();
//STRIP001             if( nPos != LISTBOX_ENTRY_NOTFOUND &&
//STRIP001                 nPos != aLbGradient.GetSavedValue() )
//STRIP001             {
//STRIP001                 XGradient aGradient = pGradientList->Get( nPos )->GetGradient();
//STRIP001                 String aString = aLbGradient.GetSelectEntry();
//STRIP001                 XFillGradientItem aItem( aString, aGradient );
//STRIP001                 pOld = GetOldItem( rAttrs, XATTR_FILLGRADIENT );
//STRIP001                 if ( !pOld || !( *(const XFillGradientItem*)pOld == aItem ) )
//STRIP001                 {
//STRIP001                     rAttrs.Put( aItem );
//STRIP001                     bModified = TRUE;
//STRIP001                 }
//STRIP001             }
//STRIP001             // NEU
//STRIP001             if( ! aRbtGradient.GetSavedValue() &&
//STRIP001                 ( bModified ||
//STRIP001                   SFX_ITEM_SET == rOutAttrs.GetItemState( GetWhich( XATTR_FILLGRADIENT ), TRUE ) ) )
//STRIP001             {
//STRIP001                 XFillStyleItem aStyleItem( XFILL_GRADIENT );
//STRIP001                 pOld = GetOldItem( rAttrs, XATTR_FILLSTYLE );
//STRIP001                 if ( !pOld || !( *(const XFillStyleItem*)pOld == aStyleItem ) )
//STRIP001                 {
//STRIP001                     rAttrs.Put( aStyleItem );
//STRIP001                     bModified = TRUE;
//STRIP001                 }
//STRIP001             }
//STRIP001         } else if ( aRbtHatch.IsChecked() )
//STRIP001         {
//STRIP001             nPos = aLbHatching.GetSelectEntryPos();
//STRIP001             if( nPos != LISTBOX_ENTRY_NOTFOUND &&
//STRIP001                nPos != aLbHatching.GetSavedValue() )
//STRIP001             {
//STRIP001                 XHatch aHatching = pHatchingList->Get( nPos )->GetHatch();
//STRIP001                 String aString = aLbHatching.GetSelectEntry();
//STRIP001                 XFillHatchItem aItem( aString, aHatching );
//STRIP001                 pOld = GetOldItem( rAttrs, XATTR_FILLHATCH );
//STRIP001                 if ( !pOld || !( *(const XFillHatchItem*)pOld == aItem ) )
//STRIP001                 {
//STRIP001                     rAttrs.Put( aItem );
//STRIP001                     bModified = TRUE;
//STRIP001                 }
//STRIP001             }
//STRIP001             XFillBackgroundItem aItem ( aCbxHatchBckgrd.IsChecked() );
//STRIP001             rAttrs.Put( aItem );
//STRIP001             nPos = aLbHatchBckgrdColor.GetSelectEntryPos();
//STRIP001             if( nPos != LISTBOX_ENTRY_NOTFOUND &&
//STRIP001                  nPos != aLbHatchBckgrdColor.GetSavedValue() )
//STRIP001             {
//STRIP001                 XFillColorItem aItem( aLbHatchBckgrdColor.GetSelectEntry(),
//STRIP001                                       aLbHatchBckgrdColor.GetSelectEntryColor() );
//STRIP001                 pOld = GetOldItem( rAttrs, XATTR_FILLCOLOR );
//STRIP001                 if ( !pOld || !( *(const XFillColorItem*)pOld == aItem ) )
//STRIP001                 {
//STRIP001                     rAttrs.Put( aItem );
//STRIP001                     bModified = TRUE;
//STRIP001                 }
//STRIP001             }
//STRIP001             // NEU
//STRIP001             if( ! aRbtHatch.GetSavedValue() &&
//STRIP001                 ( bModified ||
//STRIP001                   SFX_ITEM_SET == rOutAttrs.GetItemState( GetWhich( XATTR_FILLHATCH ), TRUE ) ) )
//STRIP001             {
//STRIP001                 XFillStyleItem aStyleItem( XFILL_HATCH );
//STRIP001                 pOld = GetOldItem( rAttrs, XATTR_FILLSTYLE );
//STRIP001                 if ( !pOld || !( *(const XFillStyleItem*)pOld == aStyleItem ) )
//STRIP001                 {
//STRIP001                     rAttrs.Put( aStyleItem );
//STRIP001                     bModified = TRUE;
//STRIP001                 }
//STRIP001             }
//STRIP001         } else if ( aRbtBitmap.IsChecked() )
//STRIP001         {
//STRIP001             nPos = aLbBitmap.GetSelectEntryPos();
//STRIP001             if( nPos != LISTBOX_ENTRY_NOTFOUND &&
//STRIP001                 nPos != aLbBitmap.GetSavedValue() )
//STRIP001             {
//STRIP001                 XOBitmap aXOBitmap = pBitmapList->Get( nPos )->GetXBitmap();
//STRIP001                 String aString = aLbBitmap.GetSelectEntry();
//STRIP001                 XFillBitmapItem aItem( aString, aXOBitmap );
//STRIP001                 pOld = GetOldItem( rAttrs, XATTR_FILLBITMAP );
//STRIP001                 if ( !pOld || !( *(const XFillBitmapItem*)pOld == aItem ) )
//STRIP001                 {
//STRIP001                     rAttrs.Put( aItem );
//STRIP001                     bModified = TRUE;
//STRIP001                 }
//STRIP001             }
//STRIP001             // NEU
//STRIP001             if( ! aRbtBitmap.GetSavedValue() &&
//STRIP001                 ( bModified ||
//STRIP001                   SFX_ITEM_SET == rOutAttrs.GetItemState( GetWhich( XATTR_FILLBITMAP ), TRUE ) ) )
//STRIP001             {
//STRIP001                 XFillStyleItem aStyleItem( XFILL_BITMAP );
//STRIP001                 pOld = GetOldItem( rAttrs, XATTR_FILLSTYLE );
//STRIP001                 if ( !pOld || !( *(const XFillStyleItem*)pOld == aStyleItem ) )
//STRIP001                 {
//STRIP001                     rAttrs.Put( aStyleItem );
//STRIP001                     bModified = TRUE;
//STRIP001                 }
//STRIP001            }
//STRIP001        }
//STRIP001 
//STRIP001 		// Schrittweite
//STRIP001 		if( aTsbStepCount.IsEnabled() )
//STRIP001 		{
//STRIP001 			UINT16 nValue = 0;
//STRIP001 			BOOL   bValueModified = FALSE;
//STRIP001 			TriState eState = aTsbStepCount.GetState();
//STRIP001 			if( eState == STATE_CHECK )
//STRIP001 			{
//STRIP001 				if( eState != aTsbStepCount.GetSavedValue() )
//STRIP001 					bValueModified = TRUE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// Zustand != Disabled ?
//STRIP001 				if( aNumFldStepCount.GetText().Len() > 0 )
//STRIP001 				{
//STRIP001 					nValue = (UINT16) aNumFldStepCount.GetValue();
//STRIP001 					if( nValue != (UINT16) aNumFldStepCount.GetSavedValue().ToInt32() )
//STRIP001 						bValueModified = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if( bValueModified )
//STRIP001 			{
//STRIP001 				XGradientStepCountItem aItem( nValue );
//STRIP001 				pOld = GetOldItem( rAttrs, XATTR_GRADIENTSTEPCOUNT );
//STRIP001 				if ( !pOld || !( *(const XGradientStepCountItem*)pOld == aItem ) )
//STRIP001 				{
//STRIP001 					rAttrs.Put( aItem );
//STRIP001 					bModified = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// Kacheln
//STRIP001 		if( aTsbTile.IsEnabled() )
//STRIP001 		{
//STRIP001 			TriState eState = aTsbTile.GetState();
//STRIP001 			if( eState != aTsbTile.GetSavedValue() )
//STRIP001 			{
//STRIP001 				XFillBmpTileItem aItem( eState );
//STRIP001 				pOld = GetOldItem( rAttrs, XATTR_FILLBMP_TILE );
//STRIP001 				if ( !pOld || !( *(const XFillBmpTileItem*)pOld == aItem ) )
//STRIP001 				{
//STRIP001 					rAttrs.Put( aItem );
//STRIP001 					bModified = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		// Stretchen
//STRIP001 		if( aTsbStretch.IsEnabled() )
//STRIP001 		{
//STRIP001 			TriState eState = aTsbStretch.GetState();
//STRIP001 			if( eState != aTsbStretch.GetSavedValue() )
//STRIP001 			{
//STRIP001 				XFillBmpStretchItem aItem( eState );
//STRIP001 				pOld = GetOldItem( rAttrs, XATTR_FILLBMP_STRETCH );
//STRIP001 				if ( !pOld || !( *(const XFillBmpStretchItem*)pOld == aItem ) )
//STRIP001 				{
//STRIP001 					rAttrs.Put( aItem );
//STRIP001 					bModified = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// Originalgroesse (im UI) wird wie folgt benutzt:
//STRIP001 		// Controls sind disabled, muessen aber gesetzt werden.
//STRIP001 		// SizeX = 0; SizeY = 0; Log = TRUE
//STRIP001 
//STRIP001 		//aTsbScale
//STRIP001 		TriState eState = aTsbScale.GetState();
//STRIP001 		if( eState != aTsbScale.GetSavedValue() ||
//STRIP001 			( !aTsbScale.IsEnabled() &&
//STRIP001 			  aTsbOriginal.IsEnabled() &&
//STRIP001 			  aTsbScale.GetSavedValue() != STATE_CHECK ) )
//STRIP001 		{
//STRIP001 			XFillBmpSizeLogItem* pItem = NULL;
//STRIP001 			if( aTsbScale.IsEnabled() )
//STRIP001 				pItem = new XFillBmpSizeLogItem( eState == STATE_NOCHECK );
//STRIP001 			else if( aTsbOriginal.IsEnabled() && aTsbOriginal.GetState() == STATE_CHECK )
//STRIP001 				pItem = new XFillBmpSizeLogItem( TRUE );
//STRIP001 
//STRIP001 			if( pItem )
//STRIP001 			{
//STRIP001 				pOld = GetOldItem( rAttrs, XATTR_FILLBMP_SIZELOG );
//STRIP001 				if ( !pOld || !( *(const XFillBmpSizeLogItem*)pOld == *pItem ) )
//STRIP001 				{
//STRIP001 					rAttrs.Put( *pItem );
//STRIP001 					bModified = TRUE;
//STRIP001 				}
//STRIP001 				delete pItem;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		//aMtrFldXSize
//STRIP001 		String aStr = aMtrFldXSize.GetText();
//STRIP001 		{
//STRIP001 			XFillBmpSizeXItem* pItem = NULL;
//STRIP001 			TriState eState = aTsbScale.GetState();
//STRIP001 
//STRIP001 			if( aMtrFldXSize.IsEnabled() &&
//STRIP001 				aStr.Len() > 0  &&
//STRIP001 				aStr != aMtrFldXSize.GetSavedValue() )
//STRIP001 			{
//STRIP001 				if( eState == STATE_NOCHECK )
//STRIP001 					pItem = new XFillBmpSizeXItem( GetCoreValue( aMtrFldXSize, ePoolUnit ) );
//STRIP001 				else
//STRIP001 				{
//STRIP001 					// Prozentwerte werden negativ gesetzt, damit
//STRIP001 					// diese nicht skaliert werden; dieses wird
//STRIP001 					// im Item beruecksichtigt ( KA05.11.96 )
//STRIP001 					pItem = new XFillBmpSizeXItem( -labs( aMtrFldXSize.GetValue() ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else if( aTsbOriginal.IsEnabled() &&
//STRIP001 					 aTsbOriginal.GetState() == STATE_CHECK &&
//STRIP001 					 aMtrFldXSize.GetSavedValue().Len() > 0 )
//STRIP001 				pItem = new XFillBmpSizeXItem( 0 );
//STRIP001 
//STRIP001 			if( pItem )
//STRIP001 			{
//STRIP001 				pOld = GetOldItem( rAttrs, XATTR_FILLBMP_SIZEX );
//STRIP001 				if ( !pOld || !( *(const XFillBmpSizeXItem*)pOld == *pItem ) )
//STRIP001 				{
//STRIP001 					rAttrs.Put( *pItem );
//STRIP001 					bModified = TRUE;
//STRIP001 				}
//STRIP001 				delete pItem;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		//aMtrFldYSize
//STRIP001 		aStr = aMtrFldYSize.GetText();
//STRIP001 		{
//STRIP001 			XFillBmpSizeYItem* pItem = NULL;
//STRIP001 			TriState eState = aTsbScale.GetState();
//STRIP001 
//STRIP001 			if( aMtrFldYSize.IsEnabled() &&
//STRIP001 				aStr.Len() > 0  &&
//STRIP001 				aStr != aMtrFldYSize.GetSavedValue() )
//STRIP001 			{
//STRIP001 				if( eState == STATE_NOCHECK )
//STRIP001 					pItem = new XFillBmpSizeYItem( GetCoreValue( aMtrFldYSize, ePoolUnit ) );
//STRIP001 				else
//STRIP001 				{
//STRIP001 					// Prozentwerte werden negativ gesetzt, damit
//STRIP001 					// diese vom MetricItem nicht skaliert werden;
//STRIP001 					// dieses wird im Item beruecksichtigt ( KA05.11.96 )
//STRIP001 					pItem = new XFillBmpSizeYItem( -labs( aMtrFldYSize.GetValue() ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else if( aTsbOriginal.IsEnabled() &&
//STRIP001 					 aTsbOriginal.GetState() == STATE_CHECK &&
//STRIP001 					 aMtrFldYSize.GetSavedValue().Len() > 0 )
//STRIP001 				pItem = new XFillBmpSizeYItem( 0 );
//STRIP001 
//STRIP001 			if( pItem )
//STRIP001 			{
//STRIP001 				pOld = GetOldItem( rAttrs, XATTR_FILLBMP_SIZEY );
//STRIP001 				if ( !pOld || !( *(const XFillBmpSizeYItem*)pOld == *pItem ) )
//STRIP001 				{
//STRIP001 					rAttrs.Put( *pItem );
//STRIP001 					bModified = TRUE;
//STRIP001 				}
//STRIP001 				delete pItem;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		//aRbtRow
//STRIP001 		//aRbtColumn
//STRIP001 		//aMtrFldOffset
//STRIP001 		if( aMtrFldOffset.IsEnabled() )
//STRIP001 		{
//STRIP001 			String aStr = aMtrFldOffset.GetText();
//STRIP001 			if( ( aStr.Len() > 0  &&
//STRIP001 				  aStr != aMtrFldOffset.GetSavedValue() ) ||
//STRIP001 				  aRbtRow.GetSavedValue() != aRbtRow.IsChecked() ||
//STRIP001 				  aRbtColumn.GetSavedValue() != aRbtColumn.IsChecked() )
//STRIP001 			{
//STRIP001 				if( aRbtRow.IsChecked() )
//STRIP001 				{
//STRIP001 					XFillBmpTileOffsetXItem aItem( (UINT16) aMtrFldOffset.GetValue() );
//STRIP001 					pOld = GetOldItem( rAttrs, XATTR_FILLBMP_TILEOFFSETX );
//STRIP001 					if ( !pOld || !( *(const XFillBmpTileOffsetXItem*)pOld == aItem ) )
//STRIP001 					{
//STRIP001 						rAttrs.Put( aItem );
//STRIP001 						rAttrs.Put( XFillBmpTileOffsetYItem( 0 ) );
//STRIP001 						bModified = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else if( aRbtColumn.IsChecked() )
//STRIP001 				{
//STRIP001 					XFillBmpTileOffsetYItem aItem( (UINT16) aMtrFldOffset.GetValue() );
//STRIP001 					pOld = GetOldItem( rAttrs, XATTR_FILLBMP_TILEOFFSETY );
//STRIP001 					if ( !pOld || !( *(const XFillBmpTileOffsetYItem*)pOld == aItem ) )
//STRIP001 					{
//STRIP001 						rAttrs.Put( aItem );
//STRIP001 						rAttrs.Put( XFillBmpTileOffsetXItem( 0 ) );
//STRIP001 						bModified = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		//aCtlPosition
//STRIP001 		if( aCtlPosition.IsEnabled() )
//STRIP001 		{
//STRIP001 			BOOL bPut = FALSE;
//STRIP001 			RECT_POINT eRP = aCtlPosition.GetActualRP();
//STRIP001 
//STRIP001 			if( SFX_ITEM_DONTCARE == rOutAttrs.GetItemState( XATTR_FILLBMP_POS ) )
//STRIP001 				bPut = TRUE;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				RECT_POINT eValue = ( ( const XFillBmpPosItem& ) rOutAttrs.Get( XATTR_FILLBMP_POS ) ).GetValue();
//STRIP001 				if( eValue != eRP )
//STRIP001 					bPut = TRUE;
//STRIP001 			}
//STRIP001 			if( bPut )
//STRIP001 			{
//STRIP001 				XFillBmpPosItem aItem( eRP );
//STRIP001 				pOld = GetOldItem( rAttrs, XATTR_FILLBMP_POS );
//STRIP001 				if ( !pOld || !( *(const XFillBmpPosItem*)pOld == aItem ) )
//STRIP001 				{
//STRIP001 					rAttrs.Put( aItem );
//STRIP001 					bModified = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		//aMtrFldXOffset
//STRIP001 		if( aMtrFldXOffset.IsEnabled() )
//STRIP001 		{
//STRIP001 			String aStr = aMtrFldXOffset.GetText();
//STRIP001 			if( aStr.Len() > 0  &&
//STRIP001 				aStr != aMtrFldXOffset.GetSavedValue() )
//STRIP001 			{
//STRIP001 				XFillBmpPosOffsetXItem aItem( (UINT16) aMtrFldXOffset.GetValue() );
//STRIP001 				pOld = GetOldItem( rAttrs, XATTR_FILLBMP_POSOFFSETX );
//STRIP001 				if ( !pOld || !( *(const XFillBmpPosOffsetXItem*)pOld == aItem ) )
//STRIP001 				{
//STRIP001 					rAttrs.Put( aItem );
//STRIP001 					bModified = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		//aMtrFldYOffset
//STRIP001 		if( aMtrFldYOffset.IsEnabled() )
//STRIP001 		{
//STRIP001 			String aStr = aMtrFldYOffset.GetText();
//STRIP001 			if( aStr.Len() > 0  &&
//STRIP001 				aStr != aMtrFldYOffset.GetSavedValue() )
//STRIP001 			{
//STRIP001 				XFillBmpPosOffsetYItem aItem( (UINT16) aMtrFldYOffset.GetValue() );
//STRIP001 				pOld = GetOldItem( rAttrs, XATTR_FILLBMP_POSOFFSETY );
//STRIP001 				if ( !pOld || !( *(const XFillBmpPosOffsetYItem*)pOld == aItem ) )
//STRIP001 				{
//STRIP001 					rAttrs.Put( aItem );
//STRIP001 					bModified = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return( bModified );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxAreaTabPage::Reset( const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	//const SfxPoolItem *pPoolItem = NULL;
//STRIP001 
//STRIP001 	XFillStyle eXFS;
//STRIP001 	if( rAttrs.GetItemState( XATTR_FILLSTYLE ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		eXFS = (XFillStyle) ( ( ( const XFillStyleItem& ) rAttrs.
//STRIP001 								Get( GetWhich( XATTR_FILLSTYLE ) ) ).GetValue() );
//STRIP001 		switch( eXFS )
//STRIP001 		{
//STRIP001 			case XFILL_NONE:
//STRIP001                 aRbtNoFill.Check();
//STRIP001                 ClickInvisibleHdl_Impl( this );
//STRIP001 			break;
//STRIP001 
//STRIP001 			case XFILL_SOLID:
//STRIP001                 aRbtColor.Check();
//STRIP001 				//if( SFX_ITEM_DONTCARE != rAttrs.GetItemState( GetWhich( XATTR_FILLCOLOR ), TRUE, &pPoolItem ) )
//STRIP001 				if( SFX_ITEM_DONTCARE != rAttrs.GetItemState( XATTR_FILLCOLOR ) )
//STRIP001 				{
//STRIP001 					XFillColorItem aColorItem( ( const XFillColorItem& )
//STRIP001 										rAttrs.Get( XATTR_FILLCOLOR ) );
//STRIP001 
//STRIP001 					aLbColor.SelectEntry( aColorItem.GetValue() );
//STRIP001 					aLbHatchBckgrdColor.SelectEntry( aColorItem.GetValue() );
//STRIP001 				}
//STRIP001                 ClickColorHdl_Impl( this );
//STRIP001 
//STRIP001 			break;
//STRIP001 
//STRIP001 			case XFILL_GRADIENT:
//STRIP001                 aRbtGradient.Check();
//STRIP001 				//if( SFX_ITEM_DONTCARE != rAttrs.GetItemState( GetWhich( XATTR_FILLGRADIENT ), TRUE, &pPoolItem ) )
//STRIP001 				if( SFX_ITEM_DONTCARE != rAttrs.GetItemState( XATTR_FILLGRADIENT ) )
//STRIP001 				{
//STRIP001 					XFillGradientItem aGradientItem( ( ( const XFillGradientItem& )
//STRIP001 											rAttrs.Get( XATTR_FILLGRADIENT ) ) );
//STRIP001 					String	  aString( aGradientItem.GetName() );
//STRIP001 					XGradient aGradient( aGradientItem.GetValue() );
//STRIP001 
//STRIP001 					aLbGradient.SelectEntryByList( pGradientList, aString, aGradient );
//STRIP001 				}
//STRIP001                 ClickGradientHdl_Impl( this );
//STRIP001 			break;
//STRIP001 
//STRIP001 			case XFILL_HATCH:
//STRIP001                 aRbtHatch.Check();
//STRIP001 				//if( SFX_ITEM_DONTCARE != rAttrs.GetItemState( GetWhich( XATTR_FILLHATCH ), TRUE, &pPoolItem ) )
//STRIP001 				if( SFX_ITEM_DONTCARE != rAttrs.GetItemState( XATTR_FILLHATCH ) )
//STRIP001 				{
//STRIP001 					aLbHatching.SelectEntry( ( ( const XFillHatchItem& )
//STRIP001 									rAttrs.Get( XATTR_FILLHATCH ) ).GetName() );
//STRIP001 				}
//STRIP001                 ClickHatchingHdl_Impl( this );
//STRIP001 
//STRIP001                 if ( SFX_ITEM_DONTCARE != rAttrs.GetItemState ( XATTR_FILLBACKGROUND ) )
//STRIP001 				{
//STRIP001 					aCbxHatchBckgrd.Check ( ( ( const XFillBackgroundItem& ) rAttrs.Get ( XATTR_FILLBACKGROUND ) ).GetValue() );
//STRIP001 				}
//STRIP001 				ToggleHatchBckgrdColorHdl_Impl( this );
//STRIP001 				if( SFX_ITEM_DONTCARE != rAttrs.GetItemState( XATTR_FILLCOLOR ) )
//STRIP001 				{
//STRIP001 					XFillColorItem aColorItem( ( const XFillColorItem& )
//STRIP001 										rAttrs.Get( XATTR_FILLCOLOR ) );
//STRIP001 
//STRIP001 					aLbColor.SelectEntry( aColorItem.GetValue() );
//STRIP001 					aLbHatchBckgrdColor.SelectEntry( aColorItem.GetValue() );
//STRIP001 				}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case XFILL_BITMAP:
//STRIP001 			{
//STRIP001                 aRbtBitmap.Check();
//STRIP001 
//STRIP001 				if( SFX_ITEM_DONTCARE != rAttrs.GetItemState( XATTR_FILLBITMAP ) )
//STRIP001 				{
//STRIP001 					XFillBitmapItem aBitmapItem( ( const XFillBitmapItem& )
//STRIP001 										rAttrs.Get( XATTR_FILLBITMAP ) );
//STRIP001 
//STRIP001 					String aString( aBitmapItem.GetName() );
//STRIP001 					aLbBitmap.SelectEntry( aString );
//STRIP001 				}
//STRIP001                 ClickBitmapHdl_Impl( this );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			default:
//STRIP001 				//aLbColor.SelectEntryPos(0);
//STRIP001 				//aRbtColor.Check();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Alle LBs nicht zug"anglich machen
//STRIP001 		aLbColor.Hide();
//STRIP001 		aLbGradient.Hide();
//STRIP001 		aLbHatching.Hide();
//STRIP001 		aLbBitmap.Hide();
//STRIP001 		aCtlBitmapPreview.Hide();
//STRIP001 		aLbColor.Disable();
//STRIP001 		aLbColor.Show();
//STRIP001 
//STRIP001 		// Damit Reset() auch mit Zurueck richtig funktioniert
//STRIP001         aRbtNoFill.Check( FALSE );
//STRIP001         aRbtColor.Check( FALSE );
//STRIP001         aRbtGradient.Check( FALSE );
//STRIP001         aRbtHatch.Check( FALSE );
//STRIP001         aRbtBitmap.Check( FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Schrittweite
//STRIP001 	if( ( rAttrs.GetItemState( XATTR_GRADIENTSTEPCOUNT ) != SFX_ITEM_DONTCARE ) ||
//STRIP001 		( rAttrs.GetItemState( XATTR_FILLSTYLE ) != SFX_ITEM_DONTCARE ) )
//STRIP001 	{
//STRIP001 		aTsbStepCount.EnableTriState( FALSE );
//STRIP001 		UINT16 nValue = ( ( const XGradientStepCountItem& ) rAttrs.Get( XATTR_GRADIENTSTEPCOUNT ) ).GetValue();
//STRIP001 		if( nValue == 0 )
//STRIP001 		{
//STRIP001 			aTsbStepCount.SetState( STATE_CHECK );
//STRIP001 			aNumFldStepCount.SetText( String() );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aTsbStepCount.SetState( STATE_NOCHECK );
//STRIP001 			aNumFldStepCount.SetValue( nValue );
//STRIP001 		}
//STRIP001 		ModifyStepCountHdl_Impl( &aTsbStepCount );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aTsbStepCount.SetState( STATE_DONTKNOW );
//STRIP001 		aNumFldStepCount.SetText( String() );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Attribute fuer die Bitmap-Fuellung
//STRIP001 
//STRIP001 	// Ist Kacheln gesetzt?
//STRIP001 	if( rAttrs.GetItemState( XATTR_FILLBMP_TILE ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		aTsbTile.EnableTriState( FALSE );
//STRIP001 
//STRIP001 		if( ( ( const XFillBmpTileItem& ) rAttrs.Get( XATTR_FILLBMP_TILE ) ).GetValue() )
//STRIP001 			aTsbTile.SetState( STATE_CHECK );
//STRIP001 		else
//STRIP001 			aTsbTile.SetState( STATE_NOCHECK );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aTsbTile.SetState( STATE_DONTKNOW );
//STRIP001 
//STRIP001 	// Ist Stretchen gesetzt?
//STRIP001 	if( rAttrs.GetItemState( XATTR_FILLBMP_STRETCH ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		aTsbStretch.EnableTriState( FALSE );
//STRIP001 
//STRIP001 		if( ( ( const XFillBmpStretchItem& ) rAttrs.Get( XATTR_FILLBMP_STRETCH ) ).GetValue() )
//STRIP001 			aTsbStretch.SetState( STATE_CHECK );
//STRIP001 		else
//STRIP001 			aTsbStretch.SetState( STATE_NOCHECK );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aTsbStretch.SetState( STATE_DONTKNOW );
//STRIP001 
//STRIP001 
//STRIP001 	//aTsbScale
//STRIP001 	if( rAttrs.GetItemState( XATTR_FILLBMP_SIZELOG ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		aTsbScale.EnableTriState( FALSE );
//STRIP001 
//STRIP001 		if( ( ( const XFillBmpSizeLogItem& ) rAttrs.Get( XATTR_FILLBMP_SIZELOG ) ).GetValue() )
//STRIP001 			aTsbScale.SetState( STATE_NOCHECK );
//STRIP001 		else
//STRIP001 			aTsbScale.SetState( STATE_CHECK );
//STRIP001 
//STRIP001 		ClickScaleHdl_Impl( NULL );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aTsbScale.SetState( STATE_DONTKNOW );
//STRIP001 
//STRIP001 
//STRIP001 	// Status fuer Originalgroesse ermitteln
//STRIP001 	TriState eOriginal = STATE_NOCHECK;
//STRIP001 
//STRIP001 	//aMtrFldXSize
//STRIP001 	if( rAttrs.GetItemState( XATTR_FILLBMP_SIZEX ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		INT32 nValue = ( ( const XFillBmpSizeXItem& ) rAttrs.Get( XATTR_FILLBMP_SIZEX ) ).GetValue();
//STRIP001 		if( aTsbScale.GetState() == STATE_CHECK )
//STRIP001 		{
//STRIP001 			// Wenn im Item eine Prozentangabe steckt,
//STRIP001 			// so ist diese wegen des MetricItems negativ
//STRIP001 			aMtrFldXSize.SetValue( labs( nValue ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			SetMetricValue( aMtrFldXSize, nValue, ePoolUnit );
//STRIP001 		aMtrFldXSize.SaveValue();
//STRIP001 
//STRIP001 		if( nValue == 0 )
//STRIP001 		{
//STRIP001 			eOriginal = STATE_CHECK;
//STRIP001 			// Wert ist beim Ausschalten von Originalgroesse sonst zu klein
//STRIP001 			// (Performance-Problem)
//STRIP001 			aMtrFldXSize.SetValue( 100 );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aMtrFldXSize.SetText( String() );
//STRIP001 		aMtrFldXSize.SaveValue();
//STRIP001 	}
//STRIP001 
//STRIP001 	//aMtrFldYSize
//STRIP001 	if( rAttrs.GetItemState( XATTR_FILLBMP_SIZEY ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		INT32 nValue = ( ( const XFillBmpSizeYItem& ) rAttrs.Get( XATTR_FILLBMP_SIZEY ) ).GetValue();
//STRIP001 		if( aTsbScale.GetState() == STATE_CHECK )
//STRIP001 		{
//STRIP001 			// Wenn im Item eine Prozentangabe steckt,
//STRIP001 			// so ist diese wegen des MetricItems negativ
//STRIP001 			aMtrFldYSize.SetValue( labs( nValue ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			SetMetricValue( aMtrFldYSize, nValue, ePoolUnit );
//STRIP001 		aMtrFldYSize.SaveValue();
//STRIP001 
//STRIP001 		if( nValue == 0 )
//STRIP001 			aMtrFldYSize.SetValue( 100 ); //s.o.
//STRIP001 		else
//STRIP001 			eOriginal = STATE_NOCHECK;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aMtrFldYSize.SetText( String() );
//STRIP001 		aMtrFldYSize.SaveValue();
//STRIP001 		eOriginal = STATE_NOCHECK;
//STRIP001 	}
//STRIP001 
//STRIP001 	// aTsbOriginal
//STRIP001 	aTsbOriginal.SetState( eOriginal );
//STRIP001 
//STRIP001     // #93372# Setting proper state after changing button
//STRIP001 	ModifyTileHdl_Impl( NULL );
//STRIP001 
//STRIP001 	//aRbtRow
//STRIP001 	//aRbtColumn
//STRIP001 	//aMtrFldOffset
//STRIP001 	if( rAttrs.GetItemState( XATTR_FILLBMP_TILEOFFSETX ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		UINT16 nValue = ( ( const XFillBmpTileOffsetXItem& ) rAttrs.Get( XATTR_FILLBMP_TILEOFFSETX ) ).GetValue();
//STRIP001 		if( nValue > 0 )
//STRIP001 		{
//STRIP001 			aMtrFldOffset.SetValue( nValue );
//STRIP001 			aRbtRow.Check();
//STRIP001 		}
//STRIP001 		else if( rAttrs.GetItemState( XATTR_FILLBMP_TILEOFFSETY ) != SFX_ITEM_DONTCARE )
//STRIP001 		{
//STRIP001 			nValue = ( ( const XFillBmpTileOffsetYItem& ) rAttrs.Get( XATTR_FILLBMP_TILEOFFSETY ) ).GetValue();
//STRIP001 			if( nValue > 0 )
//STRIP001 			{
//STRIP001 				aMtrFldOffset.SetValue( nValue );
//STRIP001 				aRbtColumn.Check();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aMtrFldOffset.SetValue( 0 );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aMtrFldOffset.SetText( String() );
//STRIP001 
//STRIP001 
//STRIP001 	//aCtlPosition
//STRIP001 	if( rAttrs.GetItemState( XATTR_FILLBMP_POS ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		RECT_POINT eValue = ( ( const XFillBmpPosItem& ) rAttrs.Get( XATTR_FILLBMP_POS ) ).GetValue();
//STRIP001 		aCtlPosition.SetActualRP( eValue );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aCtlPosition.Reset();
//STRIP001 
//STRIP001 	//aMtrFldXOffset
//STRIP001 	if( rAttrs.GetItemState( XATTR_FILLBMP_POSOFFSETX ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		INT32 nValue = ( ( const XFillBmpPosOffsetXItem& ) rAttrs.Get( XATTR_FILLBMP_POSOFFSETX ) ).GetValue();
//STRIP001 		aMtrFldXOffset.SetValue( nValue );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aMtrFldXOffset.SetText( String() );
//STRIP001 
//STRIP001 	//aMtrFldYOffset
//STRIP001 	if( rAttrs.GetItemState( XATTR_FILLBMP_POSOFFSETY ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		INT32 nValue = ( ( const XFillBmpPosOffsetYItem& ) rAttrs.Get( XATTR_FILLBMP_POSOFFSETY ) ).GetValue();
//STRIP001 		aMtrFldYOffset.SetValue( nValue );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aMtrFldYOffset.SetText( String() );
//STRIP001 
//STRIP001 	// Erst hier, damit Tile und Stretch mit beruecksichtigt wird
//STRIP001     if( aRbtBitmap.IsChecked() )
//STRIP001 		ClickBitmapHdl_Impl( NULL );
//STRIP001 
//STRIP001 	// Werte sichern
//STRIP001     aRbtNoFill.SaveValue();
//STRIP001     aRbtColor.SaveValue();
//STRIP001     aRbtGradient.SaveValue();
//STRIP001     aRbtHatch.SaveValue();
//STRIP001     aRbtBitmap.SaveValue();
//STRIP001 	aLbColor.SaveValue();
//STRIP001 	aLbGradient.SaveValue();
//STRIP001 	aLbHatching.SaveValue();
//STRIP001 	//aCbxHatchBckgrd.SaveValue();
//STRIP001 	aLbHatchBckgrdColor.SaveValue();
//STRIP001 	aLbBitmap.SaveValue();
//STRIP001 //	aLbTransparent.SaveValue();
//STRIP001 	aTsbStepCount.SaveValue();
//STRIP001 	aNumFldStepCount.SaveValue();
//STRIP001 	aTsbTile.SaveValue();
//STRIP001 	aTsbStretch.SaveValue();
//STRIP001 	aTsbScale.SaveValue();
//STRIP001 	aRbtRow.SaveValue();
//STRIP001 	aRbtColumn.SaveValue();
//STRIP001 	aMtrFldOffset.SaveValue();
//STRIP001 	aMtrFldXOffset.SaveValue();
//STRIP001 	aMtrFldYOffset.SaveValue();
//STRIP001 	//aMtrFldXSize.SaveValue(); <- wird oben behandelt
//STRIP001 	//aMtrFldYSize.SaveValue(); <- wird oben behandelt
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SvxAreaTabPage::Create( Window* pWindow,
//STRIP001 				const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	return( new SvxAreaTabPage( pWindow, rAttrs ) );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT*	SvxAreaTabPage::GetRanges()
//STRIP001 {
//STRIP001 	return( pAreaRanges );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxAreaTabPage, ClickInvisibleHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	aTsbTile.Hide();
//STRIP001 	aTsbStretch.Hide();
//STRIP001 	aTsbScale.Hide();
//STRIP001 	aTsbOriginal.Hide();
//STRIP001 	aFtXSize.Hide();
//STRIP001 	aMtrFldXSize.Hide();
//STRIP001 	aFtYSize.Hide();
//STRIP001 	aMtrFldYSize.Hide();
//STRIP001     aFlSize.Hide();
//STRIP001 	aRbtRow.Hide();
//STRIP001 	aRbtColumn.Hide();
//STRIP001 	aMtrFldOffset.Hide();
//STRIP001     aFlOffset.Hide();
//STRIP001 	aCtlPosition.Hide();
//STRIP001 	aFtXOffset.Hide();
//STRIP001 	aMtrFldXOffset.Hide();
//STRIP001 	aFtYOffset.Hide();
//STRIP001 	aMtrFldYOffset.Hide();
//STRIP001     aFlPosition.Hide();
//STRIP001 
//STRIP001     aLbColor.Hide();
//STRIP001 	aLbGradient.Hide();
//STRIP001 	aLbHatching.Hide();
//STRIP001 	aLbBitmap.Hide();
//STRIP001     aCtlXRectPreview.Hide();
//STRIP001 	aCtlBitmapPreview.Hide();
//STRIP001 
//STRIP001     aFlStepCount.Hide();
//STRIP001 	aTsbStepCount.Hide();
//STRIP001 	aNumFldStepCount.Hide();
//STRIP001 
//STRIP001     // Controls for Hatch-Background
//STRIP001     aCbxHatchBckgrd.Hide();
//STRIP001     aLbHatchBckgrdColor.Hide();
//STRIP001 
//STRIP001 	rXFSet.Put( XFillStyleItem( XFILL_NONE ) );
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 	XOutBmp.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 
//STRIP001 	aCtlXRectPreview.Invalidate();
//STRIP001 	aCtlBitmapPreview.Invalidate();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxAreaTabPage, ClickColorHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	aTsbTile.Hide();
//STRIP001 	aTsbStretch.Hide();
//STRIP001 	aTsbScale.Hide();
//STRIP001 	aTsbOriginal.Hide();
//STRIP001 	aFtXSize.Hide();
//STRIP001 	aMtrFldXSize.Hide();
//STRIP001 	aFtYSize.Hide();
//STRIP001 	aMtrFldYSize.Hide();
//STRIP001     aFlSize.Hide();
//STRIP001 	aRbtRow.Hide();
//STRIP001 	aRbtColumn.Hide();
//STRIP001 	aMtrFldOffset.Hide();
//STRIP001     aFlOffset.Hide();
//STRIP001 	aCtlPosition.Hide();
//STRIP001 	aFtXOffset.Hide();
//STRIP001 	aMtrFldXOffset.Hide();
//STRIP001 	aFtYOffset.Hide();
//STRIP001 	aMtrFldYOffset.Hide();
//STRIP001     aFlPosition.Hide();
//STRIP001 
//STRIP001 	aLbColor.Enable();
//STRIP001 	aLbColor.Show();
//STRIP001 	aLbGradient.Hide();
//STRIP001 	aLbHatching.Hide();
//STRIP001 	aLbBitmap.Hide();
//STRIP001 	aCtlXRectPreview.Enable();
//STRIP001 	aCtlXRectPreview.Show();
//STRIP001 	aCtlBitmapPreview.Hide();
//STRIP001 
//STRIP001     aFlStepCount.Hide();
//STRIP001 	aTsbStepCount.Hide();
//STRIP001 	aNumFldStepCount.Hide();
//STRIP001 
//STRIP001 	// Controls for Hatch-Background
//STRIP001 	aCbxHatchBckgrd.Hide();
//STRIP001 	aLbHatchBckgrdColor.Hide();
//STRIP001 
//STRIP001 	// Text der Tabelle setzen
//STRIP001 	String			aString( SVX_RES( RID_SVXSTR_TABLE ) ); aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 	INetURLObject	aURL( pColorTab->GetPath() );
//STRIP001 
//STRIP001 	aURL.Append( pColorTab->GetName() );
//STRIP001 	DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 	if( aURL.getBase().Len() > 18 )
//STRIP001 	{
//STRIP001 		aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 		aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aString += aURL.getBase();
//STRIP001 
//STRIP001 	ModifyColorHdl_Impl( this );
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxAreaTabPage, ModifyColorHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	const SfxPoolItem* pPoolItem = NULL;
//STRIP001 	USHORT nPos = aLbColor.GetSelectEntryPos();
//STRIP001 	aLbHatchBckgrdColor.SelectEntryPos( nPos );
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		rXFSet.Put( XFillStyleItem( XFILL_SOLID ) );
//STRIP001 		rXFSet.Put( XFillColorItem( String(),
//STRIP001 									aLbColor.GetSelectEntryColor() ) );
//STRIP001 	}
//STRIP001 	// NEU
//STRIP001 	else if( SFX_ITEM_SET == rOutAttrs.GetItemState( GetWhich( XATTR_FILLCOLOR ), TRUE, &pPoolItem ) )
//STRIP001 	{
//STRIP001 		rXFSet.Put( XFillStyleItem( XFILL_SOLID ) );
//STRIP001 		Color aColor( ( ( const XFillColorItem* ) pPoolItem )->GetValue() );
//STRIP001 		rXFSet.Put( XFillColorItem( String(), aColor ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rXFSet.Put( XFillStyleItem( XFILL_NONE ) );
//STRIP001 
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 	aCtlXRectPreview.Invalidate();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxAreaTabPage, ClickGradientHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	aTsbTile.Hide();
//STRIP001 	aTsbStretch.Hide();
//STRIP001 	aTsbScale.Hide();
//STRIP001 	aTsbOriginal.Hide();
//STRIP001 	aFtXSize.Hide();
//STRIP001 	aMtrFldXSize.Hide();
//STRIP001 	aFtYSize.Hide();
//STRIP001 	aMtrFldYSize.Hide();
//STRIP001     aFlSize.Hide();
//STRIP001 	aRbtRow.Hide();
//STRIP001 	aRbtColumn.Hide();
//STRIP001 	aMtrFldOffset.Hide();
//STRIP001     aFlOffset.Hide();
//STRIP001 	aCtlPosition.Hide();
//STRIP001 	aFtXOffset.Hide();
//STRIP001 	aMtrFldXOffset.Hide();
//STRIP001 	aFtYOffset.Hide();
//STRIP001 	aMtrFldYOffset.Hide();
//STRIP001     aFlPosition.Hide();
//STRIP001 
//STRIP001 	aLbColor.Hide();
//STRIP001 	aLbGradient.Enable();
//STRIP001 	aLbGradient.Show();
//STRIP001 	aLbHatching.Hide();
//STRIP001 	aLbBitmap.Hide();
//STRIP001 	aCtlXRectPreview.Enable();
//STRIP001 	aCtlXRectPreview.Show();
//STRIP001 	aCtlBitmapPreview.Hide();
//STRIP001 
//STRIP001     aFlStepCount.Enable();
//STRIP001     aFlStepCount.Show();
//STRIP001 	aTsbStepCount.Enable();
//STRIP001 	aTsbStepCount.Show();
//STRIP001 	aNumFldStepCount.Show();
//STRIP001 
//STRIP001 	// Controls for Hatch-Background
//STRIP001 	aCbxHatchBckgrd.Hide();
//STRIP001 	aLbHatchBckgrdColor.Hide();
//STRIP001 
//STRIP001 	// Text der Tabelle setzen
//STRIP001 	String			aString( SVX_RES( RID_SVXSTR_TABLE ) ); aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 	INetURLObject	aURL( pGradientList->GetPath() );
//STRIP001 
//STRIP001 	aURL.Append( pGradientList->GetName() );
//STRIP001 	DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 	if( aURL.getBase().Len() > 18 )
//STRIP001 	{
//STRIP001 		aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 		aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aString += aURL.getBase();
//STRIP001 
//STRIP001 	ModifyGradientHdl_Impl( this );
//STRIP001 	ModifyStepCountHdl_Impl( &aTsbStepCount );
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxAreaTabPage, ModifyGradientHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	const SfxPoolItem* pPoolItem = NULL;
//STRIP001 	USHORT nPos = aLbGradient.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		// ItemSet fuellen und an XOut weiterleiten
//STRIP001 		XGradientEntry* pEntry = pGradientList->Get( nPos );
//STRIP001 
//STRIP001 		rXFSet.Put( XFillStyleItem( XFILL_GRADIENT ) );
//STRIP001 		rXFSet.Put( XFillGradientItem( String(),
//STRIP001 									   pEntry->GetGradient() ) );
//STRIP001 	}
//STRIP001 	// NEU
//STRIP001 	else if( SFX_ITEM_SET == rOutAttrs.GetItemState( GetWhich( XATTR_FILLGRADIENT ), TRUE, &pPoolItem ) )
//STRIP001 	{
//STRIP001 		rXFSet.Put( XFillStyleItem( XFILL_GRADIENT ) );
//STRIP001 		rXFSet.Put( XFillGradientItem( String(), ( ( const XFillGradientItem* ) pPoolItem )->GetValue() ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rXFSet.Put( XFillStyleItem( XFILL_NONE ) );
//STRIP001 
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 	aCtlXRectPreview.Invalidate();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxAreaTabPage, ClickHatchingHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	aLbColor.Hide();
//STRIP001 	aLbGradient.Hide();
//STRIP001 	aLbHatching.Enable();
//STRIP001 	aLbHatching.Show();
//STRIP001 	aLbBitmap.Hide();
//STRIP001 	aCtlXRectPreview.Enable();
//STRIP001 	aCtlXRectPreview.Show();
//STRIP001 	aCtlBitmapPreview.Hide();
//STRIP001 
//STRIP001 //	aGrpTransparent.Hide();
//STRIP001 //	aLbTransparent.Hide();
//STRIP001     aFlStepCount.Hide();
//STRIP001 	aTsbStepCount.Hide();
//STRIP001 	aNumFldStepCount.Hide();
//STRIP001 
//STRIP001 	aTsbTile.Hide();
//STRIP001 	aTsbStretch.Hide();
//STRIP001 	aTsbScale.Hide();
//STRIP001 	aTsbOriginal.Hide();
//STRIP001 	aFtXSize.Hide();
//STRIP001 	aMtrFldXSize.Hide();
//STRIP001 	aFtYSize.Hide();
//STRIP001 	aMtrFldYSize.Hide();
//STRIP001     aFlSize.Hide();
//STRIP001 	aRbtRow.Hide();
//STRIP001 	aRbtColumn.Hide();
//STRIP001 	aMtrFldOffset.Hide();
//STRIP001     aFlOffset.Hide();
//STRIP001 	aCtlPosition.Hide();
//STRIP001 	aFtXOffset.Hide();
//STRIP001 	aMtrFldXOffset.Hide();
//STRIP001 	aFtYOffset.Hide();
//STRIP001 	aMtrFldYOffset.Hide();
//STRIP001     aFlPosition.Hide();
//STRIP001 
//STRIP001 	// Controls for Hatch-Background
//STRIP001 	aCbxHatchBckgrd.Show();
//STRIP001 	aLbHatchBckgrdColor.Show();
//STRIP001 	aCbxHatchBckgrd.Enable();
//STRIP001 	aLbHatchBckgrdColor.Enable();
//STRIP001 
//STRIP001 	// Text der Tabelle setzen
//STRIP001 	String			aString( SVX_RES( RID_SVXSTR_TABLE ) ); 	aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 	INetURLObject	aURL( pHatchingList->GetPath() );
//STRIP001 
//STRIP001 	aURL.Append( pHatchingList->GetName() );
//STRIP001 	DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 	if( aURL.getBase().Len() > 18 )
//STRIP001 	{
//STRIP001 		aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 		aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aString += aURL.getBase();
//STRIP001 
//STRIP001 	ModifyHatchingHdl_Impl( this );
//STRIP001 	ModifyHatchBckgrdColorHdl_Impl( this );
//STRIP001 	ToggleHatchBckgrdColorHdl_Impl( this );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxAreaTabPage, ModifyHatchingHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	const SfxPoolItem* pPoolItem = NULL;
//STRIP001 	USHORT nPos = aLbHatching.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		// ItemSet fuellen und an XOut weiterleiten
//STRIP001 		XHatchEntry* pEntry = pHatchingList->Get( nPos );
//STRIP001 
//STRIP001 		rXFSet.Put( XFillStyleItem( XFILL_HATCH ) );
//STRIP001 		rXFSet.Put( XFillHatchItem( String(), pEntry->GetHatch() ) );
//STRIP001 	}
//STRIP001 	// NEU
//STRIP001 	else if( SFX_ITEM_SET == rOutAttrs.GetItemState( GetWhich( XATTR_FILLHATCH ), TRUE, &pPoolItem ) )
//STRIP001 	{
//STRIP001 		rXFSet.Put( XFillStyleItem( XFILL_HATCH ) );
//STRIP001 		rXFSet.Put( XFillHatchItem( String(), ( ( const XFillHatchItem* ) pPoolItem )->GetValue() ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rXFSet.Put( XFillStyleItem( XFILL_NONE ) );
//STRIP001 
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 	aCtlXRectPreview.Invalidate();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxAreaTabPage, ModifyHatchBckgrdColorHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	const SfxPoolItem* pPoolItem = NULL;
//STRIP001 	USHORT nPos = aLbHatchBckgrdColor.GetSelectEntryPos();
//STRIP001 	aLbColor.SelectEntryPos( nPos );
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 //		rXFSet.Put( XFillStyleItem( XFILL_SOLID ) );
//STRIP001 		rXFSet.Put( XFillColorItem( String(),
//STRIP001 									aLbHatchBckgrdColor.GetSelectEntryColor() ) );
//STRIP001 	}
//STRIP001 	// NEU
//STRIP001 	else if( SFX_ITEM_SET == rOutAttrs.GetItemState( GetWhich( XATTR_FILLCOLOR ), TRUE, &pPoolItem ) )
//STRIP001 	{
//STRIP001 //		rXFSet.Put( XFillStyleItem( XFILL_SOLID ) );
//STRIP001 		Color aColor( ( ( const XFillColorItem* ) pPoolItem )->GetValue() );
//STRIP001 		rXFSet.Put( XFillColorItem( String(), aColor ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rXFSet.Put( XFillStyleItem( XFILL_NONE ) );
//STRIP001 
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 	aCtlXRectPreview.Invalidate();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxAreaTabPage, ToggleHatchBckgrdColorHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	// switch on/off backgroundcolor for hatches
//STRIP001 	aLbHatchBckgrdColor.Enable( aCbxHatchBckgrd.IsChecked() );
//STRIP001 
//STRIP001 	XFillBackgroundItem aItem( aCbxHatchBckgrd.IsChecked() );
//STRIP001 	rXFSet.Put ( aItem, XATTR_FILLBACKGROUND );
//STRIP001 
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 	aCtlXRectPreview.Invalidate();
//STRIP001 
//STRIP001 	if( aLbHatchBckgrdColor.GetSelectEntryPos() == LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		if ( SFX_ITEM_SET == rOutAttrs.GetItemState( XATTR_FILLCOLOR ) )//>= SFX_ITEM_DEFAULT )
//STRIP001 		{
//STRIP001 			XFillColorItem aColorItem( (const XFillColorItem&)rOutAttrs.Get( XATTR_FILLCOLOR ) );
//STRIP001 			aLbHatchBckgrdColor.SelectEntry( aColorItem.GetValue() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxAreaTabPage, ClickBitmapHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	aLbColor.Hide();
//STRIP001 	aLbGradient.Hide();
//STRIP001 	aLbHatching.Hide();
//STRIP001 	aLbBitmap.Enable();
//STRIP001 	aLbBitmap.Show();
//STRIP001 	aCtlBitmapPreview.Enable();
//STRIP001 	aCtlBitmapPreview.Show();
//STRIP001 	aCtlXRectPreview.Hide();
//STRIP001 //  	aGrpPreview.Hide();
//STRIP001 //	aGrpTransparent.Hide();
//STRIP001 //	aLbTransparent.Hide();
//STRIP001     aFlStepCount.Hide();
//STRIP001 	aTsbStepCount.Hide();
//STRIP001 	aNumFldStepCount.Hide();
//STRIP001 
//STRIP001 	aTsbTile.Enable();
//STRIP001 	aTsbStretch.Enable();
//STRIP001 	aTsbScale.Enable();
//STRIP001 	aTsbOriginal.Enable();
//STRIP001 	aFtXSize.Enable();
//STRIP001 	aMtrFldXSize.Enable();
//STRIP001 	aFtYSize.Enable();
//STRIP001 	aMtrFldYSize.Enable();
//STRIP001     aFlSize.Enable();
//STRIP001 	aCtlPosition.Enable();
//STRIP001 	aFtXOffset.Enable();
//STRIP001 	aMtrFldXOffset.Enable();
//STRIP001 	aFtYOffset.Enable();
//STRIP001 	aMtrFldYOffset.Enable();
//STRIP001     aFlPosition.Enable();
//STRIP001 	aRbtRow.Enable();
//STRIP001 	aRbtColumn.Enable();
//STRIP001 	aMtrFldOffset.Enable();
//STRIP001     aFlOffset.Enable();
//STRIP001 
//STRIP001 	// Controls for Hatch-Background
//STRIP001 	aCbxHatchBckgrd.Hide();
//STRIP001 	aLbHatchBckgrdColor.Hide();
//STRIP001 
//STRIP001 	aTsbTile.Show();
//STRIP001 	aTsbStretch.Show();
//STRIP001 	aTsbScale.Show();
//STRIP001 	aTsbOriginal.Show();
//STRIP001 	aFtXSize.Show();
//STRIP001 	aMtrFldXSize.Show();
//STRIP001 	aFtYSize.Show();
//STRIP001 	aMtrFldYSize.Show();
//STRIP001     aFlSize.Show();
//STRIP001 	aCtlPosition.Show();
//STRIP001 	aFtXOffset.Show();
//STRIP001 	aMtrFldXOffset.Show();
//STRIP001 	aFtYOffset.Show();
//STRIP001 	aMtrFldYOffset.Show();
//STRIP001     aFlPosition.Show();
//STRIP001 	aRbtRow.Show();
//STRIP001 	aRbtColumn.Show();
//STRIP001 	aMtrFldOffset.Show();
//STRIP001     aFlOffset.Show();
//STRIP001 
//STRIP001 	// Text der Tabelle setzen
//STRIP001 	String			aString( SVX_RES( RID_SVXSTR_TABLE ) ); 	aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 	INetURLObject	aURL( pBitmapList->GetPath() );
//STRIP001 
//STRIP001 	aURL.Append( pBitmapList->GetName() );
//STRIP001 	DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 	if( aURL.getBase().Len() > 18 )
//STRIP001 	{
//STRIP001 		aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 		aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aString += aURL.getBase();
//STRIP001 
//STRIP001 	ModifyBitmapHdl_Impl( this );
//STRIP001 	ModifyTileHdl_Impl( &aTsbOriginal );
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxAreaTabPage, ModifyBitmapHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	const SfxPoolItem* pPoolItem = NULL;
//STRIP001 	USHORT nPos = aLbBitmap.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		// ItemSet fuellen und an XOut weiterleiten
//STRIP001 		XBitmapEntry* pEntry = pBitmapList->Get( nPos );
//STRIP001 
//STRIP001 		rXFSet.Put( XFillStyleItem( XFILL_BITMAP ) );
//STRIP001 		rXFSet.Put( XFillBitmapItem( String(), pEntry->GetXBitmap() ) );
//STRIP001 	}
//STRIP001 	// NEU
//STRIP001 	else if( SFX_ITEM_SET == rOutAttrs.GetItemState( GetWhich( XATTR_FILLBITMAP ), TRUE, &pPoolItem ) )
//STRIP001 	{
//STRIP001 		rXFSet.Put( XFillStyleItem( XFILL_BITMAP ) );
//STRIP001 		rXFSet.Put( XFillBitmapItem( String(), ( ( const XFillBitmapItem* ) pPoolItem )->GetValue() ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rXFSet.Put( XFillStyleItem( XFILL_NONE ) );
//STRIP001 
//STRIP001 	XOutBmp.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 	aCtlBitmapPreview.Invalidate();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 //IMPL_LINK( SvxAreaTabPage, ModifyTransparentHdl_Impl, void *, EMPTYARG )
//STRIP001 //{
//STRIP001 //	USHORT nPos = aLbTransparent.GetSelectEntryPos();
//STRIP001 //	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 //	{
//STRIP001 //		XFillTransparenceItem aItem( nPos * 25 );
//STRIP001 //
//STRIP001 //		rXFSet.Put( XFillTransparenceItem( aItem ) );
//STRIP001 //		XOut.SetFillAttr( aXFillAttr );
//STRIP001 //
//STRIP001 //		aCtlXRectPreview.Invalidate();
//STRIP001 //	}
//STRIP001 //
//STRIP001 //	return( 0L );
//STRIP001 //}
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxAreaTabPage, ModifyStepCountHdl_Impl, void *, p )
//STRIP001 {
//STRIP001 	if( p == &aTsbStepCount )
//STRIP001 	{
//STRIP001 		if( aTsbStepCount.GetState() == STATE_NOCHECK )
//STRIP001 		{
//STRIP001 			if( aNumFldStepCount.GetText().Len() == 0 )
//STRIP001 				aNumFldStepCount.SetText( String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "64") ));
//STRIP001 
//STRIP001 			aNumFldStepCount.Enable();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aNumFldStepCount.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	UINT16 nValue = 0;
//STRIP001 	if( aTsbStepCount.GetState() != STATE_CHECK )
//STRIP001 	{
//STRIP001 		// Zustand != Disabled ?
//STRIP001 		if( aNumFldStepCount.GetText().Len() > 0 )
//STRIP001 			nValue = (UINT16) aNumFldStepCount.GetValue();
//STRIP001 	}
//STRIP001 	rXFSet.Put( XGradientStepCountItem( nValue ) );
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 	aCtlXRectPreview.Invalidate();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxAreaTabPage, ModifyTileHdl_Impl, void *, p )
//STRIP001 {
//STRIP001 	TriState eState = aTsbTile.GetState();
//STRIP001 	if( eState == STATE_CHECK )
//STRIP001 	{
//STRIP001 		aTsbStretch.Disable();
//STRIP001 		aRbtRow.Enable();
//STRIP001 		aRbtColumn.Enable();
//STRIP001 		aMtrFldOffset.Enable();
//STRIP001         aFlOffset.Enable();
//STRIP001 
//STRIP001 		aCtlPosition.Enable();
//STRIP001 		aCtlPosition.Invalidate();
//STRIP001 		aFtXOffset.Enable();
//STRIP001 		aMtrFldXOffset.Enable();
//STRIP001 		aFtYOffset.Enable();
//STRIP001 		aMtrFldYOffset.Enable();
//STRIP001         aFlPosition.Enable();
//STRIP001 
//STRIP001 		aTsbScale.Enable();
//STRIP001 		aTsbOriginal.Enable();
//STRIP001 		aFtXSize.Enable();
//STRIP001 		aMtrFldXSize.Enable();
//STRIP001 		aFtYSize.Enable();
//STRIP001 		aMtrFldYSize.Enable();
//STRIP001         aFlSize.Enable();
//STRIP001 	}
//STRIP001 	else if( eState == STATE_NOCHECK )
//STRIP001 	{
//STRIP001 		aTsbStretch.Enable();
//STRIP001 		aRbtRow.Disable();
//STRIP001 		aRbtColumn.Disable();
//STRIP001 		aMtrFldOffset.Disable();
//STRIP001         aFlOffset.Disable();
//STRIP001 
//STRIP001 		aCtlPosition.Disable();
//STRIP001 		aCtlPosition.Invalidate();
//STRIP001 		aFtXOffset.Disable();
//STRIP001 		aMtrFldXOffset.Disable();
//STRIP001 		aFtYOffset.Disable();
//STRIP001 		aMtrFldYOffset.Disable();
//STRIP001         aFlPosition.Disable();
//STRIP001 
//STRIP001 		if( aTsbStretch.GetState() != STATE_NOCHECK )
//STRIP001 		{
//STRIP001 			aTsbScale.Disable();
//STRIP001 			aTsbOriginal.Disable();
//STRIP001 			aFtXSize.Disable();
//STRIP001 			aMtrFldXSize.Disable();
//STRIP001 			aFtYSize.Disable();
//STRIP001 			aMtrFldYSize.Disable();
//STRIP001             aFlSize.Disable();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aTsbScale.Enable();
//STRIP001 			aTsbOriginal.Enable();
//STRIP001 			aFtXSize.Enable();
//STRIP001 			aMtrFldXSize.Enable();
//STRIP001 			aFtYSize.Enable();
//STRIP001 			aMtrFldYSize.Enable();
//STRIP001             aFlSize.Enable();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aTsbStretch.Disable();
//STRIP001 		aRbtRow.Disable();
//STRIP001 		aRbtColumn.Disable();
//STRIP001 		aMtrFldOffset.Disable();
//STRIP001         aFlOffset.Disable();
//STRIP001 
//STRIP001 		aCtlPosition.Disable();
//STRIP001 		aCtlPosition.Invalidate();
//STRIP001 		aFtXOffset.Disable();
//STRIP001 		aMtrFldXOffset.Disable();
//STRIP001 		aFtYOffset.Disable();
//STRIP001 		aMtrFldYOffset.Disable();
//STRIP001         aFlPosition.Disable();
//STRIP001 
//STRIP001 		aTsbScale.Disable();
//STRIP001 		aTsbOriginal.Disable();
//STRIP001 		aFtXSize.Disable();
//STRIP001 		aMtrFldXSize.Disable();
//STRIP001 		aFtYSize.Disable();
//STRIP001 		aMtrFldYSize.Disable();
//STRIP001         aFlSize.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aTsbOriginal.GetState() == STATE_CHECK )
//STRIP001 	{
//STRIP001 		aMtrFldXSize.SetText( String() );
//STRIP001 		aMtrFldYSize.SetText( String() );
//STRIP001 		aFtXSize.Disable();
//STRIP001 		aFtYSize.Disable();
//STRIP001 		aMtrFldXSize.Disable();
//STRIP001 		aMtrFldYSize.Disable();
//STRIP001 		aTsbScale.Disable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aMtrFldXSize.SetValue( aMtrFldXSize.GetValue() );
//STRIP001 		aMtrFldYSize.SetValue( aMtrFldYSize.GetValue() );
//STRIP001 		/*
//STRIP001 		if( eState == STATE_CHECK )
//STRIP001 		{
//STRIP001 			aFtXSize.Enable();
//STRIP001 			aFtYSize.Enable();
//STRIP001 			aMtrFldXSize.Enable();
//STRIP001 			aMtrFldYSize.Enable();
//STRIP001 		}
//STRIP001 		*/
//STRIP001 	}
//STRIP001 
//STRIP001 	rXFSet.Put( XFillBmpTileItem( eState ) );
//STRIP001 
//STRIP001 	if( aTsbStretch.IsEnabled() )
//STRIP001 		rXFSet.Put( XFillBmpStretchItem( aTsbStretch.GetState() ) );
//STRIP001 
//STRIP001 	if( aTsbScale.IsEnabled() )
//STRIP001 		rXFSet.Put( XFillBmpSizeLogItem( aTsbScale.GetState() == STATE_NOCHECK ) );
//STRIP001 
//STRIP001 	if( aMtrFldXSize.IsEnabled() )
//STRIP001 	{
//STRIP001 		XFillBmpSizeXItem* pItem = NULL;
//STRIP001 		TriState eState = aTsbScale.GetState();
//STRIP001 
//STRIP001 		if( eState == STATE_NOCHECK )
//STRIP001 			pItem = new XFillBmpSizeXItem( GetCoreValue( aMtrFldXSize, ePoolUnit ) );
//STRIP001 		else
//STRIP001 			pItem = new XFillBmpSizeXItem( -labs( aMtrFldXSize.GetValue() ) );
//STRIP001 
//STRIP001 		rXFSet.Put( *pItem );
//STRIP001 
//STRIP001 		delete pItem;
//STRIP001 	}
//STRIP001 	else if( aTsbOriginal.IsEnabled() && aTsbOriginal.GetState() == STATE_CHECK )
//STRIP001 	{
//STRIP001 		// Originalgroesse -> Size == 0
//STRIP001 		rXFSet.Put( XFillBmpSizeXItem( 0 ) );
//STRIP001 		rXFSet.Put( XFillBmpSizeLogItem( TRUE ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aMtrFldYSize.IsEnabled() )
//STRIP001 	{
//STRIP001 		XFillBmpSizeYItem* pItem = NULL;
//STRIP001 		TriState eState = aTsbScale.GetState();
//STRIP001 
//STRIP001 		if( eState == STATE_NOCHECK )
//STRIP001 			pItem = new XFillBmpSizeYItem( GetCoreValue( aMtrFldYSize, ePoolUnit ) );
//STRIP001 		else
//STRIP001 			pItem = new XFillBmpSizeYItem( -labs( aMtrFldYSize.GetValue() ) );
//STRIP001 
//STRIP001 		rXFSet.Put( *pItem );
//STRIP001 
//STRIP001 		delete pItem;
//STRIP001 	}
//STRIP001 	else if( aTsbOriginal.IsEnabled() && aTsbOriginal.GetState() == STATE_CHECK )
//STRIP001 	{
//STRIP001 		// Originalgroesse -> Size == 0
//STRIP001 		rXFSet.Put( XFillBmpSizeYItem( 0 ) );
//STRIP001 		rXFSet.Put( XFillBmpSizeLogItem( TRUE ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aMtrFldOffset.IsEnabled() )
//STRIP001 	{
//STRIP001 		if( aRbtRow.IsChecked() )
//STRIP001 		{
//STRIP001 			rXFSet.Put( XFillBmpTileOffsetXItem( (UINT16) aMtrFldOffset.GetValue() ) );
//STRIP001 			rXFSet.Put( XFillBmpTileOffsetYItem( (UINT16) 0 ) );
//STRIP001 		}
//STRIP001 		else if( aRbtColumn.IsChecked() )
//STRIP001 		{
//STRIP001 			rXFSet.Put( XFillBmpTileOffsetXItem( (UINT16) 0 ) );
//STRIP001 			rXFSet.Put( XFillBmpTileOffsetYItem( (UINT16) aMtrFldOffset.GetValue() ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aCtlPosition.IsEnabled() )
//STRIP001 		rXFSet.Put( XFillBmpPosItem( aCtlPosition.GetActualRP() ) );
//STRIP001 
//STRIP001 	if( aMtrFldXOffset.IsEnabled() )
//STRIP001 		rXFSet.Put( XFillBmpPosOffsetXItem( (UINT16) aMtrFldXOffset.GetValue() ) );
//STRIP001 
//STRIP001 	if( aMtrFldYOffset.IsEnabled() )
//STRIP001 		rXFSet.Put( XFillBmpPosOffsetYItem( (UINT16) aMtrFldYOffset.GetValue() ) );
//STRIP001 
//STRIP001 
//STRIP001 	XOutBmp.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 	aCtlBitmapPreview.Invalidate();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxAreaTabPage, ClickScaleHdl_Impl, void *, p )
//STRIP001 {
//STRIP001 	if( aTsbScale.GetState() == STATE_CHECK )
//STRIP001 	{
//STRIP001 		aMtrFldXSize.SetDecimalDigits( 0 );
//STRIP001 		aMtrFldXSize.SetUnit( FUNIT_CUSTOM );
//STRIP001 		aMtrFldXSize.SetValue( 100 );
//STRIP001 		aMtrFldXSize.SetMax( 100 );
//STRIP001 		aMtrFldXSize.SetLast( 100 );
//STRIP001 
//STRIP001 		aMtrFldYSize.SetDecimalDigits( 0 );
//STRIP001 		aMtrFldYSize.SetUnit( FUNIT_CUSTOM );
//STRIP001 		aMtrFldYSize.SetValue( 100 );
//STRIP001 		aMtrFldYSize.SetMax( 100 );
//STRIP001 		aMtrFldYSize.SetLast( 100 );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aMtrFldXSize.SetDecimalDigits( 2 );
//STRIP001 		aMtrFldXSize.SetUnit( eFUnit );
//STRIP001 		aMtrFldXSize.SetValue( 100 );
//STRIP001 		aMtrFldXSize.SetMax( 999900 );
//STRIP001 		aMtrFldXSize.SetLast( 100000 );
//STRIP001 
//STRIP001 		aMtrFldYSize.SetDecimalDigits( 2 );
//STRIP001 		aMtrFldYSize.SetUnit( eFUnit );
//STRIP001 		aMtrFldYSize.SetValue( 100 );
//STRIP001 		aMtrFldYSize.SetMax( 999900 );
//STRIP001 		aMtrFldYSize.SetLast( 100000 );
//STRIP001 	}
//STRIP001 
//STRIP001 	ModifyTileHdl_Impl( NULL );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxAreaTabPage::PointChanged( Window* pWindow, RECT_POINT eRcPt )
//STRIP001 {
//STRIP001 	eRP = eRcPt;
//STRIP001 
//STRIP001 	// Ausrichtung der Bitmapfuellung
//STRIP001 	ModifyTileHdl_Impl( pWindow );
//STRIP001 }


}
