/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_grfflt.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:44:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX
#include <bf_sfx2/viewfrm.hxx>
#endif
#ifndef _SFXVIEWSH_HXX
#include <bf_sfx2/viewsh.hxx>
#endif
#ifndef _SFXOBJSH_HXX
#include <bf_sfx2/objsh.hxx>
#endif
#ifndef _SFXREQUEST_HXX
#include <bf_sfx2/request.hxx>
#endif

#include "dialmgr.hxx"
#include "grfflt.hxx"
#include "grfflt.hrc"
#include "dialogs.hrc"
namespace binfilter {

// --------------------
// - SvxGraphicFilter -
// --------------------

//STRIP001 ULONG SvxGraphicFilter::ExecuteGrfFilterSlot( SfxRequest& rReq, GraphicObject& rFilterObject )
//STRIP001 {
//STRIP001 	const Graphic&	rGraphic = rFilterObject.GetGraphic();
//STRIP001 	ULONG			nRet;
//STRIP001 
//STRIP001 	if( rGraphic.GetType() == GRAPHIC_BITMAP )
//STRIP001 	{
//STRIP001 		SfxViewFrame*	pViewFrame = SfxViewFrame::Current();
//STRIP001 		SfxObjectShell*	pShell = pViewFrame ? pViewFrame->GetObjectShell() : NULL;
//STRIP001 		Window*			pWindow = ( pViewFrame && pViewFrame->GetViewShell() ) ? pViewFrame->GetViewShell()->GetWindow() : NULL;
//STRIP001 		Graphic			aGraphic;
//STRIP001 
//STRIP001 		switch( rReq.GetSlot() )
//STRIP001 		{
//STRIP001 			case( SID_GRFFILTER_INVERT ):
//STRIP001 			{
//STRIP001 				if( pShell )
//STRIP001 					pShell->SetWaitCursor( TRUE );
//STRIP001 
//STRIP001 				if( rGraphic.IsAnimated() )
//STRIP001 				{
//STRIP001 					Animation aAnimation( rGraphic.GetAnimation() );
//STRIP001 
//STRIP001 					if( aAnimation.Invert() )
//STRIP001 						aGraphic = aAnimation;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					BitmapEx aBmpEx( rGraphic.GetBitmapEx() );
//STRIP001 
//STRIP001 					if( aBmpEx.Invert() )
//STRIP001 						aGraphic = aBmpEx;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( pShell )
//STRIP001 					pShell->SetWaitCursor( FALSE );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SID_GRFFILTER_SMOOTH ):
//STRIP001 			{
//STRIP001 				if( pShell )
//STRIP001 					pShell->SetWaitCursor( TRUE );
//STRIP001 
//STRIP001 				if( rGraphic.IsAnimated() )
//STRIP001 				{
//STRIP001 					Animation aAnimation( rGraphic.GetAnimation() );
//STRIP001 
//STRIP001 					if( aAnimation.Filter( BMP_FILTER_SMOOTH ) )
//STRIP001 						aGraphic = aAnimation;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					BitmapEx aBmpEx( rGraphic.GetBitmapEx() );
//STRIP001 
//STRIP001 					if( aBmpEx.Filter( BMP_FILTER_SMOOTH ) )
//STRIP001 						aGraphic = aBmpEx;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( pShell )
//STRIP001 					pShell->SetWaitCursor( FALSE );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SID_GRFFILTER_SHARPEN ):
//STRIP001 			{
//STRIP001 				if( pShell )
//STRIP001 					pShell->SetWaitCursor( TRUE );
//STRIP001 
//STRIP001 				if( rGraphic.IsAnimated() )
//STRIP001 				{
//STRIP001 					Animation aAnimation( rGraphic.GetAnimation() );
//STRIP001 
//STRIP001 					if( aAnimation.Filter( BMP_FILTER_SHARPEN ) )
//STRIP001 						aGraphic = aAnimation;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					BitmapEx aBmpEx( rGraphic.GetBitmapEx() );
//STRIP001 
//STRIP001 					if( aBmpEx.Filter( BMP_FILTER_SHARPEN ) )
//STRIP001 						aGraphic = aBmpEx;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( pShell )
//STRIP001 					pShell->SetWaitCursor( FALSE );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SID_GRFFILTER_REMOVENOISE ):
//STRIP001 			{
//STRIP001 				if( pShell )
//STRIP001 					pShell->SetWaitCursor( TRUE );
//STRIP001 
//STRIP001 				if( rGraphic.IsAnimated() )
//STRIP001 				{
//STRIP001 					Animation aAnimation( rGraphic.GetAnimation() );
//STRIP001 
//STRIP001 					if( aAnimation.Filter( BMP_FILTER_REMOVENOISE ) )
//STRIP001 						aGraphic = aAnimation;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					BitmapEx aBmpEx( rGraphic.GetBitmapEx() );
//STRIP001 
//STRIP001 					if( aBmpEx.Filter( BMP_FILTER_REMOVENOISE ) )
//STRIP001 						aGraphic = aBmpEx;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( pShell )
//STRIP001 					pShell->SetWaitCursor( FALSE );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SID_GRFFILTER_SOBEL ):
//STRIP001 			{
//STRIP001 				if( pShell )
//STRIP001 					pShell->SetWaitCursor( TRUE );
//STRIP001 
//STRIP001 				if( rGraphic.IsAnimated() )
//STRIP001 				{
//STRIP001 					Animation aAnimation( rGraphic.GetAnimation() );
//STRIP001 
//STRIP001 					if( aAnimation.Filter( BMP_FILTER_SOBEL_GREY ) )
//STRIP001 						aGraphic = aAnimation;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					BitmapEx aBmpEx( rGraphic.GetBitmapEx() );
//STRIP001 
//STRIP001 					if( aBmpEx.Filter( BMP_FILTER_SOBEL_GREY ) )
//STRIP001 						aGraphic = aBmpEx;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( pShell )
//STRIP001 					pShell->SetWaitCursor( FALSE );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SID_GRFFILTER_MOSAIC ):
//STRIP001 			{
//STRIP001 				GraphicFilterMosaic aDlg( pWindow, rGraphic, 4, 4, FALSE );
//STRIP001 
//STRIP001 				if( aDlg.Execute() == RET_OK )
//STRIP001 					aGraphic = aDlg.GetFilteredGraphic( rGraphic, 1.0, 1.0 );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SID_GRFFILTER_EMBOSS	):
//STRIP001 			{
//STRIP001 				GraphicFilterEmboss aDlg( pWindow, rGraphic, RP_MM );
//STRIP001 
//STRIP001 				if( aDlg.Execute() == RET_OK )
//STRIP001 					aGraphic = aDlg.GetFilteredGraphic( rGraphic, 1.0, 1.0 );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SID_GRFFILTER_POSTER	):
//STRIP001 			{
//STRIP001 				GraphicFilterPoster aDlg( pWindow, rGraphic, 16 );
//STRIP001 
//STRIP001 				if( aDlg.Execute() == RET_OK )
//STRIP001 					aGraphic = aDlg.GetFilteredGraphic( rGraphic, 1.0, 1.0 );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SID_GRFFILTER_POPART	):
//STRIP001 			{
//STRIP001 				if( pShell )
//STRIP001 					pShell->SetWaitCursor( TRUE );
//STRIP001 
//STRIP001 				if( rGraphic.IsAnimated() )
//STRIP001 				{
//STRIP001 					Animation aAnimation( rGraphic.GetAnimation() );
//STRIP001 
//STRIP001 					if( aAnimation.Filter( BMP_FILTER_POPART ) )
//STRIP001 						aGraphic = aAnimation;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					BitmapEx aBmpEx( rGraphic.GetBitmapEx() );
//STRIP001 
//STRIP001 					if( aBmpEx.Filter( BMP_FILTER_POPART ) )
//STRIP001 						aGraphic = aBmpEx;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( pShell )
//STRIP001 					pShell->SetWaitCursor( FALSE );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SID_GRFFILTER_SEPIA ):
//STRIP001 			{
//STRIP001 				GraphicFilterSepia aDlg( pWindow, rGraphic, 10 );
//STRIP001 
//STRIP001 				if( aDlg.Execute() == RET_OK )
//STRIP001 					aGraphic = aDlg.GetFilteredGraphic( rGraphic, 1.0, 1.0 );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SID_GRFFILTER_SOLARIZE ):
//STRIP001 			{
//STRIP001 				GraphicFilterSolarize aDlg( pWindow, rGraphic, 128, FALSE );
//STRIP001 
//STRIP001 				if( aDlg.Execute() == RET_OK )
//STRIP001 					aGraphic = aDlg.GetFilteredGraphic( rGraphic, 1.0, 1.0 );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			default:
//STRIP001 			{
//STRIP001 				DBG_ERROR( "SvxGraphicFilter: selected filter slot not yet implemented" );
//STRIP001 				nRet = SVX_GRAPHICFILTER_UNSUPPORTED_SLOT;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( aGraphic.GetType() != GRAPHIC_NONE )
//STRIP001 		{
//STRIP001 			rFilterObject.SetGraphic( aGraphic );
//STRIP001 			nRet = SVX_GRAPHICFILTER_ERRCODE_NONE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nRet = SVX_GRAPHICFILTER_UNSUPPORTED_GRAPHICTYPE;
//STRIP001 	
//STRIP001 	return nRet;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SvxGraphicFilter::DisableGraphicFilterSlots( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	if( SFX_ITEM_AVAILABLE <= rSet.GetItemState( SID_GRFFILTER ) )
//STRIP001 		rSet.DisableItem( SID_GRFFILTER );
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE <= rSet.GetItemState( SID_GRFFILTER_INVERT ) )
//STRIP001 		rSet.DisableItem( SID_GRFFILTER_INVERT );
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE <= rSet.GetItemState( SID_GRFFILTER_SMOOTH ) )
//STRIP001 		rSet.DisableItem( SID_GRFFILTER_SMOOTH );
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE <= rSet.GetItemState( SID_GRFFILTER_SHARPEN ) )
//STRIP001 		rSet.DisableItem( SID_GRFFILTER_SHARPEN );
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE <= rSet.GetItemState( SID_GRFFILTER_REMOVENOISE ) )
//STRIP001 		rSet.DisableItem( SID_GRFFILTER_REMOVENOISE );
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE <= rSet.GetItemState( SID_GRFFILTER_SOBEL ) )
//STRIP001 		rSet.DisableItem( SID_GRFFILTER_SOBEL );
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE <= rSet.GetItemState( SID_GRFFILTER_MOSAIC ) )
//STRIP001 		rSet.DisableItem( SID_GRFFILTER_MOSAIC );
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE <= rSet.GetItemState( SID_GRFFILTER_EMBOSS ) )
//STRIP001 		rSet.DisableItem( SID_GRFFILTER_EMBOSS );
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE <= rSet.GetItemState( SID_GRFFILTER_POSTER ) )
//STRIP001 		rSet.DisableItem( SID_GRFFILTER_POSTER );
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE <= rSet.GetItemState( SID_GRFFILTER_POPART ) )
//STRIP001 		rSet.DisableItem( SID_GRFFILTER_POPART );
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE <= rSet.GetItemState( SID_GRFFILTER_SEPIA ) )
//STRIP001 		rSet.DisableItem( SID_GRFFILTER_SEPIA );
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE <= rSet.GetItemState( SID_GRFFILTER_SOLARIZE ) )
//STRIP001 		rSet.DisableItem( SID_GRFFILTER_SOLARIZE );
//STRIP001 };

// --------------------------------------
// - GraphicFilterDialog::PreviewWindow -
// --------------------------------------

//STRIP001 GraphicFilterDialog::PreviewWindow::PreviewWindow( Window* pParent, const ResId& rResId ) :
//STRIP001 	Control( pParent, rResId )
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 GraphicFilterDialog::PreviewWindow::~PreviewWindow()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void GraphicFilterDialog::PreviewWindow::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	Control::Paint( rRect );
//STRIP001 
//STRIP001 	const Size	aGrfSize( LogicToPixel( maGraphic.GetPrefSize(), maGraphic.GetPrefMapMode() ) );
//STRIP001 	const Size	aOutSize( GetOutputSizePixel() );
//STRIP001 	const Point aGrfPos( ( aOutSize.Width() - aGrfSize.Width() ) >> 1, 
//STRIP001 						 ( aOutSize.Height() - aGrfSize.Height() ) >> 1 );
//STRIP001 
//STRIP001 	if( maGraphic.IsAnimated() )
//STRIP001 		maGraphic.StartAnimation( this , aGrfPos, aGrfSize );
//STRIP001 	else
//STRIP001 		maGraphic.Draw( this, aGrfPos, aGrfSize );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void GraphicFilterDialog::PreviewWindow::SetGraphic( const Graphic& rGraphic )
//STRIP001 {
//STRIP001 	maGraphic = rGraphic;
//STRIP001 
//STRIP001 	if( maGraphic.IsAnimated() || maGraphic.IsTransparent() )
//STRIP001 		Invalidate();
//STRIP001 	else
//STRIP001 		Paint( Rectangle( Point(), GetOutputSizePixel() ) );
//STRIP001 }

// -----------------------
// - GraphicFilterDialog -
// -----------------------

//STRIP001 GraphicFilterDialog::GraphicFilterDialog( Window* pParent, const ResId& rResId, const Graphic& rGraphic ) :
//STRIP001 	ModalDialog		( pParent, rResId ),
//STRIP001 	mfScaleX		( 0.0 ),
//STRIP001 	mfScaleY		( 0.0 ),
//STRIP001 	maSizePixel		( LogicToPixel( rGraphic.GetPrefSize(), rGraphic.GetPrefMapMode() ) ),
//STRIP001 	maModifyHdl		( LINK( this, GraphicFilterDialog, ImplModifyHdl ) ),
//STRIP001 	maPreview		( this, SVX_RES( CTL_PREVIEW ) ),
//STRIP001 	maFlParameter	( this, SVX_RES( FL_PARAMETER ) ),
//STRIP001 	maBtnOK			( this, SVX_RES( BTN_OK ) ),
//STRIP001 	maBtnCancel		( this, SVX_RES( BTN_CANCEL ) ),
//STRIP001 	maBtnHelp		( this, SVX_RES( BTN_HELP ) )
//STRIP001 {
//STRIP001 	const Size	aPreviewSize( maPreview.GetOutputSizePixel() );
//STRIP001 	Size		aGrfSize( maSizePixel );
//STRIP001 
//STRIP001 	if( rGraphic.GetType() == GRAPHIC_BITMAP &&
//STRIP001 		aPreviewSize.Width() && aPreviewSize.Height() && 
//STRIP001 		aGrfSize.Width() && aGrfSize.Height() )
//STRIP001 	{
//STRIP001 		const double fGrfWH = (double) aGrfSize.Width() / aGrfSize.Height();
//STRIP001 		const double fPreWH = (double) aPreviewSize.Width() / aPreviewSize.Height();
//STRIP001 
//STRIP001 		if( fGrfWH < fPreWH )
//STRIP001 		{
//STRIP001 			aGrfSize.Width() = (long) ( aPreviewSize.Height() * fGrfWH );
//STRIP001 			aGrfSize.Height()= aPreviewSize.Height();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aGrfSize.Width() = aPreviewSize.Width();
//STRIP001 			aGrfSize.Height()= (long) ( aPreviewSize.Width() / fGrfWH);
//STRIP001 		}
//STRIP001 
//STRIP001 		mfScaleX = (double) aGrfSize.Width() / maSizePixel.Width();
//STRIP001 		mfScaleY = (double) aGrfSize.Height() / maSizePixel.Height();
//STRIP001 
//STRIP001 		if( !rGraphic.IsAnimated() )
//STRIP001 		{
//STRIP001 			BitmapEx aBmpEx( rGraphic.GetBitmapEx() );
//STRIP001 
//STRIP001 			if( aBmpEx.Scale( aGrfSize, BMP_SCALE_INTERPOLATE ) )
//STRIP001 				maGraphic = aBmpEx;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	maTimer.SetTimeoutHdl( LINK( this, GraphicFilterDialog, ImplPreviewTimeoutHdl ) );
//STRIP001 	maTimer.SetTimeout( 100 );
//STRIP001 	ImplModifyHdl( NULL );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 GraphicFilterDialog::~GraphicFilterDialog()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( GraphicFilterDialog, ImplPreviewTimeoutHdl, Timer*, pTimer )
//STRIP001 {
//STRIP001 	maTimer.Stop();
//STRIP001 	maPreview.SetGraphic( GetFilteredGraphic( maGraphic, mfScaleX, mfScaleY ) );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( GraphicFilterDialog, ImplModifyHdl, void*, p )
//STRIP001 {
//STRIP001 	if( maGraphic.GetType() == GRAPHIC_BITMAP )
//STRIP001 	{
//STRIP001 		maTimer.Stop();
//STRIP001 		maTimer.Start();
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

// ----------------
// - FilterMosaic -
// ----------------

//STRIP001 GraphicFilterMosaic::GraphicFilterMosaic( Window* pParent, const Graphic& rGraphic,
//STRIP001 										  USHORT nTileWidth, USHORT nTileHeight, BOOL bEnhanceEdges ) :
//STRIP001 	GraphicFilterDialog( pParent, SVX_RES( RID_SVX_GRFFILTER_DLG_MOSAIC ), rGraphic ),
//STRIP001 	maFtWidth	( this, SVX_RES( DLG_FILTERMOSAIC_FT_WIDTH ) ),
//STRIP001 	maMtrWidth	( this, SVX_RES( DLG_FILTERMOSAIC_MTR_WIDTH ) ),
//STRIP001 	maFtHeight	( this, SVX_RES( DLG_FILTERMOSAIC_FT_HEIGHT ) ),
//STRIP001 	maMtrHeight ( this, SVX_RES( DLG_FILTERMOSAIC_MTR_HEIGHT ) ),
//STRIP001 	maCbxEdges	( this, SVX_RES( DLG_FILTERMOSAIC_CBX_EDGES ) )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	maMtrWidth.SetValue( nTileWidth );
//STRIP001 	maMtrWidth.SetLast( GetGraphicSizePixel().Width() );
//STRIP001 	maMtrWidth.SetModifyHdl( GetModifyHdl() );
//STRIP001 
//STRIP001 	maMtrHeight.SetValue( nTileHeight );
//STRIP001 	maMtrHeight.SetLast( GetGraphicSizePixel().Height() );
//STRIP001 	maMtrHeight.SetModifyHdl( GetModifyHdl() );
//STRIP001 
//STRIP001 	maCbxEdges.Check( bEnhanceEdges );
//STRIP001 	maCbxEdges.SetToggleHdl( GetModifyHdl() );
//STRIP001 
//STRIP001 	maMtrWidth.GrabFocus();
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 GraphicFilterMosaic::~GraphicFilterMosaic()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 Graphic	GraphicFilterMosaic::GetFilteredGraphic( const Graphic& rGraphic, 
//STRIP001 												 double fScaleX, double fScaleY )
//STRIP001 {
//STRIP001 	Graphic			aRet;
//STRIP001 	const Size		aSize( Max( FRound( GetTileWidth() * fScaleX ), 1L ), 
//STRIP001 						   Max( FRound( GetTileHeight() * fScaleY ), 1L ) );
//STRIP001 	BmpFilterParam	aParam( aSize );
//STRIP001 
//STRIP001 	if( rGraphic.IsAnimated() )
//STRIP001 	{
//STRIP001 		Animation aAnim( rGraphic.GetAnimation() );
//STRIP001 
//STRIP001 		if( aAnim.Filter( BMP_FILTER_MOSAIC, &aParam ) )
//STRIP001 		{
//STRIP001 			if( IsEnhanceEdges() )
//STRIP001 				aAnim.Filter( BMP_FILTER_SHARPEN );
//STRIP001 
//STRIP001 			aRet = aAnim;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		BitmapEx aBmpEx( rGraphic.GetBitmapEx() );
//STRIP001 
//STRIP001 		if( aBmpEx.Filter( BMP_FILTER_MOSAIC, &aParam ) )
//STRIP001 		{
//STRIP001 			if( IsEnhanceEdges() )
//STRIP001 				aBmpEx.Filter( BMP_FILTER_SHARPEN );
//STRIP001 
//STRIP001 			aRet = aBmpEx;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return aRet;
//STRIP001 }

// ------------------
// - GraphicFilterSolarize -
// ------------------

//STRIP001 GraphicFilterSolarize::GraphicFilterSolarize( Window* pParent, const Graphic& rGraphic,
//STRIP001 											  BYTE cGreyThreshold, BOOL bInvert ) :
//STRIP001 	GraphicFilterDialog	( pParent, SVX_RES( RID_SVX_GRFFILTER_DLG_SOLARIZE ), rGraphic ),
//STRIP001 	maFtThreshold	( this, SVX_RES( DLG_FILTERSOLARIZE_FT_THRESHOLD ) ),
//STRIP001 	maMtrThreshold	( this, SVX_RES( DLG_FILTERSOLARIZE_MTR_THRESHOLD ) ),
//STRIP001 	maCbxInvert		( this, SVX_RES( DLG_FILTERSOLARIZE_CBX_INVERT ) )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	maMtrThreshold.SetValue( FRound( cGreyThreshold / 2.55 ) );
//STRIP001 	maMtrThreshold.SetModifyHdl( GetModifyHdl() );
//STRIP001 
//STRIP001 	maCbxInvert.Check( bInvert );
//STRIP001 	maCbxInvert.SetToggleHdl( GetModifyHdl() );
//STRIP001 
//STRIP001 	maMtrThreshold.GrabFocus();
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 GraphicFilterSolarize::~GraphicFilterSolarize()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 Graphic	GraphicFilterSolarize::GetFilteredGraphic( const Graphic& rGraphic, 
//STRIP001 												   double fScaleX, double fScaleY )
//STRIP001 {
//STRIP001 	Graphic			aRet;
//STRIP001 	BmpFilterParam	aParam( GetGreyThreshold() );
//STRIP001 
//STRIP001 	if( rGraphic.IsAnimated() )
//STRIP001 	{
//STRIP001 		Animation aAnim( rGraphic.GetAnimation() );
//STRIP001 
//STRIP001 		if( aAnim.Filter( BMP_FILTER_SOLARIZE, &aParam ) )
//STRIP001 		{
//STRIP001 			if( IsInvert() )
//STRIP001 				aAnim.Invert();
//STRIP001 
//STRIP001 			aRet = aAnim;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		BitmapEx aBmpEx( rGraphic.GetBitmapEx() );
//STRIP001 
//STRIP001 		if( aBmpEx.Filter( BMP_FILTER_SOLARIZE, &aParam ) )
//STRIP001 		{
//STRIP001 			if( IsInvert() )
//STRIP001 				aBmpEx.Invert();
//STRIP001 
//STRIP001 			aRet = aBmpEx;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return aRet;
//STRIP001 }

// ----------------------
// - GraphicFilterSepia -
// ----------------------

//STRIP001 GraphicFilterSepia::GraphicFilterSepia( Window* pParent, const Graphic& rGraphic,
//STRIP001 										USHORT nSepiaPercent ) :
//STRIP001 	GraphicFilterDialog	( pParent, SVX_RES( RID_SVX_GRFFILTER_DLG_SEPIA ), rGraphic ),
//STRIP001 	maFtSepia		( this, SVX_RES( DLG_FILTERSEPIA_FT_SEPIA ) ),
//STRIP001 	maMtrSepia		( this, SVX_RES( DLG_FILTERSEPIA_MTR_SEPIA ) )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	maMtrSepia.SetValue( nSepiaPercent );
//STRIP001 	maMtrSepia.SetModifyHdl( GetModifyHdl() );
//STRIP001 
//STRIP001 	maMtrSepia.GrabFocus();
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 GraphicFilterSepia::~GraphicFilterSepia()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 Graphic	GraphicFilterSepia::GetFilteredGraphic( const Graphic& rGraphic, 
//STRIP001 												double fScaleX, double fScaleY )
//STRIP001 {
//STRIP001 	Graphic			aRet;
//STRIP001 	BmpFilterParam	aParam( GetSepiaPercent() );
//STRIP001 
//STRIP001 	if( rGraphic.IsAnimated() )
//STRIP001 	{
//STRIP001 		Animation aAnim( rGraphic.GetAnimation() );
//STRIP001 
//STRIP001 		if( aAnim.Filter( BMP_FILTER_SEPIA, &aParam ) )
//STRIP001 			aRet = aAnim;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		BitmapEx aBmpEx( rGraphic.GetBitmapEx() );
//STRIP001 
//STRIP001 		if( aBmpEx.Filter( BMP_FILTER_SEPIA, &aParam ) )
//STRIP001 			aRet = aBmpEx;
//STRIP001 	}
//STRIP001 
//STRIP001 	return aRet;
//STRIP001 }

// -----------------------
// - GraphicFilterPoster -
// -----------------------

//STRIP001 GraphicFilterPoster::GraphicFilterPoster( Window* pParent, const Graphic& rGraphic,
//STRIP001 										  USHORT nPosterCount ) :
//STRIP001 	GraphicFilterDialog	( pParent, SVX_RES( RID_SVX_GRFFILTER_DLG_POSTER ), rGraphic ),
//STRIP001 	maFtPoster		( this, SVX_RES( DLG_FILTERPOSTER_FT_POSTER ) ),
//STRIP001 	maNumPoster		( this, SVX_RES( DLG_FILTERPOSTER_NUM_POSTER ) )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	maNumPoster.SetFirst( 2 );
//STRIP001 	maNumPoster.SetLast( rGraphic.GetBitmapEx().GetBitCount() );
//STRIP001 	maNumPoster.SetValue( nPosterCount );
//STRIP001 	maNumPoster.SetModifyHdl( GetModifyHdl() );
//STRIP001 	maNumPoster.GrabFocus();
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 GraphicFilterPoster::~GraphicFilterPoster()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 Graphic	GraphicFilterPoster::GetFilteredGraphic( const Graphic& rGraphic, 
//STRIP001 												 double fScaleX, double fScaleY )
//STRIP001 {
//STRIP001 	Graphic			aRet;
//STRIP001 	const USHORT	nPosterCount = GetPosterColorCount();
//STRIP001 
//STRIP001 	if( rGraphic.IsAnimated() )
//STRIP001 	{
//STRIP001 		Animation aAnim( rGraphic.GetAnimation() );
//STRIP001 
//STRIP001 		if( aAnim.ReduceColors( nPosterCount, BMP_REDUCE_POPULAR ) )
//STRIP001 			aRet = aAnim;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		BitmapEx aBmpEx( rGraphic.GetBitmapEx() );
//STRIP001 
//STRIP001 		if( aBmpEx.ReduceColors( nPosterCount, BMP_REDUCE_POPULAR ) )
//STRIP001 			aRet = aBmpEx;
//STRIP001 	}
//STRIP001 
//STRIP001 	return aRet;
//STRIP001 }

// -----------------------
// - GraphicFilterEmboss -
// -----------------------

//STRIP001 void GraphicFilterEmboss::EmbossControl::MouseButtonDown( const MouseEvent& rEvt )
//STRIP001 {
//STRIP001 	const RECT_POINT eOldRP = GetActualRP();
//STRIP001 
//STRIP001 	SvxRectCtl::MouseButtonDown( rEvt );
//STRIP001 
//STRIP001 	if( GetActualRP() != eOldRP )
//STRIP001 		maModifyHdl.Call( this );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 GraphicFilterEmboss::GraphicFilterEmboss( Window* pParent, const Graphic& rGraphic,
//STRIP001 										  RECT_POINT eLightSource ) :
//STRIP001 	GraphicFilterDialog	( pParent, SVX_RES( RID_SVX_GRFFILTER_DLG_EMBOSS ), rGraphic ),
//STRIP001 	maFtLight		( this, SVX_RES( DLG_FILTEREMBOSS_FT_LIGHT ) ),
//STRIP001 	maCtlLight		( this, SVX_RES( DLG_FILTEREMBOSS_CTL_LIGHT ), eLightSource )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	maCtlLight.SetModifyHdl( GetModifyHdl() );
//STRIP001 	maCtlLight.GrabFocus();
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 GraphicFilterEmboss::~GraphicFilterEmboss()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 Graphic	GraphicFilterEmboss::GetFilteredGraphic( const Graphic& rGraphic, 
//STRIP001 												 double fScaleX, double fScaleY )
//STRIP001 {
//STRIP001 	Graphic	aRet;
//STRIP001 	USHORT	nAzim, nElev;
//STRIP001 
//STRIP001 	switch( maCtlLight.GetActualRP() )
//STRIP001 	{
//STRIP001 		case( RP_LT ): nAzim = 4500,	nElev = 4500; break;
//STRIP001 		case( RP_MT ): nAzim = 9000,	nElev = 4500; break;
//STRIP001 		case( RP_RT ): nAzim = 13500,	nElev = 4500; break;
//STRIP001 		case( RP_LM ): nAzim = 0,		nElev = 4500; break;
//STRIP001 		case( RP_MM ): nAzim = 0,		nElev = 9000; break;
//STRIP001 		case( RP_RM ): nAzim = 18000,	nElev = 4500; break;
//STRIP001 		case( RP_LB ): nAzim = 31500,	nElev = 4500; break;
//STRIP001 		case( RP_MB ): nAzim = 27000,	nElev = 4500; break;
//STRIP001 		case( RP_RB ): nAzim = 22500,	nElev = 4500; break;
//STRIP001 	}
//STRIP001 
//STRIP001 	BmpFilterParam aParam( nAzim, nElev );
//STRIP001 
//STRIP001 	if( rGraphic.IsAnimated() )
//STRIP001 	{
//STRIP001 		Animation aAnim( rGraphic.GetAnimation() );
//STRIP001 
//STRIP001 		if( aAnim.Filter( BMP_FILTER_EMBOSS_GREY, &aParam ) )
//STRIP001 			aRet = aAnim;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		BitmapEx aBmpEx( rGraphic.GetBitmapEx() );
//STRIP001 
//STRIP001 		if( aBmpEx.Filter( BMP_FILTER_EMBOSS_GREY, &aParam ) )
//STRIP001 			aRet = aBmpEx;
//STRIP001 	}
//STRIP001 
//STRIP001 	return aRet;
//STRIP001 }
}
