/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_align.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:33:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#include <svxenum.hxx>
#pragma hdrstop

#define _SVX_ALIGN_CXX

#include "dialogs.hrc"
#include "align.hrc"
#include "rotmodit.hxx"

#define ITEMID_HORJUSTIFY		SID_ATTR_ALIGN_HOR_JUSTIFY
#define ITEMID_VERJUSTIFY		SID_ATTR_ALIGN_VER_JUSTIFY
#define ITEMID_ORIENTATION		SID_ATTR_ALIGN_ORIENTATION
#define ITEMID_LINEBREAK		SID_ATTR_ALIGN_LINEBREAK
#define ITEMID_MARGIN			SID_ATTR_ALIGN_MARGIN
#define ITEMID_FRAMEDIR         SID_ATTR_FRAMEDIRECTION

#include "algitem.hxx"
#include "frmdiritem.hxx"
#include "align.hxx"
#include "dialmgr.hxx"
#include "dlgutil.hxx"

#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif
#ifndef _SVTOOLS_CJKOPTIONS_HXX
#include <svtools/cjkoptions.hxx>
#endif
#ifndef _SVTOOLS_LANGUAGEOPTIONS_HXX
#include <svtools/languageoptions.hxx>
#endif
#ifndef _SVTOOLS_LOCALRESACCESS_HXX_
#include <svtools/localresaccess.hxx>
#endif
namespace binfilter {

// static ----------------------------------------------------------------

//STRIP001 static USHORT pRanges[] =
//STRIP001 {
//STRIP001     SID_ATTR_ALIGN_HOR_JUSTIFY,
//STRIP001     SID_ATTR_ALIGN_LINEBREAK,
//STRIP001     SID_ATTR_ALIGN_INDENT,SID_ATTR_ALIGN_INDENT,
//STRIP001     SID_ATTR_ALIGN_DEGREES,SID_ATTR_ALIGN_DEGREES,
//STRIP001     SID_ATTR_ALIGN_LOCKPOS,SID_ATTR_ALIGN_LOCKPOS,
//STRIP001     SID_ATTR_ALIGN_HYPHENATION,SID_ATTR_ALIGN_HYPHENATION,
//STRIP001     SID_ATTR_ALIGN_ASIANVERTICAL,SID_ATTR_ALIGN_ASIANVERTICAL,
//STRIP001     SID_ATTR_FRAMEDIRECTION,SID_ATTR_FRAMEDIRECTION,
//STRIP001     0
//STRIP001 };
//STRIP001 
//STRIP001 //--------------------------------------------------------------
//STRIP001 // class SvxAlignmentTabPage
//STRIP001 //--------------------------------------------------------------
//STRIP001 // Konstruktor
//STRIP001 
//STRIP001 SvxAlignmentTabPage::SvxAlignmentTabPage( Window* pParent,
//STRIP001 										  const SfxItemSet& rCoreAttrs ) :
//STRIP001 
//STRIP001 	SfxTabPage( pParent, SVX_RES( RID_SVXPAGE_ALIGNMENT ), rCoreAttrs ),
//STRIP001 
//STRIP001     aFlAlignment    ( this, ResId( FL_ALIGNMENT ) ),
//STRIP001     aFtHorAlign     ( this, ResId( FT_HORALIGN ) ),
//STRIP001     aLbHorAlign     ( this, ResId( LB_HORALIGN ) ),
//STRIP001     aFtIndent       ( this, ResId( FT_INDENT ) ),
//STRIP001     aEdIndent       ( this, ResId( ED_INDENT ) ),
//STRIP001     aFtVerAlign     ( this, ResId( FT_VERALIGN ) ),
//STRIP001     aLbVerAlign     ( this, ResId( LB_VERALIGN ) ),
//STRIP001 
//STRIP001 	aWinOrient		( this,ResId(CTR_DIAL),ResId(BTN_TXTSTACKED),
//STRIP001                         ResId(FT_DEGREES),ResId(NF_DEGREES),ResId(FT_BORDER_LOCK),
//STRIP001                         ResId(CTR_BORDER_LOCK),ResId(FL_ORIENTATION)),   //@ 12.09.97
//STRIP001     aBtnAsianVert   ( this, ResId( BTN_ASIAN_VERTICAL ) ),
//STRIP001 
//STRIP001     aFlSpace        ( this, ResId( FL_SPACE ) ),
//STRIP001 	aFtLeftSpace	( this, ResId( FT_LEFTSPACE ) ),
//STRIP001 	aEdLeftSpace	( this, ResId( ED_LEFTSPACE ) ),
//STRIP001 	aFtRightSpace	( this, ResId( FT_RIGHTSPACE ) ),
//STRIP001 	aEdRightSpace	( this, ResId( ED_RIGHTSPACE ) ),
//STRIP001 	aFtTopSpace		( this, ResId( FT_TOPSPACE ) ),
//STRIP001 	aEdTopSpace		( this, ResId( ED_TOPSPACE ) ),
//STRIP001 	aFtBottomSpace	( this, ResId( FT_BOTTOMSPACE ) ),
//STRIP001 	aEdBottomSpace	( this, ResId( ED_BOTTOMSPACE ) ),
//STRIP001 
//STRIP001     aFlWrap         ( this, ResId( FL_WRAP ) ),
//STRIP001     aBtnWrap        ( this, ResId( BTN_WRAP ) ),
//STRIP001     aBtnHyphen      ( this, ResId( BTN_HYPH ) ),
//STRIP001     aFtTextFlow     ( this, ResId( FT_TEXTFLOW ) ),
//STRIP001     aLbFrameDir     ( this, ResId( LB_FRAMEDIR ) ),
//STRIP001 
//STRIP001     bHyphenDisabled ( FALSE )
//STRIP001 {
//STRIP001     aLbHorAlign.SetSelectHdl( LINK( this, SvxAlignmentTabPage, HorAlignSelectHdl_Impl ) );
//STRIP001     aBtnWrap.SetClickHdl( LINK( this, SvxAlignmentTabPage, WrapClickHdl_Impl ) );
//STRIP001 
//STRIP001     // Asian vertical mode
//STRIP001     if( SvtCJKOptions().IsVerticalTextEnabled() )
//STRIP001         aWinOrient.SetTxtStackedClickHdl( LINK( this, SvxAlignmentTabPage, TxtStackedClickHdl_Impl ) );
//STRIP001     else
//STRIP001         aBtnAsianVert.Hide();
//STRIP001 
//STRIP001     // CTL frame direction
//STRIP001     aLbFrameDir.InsertEntryValue( SVX_RESSTR( RID_SVXSTR_FRAMEDIR_LTR ), FRMDIR_HORI_LEFT_TOP );
//STRIP001     aLbFrameDir.InsertEntryValue( SVX_RESSTR( RID_SVXSTR_FRAMEDIR_RTL ), FRMDIR_HORI_RIGHT_TOP );
//STRIP001     aLbFrameDir.InsertEntryValue( SVX_RESSTR( RID_SVXSTR_FRAMEDIR_SUPER ), FRMDIR_ENVIRONMENT );
//STRIP001     if( !SvtLanguageOptions().IsCTLFontEnabled() )
//STRIP001     {
//STRIP001         aFtTextFlow.Hide();
//STRIP001         aLbFrameDir.Hide();
//STRIP001     }
//STRIP001 
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	// Metrik einstellen
//STRIP001 	FieldUnit eFUnit = GetModuleFieldUnit( &rCoreAttrs );
//STRIP001 
//STRIP001 	switch ( eFUnit )
//STRIP001 	{
//STRIP001 		//	#103396# the default value (1pt) can't be accurately represented in
//STRIP001 		//	inches or pica with two decimals, so point is used instead.
//STRIP001 		case FUNIT_PICA:
//STRIP001 		case FUNIT_INCH:
//STRIP001 		case FUNIT_FOOT:
//STRIP001 		case FUNIT_MILE:
//STRIP001 			eFUnit = FUNIT_POINT;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FUNIT_CM:
//STRIP001 		case FUNIT_M:
//STRIP001 		case FUNIT_KM:
//STRIP001 			eFUnit = FUNIT_MM;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	SetFieldUnit( aEdLeftSpace, eFUnit );
//STRIP001 	SetFieldUnit( aEdRightSpace, eFUnit );
//STRIP001 	SetFieldUnit( aEdTopSpace, eFUnit );
//STRIP001 	SetFieldUnit( aEdBottomSpace, eFUnit );
//STRIP001 
//STRIP001 	FillForLockMode();
//STRIP001 	FreeResource();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxAlignmentTabPage::~SvxAlignmentTabPage()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // LockMode in WinOrientation initialisieren -----------------------------
//STRIP001 
//STRIP001 void SvxAlignmentTabPage::FillForLockMode()
//STRIP001 {
//STRIP001     ResId TmpId( GetBackground().GetColor().IsDark()? IL_LOCK_BMPS_HC : IL_LOCK_BMPS );
//STRIP001 	ImageList	aIlLock( TmpId );
//STRIP001 	Size		aItemSize = aIlLock.GetImage(IID_BOTTOMLOCK).GetSizePixel();
//STRIP001 	Size		aSize;
//STRIP001 
//STRIP001 	ValueSet&	rValSet = aWinOrient.GetVSLockMode();
//STRIP001 
//STRIP001 	rValSet.SetColCount( 3 );
//STRIP001 	rValSet.SetStyle( rValSet.GetStyle() | WB_ITEMBORDER | WB_DOUBLEBORDER );
//STRIP001 	aSize = rValSet.CalcWindowSizePixel( aItemSize );
//STRIP001 
//STRIP001 	rValSet.SetSizePixel( aSize );
//STRIP001 	//aWinOrient.GetVSLockMode().SetColCount( 5 );
//STRIP001 	rValSet.InsertItem( 1, aIlLock.GetImage( IID_BOTTOMLOCK ), String( ResId( STR_BOTTOMLOCK ) ) );
//STRIP001 	rValSet.InsertItem( 2, aIlLock.GetImage( IID_TOPLOCK ), String( ResId( STR_TOPLOCK ) ) );
//STRIP001 	rValSet.InsertItem( 3, aIlLock.GetImage( IID_CELLLOCK ),String( ResId( STR_CELLLOCK ) ) );
//STRIP001 	rValSet.SetNoSelection();
//STRIP001 	rValSet.Show();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxAlignmentTabPage::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	SfxTabPage::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if( ( rDCEvt.GetType() == DATACHANGED_SETTINGS ) && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001 	{
//STRIP001 		svt::OLocalResourceAccess	aLocalResAcc( SVX_RES( RID_SVXPAGE_ALIGNMENT ), RSC_TABPAGE );
//STRIP001 		aWinOrient.GetVSLockMode().Clear();
//STRIP001 		FillForLockMode();
//STRIP001 
//STRIP001 		aWinOrient.HandleUpdatedSystemsettings();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT* SvxAlignmentTabPage::GetRanges()
//STRIP001 {
//STRIP001     return pRanges;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage*	SvxAlignmentTabPage::Create( Window* pParent,
//STRIP001 										 const SfxItemSet& rAttrSet )
//STRIP001 {
//STRIP001 	return ( new SvxAlignmentTabPage( pParent, rAttrSet ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 const SfxPoolItem* SvxAlignmentTabPage::GetUniqueItem( const SfxItemSet& rItemSet, sal_uInt16 nSlotId ) const
//STRIP001 {
//STRIP001     return (rItemSet.GetItemState( GetWhich( nSlotId ), TRUE ) >= SFX_ITEM_DEFAULT) ?
//STRIP001         GetItem( rItemSet, nSlotId ) : NULL;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxAlignmentTabPage::Reset( const SfxItemSet& rCoreAttrs )
//STRIP001 {
//STRIP001     const SfxPoolItem* pItem;
//STRIP001 
//STRIP001     pItem = GetUniqueItem( rCoreAttrs, SID_ATTR_ALIGN_HOR_JUSTIFY );
//STRIP001     if ( pItem )
//STRIP001 	{
//STRIP001         USHORT nPos = ALIGNDLG_HORALIGN_STD;
//STRIP001 		switch ( (SvxCellHorJustify)
//STRIP001 			( (const SvxHorJustifyItem*)pItem )->GetValue() )
//STRIP001 		{
//STRIP001             case SVX_HOR_JUSTIFY_LEFT:      nPos = ALIGNDLG_HORALIGN_LEFT;      break;
//STRIP001             case SVX_HOR_JUSTIFY_CENTER:    nPos = ALIGNDLG_HORALIGN_CENTER;    break;
//STRIP001             case SVX_HOR_JUSTIFY_RIGHT:     nPos = ALIGNDLG_HORALIGN_RIGHT;     break;
//STRIP001             case SVX_HOR_JUSTIFY_BLOCK:     nPos = ALIGNDLG_HORALIGN_BLOCK;     break;
//STRIP001 		}
//STRIP001         aLbHorAlign.SelectEntryPos( nPos );
//STRIP001 	}
//STRIP001     else
//STRIP001         aLbHorAlign.SetNoSelection();
//STRIP001 
//STRIP001     pItem = GetUniqueItem( rCoreAttrs, SID_ATTR_ALIGN_INDENT );
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		// Einzug in Twips -> umrechnen in Point
//STRIP001 		USHORT nVal = (USHORT)( (const SfxUInt16Item*)pItem )->GetValue();
//STRIP001 		nVal /= 20;
//STRIP001         aEdIndent.SetValue( nVal );
//STRIP001 	}
//STRIP001 	else
//STRIP001         aEdIndent.SetText( String() );
//STRIP001 
//STRIP001     pItem = GetUniqueItem( rCoreAttrs, SID_ATTR_ALIGN_VER_JUSTIFY );
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001         USHORT nPos = ALIGNDLG_VERALIGN_STD;
//STRIP001 		switch ( (SvxCellVerJustify)
//STRIP001 					( (const SvxVerJustifyItem*)pItem )->GetValue() )
//STRIP001 		{
//STRIP001             case SVX_VER_JUSTIFY_TOP:       nPos = ALIGNDLG_VERALIGN_TOP;       break;
//STRIP001             case SVX_VER_JUSTIFY_CENTER:    nPos = ALIGNDLG_VERALIGN_MID;       break;
//STRIP001             case SVX_VER_JUSTIFY_BOTTOM:    nPos = ALIGNDLG_VERALIGN_BOTTOM;    break;
//STRIP001 		}
//STRIP001         aLbVerAlign.SelectEntryPos( nPos );
//STRIP001 	}
//STRIP001     else
//STRIP001         aLbVerAlign.SetNoSelection();
//STRIP001 
//STRIP001     pItem = GetUniqueItem( rCoreAttrs, SID_ATTR_ALIGN_ORIENTATION );
//STRIP001     aWinOrient.SetNoDegrees();
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		switch ( (SvxCellOrientation)
//STRIP001 					( (const SvxOrientationItem*)pItem )->GetValue() )
//STRIP001 		{
//STRIP001 			case SVX_ORIENTATION_STANDARD:
//STRIP001                     pItem = GetUniqueItem( rCoreAttrs, SID_ATTR_ALIGN_DEGREES );
//STRIP001 					if(pItem)
//STRIP001 					{
//STRIP001 						aWinOrient.SetDegrees(
//STRIP001 							((const SfxInt32Item*) pItem)->GetValue()/100);
//STRIP001 					}
//STRIP001 					break;
//STRIP001 			case SVX_ORIENTATION_TOPBOTTOM:	aWinOrient.SetDegrees(270); break;
//STRIP001 			case SVX_ORIENTATION_STACKED:	aWinOrient.SetStackedTxt(TRUE); break;
//STRIP001 			case SVX_ORIENTATION_BOTTOMTOP:	aWinOrient.SetDegrees(90); break;
//STRIP001 			default:						aWinOrient.SetDegrees(0);
//STRIP001 		};
//STRIP001 	}
//STRIP001 
//STRIP001     pItem = GetUniqueItem( rCoreAttrs, SID_ATTR_ALIGN_LOCKPOS );
//STRIP001     if( pItem )
//STRIP001     {
//STRIP001         aWinOrient.SetRotateMode((SvxRotateMode)
//STRIP001                         ( (const SvxRotateModeItem*)pItem )->GetValue() );
//STRIP001     }
//STRIP001 
//STRIP001     pItem = GetUniqueItem( rCoreAttrs, SID_ATTR_ALIGN_ASIANVERTICAL );
//STRIP001     if( pItem )
//STRIP001     {
//STRIP001         aBtnAsianVert.EnableTriState( FALSE );
//STRIP001         aBtnAsianVert.SetState( TriState(
//STRIP001             ((const SfxBoolItem*)pItem)->GetValue() ? STATE_CHECK : STATE_NOCHECK ) );
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         aBtnAsianVert.EnableTriState();
//STRIP001         aBtnAsianVert.SetState( TriState( STATE_DONTKNOW ) );
//STRIP001     }
//STRIP001 
//STRIP001     pItem = GetUniqueItem( rCoreAttrs, SID_ATTR_ALIGN_MARGIN );
//STRIP001     if( pItem )
//STRIP001 	{
//STRIP001 		const SvxMarginItem* pMarginAttr = (const SvxMarginItem*)pItem;
//STRIP001 
//STRIP001 		aEdLeftSpace.SetValue( aEdLeftSpace.Normalize( (long)
//STRIP001 						(pMarginAttr->GetLeftMargin()) ),
//STRIP001 						FUNIT_TWIP );
//STRIP001 		aEdRightSpace.SetValue( aEdRightSpace.Normalize( (long)
//STRIP001 						(pMarginAttr->GetRightMargin()) ),
//STRIP001 						FUNIT_TWIP );
//STRIP001 		aEdTopSpace.SetValue( aEdTopSpace.Normalize( (long)
//STRIP001 						(pMarginAttr->GetTopMargin()) ),
//STRIP001 						FUNIT_TWIP );
//STRIP001 		aEdBottomSpace.SetValue	( aEdBottomSpace.Normalize( (long)
//STRIP001 						(pMarginAttr->GetBottomMargin()) ),
//STRIP001 						FUNIT_TWIP );
//STRIP001 	}
//STRIP001 	else // DON'T-KNOW
//STRIP001 	{
//STRIP001 		aEdLeftSpace.SetText	( String() );
//STRIP001 		aEdRightSpace.SetText	( String() );
//STRIP001 		aEdTopSpace.SetText		( String() );
//STRIP001 		aEdBottomSpace.SetText	( String() );
//STRIP001 	}
//STRIP001 
//STRIP001     pItem = GetUniqueItem( rCoreAttrs, SID_ATTR_ALIGN_LINEBREAK );
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		aBtnWrap.EnableTriState( FALSE );
//STRIP001 		aBtnWrap.SetState( ( (const SfxBoolItem*)pItem )->GetValue()
//STRIP001 						   ? TriState( STATE_CHECK )
//STRIP001 						   : TriState( STATE_NOCHECK ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBtnWrap.EnableTriState();
//STRIP001 		aBtnWrap.SetState( TriState( STATE_DONTKNOW ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (rCoreAttrs.GetItemState(GetWhich(SID_ATTR_ALIGN_HYPHENATION),TRUE) == SFX_ITEM_UNKNOWN)
//STRIP001 		bHyphenDisabled = TRUE;
//STRIP001 	else
//STRIP001 	{
//STRIP001         pItem = GetUniqueItem( rCoreAttrs, SID_ATTR_ALIGN_HYPHENATION );
//STRIP001 		if ( pItem )
//STRIP001 		{
//STRIP001 			aBtnHyphen.EnableTriState( FALSE );
//STRIP001 			aBtnHyphen.SetState( ( (const SfxBoolItem*)pItem )->GetValue()
//STRIP001 							   ? TriState( STATE_CHECK )
//STRIP001 							   : TriState( STATE_NOCHECK ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aBtnHyphen.EnableTriState();
//STRIP001 			aBtnHyphen.SetState( TriState( STATE_DONTKNOW ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     pItem = GetUniqueItem( rCoreAttrs, SID_ATTR_FRAMEDIRECTION );
//STRIP001     if( pItem )
//STRIP001     {
//STRIP001         SvxFrameDirection eDir = (SvxFrameDirection)((const SvxFrameDirectionItem*)pItem)->GetValue();
//STRIP001         aLbFrameDir.SelectEntryValue( eDir );
//STRIP001     }
//STRIP001     else
//STRIP001         aLbFrameDir.SetNoSelection();
//STRIP001 
//STRIP001     HorAlignSelectHdl_Impl( NULL );
//STRIP001 
//STRIP001     aBtnWrap.SaveValue();  // TriStateButton
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxAlignmentTabPage::FillItemSet( SfxItemSet& rCoreAttrs )
//STRIP001 {
//STRIP001 	BOOL				bAttrsChanged 	= FALSE;
//STRIP001 	const SfxItemSet&	rOldSet 		= GetItemSet();
//STRIP001 	USHORT				nWhich;
//STRIP001 	TriState			eState;
//STRIP001 	const SfxPoolItem*	pOld 			= 0;
//STRIP001     bool                bSelected       = false;
//STRIP001 
//STRIP001 	// Horizontale Ausrichtung
//STRIP001 	nWhich = GetWhich( SID_ATTR_ALIGN_HOR_JUSTIFY );
//STRIP001 	USHORT nTmp = USHRT_MAX;
//STRIP001 
//STRIP001     switch( aLbHorAlign.GetSelectEntryPos() )
//STRIP001     {
//STRIP001         case ALIGNDLG_HORALIGN_STD:     nTmp = SVX_HOR_JUSTIFY_STANDARD;    break;
//STRIP001         case ALIGNDLG_HORALIGN_LEFT:    nTmp = SVX_HOR_JUSTIFY_LEFT;        break;
//STRIP001         case ALIGNDLG_HORALIGN_CENTER:  nTmp = SVX_HOR_JUSTIFY_CENTER;      break;
//STRIP001         case ALIGNDLG_HORALIGN_RIGHT:   nTmp = SVX_HOR_JUSTIFY_RIGHT;       break;
//STRIP001         case ALIGNDLG_HORALIGN_BLOCK:   nTmp = SVX_HOR_JUSTIFY_BLOCK;       break;
//STRIP001     }
//STRIP001     bSelected = aLbHorAlign.GetSelectEntryCount() > 0;
//STRIP001     pOld = GetUniqueItem( rOldSet, SID_ATTR_ALIGN_HOR_JUSTIFY );
//STRIP001 
//STRIP001     DBG_ASSERT( !bSelected || (USHRT_MAX != nTmp) || !aLbHorAlign.IsEnabled(), "no button checked" );
//STRIP001         // if aLbHorAlign is disabled SetFlags was called with the WBA_NO_HORIZONTAL flag set
//STRIP001 		// 67977 - 30.07.99 - FS
//STRIP001 
//STRIP001     if ( bSelected && (!pOld || (((const SvxHorJustifyItem*)pOld)->GetValue() != nTmp)) )
//STRIP001 	{
//STRIP001 		rCoreAttrs.Put( SvxHorJustifyItem( (SvxCellHorJustify)nTmp, nWhich ) );
//STRIP001 		bAttrsChanged |= TRUE;
//STRIP001 	}
//STRIP001 	else if ( rOldSet.GetItemState( nWhich, FALSE ) == SFX_ITEM_DEFAULT )
//STRIP001 		rCoreAttrs.ClearItem( nWhich );
//STRIP001 
//STRIP001 	nWhich = GetWhich( SID_ATTR_ALIGN_INDENT );
//STRIP001 	pOld = GetOldItem( rCoreAttrs, SID_ATTR_ALIGN_INDENT );
//STRIP001     nTmp = aEdIndent.GetValue() * 20; // Point in twips
//STRIP001 
//STRIP001 	if ( !pOld || ( (const SfxUInt16Item*)pOld )->GetValue() != nTmp )
//STRIP001 	{
//STRIP001 		rCoreAttrs.Put( SfxUInt16Item( nWhich, nTmp ) );
//STRIP001 		bAttrsChanged |= TRUE;
//STRIP001 	}
//STRIP001 	else if ( rOldSet.GetItemState( nWhich, FALSE ) == SFX_ITEM_DEFAULT )
//STRIP001 		rCoreAttrs.ClearItem( nWhich );
//STRIP001 
//STRIP001 	// Vertikale Ausrichtung
//STRIP001 	nWhich = GetWhich( SID_ATTR_ALIGN_VER_JUSTIFY );
//STRIP001 	nTmp = USHRT_MAX;
//STRIP001 
//STRIP001     switch( aLbVerAlign.GetSelectEntryPos() )
//STRIP001     {
//STRIP001         case ALIGNDLG_VERALIGN_STD:     nTmp = SVX_VER_JUSTIFY_STANDARD;    break;
//STRIP001         case ALIGNDLG_VERALIGN_TOP:     nTmp = SVX_VER_JUSTIFY_TOP;         break;
//STRIP001         case ALIGNDLG_VERALIGN_MID:     nTmp = SVX_VER_JUSTIFY_CENTER;      break;
//STRIP001         case ALIGNDLG_VERALIGN_BOTTOM:  nTmp = SVX_VER_JUSTIFY_BOTTOM;      break;
//STRIP001     }
//STRIP001     bSelected = aLbVerAlign.GetSelectEntryCount() > 0;
//STRIP001     pOld = GetUniqueItem( rOldSet, SID_ATTR_ALIGN_VER_JUSTIFY );
//STRIP001 
//STRIP001     DBG_ASSERT( !bSelected || (USHRT_MAX != nTmp) || !aLbVerAlign.IsEnabled(), "no button checked" );
//STRIP001         // if aLbVerAlign is disabled SetFlags was called with the WBA_NO_VERTICAL flag set
//STRIP001 		// 67977 - 30.07.99 - FS
//STRIP001 
//STRIP001     if ( bSelected && (!pOld || (((const SvxVerJustifyItem*)pOld )->GetValue() != nTmp)) )
//STRIP001 	{
//STRIP001 		rCoreAttrs.Put( SvxVerJustifyItem( (SvxCellVerJustify)nTmp, nWhich ) );
//STRIP001 		bAttrsChanged |= TRUE;
//STRIP001 	}
//STRIP001 	else if ( rOldSet.GetItemState( nWhich, FALSE ) == SFX_ITEM_DEFAULT )
//STRIP001 		rCoreAttrs.ClearItem( nWhich );
//STRIP001 
//STRIP001     if ( aWinOrient.HasDegrees() )
//STRIP001     {
//STRIP001         // Schreibrichtung
//STRIP001         nWhich = GetWhich( SID_ATTR_ALIGN_ORIENTATION );
//STRIP001 
//STRIP001         nTmp = SVX_ORIENTATION_STANDARD;
//STRIP001 
//STRIP001         if ( aWinOrient.IsStackedTxt() )
//STRIP001             nTmp = SVX_ORIENTATION_STACKED;
//STRIP001         else if ( aWinOrient.GetDegrees()==90 )
//STRIP001             nTmp = SVX_ORIENTATION_BOTTOMTOP;
//STRIP001         else if ( aWinOrient.GetDegrees()==270 )
//STRIP001             nTmp = SVX_ORIENTATION_TOPBOTTOM;
//STRIP001 
//STRIP001         pOld = GetUniqueItem( rOldSet, SID_ATTR_ALIGN_ORIENTATION );
//STRIP001 
//STRIP001         if ( !pOld || ( (const SvxOrientationItem*)pOld )->GetValue() != nTmp )
//STRIP001         {
//STRIP001             rCoreAttrs.Put(
//STRIP001                 SvxOrientationItem( (SvxCellOrientation)nTmp, nWhich ) );
//STRIP001             bAttrsChanged |= TRUE;
//STRIP001         }
//STRIP001         else if ( rOldSet.GetItemState( nWhich, FALSE ) == SFX_ITEM_DEFAULT )
//STRIP001             rCoreAttrs.ClearItem( nWhich );
//STRIP001 
//STRIP001         // Schreibwinkel
//STRIP001         nWhich = GetWhich( SID_ATTR_ALIGN_DEGREES );
//STRIP001 
//STRIP001         long nDegrees=aWinOrient.GetDegrees()*100L;
//STRIP001 
//STRIP001         pOld = GetUniqueItem( rOldSet, SID_ATTR_ALIGN_DEGREES );
//STRIP001 
//STRIP001         if ( !pOld || ( (const SfxInt32Item*)pOld )->GetValue() != nDegrees )
//STRIP001         {
//STRIP001             rCoreAttrs.Put(SfxInt32Item( nWhich,nDegrees) );
//STRIP001             bAttrsChanged |= TRUE;
//STRIP001         }
//STRIP001         else if ( rOldSet.GetItemState( nWhich, FALSE ) == SFX_ITEM_DEFAULT )
//STRIP001             rCoreAttrs.ClearItem( nWhich );
//STRIP001     }
//STRIP001 
//STRIP001 	// Bezugskante
//STRIP001 
//STRIP001 	nWhich = GetWhich( SID_ATTR_ALIGN_LOCKPOS );
//STRIP001 
//STRIP001 	SvxRotateMode nRotMode=aWinOrient.GetRotateMode();
//STRIP001 
//STRIP001 	pOld = GetOldItem( rCoreAttrs, SID_ATTR_ALIGN_LOCKPOS );
//STRIP001 
//STRIP001 	if(aWinOrient.IsSelRotateMode())
//STRIP001 	{
//STRIP001 		if ( !pOld ||
//STRIP001 			((SvxRotateMode)((const SvxRotateModeItem*)pOld )->GetValue()) != nRotMode )
//STRIP001 		{
//STRIP001 			rCoreAttrs.Put(SvxRotateModeItem( nRotMode,nWhich) );
//STRIP001 			bAttrsChanged |= TRUE;
//STRIP001 		}
//STRIP001 		else if ( rOldSet.GetItemState( nWhich, FALSE ) == SFX_ITEM_DEFAULT )
//STRIP001 			rCoreAttrs.ClearItem( nWhich );
//STRIP001 	}
//STRIP001 
//STRIP001     // Asian vertical mode
//STRIP001     nWhich = GetWhich( SID_ATTR_ALIGN_ASIANVERTICAL );
//STRIP001     eState = aBtnAsianVert.GetState();
//STRIP001     pOld = GetOldItem( rCoreAttrs, SID_ATTR_ALIGN_ASIANVERTICAL );
//STRIP001 
//STRIP001     if ( !pOld || (((const SfxBoolItem*)pOld )->GetValue() != (eState == STATE_CHECK)) ||
//STRIP001         (aBtnAsianVert.IsTriStateEnabled() && (eState != STATE_DONTKNOW)) ) // changed from "don't care"
//STRIP001 	{
//STRIP001 		rCoreAttrs.Put( SfxBoolItem( nWhich, (eState == STATE_CHECK) ) );
//STRIP001 		bAttrsChanged = TRUE;
//STRIP001 	}
//STRIP001 	else if ( rOldSet.GetItemState( nWhich, FALSE ) == SFX_ITEM_DEFAULT )
//STRIP001 		rCoreAttrs.ClearItem( nWhich );
//STRIP001 
//STRIP001 	// Abst"ande zum Zellinhalt
//STRIP001 
//STRIP001     // #106224# all edits empty: do nothing
//STRIP001     if( aEdLeftSpace.GetText().Len() || aEdRightSpace.GetText().Len() ||
//STRIP001         aEdTopSpace.GetText().Len() || aEdBottomSpace.GetText().Len() )
//STRIP001     {
//STRIP001         nWhich = GetWhich( SID_ATTR_ALIGN_MARGIN );
//STRIP001         SvxMarginItem aMargin(
//STRIP001             (INT16)aEdLeftSpace.Denormalize(
//STRIP001                 aEdLeftSpace.GetValue( FUNIT_TWIP ) ),
//STRIP001             (INT16)aEdTopSpace.Denormalize(
//STRIP001                 aEdTopSpace.GetValue( FUNIT_TWIP ) ),
//STRIP001             (INT16)aEdRightSpace.Denormalize(
//STRIP001                 aEdRightSpace.GetValue( FUNIT_TWIP ) ),
//STRIP001             (INT16)aEdBottomSpace.Denormalize(
//STRIP001                 aEdBottomSpace.GetValue( FUNIT_TWIP ) ),
//STRIP001             nWhich );
//STRIP001         pOld = GetOldItem( rCoreAttrs, SID_ATTR_ALIGN_MARGIN );
//STRIP001 
//STRIP001         if ( !pOld || !( *(const SvxMarginItem*)pOld == aMargin ) )
//STRIP001         {
//STRIP001             rCoreAttrs.Put( aMargin );
//STRIP001             bAttrsChanged |= TRUE;
//STRIP001         }
//STRIP001         else if ( rOldSet.GetItemState( nWhich, FALSE ) == SFX_ITEM_DEFAULT )
//STRIP001             rCoreAttrs.ClearItem( nWhich );
//STRIP001     }
//STRIP001 
//STRIP001 	// Zeilenumbruch
//STRIP001 	nWhich = GetWhich( SID_ATTR_ALIGN_LINEBREAK );
//STRIP001 	eState = aBtnWrap.GetState();
//STRIP001 	pOld = GetOldItem( rCoreAttrs, SID_ATTR_ALIGN_LINEBREAK );
//STRIP001 
//STRIP001     if( !pOld || (((const SfxBoolItem*)pOld )->GetValue() != (eState == STATE_CHECK)) ||
//STRIP001         (aBtnWrap.IsTriStateEnabled() && (eState != STATE_DONTKNOW)) ) // changed from "don't care"
//STRIP001 	{
//STRIP001 		rCoreAttrs.Put( SfxBoolItem( nWhich, (eState == STATE_CHECK) ) );
//STRIP001 		bAttrsChanged = TRUE;
//STRIP001 	}
//STRIP001 	else if ( rOldSet.GetItemState( nWhich, FALSE ) == SFX_ITEM_DEFAULT )
//STRIP001 		rCoreAttrs.ClearItem( nWhich );
//STRIP001 
//STRIP001 	// Hyphenation
//STRIP001 	nWhich = GetWhich( SID_ATTR_ALIGN_HYPHENATION );
//STRIP001 	eState = aBtnHyphen.GetState();
//STRIP001 	pOld = GetOldItem( rCoreAttrs, SID_ATTR_ALIGN_HYPHENATION );
//STRIP001 
//STRIP001     if ( !pOld || (((const SfxBoolItem*)pOld )->GetValue() != (eState == STATE_CHECK)) ||
//STRIP001         (aBtnHyphen.IsTriStateEnabled() && (eState != STATE_DONTKNOW)) ) // changed from "don't care"
//STRIP001 	{
//STRIP001 		rCoreAttrs.Put( SfxBoolItem( nWhich, (eState == STATE_CHECK) ) );
//STRIP001 		bAttrsChanged = TRUE;
//STRIP001 	}
//STRIP001 	else if ( rOldSet.GetItemState( nWhich, FALSE ) == SFX_ITEM_DEFAULT )
//STRIP001 		rCoreAttrs.ClearItem( nWhich );
//STRIP001 
//STRIP001     // CTL frame direction
//STRIP001     nWhich = GetWhich( SID_ATTR_FRAMEDIRECTION );
//STRIP001     pOld = GetUniqueItem( rOldSet, SID_ATTR_FRAMEDIRECTION );
//STRIP001     SvxFrameDirection eDir = aLbFrameDir.GetSelectEntryValue();
//STRIP001     bSelected = aLbFrameDir.GetSelectEntryCount() > 0;
//STRIP001 
//STRIP001     if( bSelected && (!pOld || (((const SvxFrameDirectionItem*)pOld)->GetValue() != eDir)) )
//STRIP001     {
//STRIP001         rCoreAttrs.Put( SvxFrameDirectionItem( eDir, nWhich ) );
//STRIP001         bAttrsChanged = TRUE;
//STRIP001     }
//STRIP001     else if ( rOldSet.GetItemState( nWhich, FALSE ) == SFX_ITEM_DEFAULT )
//STRIP001         rCoreAttrs.ClearItem( nWhich );
//STRIP001 
//STRIP001 	return bAttrsChanged;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxAlignmentTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if ( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxAlignmentTabPage, HorAlignSelectHdl_Impl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001     BOOL bChecked = (aLbHorAlign.GetSelectEntryPos() == ALIGNDLG_HORALIGN_LEFT);
//STRIP001     aFtIndent.Enable( bChecked );
//STRIP001     aEdIndent.Enable( bChecked );
//STRIP001 	EnableHyphen_Impl();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxAlignmentTabPage, WrapClickHdl_Impl, TriStateBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	EnableHyphen_Impl();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxAlignmentTabPage, TxtStackedClickHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001     aBtnAsianVert.Enable( aWinOrient.IsStackedTxt() );
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxAlignmentTabPage::EnableHyphen_Impl()
//STRIP001 {
//STRIP001 	BOOL bWrap = (aBtnWrap.GetState() == STATE_CHECK);
//STRIP001 	BOOL bBlock = (aLbHorAlign.GetSelectEntryPos() == ALIGNDLG_HORALIGN_BLOCK);
//STRIP001 	BOOL bEnable = ( ( bWrap || bBlock ) && !bHyphenDisabled );
//STRIP001 	aBtnHyphen.Enable( bEnable );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxAlignmentTabPage::SetFlags( USHORT nFlags )
//STRIP001 {
//STRIP001     /* This method allows to disable specific control groups. */
//STRIP001 
//STRIP001 	if ( ( nFlags & WBA_NO_ORIENTATION ) == WBA_NO_ORIENTATION )
//STRIP001 	{
//STRIP001 		aWinOrient.Disable();
//STRIP001         aBtnAsianVert.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( ( nFlags & WBA_NO_LINEBREAK ) == WBA_NO_LINEBREAK )
//STRIP001 	{
//STRIP001         aFlWrap.Disable();
//STRIP001 		aBtnWrap.Disable();
//STRIP001         aFtTextFlow.Disable();
//STRIP001         aLbFrameDir.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nFlags & ( WBA_NO_LINEBREAK | WBA_NO_HYPHENATION ) )
//STRIP001 	{
//STRIP001 		//	WBA_NO_LINEBREAK also disables hyphenation
//STRIP001 
//STRIP001 		bHyphenDisabled = TRUE;
//STRIP001 		aBtnHyphen.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( ( nFlags & WBA_NO_HORIZONTAL ) == WBA_NO_HORIZONTAL )
//STRIP001 	{
//STRIP001         aFtHorAlign.Disable();
//STRIP001         aLbHorAlign.Disable();
//STRIP001         aFtIndent.Disable();
//STRIP001         aEdIndent.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( ( nFlags & WBA_NO_LEFTINDENT ) == WBA_NO_LEFTINDENT )
//STRIP001 	{
//STRIP001         aFtIndent.Hide();
//STRIP001         aEdIndent.Hide();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( ( nFlags & WBA_NO_VERTICAL ) == WBA_NO_VERTICAL )
//STRIP001 	{
//STRIP001         aFtVerAlign.Disable();
//STRIP001         aLbVerAlign.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( ( nFlags & WBA_NO_GRIDLINES ) == WBA_NO_GRIDLINES )
//STRIP001 	{
//STRIP001         aFlSpace.Disable();
//STRIP001 		aFtLeftSpace.Disable();
//STRIP001 		aEdLeftSpace.Disable();
//STRIP001 		aFtRightSpace.Disable();
//STRIP001 		aEdRightSpace.Disable();
//STRIP001 		aFtTopSpace.Disable();
//STRIP001 		aEdTopSpace.Disable();
//STRIP001 		aFtBottomSpace.Disable();
//STRIP001 		aEdBottomSpace.Disable();
//STRIP001 	}
//STRIP001 }


}
