/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: starmath_toolbox.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:06:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXAPP_HXX //autogen
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
// auto strip #ifndef _SFXINTITEM_HXX //autogen
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVTOOLS_IMGDEF_HXX
// auto strip #include <svtools/imgdef.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SFXIMGMGR_HXX //autogen
// auto strip #include <bf_sfx2/imgmgr.hxx>
// auto strip #endif
// auto strip #ifndef _SV_WRKWIN_HXX //autogen
// auto strip #include <vcl/wrkwin.hxx>
// auto strip #endif

// auto strip #ifndef TOOLBOX_HXX
// auto strip #include "toolbox.hxx"
// auto strip #endif
#ifndef _STARMATH_HRC
#include "starmath.hrc"
#endif
#ifndef _TOOLBOX_HRC_
#include "toolbox.hrc"
#endif
// auto strip #include "view.hxx"
namespace binfilter {



//STRIP001 /*N*/ SmToolBoxWindow::SmToolBoxWindow(SfxBindings *pBindings,
//STRIP001 /*N*/ 								 SfxChildWindow *pChildWindow,
//STRIP001 /*N*/ 								 Window *pParent) :
//STRIP001 /*N*/ 	SfxFloatingWindow(pBindings, pChildWindow, pParent, SmResId(RID_TOOLBOXWINDOW)),
//STRIP001 /*N*/     aToolBoxCat(this, ResId(NUM_TBX_CATEGORIES + 1)),
//STRIP001 /*N*/     aToolBoxCat_Delim(this, ResId( FL_TOOLBOX_CAT_DELIM ))
//STRIP001 /*N*/ {
//STRIP001 /*N*/     // allow for cursor travelling between toolbox and sub-categories
//STRIP001 /*N*/     SetStyle( GetStyle() | WB_DIALOGCONTROL );
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	nActiveCategory = -1;
//STRIP001 /*N*/ 
//STRIP001 /*N*/     SfxImageManager *pImgMan = pBindings->GetImageManager();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	aToolBoxCat.SetClickHdl(LINK(this, SmToolBoxWindow, CategoryClickHdl));
//STRIP001 /*N*/     //! register toolbox and prevent it from changing to large buttons
//STRIP001 /*N*/     //! if the corresponding option in Tools/Options get set
//STRIP001 /*N*/     const USHORT nFlags = 0xFFFF & ~SFX_TOOLBOX_CHANGESYMBOLSET;
//STRIP001 /*N*/     pImgMan->RegisterToolBox( &aToolBoxCat, nFlags );
//STRIP001 /*N*/ 
//STRIP001 /*N*/     int i;
//STRIP001 /*N*/     for (i = 0;  i < NUM_TBX_CATEGORIES;  i++)
//STRIP001 /*N*/ 	{
//STRIP001 /*N*/ 		ToolBox *pBox = new ToolBox(this, ResId (i+1));
//STRIP001 /*N*/         pImgMan->RegisterToolBox( pBox, nFlags );
//STRIP001 /*N*/ 		vToolBoxCategories[i] = pBox;
//STRIP001 /*N*/ 		pBox->SetSelectHdl(LINK(this, SmToolBoxWindow, CmdSelectHdl));
//STRIP001 /*N*/ 	}
//STRIP001 /*N*/     pToolBoxCmd = vToolBoxCategories[0];
//STRIP001 /*N*/ 
//STRIP001 /*N*/     // get ImageList
//STRIP001 /*N*/     for (i = 0;  i < NUM_TBX_CATEGORIES;  i++)
//STRIP001 /*N*/ 	{
//STRIP001 /*N*/         aImageLists [i] = new ImageList( SmResId(IL_UNOP  + 2*i) );
//STRIP001 /*N*/         aImageListsH[i] = new ImageList( SmResId(ILH_UNOP + 2*i) );
//STRIP001 /*N*/ 	}
//STRIP001 /*N*/     aImageLists [NUM_TBX_CATEGORIES] = new ImageList( SmResId(IL_IMG) );
//STRIP001 /*N*/     aImageListsH[NUM_TBX_CATEGORIES] = new ImageList( SmResId(ILH_IMG) );
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	FreeResource();
//STRIP001 /*N*/ 
//STRIP001 /*N*/     ApplyImageLists();
//STRIP001 /*N*/ }

//STRIP001 /*N*/ SmToolBoxWindow::~SmToolBoxWindow()
//STRIP001 /*N*/ {
//STRIP001 /*N*/     SfxImageManager *pImgMan = GetBindings().GetImageManager();
//STRIP001 /*N*/ 	pImgMan->ReleaseToolBox( &aToolBoxCat );
//STRIP001 /*N*/ 
//STRIP001 /*N*/     int i;
//STRIP001 /*N*/     for (i = 0;  i < NUM_TBX_CATEGORIES;  i++)
//STRIP001 /*N*/ 	{
//STRIP001 /*N*/ 		ToolBox *pBox = vToolBoxCategories[i];
//STRIP001 /*N*/ 		pImgMan->ReleaseToolBox( pBox );
//STRIP001 /*N*/ 		delete pBox;
//STRIP001 /*N*/ 	}
//STRIP001 /*N*/     for (i = 0;  i < NUM_TBX_CATEGORIES + 1;  ++i)
//STRIP001 /*N*/ 	{
//STRIP001 /*N*/         delete aImageLists[i];
//STRIP001 /*N*/         delete aImageListsH[i];
//STRIP001 /*N*/ 	}
//STRIP001 /*N*/ }

//STRIP001 /*N*/ void SmToolBoxWindow::ApplyImageLists()
//STRIP001 /*N*/ {
//STRIP001 /*N*/     BOOL bHighContrast = GetDisplayBackground().GetColor().IsDark() != 0;
//STRIP001 /*N*/     ImageList ** const &rImgList = bHighContrast ? aImageListsH : aImageLists;
//STRIP001 /*N*/     for (int i = 0;  i < NUM_TBX_CATEGORIES;  ++i)
//STRIP001 /*N*/         vToolBoxCategories[i]->SetImageList( *rImgList[i] );
//STRIP001 /*N*/     aToolBoxCat.SetImageList( *rImgList[NUM_TBX_CATEGORIES] );
//STRIP001 /*N*/ }

//STRIP001 void SmToolBoxWindow::DataChanged( const DataChangedEvent &rEvt )
//STRIP001 {
//STRIP001     if ( (rEvt.GetType() == DATACHANGED_SETTINGS) && (rEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001             ApplyImageLists();
//STRIP001 
//STRIP001     SfxFloatingWindow::DataChanged( rEvt );
//STRIP001 }

//STRIP001 /*N*/ void SmToolBoxWindow::StateChanged( StateChangedType nStateChange )
//STRIP001 /*N*/ {
//STRIP001 /*N*/     static BOOL bSetPosition = TRUE;
//STRIP001 /*N*/     if (STATE_CHANGE_INITSHOW == nStateChange)
//STRIP001 /*N*/     {
//STRIP001 /*N*/         // calculate initial position to be used after creation of the window...
//STRIP001 /*N*/         AdjustPosSize( bSetPosition );
//STRIP001 /*N*/         bSetPosition = FALSE;
//STRIP001 /*N*/ 
//STRIP001 /*N*/         SetCategory(RID_UNBINOPS_CAT);
//STRIP001 /*N*/     }
//STRIP001 /*N*/     //... otherwise the base class will remember the last position of the window
//STRIP001 /*N*/     SfxFloatingWindow::StateChanged( nStateChange );
//STRIP001 /*N*/ }


//STRIP001 /*N*/ void SmToolBoxWindow::AdjustPosSize( BOOL bSetPos )
//STRIP001 /*N*/ {
//STRIP001 /*N*/ 	Size		CatSize (31 * 5, 31 * 2);
//STRIP001 /*N*/ 	Size		CmdSize (31 * 5, 31 * 5);
//STRIP001 /*N*/ 	Size		WndSize (31 * 5, CatSize.Height() + 10 + CmdSize.Height());
//STRIP001 /*N*/ 
//STRIP001 /*N*/     // basic window settings
//STRIP001 /*N*/     SetOutputSizePixel(WndSize);
//STRIP001 /*N*/     // catalog settings
//STRIP001 /*N*/     aToolBoxCat.SetPosPixel( Point(0, 3) );
//STRIP001 /*N*/     aToolBoxCat.SetSizePixel( CatSize );
//STRIP001 /*N*/     // settings for catalog / category delimiter
//STRIP001 /*N*/     Point aP( aToolBoxCat_Delim.GetPosPixel() );
//STRIP001 /*N*/     aP.X() += 5;
//STRIP001 /*N*/     aToolBoxCat_Delim.SetPosPixel( aP );
//STRIP001 /*N*/     Size  aS( CatSize.Width() - 10, 10 );
//STRIP001 /*N*/     aToolBoxCat_Delim.SetSizePixel( aS );
//STRIP001 /*N*/     // category settings
//STRIP001 /*N*/ 	for (int i = 0;  i < NUM_TBX_CATEGORIES;  i++)
//STRIP001 /*N*/         vToolBoxCategories[i]->SetSizePixel(CmdSize);
//STRIP001 /*N*/ 
//STRIP001 /*N*/     if (bSetPos)
//STRIP001 /*N*/ 	{
//STRIP001 /*N*/         SmViewShell *pView = SmGetActiveView();
//STRIP001 /*N*/         DBG_ASSERT( pView, "view shell missing" );
//STRIP001 /*N*/         Point aPos( 50, 75 );
//STRIP001 /*N*/         if (pView)
//STRIP001 /*N*/         {
//STRIP001 /*N*/             SmGraphicWindow &rWin = pView->GetGraphicWindow();
//STRIP001 /*N*/             aPos = Point( rWin.OutputToScreenPixel(
//STRIP001 /*N*/                             Point( rWin.GetSizePixel().Width() - WndSize.Width(), 0) ) );
//STRIP001 /*N*/         }
//STRIP001 /*N*/ 		if (aPos.X() < 0)
//STRIP001 /*N*/ 			aPos.X() = 0;
//STRIP001 /*N*/ 		if (aPos.Y() < 0)
//STRIP001 /*N*/ 			aPos.Y() = 0;
//STRIP001 /*N*/         SetPosPixel( aPos );
//STRIP001 /*N*/ 	}
//STRIP001 /*N*/ }


//STRIP001 BOOL SmToolBoxWindow::Close()
//STRIP001 {
//STRIP001 	SmViewShell *pViewSh = SmGetActiveView();
//STRIP001 	if (pViewSh)
//STRIP001 		pViewSh->GetViewFrame()->GetDispatcher()->Execute(
//STRIP001 				SID_TOOLBOX, SFX_CALLMODE_STANDARD,
//STRIP001 				new SfxBoolItem(SID_TOOLBOX, FALSE), 0L);
//STRIP001 	return TRUE;
//STRIP001 }

//STRIP001 void SmToolBoxWindow::GetFocus()
//STRIP001 {
//STRIP001     // give focus to category toolbox
//STRIP001     // (allow for cursor travelling when a category is selected with the mouse)
//STRIP001     aToolBoxCat.GrabFocus();
//STRIP001 }

//STRIP001 /*N*/ void SmToolBoxWindow::SetCategory(USHORT nCategory)
//STRIP001 /*N*/ {
//STRIP001 /*N*/ 	if (nCategory != nActiveCategory)
//STRIP001 /*N*/ 	{
//STRIP001 /*N*/ 		USHORT nLines,
//STRIP001 /*N*/ 			   nWhatBox;
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		// check for valid resource id
//STRIP001 /*N*/ 		switch (nCategory)
//STRIP001 /*N*/ 		{
//STRIP001 /*N*/ 			case RID_UNBINOPS_CAT :		nWhatBox = 0; nLines = 4; break;
//STRIP001 /*N*/ 			case RID_RELATIONS_CAT:		nWhatBox = 1; nLines = 5; break;
//STRIP001 /*N*/ 			case RID_SETOPERATIONS_CAT: nWhatBox = 2; nLines = 5; break;
//STRIP001 /*N*/ 			case RID_FUNCTIONS_CAT:		nWhatBox = 3; nLines = 5; break;
//STRIP001 /*N*/ 			case RID_OPERATORS_CAT:		nWhatBox = 4; nLines = 3; break;
//STRIP001 /*N*/ 			case RID_ATTRIBUTES_CAT:	nWhatBox = 5; nLines = 5; break;
//STRIP001 /*N*/ 			case RID_MISC_CAT:			nWhatBox = 8; nLines = 4; break;
//STRIP001 /*N*/ 			case RID_BRACKETS_CAT:		nWhatBox = 6; nLines = 5; break;
//STRIP001 /*N*/ 			case RID_FORMAT_CAT:		nWhatBox = 7; nLines = 3; break;
//STRIP001 /*N*/ 			default:
//STRIP001 /*N*/ 				// nothing to be done
//STRIP001 /*N*/ 				return;
//STRIP001 /*N*/ 		}
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		pToolBoxCmd->Hide();
//STRIP001 /*N*/ 
//STRIP001 /*N*/         pToolBoxCmd = vToolBoxCategories[nWhatBox];
//STRIP001 /*N*/ 
//STRIP001 /*N*/         // calculate actual size of window to use
//STRIP001 /*N*/         Size  CatSize (31 * 5, 31 * 2);
//STRIP001 /*N*/ 		Size  CmdSize (31 * 5, 31 * nLines);
//STRIP001 /*N*/         Size  WndSize (31 * 5, CatSize.Height() + 2*10 + CmdSize.Height());
//STRIP001 /*N*/         SetOutputSizePixel(WndSize);
//STRIP001 /*N*/ 
//STRIP001 /*N*/         if (nActiveCategory)
//STRIP001 /*N*/ 			aToolBoxCat.CheckItem(nActiveCategory, FALSE);
//STRIP001 /*N*/ 		nActiveCategory = nCategory;
//STRIP001 /*N*/ 		aToolBoxCat.CheckItem(nActiveCategory, TRUE);
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		pToolBoxCmd->Show();
//STRIP001 /*N*/ 	}
//STRIP001 /*N*/ }


//STRIP001 /*N*/ IMPL_LINK_INLINE_START( SmToolBoxWindow, CategoryClickHdl, ToolBox*, pToolBox)
//STRIP001 /*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	SetCategory(pToolBox->GetCurItemId());
//STRIP001 /*N*/ 	return 0;
//STRIP001 /*N*/ }
//STRIP001 /*N*/ IMPL_LINK_INLINE_END( SmToolBoxWindow, CategoryClickHdl, ToolBox*, pToolBox)


//STRIP001 /*N*/ IMPL_LINK_INLINE_START( SmToolBoxWindow, CmdSelectHdl, ToolBox*, pToolBox)
//STRIP001 /*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 //STRIP001 	SmViewShell *pViewSh = SmGetActiveView();
//STRIP001 	if (pViewSh)
//STRIP001 		pViewSh->GetViewFrame()->GetDispatcher()->Execute(
//STRIP001 				SID_INSERTCOMMAND, SFX_CALLMODE_STANDARD,
//STRIP001 				new SfxInt16Item(SID_INSERTCOMMAND, pToolBox->GetCurItemId()), 0L);
//STRIP001 /*N*/ 	return 0;
//STRIP001 /*N*/ }
//STRIP001 /*N*/ IMPL_LINK_INLINE_END( SmToolBoxWindow, CmdSelectHdl, ToolBox*, pToolBox)


/**************************************************************************/

//STRIP001 /*N*/ SFX_IMPL_FLOATINGWINDOW(SmToolBoxWrapper, SID_TOOLBOXWINDOW);
//STRIP001 /*N*/ 
//STRIP001 /*N*/ SmToolBoxWrapper::SmToolBoxWrapper(Window *pParentWindow,
//STRIP001 /*N*/ 								   USHORT nId, SfxBindings* pBindings,
//STRIP001 /*N*/ 								   SfxChildWinInfo *pInfo) :
//STRIP001 /*N*/ 	SfxChildWindow(pParentWindow, nId)
//STRIP001 /*N*/ {
//STRIP001 /*N*/     eChildAlignment = SFX_ALIGN_NOALIGNMENT;
//STRIP001 /*N*/ 
//STRIP001 //STRIP001 /*N*/ 	pWindow = new SmToolBoxWindow(pBindings, this, pParentWindow);
//STRIP001 /*N*/     {DBG_BF_ASSERT(0, "STRIP");}//STRIP001 ((SfxFloatingWindow *)pWindow)->Initialize(pInfo);
//STRIP001 /*N*/ }



}
