/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: starmath_mathtype.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:03:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {

/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil -*- */

//STRIP001 #ifndef MATHTYPE_HXX
//STRIP001 #include <mathtype.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _TOOLS_DEBUG_H
//STRIP001 #include <tools/debug.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #define APPEND(str,ascii) str.AppendAscii(RTL_CONSTASCII_STRINGPARAM(ascii))
//STRIP001 
//STRIP001 #if 0
//STRIP001 String aEmbelList[21] =
//STRIP001 {
//STRIP001 	" ",
//STRIP001 	" ",
//STRIP001     "single dot",
//STRIP001     "double dot",
//STRIP001     "triple dot",
//STRIP001     "single prime",
//STRIP001     "double prime",
//STRIP001     "backwards prime (left of character)",
//STRIP001     "tilde",
//STRIP001     "hat (circumflex)",
//STRIP001     "diagonal slash through character",
//STRIP001     "right arrow",
//STRIP001     "left arrow",
//STRIP001     "double-headed arrow",
//STRIP001     "right single-barbed arrow",
//STRIP001     "left single-barbed arrow",
//STRIP001     "mid-height horizontal bar",
//STRIP001     "over-bar",
//STRIP001     "triple prime",
//STRIP001     "over-arc, concave downward",
//STRIP001     "over-arc, concave upward"
//STRIP001 };
//STRIP001 
//STRIP001 String aSelectorList[49] =
//STRIP001 {
//STRIP001 	"angle brackets",
//STRIP001 	"parentheses",
//STRIP001 	"braces (curly brackets)",
//STRIP001 	"square brackets",
//STRIP001 	"vertical bars",
//STRIP001 	"double vertical bars",
//STRIP001 	"floor brackets",
//STRIP001 	"ceiling brackets",
//STRIP001 	"left brace, left brace",
//STRIP001 	"right brace, right brace",
//STRIP001 	"right brace, left brace",
//STRIP001 	"left brace, right parenthesis",
//STRIP001 	"left parenthesis, right brace",
//STRIP001 	"radical",
//STRIP001 	"fractions",
//STRIP001 	"subscript/superscript",
//STRIP001 	"underbar",
//STRIP001 	"overbar",
//STRIP001 	"left-pointing arrow",
//STRIP001 	"right-pointing arrow",
//STRIP001 	"left- and right-pointing arrow",
//STRIP001 	"single integral",
//STRIP001 	"double integral",
//STRIP001 	"triple integral",
//STRIP001 	"single summation-style integral",
//STRIP001 	"double summation-style integral",
//STRIP001 	"triple summation-style integral",
//STRIP001 	"upper horizontal brace",
//STRIP001 	"lower horizontal brace",
//STRIP001 	"summation",
//STRIP001 	"summation (integral-style limits)",
//STRIP001 	"product",
//STRIP001 	"product (integral-style limits)",
//STRIP001 	"coproduct",
//STRIP001 	"coproduct (integral-style limits)",
//STRIP001 	"union",
//STRIP001 	"union (integral-style limits)",
//STRIP001 	"intersection",
//STRIP001 	"intersection (integral-style limits)",
//STRIP001 	"limit",
//STRIP001 	"long division",
//STRIP001 	"slash fractions",
//STRIP001 	"big integral-style operators",
//STRIP001 	"big summation-style operators",
//STRIP001 	"leading sub- and superscripts",
//STRIP001 	"Dirac delta",
//STRIP001 	"under arrow",
//STRIP001 	"over arrow",
//STRIP001 	"over arc"
//STRIP001 };
//STRIP001 
//STRIP001 String aIntegralOpt[2] =
//STRIP001 {
//STRIP001 	"fixed-size integral",
//STRIP001 	"integral expands vertically to fit its contents"
//STRIP001 };
//STRIP001 
//STRIP001 String aFenceOpt[3] =
//STRIP001 {
//STRIP001 	"center fence on math axis",
//STRIP001 	"center fence on contents, place math axis of contents on math axis of containing line",
//STRIP001 	"center fence on contents, center contents on math axis of containing line"
//STRIP001 };
//STRIP001 
//STRIP001 String aTypeFaces[12] =
//STRIP001 {
//STRIP001 	"",
//STRIP001 	"fnTEXT",
//STRIP001 	"fnFUNCTION",
//STRIP001 	"fnVARIABLE",
//STRIP001 	"fnLCGREEK",
//STRIP001 	"fnUCGREEK",
//STRIP001 	"fnSYMBOL",
//STRIP001 	"fnVECTOR",
//STRIP001 	"fnNUMBER",
//STRIP001 	"fnUSER1",
//STRIP001 	"fnUSER2",
//STRIP001 	"fnMTEXTRA"
//STRIP001 };
//STRIP001 
//STRIP001 String aSizes[7] =
//STRIP001 {
//STRIP001 	"full",
//STRIP001 	"subscript",
//STRIP001 	"sub-subscript",
//STRIP001 	"symbol",
//STRIP001 	"sub-symbol",
//STRIP001 	"user 1",
//STRIP001 	"user 2"
//STRIP001 };
//STRIP001 #endif

//STRIP001 static sal_Unicode Convert(sal_Unicode nIn)
//STRIP001 {
//STRIP001     //Find the best match in accepted unicode for our private area symbols
//STRIP001     static sal_Unicode aStarMathPrivateToUnicode[] = 
//STRIP001     {
//STRIP001 0x2030, 0xF613, 0xF612, 0x002B, 0x003C, 0x003E, 0xE425, 0xE421, 0xE088, 0x2208,
//STRIP001 0x0192, 0x2026, 0x2192, 0x221A, 0x221A, 0x221A, 0xE090, 0x005E, 0x02C7, 0x02D8,
//STRIP001 0x00B4, 0x0060, 0x02DC, 0x00AF, 0x0362, 0xE099, 0xE09A, 0x20DB, 0xE09C, 0xE09D,
//STRIP001 0x0028, 0x0029, 0x2220, 0x22AF, 0xE0A2, 0xE0A3, 0xE0A4, 0xE0A5, 0xE0A6, 0xE0A7,
//STRIP001 0x002F, 0x005C, 0x274F, 0xE0AB, 0x0393, 0x0394, 0x0398, 0x039b, 0x039e, 0x03A0,
//STRIP001 0x03a3, 0x03a5, 0x03a6, 0x03a8, 0x03A9, 0x03B1, 0x03B2, 0x03b3, 0x03b4, 0x03b5,
//STRIP001 0x03b6, 0x03b7, 0x03b8, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf,
//STRIP001 0x03c0, 0x03c1, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, 0x03c8, 0x03c9, 0x03b5,
//STRIP001 0x03d1, 0x03d6, 0xE0D2, 0x03db, 0x2118, 0x2202, 0x2129, 0xE0D7, 0xE0D8, 0x22A4,
//STRIP001 0xE0DA, 0x2190, 0x2191, 0x2193
//STRIP001     };
//STRIP001     if ((nIn >= 0xE080) && (nIn <= 0xE0DD))
//STRIP001         nIn = aStarMathPrivateToUnicode[nIn-0xE080];
//STRIP001 
//STRIP001     //For whatever unicode glyph that equation editor doesn't ship with that
//STRIP001     //we have a possible match we can munge it to.
//STRIP001     switch (nIn)
//STRIP001     {
//STRIP001         case 0x2223:
//STRIP001             nIn = '|';
//STRIP001             break;
//STRIP001         default:
//STRIP001             break;
//STRIP001     }
//STRIP001 
//STRIP001     return nIn;
//STRIP001 }

//STRIP001 void EQNOLEFILEHDR::Read(SvStorageStream *pS)
//STRIP001 {
//STRIP001 	*pS >> nCBHdr;     
//STRIP001 	*pS >> nVersion;   
//STRIP001 	*pS >> nCf;        
//STRIP001 	*pS >> nCBObject;  
//STRIP001 	*pS >> nReserved1; 
//STRIP001 	*pS >> nReserved2; 
//STRIP001 	*pS >> nReserved3; 
//STRIP001 	*pS >> nReserved4; 
//STRIP001 }

//STRIP001 void EQNOLEFILEHDR::Write(SvStorageStream *pS)
//STRIP001 {
//STRIP001 	*pS << nCBHdr;     
//STRIP001 	*pS << nVersion;   
//STRIP001 	*pS << nCf;        
//STRIP001 	*pS << nCBObject; 
//STRIP001 	*pS << nReserved1; 
//STRIP001 	*pS << nReserved2; 
//STRIP001 	*pS << nReserved3; 
//STRIP001 	*pS << nReserved4; 
//STRIP001 }

//STRIP001 void MathType::Init()
//STRIP001 {
//STRIP001 	//These are the default MathType sizes
//STRIP001 	aSizeTable[0]=12;
//STRIP001 	aSizeTable[1]=8;
//STRIP001 	aSizeTable[2]=6;
//STRIP001 	aSizeTable[3]=24;
//STRIP001 	aSizeTable[4]=10;
//STRIP001 	aSizeTable[5]=12;
//STRIP001 	aSizeTable[6]=12;
//STRIP001 
 	/*
 	These are the default MathType italic/bold settings If mathtype is changed
 	from its defaults, there is nothing we can do, as this information is not
 	stored in the document
 	*/
//STRIP001 	MathTypeFont aFont;
//STRIP001 	for(sal_uInt8 i=1;i<=11;i++)
//STRIP001 	{
//STRIP001 		aFont.nTface = i+128;
//STRIP001 		switch (i)
//STRIP001 		{
//STRIP001 			default:
//STRIP001 				aFont.nStyle=0;
//STRIP001 				break;
//STRIP001 			case 3:
//STRIP001 			case 4:
//STRIP001 				aFont.nStyle=1;
//STRIP001 				break;
//STRIP001 			case 7:
//STRIP001 				aFont.nStyle=2;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 		aUserStyles.insert(aFont);
//STRIP001 	}
//STRIP001 }


/*ToDo replace with table rather than switch, returns
 TRUE in the case that the char is just a char, and
 FALSE if the character is an operator which must not be
 placed inside the quote sequence designed to protect
 against being parsed as a keyword

 General solution required to force starmath to handle
 unicode math chars the way it handles its own math
 chars rathar than handle them as text as it will do
 for the default case below, i.e. incorrect spacing
 between math symbols and ordinary text e.g. 1=2 rather
 than 1 = 2
 */
//STRIP001 sal_Bool MathType::LookupChar(sal_Unicode nChar,String &rRet,sal_uInt8 nVersion,
//STRIP001 	sal_uInt8 nTypeFace)
//STRIP001 {
//STRIP001 	sal_Bool bRet=FALSE;
//STRIP001 	const char *pC = NULL;
//STRIP001 	switch(nChar)
//STRIP001 	{
//STRIP001 		case 0x0000:
//STRIP001 			pC = " none ";
//STRIP001 			break;
//STRIP001 		case 0x00ac:
//STRIP001 			pC = " neg ";
//STRIP001 			break;
//STRIP001 		case 0x00b1:
//STRIP001 			pC = " +- ";
//STRIP001 			break;
//STRIP001         case '(':
//STRIP001 			pC = " \\( ";
//STRIP001 			break;
//STRIP001         case ')':
//STRIP001 			pC = " \\) ";
//STRIP001 			break;
//STRIP001         case '[':
//STRIP001 			pC = " \\[ ";
//STRIP001 			break;
//STRIP001         case ']':
//STRIP001 			pC = " \\] ";
//STRIP001 			break;
//STRIP001         case '.':
//STRIP001 			pC = " \".\" ";
//STRIP001             break;
//STRIP001         case 0xae:
//STRIP001             if ((nVersion < 3) && (nTypeFace == 0x86))
//STRIP001 			    pC = " rightarrow ";
//STRIP001             else
//STRIP001             {
//STRIP001                 rRet.Append(nChar);
//STRIP001 			    bRet=TRUE;
//STRIP001             }
//STRIP001 			break;
//STRIP001         case 0x00fb:
//STRIP001 			if ((nVersion < 3) && (nTypeFace == 0x81))
//STRIP001 				nChar = 0xDF;
//STRIP001 			rRet.Append(nChar);
//STRIP001 			bRet=TRUE;
//STRIP001             break;
//STRIP001         case 'a':
//STRIP001 			if ((nVersion < 3) && (nTypeFace == 0x84))
//STRIP001 				nChar = 0x3b1;
//STRIP001 			rRet.Append(nChar);
//STRIP001 			bRet=TRUE;
//STRIP001             break;
//STRIP001         case 'b':
//STRIP001 			if ((nVersion < 3) && (nTypeFace == 0x84))
//STRIP001 				nChar = 0x3b2;
//STRIP001 			rRet.Append(nChar);
//STRIP001 			bRet=TRUE;
//STRIP001             break;
//STRIP001         case 'l':
//STRIP001 			if ((nVersion < 3) && (nTypeFace == 0x84))
//STRIP001 				nChar = 0x3bb;
//STRIP001 			rRet.Append(nChar);
//STRIP001 			bRet=TRUE;
//STRIP001             break;
//STRIP001         case 'n':
//STRIP001 			if ((nVersion < 3) && (nTypeFace == 0x84))
//STRIP001 				nChar = 0x3bd;
//STRIP001 			rRet.Append(nChar);
//STRIP001 			bRet=TRUE;
//STRIP001             break;
//STRIP001         case 'r':
//STRIP001 			if ((nVersion < 3) && (nTypeFace == 0x84))
//STRIP001 				nChar = 0x3c1;
//STRIP001 			rRet.Append(nChar);
//STRIP001 			bRet=TRUE;
//STRIP001             break;
//STRIP001         case 'D':
//STRIP001 			if ((nVersion < 3) && (nTypeFace == 0x84))
//STRIP001 				nChar = 0x394;
//STRIP001 			rRet.Append(nChar);
//STRIP001 			bRet=TRUE;
//STRIP001             break;
//STRIP001         case 0xa9:
//STRIP001 			if ((nVersion < 3) && (nTypeFace == 0x82))
//STRIP001 				nChar = '\'';
//STRIP001 			rRet.Append(nChar);
//STRIP001 			bRet=TRUE;
//STRIP001             break;
//STRIP001         case 0x00f1:
//STRIP001 			if ((nVersion < 3) && (nTypeFace == 0x86))
//STRIP001 				pC = " \\rangle ";
//STRIP001             else
//STRIP001             {
//STRIP001 			    rRet.Append(nChar);
//STRIP001 			    bRet=TRUE;
//STRIP001             }
//STRIP001             break;
//STRIP001         case 0x00a3:
//STRIP001 			if ((nVersion < 3) && (nTypeFace == 0x86))
//STRIP001 				pC = " <= ";
//STRIP001             else
//STRIP001             {
//STRIP001 			    rRet.Append(nChar);
//STRIP001 			    bRet=TRUE;
//STRIP001             }
//STRIP001             break;
//STRIP001         case 0x00de:
//STRIP001 			if ((nVersion < 3) && (nTypeFace == 0x86))
//STRIP001 				pC = " drarrow ";
//STRIP001 			else
//STRIP001 			{
//STRIP001 				rRet.Append(nChar);
//STRIP001 				bRet=TRUE;
//STRIP001 			}
//STRIP001             break;
//STRIP001 		case 0x0057:
//STRIP001 			if ((nVersion < 3) && (nTypeFace == 0x85))
//STRIP001 				pC = " %OMEGA ";
//STRIP001 			else
//STRIP001 			{
//STRIP001 				rRet.Append(nChar);
//STRIP001 				bRet=TRUE;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case 0x007b:
//STRIP001 			pC = " lbrace ";
//STRIP001 			break;
//STRIP001 		case 0x007c:
//STRIP001 			pC = " \\lline ";
//STRIP001 			break;
//STRIP001 		case 0x007d:
//STRIP001 			pC = " rbrace ";
//STRIP001 			break;
//STRIP001 		case 0x007e:
//STRIP001 			pC = " sim ";
//STRIP001 			break;
//STRIP001 		case 0x2224:
//STRIP001 			pC = " ndivides ";
//STRIP001 			break;
//STRIP001 		case 0x2225:
//STRIP001 			pC = " parallel ";
//STRIP001 			break;
//STRIP001 		case 0x00d7:
//STRIP001 			if (nVersion < 3)
//STRIP001 				pC = " cdot ";
//STRIP001 			else
//STRIP001 				pC = " times ";
//STRIP001 			break;
//STRIP001 		case 0x00f7:
//STRIP001 			pC = " div ";
//STRIP001 			break;
//STRIP001 		case 0x019b:
//STRIP001 			pC = " lambdabar ";
//STRIP001 			break;
//STRIP001 		case 0x2026:
//STRIP001 			pC = " dotslow ";
//STRIP001 			break;
//STRIP001 		case 0x2022:
//STRIP001 			pC = " cdot ";
//STRIP001 			break;
//STRIP001 		case 0x2102:
//STRIP001 			pC = " setC ";
//STRIP001 			break;
//STRIP001 		case 0x210f:
//STRIP001 			pC = " hbar ";
//STRIP001 			break;
//STRIP001 		case 0x2111:
//STRIP001 			pC = " Im ";
//STRIP001 			break;
//STRIP001 		case 0x2115:
//STRIP001 			pC = " setN ";
//STRIP001 			break;
//STRIP001 		case 0x2118:
//STRIP001 			pC = " wp ";
//STRIP001 			break;
//STRIP001 		case 0x211a:
//STRIP001 			pC = " setQ ";
//STRIP001 			break;
//STRIP001 		case 0x211c:
//STRIP001 			pC = " Re ";
//STRIP001 			break;
//STRIP001 		case 0x211d:
//STRIP001 			pC = " setR ";
//STRIP001 			break;
//STRIP001 		case 0x2124:
//STRIP001 			pC = " setZ ";
//STRIP001 			break;
//STRIP001 		case 0x2135:
//STRIP001 			pC = " aleph ";
//STRIP001 			break;
//STRIP001 		case 0x2190:
//STRIP001 			pC = " leftarrow ";
//STRIP001 			break;
//STRIP001 		case 0x2191:
//STRIP001 			pC = " uparrow ";
//STRIP001 			break;
//STRIP001 		case 0x2192:
//STRIP001 			pC = " rightarrow ";
//STRIP001 			break;
//STRIP001 		case 0x0362:
//STRIP001 			pC = " widevec ";
//STRIP001 			break;
//STRIP001 		case 0x2193:
//STRIP001 			pC = " downarrow ";
//STRIP001 			break;
//STRIP001 		case 0x21d0:
//STRIP001 			pC = " dlarrow ";
//STRIP001 			break;
//STRIP001 		case 0x21d2:
//STRIP001 			pC = " drarrow ";
//STRIP001 			break;
//STRIP001 		case 0x21d4:
//STRIP001 			pC = " dlrarrow ";
//STRIP001 			break;
//STRIP001 		case 0x2200:
//STRIP001 			pC = " forall ";
//STRIP001 			break;
//STRIP001 		case 0x2202:
//STRIP001 			pC = " partial ";
//STRIP001 			break;
//STRIP001 		case 0x2203:
//STRIP001 			pC = " exists ";
//STRIP001 			break;
//STRIP001 		case 0x2205:
//STRIP001 			pC = " emptyset ";
//STRIP001 			break;
//STRIP001 		case 0x2207:
//STRIP001 			pC = " nabla ";
//STRIP001 			break;
//STRIP001 		case 0x2208:
//STRIP001 			pC = " in ";
//STRIP001 			break;
//STRIP001 		case 0x2209:
//STRIP001 			pC = " notin ";
//STRIP001 			break;
//STRIP001 		case 0x220d:
//STRIP001 			pC = " owns ";
//STRIP001 			break;
//STRIP001 		case 0x220f:
//STRIP001 			pC = " prod ";
//STRIP001 			break;
//STRIP001 		case 0x2210:
//STRIP001 			pC = " coprod ";
//STRIP001 			break;
//STRIP001 		case 0x2211:
//STRIP001 			pC = " sum ";
//STRIP001 			break;
//STRIP001 		case 0x2212:
//STRIP001 			pC = " - ";
//STRIP001 			break;
//STRIP001 		case 0x2213:
//STRIP001 			pC = " -+ ";
//STRIP001 			break;
//STRIP001 		case 0x2217:
//STRIP001 			pC = " * ";
//STRIP001 			break;
//STRIP001 		case 0x2218:
//STRIP001 			pC = " circ ";
//STRIP001 			break;
//STRIP001 		case 0x221d:
//STRIP001 			pC = " prop ";
//STRIP001 			break;
//STRIP001 		case 0x221e:
//STRIP001 			pC = " infinity ";
//STRIP001 			break;
//STRIP001 		case 0x2227:
//STRIP001 			pC = " and ";
//STRIP001 			break;
//STRIP001 		case 0x2228:
//STRIP001 			pC = " or ";
//STRIP001 			break;
//STRIP001 		case 0x2229:
//STRIP001 			pC = " intersection ";
//STRIP001 			break;
//STRIP001 		case 0x222a:
//STRIP001 			pC = " union ";
//STRIP001 			break;
//STRIP001 		case 0x222b:
//STRIP001 			pC = " int ";
//STRIP001 			break;
//STRIP001 		case 0x222c:
//STRIP001 			pC = " iint ";
//STRIP001 			break;
//STRIP001 		case 0x222d:
//STRIP001 			pC = " iiint ";
//STRIP001 			break;
//STRIP001         case 0x222e:
//STRIP001 			pC = " lint ";
//STRIP001             break;
//STRIP001         case 0x222f:
//STRIP001 			pC = " llint ";
//STRIP001             break;
//STRIP001         case 0x2230:
//STRIP001 			pC = " lllint ";
//STRIP001             break;
//STRIP001 		case 0x2245:
//STRIP001 			pC = " simeq ";
//STRIP001 			break;
//STRIP001 		case 0x2248:
//STRIP001 			pC = " approx ";
//STRIP001 			break;
//STRIP001 		case 0x2260:
//STRIP001 			pC = " <> ";
//STRIP001 			break;
//STRIP001 		case 0x2261:
//STRIP001 			pC = " equiv ";
//STRIP001 			break;
//STRIP001 		case 0x2264:
//STRIP001 			pC = " <= ";
//STRIP001 			break;
//STRIP001 		case 0x2265:
//STRIP001 			pC = " >= ";
//STRIP001 			break;
//STRIP001 		case 0x2282:
//STRIP001 			pC = " subset ";
//STRIP001 			break;
//STRIP001 		case 0x2283:
//STRIP001 			pC = " supset ";
//STRIP001 			break;
//STRIP001 		case 0x2284:
//STRIP001 			pC = " nsubset ";
//STRIP001 			break;
//STRIP001 		case 0x2285:
//STRIP001 			pC = " nsupset ";
//STRIP001 			break;
//STRIP001 		case 0x2286:
//STRIP001 			pC = " subseteq ";
//STRIP001 			break;
//STRIP001 		case 0x2287:
//STRIP001 			pC = " supseteq ";
//STRIP001 			break;
//STRIP001 		case 0x2288:
//STRIP001 			pC = " nsubseteq ";
//STRIP001 			break;
//STRIP001 		case 0x2289:
//STRIP001 			pC = " nsupseteq ";
//STRIP001 			break;
//STRIP001 		case 0x227a:
//STRIP001 		case 0x227b:
//STRIP001 		case 0x22b2:
//STRIP001 		case 0x22b3:
//STRIP001 			rRet += ' ';
//STRIP001 			rRet.Append(nChar);
//STRIP001 			rRet += ' ';
//STRIP001 			break;
//STRIP001 		case 0x22a5:
//STRIP001 			pC = " ortho ";
//STRIP001 			break;
//STRIP001 		case 0x22c5:
//STRIP001 			pC = " cdot ";
//STRIP001 			break;
//STRIP001 		case 0x22ee:
//STRIP001 			pC = " dotsvert ";
//STRIP001 			break;
//STRIP001 		case 0x22ef:
//STRIP001 			pC = " dotsaxis ";
//STRIP001 			break;
//STRIP001 		case 0x22f0:
//STRIP001 			pC = " dotsup ";
//STRIP001 			break;
//STRIP001 		case 0x22f1:
//STRIP001 			pC = " dotsdown ";
//STRIP001 			break;
//STRIP001 		case 0x2329:
//STRIP001 			pC = " langle ";
//STRIP001 			break;
//STRIP001 		case 0x232a:
//STRIP001 			pC = " rangle ";
//STRIP001 			break;
//STRIP001 		case 0x301a:
//STRIP001 			pC = " ldbracket ";
//STRIP001 			break;
//STRIP001 		case 0x301b:
//STRIP001 			pC = " rdbracket ";
//STRIP001 			break;
//STRIP001         case 0xe083:
//STRIP001 			rRet.Append('+');
//STRIP001             bRet=TRUE;
//STRIP001             break;
//STRIP001         case '^':
//STRIP001         case 0xe091:
//STRIP001             pC = " widehat ";
//STRIP001             break;
//STRIP001         case 0xe096:
//STRIP001             pC = " widetilde ";
//STRIP001             break;
//STRIP001         case 0xe098:
//STRIP001             pC = " widevec ";
//STRIP001             break;
//STRIP001 		case 0xE421:
//STRIP001 			pC = " geslant ";
//STRIP001 			break;
//STRIP001 		case 0xE425:
//STRIP001 			pC = " leslant ";
//STRIP001 			break;
//STRIP001 		case 0xeb01:	//no space
//STRIP001 		case 0xeb08:	//normal space
//STRIP001 			bRet=TRUE; 
//STRIP001 			break;
//STRIP001         case 0xef04:	//tiny space
//STRIP001 		case 0xef05:	//tiny space
//STRIP001 		case 0xeb02:	//small space
//STRIP001 		case 0xeb04:	//medium space
//STRIP001 			rRet.Append('`');
//STRIP001 			break;
//STRIP001 		case 0xeb05:	//large space
//STRIP001 			rRet.Append('~');
//STRIP001 			break;
//STRIP001 		case 0x3a9:
//STRIP001 			pC = " %OMEGA ";
//STRIP001 			break;
//STRIP001 		default:
//STRIP001 			rRet.Append(nChar);
//STRIP001 			bRet=TRUE;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	if (pC)
//STRIP001 		rRet.AppendAscii(pC);
//STRIP001 	return bRet;
//STRIP001 }

//STRIP001 void MathTypeFont::AppendStyleToText(String &rRet)
//STRIP001 {
//STRIP001 	const char *pC = NULL;
//STRIP001 	switch (nStyle)
//STRIP001 	{
//STRIP001 		default:
//STRIP001 		case 0:
//STRIP001 			break;
//STRIP001 		case 1:
//STRIP001 			pC = " ital ";
//STRIP001 			break;
//STRIP001 		case 2:
//STRIP001 			pC = " bold ";
//STRIP001 			break;
//STRIP001 		case 3:
//STRIP001 			pC = " bold italic";
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	if (pC)
//STRIP001 		rRet.AppendAscii(pC);
//STRIP001 }

//STRIP001 void MathType::TypeFaceToString(String &rRet,sal_uInt8 nFace)
//STRIP001 {
//STRIP001 	MathTypeFont aFont(nFace);
//STRIP001 	MathTypeFontSet::iterator aItr = aUserStyles.find(aFont);
//STRIP001 	if (aItr != aUserStyles.end())
//STRIP001 		aFont.nStyle = aItr->nStyle;
//STRIP001 	aFont.AppendStyleToText(rRet);
//STRIP001 }

//STRIP001 int MathType::Parse(SvStorage *pStor)
//STRIP001 {
//STRIP001 	SvStorageStreamRef xSrc = pStor->OpenStream(
//STRIP001 		String::CreateFromAscii("Equation Native"),
//STRIP001 		STREAM_STD_READ | STREAM_NOCREATE);
//STRIP001 	if ( (!xSrc.Is()) || (SVSTREAM_OK != xSrc->GetError()))
//STRIP001 		return NULL;
//STRIP001 	pS = &xSrc;
//STRIP001 	pS->SetNumberFormatInt( NUMBERFORMAT_INT_LITTLEENDIAN );
//STRIP001 
//STRIP001 	EQNOLEFILEHDR aHdr;
//STRIP001 	aHdr.Read(pS);
//STRIP001 	*pS >> nVersion;
//STRIP001 	*pS >> nPlatform;
//STRIP001 	*pS >> nProduct;
//STRIP001 	*pS >> nProdVersion;
//STRIP001 	*pS >> nProdSubVersion;
//STRIP001 
//STRIP001 #ifdef STANDALONE
//STRIP001 	*pOut << "Format Version is " << int(nVersion) << endl;
//STRIP001 	*pOut << "Generating Platform is " << (nPlatform ? "Windows" 
//STRIP001 		: "Mac") << endl;
//STRIP001 	*pOut << "Generating Product is " << (nPlatform ? "Equation Editor" 
//STRIP001 		: "Equation Editor") << endl;
//STRIP001 	*pOut << "Prod Version is " << int(nProdVersion) << "." << 
//STRIP001 		int(nProdSubVersion) << endl << endl;
//STRIP001 #endif
//STRIP001 
//STRIP001 	int nRet = HandleRecords();
//STRIP001 	//little crude hack to close ocassionally open expressions
//STRIP001 	//a sophisticated system to determine what expressions are
//STRIP001 	//opened is required, but this is as much work as rewriting
//STRIP001 	//starmaths internals.
//STRIP001 	APPEND(rRet,"{}");
//STRIP001 
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001 #	ifdef CAOLAN
//STRIP001 	//sanity check
//STRIP001 
//STRIP001 	//sigh, theres no point! MathType (in some bizarre subvarient) pads
//STRIP001 	//the end of the formula with ENDs (0)'s
//STRIP001 	ULONG nEnd = pS->Tell();
//STRIP001 	DBG_ASSERT(nEnd == pS->Seek(STREAM_SEEK_TO_END),
//STRIP001 		"Possibly unfully parsed formula")
//STRIP001 #	endif
//STRIP001 #endif
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 static void lcl_PrependDummyTerm(String &rRet, xub_StrLen &rTextStart)
//STRIP001 {
//STRIP001 	if ((rRet.GetChar(rTextStart) == '=') &&
//STRIP001 		((rTextStart == 0) ||
//STRIP001 		(rRet.GetChar(rTextStart-1) == '{'))
//STRIP001 	   )
//STRIP001 	{
//STRIP001 		rRet.InsertAscii(" {}",rTextStart);
//STRIP001         rTextStart+=3;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 static void lcl_AppendDummyTerm(String &rRet)
//STRIP001 {
//STRIP001     sal_Bool bOk=sal_False;
//STRIP001     for(xub_StrLen nI=rRet.Len()-1;nI >= 0; nI--)
//STRIP001     {
//STRIP001         sal_Unicode nChar = rRet.GetChar(nI);
//STRIP001         if (nChar == ' ')
//STRIP001             continue;
//STRIP001         if (rRet.GetChar(nI) != '{')
//STRIP001             bOk=sal_True;
//STRIP001         break;
//STRIP001     }
//STRIP001     if (!bOk)   //No term, use dummy
//STRIP001         APPEND(rRet," {}");
//STRIP001 }
//STRIP001 
//STRIP001 /*Fabously complicated as many tokens have to be reordered and generally
//STRIP001  *moved around from mathtypes paradigm to starmaths.*/
//STRIP001 int MathType::HandleRecords(int nLevel,sal_uInt8 nSelector,
//STRIP001 	sal_uInt8 nVariation, int nMatrixRows,int nMatrixCols)
//STRIP001 {
//STRIP001 	sal_uInt8 nTag,nRecord;
//STRIP001 	sal_uInt8 nTabType,nTabStops;
//STRIP001 	sal_uInt16 nTabOffset;
//STRIP001 	sal_Char nChar8;
//STRIP001 	String sFontName;
//STRIP001 	int i,nRet=1,newline=0;
//STRIP001 	sal_Bool bSilent=FALSE;
//STRIP001 	int nPart=0;
//STRIP001 	String sPush,sMainTerm;
//STRIP001 	int nSetSize=0,nSetAlign=0;
//STRIP001 	int nCurRow=0,nCurCol=0;
//STRIP001 	sal_Bool bOpenString=FALSE;
//STRIP001 	xub_StrLen nTextStart;
//STRIP001     xub_StrLen nSubSupStartPos;
//STRIP001     xub_StrLen nLastTemplateBracket=STRING_NOTFOUND;
//STRIP001 
//STRIP001 	do
//STRIP001 	{
//STRIP001 		*pS >> nTag;
//STRIP001 		nRecord = nTag&0x0F;
//STRIP001 
//STRIP001 		/*MathType strings can of course include words which
//STRIP001 		 *are StarMath keywords, the simplest solution is
//STRIP001 		 to escape strings of greater than len 1 with double
//STRIP001 		 quotes to avoid scanning the TokenTable for matches
//STRIP001 
//STRIP001 		 Unfortunately it may turn out that the string gets
//STRIP001 		 split during the handling of a character emblishment
//STRIP001 		 so this special case must be handled in the
//STRIP001 		 character handler case 2:
//STRIP001 		 */
//STRIP001 		if ((nRecord == CHAR) && (!bSilent) && (!bOpenString))
//STRIP001 		{
//STRIP001 			bOpenString=TRUE;
//STRIP001 			nTextStart = rRet.Len();
//STRIP001 		}
//STRIP001 		else if ((nRecord != CHAR) && (bOpenString))
//STRIP001 		{
//STRIP001 			bOpenString=FALSE;
//STRIP001 			if ((rRet.Len() - nTextStart) > 1)
//STRIP001 			{
//STRIP001 				String aStr;
//STRIP001 				TypeFaceToString(aStr,nTypeFace);
//STRIP001 				aStr += '\"';
//STRIP001 				rRet.Insert(aStr,nTextStart);
//STRIP001 				rRet += '\"';
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if (nRecord == END)
//STRIP001 				{
//STRIP001                     sal_Unicode cChar = 0;
//STRIP001                     xub_StrLen nI = rRet.Len()-1;
//STRIP001                     while (nI && ((cChar = rRet.GetChar(nI)) == ' '))
//STRIP001                         --nI;
//STRIP001 					if ((cChar == '=') || (cChar == '+') || (cChar == '-'))
//STRIP001 						APPEND(rRet,"{}");
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		switch(nRecord)
//STRIP001 		{
//STRIP001 			case LINE:
//STRIP001 				{
//STRIP001 					//if (xfLMOVE(nTag))
//STRIP001 					//if (xfLSPACE(nTag))
//STRIP001 					//if (xfRULER(nTag))
//STRIP001 
//STRIP001 					if (newline>0)
//STRIP001 						APPEND(rRet,"\nnewline\n");
//STRIP001 					if (!(xfNULL(nTag)))
//STRIP001 					{
//STRIP001 						switch (nSelector)
//STRIP001 						{
//STRIP001 						case 0x0:
//STRIP001 							if (nVariation==0)
//STRIP001 								APPEND(rRet," langle ");
//STRIP001 							else if (nVariation==1)
//STRIP001 								APPEND(rRet," \\langle ");
//STRIP001 							break;
//STRIP001 						case 0x1:
//STRIP001 							if (nVariation==0)
//STRIP001 								APPEND(rRet," left (");
//STRIP001 							else if (nVariation==1)
//STRIP001 								APPEND(rRet,"\\(");
//STRIP001 							break;
//STRIP001 						case 0x2:
//STRIP001 							if ((nVariation==0) || (nVariation==1))
//STRIP001 								APPEND(rRet," left lbrace ");
//STRIP001                             else 
//STRIP001                                 APPEND(rRet," left none ");
//STRIP001 							break;
//STRIP001 						case 0x3:
//STRIP001 							if (nVariation==0)
//STRIP001 								APPEND(rRet," left [");
//STRIP001 							else if (nVariation==1)
//STRIP001 								APPEND(rRet,"\\[");
//STRIP001 							break;
//STRIP001 						case 0x8:
//STRIP001 						case 0xb:
//STRIP001 							APPEND(rRet," \\[");
//STRIP001 							break;
//STRIP001 						case 0x4:
//STRIP001 							if (nVariation==0)
//STRIP001 								APPEND(rRet," lline ");
//STRIP001 							else if (nVariation==1)
//STRIP001 								APPEND(rRet," \\lline ");
//STRIP001 							break;
//STRIP001 						case 0x5:
//STRIP001 							if (nVariation==0)
//STRIP001 								APPEND(rRet," ldline ");
//STRIP001 							else if (nVariation==1)
//STRIP001 								APPEND(rRet," \\ldline ");
//STRIP001 							break;
//STRIP001 						case 0x6:
//STRIP001 							if (nVariation==0)
//STRIP001 								APPEND(rRet," lfloor ");
//STRIP001 							else if (nVariation==1)
//STRIP001 								APPEND(rRet," \\lfloor ");
//STRIP001 							break;
//STRIP001 						case 0x7:
//STRIP001 							if (nVariation==0)
//STRIP001 								APPEND(rRet," lceil ");
//STRIP001 							else if (nVariation==1)
//STRIP001 								APPEND(rRet," \\lceil ");
//STRIP001 							break;
//STRIP001 						case 0x9:
//STRIP001 						case 0xa:
//STRIP001 							APPEND(rRet," \\]");
//STRIP001 							break;
//STRIP001 						case 0xc:
//STRIP001 							APPEND(rRet," \\(");
//STRIP001 							break;
//STRIP001 						case 0xd:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								if (nVariation == 0)
//STRIP001 									APPEND(rRet," sqrt");
//STRIP001 								else
//STRIP001 								{
//STRIP001 									APPEND(rRet," nroot");
//STRIP001 									sPush = rRet;
//STRIP001 									rRet.Erase();
//STRIP001 								}
//STRIP001 							}
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0xe:
//STRIP001 							if (nPart == 0)
//STRIP001 								APPEND(rRet," { ");
//STRIP001 
//STRIP001 
//STRIP001 							if (nPart == 1)
//STRIP001 								APPEND(rRet," over ");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0xf:
//STRIP001                             nSubSupStartPos = rRet.Len();
//STRIP001 							if ((nVariation == 0) ||
//STRIP001 									((nVariation == 2) && (nPart==1)))
//STRIP001                             {
//STRIP001                                 lcl_AppendDummyTerm(rRet);
//STRIP001 								APPEND(rRet," rSup");
//STRIP001                             }
//STRIP001 							else if ((nVariation == 1) ||
//STRIP001 									((nVariation == 2) && (nPart==0)))
//STRIP001                             {
//STRIP001                                 lcl_AppendDummyTerm(rRet);
//STRIP001 								APPEND(rRet," rSub");
//STRIP001                             }
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x10:
//STRIP001 							if (nVariation == 0)
//STRIP001 								APPEND(rRet," {underline ");
//STRIP001 							else if (nVariation == 1) 
//STRIP001 								APPEND(rRet," {underline underline ");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x11:
//STRIP001 							if (nVariation == 0)
//STRIP001 								APPEND(rRet," {overline ");
//STRIP001 							else if (nVariation == 1) 
//STRIP001 								APPEND(rRet," {overline overline ");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x12:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								if (nVariation == 0)
//STRIP001 									APPEND(rRet," widevec ");//left arrow above
//STRIP001 								else if (nVariation == 1)
//STRIP001 									APPEND(rRet," widevec ");//left arrow below
//STRIP001 								APPEND(rRet," {");
//STRIP001 							}
//STRIP001 							break;
//STRIP001 						case 0x13:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								if (nVariation == 0)
//STRIP001 									APPEND(rRet," widevec ");//right arrow above
//STRIP001 								else if (nVariation == 1)
//STRIP001 									APPEND(rRet," widevec ");//right arrow below
//STRIP001 								APPEND(rRet," {");
//STRIP001 							}
//STRIP001 							break;
//STRIP001 						case 0x14:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								if (nVariation == 0)
//STRIP001 									APPEND(rRet," widevec ");//double arrow above
//STRIP001 								else if (nVariation == 1)
//STRIP001 									APPEND(rRet," widevec ");//double arrow below
//STRIP001 								APPEND(rRet," {");
//STRIP001 							}
//STRIP001 							break;
//STRIP001 						case 0x15:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								if ((nVariation == 3) || (nVariation == 4))
//STRIP001 									APPEND(rRet," lInt");
//STRIP001 								else
//STRIP001 									APPEND(rRet," Int");
//STRIP001 								if ( (nVariation != 0) && (nVariation != 3))
//STRIP001 								{
//STRIP001 									sPush = rRet;
//STRIP001 									rRet.Erase();
//STRIP001 								}
//STRIP001 							}
//STRIP001 							if (((nVariation == 1) ||
//STRIP001 									(nVariation == 4)) && (nPart==1))
//STRIP001 								APPEND(rRet," rSub");
//STRIP001 							else if ((nVariation == 2) && (nPart==2))
//STRIP001 								APPEND(rRet," rSup");
//STRIP001 							else if ((nVariation == 2) && (nPart==1))
//STRIP001 								APPEND(rRet," rSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x16:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								if ((nVariation == 2) || (nVariation == 3))
//STRIP001 									APPEND(rRet," llInt");
//STRIP001 								else
//STRIP001 									APPEND(rRet," iInt");
//STRIP001 								if ( (nVariation != 0) && (nVariation != 2))
//STRIP001 								{
//STRIP001 									sPush = rRet;
//STRIP001 									rRet.Erase();
//STRIP001 								}
//STRIP001 							}
//STRIP001 							if (((nVariation == 1) ||
//STRIP001 									(nVariation == 3)) && (nPart==1))
//STRIP001 								APPEND(rRet," rSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x17:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								if ((nVariation == 2) || (nVariation == 3))
//STRIP001 									APPEND(rRet," lllInt");
//STRIP001 								else
//STRIP001 									APPEND(rRet," iiInt");
//STRIP001 								if ( (nVariation != 0) && (nVariation != 2))
//STRIP001 								{
//STRIP001 									sPush = rRet;
//STRIP001 									rRet.Erase();
//STRIP001 								}
//STRIP001 							}
//STRIP001 							if (((nVariation == 1) ||
//STRIP001 									(nVariation == 3)) && (nPart==1))
//STRIP001 								APPEND(rRet," rSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x18:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								if (nVariation == 2)
//STRIP001 									APPEND(rRet," lInt");
//STRIP001 								else
//STRIP001 									APPEND(rRet," Int");
//STRIP001 								sPush = rRet;
//STRIP001 								rRet.Erase();
//STRIP001 							}
//STRIP001 							if (((nVariation == 1) ||
//STRIP001 									(nVariation == 2)) && (nPart==1))
//STRIP001 								APPEND(rRet," cSub");
//STRIP001 							else if ((nVariation == 0) && (nPart==2))
//STRIP001 								APPEND(rRet," cSup");
//STRIP001 							else if ((nVariation == 0) && (nPart==1))
//STRIP001 								APPEND(rRet," cSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x19:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								if (nVariation == 0)
//STRIP001 									APPEND(rRet," llInt");
//STRIP001 								else
//STRIP001 									APPEND(rRet," iInt");
//STRIP001 								sPush = rRet;
//STRIP001 								rRet.Erase();
//STRIP001 							}
//STRIP001 							if (nPart==1)
//STRIP001 								APPEND(rRet," cSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x1a:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								if (nVariation == 0)
//STRIP001 									APPEND(rRet," lllInt");
//STRIP001 								else
//STRIP001 									APPEND(rRet," iiInt");
//STRIP001 								sPush = rRet;
//STRIP001 								rRet.Erase();
//STRIP001 							}
//STRIP001 							if (nPart==1)
//STRIP001 								APPEND(rRet," cSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x1b:
//STRIP001 						case 0x1c:
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x1d:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								APPEND(rRet," Sum");
//STRIP001 								if (nVariation != 2)
//STRIP001 								{
//STRIP001 									sPush = rRet;
//STRIP001 									rRet.Erase();
//STRIP001 								}
//STRIP001 							}
//STRIP001 							if ((nVariation == 0) && (nPart==1))
//STRIP001 								APPEND(rRet," cSub");
//STRIP001 							else if ((nVariation == 1) && (nPart==2))
//STRIP001 								APPEND(rRet," cSup");
//STRIP001 							else if ((nVariation == 1) && (nPart==1))
//STRIP001 								APPEND(rRet," cSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x1e:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								APPEND(rRet," Sum");
//STRIP001 								sPush = rRet;
//STRIP001 								rRet.Erase();
//STRIP001 							}
//STRIP001 							if ((nVariation == 0) && (nPart==1))
//STRIP001 								APPEND(rRet," rSub");
//STRIP001 							else if ((nVariation == 1) && (nPart==2))
//STRIP001 								APPEND(rRet," rSup");
//STRIP001 							else if ((nVariation == 1) && (nPart==1))
//STRIP001 								APPEND(rRet," rSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x1f:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								APPEND(rRet," Prod");
//STRIP001 								if (nVariation != 2)
//STRIP001 								{
//STRIP001 									sPush = rRet;
//STRIP001 									rRet.Erase();
//STRIP001 								}
//STRIP001 							}
//STRIP001 							if ((nVariation == 0) && (nPart==1))
//STRIP001 								APPEND(rRet," cSub");
//STRIP001 							else if ((nVariation == 1) && (nPart==2))
//STRIP001 								APPEND(rRet," cSup");
//STRIP001 							else if ((nVariation == 1) && (nPart==1))
//STRIP001 								APPEND(rRet," cSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x20:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								APPEND(rRet," Prod");
//STRIP001 								sPush = rRet;
//STRIP001 								rRet.Erase();
//STRIP001 							}
//STRIP001 							if ((nVariation == 0) && (nPart==1))
//STRIP001 								APPEND(rRet," rSub");
//STRIP001 							else if ((nVariation == 1) && (nPart==2))
//STRIP001 								APPEND(rRet," rSup");
//STRIP001 							else if ((nVariation == 1) && (nPart==1))
//STRIP001 								APPEND(rRet," rSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x21:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								APPEND(rRet," coProd");
//STRIP001 								if (nVariation != 2)
//STRIP001 								{
//STRIP001 									sPush = rRet;
//STRIP001 									rRet.Erase();
//STRIP001 								}
//STRIP001 							}
//STRIP001 							if ((nVariation == 0) && (nPart==1))
//STRIP001 								APPEND(rRet," cSub");
//STRIP001 							else if ((nVariation == 1) && (nPart==2))
//STRIP001 								APPEND(rRet," cSup");
//STRIP001 							else if ((nVariation == 1) && (nPart==1))
//STRIP001 								APPEND(rRet," cSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x22:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								APPEND(rRet," coProd");
//STRIP001 								sPush = rRet;
//STRIP001 								rRet.Erase();
//STRIP001 							}
//STRIP001 							if ((nVariation == 0) && (nPart==1))
//STRIP001 								APPEND(rRet," rSub");
//STRIP001 							else if ((nVariation == 1) && (nPart==2))
//STRIP001 								APPEND(rRet," rSup");
//STRIP001 							else if ((nVariation == 1) && (nPart==1))
//STRIP001 								APPEND(rRet," rSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x23:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								APPEND(rRet," union"); //union
//STRIP001 								if (nVariation != 2)
//STRIP001 								{
//STRIP001 									sPush = rRet;
//STRIP001 									rRet.Erase();
//STRIP001 								}
//STRIP001 							}
//STRIP001 							if ((nVariation == 0) && (nPart==1))
//STRIP001 								APPEND(rRet," cSub");
//STRIP001 							else if ((nVariation == 1) && (nPart==2))
//STRIP001 								APPEND(rRet," cSup");
//STRIP001 							else if ((nVariation == 1) && (nPart==1))
//STRIP001 								APPEND(rRet," cSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x24:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								APPEND(rRet," union"); //union
//STRIP001 								sPush = rRet;
//STRIP001 								rRet.Erase();
//STRIP001 							}
//STRIP001 							if ((nVariation == 0) && (nPart==1))
//STRIP001 								APPEND(rRet," rSub");
//STRIP001 							else if ((nVariation == 1) && (nPart==2))
//STRIP001 								APPEND(rRet," rSup");
//STRIP001 							else if ((nVariation == 1) && (nPart==1))
//STRIP001 								APPEND(rRet," rSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x25:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								APPEND(rRet," intersect"); //intersect
//STRIP001 								if (nVariation != 2)
//STRIP001 								{
//STRIP001 									sPush = rRet;
//STRIP001 									rRet.Erase();
//STRIP001 								}
//STRIP001 							}
//STRIP001 							if ((nVariation == 0) && (nPart==1))
//STRIP001 								APPEND(rRet," cSub");
//STRIP001 							else if ((nVariation == 1) && (nPart==2))
//STRIP001 								APPEND(rRet," cSup");
//STRIP001 							else if ((nVariation == 1) && (nPart==1))
//STRIP001 								APPEND(rRet," cSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x26:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								APPEND(rRet," intersect"); //intersect
//STRIP001 								sPush = rRet;
//STRIP001 								rRet.Erase();
//STRIP001 							}
//STRIP001 							if ((nVariation == 0) && (nPart==1))
//STRIP001 								APPEND(rRet," rSub");
//STRIP001 							else if ((nVariation == 1) && (nPart==2))
//STRIP001 								APPEND(rRet," rSup");
//STRIP001 							else if ((nVariation == 1) && (nPart==1))
//STRIP001 								APPEND(rRet," rSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x27:
//STRIP001 							if ((nVariation == 0) && (nPart==1))
//STRIP001 								APPEND(rRet," cSup");
//STRIP001 							else if ((nVariation == 1) && (nPart==1))
//STRIP001 								APPEND(rRet," cSub");
//STRIP001 							else if ((nVariation == 2) && (nPart==1))
//STRIP001 								APPEND(rRet," cSub");
//STRIP001 							else if ((nVariation == 2) && (nPart==2))
//STRIP001 								APPEND(rRet," cSup");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x28:
//STRIP001 							if (nVariation == 0)
//STRIP001 							{
//STRIP001 								if (nPart == 0)
//STRIP001 								{
//STRIP001 									sPush = rRet;
//STRIP001 									rRet.Erase();
//STRIP001 								}
//STRIP001 							}
//STRIP001 							APPEND(rRet," {");
//STRIP001 							if (nVariation == 0)
//STRIP001 							{
//STRIP001 								if (nPart == 1)
//STRIP001 									APPEND(rRet,"alignr ");
//STRIP001 							}
//STRIP001 							if (nPart == 0)
//STRIP001 								APPEND(rRet,"\\lline ");
//STRIP001 							if (nVariation == 1)
//STRIP001 								APPEND(rRet,"overline ");
//STRIP001 							break;
//STRIP001 						case 0x29:
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x2a:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								sPush = rRet;
//STRIP001 								rRet.Erase();
//STRIP001 							}
//STRIP001 							if ((nVariation == 0) && (nPart==0))
//STRIP001 								APPEND(rRet," rSup");
//STRIP001 							else if ((nVariation == 2) && (nPart==1))
//STRIP001 								APPEND(rRet," rSup");
//STRIP001 							else if ((nVariation == 1) && (nPart==0))
//STRIP001 								APPEND(rRet," rSub");
//STRIP001 							else if ((nVariation == 2) && (nPart==0))
//STRIP001 								APPEND(rRet," rSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x2b:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								sPush = rRet;
//STRIP001 								rRet.Erase();
//STRIP001 							}
//STRIP001 							if ((nVariation == 0) && (nPart==0))
//STRIP001 								APPEND(rRet," cSup");
//STRIP001 							else if ((nVariation == 2) && (nPart==1))
//STRIP001 								APPEND(rRet," cSup");
//STRIP001 							else if ((nVariation == 1) && (nPart==0))
//STRIP001 								APPEND(rRet," cSub");
//STRIP001 							else if ((nVariation == 2) && (nPart==0))
//STRIP001 								APPEND(rRet," cSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x2c:
//STRIP001 							if (nPart == 0)
//STRIP001 								APPEND(rRet,"\"\"");
//STRIP001 							if ((nVariation == 0)
//STRIP001 									|| ((nVariation == 2) && (nPart==1)))
//STRIP001 								APPEND(rRet," lSup");
//STRIP001 							else if ((nVariation == 1)
//STRIP001 									|| ((nVariation == 2) && (nPart==0)))
//STRIP001 								APPEND(rRet," lSub");
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x2d:
//STRIP001 							if (nVariation==0)
//STRIP001 							{
//STRIP001 								if (nPart == 0)
//STRIP001 									APPEND(rRet," langle ");
//STRIP001 							}
//STRIP001 							else if (nVariation==1)
//STRIP001 							{
//STRIP001 								APPEND(rRet," \\langle ");
//STRIP001 								newline--;
//STRIP001 							}
//STRIP001 							else if (nVariation==2)
//STRIP001 							{
//STRIP001 								APPEND(rRet," \\lline ");
//STRIP001 								newline--;
//STRIP001 							}
//STRIP001 							break;
//STRIP001 						case 0x2e:
//STRIP001 							if (nVariation == 0)
//STRIP001 								APPEND(rRet," widevec ");//left below
//STRIP001 							else if (nVariation == 1)
//STRIP001 								APPEND(rRet," widevec ");//right below
//STRIP001 							else if (nVariation == 2)
//STRIP001 								APPEND(rRet," widevec ");//double headed below
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						case 0x2f:
//STRIP001 							if (nVariation == 0)
//STRIP001 								APPEND(rRet," widevec ");//left above
//STRIP001 							else if (nVariation == 1)
//STRIP001 								APPEND(rRet," widevec ");//right above
//STRIP001 							else if (nVariation == 2)
//STRIP001 								APPEND(rRet," widevec ");//double headed above
//STRIP001 							APPEND(rRet," {");
//STRIP001 							break;
//STRIP001 						default:
//STRIP001 							break;
//STRIP001 						}
//STRIP001 						int nOldCurSize=nCurSize;
//STRIP001                         xub_StrLen nSizeStartPos = rRet.Len();
//STRIP001 						HandleSize(nLSize,nDSize,nSetSize);
//STRIP001 						nRet = HandleRecords(nLevel+1);
//STRIP001 						while (nSetSize)
//STRIP001 						{
//STRIP001                             sal_Bool bOk=sal_False;
//STRIP001                             xub_StrLen nI = rRet.SearchBackward('{');
//STRIP001                             if (nI != STRING_NOTFOUND)
//STRIP001                             {
//STRIP001                                 for(nI=nI+1;nI<rRet.Len();nI++)
//STRIP001                                     if (rRet.GetChar(nI) != ' ')
//STRIP001                                     {
//STRIP001                                         bOk=sal_True;
//STRIP001                                         break;
//STRIP001                                     }
//STRIP001                             }
//STRIP001                             else
//STRIP001                                 bOk=sal_True;
//STRIP001 
//STRIP001                             if (bOk)
//STRIP001 							    APPEND(rRet,"} ");
//STRIP001                             else
//STRIP001                                 rRet.Erase(nSizeStartPos);
//STRIP001 							nSetSize--;
//STRIP001 							nCurSize=nOldCurSize;
//STRIP001 						}
//STRIP001 
//STRIP001 
//STRIP001 						HandleMatrixSeperator(nMatrixRows,nMatrixCols,
//STRIP001 							nCurCol,nCurRow);
//STRIP001 
//STRIP001 						switch (nSelector)
//STRIP001 						{
//STRIP001 						case 0x0:
//STRIP001 							if (nVariation==0)
//STRIP001 								APPEND(rRet," rangle ");
//STRIP001 							else if (nVariation==2)
//STRIP001 								APPEND(rRet," \\rangle ");
//STRIP001 							break;
//STRIP001 						case 0x1:
//STRIP001 							if (nVariation==0)
//STRIP001 								APPEND(rRet," right )");
//STRIP001 							else if (nVariation==2)
//STRIP001 								APPEND(rRet,"\\)");
//STRIP001 							break;
//STRIP001 						case 0x2:
//STRIP001 							if ((nVariation==0) || (nVariation==2))
//STRIP001 								APPEND(rRet," right rbrace ");
//STRIP001 							else
//STRIP001 								APPEND(rRet," right none ");
//STRIP001 							break;
//STRIP001 						case 0x3:
//STRIP001 							if (nVariation==0)
//STRIP001 								APPEND(rRet," right ]");
//STRIP001 							else if (nVariation==2)
//STRIP001 								APPEND(rRet,"\\]");
//STRIP001 							break;
//STRIP001 						case 0x4:
//STRIP001 							if (nVariation==0)
//STRIP001 								APPEND(rRet," rline ");
//STRIP001 							else if (nVariation==2)
//STRIP001 								APPEND(rRet," \\rline ");
//STRIP001 							break;
//STRIP001 						case 0x5:
//STRIP001 							if (nVariation==0)
//STRIP001 								APPEND(rRet," rdline ");
//STRIP001 							else if (nVariation==2)
//STRIP001 								APPEND(rRet," \\rdline ");
//STRIP001 							break;
//STRIP001 						case 0x6:
//STRIP001 							if (nVariation==0)
//STRIP001 								APPEND(rRet," rfloor ");
//STRIP001 							else if (nVariation==2)
//STRIP001 								APPEND(rRet," \\rfloor ");
//STRIP001 							break;
//STRIP001 						case 0x7:
//STRIP001 							if (nVariation==0)
//STRIP001 								APPEND(rRet," rceil ");
//STRIP001 							else if (nVariation==2)
//STRIP001 								APPEND(rRet," \\rceil ");
//STRIP001 							break;
//STRIP001 						case 0x8:
//STRIP001 						case 0xa:
//STRIP001 							APPEND(rRet,"\\[");
//STRIP001 							break;
//STRIP001 						case 0x9:
//STRIP001 						case 0xc:
//STRIP001 							APPEND(rRet,"\\]");
//STRIP001 							break;
//STRIP001 						case 0xd:
//STRIP001 							APPEND(rRet,"} ");
//STRIP001 							if (nVariation == 1)
//STRIP001 							{
//STRIP001 								if (nPart == 0)
//STRIP001 								{
//STRIP001 									newline--;
//STRIP001 									sMainTerm = rRet;
//STRIP001 									rRet.Erase();
//STRIP001 								}
//STRIP001 								else
//STRIP001 								{
//STRIP001 									sPush += rRet;
//STRIP001 									rRet = sPush;
//STRIP001 									rRet += sMainTerm;
//STRIP001 								}
//STRIP001 							}
//STRIP001 							else
//STRIP001 							{
//STRIP001 								if (nPart == 0)
//STRIP001 									newline--;
//STRIP001 							}
//STRIP001 							nPart++;
//STRIP001 							break;
//STRIP001 						case 0xb:
//STRIP001 							APPEND(rRet,"\\)");
//STRIP001 							break;
//STRIP001 						case 0xe:
//STRIP001 							APPEND(rRet,"} ");
//STRIP001 							if (nPart == 0)
//STRIP001 								newline--;
//STRIP001 							else
//STRIP001 								APPEND(rRet,"} ");
//STRIP001 							nPart++;
//STRIP001 							break;
//STRIP001 						case 0xf:
//STRIP001                             {
//STRIP001                             if ((nPart == 0) &&
//STRIP001 									((nVariation == 2) || (nVariation == 1)))
//STRIP001 								newline--;
//STRIP001 
//STRIP001                             sal_Bool bOk=sal_False;
//STRIP001                             xub_StrLen nI = rRet.SearchBackward('{');
//STRIP001                             if (nI != STRING_NOTFOUND)
//STRIP001                             {
//STRIP001                                 for(nI=nI+1;nI<rRet.Len();nI++)
//STRIP001                                     if (rRet.GetChar(nI) != ' ')
//STRIP001                                     {
//STRIP001                                         bOk=sal_True;
//STRIP001                                         break;
//STRIP001                                     }
//STRIP001                             }
//STRIP001                             else
//STRIP001                                 bOk=sal_True;
//STRIP001 
//STRIP001                             if (bOk)
//STRIP001 							    APPEND(rRet,"} ");
//STRIP001                             else
//STRIP001                                 rRet.Erase(nSubSupStartPos);
//STRIP001 							nPart++;
//STRIP001                             }
//STRIP001 							break;
//STRIP001 						case 0x2c:
//STRIP001 							if ((nPart == 0) &&
//STRIP001 									((nVariation == 2) || (nVariation == 1)))
//STRIP001 								newline--;
//STRIP001 							APPEND(rRet,"} ");
//STRIP001 							nPart++;
//STRIP001 							break;
//STRIP001 						case 0x2e:
//STRIP001 						case 0x2f:
//STRIP001 							APPEND(rRet,"} ");
//STRIP001 							break;
//STRIP001                         case 0x10:
//STRIP001                         case 0x11:
//STRIP001                             APPEND(rRet,"}} ");
//STRIP001                             break;
//STRIP001 						case 0x12:
//STRIP001 						case 0x13:
//STRIP001 						case 0x14:
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								newline--;
//STRIP001 								APPEND(rRet,"} ");
//STRIP001 							}
//STRIP001 							nPart++;
//STRIP001 							break;
//STRIP001 						case 0x1b:
//STRIP001 							APPEND(rRet,"} ");
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								newline--;
//STRIP001 								APPEND(rRet,"overbrace");
//STRIP001 							}
//STRIP001 							nPart++;
//STRIP001 							break;
//STRIP001 						case 0x1c:
//STRIP001 							APPEND(rRet,"} ");
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								newline--;
//STRIP001 								APPEND(rRet,"underbrace");
//STRIP001 							}
//STRIP001 							nPart++;
//STRIP001 							break;
//STRIP001 						case 0x27:
//STRIP001 							if (nPart==0)
//STRIP001 								newline--;
//STRIP001 							else if ((nPart==1) &&
//STRIP001 									((nVariation == 2) || (nVariation == 1)))
//STRIP001 								newline--;
//STRIP001 							APPEND(rRet,"} ");
//STRIP001 							nPart++;
//STRIP001 							break;
//STRIP001 						case 0x28:
//STRIP001 							APPEND(rRet,"} ");
//STRIP001 							if (nVariation == 0)
//STRIP001 							{
//STRIP001 								if (nPart == 0)
//STRIP001 								{
//STRIP001 									sMainTerm = rRet;
//STRIP001 									rRet.Erase();
//STRIP001 								}
//STRIP001 								else
//STRIP001 								{
//STRIP001 									sPush += rRet;
//STRIP001 									rRet = sPush;
//STRIP001 									APPEND(rRet," over ");
//STRIP001 									rRet += sMainTerm;
//STRIP001 								}
//STRIP001 							}
//STRIP001 							if (nPart == 0)
//STRIP001 								newline--;
//STRIP001 							nPart++;
//STRIP001 							break;
//STRIP001 						case 0x29:
//STRIP001 							APPEND(rRet,"} ");
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								newline--;
//STRIP001 								switch (nVariation)
//STRIP001 								{
//STRIP001 								case 1:
//STRIP001 									APPEND(rRet,"slash");
//STRIP001 									break;
//STRIP001 								default:
//STRIP001 									APPEND(rRet,"wideslash");
//STRIP001 									break;
//STRIP001 								}
//STRIP001 							}
//STRIP001 							nPart++;
//STRIP001 							break;
//STRIP001 						case 0x1d:
//STRIP001 						case 0x1e:
//STRIP001 						case 0x1f:
//STRIP001 						case 0x20:
//STRIP001 						case 0x21:
//STRIP001 						case 0x22:
//STRIP001 						case 0x23:
//STRIP001 						case 0x24:
//STRIP001 						case 0x25:
//STRIP001 						case 0x26:
//STRIP001 							APPEND(rRet,"} ");
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								if (nVariation != 2)
//STRIP001 								{
//STRIP001 									sMainTerm = rRet;
//STRIP001 									rRet.Erase();
//STRIP001 								}
//STRIP001 								newline--;
//STRIP001 							}
//STRIP001 							else if ((nPart == 1) && (nVariation == 0))
//STRIP001 							{
//STRIP001 								sPush += rRet;
//STRIP001 								rRet = sPush;
//STRIP001 								rRet += sMainTerm;
//STRIP001 								newline--;
//STRIP001 							}
//STRIP001 							else if ((nPart == 1) && (nVariation == 1))
//STRIP001 								newline--;
//STRIP001 							else if ((nPart == 2) && (nVariation == 1))
//STRIP001 							{
//STRIP001 								sPush += rRet;
//STRIP001 								rRet = sPush;
//STRIP001 								rRet += sMainTerm;
//STRIP001 								newline--;
//STRIP001 							}
//STRIP001 							nPart++;
//STRIP001 							break;
//STRIP001 						case 0x15:
//STRIP001 							APPEND(rRet,"} ");
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								if ((nVariation != 0) && (nVariation != 3))
//STRIP001 								{
//STRIP001 									sMainTerm = rRet;
//STRIP001 									rRet.Erase();
//STRIP001 								}
//STRIP001 								newline--;
//STRIP001 							}
//STRIP001 							else if ((nPart == 1) &&
//STRIP001 									((nVariation == 1) || (nVariation==4)))
//STRIP001 							{
//STRIP001 								sPush += rRet;
//STRIP001 								rRet = sPush;
//STRIP001 								rRet += sMainTerm;
//STRIP001 								newline--;
//STRIP001 							}
//STRIP001 							else if ((nPart == 1) && (nVariation == 2))
//STRIP001 								newline--;
//STRIP001 							else if ((nPart == 2) && (nVariation == 2))
//STRIP001 							{
//STRIP001 								sPush += rRet;
//STRIP001 								rRet = sPush;
//STRIP001 								rRet += sMainTerm;
//STRIP001 								newline--;
//STRIP001 							}
//STRIP001 							nPart++;
//STRIP001 							break;
//STRIP001 						case 0x16:
//STRIP001 						case 0x17:
//STRIP001 							APPEND(rRet,"} ");
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								if ((nVariation != 0) && (nVariation != 2))
//STRIP001 								{
//STRIP001 									sMainTerm = rRet;
//STRIP001 									rRet.Erase();
//STRIP001 								}
//STRIP001 								newline--;
//STRIP001 							}
//STRIP001 							else if ((nPart == 1) &&
//STRIP001 									((nVariation == 1) || (nVariation==3)))
//STRIP001 							{
//STRIP001 								sPush += rRet;
//STRIP001 								rRet = sPush;
//STRIP001 								rRet += sMainTerm;
//STRIP001 								newline--;
//STRIP001 							}
//STRIP001 							nPart++;
//STRIP001 							break;
//STRIP001 						case 0x18:
//STRIP001 							APPEND(rRet,"} ");
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								sMainTerm = rRet;
//STRIP001 								rRet.Erase();
//STRIP001 								newline--;
//STRIP001 							}
//STRIP001 							else if ((nPart == 1) &&
//STRIP001 									((nVariation == 1) || (nVariation==2)))
//STRIP001 							{
//STRIP001 								sPush += rRet;
//STRIP001 								rRet = sPush;
//STRIP001 								rRet += sMainTerm;
//STRIP001 								newline--;
//STRIP001 							}
//STRIP001 							else if ((nPart == 1) && (nVariation == 0))
//STRIP001 								newline--;
//STRIP001 							else if ((nPart == 2) && (nVariation == 0))
//STRIP001 							{
//STRIP001 								sPush += rRet;
//STRIP001 								rRet = sPush;
//STRIP001 								rRet += sMainTerm;
//STRIP001 								newline--;
//STRIP001 							}
//STRIP001 							nPart++;
//STRIP001 							break;
//STRIP001 						case 0x19:
//STRIP001 						case 0x1a:
//STRIP001 							APPEND(rRet,"} ");
//STRIP001 							if (nPart == 0)
//STRIP001 							{
//STRIP001 								sMainTerm = rRet;
//STRIP001 								rRet.Erase();
//STRIP001 								newline--;
//STRIP001 							}
//STRIP001 							else if (nPart == 1)
//STRIP001 							{
//STRIP001 								sPush += rRet;
//STRIP001 								rRet = sPush;
//STRIP001 								rRet += sMainTerm;
//STRIP001 								newline--;
//STRIP001 							}
//STRIP001 							nPart++;
//STRIP001 							break;
//STRIP001 						case 0x2a:
//STRIP001 						case 0x2b:
//STRIP001 							APPEND(rRet,"} ");
//STRIP001 
//STRIP001 							if ((nPart == 0) &&
//STRIP001 									((nVariation == 0) || (nVariation == 1)))
//STRIP001 							{
//STRIP001 								sMainTerm = rRet;
//STRIP001 								rRet.Erase();
//STRIP001 								newline--;
//STRIP001 							}
//STRIP001 							else if ((nPart == 0) && (nVariation == 2))
//STRIP001 								newline--;
//STRIP001 							else if ((nPart == 1) && (nVariation == 2))
//STRIP001 							{
//STRIP001 								sMainTerm = rRet;
//STRIP001 								rRet.Erase();
//STRIP001 								newline--;
//STRIP001 							}
//STRIP001 							else if ((nPart == 2) || (((nPart == 1) &&
//STRIP001 									(nVariation == 0) || (nVariation == 1))))
//STRIP001 							{
//STRIP001 								sPush+=rRet;
//STRIP001 								rRet = sPush;
//STRIP001 								rRet += sMainTerm;
//STRIP001 							}
//STRIP001 							nPart++;
//STRIP001 							break;
//STRIP001 						case 0x2d:
//STRIP001 							if (nVariation==0)
//STRIP001 							{
//STRIP001 								if (nPart == 0)
//STRIP001 								{
//STRIP001 									newline--; //there is another term to arrive
//STRIP001 									APPEND(rRet," mline ");
//STRIP001 								}
//STRIP001 								else
//STRIP001 									APPEND(rRet," rangle ");
//STRIP001 							}
//STRIP001 							else if (nVariation==1)
//STRIP001 								APPEND(rRet," \\lline ");
//STRIP001 							else if (nVariation==2)
//STRIP001 								APPEND(rRet," \\rangle ");
//STRIP001 							nPart++;
//STRIP001 							break;
//STRIP001 						default:
//STRIP001 							break;
//STRIP001 						}
//STRIP001 						bSilent = TRUE; //Skip the optional brackets and/or
//STRIP001 										//symbols that follow some of these
//STRIP001 										//records. Foo Data.
//STRIP001 
//STRIP001 						/*In matrices and piles we cannot seperate equation
//STRIP001 						 *lines with the newline keyword*/
//STRIP001 						if (nMatrixCols==0)
//STRIP001 							newline++;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			case CHAR:
//STRIP001 				nRet = HandleChar(nTextStart,nSetSize,nLevel,nTag,nSelector,
//STRIP001 					nVariation,bSilent);
//STRIP001  				break;
//STRIP001 			case TMPL:
//STRIP001 				nRet = HandleTemplate(nLevel,nSelector,nVariation,
//STRIP001 					nLastTemplateBracket);
//STRIP001 				break;
//STRIP001 			case PILE:
//STRIP001 				nRet = HandlePile(nSetAlign,nLevel,nSelector,nVariation);
//STRIP001 				HandleMatrixSeperator(nMatrixRows,nMatrixCols,nCurCol,nCurRow);
//STRIP001 				break;
//STRIP001 			case MATRIX:
//STRIP001 				nRet = HandleMatrix(nLevel,nSelector,nVariation);
//STRIP001 				HandleMatrixSeperator(nMatrixRows,nMatrixCols,nCurCol,nCurRow);
//STRIP001 				break;
//STRIP001 			case EMBEL:
//STRIP001 				HandleEmblishments();
//STRIP001 				break;
//STRIP001 			case RULER:
//STRIP001 				*pS >> nTabStops;
//STRIP001 				for (i=0;i<nTabStops;i++)
//STRIP001 				{
//STRIP001 					*pS >> nTabType;
//STRIP001 					*pS >> nTabOffset;
//STRIP001 				}
//STRIP001 				DBG_ASSERT(FALSE,"Not seen in the wild Equation Ruler Field")
//STRIP001 				break;
//STRIP001 			case FONT:
//STRIP001 				{
//STRIP001 					MathTypeFont aFont;
//STRIP001 					*pS >> aFont.nTface;
//STRIP001                     /*
//STRIP001 					The typeface number is the negative (which makes it
//STRIP001 					positive) of the typeface value (unbiased) that appears in
//STRIP001 					CHAR records that might follow a given FONT record
//STRIP001                     */
//STRIP001                     aFont.nTface = 128-aFont.nTface;
//STRIP001 					*pS >> aFont.nStyle;
//STRIP001 					aUserStyles.insert(aFont);
//STRIP001 					sFontName.Erase();
//STRIP001 					do
//STRIP001 					{
//STRIP001 						*pS >> nChar8;
//STRIP001 						sFontName.Append(ByteString::ConvertToUnicode(
//STRIP001 							nChar8,RTL_TEXTENCODING_MS_1252));
//STRIP001 					}
//STRIP001 					while(nChar8);
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			case SIZE:
//STRIP001 				HandleSetSize();
//STRIP001 				break;
//STRIP001 			case 10:
//STRIP001 			case 11:
//STRIP001 			case 12:
//STRIP001 			case 13:
//STRIP001 			case 14:
//STRIP001 				nLSize=nRecord-10;
//STRIP001 				break;
//STRIP001 			case END:
//STRIP001 			default:
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	while (nRecord != END);
//STRIP001 	while (nSetSize)
//STRIP001 	{
//STRIP001 		rRet += '}';
//STRIP001 		nSetSize--;
//STRIP001 	}
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 /*Simply determine if we are at the end of a record or the end of a line,
//STRIP001  *with fiddley logic to see if we are in a matrix or a pile or neither
//STRIP001 
//STRIP001  Note we cannot tell until after the event that this is the last entry
//STRIP001  of a pile, so we must strip the last seperator of a pile after this
//STRIP001  is detected in the PILE handler
//STRIP001  */
//STRIP001 void MathType::HandleMatrixSeperator(int nMatrixRows,int nMatrixCols,
//STRIP001 	int &rCurCol,int &rCurRow)
//STRIP001 {
//STRIP001 	if (nMatrixRows!=0)
//STRIP001 	{
//STRIP001 		if (rCurCol == nMatrixCols-1)
//STRIP001 		{
//STRIP001 			if (rCurRow != nMatrixRows-1)
//STRIP001 				APPEND(rRet," {} ##\n");
//STRIP001 			if (nMatrixRows!=-1)
//STRIP001 			{
//STRIP001 				rCurCol=0;
//STRIP001 				rCurRow++;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			APPEND(rRet," {} # ");
//STRIP001 			if (nMatrixRows!=-1)
//STRIP001 				rCurCol++;
//STRIP001 			else
//STRIP001 			    rRet += '\n';
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /* set the alignment of the following term, but starmath currently
//STRIP001  * cannot handle vertical alignment */
//STRIP001 void MathType::HandleAlign(sal_uInt8 nHAlign,sal_uInt8 nVAlign,int &rSetAlign)
//STRIP001 {
//STRIP001 	switch(nHAlign)
//STRIP001 	{
//STRIP001 	case 1:
//STRIP001 	default:
//STRIP001 		APPEND(rRet,"alignl {");
//STRIP001 		break;
//STRIP001 	case 2:
//STRIP001 		APPEND(rRet,"alignc {");
//STRIP001 		break;
//STRIP001 	case 3:
//STRIP001 		APPEND(rRet,"alignr {");
//STRIP001 		break;
//STRIP001 	}
//STRIP001 #if 0
//STRIP001 	switch(nVAlign)
//STRIP001 	{
//STRIP001 	}
//STRIP001 	rSetAlign+=2;
//STRIP001 #endif
//STRIP001 	rSetAlign++;
//STRIP001 }
//STRIP001 
//STRIP001 /* set size of text, complexity due to overuse of signedness as a flag
//STRIP001  * indicator by mathtype file format*/
//STRIP001 sal_Bool MathType::HandleSize(sal_Int16 nLSize,sal_Int16 nDSize, int &rSetSize)
//STRIP001 {
//STRIP001 	sal_Bool bRet=FALSE;
//STRIP001 	if (nLSize < 0)
//STRIP001 	{
//STRIP001 		if ((-nLSize/32 != nDefaultSize) && (-nLSize/32 != nCurSize))
//STRIP001 		{
//STRIP001 			if (rSetSize)
//STRIP001 			{
//STRIP001 				rSetSize--;
//STRIP001 				rRet += '}';
//STRIP001 				bRet=TRUE;
//STRIP001 			}
//STRIP001 			if (-nLSize/32 != nLastSize)
//STRIP001 			{
//STRIP001 				nLastSize = nCurSize;
//STRIP001 				APPEND(rRet," size ");
//STRIP001 				rRet += String::CreateFromInt32(-nLSize/32);
//STRIP001 				rRet += '{';
//STRIP001 				bRet=TRUE;
//STRIP001 				rSetSize++;
//STRIP001 			}
//STRIP001 			nCurSize = -nLSize/32;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		/*sizetable should theoreticaly be filled with the default sizes
//STRIP001 		 *of the various font groupings matching starmaths equivalents
//STRIP001 		 in aTypeFaces, and a test would be done to see if the new font
//STRIP001 		 size would be the same as what starmath would have chosen for
//STRIP001 		 itself anyway in which case the size setting could be ignored*/
//STRIP001 		nLSize = aSizeTable[nLSize];
//STRIP001 		nLSize += nDSize;
//STRIP001 		//if (nLSize != nDefaultSize)
//STRIP001 		if (nLSize != nCurSize)
//STRIP001 		{
//STRIP001 			if (rSetSize)
//STRIP001 			{
//STRIP001 				rSetSize--;
//STRIP001 				rRet += '}';
//STRIP001 				bRet=TRUE;
//STRIP001 			}
//STRIP001 			if (nLSize != nLastSize)
//STRIP001 			{
//STRIP001 				nLastSize = nCurSize;
//STRIP001 				APPEND(rRet," size ");
//STRIP001 				rRet += String::CreateFromInt32(nLSize);
//STRIP001 				rRet += '{';
//STRIP001 				bRet=TRUE;
//STRIP001 				rSetSize++;
//STRIP001 			}
//STRIP001 			nCurSize = nLSize;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 int MathType::ConvertFromStarMath(SvStorage *pStor)
//STRIP001 {
//STRIP001 	if (!pTree)
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	SvGlobalName aGName(0x0002ce02L, 0x0000, 0x0000,0xc0,0x00,
//STRIP001 		0x00,0x00,0x00,0x00,0x00,0x46 );
//STRIP001 	pStor->SetClass( aGName, 0, C2S("Microsoft Equation 3.0"));
//STRIP001 
//STRIP001 	static sal_uInt8 __READONLY_DATA aCompObj[] = {
//STRIP001 		0x01, 0x00, 0xFE, 0xFF, 0x03, 0x0A, 0x00, 0x00,
//STRIP001 		0xFF, 0xFF, 0xFF, 0xFF, 0x02, 0xCE, 0x02, 0x00,
//STRIP001 		0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00,
//STRIP001 		0x00, 0x00, 0x00, 0x46, 0x17, 0x00, 0x00, 0x00,
//STRIP001 		0x4D, 0x69, 0x63, 0x72, 0x6F, 0x73, 0x6F, 0x66,
//STRIP001 		0x74, 0x20, 0x45, 0x71, 0x75, 0x61, 0x74, 0x69,
//STRIP001 		0x6F, 0x6E, 0x20, 0x33, 0x2E, 0x30, 0x00, 0x0C,
//STRIP001 		0x00, 0x00, 0x00, 0x44, 0x53, 0x20, 0x45, 0x71,
//STRIP001 		0x75, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x00, 0x0B,
//STRIP001 		0x00, 0x00, 0x00, 0x45, 0x71, 0x75, 0x61, 0x74,
//STRIP001 		0x69, 0x6F, 0x6E, 0x2E, 0x33, 0x00, 0xF4, 0x39,
//STRIP001 		0xB2, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//STRIP001 		0x00, 0x00, 0x00, 0x00, 0x00, 0x00
//STRIP001 	};
//STRIP001 	SvStorageStreamRef xStor( pStor->OpenStream( C2S("\1CompObj")));
//STRIP001 	xStor->Write(aCompObj,sizeof(aCompObj));
//STRIP001 
//STRIP001 	static sal_uInt8 __READONLY_DATA aOle[] = {
//STRIP001 		0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
//STRIP001 		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//STRIP001 		0x00, 0x00, 0x00, 0x00
//STRIP001 		};
//STRIP001 	SvStorageStreamRef xStor2( pStor->OpenStream( C2S("\1Ole")));
//STRIP001 	xStor2->Write(aOle,sizeof(aOle));
//STRIP001 	xStor.Clear();
//STRIP001 	xStor2.Clear();
//STRIP001 
//STRIP001 	SvStorageStreamRef xSrc = pStor->OpenStream(C2S("Equation Native"));
//STRIP001 	if ( (!xSrc.Is()) || (SVSTREAM_OK != xSrc->GetError()))
//STRIP001 		return NULL;
//STRIP001 
//STRIP001 	pS = &xSrc;
//STRIP001 	pS->SetNumberFormatInt( NUMBERFORMAT_INT_LITTLEENDIAN );
//STRIP001 
//STRIP001 	pS->SeekRel(EQNOLEFILEHDR_SIZE); //Skip 28byte Header and fill it in later
//STRIP001 	*pS << sal_uInt8(0x03);
//STRIP001 	*pS << sal_uInt8(0x01);
//STRIP001 	*pS << sal_uInt8(0x01);
//STRIP001 	*pS << sal_uInt8(0x03);
//STRIP001 	*pS << sal_uInt8(0x00);
//STRIP001 	sal_uInt32 nSize = pS->Tell();
//STRIP001 	nPendingAttributes=0;
//STRIP001 
//STRIP001 	HandleNodes(pTree);
//STRIP001 	*pS << sal_uInt8(END);
//STRIP001 
//STRIP001 	nSize = pS->Tell()-nSize;
//STRIP001 	pS->Seek(0);
//STRIP001 	EQNOLEFILEHDR aHdr(nSize+4+1);
//STRIP001 	aHdr.Write(pS);
//STRIP001 	return 1;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 sal_uInt8 MathType::HandleNodes(SmNode *pNode,int nLevel)
//STRIP001 {
//STRIP001 	sal_Bool bRet=FALSE;
//STRIP001 	switch(pNode->GetType())
//STRIP001 	{
//STRIP001 		case NATTRIBUT:
//STRIP001 			HandleAttributes(pNode,nLevel);
//STRIP001 			break;
//STRIP001 		case NTEXT:
//STRIP001 			HandleText(pNode,nLevel);
//STRIP001 			break;
//STRIP001 		case NVERTICAL_BRACE:
//STRIP001 			HandleVerticalBrace(pNode,nLevel);
//STRIP001 			break;
//STRIP001 		case NBRACE:
//STRIP001 			HandleBrace(pNode,nLevel);
//STRIP001 			break;
//STRIP001 		case NOPER:
//STRIP001 			HandleOperator(pNode,nLevel);
//STRIP001 			break;
//STRIP001 		case NBINVER:
//STRIP001 			HandleFractions(pNode,nLevel);
//STRIP001 			break;
//STRIP001 		case NROOT:
//STRIP001 			HandleRoot(pNode,nLevel);
//STRIP001 			break;
//STRIP001 		case NSPECIAL:
//STRIP001 			{
//STRIP001 			SmTextNode *pText=(SmTextNode *)pNode;
//STRIP001 			//if the token str and the result text are the same then this
//STRIP001 			//is to be seen as text, else assume its a mathchar
//STRIP001 			if (pText->GetText() == pText->GetToken().aText)
//STRIP001 				HandleText(pText,nLevel);
//STRIP001 			else
//STRIP001 				HandleMath(pText,nLevel);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case NMATH:
//STRIP001 			HandleMath(pNode,nLevel);
//STRIP001 			break;
//STRIP001 		case NSUBSUP:
//STRIP001 			HandleSubSupScript(pNode,nLevel);
//STRIP001 			break;
//STRIP001 		case NEXPRESSION:
//STRIP001 			{
//STRIP001 			USHORT  nSize = pNode->GetNumSubNodes();
//STRIP001 			for (USHORT i = 0; i < nSize; i++)
//STRIP001 				if (SmNode *pTemp = pNode->GetSubNode(i))
//STRIP001 					HandleNodes(pTemp,nLevel+1);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case NTABLE:
//STRIP001 			//Root Node, PILE equivalent, i.e. vertical stack
//STRIP001 			HandleTable(pNode,nLevel);
//STRIP001 			break;
//STRIP001 		case NMATRIX:
//STRIP001 			HandleSmMatrix((SmMatrixNode *)pNode,nLevel);
//STRIP001 			break;
//STRIP001 		case NLINE:
//STRIP001 			{
//STRIP001 			*pS << sal_uInt8(0x0a);
//STRIP001 			*pS << sal_uInt8(LINE);
//STRIP001 			USHORT  nSize = pNode->GetNumSubNodes();
//STRIP001 			for (USHORT i = 0; i < nSize; i++)
//STRIP001 				if (SmNode *pTemp = pNode->GetSubNode(i))
//STRIP001 					HandleNodes(pTemp,nLevel+1);
//STRIP001 			*pS << sal_uInt8(END);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case NALIGN:
//STRIP001 			HandleMAlign(pNode,nLevel);
//STRIP001 			break;
//STRIP001 		case NBLANK:
//STRIP001 			*pS << sal_uInt8(CHAR);
//STRIP001 			*pS << sal_uInt8(0x98);
//STRIP001 			if (pNode->GetToken().eType == TSBLANK)
//STRIP001 				*pS << sal_uInt16(0xEB04);
//STRIP001 			else
//STRIP001 				*pS << sal_uInt16(0xEB05);
//STRIP001 			break;
//STRIP001 
//STRIP001 			break;
//STRIP001 		default:
//STRIP001 			{
//STRIP001 			USHORT  nSize = pNode->GetNumSubNodes();
//STRIP001 			for (USHORT i = 0; i < nSize; i++)
//STRIP001 				if (SmNode *pTemp = pNode->GetSubNode(i))
//STRIP001 					HandleNodes(pTemp,nLevel+1);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 int MathType::StartTemplate(sal_uInt16 nSelector,sal_uInt16 nVariation)
//STRIP001 {
//STRIP001 	int nOldPending=nPendingAttributes;
//STRIP001 	*pS << sal_uInt8(TMPL); //Template
//STRIP001 	*pS << sal_uInt8(nSelector); //selector
//STRIP001 	*pS << sal_uInt8(nVariation); //variation
//STRIP001 	*pS << sal_uInt8(0x00); //options
//STRIP001 	*pS << sal_uInt8(LINE);
//STRIP001 	//theres just no way we can now handle any character
//STRIP001 	//attributes (from mathtypes perspective) centered
//STRIP001 	//over an expression but above template attribute
//STRIP001 	//such as widevec and similiar constructs
//STRIP001 	//we have to drop them
//STRIP001 	nPendingAttributes=0;
//STRIP001 	return nOldPending;
//STRIP001 }
//STRIP001 
//STRIP001 void MathType::EndTemplate(int nOldPendingAttributes)
//STRIP001 {
//STRIP001 	*pS << sal_uInt8(END); //end line
//STRIP001 	*pS << sal_uInt8(END); //end template
//STRIP001 	nPendingAttributes=nOldPendingAttributes;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void MathType::HandleSmMatrix(SmMatrixNode *pMatrix,int nLevel)
//STRIP001 {
//STRIP001 	*pS << sal_uInt8(MATRIX);
//STRIP001 	*pS << sal_uInt8(0x00); //vAlign ?
//STRIP001 	*pS << sal_uInt8(0x00); //h_just
//STRIP001 	*pS << sal_uInt8(0x00); //v_just
//STRIP001 	*pS << sal_uInt8(pMatrix->GetNumRows()); //v_just
//STRIP001 	*pS << sal_uInt8(pMatrix->GetNumCols()); //v_just
//STRIP001 	int nBytes=(pMatrix->GetNumRows()+1)*2/8;
//STRIP001 	if (((pMatrix->GetNumRows()+1)*2)%8)
//STRIP001 		nBytes++;
//STRIP001 	for (USHORT j = 0; j < nBytes; j++)
//STRIP001 		*pS << sal_uInt8(0x00); //row_parts
//STRIP001 	nBytes=(pMatrix->GetNumCols()+1)*2/8;
//STRIP001 	if (((pMatrix->GetNumCols()+1)*2)%8)
//STRIP001 		nBytes++;
//STRIP001 	for (USHORT k = 0; k < nBytes; k++)
//STRIP001 		*pS << sal_uInt8(0x00); //col_parts
//STRIP001 	USHORT  nSize = pMatrix->GetNumSubNodes();
//STRIP001 	for (USHORT i = 0; i < nSize; i++)
//STRIP001 		if (SmNode *pTemp = pMatrix->GetSubNode(i))
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(LINE); //line
//STRIP001 			HandleNodes(pTemp,nLevel+1);
//STRIP001 			*pS << sal_uInt8(END); //end line
//STRIP001 		}
//STRIP001 	*pS << sal_uInt8(END);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 //Root Node, PILE equivalent, i.e. vertical stack
//STRIP001 void MathType::HandleTable(SmNode *pNode,int nLevel)
//STRIP001 {
//STRIP001 	USHORT  nSize = pNode->GetNumSubNodes();
//STRIP001 	//The root of the starmath is a table, if
//STRIP001 	//we convert this them each iteration of
//STRIP001 	//conversion from starmath to mathtype will
//STRIP001 	//add an extra unnecessary level to the
//STRIP001 	//mathtype output stack which would grow
//STRIP001 	//without bound in a multi step conversion
//STRIP001 
//STRIP001 	if (nLevel == 0)
//STRIP001 		*pS << sal_uInt8(0x0A); //initial size
//STRIP001 
//STRIP001 	if ( nLevel || (nSize >1))
//STRIP001 	{
//STRIP001 		*pS << sal_uInt8(PILE);
//STRIP001 		*pS << sal_uInt8(nHAlign); //vAlign ?
//STRIP001 		*pS << sal_uInt8(0x01); //hAlign
//STRIP001 	}
//STRIP001 
//STRIP001 	for (USHORT i = 0; i < nSize; i++)
//STRIP001 		if (SmNode *pTemp = pNode->GetSubNode(i))
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(LINE);
//STRIP001 			HandleNodes(pTemp,nLevel+1);
//STRIP001 			*pS << sal_uInt8(END);
//STRIP001 		}
//STRIP001 	if (nLevel || (nSize>1))
//STRIP001 		*pS << sal_uInt8(END);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void MathType::HandleRoot(SmNode *pNode,int nLevel)
//STRIP001 {
//STRIP001 	USHORT  nSize = pNode->GetNumSubNodes();
//STRIP001 	SmNode *pTemp;
//STRIP001 	*pS << sal_uInt8(TMPL); //Template
//STRIP001 	*pS << sal_uInt8(0x0D); //selector
//STRIP001 	if (pNode->GetSubNode(0))
//STRIP001 		*pS << sal_uInt8(0x01); //variation
//STRIP001 	else
//STRIP001 		*pS << sal_uInt8(0x00); //variation
//STRIP001 	*pS << sal_uInt8(0x00); //options
//STRIP001 
//STRIP001 	/*
//STRIP001 	if (pTemp = pNode->GetSubNode(1))
//STRIP001 			HandleNodes(pTemp,nLevel+1);
//STRIP001 	*/
//STRIP001 	if (pTemp = pNode->GetSubNode(2))
//STRIP001 	{
//STRIP001 		*pS << sal_uInt8(LINE); //line
//STRIP001 		HandleNodes(pTemp,nLevel+1);
//STRIP001 		*pS << sal_uInt8(END);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pTemp = pNode->GetSubNode(0))
//STRIP001 	{
//STRIP001 		*pS << sal_uInt8(LINE); //line
//STRIP001 		HandleNodes(pTemp,nLevel+1);
//STRIP001 		*pS << sal_uInt8(END);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		*pS << sal_uInt8(LINE|0x10); //dummy line
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 	*pS << sal_uInt8(END);
//STRIP001 }
//STRIP001 
//STRIP001 sal_uInt8 MathType::HandleCScript(SmNode *pNode,SmNode *pContent,int nLevel,
//STRIP001 	ULONG *pPos,sal_Bool bTest)
//STRIP001 {
//STRIP001 	sal_uInt8 nVariation2=0xff;
//STRIP001 
//STRIP001 	if (bTest && pNode->GetSubNode(CSUP+1))
//STRIP001 	{
//STRIP001 		nVariation2=0;
//STRIP001 		if (pNode->GetSubNode(CSUB+1))
//STRIP001 			nVariation2=2;
//STRIP001 	}
//STRIP001 	else if (pNode->GetSubNode(CSUB+1))
//STRIP001 		nVariation2=1;
//STRIP001 
//STRIP001 	if (nVariation2!=0xff)
//STRIP001 	{
//STRIP001 		if (pPos)
//STRIP001 			*pPos = pS->Tell();
//STRIP001 		*pS << sal_uInt8(TMPL); //Template
//STRIP001 		*pS << sal_uInt8(0x2B); //selector
//STRIP001 		*pS << nVariation2;
//STRIP001 		*pS << sal_uInt8(0x00); //options
//STRIP001 
//STRIP001 		if (pContent)
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(LINE); //line
//STRIP001 			HandleNodes(pContent,nLevel+1);
//STRIP001 			*pS << sal_uInt8(END); //line
//STRIP001 		}
//STRIP001 		else
//STRIP001 			*pS << sal_uInt8(LINE|0x10);
//STRIP001 
//STRIP001 		*pS << sal_uInt8(0x0B);
//STRIP001 
//STRIP001 		SmNode *pTemp;
//STRIP001 		if (pTemp = pNode->GetSubNode(CSUB+1))
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(LINE); //line
//STRIP001 			HandleNodes(pTemp,nLevel+1);
//STRIP001 			*pS << sal_uInt8(END); //line
//STRIP001 		}
//STRIP001 		else
//STRIP001 			*pS << sal_uInt8(LINE|0x10);
//STRIP001 		if (bTest && (pTemp = pNode->GetSubNode(CSUP+1)))
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(LINE); //line
//STRIP001 			HandleNodes(pTemp,nLevel+1);
//STRIP001 			*pS << sal_uInt8(END); //line
//STRIP001 		}
//STRIP001 		else
//STRIP001 			*pS << sal_uInt8(LINE|0x10);
//STRIP001 	}
//STRIP001 	return nVariation2;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 /*
//STRIP001  Sub and Sup scripts and another problem area, StarMath
//STRIP001  can have all possible options used at the same time, whereas
//STRIP001  Mathtype cannot. The ordering of the nodes for each system
//STRIP001  is quite different as well leading to some complexity
//STRIP001  */
//STRIP001 void MathType::HandleSubSupScript(SmNode *pNode,int nLevel)
//STRIP001 {
//STRIP001 	USHORT  nSize = pNode->GetNumSubNodes();
//STRIP001 	SmNode *pTemp;
//STRIP001 
//STRIP001 	sal_uInt8 nVariation=0xff;
//STRIP001 	if (pNode->GetSubNode(LSUP+1))
//STRIP001 	{
//STRIP001 		nVariation=0;
//STRIP001 		if (pNode->GetSubNode(LSUB+1))
//STRIP001 			nVariation=2;
//STRIP001 	}
//STRIP001 	else if (pTemp = pNode->GetSubNode(LSUB+1))
//STRIP001 		nVariation=1;
//STRIP001 
//STRIP001 	if (nVariation!=0xff)
//STRIP001 	{
//STRIP001 		*pS << sal_uInt8(TMPL); //Template
//STRIP001 		*pS << sal_uInt8(0x2c); //selector
//STRIP001 		*pS << nVariation;
//STRIP001 		*pS << sal_uInt8(0x00); //options
//STRIP001 		*pS << sal_uInt8(0x0B);
//STRIP001 
//STRIP001 		if (pTemp = pNode->GetSubNode(LSUB+1))
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(LINE); //line
//STRIP001 			HandleNodes(pTemp,nLevel+1);
//STRIP001 			*pS << sal_uInt8(END); //line
//STRIP001 		}
//STRIP001 		else
//STRIP001 			*pS << sal_uInt8(LINE|0x10);
//STRIP001 		if (pTemp = pNode->GetSubNode(LSUP+1))
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(LINE); //line
//STRIP001 			HandleNodes(pTemp,nLevel+1);
//STRIP001 			*pS << sal_uInt8(END); //line
//STRIP001 		}
//STRIP001 		else
//STRIP001 			*pS << sal_uInt8(LINE|0x10);
//STRIP001 		*pS << sal_uInt8(END);
//STRIP001 		nVariation=0xff;
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	sal_uInt8 nVariation2=HandleCScript(pNode,NULL,nLevel);
//STRIP001 
//STRIP001 	if (pTemp = pNode->GetSubNode(0))
//STRIP001 	{
//STRIP001 //		*pS << sal_uInt8(0x0A);
//STRIP001 //		*pS << sal_uInt8(LINE);
//STRIP001 		HandleNodes(pTemp,nLevel+1);
//STRIP001 //		*pS << sal_uInt8(END);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nVariation2 != 0xff)
//STRIP001 		*pS << sal_uInt8(END);
//STRIP001 
//STRIP001 	if (pNode->GetSubNode(RSUP+1))
//STRIP001 	{
//STRIP001 		nVariation=0;
//STRIP001 		if (pNode->GetSubNode(RSUB+1))
//STRIP001 			nVariation=2;
//STRIP001 	}
//STRIP001 	else if (pTemp = pNode->GetSubNode(RSUB+1))
//STRIP001 		nVariation=1;
//STRIP001 
//STRIP001 	if (nVariation!=0xff)
//STRIP001 	{
//STRIP001 		*pS << sal_uInt8(TMPL); //Template
//STRIP001 		*pS << sal_uInt8(0x0F); //selector
//STRIP001 		*pS << nVariation;
//STRIP001 		*pS << sal_uInt8(0x00); //options
//STRIP001 		*pS << sal_uInt8(0x0B);
//STRIP001 
//STRIP001 		if (pTemp = pNode->GetSubNode(RSUB+1))
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(LINE); //line
//STRIP001 			HandleNodes(pTemp,nLevel+1);
//STRIP001 			*pS << sal_uInt8(END); //line
//STRIP001 		}
//STRIP001 		else
//STRIP001 			*pS << sal_uInt8(LINE|0x10);
//STRIP001 		if (pTemp = pNode->GetSubNode(RSUP+1))
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(LINE); //line
//STRIP001 			HandleNodes(pTemp,nLevel+1);
//STRIP001 			*pS << sal_uInt8(END); //line
//STRIP001 		}
//STRIP001 		else
//STRIP001 			*pS << sal_uInt8(LINE|0x10);
//STRIP001 	*pS << sal_uInt8(END); //line
//STRIP001 	}
//STRIP001 
//STRIP001 	//After subscript mathtype will keep the size of
//STRIP001 	//normal text at the subscript size, sigh.
//STRIP001 	*pS << sal_uInt8(0x0A);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void MathType::HandleFractions(SmNode *pNode,int nLevel)
//STRIP001 {
//STRIP001 	USHORT  nSize = pNode->GetNumSubNodes();
//STRIP001 	SmNode *pTemp;
//STRIP001 	*pS << sal_uInt8(TMPL); //Template
//STRIP001 	*pS << sal_uInt8(0x0E); //selector
//STRIP001 	*pS << sal_uInt8(0x00); //variation
//STRIP001 	*pS << sal_uInt8(0x00); //options
//STRIP001 
//STRIP001 	*pS << sal_uInt8(0x0A);
//STRIP001 	*pS << sal_uInt8(LINE); //line
//STRIP001 	if (pTemp = pNode->GetSubNode(0))
//STRIP001 		HandleNodes(pTemp,nLevel+1);
//STRIP001 	*pS << sal_uInt8(END);
//STRIP001 
//STRIP001 	*pS << sal_uInt8(0x0A);
//STRIP001 	*pS << sal_uInt8(LINE); //line
//STRIP001 	if (pTemp = pNode->GetSubNode(2))
//STRIP001 		HandleNodes(pTemp,nLevel+1);
//STRIP001 	*pS << sal_uInt8(END);
//STRIP001 
//STRIP001 	*pS << sal_uInt8(END);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void MathType::HandleBrace(SmNode *pNode,int nLevel)
//STRIP001 {
//STRIP001 	USHORT  nSize = pNode->GetNumSubNodes();
//STRIP001 	SmNode *pTemp;
//STRIP001 	SmNode *pLeft=pNode->GetSubNode(0);
//STRIP001 	SmNode *pRight=pNode->GetSubNode(2);
//STRIP001 
//STRIP001 	*pS << sal_uInt8(TMPL); //Template
//STRIP001 	bReInterpBrace=0;
//STRIP001 	sal_uInt8 nBSpec=0x10;
//STRIP001 	ULONG nLoc = pS->Tell();
//STRIP001 	if (pLeft)
//STRIP001 	{
//STRIP001 		switch (pLeft->GetToken().eType)
//STRIP001 		{
//STRIP001 			case TLANGLE:
//STRIP001 				*pS << sal_uInt8(tmANGLE); //selector
//STRIP001 				*pS << sal_uInt8(0x00); //variation
//STRIP001 				*pS << sal_uInt8(0x00); //options
//STRIP001 				break;
//STRIP001 			case TLBRACE:
//STRIP001 				*pS << sal_uInt8(tmBRACE); //selector
//STRIP001 				*pS << sal_uInt8(0x00); //variation
//STRIP001 				*pS << sal_uInt8(0x00); //options
//STRIP001 				nBSpec+=3;
//STRIP001 				break;
//STRIP001 			case TLBRACKET:
//STRIP001 				*pS << sal_uInt8(tmBRACK); //selector
//STRIP001 				*pS << sal_uInt8(0x00); //variation
//STRIP001 				*pS << sal_uInt8(0x00); //options
//STRIP001 				nBSpec+=3;
//STRIP001 				break;
//STRIP001 			case TLLINE:
//STRIP001 				*pS << sal_uInt8(tmBAR); //selector
//STRIP001 				*pS << sal_uInt8(0x00); //variation
//STRIP001 				*pS << sal_uInt8(0x00); //options
//STRIP001 				nBSpec+=3;
//STRIP001 				break;
//STRIP001 			case TLDLINE:
//STRIP001 				*pS << sal_uInt8(tmDBAR); //selector
//STRIP001 				*pS << sal_uInt8(0x00); //variation
//STRIP001 				*pS << sal_uInt8(0x00); //options
//STRIP001 				break;
//STRIP001 			default:
//STRIP001 				*pS << sal_uInt8(tmPAREN); //selector
//STRIP001 				*pS << sal_uInt8(0x00); //variation
//STRIP001 				*pS << sal_uInt8(0x00); //options
//STRIP001 				nBSpec+=3;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pTemp = pNode->GetSubNode(1))
//STRIP001 	{
//STRIP001 		*pS << sal_uInt8(LINE); //line
//STRIP001 		HandleNodes(pTemp,nLevel+1);
//STRIP001 		*pS << sal_uInt8(END); //options
//STRIP001 	}
//STRIP001 	nSpec=nBSpec;
//STRIP001 	if (pLeft)
//STRIP001 		HandleNodes(pLeft,nLevel+1);
//STRIP001 	if (bReInterpBrace)
//STRIP001 	{
//STRIP001 		ULONG nLoc2 = pS->Tell();
//STRIP001 		pS->Seek(nLoc);
//STRIP001 		*pS << sal_uInt8(0x2D);
//STRIP001 		pS->Seek(nLoc2);
//STRIP001 		*pS << sal_uInt8(CHAR);
//STRIP001 		*pS << sal_uInt8(0x96);
//STRIP001 		*pS << sal_uInt16(0xEC07);
//STRIP001 		bReInterpBrace=0;
//STRIP001 	}
//STRIP001 	if (pRight)
//STRIP001 		HandleNodes(pRight,nLevel+1);
//STRIP001 	nSpec=0x0;
//STRIP001 	*pS << sal_uInt8(END);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void MathType::HandleVerticalBrace(SmNode *pNode,int nLevel)
//STRIP001 {
//STRIP001 	SmNode *pTemp;
//STRIP001 	*pS << sal_uInt8(TMPL); //Template
//STRIP001 	if (pNode->GetToken().eType == TUNDERBRACE)
//STRIP001 		*pS << sal_uInt8(tmLHBRACE); //selector
//STRIP001 	else
//STRIP001 		*pS << sal_uInt8(tmUHBRACE); //selector
//STRIP001 	*pS << sal_uInt8(0x01); //variation
//STRIP001 	*pS << sal_uInt8(0x00); //options
//STRIP001 
//STRIP001 	if (pTemp = pNode->GetSubNode(0))
//STRIP001 	{
//STRIP001 		*pS << sal_uInt8(LINE); //line
//STRIP001 		HandleNodes(pTemp,nLevel+1);
//STRIP001 		*pS << sal_uInt8(END); //options
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pTemp = pNode->GetSubNode(2))
//STRIP001 	{
//STRIP001 		*pS << sal_uInt8(LINE); //line
//STRIP001 		HandleNodes(pTemp,nLevel+1);
//STRIP001 		*pS << sal_uInt8(END); //options
//STRIP001 	}
//STRIP001 	*pS << sal_uInt8(END);
//STRIP001 }
//STRIP001 
//STRIP001 void MathType::HandleOperator(SmNode *pNode,int nLevel)
//STRIP001 {
//STRIP001 	USHORT  nSize = pNode->GetNumSubNodes();
//STRIP001 
//STRIP001 	if (HandleLim(pNode,nLevel))
//STRIP001 		return;
//STRIP001 
//STRIP001 	ULONG nPos;
//STRIP001 	sal_uInt8 nVariation;
//STRIP001 
//STRIP001 	switch (pNode->GetToken().eType)
//STRIP001 	{
//STRIP001 		case TIINT:
//STRIP001 		case TIIINT:
//STRIP001 		case TLINT:
//STRIP001 		case TLLINT:
//STRIP001 		case TLLLINT:
//STRIP001 			nVariation=HandleCScript(pNode->GetSubNode(0),
//STRIP001 				pNode->GetSubNode(1),nLevel,&nPos,0);
//STRIP001 			break;
//STRIP001 		default:
//STRIP001 			nVariation=HandleCScript(pNode->GetSubNode(0),
//STRIP001 				pNode->GetSubNode(1),nLevel,&nPos);
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	sal_uInt8 nOldVariation=nVariation;
//STRIP001 	sal_uInt8 nIntVariation=nVariation;
//STRIP001 
//STRIP001 	ULONG nPos2=0;
//STRIP001 	if (nVariation != 0xff)
//STRIP001 	{
//STRIP001 		nPos2 = pS->Tell();
//STRIP001 		pS->Seek(nPos);
//STRIP001 		if (nVariation == 2)
//STRIP001 		{
//STRIP001 			nIntVariation=0;
//STRIP001 			nVariation = 1;
//STRIP001 		}
//STRIP001 		else if (nVariation == 0)
//STRIP001 			nVariation = 1;
//STRIP001 		else if (nVariation == 1)
//STRIP001 			nVariation = 0;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nVariation = 2;
//STRIP001 		nIntVariation=0;
//STRIP001 	}
//STRIP001 	*pS << sal_uInt8(TMPL);
//STRIP001 	switch(pNode->GetToken().eType)
//STRIP001 	{
//STRIP001 	case TINT:
//STRIP001 		if (nOldVariation != 0xff)
//STRIP001 			*pS << sal_uInt8(0x18); //selector
//STRIP001 		else
//STRIP001 			*pS << sal_uInt8(0x15); //selector
//STRIP001 		*pS << nIntVariation; //variation
//STRIP001 		break;
//STRIP001 	case TIINT:
//STRIP001 		if (nOldVariation != 0xff)
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(0x19);
//STRIP001 			*pS << sal_uInt8(0x01);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(0x16);
//STRIP001 			*pS << sal_uInt8(0x00);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	case TIIINT:
//STRIP001 		if (nOldVariation != 0xff)
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(0x1a);
//STRIP001 			*pS << sal_uInt8(0x01);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(0x17);
//STRIP001 			*pS << sal_uInt8(0x00);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	case TLINT:
//STRIP001 		if (nOldVariation != 0xff)
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(0x18);
//STRIP001 			*pS << sal_uInt8(0x02);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(0x15);
//STRIP001 			*pS << sal_uInt8(0x03);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	case TLLINT:
//STRIP001 		if (nOldVariation != 0xff)
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(0x19);
//STRIP001 			*pS << sal_uInt8(0x00);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(0x16);
//STRIP001 			*pS << sal_uInt8(0x02);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	case TLLLINT:
//STRIP001 		if (nOldVariation != 0xff)
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(0x1a);
//STRIP001 			*pS << sal_uInt8(0x00);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(0x17);
//STRIP001 			*pS << sal_uInt8(0x02);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	case TSUM:
//STRIP001 	default:
//STRIP001 		*pS << sal_uInt8(0x1d);
//STRIP001 		*pS << nVariation;
//STRIP001 		break;
//STRIP001 	case TPROD:
//STRIP001 		*pS << sal_uInt8(0x1f);
//STRIP001 		*pS << nVariation;
//STRIP001 		break;
//STRIP001 	case TCOPROD:
//STRIP001 		*pS << sal_uInt8(0x21);
//STRIP001 		*pS << nVariation;
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	*pS << sal_uInt8(0x00); //options
//STRIP001 
//STRIP001 	if (nPos2)
//STRIP001 		pS->Seek(nPos2);
//STRIP001 	else
//STRIP001 	{
//STRIP001 		*pS << sal_uInt8(LINE); //line
//STRIP001 		HandleNodes(pNode->GetSubNode(1),nLevel+1);
//STRIP001 		*pS << sal_uInt8(END); //line
//STRIP001 		*pS << sal_uInt8(LINE|0x10);
//STRIP001 		*pS << sal_uInt8(LINE|0x10);
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	*pS << sal_uInt8(0x0D);
//STRIP001 	switch(pNode->GetToken().eType)
//STRIP001 	{
//STRIP001 	case TSUM:
//STRIP001 	default:
//STRIP001 		*pS << sal_uInt8(CHAR);
//STRIP001 		*pS << sal_uInt8(0x86);
//STRIP001 		*pS << sal_uInt16(0x2211);
//STRIP001 		break;
//STRIP001 	case TPROD:
//STRIP001 		*pS << sal_uInt8(CHAR);
//STRIP001 		*pS << sal_uInt8(0x86);
//STRIP001 		*pS << sal_uInt16(0x220F);
//STRIP001 		break;
//STRIP001 	case TCOPROD:
//STRIP001 		*pS << sal_uInt8(CHAR);
//STRIP001 		*pS << sal_uInt8(0x8B);
//STRIP001 		*pS << sal_uInt16(0x2210);
//STRIP001 		break;
//STRIP001 	case TIIINT:
//STRIP001 	case TLLLINT:
//STRIP001 		*pS << sal_uInt8(CHAR);
//STRIP001 		*pS << sal_uInt8(0x86);
//STRIP001 		*pS << sal_uInt16(0x222B);
//STRIP001 	case TIINT:
//STRIP001 	case TLLINT:
//STRIP001 		*pS << sal_uInt8(CHAR);
//STRIP001 		*pS << sal_uInt8(0x86);
//STRIP001 		*pS << sal_uInt16(0x222B);
//STRIP001 	case TINT:
//STRIP001 	case TLINT:
//STRIP001 		*pS << sal_uInt8(CHAR);
//STRIP001 		*pS << sal_uInt8(0x86);
//STRIP001 		*pS << sal_uInt16(0x222B);
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	*pS << sal_uInt8(END);
//STRIP001 	*pS << sal_uInt8(0x0A);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 int MathType::HandlePile(int &rSetAlign,int nLevel,sal_uInt8 nSelector,
//STRIP001 	sal_uInt8 nVariation)
//STRIP001 {
//STRIP001 	//if (xfLMOVE(nTag))
//STRIP001 	*pS >> nHAlign;
//STRIP001 	*pS >> nVAlign;
//STRIP001 
//STRIP001 	HandleAlign(nHAlign,nVAlign,rSetAlign);
//STRIP001 
//STRIP001 	APPEND(rRet," stack {\n");
//STRIP001 	int nRet = HandleRecords(nLevel+1,nSelector,nVariation,-1,-1);
//STRIP001 	rRet.Erase(rRet.Len()-3,2);
//STRIP001 	APPEND(rRet,"} ");
//STRIP001 
//STRIP001 	while (rSetAlign)
//STRIP001 	{
//STRIP001 		APPEND(rRet,"} ");
//STRIP001 		rSetAlign--;
//STRIP001 	}
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 int MathType::HandleMatrix(int nLevel,sal_uInt8 nSelector,
//STRIP001 	sal_uInt8 nVariation)
//STRIP001 {
//STRIP001 	sal_uInt8 nH_just,nV_just,nRows,nCols;
//STRIP001 	//if (xfLMOVE(nTag))
//STRIP001 	*pS >> nVAlign;
//STRIP001 	*pS >> nH_just;
//STRIP001 	*pS >> nV_just;
//STRIP001 	*pS >> nRows;
//STRIP001 	*pS >> nCols;
//STRIP001 	int nBytes = ((nRows+1)*2)/8;
//STRIP001 	if (((nRows+1)*2)%8)
//STRIP001 		nBytes++;
//STRIP001 	pS->SeekRel(nBytes);
//STRIP001 	nBytes = ((nCols+1)*2)/8;
//STRIP001 	if (((nCols+1)*2)%8)
//STRIP001 		nBytes++;
//STRIP001 	pS->SeekRel(nBytes);
//STRIP001 	APPEND(rRet," matrix {\n");
//STRIP001 	int nRet = HandleRecords(nLevel+1,nSelector,nVariation,nRows,nCols);
//STRIP001 
//STRIP001     xub_StrLen nI = rRet.SearchBackward('#');
//STRIP001     if ((nI != STRING_NOTFOUND) && (nI > 0))
//STRIP001         if (rRet.GetChar(nI-1) != '#')  //missing column
//STRIP001             APPEND(rRet,"{}");
//STRIP001 
//STRIP001 	APPEND(rRet,"\n} ");
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 int MathType::HandleTemplate(int nLevel,sal_uInt8 &rSelector,
//STRIP001 	sal_uInt8 &rVariation, xub_StrLen &rLastTemplateBracket)
//STRIP001 {
//STRIP001 	sal_uInt8 nOption; //This appears utterly unused
//STRIP001 	//if (xfLMOVE(nTag))
//STRIP001 	*pS >> rSelector;
//STRIP001 	*pS >> rVariation;
//STRIP001 	*pS >> nOption;
//STRIP001 	DBG_ASSERT(rSelector < 48,"Selector out of range")
//STRIP001 	if ((rSelector >= 21) && (rSelector <=26))
//STRIP001 	{
//STRIP001 		DBG_ASSERT(nOption < 2,"Option out of range");
//STRIP001 	}
//STRIP001 	else if ((rSelector >= 0) && (rSelector <=12))
//STRIP001 	{
//STRIP001 		DBG_ASSERT(nOption < 3,"Option out of range");
//STRIP001 	}
//STRIP001 
//STRIP001     //For the (broken) case where one subscript template ends, and there is
//STRIP001     //another one after it, mathtype handles it as if the second one was
//STRIP001     //inside the first one and renders it as sub of sub
//STRIP001     BOOL bRemove=FALSE;
//STRIP001     if ( (rSelector == 0xf) && (rLastTemplateBracket != STRING_NOTFOUND) )
//STRIP001     {
//STRIP001         bRemove=TRUE;
//STRIP001         for (xub_StrLen nI = rLastTemplateBracket+1; nI < rRet.Len(); nI++ )
//STRIP001             if (rRet.GetChar(nI) != ' ')
//STRIP001             {
//STRIP001                 bRemove=FALSE;
//STRIP001                 break;
//STRIP001             }
//STRIP001     }
//STRIP001 
//STRIP001 	//suborderlist
//STRIP001     int nRet = HandleRecords(nLevel+1,rSelector,rVariation);
//STRIP001 
//STRIP001     if (bRemove)
//STRIP001     {
//STRIP001         rRet.Erase(rLastTemplateBracket,1);
//STRIP001         APPEND(rRet,"} ");
//STRIP001         rLastTemplateBracket = STRING_NOTFOUND;
//STRIP001     }
//STRIP001     if (rSelector == 0xf)
//STRIP001         rLastTemplateBracket = rRet.SearchBackward('}');
//STRIP001     else
//STRIP001         rLastTemplateBracket = STRING_NOTFOUND;
//STRIP001 
//STRIP001 	rSelector = -1;
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 void MathType::HandleEmblishments()
//STRIP001 {
//STRIP001 	sal_uInt8 nEmbel;
//STRIP001 	//if (xfLMOVE(nTag))
//STRIP001 	do
//STRIP001 	{
//STRIP001 		*pS >> nEmbel;
//STRIP001 		switch (nEmbel)
//STRIP001 		{
//STRIP001 		case 0x02:
//STRIP001 			APPEND(rRet," dot ");
//STRIP001 			break;
//STRIP001 		case 0x03:
//STRIP001 			APPEND(rRet," ddot ");
//STRIP001 			break;
//STRIP001 		case 0x04:
//STRIP001 			APPEND(rRet," dddot ");
//STRIP001 			break;
//STRIP001 		case 0x05:
//STRIP001 			if (nPostSup == 0)
//STRIP001 			{
//STRIP001 				APPEND(sPost," sup {}");
//STRIP001 				nPostSup = sPost.Len();
//STRIP001 			}
//STRIP001 			sPost.InsertAscii(" ' ",nPostSup-1);
//STRIP001 			nPostSup += 3;
//STRIP001 			break;
//STRIP001 		case 0x06:
//STRIP001 			if (nPostSup == 0)
//STRIP001 			{
//STRIP001 				APPEND(sPost," sup {}");
//STRIP001 				nPostSup = sPost.Len();
//STRIP001 			}
//STRIP001 			sPost.InsertAscii(" '' ",nPostSup-1);
//STRIP001 			nPostSup += 4;
//STRIP001 			break;
//STRIP001 		case 0x07:
//STRIP001 			if (nPostlSup == 0)
//STRIP001 			{
//STRIP001 				APPEND(sPost," lsup {}");
//STRIP001 				nPostlSup = sPost.Len();
//STRIP001 			}
//STRIP001 			sPost.InsertAscii(" ' ",nPostlSup-1);
//STRIP001 			nPostlSup += 3;
//STRIP001 			break;
//STRIP001 		case 0x08:
//STRIP001 			APPEND(rRet," tilde ");
//STRIP001 			break;
//STRIP001 		case 0x09:
//STRIP001 			APPEND(rRet," hat ");
//STRIP001 			break;
//STRIP001 		case 0x0b:
//STRIP001 			APPEND(rRet," vec ");
//STRIP001 			break;
//STRIP001 		case 0x10:
//STRIP001 			APPEND(rRet," overstrike ");
//STRIP001 			break;
//STRIP001 		case 0x11:
//STRIP001 			APPEND(rRet," bar ");
//STRIP001 			break;
//STRIP001 		case 0x12:
//STRIP001 			if (nPostSup == 0)
//STRIP001 			{
//STRIP001 				APPEND(sPost," sup {}");
//STRIP001 				nPostSup = sPost.Len();
//STRIP001 			}
//STRIP001 			sPost.InsertAscii(" ''' ",nPostSup-1);
//STRIP001 			nPostSup += 5;
//STRIP001 			break;
//STRIP001 		case 0x14:
//STRIP001 			APPEND(rRet," breve ");
//STRIP001 			break;
//STRIP001 		default:
//STRIP001 			DBG_ASSERT(nEmbel < 21,"Embel out of range")
//STRIP001 			break;
//STRIP001 		}
//STRIP001         if (nVersion < 3)
//STRIP001             break;
//STRIP001 	}while (nEmbel);
//STRIP001 }
//STRIP001 
//STRIP001 void MathType::HandleSetSize()
//STRIP001 {
//STRIP001 	sal_uInt8 nTemp;
//STRIP001 	*pS >> nTemp;
//STRIP001 	switch (nTemp)
//STRIP001 	{
//STRIP001 		case 101:
//STRIP001 			*pS >> nLSize;
//STRIP001 			nLSize = -nLSize;
//STRIP001 			break;
//STRIP001 		case 100:
//STRIP001 			*pS >> nTemp;
//STRIP001 			nLSize = nTemp;
//STRIP001 			*pS >> nDSize;
//STRIP001 			break;
//STRIP001 		default:
//STRIP001 			nLSize = nTemp;
//STRIP001 			*pS >> nTemp;
//STRIP001 			nDSize = nTemp-128;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 int MathType::HandleChar(xub_StrLen &rTextStart,int &rSetSize,int nLevel,
//STRIP001 	sal_uInt8 nTag,sal_uInt8 nSelector,sal_uInt8 nVariation, sal_Bool bSilent)
//STRIP001 {
//STRIP001 	sal_Unicode nChar;
//STRIP001 	int nRet=1;
//STRIP001 
//STRIP001 	if (xfAUTO(nTag))
//STRIP001 	{
//STRIP001 	//This is a candidate for function recognition, whatever
//STRIP001 	//that is!
//STRIP001 	}
//STRIP001 	//if (xfLMODE(nTag))
//STRIP001 
//STRIP001 	sal_uInt8 nOldTypeFace = nTypeFace;
//STRIP001 	*pS >> nTypeFace;
//STRIP001 	if (nVersion < 3)
//STRIP001 	{
//STRIP001 		sal_uInt8 nChar8;
//STRIP001 		*pS >> nChar8;
//STRIP001 		nChar = nChar8;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		*pS >> nChar;
//STRIP001 
//STRIP001     /*
//STRIP001     ##912##
//STRIP001     bad character, old mathtype < 3 has these
//STRIP001     */
//STRIP001     if (nChar < 0x20)
//STRIP001         return nRet;
//STRIP001 
//STRIP001 	if (xfEMBELL(nTag))
//STRIP001 	{
//STRIP001 		//A bit tricky, the character emblishments for
//STRIP001 		//mathtype can all be listed after eachother, in
//STRIP001 		//starmath some must go before the character and some
//STRIP001 		//must go after. In addition some of the emblishments
//STRIP001 		//may repeated and in starmath some of these groups
//STRIP001 		//must be gathered together. sPost is the portion that
//STRIP001 		//follows the char and nPostSup and nPostlSup are the
//STRIP001 		//indexes at which this class of emblishment is
//STRIP001 		//collated together
//STRIP001 		sPost.Erase();
//STRIP001 		nPostSup = nPostlSup = 0;
//STRIP001 		int nOriglen=rRet.Len()-rTextStart;
//STRIP001 		if ((!bSilent) && ((nOriglen) > 1))
//STRIP001 			rRet += '\"';
//STRIP001 		nRet = HandleRecords(nLevel+1,nSelector,nVariation);
//STRIP001 		if (!bSilent)
//STRIP001 		{
//STRIP001 			if (nOriglen > 1)
//STRIP001 			{
//STRIP001 				String aStr;
//STRIP001 				TypeFaceToString(aStr,nOldTypeFace);
//STRIP001 				aStr += '\"';
//STRIP001 				rRet.Insert(aStr,rTextStart);
//STRIP001 
//STRIP001 				aStr.Erase();
//STRIP001 				TypeFaceToString(aStr,nTypeFace);
//STRIP001 				rRet.Append(aStr);
//STRIP001 				rRet += '{';
//STRIP001 			}
//STRIP001 			else
//STRIP001 				APPEND(rRet," {");
//STRIP001             rTextStart = rRet.Len();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!bSilent)
//STRIP001 	{
//STRIP001 		int nOldLen = rRet.Len();
//STRIP001 		//nLastSize = nCurSize;
//STRIP001 		if (
//STRIP001 			HandleSize(nLSize,nDSize,rSetSize) ||
//STRIP001 			(nOldTypeFace != nTypeFace)
//STRIP001 		   )
//STRIP001 		{
//STRIP001 			if ((nOldLen - rTextStart) > 1)
//STRIP001 			{
//STRIP001 				rRet.InsertAscii("\"",nOldLen);
//STRIP001 				String aStr;
//STRIP001 				TypeFaceToString(aStr,nOldTypeFace);
//STRIP001 				aStr += '\"';
//STRIP001 				rRet.Insert(aStr,rTextStart);
//STRIP001 			}
//STRIP001 			rTextStart = rRet.Len();
//STRIP001 		}
//STRIP001 		nOldLen = rRet.Len();
//STRIP001 		if (!LookupChar(nChar,rRet,nVersion,nTypeFace))
//STRIP001 		{
//STRIP001 			if (nOldLen - rTextStart > 1)
//STRIP001 			{
//STRIP001 				rRet.InsertAscii("\"",nOldLen);
//STRIP001 				String aStr;
//STRIP001 				TypeFaceToString(aStr,nOldTypeFace);
//STRIP001 				aStr += '\"';
//STRIP001 				rRet.Insert(aStr,rTextStart);
//STRIP001 			}
//STRIP001 			rTextStart = rRet.Len();
//STRIP001 		}
//STRIP001         lcl_PrependDummyTerm(rRet, rTextStart);
//STRIP001 	}
//STRIP001 
//STRIP001 	if ((xfEMBELL(nTag)) && (!bSilent))
//STRIP001 	{
//STRIP001 		rRet += '}';
//STRIP001 		rRet += sPost;
//STRIP001 		rTextStart = rRet.Len();
//STRIP001 	}
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool MathType::HandleLim(SmNode *pNode,int nLevel)
//STRIP001 {
//STRIP001 	sal_Bool bRet=0;
//STRIP001 	//Special case for the "lim" option in StarMath
//STRIP001 	if ((pNode->GetToken().eType == TLIM)
//STRIP001 		|| (pNode->GetToken().eType == TLIMSUP)
//STRIP001 		|| (pNode->GetToken().eType == TLIMINF)
//STRIP001 		)
//STRIP001 	{
//STRIP001 		if (pNode->GetSubNode(1))
//STRIP001 		{
//STRIP001 			sal_uInt8 nVariation2=HandleCScript(pNode->GetSubNode(0),NULL,
//STRIP001 				nLevel);
//STRIP001 
//STRIP001 			*pS << sal_uInt8(0x0A);
//STRIP001 			*pS << sal_uInt8(LINE); //line
//STRIP001 			*pS << sal_uInt8(CHAR|0x10);
//STRIP001 			*pS << sal_uInt8(0x82);
//STRIP001 			*pS << sal_uInt16('l');
//STRIP001 			*pS << sal_uInt8(CHAR|0x10);
//STRIP001 			*pS << sal_uInt8(0x82);
//STRIP001 			*pS << sal_uInt16('i');
//STRIP001 			*pS << sal_uInt8(CHAR|0x10);
//STRIP001 			*pS << sal_uInt8(0x82);
//STRIP001 			*pS << sal_uInt16('m');
//STRIP001 
//STRIP001 			if (pNode->GetToken().eType == TLIMSUP)
//STRIP001 			{
//STRIP001 				*pS << sal_uInt8(CHAR); //some space
//STRIP001 				*pS << sal_uInt8(0x98);
//STRIP001 				*pS << sal_uInt16(0xEB04);
//STRIP001 
//STRIP001 				*pS << sal_uInt8(CHAR|0x10);
//STRIP001 				*pS << sal_uInt8(0x82);
//STRIP001 				*pS << sal_uInt16('s');
//STRIP001 				*pS << sal_uInt8(CHAR|0x10);
//STRIP001 				*pS << sal_uInt8(0x82);
//STRIP001 				*pS << sal_uInt16('u');
//STRIP001 				*pS << sal_uInt8(CHAR|0x10);
//STRIP001 				*pS << sal_uInt8(0x82);
//STRIP001 				*pS << sal_uInt16('p');
//STRIP001 			}
//STRIP001 			else if (pNode->GetToken().eType == TLIMINF)
//STRIP001 			{
//STRIP001 				*pS << sal_uInt8(CHAR); //some space
//STRIP001 				*pS << sal_uInt8(0x98);
//STRIP001 				*pS << sal_uInt16(0xEB04);
//STRIP001 
//STRIP001 				*pS << sal_uInt8(CHAR|0x10);
//STRIP001 				*pS << sal_uInt8(0x82);
//STRIP001 				*pS << sal_uInt16('i');
//STRIP001 				*pS << sal_uInt8(CHAR|0x10);
//STRIP001 				*pS << sal_uInt8(0x82);
//STRIP001 				*pS << sal_uInt16('n');
//STRIP001 				*pS << sal_uInt8(CHAR|0x10);
//STRIP001 				*pS << sal_uInt8(0x82);
//STRIP001 				*pS << sal_uInt16('f');
//STRIP001 			}
//STRIP001 
//STRIP001 
//STRIP001 			*pS << sal_uInt8(CHAR); //some space
//STRIP001 			*pS << sal_uInt8(0x98);
//STRIP001 			*pS << sal_uInt16(0xEB04);
//STRIP001 
//STRIP001 			if (nVariation2 != 0xff)
//STRIP001 			{
//STRIP001 				*pS << sal_uInt8(END);
//STRIP001 				*pS << sal_uInt8(END);
//STRIP001 			}
//STRIP001 			HandleNodes(pNode->GetSubNode(1),nLevel+1);
//STRIP001 			//*pS << sal_uInt8(END); //options
//STRIP001 			bRet = 1;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 void MathType::HandleMAlign(SmNode *pNode,int nLevel)
//STRIP001 {
//STRIP001 	sal_uInt8 nPushedHAlign=nHAlign;
//STRIP001 	switch(pNode->GetToken().eType)
//STRIP001 	{
//STRIP001 		case TALIGNC:
//STRIP001 			nHAlign=2;
//STRIP001 			break;
//STRIP001 		case TALIGNR:
//STRIP001 			nHAlign=3;
//STRIP001 			break;
//STRIP001 		default:
//STRIP001 			nHAlign=1;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	USHORT  nSize = pNode->GetNumSubNodes();
//STRIP001 	for (USHORT i = 0; i < nSize; i++)
//STRIP001 		if (SmNode *pTemp = pNode->GetSubNode(i))
//STRIP001 			HandleNodes(pTemp,nLevel+1);
//STRIP001 	nHAlign=nPushedHAlign;
//STRIP001 }
//STRIP001 
//STRIP001 void MathType::HandleMath(SmNode *pNode,int nLevel)
//STRIP001 {
//STRIP001 	if (pNode->GetToken().eType == TMLINE)
//STRIP001 	{
//STRIP001 		*pS << sal_uInt8(END);
//STRIP001 		*pS << sal_uInt8(LINE);
//STRIP001 		bReInterpBrace=1;
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	SmMathSymbolNode *pTemp=(SmMathSymbolNode *)pNode;
//STRIP001 	for(int i=0;i<pTemp->GetText().Len();i++)
//STRIP001 	{
//STRIP001 		sal_Unicode nArse = Convert(pTemp->GetText().GetChar(i));
//STRIP001         if ((nArse == 0x2224) || (nArse == 0x2288) || (nArse == 0x2285) || 
//STRIP001 			(nArse == 0x2289))
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(CHAR|0x20);
//STRIP001 		}
//STRIP001         else if ((nPendingAttributes) &&
//STRIP001                 (i == ((pTemp->GetText().Len()+1)/2)-1))
//STRIP001             {
//STRIP001                 *pS << sal_uInt8(0x22);
//STRIP001             }
//STRIP001 		else
//STRIP001 			*pS << sal_uInt8(CHAR); //char without formula recognition
//STRIP001 		//The typeface seems to be MTEXTRA for unicode characters,
//STRIP001 		//though how to determine when mathtype chooses one over
//STRIP001 		//the other is unknown. This should do the trick
//STRIP001 		//nevertheless.
//STRIP001 		sal_uInt8 nBias;
//STRIP001 		if ( (nArse == 0x2213) || (nArse == 0x2218) ||
//STRIP001 			(nArse == 0x210F) || (
//STRIP001 				(nArse >= 0x22EE) && (nArse <= 0x22FF)
//STRIP001 			))
//STRIP001 		{
//STRIP001 			nBias = 0xB; //typeface
//STRIP001 		}
//STRIP001 		else if ((nArse > 0x2000) || (nArse == 0x00D7))
//STRIP001 			nBias = 0x6; //typeface
//STRIP001 		else if (nArse == 0x3d1)
//STRIP001 			nBias = 0x4;
//STRIP001 		else if ((nArse > 0xFF) && ((nArse < 0x393) || (nArse > 0x3c9)))
//STRIP001 			nBias = 0xB; //typeface
//STRIP001 		else if ((nArse == 0x2F) || (nArse == 0x2225))
//STRIP001 			nBias = 0x2; //typeface
//STRIP001 		else
//STRIP001 			nBias = 0x3; //typeface
//STRIP001 
//STRIP001 		*pS << sal_uInt8(nSpec+nBias+128); //typeface
//STRIP001 
//STRIP001 		if (nArse == 0x2224)
//STRIP001 		{
//STRIP001 			*pS << sal_uInt16(0x7C);
//STRIP001 			*pS << sal_uInt8(EMBEL);
//STRIP001 			*pS << sal_uInt8(0x0A);
//STRIP001 			*pS << sal_uInt8(END); //end embel
//STRIP001 			*pS << sal_uInt8(END); //end embel
//STRIP001 		}
//STRIP001 		else if (nArse == 0x2225)
//STRIP001 			*pS << sal_uInt16(0xEC09);
//STRIP001 		else if	(nArse == 0xE421)
//STRIP001 			*pS << sal_uInt16(0x2265);
//STRIP001 		else if (nArse == 0xE425)
//STRIP001 			*pS << sal_uInt16(0x2264);
//STRIP001 		else if (nArse == 0x226A)
//STRIP001 		{
//STRIP001 			*pS << sal_uInt16(0x3C);
//STRIP001 			*pS << sal_uInt8(CHAR);
//STRIP001 			*pS << sal_uInt8(0x98);
//STRIP001 			*pS << sal_uInt16(0xEB01);
//STRIP001 			*pS << sal_uInt8(CHAR);
//STRIP001 			*pS << sal_uInt8(0x86);
//STRIP001 			*pS << sal_uInt16(0x3c);
//STRIP001 		}
//STRIP001 		else if (nArse == 0x2288)
//STRIP001 		{
//STRIP001 			*pS << sal_uInt16(0x2286);
//STRIP001 			*pS << sal_uInt8(EMBEL);
//STRIP001 			*pS << sal_uInt8(0x0A);
//STRIP001 			*pS << sal_uInt8(END); //end embel
//STRIP001 			*pS << sal_uInt8(END); //end embel
//STRIP001 		}
//STRIP001 		else if (nArse == 0x2289)
//STRIP001 		{
//STRIP001 			*pS << sal_uInt16(0x2287);
//STRIP001 			*pS << sal_uInt8(EMBEL);
//STRIP001 			*pS << sal_uInt8(0x0A);
//STRIP001 			*pS << sal_uInt8(END); //end embel
//STRIP001 			*pS << sal_uInt8(END); //end embel
//STRIP001 		}
//STRIP001 		else if (nArse == 0x2285)
//STRIP001 		{
//STRIP001 			*pS << sal_uInt16(0x2283);
//STRIP001 			*pS << sal_uInt8(EMBEL);
//STRIP001 			*pS << sal_uInt8(0x0A);
//STRIP001 			*pS << sal_uInt8(END); //end embel
//STRIP001 			*pS << sal_uInt8(END); //end embel
//STRIP001 		}
//STRIP001 		else
//STRIP001 			*pS << nArse;
//STRIP001 	}
//STRIP001     nPendingAttributes = 0;
//STRIP001 }
//STRIP001 
//STRIP001 void MathType::HandleAttributes(SmNode *pNode,int nLevel)
//STRIP001 {
//STRIP001 	int nOldPending;
//STRIP001 	USHORT  nSize = pNode->GetNumSubNodes();
//STRIP001 	SmNode *pTemp;
//STRIP001 	SmTextNode *pIsText;
//STRIP001 
//STRIP001 	//SmTextNode *pTemp=(SmTextNode *)pNode;
//STRIP001 	//for(int i=0;i<pTemp->GetText().Len();i++)
//STRIP001 
//STRIP001 	if (pTemp = pNode->GetSubNode(0))
//STRIP001 	{
//STRIP001 		pIsText = (SmTextNode *)pNode->GetSubNode(1);
//STRIP001 
//STRIP001 		switch (pTemp->GetToken().eType)
//STRIP001 		{
//STRIP001 		case TWIDEVEC:
//STRIP001 			//theres just no way we can now handle any character
//STRIP001 			//attributes (from mathtypes perspective) centered
//STRIP001 			//over an expression but above template attributes
//STRIP001 			//such as widevec and similiar constructs
//STRIP001 			//we have to drop them
//STRIP001 			nOldPending = StartTemplate(0x2f,0x01);
//STRIP001 			break;
//STRIP001 		case TCHECK: //Not Exportable
//STRIP001 		case TACUTE: //Not Exportable
//STRIP001 		case TGRAVE: //Not Exportable
//STRIP001 		case TCIRCLE: //Not Exportable
//STRIP001 		case TWIDETILDE: //Not Exportable
//STRIP001 		case TWIDEHAT: //Not Exportable
//STRIP001 			break;
//STRIP001 		case TUNDERLINE:
//STRIP001 			nOldPending = StartTemplate(0x10);
//STRIP001 			break;
//STRIP001 		case TOVERLINE:	//If the next node is not text
//STRIP001 						//or text with more than one char
//STRIP001 			if ((pIsText->GetToken().eType != NTEXT) ||
//STRIP001 				(pIsText->GetText().Len() > 1))
//STRIP001 				nOldPending = StartTemplate(0x11);
//STRIP001 			break;
//STRIP001 		default:
//STRIP001 			nPendingAttributes++;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pIsText)
//STRIP001 		HandleNodes(pIsText,nLevel+1);
//STRIP001 
//STRIP001 	switch (pTemp->GetToken().eType)
//STRIP001 	{
//STRIP001 		case TWIDEVEC:
//STRIP001 		case TUNDERLINE:
//STRIP001 			EndTemplate(nOldPending);
//STRIP001 			break;
//STRIP001 		case TOVERLINE:
//STRIP001 			if ((pIsText->GetToken().eType != NTEXT) ||
//STRIP001 				(pIsText->GetText().Len() > 1))
//STRIP001 				EndTemplate(nOldPending);
//STRIP001 			break;
//STRIP001 		default:
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	//if there was no suitable place to put the attribute,
//STRIP001 	//then we have to just give up on it
//STRIP001 	if (nPendingAttributes)
//STRIP001 		nPendingAttributes--;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ((nInsertion != 0) && (pTemp = pNode->GetSubNode(0)))
//STRIP001 		{
//STRIP001 			ULONG nPos = pS->Tell();
//STRIP001 			nInsertion--;
//STRIP001 			pS->Seek(nInsertion);
//STRIP001 			switch(pTemp->GetToken().eType)
//STRIP001 			{
//STRIP001 			case TACUTE: //Not Exportable
//STRIP001 			case TGRAVE: //Not Exportable
//STRIP001 			case TCIRCLE: //Not Exportable
//STRIP001 				break;
//STRIP001 			case TCDOT:
//STRIP001 				*pS << sal_uInt8(2);
//STRIP001 				break;
//STRIP001 			case TDDOT:
//STRIP001 				*pS << sal_uInt8(3);
//STRIP001 				break;
//STRIP001 			case TDDDOT:
//STRIP001 				*pS << sal_uInt8(4);
//STRIP001 				break;
//STRIP001 			case TTILDE:
//STRIP001 				*pS << sal_uInt8(8);
//STRIP001 				break;
//STRIP001 			case THAT:
//STRIP001 				*pS << sal_uInt8(9);
//STRIP001 				break;
//STRIP001 			case TVEC:
//STRIP001 				*pS << sal_uInt8(11);
//STRIP001 				break;
//STRIP001 			case TOVERSTRIKE:
//STRIP001 				*pS << sal_uInt8(16);
//STRIP001 				break;
//STRIP001 			case TOVERLINE:
//STRIP001 				if ((pIsText->GetToken().eType == NTEXT) &&
//STRIP001 					(pIsText->GetText().Len() == 1))
//STRIP001 					*pS << sal_uInt8(17);
//STRIP001 				break;
//STRIP001 			case TBREVE:
//STRIP001 				*pS << sal_uInt8(20);
//STRIP001 				break;
//STRIP001 			case TWIDEVEC:
//STRIP001 			case TUNDERLINE:
//STRIP001 			case TWIDETILDE:
//STRIP001 			case TWIDEHAT:
//STRIP001 				break;
//STRIP001 			case TBAR:
//STRIP001 				*pS << sal_uInt8(17);
//STRIP001 				break;
//STRIP001 			default:
//STRIP001 				*pS << sal_uInt8(0x2);
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		pS->Seek(nPos);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void MathType::HandleText(SmNode *pNode,int nLevel)
//STRIP001 {
//STRIP001 	SmTextNode *pTemp=(SmTextNode *)pNode;
//STRIP001 	for(int i=0;i<pTemp->GetText().Len();i++)
//STRIP001 	{
//STRIP001 		if ((nPendingAttributes) &&
//STRIP001 			(i == ((pTemp->GetText().Len()+1)/2)-1))
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(0x22); 	//char, with attributes right
//STRIP001 								//after the character
//STRIP001 		}
//STRIP001 		else
//STRIP001             *pS << sal_uInt8(CHAR);
//STRIP001 			//*pS << sal_uInt8(CHAR|0x10); //char with formula recognition
//STRIP001 
//STRIP001 #if 1
//STRIP001 		sal_uInt8 nFace = 0x1;
//STRIP001 		if (pNode->GetFont().GetItalic() == ITALIC_NORMAL)
//STRIP001 			nFace = 0x3;
//STRIP001 		else if (pNode->GetFont().GetWeight() == WEIGHT_BOLD)
//STRIP001 			nFace = 0x7;
//STRIP001 		*pS << sal_uInt8(nFace+128); //typeface
//STRIP001 #else
//STRIP001 		if ((pTemp->GetText().GetChar(i) >= '0') &&
//STRIP001 			(pTemp->GetText().GetChar(i) <= '9'))
//STRIP001 			*pS << sal_uInt8(0x8+128); //typeface
//STRIP001 		else
//STRIP001 			*pS << sal_uInt8(0x3+128); //typeface
//STRIP001 #endif
//STRIP001         sal_uInt16 nChar = pTemp->GetText().GetChar(i);
//STRIP001 		*pS << Convert(nChar);
//STRIP001 
//STRIP001 		//Mathtype can only have these sort of character
//STRIP001 		//attributes on a single character, starmath can put them
//STRIP001 		//anywhere, when the entity involved is a text run this is
//STRIP001 		//a large effort to place the character attribute on the
//STRIP001 		//central mathtype character so that it does pretty much
//STRIP001 		//what the user probably has in mind. The attributes
//STRIP001 		//filled in here are dummy ones which are replaced in the
//STRIP001 		//ATTRIBUT handler if a suitable location for the
//STRIP001 		//attributes was found here. Unfortunately it is
//STRIP001 		//possible for starmath to place character attributes on
//STRIP001 		//entities which cannot occur in mathtype e.g. a Summation
//STRIP001 		//symbol so these attributes may be lost
//STRIP001 		if ((nPendingAttributes) &&
//STRIP001 			(i == ((pTemp->GetText().Len()+1)/2)-1))
//STRIP001 		{
//STRIP001 			*pS << sal_uInt8(EMBEL);
//STRIP001 			while (nPendingAttributes)
//STRIP001 			{
//STRIP001 				*pS << sal_uInt8(2);
//STRIP001 				//wedge the attributes in here and clear
//STRIP001 				//the pending stack
//STRIP001 				nPendingAttributes--;
//STRIP001 			}
//STRIP001 			nInsertion=pS->Tell();
//STRIP001 			*pS << sal_uInt8(END); //end embel
//STRIP001 			*pS << sal_uInt8(END); //end embel
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/* vi:set tabstop=4 shiftwidth=4 expandtab: */
}
