/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_stbmgr.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:44:24 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
// auto strip #include <vcl/wrkwin.hxx>

#pragma hdrstop

// auto strip #include "stbmgr.hxx"
// auto strip #include "minarray.hxx"
#include "stbitem.hxx"
// auto strip #include "bindings.hxx"
#include "msgpool.hxx"
// auto strip #include "sfxtypes.hxx"
// auto strip #include "sfxresid.hxx"
// auto strip #include "app.hxx"
#include "objsh.hxx"
#include "progress.hxx"
#include "workwin.hxx"
#include "objface.hxx"
#include "sfx.hrc"
#include "statbar.hrc"
#include "helpid.hrc"
#include "dispatch.hxx"
namespace binfilter {

using namespace ::framework;

static const USHORT nVersion = 5;

struct SfxStatusItemInf_Impl
{
	USHORT				nId;
	StatusBarItemBits	aBits;
	long				nWidth;
	long				nOffset;

	SfxStatusItemInf_Impl (USHORT n, long nW, StatusBarItemBits aSBits, long nOffs) :
		nId(n),
		aBits(aSBits),
		nWidth(nW),
		nOffset(nOffs)
	{}
};

//====================================================================

DECL_PTRARRAY(SfxStatusItemArr_Impl, SfxStatusBarControl*, 2, 2 )//STRIP008 ;
DECL_PTRARRAY(SfxStatusItemInfArr_Impl, SfxStatusItemInf_Impl*, 4, 4 )//STRIP008 ;

SfxStatusItemInf_Impl* FindItem(SfxStatusItemInfArr_Impl, USHORT);

//==================================================================

//STRIP001 SfxStatusItemInf_Impl* FindItem(SfxStatusItemInfArr_Impl *pArr, USHORT nID)
//STRIP001 {
//STRIP001 	for (USHORT n=0; n<pArr->Count(); n++)
//STRIP001 	{
//STRIP001 		SfxStatusItemInf_Impl *pItem=(*pArr)[n];
//STRIP001 		if (pItem->nId == nID) return pItem;
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }


//====================================================================

class SfxStatusBar_Impl: public StatusBar
{
	SfxStatusBarManager*	pMgr;
	Rectangle				aLastItemRect;
	Rectangle				aTrackingRect;
	SfxStatusBarControl*	pLastControl;
	USHORT                  nLastItemId;
	BOOL					bCaptured;
	USHORT					nMoveId;
	USHORT					nLastItemPos;
	long					nMovePos;
	Pointer 				aOldPointer;
	BOOL					bMoving;
	BOOL					bCapt;
	BOOL					bShow;
	BOOL					bLock;
	Window*					pLastFocusWin;

friend class SfxStatusBarManager;

private:
//STRIP001 	SfxStatusBarControl* GetItemAt( const MouseEvent &rEvt );

protected:
	virtual void    Click(){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual void    Click();
	virtual void    DoubleClick(){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual void    DoubleClick();
	virtual void	Command( const CommandEvent &rEvt ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual void	Command( const CommandEvent &rEvt );
	virtual void	MouseButtonDown( const MouseEvent& rMEvt ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual void	MouseButtonDown( const MouseEvent& rMEvt );
	virtual void	MouseMove( const MouseEvent& rMEvt );
	virtual void	MouseButtonUp( const MouseEvent& rMEvt ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual void	MouseButtonUp( const MouseEvent& rMEvt );
	virtual void	UserDraw( const UserDrawEvent& rUDEvt);
	virtual void	KeyInput( const KeyEvent& rKEvent ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual void	KeyInput( const KeyEvent& rKEvent );

public:
					SfxStatusBar_Impl( Window* pParent,
									   SfxStatusBarManager& rMgr );
//STRIP001 	void			Init( SfxStatusBarManager* rMgr );

//STRIP001 	void			CaptureMouse( SfxStatusBarControl &rCtrl );
//STRIP001 	void			ReleaseMouse( SfxStatusBarControl &rCtrl );
};

//--------------------------------------------------------------------

/*N*/ SfxStatusBar_Impl::SfxStatusBar_Impl( Window* pParent,
/*N*/ 									  SfxStatusBarManager& rMgr )
/*N*/ :	StatusBar( pParent, WinBits( WB_LEFT | WB_3DLOOK ) ),
/*N*/ 	pMgr( &rMgr ),
/*N*/ 	nLastItemId( 0 ),
/*N*/ 	pLastControl( 0 ),
/*N*/ 	bCaptured(FALSE),
/*N*/ 	bMoving(FALSE),
/*N*/ 	nMoveId(0),
/*N*/ 	nLastItemPos(STATUSBAR_ITEM_NOTFOUND),
/*N*/ 	nMovePos(0),
/*N*/ 	bCapt(FALSE),
/*N*/ 	bShow(TRUE),
/*N*/ 	bLock(FALSE),
/*N*/ 	pLastFocusWin(0)
/*N*/ {
/*N*/ 	SetUniqueId( HID_STATUSBAR );
/*N*/ }

//STRIP001 void SfxStatusBar_Impl::Init( SfxStatusBarManager* p  )
//STRIP001 {
//STRIP001 	pMgr = p;
//STRIP001 	nLastItemId = 0;
//STRIP001 	pLastControl = 0;
//STRIP001 	bCaptured = FALSE;
//STRIP001 	bMoving = FALSE;
//STRIP001 	nMoveId = 0;
//STRIP001 	nMovePos = 0;
//STRIP001 	bCapt = FALSE;
//STRIP001 	bShow = TRUE;
//STRIP001 	nLastItemPos = STATUSBAR_ITEM_NOTFOUND;
//STRIP001 	pLastFocusWin = 0;
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 SfxStatusBarControl* SfxStatusBar_Impl::GetItemAt( const MouseEvent &rEvt )
//STRIP001 {
//STRIP001 	Point aMousePos = rEvt.GetPosPixel();
//STRIP001 	if ( pLastControl && ( bCaptured || aLastItemRect.IsInside(aMousePos) ) )
//STRIP001 		return pLastControl;
//STRIP001 
//STRIP001 	pLastControl = 0;
//STRIP001 	nLastItemId = 0;
//STRIP001 
//STRIP001 	// Item suchen, das geklickt wurde
//STRIP001 	USHORT nPos = 0;
//STRIP001 	while ( nPos < GetItemCount() )
//STRIP001 	{
//STRIP001 		USHORT nId = GetItemId( nPos );
//STRIP001 
//STRIP001 		// Ist es dieses Item
//STRIP001 		Rectangle aItemRect( GetItemRect( nId ) );
//STRIP001 		if ( aItemRect.IsInside( aMousePos ) )
//STRIP001 		{
//STRIP001 			aLastItemRect = aItemRect;
//STRIP001 			nLastItemId = nId;
//STRIP001 			pLastControl = pMgr->FindControl_Impl( nId );
//STRIP001 			return pLastControl;
//STRIP001 		}
//STRIP001 
//STRIP001 		++nPos;
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 void SfxStatusBar_Impl::CaptureMouse( SfxStatusBarControl &rCtrl )
//STRIP001 {
//STRIP001 	nLastItemId = rCtrl.GetId();
//STRIP001 	pLastControl = &rCtrl;
//STRIP001 	bCaptured = TRUE;
//STRIP001 }

//STRIP001 void SfxStatusBar_Impl::ReleaseMouse( SfxStatusBarControl &rCtrl )
//STRIP001 {
//STRIP001 	if ( pLastControl == &rCtrl )
//STRIP001 	{
//STRIP001 		bCaptured = FALSE;
//STRIP001 		nLastItemId = 0;
//STRIP001 		pLastControl = 0;
//STRIP001 	}
//STRIP001 }

//STRIP001 void SfxStatusBar_Impl::Command( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	if ( rCEvt.GetCommand() != COMMAND_CONTEXTMENU )
//STRIP001 		return;
//STRIP001 
//STRIP001 	MouseEvent aMEvt( rCEvt.GetMousePosPixel(), 1, 0, MOUSE_RIGHT, 0 );
//STRIP001 	SfxStatusBarControl *pStbCtrl = GetItemAt(aMEvt);
//STRIP001 	if ( pStbCtrl )
//STRIP001 		pStbCtrl->Command(rCEvt);
//STRIP001 }

//STRIP001 void SfxStatusBar_Impl::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001 	if ( bMoving && rKEvt.GetKeyCode().GetCode() == KEY_ESCAPE )
//STRIP001 	{
//STRIP001 		HideTracking();
//STRIP001 		nMoveId = 0;
//STRIP001 		bMoving = FALSE;
//STRIP001 		Window::ReleaseMouse();
//STRIP001 		if ( pLastFocusWin )
//STRIP001 			pLastFocusWin->GrabFocus();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		StatusBar::KeyInput( rKEvt );
//STRIP001 }

//STRIP001 void SfxStatusBar_Impl::MouseButtonDown( const MouseEvent& rEvt )
//STRIP001 {
//STRIP001 	if ( nMoveId )
//STRIP001 	{
//STRIP001 		// ButtonDown ueber Zwischenraum
//STRIP001 		if ( rEvt.GetMode() & MOUSE_SELECT )
//STRIP001 		{
//STRIP001 			// Position + Id festhalten
//STRIP001 			bMoving = TRUE;
//STRIP001 			nMovePos = rEvt.GetPosPixel().X();
//STRIP001 			aTrackingRect = GetItemRect( nMoveId );
//STRIP001 			Window::CaptureMouse();
//STRIP001 			pLastFocusWin = Application::GetFocusWindow();
//STRIP001 			GrabFocus();
//STRIP001 		}
//STRIP001 
//STRIP001 		StatusBar::MouseButtonDown(rEvt);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SfxStatusBarControl *pStbCtrl = GetItemAt(rEvt);
//STRIP001 		if (!pStbCtrl || !pStbCtrl->MouseButtonDown(rEvt) )
//STRIP001 			StatusBar::MouseButtonDown(rEvt);
//STRIP001 	}
//STRIP001 }

/*N*/ void SfxStatusBar_Impl::MouseMove( const MouseEvent& rEvt )
/*N*/ {
/*N*/ 	StatusBar::MouseMove(rEvt);
/*N*/ }

//STRIP001 void SfxStatusBar_Impl::MouseButtonUp( const MouseEvent& rEvt )
//STRIP001 {
//STRIP001 	if ( bMoving )
//STRIP001 	{
//STRIP001 		// Es wurde verschoben
//STRIP001 		HideTracking();
//STRIP001 		pMgr->SetItemWidth( nMoveId, aTrackingRect.GetWidth() );
//STRIP001 
//STRIP001 		// Nach Loslassen wieder zurueck
//STRIP001 		nMoveId = 0;
//STRIP001 		bMoving = FALSE;
//STRIP001 		Window::ReleaseMouse();
//STRIP001 		StatusBar::MouseButtonUp(rEvt);
//STRIP001 		if ( pLastFocusWin )
//STRIP001 			pLastFocusWin->GrabFocus();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SfxStatusBarControl *pStbCtrl = GetItemAt(rEvt);
//STRIP001 		if ( !pStbCtrl || !pStbCtrl->MouseButtonUp(rEvt) )
//STRIP001 			StatusBar::MouseButtonUp(rEvt);
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bCapt )
//STRIP001 	{
//STRIP001 		SetPointer( aOldPointer );
//STRIP001 		bCapt = FALSE;
//STRIP001 	}
//STRIP001 }

//STRIP001 void SfxStatusBar_Impl::Click()
//STRIP001 {
//STRIP001 	if ( GetCurItemId() )
//STRIP001 		pMgr->FindControl_Impl( GetCurItemId() )->Click();
//STRIP001 }

//STRIP001 void SfxStatusBar_Impl::DoubleClick()
//STRIP001 {
//STRIP001 	if ( GetCurItemId() )
//STRIP001 		pMgr->FindControl_Impl( GetCurItemId() )->DoubleClick();
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ void SfxStatusBar_Impl::UserDraw(const UserDrawEvent& rUDEvt)
/*N*/ {
/*N*/ 	if ( !bLock )
/*N*/ 	{
/*N*/ 		// MI/#31218#: da kam ein Paint als keine Items gebunden waren, warum?
/*N*/ 		DBG_ASSERT( pMgr, "StatusBar: UserDraw without StatusBarManager" );
/*N*/ 		SfxStatusBarControl *pCtrl = pMgr
/*N*/ 								? pMgr->FindControl_Impl( rUDEvt.GetItemId() )
/*N*/ 								: 0;
/*N*/ 		DBG_ASSERT( !pMgr->GetBindings_Impl() || pCtrl, "StatusBar: unknown UserDraw (no items bound)" );
/*N*/ 		if ( pCtrl )
/*N*/ 			pCtrl->Paint( rUDEvt );
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxStatusBarManager::UseDefault()
/*N*/ {
/*N*/ 	((SfxStatusBar_Impl*)pBar)->bLock = TRUE;
/*N*/ 	pBindings->ENTERREGISTRATIONS();
/*N*/ 
/*N*/ 	if ( pBar->GetItemCount() )
/*N*/ 		// Falls neu initialisiert wird
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 Clear_Impl();
/*N*/ 
/*N*/ 	pShell->FillStatusBar( *pBar );
/*N*/ 
/*N*/ 	// Visible-Status merken
/*N*/     ((SfxStatusBar_Impl*)pBar)->bShow = TRUE;
/*N*/ 
/*N*/ 	// Controller erzeugen
/*N*/ 	Construct();
/*N*/ 
/*N*/ 	pBindings->LEAVEREGISTRATIONS();
/*N*/ 	((SfxStatusBar_Impl*)pBar)->bLock = FALSE;
/*N*/ 
/*N*/ 	// Die Daten der vorhandenen Items merken
/*N*/ 	for (USHORT n=0; n<pItems->Count(); n++)
/*?*/ 		delete (*pItems)[n];
/*N*/ 	pItems->Clear();
/*N*/ 	for ( USHORT nItem = 0; nItem < pBar->GetItemCount(); ++nItem )
/*N*/ 	{
/*N*/ 		USHORT nId = pBar->GetItemId(nItem);
/*N*/ 		long nWidth = pBar->GetItemWidth(nId);
/*N*/ 		StatusBarItemBits aBits = pBar->GetItemBits(nId);
/*N*/ 		long nOffs = pBar->GetItemOffset(nId);
/*N*/ 		SfxStatusItemInf_Impl* pItem = new SfxStatusItemInf_Impl(nId, nWidth, aBits, nOffs);
/*N*/ 		pItems->Append(pItem);
/*N*/ 	}
/*N*/ 
/*N*/     SetDefault( TRUE );
/*N*/ }


//--------------------------------------------------------------------

/*N*/ void SfxStatusBarManager::Construct()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_ASSERT(pBindings, "Statuszeile ohne Bindings!");
/*N*/ 
/*N*/ 	pBoundItems = new SfxStatusItemArr_Impl;
/*N*/ 
/*N*/ 	Font aFont( pBar->GetFont() );
/*N*/ 	aFont.SetWeight( WEIGHT_NORMAL );
/*N*/ 	pBar->SetFont( aFont );
/*N*/ 
/*N*/ 	const SfxSlotPool& rSlotPool = SFX_APP()->GetSlotPool( pBindings->GetDispatcher_Impl()->GetFrame() );
/*N*/ 
/*N*/ 	for ( USHORT nItem = 0; nItem < pBar->GetItemCount(); ++nItem )
/*N*/ 	{
/*N*/ 		USHORT nId = pBar->GetItemId( nItem );
/*N*/ #ifdef DBG_UTIL
/*N*/ 		const SfxSlot *pSlot = SFX_SLOTPOOL().GetSlot( nId );
/*N*/ 		if ( pSlot && !pSlot->IsMode( SFX_SLOT_STATUSBARCONFIG ) )
/*N*/ 		{
/*?*/ 			ByteString aStr( "Slot " );
/*?*/ 			aStr += ByteString::CreateFromInt32( nId );
/*?*/ 			aStr += ByteString( " : StatusbarConfig fehlt!" );
/*?*/ 			DBG_ERROR( aStr.GetBuffer() );
/*N*/ 		}
/*N*/ #endif
/*N*/ 		pBoundItems->Append( SfxStatusBarControl::CreateControl(
/*N*/ 				nId, pBar, *pBindings, pShell->GetInterface()->GetModule() ) );
/*N*/ 		pBar->SetHelpId( nId, nId );
/*N*/ 		pBar->SetAccessibleName( nId, rSlotPool.GetSlotName_Impl( nId ) );
/*N*/ 	}
/*N*/ 
/*N*/     // Immer anzeigen, Statuszeile wird "uber #Taskbar ein/ausgeschaltet
/*N*/ 	pBar->Show();
/*N*/ }

//STRIP001 void SfxStatusBarManager::Clear_Impl()
//STRIP001 {
//STRIP001 	if ( pBar )
//STRIP001 	{
//STRIP001 		((SfxStatusBar_Impl*)pBar)->Init( this );
//STRIP001 		pBar->Clear();
//STRIP001 	}
//STRIP001 
//STRIP001 	// alte items freigeben
//STRIP001 	if ( pBoundItems )
//STRIP001 	{
//STRIP001 		for ( USHORT nItem = 0; nItem < pBoundItems->Count(); ++nItem )
//STRIP001 			delete pBoundItems->GetObject( nItem );
//STRIP001 		delete pBoundItems;
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ SfxStatusBarManager::SfxStatusBarManager(Window* pParent, SfxBindings &rBindings,
/*N*/ 						SfxShell *pSh, SfxConfigManager* pMgr, USHORT nId, StatusBar *p) :
/*N*/     SfxConfigItem( nId, pMgr ),
/*N*/ 	pBar( p ),
/*N*/ 	pBoundItems( 0 ),
/*N*/ 	pShell(pSh),
/*N*/ 	pBindings(&rBindings)
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	if ( pBar )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ((SfxStatusBar_Impl*)pBar)->Init( this );
/*N*/ 	else
/*N*/ 		pBar = new SfxStatusBar_Impl( pParent, *this );
/*N*/ 
/*N*/ 	pItems = new SfxStatusItemInfArr_Impl;
/*N*/ 	StartListening(rBindings);
/*N*/ 	Initialize();
/*N*/ }

//STRIP001 SfxStatusBarManager::SfxStatusBarManager( Window* pParent, const SfxStatusBarManager& rOther, SfxConfigManager* pMgr )
//STRIP001     : SfxConfigItem( rOther.GetType(), pMgr ),
//STRIP001     pBar( NULL ),
//STRIP001 	pBoundItems( 0 ),
//STRIP001     pShell( rOther.pShell ),
//STRIP001     pBindings( rOther.pBindings )
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 
//STRIP001     pBar = new SfxStatusBar_Impl( pParent, *this );
//STRIP001 	pItems = new SfxStatusItemInfArr_Impl;
//STRIP001     StartListening( *pBindings );
//STRIP001 	Initialize();
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ SfxStatusBarManager::~SfxStatusBarManager()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	((SfxStatusBar_Impl*)pBar)->pMgr = 0;
/*N*/ 
/*N*/     // allen SfxProgress bescheid geben; auch nicht sichtbare Dokumente knnen einen Progress laufen haben,
/*N*/     // nmlich in einer anderen View, wenn sie gerade geladen werden!
/*N*/     for ( SfxObjectShell* pObjSh = SfxObjectShell::GetFirst( 0, sal_False );
/*N*/ 		  pObjSh;
/*N*/           pObjSh = SfxObjectShell::GetNext( *pObjSh, 0, sal_False ) )
/*N*/ 		if ( pObjSh->GetProgress() &&
/*N*/ 			 pObjSh->GetProgress()->StatusBarManagerGone_Impl(this) )
/*N*/ 			break;
/*N*/ 
/*N*/ 	if (pBindings)
/*N*/ 	{
/*N*/ 		pBindings->ENTERREGISTRATIONS();
/*N*/ 		for ( USHORT n = pBoundItems->Count(); n > 0; --n )
/*N*/ 			delete pBoundItems->GetObject(n-1);
/*N*/ 		pBindings->LEAVEREGISTRATIONS();
/*N*/ 		EndListening(*pBindings);
/*N*/ 		pBindings = 0;
/*N*/ 	}
/*N*/ 
/*N*/ 	delete pBoundItems;
/*N*/ 
/*N*/ 	for (USHORT n=0; n<pItems->Count(); n++)
/*N*/ 		delete (*pItems)[n];
/*N*/ 
/*N*/ 	delete pItems;
/*N*/ }


//--------------------------------------------------------------------

//STRIP001 BOOL SfxStatusBarManager::AddItem( USHORT nItemId, long nWidth,
//STRIP001 								   USHORT nOffset, USHORT nPos )
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 	DBG_ASSERT(pBindings, "Statuszeile ohne Bindings!");
//STRIP001 
//STRIP001 	SfxStatusItemInf_Impl* pItem = FindItem(pItems, nItemId);
//STRIP001 	StatusBarItemBits aBits = SIB_CENTER | SIB_IN | SIB_USERDRAW | SIB_AUTOSIZE;
//STRIP001 
//STRIP001 	if (pItem)
//STRIP001 	{
//STRIP001 		nWidth = pItem->nWidth;
//STRIP001 		nOffset = (USHORT) pItem->nOffset;
//STRIP001 		aBits = pItem->aBits;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pItem = new SfxStatusItemInf_Impl(nItemId, nWidth, aBits, nOffset);
//STRIP001 		pItems->Append(pItem);
//STRIP001 	}
//STRIP001 
//STRIP001 	((SfxStatusBar_Impl*)pBar)->bLock = TRUE;
//STRIP001 	pBar->InsertItem( nItemId, nWidth, aBits, nOffset, nPos );
//STRIP001 	pBar->SetHelpId( nItemId, nItemId );
//STRIP001 	const SfxSlotPool& rSlotPool = SFX_APP()->GetSlotPool( pBindings->GetDispatcher_Impl()->GetFrame() );
//STRIP001 	pBar->SetAccessibleName( nItemId, rSlotPool.GetSlotName_Impl( nItemId ) );
//STRIP001 
//STRIP001 	pBindings->ENTERREGISTRATIONS();
//STRIP001 	pBoundItems->Append( SfxStatusBarControl::CreateControl(
//STRIP001 		nItemId, pBar, *pBindings, pShell->GetInterface()->GetModule() ) );
//STRIP001 	pBindings->LEAVEREGISTRATIONS();
//STRIP001 	((SfxStatusBar_Impl*)pBar)->bLock = FALSE;
//STRIP001 	SetDefault(FALSE);
//STRIP001 	return TRUE;
//STRIP001 }


//--------------------------------------------------------------------

//STRIP001 void SfxStatusBarManager::RemoveItem( USHORT nItemId)
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 	DBG_ASSERT(pBindings, "Statuszeile ohne Bindings!");
//STRIP001 
//STRIP001 	pBar->RemoveItem(nItemId);
//STRIP001 	pBindings->ENTERREGISTRATIONS();
//STRIP001 
//STRIP001 	SfxStatusBarControl* pControl = FindControl_Impl(nItemId);
//STRIP001 	pBoundItems->Remove(pControl);
//STRIP001 	delete pControl;
//STRIP001 
//STRIP001 	pBindings->LEAVEREGISTRATIONS();
//STRIP001 	SetDefault(FALSE);
//STRIP001 }


//--------------------------------------------------------------------

//STRIP001 void SfxStatusBarManager::Show()
//STRIP001 {
//STRIP001 	HACK(soll ggf. nicht in Config durchschlagen - aber was InPlace)
//STRIP001     ((SfxStatusBar_Impl*)pBar)->bShow = TRUE;
//STRIP001 	pBar->Show();
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 void SfxStatusBarManager::Hide()
//STRIP001 {
//STRIP001 	HACK(soll ggf. nicht in Config durchschlagen - aber was InPlace)
//STRIP001     ((SfxStatusBar_Impl*)pBar)->bShow = FALSE;
//STRIP001 	pBar->Hide();
//STRIP001 }

// ------------------------------------------------------------------------

//STRIP001 String SfxStatusBarManager::GetStreamName() const
//STRIP001 {
//STRIP001     return SfxConfigItem::GetStreamName( GetType() );
//STRIP001 }
//--------------------------------------------------------------------

// Beginn Fortschrittsanzeige

/*N*/ void    SfxStatusBarManager::StartProgressMode(
/*N*/ 	const String &rText,		// Text, der waehrend der Forrtschrittsanzeige in der Statuszeile erscheint
/*N*/ 	ULONG nMax)					// Maximalwert (100 %)
/*N*/ {
/*N*/ 	nMaxProgress = nMax;
/*N*/ 	pBar->StartProgressMode(rText);
/*N*/ }

//--------------------------------------------------------------------

// Status Fortschrittsanzeige

/*N*/ void SfxStatusBarManager::SetProgressState
/*N*/ (
/*N*/ 	ULONG nPosition	// Status relativ zum initial "ubergebenen Maximalwert
/*N*/ )
/*N*/ {
/*N*/ 	DBG_ASSERT( nPosition < ULONG_MAX / 100, "ULONG overflow" );
/*N*/ 	USHORT nVal = nMaxProgress ? (USHORT)(nPosition * 100L / nMaxProgress) : 0;
/*N*/ 	pBar->SetProgressValue( nVal );
/*N*/ }

//--------------------------------------------------------------------

// Ende Fortschrittsanzeige

/*N*/ void    SfxStatusBarManager::EndProgressMode()
/*N*/ {
/*N*/ 	pBar->EndProgressMode();
/*N*/ }

//--------------------------------------------------------------------

// Hilfetext anzeigen

//STRIP001 void    SfxStatusBarManager::ShowHelpText( const String &rText )
//STRIP001 {
//STRIP001 	pBar->HideItems();
//STRIP001 	pBar->SetText(rText);
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ SfxStatusBarControl* SfxStatusBarManager::FindControl_Impl( USHORT nId ) const
/*N*/ {
/*N*/ 	DBG_ASSERT( pBoundItems, "StatusBar: no items bound" );
/*N*/ 	if ( !pBoundItems )
/*N*/ 		return 0;
/*N*/ 
/*N*/ 	for ( USHORT nPos = 0; nPos < pBoundItems->Count(); ++nPos )
/*N*/ 		if ( pBoundItems->GetObject(nPos)->GetId() == nId )
/*N*/ 			return pBoundItems->GetObject(nPos);
/*N*/ 	return 0;
/*N*/ }

//STRIP001 void SfxStatusBarControl::CaptureMouse()
//STRIP001 {
//STRIP001 	( (SfxStatusBar_Impl*) pBar )->CaptureMouse(*this);
//STRIP001 }

//STRIP001 void SfxStatusBarControl::ReleaseMouse()
//STRIP001 {
//STRIP001 	( (SfxStatusBar_Impl*) pBar )->ReleaseMouse(*this);
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 void SfxStatusBarManager::Clear()
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 	DBG_ASSERT(pBindings, "Statuszeile ohne Bindings!");
//STRIP001 
//STRIP001 	pBar->Clear();
//STRIP001 	pBindings->ENTERREGISTRATIONS();
//STRIP001 	for ( USHORT n = pBoundItems->Count(); n > 0; --n )
//STRIP001 		delete pBoundItems->GetObject(n-1);
//STRIP001 	pBoundItems->Clear();
//STRIP001 	pBindings->LEAVEREGISTRATIONS();
//STRIP001 	SetDefault(FALSE);
//STRIP001 }


//--------------------------------------------------------------------

//STRIP001 void SfxStatusBarManager::SetItemWidth(USHORT nId, long nWidth)
//STRIP001 {
//STRIP001 	USHORT nPos = pBar->GetItemPos(nId);
//STRIP001 	StatusBarItemBits aBits = pBar->GetItemBits(nId);
//STRIP001 	long nOffset = pBar->GetItemOffset(nId);
//STRIP001 
//STRIP001 	String aText = pBar->GetItemText(nId);
//STRIP001 	pBar->RemoveItem (nId);
//STRIP001 	pBar->InsertItem(nId, nWidth, aBits, nOffset, nPos);
//STRIP001 	pBar->SetItemText(nId, aText);
//STRIP001 
//STRIP001 	SfxStatusItemInf_Impl* pItem = FindItem(pItems, nId);
//STRIP001 	pItem->nWidth = nWidth;
//STRIP001 	SetDefault(FALSE);
//STRIP001 }


//--------------------------------------------------------------------

//STRIP001 void SfxStatusBarManager::DestroyingBindings(SfxBindings *pBind)
//STRIP001 {
//STRIP001 	if (pBind == pBindings)
//STRIP001 	{
//STRIP001 		pBoundItems->Clear();			// Bindings haben Controller zerstoert
//STRIP001 		pBindings = 0;					// Bindings werden ungueltig
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ void SfxStatusBarManager::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
/*N*/ {
/*N*/ 	if ( rHint.IsA(TYPE(SfxSimpleHint)) )
/*N*/ 	{
/*N*/ 		switch( ( (SfxSimpleHint&) rHint ).GetId() )
/*N*/ 		{
/*N*/ 			case SFX_HINT_DYING:
/*?*/ 				if ( rBC.IsA(TYPE(SfxBindings)) )
/*?*/ 					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 DestroyingBindings(PTR_CAST(SfxBindings,&rBC));
/*N*/ 				break;
/*N*/ 		}
/*N*/ 	}
/*N*/ }


/*N*/ int SfxStatusBarManager::Load( SotStorage& rStorage )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001     SotStorageStreamRef xStream = rStorage.OpenSotStream( GetStreamName(), STREAM_STD_READ );
//STRIP001     if ( xStream->GetError() )
//STRIP001         return SfxConfigItem::ERR_READ;
//STRIP001 
//STRIP001 	pBindings->ENTERREGISTRATIONS();
//STRIP001 
//STRIP001 	if ( pBar->GetItemCount() )
//STRIP001 		Clear_Impl();
//STRIP001 
//STRIP001 	StatusBarDescriptor aItems;
//STRIP001     int nRet = ERR_OK;
//STRIP001     if ( !::framework::StatusBarConfiguration::LoadStatusBar( *xStream, aItems ) )
//STRIP001 	{
//STRIP001 		pBindings->LEAVEREGISTRATIONS();
//STRIP001         return ERR_READ;
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nCount = aItems.Count();
//STRIP001 	USHORT n;
//STRIP001 	for (n=0; n<nCount; n++)
//STRIP001 	{
//STRIP001 		StatusBarItemDescriptor *pItem = aItems[n];
//STRIP001         if ( pItem->aURL.CompareToAscii("slot:",5) == COMPARE_EQUAL )
//STRIP001         {
//STRIP001             USHORT nId = (USHORT) pItem->aURL.Copy( 5 ).ToInt32();
//STRIP001             pItem->aURL.Erase();
//STRIP001 			pBar->InsertItem( nId, pItem->nWidth, pItem->nItemBits, pItem->nOffset );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			DBG_ERROR("Invalid statusbar configuration!");
//STRIP001 	}
//STRIP001 
//STRIP001 	for ( n=0; n<pItems->Count(); n++ )
//STRIP001 		delete (*pItems)[n];
//STRIP001 
//STRIP001 	pItems->Clear();
//STRIP001 	for ( USHORT nItem = 0; nItem < pBar->GetItemCount(); ++nItem )
//STRIP001 	{
//STRIP001 		USHORT nId = pBar->GetItemId(nItem);
//STRIP001 		long nWidth = pBar->GetItemWidth(nId);
//STRIP001 		StatusBarItemBits aBits = pBar->GetItemBits(nId);
//STRIP001 		long nOffs = pBar->GetItemOffset(nId);
//STRIP001 		SfxStatusItemInf_Impl* pItem = new SfxStatusItemInf_Impl(nId, nWidth, aBits, nOffs);
//STRIP001 		pItems->Append(pItem);
//STRIP001 	}
//STRIP001 
//STRIP001 	Construct();
//STRIP001 	pBindings->LEAVEREGISTRATIONS();
//STRIP001 	SetDefault( FALSE );
//STRIP001 
//STRIP001 	return SfxConfigItem::ERR_OK;
//STRIP001 	return ERR_OK;
//STRIP001 
/*N*/ }

/*N*/ BOOL SfxStatusBarManager::Store( SotStorage& rStorage )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001     SotStorageStreamRef xStream = rStorage.OpenSotStream( SfxStatusBarManager::GetStreamName(), STREAM_STD_READWRITE|STREAM_TRUNC );
//STRIP001     if ( xStream->GetError() )
//STRIP001         return FALSE;
//STRIP001 
//STRIP001 	StatusBarDescriptor aItems;
//STRIP001 	USHORT nPos, nCount = pBar->GetItemCount();
//STRIP001 	for ( nPos = 0; nPos < nCount; ++nPos )
//STRIP001 	{
//STRIP001 		StatusBarItemDescriptor* pItem = new StatusBarItemDescriptor;
//STRIP001 		aItems.Insert( pItem, aItems.Count() );
//STRIP001 
//STRIP001 		USHORT nId = pBar->GetItemId( nPos );
//STRIP001         pItem->aURL = String::CreateFromAscii( "slot:" );
//STRIP001         pItem->aURL += String::CreateFromInt32( nId );
//STRIP001 		pItem->nItemBits = pBar->GetItemBits( nId );
//STRIP001         pItem->nWidth = pBar->GetItemWidth( nId );
//STRIP001         pItem->nOffset = pBar->GetItemOffset( nId );
//STRIP001 	}
//STRIP001 
//STRIP001 	return ::framework::StatusBarConfiguration::StoreStatusBar( *xStream, aItems );
/*N*/ }

/*N*/ BOOL SfxStatusBarManager::Import( SvStream& rInStream, SvStream& rOutStream )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	USHORT nFileVersion, nCount, nId, nBits;
//STRIP001 	long nWidth, nOffs;
//STRIP001 
//STRIP001 	rInStream >> nFileVersion;
//STRIP001 
//STRIP001 	if ( nFileVersion < 4 )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	BOOL bVisible = TRUE;
//STRIP001 	if ( nFileVersion >= 5 )
//STRIP001 		rInStream >> bVisible;
//STRIP001 
//STRIP001 	rInStream >> nCount;
//STRIP001 	USHORT n;
//STRIP001 	StatusBarDescriptor aItems;
//STRIP001 	for (n=0; n<nCount; n++)
//STRIP001 	{
//STRIP001 		StatusBarItemDescriptor* pItem = new StatusBarItemDescriptor;
//STRIP001 		aItems.Insert( pItem, aItems.Count() );
//STRIP001 		rInStream >> nId >> nWidth >> nBits >> nOffs;
//STRIP001         pItem->aURL = String::CreateFromAscii("slot:");
//STRIP001         pItem->aURL += String::CreateFromInt32( nId );
//STRIP001 		pItem->nWidth = nWidth;
//STRIP001 		pItem->nItemBits = nBits;
//STRIP001 		pItem->nOffset = nOffs;
//STRIP001 	}
//STRIP001 
//STRIP001 	return ::framework::StatusBarConfiguration::StoreStatusBar( rOutStream, aItems );
/*N*/ }

/*N*/ BOOL SfxStatusBarManager::Export( SvStream& rInStream, SvStream& rOutStream )
/*N*/ {DBG_BF_ASSERT(0, "STRIP");return FALSE; //STRIP001 
//STRIP001 	StatusBarDescriptor aItems;
//STRIP001     if ( !::framework::StatusBarConfiguration::LoadStatusBar( rInStream, aItems ) )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	rOutStream << nVersion
//STRIP001 			<< (BOOL) TRUE
//STRIP001 			<< aItems.Count();
//STRIP001 
//STRIP001 	USHORT n;
//STRIP001 	for (n=0; n<aItems.Count(); n++)
//STRIP001 	{
//STRIP001 		StatusBarItemDescriptor *pItem = aItems[n];
//STRIP001 		USHORT nId=0;
//STRIP001         if ( pItem->aURL.CompareToAscii("slot:",5) == COMPARE_EQUAL )
//STRIP001             nId = (USHORT) pItem->aURL.Copy( 5 ).ToInt32();
//STRIP001 		rOutStream << nId
//STRIP001 				<< pItem->nWidth
//STRIP001 				<< (USHORT) pItem->nItemBits
//STRIP001 				<< pItem->nOffset;
//STRIP001 	}
//STRIP001 
//STRIP001 	rOutStream << (USHORT) 0;
//STRIP001 	return TRUE;
/*N*/ }
}
