/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_showwin.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:45:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef INCLUDED_SVTOOLS_SYSLOCALE_HXX
// auto strip #include <svtools/syslocale.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWFRM_HXX //autogen
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif

#pragma hdrstop

#include "res_bmp.hrc"
// auto strip #include "showwin.hxx"
// auto strip #include "slidvish.hxx"
// auto strip #include "fuslshow.hxx"
// auto strip #include "preview.hxx"
// auto strip #include "sdresid.hxx"
#include "helpids.h"
#include "strings.hrc"
namespace binfilter {

#define SHOWWIN_FONTHEIGHT 14

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

//STRIP001 SdShowWindow::SdShowWindow( Window* pParent, SdPreviewWin* pPreviewWin ) :
//STRIP001 	SdWindow(pParent),
//STRIP001 	pPreview(pPreviewWin),
//STRIP001     eShowWindowMode(SHOWWINDOWMODE_NORMAL),
//STRIP001 	nRestartPage( PAGE_NO_END ),
//STRIP001 	nPauseTimeout( SLIDE_NO_TIMEOUT ),
//STRIP001 	bShowNavigatorAfterSpecialMode( FALSE )
//STRIP001 {
//STRIP001     // Do never mirror the preview window.  This explicitly includes right
//STRIP001     // to left writing environments.
//STRIP001     EnableRTL (FALSE);
//STRIP001 
//STRIP001 	MapMode aMap(GetMapMode());
//STRIP001 	aMap.SetMapUnit(MAP_100TH_MM);
//STRIP001 	SetMapMode(aMap);
//STRIP001 
//STRIP001 	// HelpId setzen
//STRIP001 	SetHelpId( HID_SD_WIN_PRESENTATION );
//STRIP001 	SetUniqueId( HID_SD_WIN_PRESENTATION );
//STRIP001 
//STRIP001 	aPauseTimer.SetTimeoutHdl( LINK( this, SdShowWindow, PauseTimeoutHdl ) );
//STRIP001 	aPauseTimer.SetTimeout( 1000 );
//STRIP001 
//STRIP001 	Bitmap 	  aBitmap(SdResId(BMP_WAIT_ICON));
//STRIP001 	BitmapEx  aBmpEx( aBitmap, COL_LIGHTMAGENTA );
//STRIP001 	AlphaMask aMask( aBmpEx.GetMask() );
//STRIP001 	aMask.Replace( 0, 128 );
//STRIP001 	aWaitIcon = BitmapEx( aBmpEx.GetBitmap(), aMask );
//STRIP001 
//STRIP001 	aRestoreSpace.SetSizePixel( aWaitIcon.GetSizePixel() );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Destruktor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SdShowWindow::~SdShowWindow()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Keyboard event
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdShowWindow::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	if( SHOWWINDOWMODE_END == eShowWindowMode )
//STRIP001 		TerminateShow();
//STRIP001 	else if( SHOWWINDOWMODE_BLANK == eShowWindowMode )
//STRIP001 	{
//STRIP001 		RestartShow();
//STRIP001 	}
//STRIP001 	else if( SHOWWINDOWMODE_PAUSE == eShowWindowMode )
//STRIP001 	{
//STRIP001 		if( rKEvt.GetKeyCode().GetCode() == KEY_ESCAPE )
//STRIP001 			TerminateShow();
//STRIP001 		else
//STRIP001 			RestartShow();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 		if( pViewShell )
//STRIP001 			bReturn = pViewShell->KeyInput(rKEvt, this);
//STRIP001 		else if (pPreview)
//STRIP001 			pPreview->KeyInputFromContents(rKEvt);
//STRIP001 
//STRIP001 		if( !bReturn )
//STRIP001 			Window::KeyInput(rKEvt);
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pViewShell )
//STRIP001 		pViewShell->SetActiveWindow( this );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* MouseButtonDown event
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdShowWindow::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	if( SHOWWINDOWMODE_NORMAL == eShowWindowMode )
//STRIP001 	{
//STRIP001 		if( pViewShell )
//STRIP001 			pViewShell->MouseButtonDown( rMEvt, this );
//STRIP001 		else if (pPreview)
//STRIP001 			pPreview->MouseButtonDownFromContents(rMEvt);
//STRIP001 	}
//STRIP001 	else if( pViewShell )
//STRIP001 		pViewShell->SetActiveWindow( this );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* MouseMove event
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdShowWindow::MouseMove(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	if( SHOWWINDOWMODE_NORMAL == eShowWindowMode )
//STRIP001 	{
//STRIP001 		if (pViewShell)
//STRIP001 			pViewShell->MouseMove( rMEvt, this );
//STRIP001 		else if (pPreview)
//STRIP001 			pPreview->MouseMoveFromContents( rMEvt );
//STRIP001 	}
//STRIP001 	else if( pViewShell )
//STRIP001 		pViewShell->SetActiveWindow( this );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* MouseButtonUp event
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdShowWindow::MouseButtonUp(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	if( SHOWWINDOWMODE_END == eShowWindowMode )
//STRIP001 		TerminateShow();
//STRIP001 	else if( ( SHOWWINDOWMODE_BLANK == eShowWindowMode ) ||
//STRIP001 	         ( SHOWWINDOWMODE_PAUSE == eShowWindowMode ) )
//STRIP001 	{
//STRIP001         RestartShow();
//STRIP001 	}
//STRIP001 	else if( pViewShell )
//STRIP001 		pViewShell->MouseButtonUp( rMEvt, this );
//STRIP001 	else if (pPreview)
//STRIP001 		pPreview->MouseButtonUpFromContents( rMEvt );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Paint-Event: wenn FuSlideShow noch erreichbar ist, weiterleiten
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdShowWindow::Paint(const Rectangle& rRect)
//STRIP001 {
//STRIP001 	if( SHOWWINDOWMODE_END == eShowWindowMode )
//STRIP001 		DrawEndScene();
//STRIP001 	else if( SHOWWINDOWMODE_PAUSE == eShowWindowMode )
//STRIP001 		DrawPauseScene( FALSE );
//STRIP001 	else if( SHOWWINDOWMODE_BLANK == eShowWindowMode )
//STRIP001 		DrawBlankScene();
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if (pViewShell)
//STRIP001 			pViewShell->Paint(rRect, this);
//STRIP001 		else if (pPreview)
//STRIP001 			pPreview->PaintContents(rRect);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* ParentNotify
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 long SdShowWindow::ParentNotify(NotifyEvent& rNEvt)
//STRIP001 {
//STRIP001 	long nOK = FALSE;
//STRIP001 
//STRIP001 	if( pViewShell && rNEvt.GetType() == EVENT_GETFOCUS )
//STRIP001 	{
//STRIP001 		NotifyEvent aNEvt(EVENT_GETFOCUS, this);
//STRIP001 		nOK = pViewShell->GetViewFrame()->GetWindow().Notify(aNEvt);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!nOK)
//STRIP001 		nOK = SdWindow::Notify(rNEvt);
//STRIP001 
//STRIP001 	return nOK;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* GetFocus()
//STRIP001 |* Window des MDIFrames benachrichtigen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdShowWindow::GetFocus()
//STRIP001 {
//STRIP001 	// Basisklasse
//STRIP001 	SdWindow::GetFocus();
//STRIP001 
//STRIP001 	if( pViewShell )
//STRIP001 	{
//STRIP001 		NotifyEvent aNEvt(EVENT_GETFOCUS, this);
//STRIP001 		pViewShell->GetViewFrame()->GetWindow().Notify(aNEvt);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* GetFocus()
//STRIP001 |* Window des MDIFrames benachrichtigen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL SdShowWindow::SetEndMode()
//STRIP001 {
//STRIP001 	if( ( SHOWWINDOWMODE_NORMAL == eShowWindowMode ) && !pPreview && pViewShell && pViewShell->GetView() )
//STRIP001 	{
//STRIP001 		pViewShell->GetView()->DelWin( this );
//STRIP001 		eShowWindowMode = SHOWWINDOWMODE_END;
//STRIP001 		aShowBackground = GetBackground();
//STRIP001 		SetBackground( Wallpaper( Color( COL_BLACK ) ) );
//STRIP001 
//STRIP001 		// hide navigator if it is visible
//STRIP001 		if( GetViewShell()->GetViewFrame()->GetChildWindow( SID_NAVIGATOR ) )
//STRIP001 		{
//STRIP001 			GetViewShell()->GetViewFrame()->ShowChildWindow( SID_NAVIGATOR, FALSE );
//STRIP001 			bShowNavigatorAfterSpecialMode = TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 
//STRIP001 	return( SHOWWINDOWMODE_END == eShowWindowMode );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 BOOL SdShowWindow::SetPauseMode( USHORT nPageToRestart, ULONG nTimeout, Graphic* pLogo )
//STRIP001 {
//STRIP001 	if( pViewShell && pViewShell->GetSlideShow() && !nTimeout )
//STRIP001 		pViewShell->GetSlideShow()->JumpToPage( nPageToRestart );
//STRIP001 	else if( ( SHOWWINDOWMODE_NORMAL == eShowWindowMode ) && !pPreview && pViewShell && pViewShell->GetView() )
//STRIP001 	{
//STRIP001 		pViewShell->GetView()->DelWin( this );
//STRIP001 		nPauseTimeout = nTimeout;
//STRIP001 		nRestartPage = nPageToRestart;
//STRIP001 		eShowWindowMode = SHOWWINDOWMODE_PAUSE;
//STRIP001 		aShowBackground = GetBackground();
//STRIP001 		SetBackground( Wallpaper( Color( COL_BLACK ) ) );
//STRIP001 
//STRIP001 		// hide navigator if it is visible
//STRIP001 		if( GetViewShell()->GetViewFrame()->GetChildWindow( SID_NAVIGATOR ) )
//STRIP001 		{
//STRIP001 			GetViewShell()->GetViewFrame()->ShowChildWindow( SID_NAVIGATOR, FALSE );
//STRIP001 			bShowNavigatorAfterSpecialMode = TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( pLogo )
//STRIP001 			aLogo = *pLogo;
//STRIP001 
//STRIP001 		Invalidate();
//STRIP001 
//STRIP001 		if( SLIDE_NO_TIMEOUT != nPauseTimeout )
//STRIP001 			aPauseTimer.Start();
//STRIP001 	}
//STRIP001 
//STRIP001 	return( SHOWWINDOWMODE_PAUSE == eShowWindowMode );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 BOOL SdShowWindow::SetBlankMode( USHORT nPageToRestart, const Color& rBlankColor )
//STRIP001 {
//STRIP001     if( ( SHOWWINDOWMODE_NORMAL == eShowWindowMode ) && !pPreview && pViewShell && pViewShell->GetView() )
//STRIP001 	{
//STRIP001 		pViewShell->GetView()->DelWin( this );
//STRIP001 		nRestartPage = nPageToRestart;
//STRIP001 		eShowWindowMode = SHOWWINDOWMODE_BLANK;
//STRIP001 		aShowBackground = GetBackground();
//STRIP001 		SetBackground( Wallpaper( rBlankColor ) );
//STRIP001 
//STRIP001 		// hide navigator if it is visible
//STRIP001 		if( GetViewShell()->GetViewFrame()->GetChildWindow( SID_NAVIGATOR ) )
//STRIP001 		{
//STRIP001 			GetViewShell()->GetViewFrame()->ShowChildWindow( SID_NAVIGATOR, FALSE );
//STRIP001 			bShowNavigatorAfterSpecialMode = TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 
//STRIP001 	return( SHOWWINDOWMODE_BLANK == eShowWindowMode );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdShowWindow::TerminateShow()
//STRIP001 {
//STRIP001 	aLogo.Clear();
//STRIP001 	aPauseTimer.Stop();
//STRIP001 	Erase();
//STRIP001 	SetBackground( aShowBackground );
//STRIP001     eShowWindowMode = SHOWWINDOWMODE_NORMAL;
//STRIP001 	nPauseTimeout = SLIDE_NO_TIMEOUT;
//STRIP001 
//STRIP001 	// show navigator?
//STRIP001 	if( bShowNavigatorAfterSpecialMode )
//STRIP001 	{
//STRIP001 		GetViewShell()->GetViewFrame()->ShowChildWindow( SID_NAVIGATOR, TRUE );
//STRIP001 		bShowNavigatorAfterSpecialMode = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pViewShell && pViewShell->GetSlideShow() )
//STRIP001 	{
//STRIP001 		if( pViewShell->GetView() )
//STRIP001 			pViewShell->GetView()->AddWin( this );
//STRIP001 
//STRIP001 		pViewShell->GetSlideShow()->Terminate();
//STRIP001 	}
//STRIP001 
//STRIP001 	nRestartPage = PAGE_NO_END;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdShowWindow::RestartShow()
//STRIP001 {
//STRIP001     ShowWindowMode eOldShowWindowMode = eShowWindowMode;
//STRIP001 
//STRIP001 	aLogo.Clear();
//STRIP001 	aPauseTimer.Stop();
//STRIP001 	Erase();
//STRIP001 	SetBackground( aShowBackground );
//STRIP001     eShowWindowMode = SHOWWINDOWMODE_NORMAL;
//STRIP001 	nPauseTimeout = SLIDE_NO_TIMEOUT;
//STRIP001 
//STRIP001 	if( pViewShell && pViewShell->GetSlideShow() )
//STRIP001 	{
//STRIP001 		if( pViewShell->GetView() )
//STRIP001 			pViewShell->GetView()->AddWin( this );
//STRIP001 	
//STRIP001 	    if( SHOWWINDOWMODE_BLANK == eOldShowWindowMode )
//STRIP001 	        Invalidate();
//STRIP001 	    else
//STRIP001 		    pViewShell->GetSlideShow()->JumpToPage( nRestartPage );
//STRIP001 	}
//STRIP001 
//STRIP001 	nRestartPage = PAGE_NO_END;
//STRIP001 
//STRIP001 	// show navigator?
//STRIP001 	if( bShowNavigatorAfterSpecialMode )
//STRIP001 	{
//STRIP001 		GetViewShell()->GetViewFrame()->ShowChildWindow( SID_NAVIGATOR, TRUE );
//STRIP001 		bShowNavigatorAfterSpecialMode = FALSE;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdShowWindow::DrawPauseScene( BOOL bTimeoutOnly )
//STRIP001 {
//STRIP001 	const MapMode&	rMap = GetMapMode();
//STRIP001 	const Point		aOutOrg( PixelToLogic( Point() ) );
//STRIP001 	const Size		aOutSize( GetOutputSize() );
//STRIP001 	const Size		aTextSize( LogicToLogic( Size( 0, SHOWWIN_FONTHEIGHT ), MAP_POINT, rMap ) );
//STRIP001 	const Size		aOffset( LogicToLogic( Size( 1000, 1000 ), MAP_100TH_MM, rMap ) );
//STRIP001 	String			aText( SdResId( STR_PRES_PAUSE ) );
//STRIP001 	BOOL			bDrawn = FALSE;
//STRIP001 
//STRIP001 	Font 			aFont( GetSettings().GetStyleSettings().GetMenuFont() );
//STRIP001 	const Font 		aOldFont( GetFont() );
//STRIP001 
//STRIP001 	aFont.SetSize( aTextSize );
//STRIP001 	aFont.SetColor( COL_WHITE );
//STRIP001 	aFont.SetCharSet( aOldFont.GetCharSet() );
//STRIP001 	aFont.SetLanguage( aOldFont.GetLanguage() );
//STRIP001 
//STRIP001 	if( !bTimeoutOnly && ( aLogo.GetType() != GRAPHIC_NONE ) )
//STRIP001 	{
//STRIP001 		Size aGrfSize;
//STRIP001 
//STRIP001 		if( aLogo.GetPrefMapMode() == MAP_PIXEL )
//STRIP001 			aGrfSize = PixelToLogic( aLogo.GetPrefSize() );
//STRIP001 		else
//STRIP001 			aGrfSize = LogicToLogic( aLogo.GetPrefSize(), aLogo.GetPrefMapMode(), rMap );
//STRIP001 
//STRIP001 		const Point	aGrfPos( Max( aOutOrg.X() + aOutSize.Width() - aGrfSize.Width() - aOffset.Width(), aOutOrg.X() ),
//STRIP001 							 Max( aOutOrg.Y() + aOutSize.Height() - aGrfSize.Height() - aOffset.Height(), aOutOrg.Y() ) );
//STRIP001 
//STRIP001 		if( aLogo.IsAnimated() )
//STRIP001 			aLogo.StartAnimation( this, aGrfPos, aGrfSize, (long) this );
//STRIP001 		else
//STRIP001 			aLogo.Draw( this, aGrfPos, aGrfSize );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( SLIDE_NO_TIMEOUT != nPauseTimeout )
//STRIP001 	{
//STRIP001 		MapMode			aVMap( rMap );
//STRIP001 		VirtualDevice	aVDev( *this );
//STRIP001 
//STRIP001 		aVMap.SetOrigin( Point() );
//STRIP001 		aVDev.SetMapMode( aVMap );
//STRIP001 		aVDev.SetBackground( Wallpaper( Color( COL_BLACK ) ) );
//STRIP001 		
//STRIP001 		// set font first, to determine real output height
//STRIP001 		aVDev.SetFont( aFont );
//STRIP001 			
//STRIP001 		const Size aVDevSize( aOutSize.Width(), aVDev.GetTextHeight() );
//STRIP001 
//STRIP001 		if( aVDev.SetOutputSize( aVDevSize ) )
//STRIP001 		{
//STRIP001 			// Note: if performance gets an issue here, we can use NumberFormatter directly
//STRIP001 			SvtSysLocale				aSysLocale;
//STRIP001 			const LocaleDataWrapper&    aLocaleData = aSysLocale.GetLocaleData();
//STRIP001 			
//STRIP001 			aText.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " ( " ));
//STRIP001 			aText += aLocaleData.getDuration( Time( 0, 0, nPauseTimeout ) );
//STRIP001 			aText.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " )" ));
//STRIP001 			aVDev.DrawText( Point( aOffset.Width(), 0 ), aText );
//STRIP001 			DrawOutDev( Point( aOutOrg.X(), aOffset.Height() ), aVDevSize, Point(), aVDevSize, aVDev );
//STRIP001 			bDrawn = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( !bDrawn )
//STRIP001 	{
//STRIP001 		SetFont( aFont );
//STRIP001 		DrawText( Point( aOutOrg.X() + aOffset.Width(), aOutOrg.Y() + aOffset.Height() ), aText );
//STRIP001 		SetFont( aOldFont );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdShowWindow::DrawEndScene()
//STRIP001 {
//STRIP001 	const Font		aOldFont( GetFont() );
//STRIP001 	Font			aFont( GetSettings().GetStyleSettings().GetMenuFont() );
//STRIP001 
//STRIP001 	const Point		aOutOrg( PixelToLogic( Point() ) );
//STRIP001 	const Size		aTextSize( LogicToLogic( Size( 0, SHOWWIN_FONTHEIGHT ), MAP_POINT, GetMapMode() ) );
//STRIP001 	const String	aText( SdResId( STR_PRES_SOFTEND ) );
//STRIP001 
//STRIP001 	aFont.SetSize( aTextSize );
//STRIP001 	aFont.SetColor( COL_WHITE );
//STRIP001 	aFont.SetCharSet( aOldFont.GetCharSet() );
//STRIP001 	aFont.SetLanguage( aOldFont.GetLanguage() );
//STRIP001 	SetFont( aFont );
//STRIP001 	DrawText( Point( aOutOrg.X() + aTextSize.Height(), aOutOrg.Y() + aTextSize.Height() ), aText );
//STRIP001 	SetFont( aOldFont );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdShowWindow::DrawBlankScene()
//STRIP001 {
//STRIP001     // just blank through background color => nothing to be done here
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SdShowWindow, PauseTimeoutHdl, Timer*, pTimer )
//STRIP001 {
//STRIP001 	if( !( --nPauseTimeout ) )
//STRIP001 		RestartShow();
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DrawPauseScene( TRUE );
//STRIP001 		pTimer->Start();
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 const int BORDER = 16;
//STRIP001 
//STRIP001 void SdShowWindow::DrawWaitIcon()
//STRIP001 {
//STRIP001 	const MapMode nOldMode = GetMapMode();
//STRIP001 	SetMapMode( MapMode(MAP_PIXEL) );
//STRIP001 
//STRIP001 	Size aOutputSize = GetOutputSizePixel();
//STRIP001 	Size aIconSize = aWaitIcon.GetSizePixel();
//STRIP001 
//STRIP001 	Point aPoint( BORDER, aOutputSize.Height() - aIconSize.Height() - BORDER );
//STRIP001 
//STRIP001 	aRestoreSpace = GetBitmap( aPoint, aIconSize );
//STRIP001 
//STRIP001 	DrawBitmapEx( aPoint, aWaitIcon );
//STRIP001 
//STRIP001 	SetMapMode( nOldMode );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdShowWindow::ClearWaitIcon()
//STRIP001 {
//STRIP001 	const MapMode nOldMode = GetMapMode();
//STRIP001 	SetMapMode( MapMode(MAP_PIXEL) );
//STRIP001 
//STRIP001 	Size aOutputSize = GetOutputSizePixel();
//STRIP001 	Size aIconSize = aWaitIcon.GetSizePixel();
//STRIP001 
//STRIP001 	Point aPoint( BORDER, aOutputSize.Height() - aIconSize.Height() - BORDER );
//STRIP001 
//STRIP001 	DrawBitmap( aPoint, aRestoreSpace );
//STRIP001 
//STRIP001 	SetMapMode( nOldMode );
//STRIP001 }


}
