/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviewse.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:39:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _COM_SUN_STAR_FORM_FORMBUTTONTYPE_HPP_
// auto strip #include <com/sun/star/form/FormButtonType.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
// auto strip #include <com/sun/star/beans/XPropertySet.hpp>
// auto strip #endif
#ifndef _COM_SUN_STAR_I18N_TRANSLITERATIONMODULES_HDL_
#include <com/sun/star/i18n/TransliterationModules.hdl>
#endif

// auto strip #ifndef _SV_WAITOBJ_HXX
// auto strip #include <vcl/waitobj.hxx>
// auto strip #endif

// auto strip #ifndef _AEITEM_HXX //autogen
// auto strip #include <svtools/aeitem.hxx>
// auto strip #endif
// auto strip #ifndef _EDITSTAT_HXX //autogen
// auto strip #include <bf_svx/editstat.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _URLBMK_HXX //autogen
// auto strip #include <svtools/urlbmk.hxx>
// auto strip #endif
// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_FMSHELL_HXX
// auto strip #include <bf_svx/fmshell.hxx>
// auto strip #endif
// auto strip #ifndef _SV_SCRBAR_HXX //autogen
// auto strip #include <vcl/scrbar.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOPATH_HXX //autogen
// auto strip #include <bf_svx/svdopath.hxx>
// auto strip #endif
// auto strip #ifndef _SVDUNDO_HXX //autogen
// auto strip #include <bf_svx/svdundo.hxx>
// auto strip #endif
// auto strip #ifndef _SVDORECT_HXX //autogen
// auto strip #include <bf_svx/svdorect.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOGRAF_HXX //autogen
// auto strip #include <bf_svx/svdograf.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
#ifndef _EEITEM_HXX //autogen
#include <bf_svx/eeitem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SFXVIEWFRM_HXX //autogen
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif

// auto strip #ifndef _PSTM_HXX
// auto strip #include <tools/pstm.hxx>
// auto strip #endif

// auto strip #ifndef _SFXPOOLITEM_HXX
// auto strip #include <svtools/poolitem.hxx>
// auto strip #endif

#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif

// auto strip #ifndef _DATE_HXX
// auto strip #include <tools/date.hxx>
// auto strip #endif

// auto strip #ifndef _TOOLS_TIME_HXX
// auto strip #include <tools/time.hxx>
// auto strip #endif

#define ITEMID_FIELD	EE_FEATURE_FIELD
// auto strip #ifndef _FLDITEM_HXX
// auto strip #include <bf_svx/flditem.hxx>
// auto strip #endif
// auto strip #ifndef _RULER_HXX
// auto strip #include <bf_svx/ruler.hxx>
// auto strip #endif
// auto strip #ifndef _OBJ3D_HXX
// auto strip #include <bf_svx/obj3d.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_FMGLOB_HXX
// auto strip #include <bf_svx/fmglob.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOUNO_HXX //autogen
// auto strip #include <bf_svx/svdouno.hxx>
// auto strip #endif
// auto strip #ifndef _URLOBJ_HXX //autogen
// auto strip #include <tools/urlobj.hxx>
// auto strip #endif
// auto strip #ifndef _SV_SOUND_HXX
// auto strip #include <vcl/sound.hxx>
// auto strip #endif

// #UndoRedo#
// auto strip #ifndef _SFXSLSTITM_HXX
// auto strip #include <svtools/slstitm.hxx>
// auto strip #endif

#pragma hdrstop

// auto strip #include <svtools/urihelper.hxx>
// auto strip #include <bf_sfx2/topfrm.hxx>

#include "app.hrc"
#include "glob.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
// auto strip #include "drawdoc.hxx"
#include "fusel.hxx"
//STRIP001#include "futext.hxx"
// auto strip #include "fuconrec.hxx"
// auto strip #include "fuconuno.hxx"
// auto strip #include "fuconbez.hxx"
// auto strip #include "fuediglu.hxx"
// auto strip #include "fuconarc.hxx"
// auto strip #include "fucon3d.hxx"
// auto strip #include "sdresid.hxx"
#include "fuslshow.hxx"
// auto strip #include "sdoutl.hxx"
// auto strip #include "drviewsh.hxx"
#include "presvish.hxx"
// auto strip #include "sdpage.hxx"
// auto strip #include "frmview.hxx"
// auto strip #include "zoomlist.hxx"
#include "drawview.hxx"
#include "docshell.hxx"
// auto strip #include "sdattr.hxx"

// #97016#
// auto strip #ifndef _SD_OPTSITEM_HXX
// auto strip #include "optsitem.hxx"
// auto strip #endif

// #98721#
// auto strip #ifndef _SVX_DATACCESSDESCRIPTOR_HXX_
// auto strip #include <bf_svx/dataaccessdescriptor.hxx>
// auto strip #endif
#include "so3/staticbaseurl.hxx"
namespace binfilter {

using namespace ::rtl;
using namespace ::com::sun::star;

#ifdef WNT
#pragma optimize ( "", off )
#endif

/*************************************************************************
|*
|* Permanente Funktionen
|*
\************************************************************************/

//STRIP001 void ImpAddPrintableCharactersToTextEdit(SfxRequest& rReq, SdView* pView)
//STRIP001 {
//STRIP001 	// #98198# evtl. feed characters to activated textedit
//STRIP001 	const SfxItemSet* pSet = rReq.GetArgs();
//STRIP001 
//STRIP001 	if(pSet)
//STRIP001 	{
//STRIP001 		String aInputString;
//STRIP001 		
//STRIP001 		if(SFX_ITEM_SET == pSet->GetItemState(SID_ATTR_CHAR))
//STRIP001 			aInputString = ((SfxStringItem&)pSet->Get(SID_ATTR_CHAR)).GetValue();
//STRIP001 
//STRIP001 		if(aInputString.Len())
//STRIP001 		{
//STRIP001 			OutlinerView* pOLV = pView->GetTextEditOutlinerView();
//STRIP001 
//STRIP001 			if(pOLV)
//STRIP001 			{
//STRIP001 				for(sal_uInt16 a(0); a < aInputString.Len(); a++)
//STRIP001 				{
//STRIP001 					sal_Char aChar = aInputString.GetChar(a);
//STRIP001 					KeyCode aKeyCode;
//STRIP001 					KeyEvent aKeyEvent(aChar, aKeyCode);
//STRIP001 					
//STRIP001 					// add actual character
//STRIP001 					pOLV->PostKeyEvent(aKeyEvent);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*N*/ void SdDrawViewShell::FuPermanent(SfxRequest& rReq)
/*N*/ {
/*N*/ 	// Waehrend einer Native-Diashow wird nichts ausgefuehrt!
/*?*/ 	if (pFuSlideShow && !pFuSlideShow->IsLivePresentation())
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 return;
/*N*/ 
/*N*/ 	USHORT nSId = rReq.GetSlot();
/*N*/ 
/*N*/ 	if( pFuActual && //STRIP001 pFuActual->ISA(FuText) &&
/*N*/ 		( nSId == SID_TEXTEDIT || nSId == SID_ATTR_CHAR || nSId == SID_TEXT_FITTOSIZE ||
/*N*/ 		  nSId == SID_ATTR_CHAR_VERTICAL || nSId == SID_TEXT_FITTOSIZE_VERTICAL ) )
/*N*/ 	{
/*N*/       DBG_ASSERT(0,"STRIP!");//STRIP001 ((FuText*) pFuActual)->SetPermanent(TRUE);
//STRIP001 /*?*/ 		pFuActual->ReceiveRequest( rReq );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		MapSlot( nSId );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		Invalidate();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		Invalidate();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		// #98198# evtl. feed characters to activated textedit
//STRIP001 /*?*/ 		if(SID_ATTR_CHAR == nSId && pView && pView->IsTextEdit())
//STRIP001 /*?*/ 			ImpAddPrintableCharactersToTextEdit(rReq, pView);
//STRIP001 /*?*/ 		
//STRIP001 /*?*/ 		rReq.Done();
//STRIP001 /*?*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	CheckLineTo (rReq);
/*N*/     USHORT nOldSId = 0;
/*N*/     BOOL bPermanent = FALSE;
/*N*/ 
/*N*/ 	if (pFuActual)
/*N*/ 	{
/*?*/ 		if (pFuOld == pFuActual)
/*?*/ 		{
/*?*/ 			pFuOld = NULL;
/*?*/ 		}
/*?*/ 
/*?*/ 		if ( nSId != SID_TEXTEDIT && nSId != SID_ATTR_CHAR && nSId != SID_TEXT_FITTOSIZE &&
/*?*/ 			 nSId != SID_ATTR_CHAR_VERTICAL && nSId != SID_TEXT_FITTOSIZE_VERTICAL &&
/*?*/ 			 pDrView->IsTextEdit() )
/*?*/ 		{
/*?*/ 			pDrView->EndTextEdit();
/*?*/ 		}
/*?*/ 
/*?*/         nOldSId = pFuActual->GetSlotID();
/*?*/ 
/*?*/         if (nOldSId == nSId ||
/*?*/             ((nOldSId == SID_TEXTEDIT || nOldSId == SID_ATTR_CHAR || nOldSId == SID_TEXT_FITTOSIZE ||
/*?*/ 			  nOldSId == SID_ATTR_CHAR_VERTICAL || nOldSId == SID_TEXT_FITTOSIZE_VERTICAL) &&
/*?*/              (nSId == SID_TEXTEDIT || nSId == SID_ATTR_CHAR || nSId == SID_TEXT_FITTOSIZE ||
/*?*/ 			  nSId == SID_ATTR_CHAR_VERTICAL || nSId == SID_TEXT_FITTOSIZE_VERTICAL )))
/*?*/         {
/*?*/             bPermanent = TRUE;
/*?*/         }
/*?*/ 
/*?*/ 		pFuActual->Deactivate();
/*?*/ 		delete pFuActual;
/*?*/ 		pFuActual = NULL;
/*?*/ 
/*?*/ 		SfxBindings& rBind = GetViewFrame()->GetBindings();
/*?*/         rBind.Invalidate(nOldSId);
/*?*/         rBind.Update(nOldSId);
/*N*/ 	}
/*N*/ 
/*N*/ 	// Slot wird gemapped (ToolboxImages/-Slots)
/*N*/ 	MapSlot( nSId );
/*N*/ 
/*N*/     switch ( nSId )
/*N*/ 	{
/*?*/  		case SID_TEXTEDIT:	// BASIC ???
/*?*/  		case SID_ATTR_CHAR:
/*?*/  		case SID_ATTR_CHAR_VERTICAL:
/*?*/  		case SID_TEXT_FITTOSIZE:
/*?*/  		case SID_TEXT_FITTOSIZE_VERTICAL:
/*?*/  		{
/*?*/  			DBG_ASSERT(0,"STRIP!");//STRIP001 pFuActual = new FuText(this, pWindow, pDrView, pDoc, rReq);
//STRIP001 /*?*/  			( (FuText*) pFuActual)->DoExecute();
//STRIP001 /*?*/              // Das Setzen des Permanent-Status erfolgt weiter oben!
//STRIP001 /*?*/  
//STRIP001 /*?*/  			SfxBindings& rBindings = GetViewFrame()->GetBindings();
//STRIP001 /*?*/  			rBindings.Invalidate( SID_ATTR_CHAR );
//STRIP001 /*?*/  			rBindings.Invalidate( SID_ATTR_CHAR_VERTICAL );
//STRIP001 /*?*/ 			rBindings.Invalidate( SID_TEXT_FITTOSIZE );
//STRIP001 /*?*/ 			rBindings.Invalidate( SID_TEXT_FITTOSIZE_VERTICAL );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			// #98198# evtl. feed characters to activated textedit
//STRIP001 /*?*/ 			if(SID_ATTR_CHAR == nSId && pView && pView->IsTextEdit())
//STRIP001 /*?*/ 				ImpAddPrintableCharactersToTextEdit(rReq, pView);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			rReq.Done();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_FM_CREATE_CONTROL:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuConstUnoControl(this, pWindow, pDrView, pDoc, rReq);
//STRIP001 /*?*/             ((FuConstUnoControl*) pFuActual)->SetPermanent(bPermanent);
//STRIP001 /*?*/ 			rReq.Done();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		// #98721#
/*?*/ 		case SID_FM_CREATE_FIELDCONTROL:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SFX_REQUEST_ARG( rReq, pDescriptorItem, SfxUnoAnyItem, SID_FM_DATACCESS_DESCRIPTOR, sal_False );
//STRIP001 /*?*/ 			DBG_ASSERT( pDescriptorItem, "SdDrawViewShell::FuPermanent(SID_FM_CREATE_FIELDCONTROL): invalid request args!" );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if(pDescriptorItem)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				// get the form view
//STRIP001 /*?*/ 				FmFormView* pFormView = PTR_CAST(FmFormView, pDrView);
//STRIP001 /*?*/ 				SdrPageView* pPageView = pFormView ? pFormView->GetPageViewPvNum(0) : NULL;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if(pPageView)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					::svx::ODataAccessDescriptor aDescriptor(pDescriptorItem->GetValue());
//STRIP001 /*?*/ 					SdrObject* pNewDBField = pFormView->CreateFieldControl(aDescriptor);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if(pNewDBField)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						Rectangle aVisArea = pWindow->PixelToLogic(Rectangle(Point(0,0), pWindow->GetOutputSizePixel()));
//STRIP001 /*?*/ 						Point aObjPos(aVisArea.Center());
//STRIP001 /*?*/ 						Size aObjSize(pNewDBField->GetLogicRect().GetSize());
//STRIP001 /*?*/ 						aObjPos.X() -= aObjSize.Width() / 2;
//STRIP001 /*?*/ 						aObjPos.Y() -= aObjSize.Height() / 2;
//STRIP001 /*?*/ 						Rectangle aNewObjectRectangle(aObjPos, aObjSize);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						pNewDBField->SetLogicRect(aNewObjectRectangle);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						pView->InsertObject(pNewDBField, *pPageView, pView->IsSolidDraggingNow() ? SDRINSERT_NOBROADCAST : 0);
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			rReq.Done();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_SELECT:
/*?*/ 		case SID_OBJECT_ROTATE:
/*?*/ 		case SID_OBJECT_MIRROR:
/*?*/ 		case SID_OBJECT_TRANSPARENCE:
/*?*/ 		case SID_OBJECT_GRADIENT:
/*?*/ 		case SID_OBJECT_SHEAR:
/*?*/ 		case SID_OBJECT_CROOK_ROTATE:
/*?*/ 		case SID_OBJECT_CROOK_SLANT:
/*?*/ 		case SID_OBJECT_CROOK_STRETCH:
/*N*/         case SID_CONVERT_TO_3D_LATHE:
/*N*/ 		{
/*N*/ 			short nSlotId = rReq.GetSlot();
/*N*/ 
/*N*/ 			if (nSlotId == SID_OBJECT_CROOK_ROTATE ||
/*N*/ 				nSlotId == SID_OBJECT_CROOK_SLANT ||
/*N*/ 				nSlotId == SID_OBJECT_CROOK_STRETCH)
/*N*/ 			{
/*?*/  				if ( pDrView->GetMarkList().GetMarkCount() > 0 &&
/*?*/  				    !pDrView->IsCrookAllowed( pDrView->IsCrookNoContortion() ) )
/*?*/  				{
/*?*/  					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsPresObjSelected() )
//STRIP001 /*?*/  					{
//STRIP001 /*?*/                          InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE) ) ).Execute();
//STRIP001 /*?*/  					}
//STRIP001 /*?*/  					else if ( QueryBox(pWindow, WB_YES_NO,
//STRIP001 /*?*/                                        String(SdResId(STR_ASK_FOR_CONVERT_TO_BEZIER) )
//STRIP001 /*?*/  									  ).Execute() == RET_YES )
//STRIP001 /*?*/  					{
//STRIP001 /*?*/  						// Implizite Wandlung in Bezier
//STRIP001 /*?*/                          WaitObject aWait( (Window*)GetActiveWindow() );
//STRIP001 /*?*/  						pDrView->ConvertMarkedToPathObj(FALSE);
//STRIP001 /*?*/  					}
/*?*/  				}
/*N*/  			}
/*N*/  			else if (nSlotId == SID_OBJECT_SHEAR)
/*N*/  			{
/*?*/                  DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ULONG i = 0;
//STRIP001 /*?*/                  const SdrMarkList& rMarkList = pDrView->GetMarkList();
//STRIP001 /*?*/                  ULONG nMarkCnt = rMarkList.GetMarkCount();
//STRIP001 /*?*/                  BOOL b3DObjMarked = FALSE;
//STRIP001 /*?*/  
//STRIP001 /*?*/                  while (i < nMarkCnt && !b3DObjMarked)
//STRIP001 /*?*/                  {
//STRIP001 /*?*/                      if (rMarkList.GetMark(i)->GetObj()->ISA(E3dObject))
//STRIP001 /*?*/                      {
//STRIP001 /*?*/                          b3DObjMarked = TRUE;
//STRIP001 /*?*/                      }
//STRIP001 /*?*/                      else
//STRIP001 /*?*/                      {
//STRIP001 /*?*/                          i++;
//STRIP001 /*?*/                      }
//STRIP001 /*?*/                  }
//STRIP001 /*?*/  
//STRIP001 /*?*/                  if ( nMarkCnt > 0 && !b3DObjMarked &&
//STRIP001 /*?*/                       (!pDrView->IsShearAllowed() || !pDrView->IsDistortAllowed()) )
//STRIP001 /*?*/  				{
//STRIP001 /*?*/  					if ( pDrView->IsPresObjSelected() )
//STRIP001 /*?*/  					{
//STRIP001 /*?*/                          InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE) ) ).Execute();
//STRIP001 /*?*/  					}
//STRIP001 /*?*/  					else if ( QueryBox(pWindow, WB_YES_NO,
//STRIP001 /*?*/                                        String(SdResId(STR_ASK_FOR_CONVERT_TO_BEZIER) )
//STRIP001 /*?*/  									  ).Execute() == RET_YES )
//STRIP001 /*?*/  					{
//STRIP001 /*?*/  						// Implizite Wandlung in Bezier
//STRIP001 /*?*/                          WaitObject aWait( (Window*)GetActiveWindow() );
//STRIP001 /*?*/  						pDrView->ConvertMarkedToPathObj(FALSE);
//STRIP001 /*?*/  					}
//STRIP001 /*?*/  				}
/*N*/  			}
/*N*/ 
/*N*/ 			pFuActual = new FuSelection(this, pWindow, pDrView,
/*N*/ 											  pDoc, rReq);
/*N*/ 
/*N*/ 			rReq.Done();
/*N*/ 			Invalidate( SID_OBJECT_SELECT );
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*?*/ 		case SID_DRAW_LINE:
/*?*/ 		case SID_DRAW_XLINE:
/*?*/         case SID_DRAW_MEASURELINE:
/*?*/ 		case SID_LINE_ARROW_START:
/*?*/ 		case SID_LINE_ARROW_END:
/*?*/ 		case SID_LINE_ARROWS:
/*?*/ 		case SID_LINE_ARROW_CIRCLE:
/*?*/ 		case SID_LINE_CIRCLE_ARROW:
/*?*/ 		case SID_LINE_ARROW_SQUARE:
/*?*/ 		case SID_LINE_SQUARE_ARROW:
/*?*/ 
/*?*/ 		case SID_DRAW_RECT:
/*?*/ 		case SID_DRAW_RECT_NOFILL:
/*?*/ 		case SID_DRAW_RECT_ROUND:
/*?*/ 		case SID_DRAW_RECT_ROUND_NOFILL:
/*?*/ 		case SID_DRAW_SQUARE:
/*?*/ 		case SID_DRAW_SQUARE_NOFILL:
/*?*/ 		case SID_DRAW_SQUARE_ROUND:
/*?*/ 		case SID_DRAW_SQUARE_ROUND_NOFILL:
/*?*/ 		case SID_DRAW_ELLIPSE:
/*?*/ 		case SID_DRAW_ELLIPSE_NOFILL:
/*?*/ 		case SID_DRAW_CIRCLE:
/*?*/ 		case SID_DRAW_CIRCLE_NOFILL:
/*?*/ 		case SID_DRAW_CAPTION:
/*?*/ 		case SID_DRAW_CAPTION_VERTICAL:
/*?*/ 		case SID_TOOL_CONNECTOR:
/*?*/         case SID_CONNECTOR_ARROW_START:
/*?*/         case SID_CONNECTOR_ARROW_END:
/*?*/         case SID_CONNECTOR_ARROWS:
/*?*/         case SID_CONNECTOR_CIRCLE_START:
/*?*/         case SID_CONNECTOR_CIRCLE_END:
/*?*/         case SID_CONNECTOR_CIRCLES:
/*?*/         case SID_CONNECTOR_LINE:
/*?*/         case SID_CONNECTOR_LINE_ARROW_START:
/*?*/         case SID_CONNECTOR_LINE_ARROW_END:
/*?*/         case SID_CONNECTOR_LINE_ARROWS:
/*?*/         case SID_CONNECTOR_LINE_CIRCLE_START:
/*?*/         case SID_CONNECTOR_LINE_CIRCLE_END:
/*?*/         case SID_CONNECTOR_LINE_CIRCLES:
/*?*/         case SID_CONNECTOR_CURVE:
/*?*/         case SID_CONNECTOR_CURVE_ARROW_START:
/*?*/         case SID_CONNECTOR_CURVE_ARROW_END:
/*?*/         case SID_CONNECTOR_CURVE_ARROWS:
/*?*/         case SID_CONNECTOR_CURVE_CIRCLE_START:
/*?*/         case SID_CONNECTOR_CURVE_CIRCLE_END:
/*?*/         case SID_CONNECTOR_CURVE_CIRCLES:
/*?*/         case SID_CONNECTOR_LINES:
/*?*/         case SID_CONNECTOR_LINES_ARROW_START:
/*?*/         case SID_CONNECTOR_LINES_ARROW_END:
/*?*/         case SID_CONNECTOR_LINES_ARROWS:
/*?*/         case SID_CONNECTOR_LINES_CIRCLE_START:
/*?*/         case SID_CONNECTOR_LINES_CIRCLE_END:
/*?*/         case SID_CONNECTOR_LINES_CIRCLES:
/*?*/         {
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuConstRectangle(this, pWindow, pDrView,
//STRIP001 /*?*/ 												   pDoc, rReq);
//STRIP001 /*?*/             ((FuConstRectangle*) pFuActual)->SetPermanent(bPermanent);
//STRIP001 /*?*/ 
//STRIP001 /*?*/             rReq.Done();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_DRAW_POLYGON:
/*?*/ 		case SID_DRAW_POLYGON_NOFILL:
/*?*/ 		case SID_DRAW_XPOLYGON:
/*?*/ 		case SID_DRAW_XPOLYGON_NOFILL:
/*?*/         case SID_DRAW_FREELINE:
/*?*/         case SID_DRAW_FREELINE_NOFILL:
/*?*/         case SID_DRAW_BEZIER_FILL:          // BASIC
/*?*/         case SID_DRAW_BEZIER_NOFILL:        // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuConstBezPoly(this, pWindow, pDrView,
//STRIP001 /*?*/ 												 pDoc, rReq);
//STRIP001 /*?*/             ((FuConstBezPoly*) pFuActual)->SetPermanent(bPermanent);
//STRIP001 /*?*/             rReq.Done();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/         case SID_GLUE_EDITMODE:
/*?*/ 		{
/*?*/             if (nOldSId != SID_GLUE_EDITMODE)
/*?*/             {
/*?*/                 DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuEditGluePoints( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/                 ((FuEditGluePoints*) pFuActual)->SetPermanent(bPermanent);
/*?*/             }
/*?*/             else
/*?*/             {
/*?*/ 				GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON);
/*?*/             }
/*?*/ 
/*?*/ 			rReq.Done();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_DRAW_ARC:
/*?*/ 		case SID_DRAW_CIRCLEARC:
/*?*/ 		case SID_DRAW_PIE:
/*?*/ 		case SID_DRAW_PIE_NOFILL:
/*?*/ 		case SID_DRAW_CIRCLEPIE:
/*?*/ 		case SID_DRAW_CIRCLEPIE_NOFILL:
/*?*/ 		case SID_DRAW_ELLIPSECUT:
/*?*/ 		case SID_DRAW_ELLIPSECUT_NOFILL:
/*?*/ 		case SID_DRAW_CIRCLECUT:
/*?*/ 		case SID_DRAW_CIRCLECUT_NOFILL:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuConstArc( this, pWindow, pDrView, pDoc, rReq);
//STRIP001 /*?*/ 			((FuConstArc*) pFuActual)->SetPermanent(bPermanent);
//STRIP001 /*?*/             rReq.Done();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_3D_CUBE:
/*?*/ 		case SID_3D_SHELL:
/*?*/ 		case SID_3D_SPHERE:
/*?*/ 		case SID_3D_TORUS:
/*?*/ 		case SID_3D_HALF_SPHERE:
/*?*/ 		case SID_3D_CYLINDER:
/*?*/ 		case SID_3D_CONE:
/*?*/ 		case SID_3D_PYRAMID:
/*?*/ 		{
/*?*/ 			DBG_ASSERT(0,"STRIP!"); //STRIP001 pFuActual = new FuConst3dObj(this, pWindow, pDrView, pDoc, rReq);
//STRIP001 /*?*/             ((FuConst3dObj*) pFuActual)->SetPermanent(bPermanent);
//STRIP001 /*?*/             rReq.Done();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		default:
/*?*/ 		break;
/*?*/ 	}
/*N*/  
/*N*/  	if (pFuOld)
/*N*/  	{
/*?*/   		USHORT nSId = pFuOld->GetSlotID();
/*?*/   
/*?*/   		pFuOld->Deactivate();
/*?*/   		delete pFuOld;
/*?*/   		pFuOld = NULL;
/*?*/   
/*?*/   		SfxBindings& rBind = GetViewFrame()->GetBindings();
/*?*/   		rBind.Invalidate( nSId );
/*?*/   		rBind.Update( nSId );
/*?*/  	}
/*N*/  
/*N*/  	if (pFuActual)
/*N*/  	{
/*N*/  		pFuActual->Activate();
/*N*/  		pFuOld = pFuActual;
/*N*/  
/*N*/  		SetHelpId( pFuActual->GetSlotID() );
/*N*/  	}
/*N*/ 
/*N*/ 	// Shell wird invalidiert, schneller als einzeln (laut MI)
/*N*/ 	// Jetzt explizit der letzte Slot incl. Update()
/*N*/ 	Invalidate();
/*N*/ 
/*N*/ 	// #97016# III CTRL-SID_OBJECT_SELECT -> select first draw object if none is selected yet
/*N*/ 	if(SID_OBJECT_SELECT == nSId && pFuActual && (rReq.GetModifier() & KEY_MOD1))
/*N*/ 	{
/*N*/ 		if(!pView->HasMarkedObj())
/*N*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 // select first object
//STRIP001 /*?*/ 			pView->UnmarkAllObj();
//STRIP001 /*?*/ 			pView->MarkNextObj(TRUE);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			// ...and make it visible
//STRIP001 /*?*/ 			if(pView->HasMarkedObj())
//STRIP001 /*?*/ 				{DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 pView->MakeVisible(pView->GetAllMarkedRect(), *pWindow);
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	// #97016# with qualifier construct directly
/*N*/ 	if(pFuActual && (rReq.GetModifier() & KEY_MOD1))
/*N*/ 	{
		// get SdOptions
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SdOptions* pOptions = SD_MOD()->GetSdOptions(pDoc->GetDocumentType());
//STRIP001 /*?*/ 		sal_uInt32 nDefaultObjectSizeWidth(pOptions->GetDefaultObjectSizeWidth());
//STRIP001 /*?*/ 		sal_uInt32 nDefaultObjectSizeHeight(pOptions->GetDefaultObjectSizeHeight());
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		// calc position and size
//STRIP001 /*?*/ 		Rectangle aVisArea = pWindow->PixelToLogic(Rectangle(Point(0,0), pWindow->GetOutputSizePixel()));
//STRIP001 /*?*/ 		Point aPagePos = aVisArea.Center();
//STRIP001 /*?*/ 		aPagePos.X() -= nDefaultObjectSizeWidth / 2;
//STRIP001 /*?*/ 		aPagePos.Y() -= nDefaultObjectSizeHeight / 2;
//STRIP001 /*?*/ 		Rectangle aNewObjectRectangle(aPagePos, Size(nDefaultObjectSizeWidth, nDefaultObjectSizeHeight));
//STRIP001 /*?*/ 		SdrPageView* pPageView = pDrView->GetPageViewPvNum(0);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if(pPageView)
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			// create the default object
//STRIP001 /*?*/ 			SdrObject* pObj = pFuActual->CreateDefaultObject(nSId, aNewObjectRectangle);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if(pObj)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				// insert into page
//STRIP001 /*?*/ 				pView->InsertObject(pObj, *pPageView, pView->IsSolidDraggingNow() ? SDRINSERT_NOBROADCAST : 0);
//STRIP001 /*?*/ 
//STRIP001 /*?*/                 // Now that pFuActual has done what it was created for we
//STRIP001 /*?*/                 // can switch on the edit mode for callout objects.
//STRIP001 /*?*/                 switch (nSId)
//STRIP001 /*?*/                 {
//STRIP001 /*?*/                     case SID_DRAW_CAPTION:
//STRIP001 /*?*/                     case SID_DRAW_CAPTION_VERTICAL:
//STRIP001 /*?*/                     {
//STRIP001 /*?*/                         // Make FuText the current function.
//STRIP001 /*?*/                         SfxUInt16Item aItem (SID_TEXTEDIT, 1);
//STRIP001 /*?*/                         GetViewFrame()->GetDispatcher()->
//STRIP001 /*?*/                             Execute(SID_TEXTEDIT, SFX_CALLMODE_SYNCHRON |
//STRIP001 /*?*/                                 SFX_CALLMODE_RECORD, &aItem, 0L);
//STRIP001 /*?*/                         // Put text object into edit mode.
//STRIP001 /*?*/                         pView->BegTextEdit (reinterpret_cast<SdrTextObj*>(pObj), pPageView);
//STRIP001 /*?*/                         break;
//STRIP001 /*?*/                     }
//STRIP001 /*?*/                 }
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
/*?*/ 	}
/*N*/ }

//////////////////////////////////////////////////////////////////////////////
// service routine for Undo/Redo implementation
//STRIP001 extern SfxUndoManager* ImpGetUndoManagerFromViewShell(SdDrawViewShell& rDViewShell);

/*************************************************************************
|*
|* SfxRequests fuer Support-Funktionen
|*
\************************************************************************/

//STRIP001 void SdDrawViewShell::FuSupport(SfxRequest& rReq)
//STRIP001 {
//STRIP001 	if( rReq.GetSlot() == SID_STYLE_FAMILY && rReq.GetArgs())
//STRIP001 		pDocSh->SetStyleFamily(((SfxUInt16Item&)rReq.GetArgs()->Get( SID_STYLE_FAMILY )).GetValue());
//STRIP001 
//STRIP001 	// Waehrend einer Native-Diashow wird nichts ausgefuehrt!
//STRIP001 	if (pFuSlideShow && !pFuSlideShow->IsLivePresentation() &&
//STRIP001 		(rReq.GetSlot() != SID_PRESENTATION_END &&
//STRIP001          rReq.GetSlot() != SID_LIVE_PRESENTATION &&
//STRIP001          rReq.GetSlot() != SID_SIZE_PAGE))
//STRIP001 		return;
//STRIP001 
//STRIP001 	CheckLineTo (rReq);
//STRIP001 
//STRIP001 	USHORT nSId = rReq.GetSlot();
//STRIP001 
//STRIP001 	// Slot wird evtl. gemapped (ToolboxImages/-Slots)
//STRIP001 	MapSlot( nSId );
//STRIP001 
//STRIP001 	switch ( nSId )
//STRIP001 	{
//STRIP001         // Slots der ToolboxController gemapped ausfuehren
//STRIP001         case SID_OBJECT_CHOOSE_MODE:
//STRIP001         case SID_POSITION:
//STRIP001         case SID_OBJECT_ALIGN:
//STRIP001         case SID_ZOOM_TOOLBOX:
//STRIP001         case SID_DRAWTBX_TEXT:
//STRIP001         case SID_DRAWTBX_RECTANGLES:
//STRIP001         case SID_DRAWTBX_ELLIPSES:
//STRIP001         case SID_DRAWTBX_LINES:
//STRIP001         case SID_DRAWTBX_ARROWS:
//STRIP001         case SID_DRAWTBX_3D_OBJECTS:
//STRIP001         case SID_DRAWTBX_CONNECTORS:
//STRIP001         case SID_DRAWTBX_INSERT:
//STRIP001         {
//STRIP001             USHORT nMappedSlot = GetMappedSlot( nSId );
//STRIP001             if( nMappedSlot > 0 )
//STRIP001             {
//STRIP001                 SfxRequest aReq( nMappedSlot, 0, pDoc->GetItemPool() );
//STRIP001                 ExecuteSlot( aReq );
//STRIP001             }
//STRIP001         }
//STRIP001         break;
//STRIP001 
//STRIP001 		case SID_PRESENTATION:
//STRIP001 		case SID_REHEARSE_TIMINGS:
//STRIP001 		{
//STRIP001 			if( !pFuSlideShow )
//STRIP001 			{
//STRIP001 				if( pDrView->IsTextEdit() )
//STRIP001 					pDrView->EndTextEdit();
//STRIP001 
//STRIP001                 SFX_REQUEST_ARG( rReq, pFullScreen, SfxBoolItem, ATTR_PRESENT_FULLSCREEN, FALSE );
//STRIP001                 const BOOL bFullScreen = ( ( SID_REHEARSE_TIMINGS != rReq.GetSlot() ) && pFullScreen ) ? pFullScreen->GetValue() : pDoc->GetPresFullScreen();
//STRIP001 
//STRIP001                 if( bFullScreen )
//STRIP001                     SdPresViewShell::CreateFullScreenShow( this, rReq );
//STRIP001                 else
//STRIP001                 {
//STRIP001 				    pFuSlideShow = new FuSlideShow( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 				    pFuSlideShow->StartShow();
//STRIP001 				    pFuSlideShow->Activate();
//STRIP001                 }
//STRIP001 			}
//STRIP001 
//STRIP001 			rReq.Ignore ();
//STRIP001         }
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_PRESENTATION_END:
//STRIP001 		{
//STRIP001 			if( pFuSlideShow )
//STRIP001 			{
//STRIP001 				if( pDrView->IsTextEdit() )
//STRIP001 					pDrView->EndTextEdit();
//STRIP001 
//STRIP001 				pFuSlideShow->Deactivate();
//STRIP001 				pFuSlideShow->Destroy();
//STRIP001 				pFuSlideShow = NULL;
//STRIP001 
//STRIP001                 if( ISA( SdPresViewShell ) )
//STRIP001                     GetViewFrame()->GetDispatcher()->Execute( SID_CLOSEWIN, SFX_CALLMODE_ASYNCHRON );
//STRIP001                 else if( pFrameView->GetPresentationViewShellId() != SID_VIEWSHELL0 )
//STRIP001                 {
//STRIP001                     const USHORT nRestoreViewShellId = pFrameView->GetPresentationViewShellId();
//STRIP001 
//STRIP001                     pFrameView->SetPresentationViewShellId(SID_VIEWSHELL0);
//STRIP001 	    			pFrameView->SetSlotId(SID_OBJECT_SELECT);
//STRIP001                     GetViewFrame()->GetDispatcher()->Execute( nRestoreViewShellId, SFX_CALLMODE_ASYNCHRON );
//STRIP001                 }
//STRIP001 			}
//STRIP001 
//STRIP001             rReq.Ignore ();
//STRIP001 			GetViewFrame()->GetBindings().InvalidateAll( TRUE );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_LIVE_PRESENTATION:
//STRIP001 		{
//STRIP001 			if( pFuSlideShow && !pFuSlideShow->IsInputLocked() )
//STRIP001 			{
//STRIP001 				if (pDrView->IsTextEdit())
//STRIP001 				{
//STRIP001 					pDrView->EndTextEdit();
//STRIP001 				}
//STRIP001 
//STRIP001 				pFuSlideShow->ReceiveRequest(rReq);
//STRIP001 			}
//STRIP001 			rReq.Ignore ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001         case SID_BEZIER_EDIT:
//STRIP001 		{
//STRIP001             pDrView->SetFrameDragSingles(!pDrView->IsFrameDragSingles());
//STRIP001 
//STRIP001             /******************************************************************
//STRIP001             * ObjectBar einschalten
//STRIP001             ******************************************************************/
//STRIP001             if (pFuActual &&
//STRIP001                 (pFuActual->ISA(FuSelection) || pFuActual->ISA(FuConstBezPoly)))
//STRIP001             {
//STRIP001                 USHORT nObjBarId = RID_DRAW_OBJ_TOOLBOX;
//STRIP001 
//STRIP001                 if (pDrView->HasMarkablePoints())
//STRIP001                 {
//STRIP001                     nObjBarId = RID_BEZIER_TOOLBOX;
//STRIP001                 }
//STRIP001 
//STRIP001                 SwitchObjectBar(nObjBarId);
//STRIP001             }
//STRIP001 
//STRIP001             Invalidate(SID_BEZIER_EDIT);
//STRIP001             rReq.Ignore();
//STRIP001         }
//STRIP001         break;
//STRIP001 
//STRIP001 		case SID_OBJECT_CLOSE:
//STRIP001 		{
//STRIP001 			const SdrMarkList& rMarkList = pDrView->GetMarkList();
//STRIP001 			if ( rMarkList.GetMark(0) && !pDrView->IsAction() )
//STRIP001 			{
//STRIP001 				SdrPathObj* pPathObj = (SdrPathObj*) rMarkList.GetMark(0)->GetObj();
//STRIP001                 pDrView->BegUndo(String(SdResId(STR_UNDO_BEZCLOSE)));
//STRIP001 				pDrView->UnmarkAllPoints();
//STRIP001 				Size aDist(pWindow->PixelToLogic(Size(8,8)));
//STRIP001 				pDrView->AddUndo(new SdrUndoGeoObj(*pPathObj));
//STRIP001 				pPathObj->ToggleClosed(aDist.Width());
//STRIP001 				pDrView->EndUndo();
//STRIP001 			}
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_CUT:
//STRIP001 		{
//STRIP001 			if ( pDrView->IsPresObjSelected(FALSE, TRUE) )
//STRIP001 			{
//STRIP001                 InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE) ) ).Execute();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if (pFuActual)		pFuActual->DoCut();
//STRIP001 				else if (pDrView)	pDrView->DoCut();
//STRIP001 			}
//STRIP001 			rReq.Ignore ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_COPY:
//STRIP001 		{
//STRIP001 			if ( pDrView->IsPresObjSelected(FALSE, TRUE) )
//STRIP001 			{
//STRIP001                 InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE) ) ).Execute();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if (pFuActual)
//STRIP001 					pFuActual->DoCopy();
//STRIP001 				else
//STRIP001 					pDrView->DoCopy();
//STRIP001 			}
//STRIP001 			rReq.Ignore ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_PASTE:
//STRIP001 		{
//STRIP001 			WaitObject aWait( (Window*)GetActiveWindow() );
//STRIP001 
//STRIP001 			if (pFuActual)		pFuActual->DoPaste();
//STRIP001 			else if (pDrView)	pDrView->DoPaste();
//STRIP001 
//STRIP001 			rReq.Ignore ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001         case SID_CLIPBOARD_FORMAT_ITEMS:
//STRIP001         {
//STRIP001 			WaitObject              aWait( (Window*)GetActiveWindow() );
//STRIP001 	        TransferableDataHelper  aDataHelper( TransferableDataHelper::CreateFromSystemClipboard( GetActiveWindow() ) );
//STRIP001             const SfxItemSet*       pReqArgs = rReq.GetArgs();
//STRIP001             UINT32                  nFormat = 0;
//STRIP001 
//STRIP001             if( pReqArgs )
//STRIP001             {
//STRIP001                 SFX_REQUEST_ARG( rReq, pIsActive, SfxUInt32Item, SID_CLIPBOARD_FORMAT_ITEMS, FALSE );
//STRIP001                 nFormat = pIsActive->GetValue();
//STRIP001             }
//STRIP001 
//STRIP001 
//STRIP001 	        if( nFormat && aDataHelper.GetTransferable().is() )
//STRIP001 	        {
//STRIP001 		        sal_Int8 nAction = DND_ACTION_COPY;
//STRIP001 
//STRIP001                 if( !pDrView->InsertData( aDataHelper,
//STRIP001 						                  pWindow->PixelToLogic( Rectangle( Point(), pWindow->GetOutputSizePixel() ).Center() ),
//STRIP001 						                  nAction, FALSE, nFormat ) )
//STRIP001                 {
//STRIP001     		        String		    aEmptyStr;
//STRIP001 			        INetBookmark    aINetBookmark( aEmptyStr, aEmptyStr );
//STRIP001 
//STRIP001 			        if( ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK ) &&
//STRIP001 				          aDataHelper.GetINetBookmark( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK, aINetBookmark ) ) ||
//STRIP001 				        ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_FILEGRPDESCRIPTOR ) &&
//STRIP001 				          aDataHelper.GetINetBookmark( SOT_FORMATSTR_ID_FILEGRPDESCRIPTOR, aINetBookmark ) ) ||
//STRIP001 				        ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_UNIFORMRESOURCELOCATOR ) &&
//STRIP001 				          aDataHelper.GetINetBookmark( SOT_FORMATSTR_ID_UNIFORMRESOURCELOCATOR, aINetBookmark ) ) )
//STRIP001 			        {
//STRIP001 				        InsertURLField( aINetBookmark.GetURL(), aINetBookmark.GetDescription(), aEmptyStr, NULL );
//STRIP001 			        }
//STRIP001                 }
//STRIP001 	        }
//STRIP001         }
//STRIP001         break;
//STRIP001 
//STRIP001 		case SID_DELETE:
//STRIP001 		{
//STRIP001 			if ( pDrView->IsTextEdit() )
//STRIP001 			{
//STRIP001 				OutlinerView* pOLV = pDrView->GetTextEditOutlinerView();
//STRIP001 
//STRIP001 				if (pOLV)
//STRIP001 				{
//STRIP001 					KeyCode aKCode(KEY_DELETE);
//STRIP001 					KeyEvent aKEvt( 0, aKCode);
//STRIP001 					pOLV->PostKeyEvent(aKEvt);
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else if ( pDrView->IsPresObjSelected(FALSE, TRUE) )
//STRIP001 			{
//STRIP001                 InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE) ) ).Execute();
//STRIP001 			}
//STRIP001 			else if (pFuActual)
//STRIP001 			{
//STRIP001 				KeyCode aKCode(KEY_DELETE);
//STRIP001 				KeyEvent aKEvt( 0, aKCode);
//STRIP001 
//STRIP001 				if ( !pFuActual->KeyInput(aKEvt) )
//STRIP001 					pDrView->DeleteMarked();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pDrView->DeleteMarked();
//STRIP001 			}
//STRIP001 			rReq.Ignore ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001        case SID_PIXELMODE:
//STRIP001 	   {
//STRIP001             const SfxItemSet* pReqArgs = rReq.GetArgs();
//STRIP001             BOOL  bPixelMode = pDrView->IsPixelMode();
//STRIP001 
//STRIP001             if (pReqArgs)
//STRIP001             {
//STRIP001                 SFX_REQUEST_ARG(rReq, pIsActive, SfxBoolItem, SID_PIXELMODE, FALSE);
//STRIP001                 bPixelMode = pIsActive->GetValue();
//STRIP001             }
//STRIP001 
//STRIP001             pDrView->SetPixelMode(!bPixelMode);
//STRIP001 
//STRIP001             Invalidate(SID_PIXELMODE);
//STRIP001        }
//STRIP001        break;
//STRIP001 
//STRIP001        case SID_ANIMATIONMODE:
//STRIP001 	   {
//STRIP001             const SfxItemSet* pReqArgs = rReq.GetArgs();
//STRIP001             BOOL  bAnimationMode = FALSE;
//STRIP001 
//STRIP001             if (pDrView->GetSlideShow())
//STRIP001             {
//STRIP001                 bAnimationMode = TRUE;
//STRIP001             }
//STRIP001 
//STRIP001             if (pReqArgs)
//STRIP001             {
//STRIP001                 SFX_REQUEST_ARG(rReq, pIsActive, SfxBoolItem, SID_ANIMATIONMODE, FALSE);
//STRIP001                 bAnimationMode = pIsActive->GetValue();
//STRIP001             }
//STRIP001 
//STRIP001             pDrView->SetAnimationMode(!bAnimationMode);
//STRIP001 
//STRIP001             Invalidate(SID_ANIMATIONMODE);
//STRIP001        }
//STRIP001        break;
//STRIP001 
//STRIP001        case SID_ACTIONMODE:
//STRIP001 	   {
//STRIP001             const SfxItemSet* pReqArgs = rReq.GetArgs();
//STRIP001             BOOL  bActionMode = FALSE;
//STRIP001 
//STRIP001             if (pDrView->IsActionMode())
//STRIP001             {
//STRIP001                 bActionMode = TRUE;
//STRIP001             }
//STRIP001 
//STRIP001             if (pReqArgs)
//STRIP001             {
//STRIP001                 SFX_REQUEST_ARG(rReq, pIsActive, SfxBoolItem, SID_ACTIONMODE, FALSE);
//STRIP001                 bActionMode = pIsActive->GetValue();
//STRIP001             }
//STRIP001 
//STRIP001             pDrView->SetActionMode(!bActionMode);
//STRIP001 
//STRIP001             Invalidate(SID_ACTIONMODE);
//STRIP001        }
//STRIP001        break;
//STRIP001 
//STRIP001        case SID_DRAWINGMODE:  // BASIC
//STRIP001 	   {
//STRIP001 			const SfxItemSet* pReqArgs = rReq.GetArgs();
//STRIP001 			BOOL  bIsActive = TRUE;
//STRIP001 
//STRIP001 			if ( pReqArgs )
//STRIP001 			{
//STRIP001 				SFX_REQUEST_ARG (rReq, pIsActive, SfxBoolItem, SID_DRAWINGMODE, FALSE);
//STRIP001 				bIsActive = pIsActive->GetValue ();
//STRIP001 			}
//STRIP001 
//STRIP001 			if ((ePageKind != PK_STANDARD) && bIsActive)
//STRIP001 			{
//STRIP001 				pFrameView->SetPageKind(PK_STANDARD);
//STRIP001 				GetViewFrame()->GetDispatcher()->Execute (SID_VIEWSHELL0,
//STRIP001 						SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 			}
//STRIP001 
//STRIP001 			Invalidate ();
//STRIP001 			rReq.Ignore ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001         case SID_NOTESMODE:  // BASIC
//STRIP001 		{
//STRIP001 			// AutoLayouts muessen fertig sein
//STRIP001 			pDoc->StopWorkStartupDelay();
//STRIP001 
//STRIP001 			// Effekte abschalten
//STRIP001 			pDrView->SetAnimationMode(FALSE);
//STRIP001 
//STRIP001 			const SfxItemSet* pReqArgs = rReq.GetArgs();
//STRIP001 			BOOL  bIsActive = TRUE;
//STRIP001 
//STRIP001 			if ( pReqArgs )
//STRIP001 			{
//STRIP001 				SFX_REQUEST_ARG (rReq, pIsActive, SfxBoolItem, SID_NOTESMODE, FALSE);
//STRIP001 				bIsActive = pIsActive->GetValue ();
//STRIP001 			}
//STRIP001 
//STRIP001 			if ((ePageKind != PK_NOTES) && bIsActive)
//STRIP001 			{
//STRIP001 				pFrameView->SetPageKind(PK_NOTES);
//STRIP001 				GetViewFrame()->GetDispatcher()->Execute (SID_VIEWSHELL0,
//STRIP001 						SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 			}
//STRIP001 
//STRIP001 			Invalidate ();
//STRIP001 			rReq.Ignore ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_HANDOUTMODE:  // BASIC
//STRIP001 		{
//STRIP001 			// AutoLayouts muessen fertig sein
//STRIP001 			pDoc->StopWorkStartupDelay();
//STRIP001 
//STRIP001 			// Effekte abschalten
//STRIP001 			pDrView->SetAnimationMode(FALSE);
//STRIP001 
//STRIP001 			const SfxItemSet* pReqArgs = rReq.GetArgs();
//STRIP001 			BOOL  bIsActive = TRUE;
//STRIP001 
//STRIP001 			if ( pReqArgs )
//STRIP001 			{
//STRIP001 				SFX_REQUEST_ARG (rReq, pIsActive, SfxBoolItem, SID_HANDOUTMODE, FALSE);
//STRIP001 				bIsActive = pIsActive->GetValue ();
//STRIP001 			}
//STRIP001 
//STRIP001 			if ((ePageKind != PK_HANDOUT) && bIsActive)
//STRIP001 			{
//STRIP001 				pFrameView->SetPageKind(PK_HANDOUT);
//STRIP001 				GetViewFrame()->GetDispatcher()->Execute (SID_VIEWSHELL0,
//STRIP001 						SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 			}
//STRIP001 
//STRIP001 			Invalidate ();
//STRIP001 			rReq.Ignore ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_DIAMODE:  // BASIC
//STRIP001 		{
//STRIP001 			const SfxItemSet* pReqArgs = rReq.GetArgs();
//STRIP001 
//STRIP001     		if ( pReqArgs )
//STRIP001 			{
//STRIP001 				SFX_REQUEST_ARG (rReq, pIsActive, SfxBoolItem, SID_DIAMODE, FALSE);
//STRIP001 				if( pIsActive && pIsActive->GetValue ())
//STRIP001 					GetViewFrame()->GetDispatcher()->Execute (SID_VIEWSHELL1,
//STRIP001 											SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 			}
//STRIP001 			else
//STRIP001 				GetViewFrame()->GetDispatcher()->Execute (SID_VIEWSHELL1,
//STRIP001 						SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 
//STRIP001 			Invalidate ();
//STRIP001 			rReq.Ignore ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_OUTLINEMODE:  // BASIC
//STRIP001 		{
//STRIP001 			const SfxItemSet* pReqArgs = rReq.GetArgs();
//STRIP001 
//STRIP001             if ( pReqArgs )
//STRIP001 			{
//STRIP001 				SFX_REQUEST_ARG (rReq, pIsActive, SfxBoolItem, SID_OUTLINEMODE, FALSE);
//STRIP001 				if (pIsActive->GetValue ()) GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL2,
//STRIP001 												SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 			}
//STRIP001 			else GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL2,
//STRIP001 					SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 
//STRIP001 			Invalidate ();
//STRIP001 			rReq.Ignore ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001         case SID_MASTERPAGE:          // BASIC
//STRIP001         case SID_SLIDE_MASTERPAGE:    // BASIC
//STRIP001         case SID_TITLE_MASTERPAGE:    // BASIC
//STRIP001         case SID_NOTES_MASTERPAGE:    // BASIC
//STRIP001         case SID_HANDOUT_MASTERPAGE:  // BASIC
//STRIP001 		{
//STRIP001 			// AutoLayouts muessen fertig sein
//STRIP001 			pDoc->StopWorkStartupDelay();
//STRIP001 
//STRIP001 			const SfxItemSet* pReqArgs = rReq.GetArgs();
//STRIP001 
//STRIP001 			if ( pReqArgs )
//STRIP001 			{
//STRIP001 				SFX_REQUEST_ARG (rReq, pIsActive, SfxBoolItem, SID_MASTERPAGE, FALSE);
//STRIP001 				bLayerMode = pIsActive->GetValue ();
//STRIP001 			}
//STRIP001 
//STRIP001             if (nSId == SID_MASTERPAGE                                       ||
//STRIP001                 (nSId == SID_SLIDE_MASTERPAGE   && ePageKind == PK_STANDARD) ||
//STRIP001                 (nSId == SID_TITLE_MASTERPAGE   && ePageKind == PK_STANDARD) ||
//STRIP001                 (nSId == SID_NOTES_MASTERPAGE   && ePageKind == PK_NOTES)    ||
//STRIP001                 (nSId == SID_HANDOUT_MASTERPAGE && ePageKind == PK_HANDOUT))
//STRIP001             {
//STRIP001                 if (nSId == SID_TITLE_MASTERPAGE ||
//STRIP001 					nSId == SID_SLIDE_MASTERPAGE)
//STRIP001                 {
//STRIP001                     // Gibt es eine Seite mit dem AutoLayout "Titel"?
//STRIP001                     BOOL bFound = FALSE;
//STRIP001                     USHORT i = 0;
//STRIP001                     USHORT nCount = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 
//STRIP001                     while (i < nCount && !bFound)
//STRIP001                     {
//STRIP001                         SdPage* pPage = pDoc->GetSdPage(i, PK_STANDARD);
//STRIP001 
//STRIP001                         if (nSId == SID_TITLE_MASTERPAGE && pPage->GetAutoLayout() == AUTOLAYOUT_TITLE)
//STRIP001                         {
//STRIP001                             bFound = TRUE;
//STRIP001                             SwitchPage((pPage->GetPageNum() - 1) / 2);
//STRIP001                         }
//STRIP001                         else if (nSId == SID_SLIDE_MASTERPAGE && pPage->GetAutoLayout() != AUTOLAYOUT_TITLE)
//STRIP001                         {
//STRIP001                             bFound = TRUE;
//STRIP001                             SwitchPage((pPage->GetPageNum() - 1) / 2);
//STRIP001                         }
//STRIP001 
//STRIP001                         i++;
//STRIP001                     }
//STRIP001                 }
//STRIP001 
//STRIP001                 // Default-Layer der MasterPage einschalten
//STRIP001                 pDrView->SetActiveLayer( String( SdResId(STR_LAYER_BCKGRNDOBJ) ) );
//STRIP001 
//STRIP001                 ChangeEditMode(EM_MASTERPAGE, bLayerMode);
//STRIP001 
//STRIP001                 if (pFuActual && pFuActual->GetSlotID() == SID_BEZIER_EDIT)
//STRIP001 					GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON);
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 // Gewuenschte ViewShell einschalten
//STRIP001 
//STRIP001                 if (nSId == SID_SLIDE_MASTERPAGE || nSId == SID_TITLE_MASTERPAGE)
//STRIP001                 {
//STRIP001                     pFrameView->SetPageKind(PK_STANDARD);
//STRIP001                 }
//STRIP001                 else if (nSId == SID_NOTES_MASTERPAGE)
//STRIP001                 {
//STRIP001                     pFrameView->SetPageKind(PK_NOTES);
//STRIP001                 }
//STRIP001                 else if (nSId == SID_HANDOUT_MASTERPAGE)
//STRIP001                 {
//STRIP001                     pFrameView->SetPageKind(PK_HANDOUT);
//STRIP001                 }
//STRIP001 
//STRIP001                 pFrameView->SetViewShEditMode(EM_MASTERPAGE, pFrameView->GetPageKind());
//STRIP001                 pFrameView->SetLayerMode(bLayerMode);
//STRIP001                 GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL0,
//STRIP001                             SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001             }
//STRIP001 
//STRIP001 			InvalidateWindows();
//STRIP001 			Invalidate();
//STRIP001 
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_RULER:
//STRIP001         {
//STRIP001 			const SfxItemSet* pReqArgs = rReq.GetArgs();
//STRIP001 
//STRIP001 			// #97516# Remember old ruler state
//STRIP001 			BOOL bOldHasRuler(HasRuler());
//STRIP001 
//STRIP001 			if ( pReqArgs )
//STRIP001 			{
//STRIP001 				SFX_REQUEST_ARG (rReq, pIsActive, SfxBoolItem, SID_RULER, FALSE);
//STRIP001 				SetRuler (pIsActive->GetValue ());
//STRIP001 			}
//STRIP001 			else SetRuler (!HasRuler());
//STRIP001 
//STRIP001 			// #97516# Did ruler state change? Tell that to SdOptions, too.
//STRIP001 			BOOL bHasRuler(HasRuler());
//STRIP001 
//STRIP001 			if(bOldHasRuler != bHasRuler)
//STRIP001 			{
//STRIP001 				SdOptions* pOptions = SD_MOD()->GetSdOptions(pDoc->GetDocumentType());
//STRIP001 
//STRIP001 				if(pOptions && pOptions->IsRulerVisible() != bHasRuler)
//STRIP001 				{
//STRIP001 					pOptions->SetRulerVisible(bHasRuler);
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001             Invalidate (SID_RULER);
//STRIP001             rReq.Done ();
//STRIP001         }
//STRIP001         break;
//STRIP001 
//STRIP001 		case SID_SIZE_PAGE:
//STRIP001 		case SID_SIZE_PAGE_WIDTH:  // BASIC
//STRIP001 		{
//STRIP001 			bZoomOnPage = ( rReq.GetSlot() == SID_SIZE_PAGE );
//STRIP001 
//STRIP001 			SdrPageView* pPageView = pDrView->GetPageViewPvNum(0);
//STRIP001 
//STRIP001 			if ( pPageView )
//STRIP001 			{
//STRIP001 				Point aPagePos = pPageView->GetOffset();
//STRIP001 				Size aPageSize = pPageView->GetPage()->GetSize();
//STRIP001 
//STRIP001 				aPagePos.X() += aPageSize.Width()  / 2;
//STRIP001                 aPageSize.Width() = (long) (aPageSize.Width() * 1.03);
//STRIP001 
//STRIP001                 if( rReq.GetSlot() == SID_SIZE_PAGE )
//STRIP001 				{
//STRIP001 					aPagePos.Y() += aPageSize.Height() / 2;
//STRIP001                     aPageSize.Height() = (long) (aPageSize.Height() * 1.03);
//STRIP001 					aPagePos.Y() -= aPageSize.Height() / 2;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					Point aPt = pWindow->PixelToLogic( Point( 0, pWindow->GetSizePixel().Height() / 2 ) );
//STRIP001 					aPagePos.Y() += aPt.Y();
//STRIP001 					aPageSize.Height() = 2;
//STRIP001 				}
//STRIP001 
//STRIP001 				aPagePos.X() -= aPageSize.Width()  / 2;
//STRIP001 
//STRIP001 				SetZoomRect( Rectangle( aPagePos, aPageSize ) );
//STRIP001 
//STRIP001 				Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0),
//STRIP001 											  pWindow->GetOutputSizePixel()) );
//STRIP001 				pZoomList->InsertZoomRect(aVisAreaWin);
//STRIP001 			}
//STRIP001 			Invalidate( SID_ZOOM_IN );
//STRIP001 			Invalidate( SID_ZOOM_OUT );
//STRIP001 			Invalidate( SID_ZOOM_PANNING );
//STRIP001 			Invalidate( SID_ZOOM_TOOLBOX );
//STRIP001 			rReq.Done ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_SIZE_REAL:  // BASIC
//STRIP001 		{
//STRIP001 			bZoomOnPage = FALSE;
//STRIP001 			SetZoom( 100 );
//STRIP001 			Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0),
//STRIP001 											  pWindow->GetOutputSizePixel()) );
//STRIP001 			pZoomList->InsertZoomRect(aVisAreaWin);
//STRIP001 			Invalidate( SID_ZOOM_IN );
//STRIP001 			Invalidate( SID_ZOOM_OUT );
//STRIP001 			Invalidate( SID_ZOOM_PANNING );
//STRIP001 			Invalidate( SID_ZOOM_TOOLBOX );
//STRIP001 			rReq.Done ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ZOOM_IN:  // BASIC
//STRIP001 		{
//STRIP001 			bZoomOnPage = FALSE;
//STRIP001 			SetZoom( Max( (long) ( pWindow->GetZoom() / 2 ), (long) pWindow->GetMinZoom() ) );
//STRIP001 			Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0),
//STRIP001 											  pWindow->GetOutputSizePixel()) );
//STRIP001 			pZoomList->InsertZoomRect(aVisAreaWin);
//STRIP001 			Invalidate( SID_ZOOM_IN );
//STRIP001 			Invalidate( SID_ZOOM_OUT );
//STRIP001 			Invalidate( SID_ZOOM_PANNING );
//STRIP001 			Invalidate( SID_ZOOM_TOOLBOX );
//STRIP001 			rReq.Done ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_SIZE_VISAREA:
//STRIP001 		{
//STRIP001 			Rectangle aVisArea = pFrameView->GetVisArea();
//STRIP001 			Size aVisAreaSize = aVisArea.GetSize();
//STRIP001 
//STRIP001 			if (aVisAreaSize.Height()!=0 && aVisAreaSize.Width()!=0)
//STRIP001 			{
//STRIP001 				bZoomOnPage = FALSE;
//STRIP001 				SetZoomRect(aVisArea);
//STRIP001 				Invalidate( SID_ZOOM_IN );
//STRIP001 				Invalidate( SID_ZOOM_OUT );
//STRIP001 				Invalidate( SID_ZOOM_PANNING );
//STRIP001 				Invalidate( SID_ZOOM_TOOLBOX );
//STRIP001 			}
//STRIP001 			rReq.Done ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		// Namensverwirrung: SID_SIZE_OPTIMAL -> Zoom auf selektierte Objekte
//STRIP001 		// --> Wird als Objektzoom im Programm angeboten
//STRIP001 		case SID_SIZE_OPTIMAL:	// BASIC
//STRIP001 		{
//STRIP001 			bZoomOnPage = FALSE;
//STRIP001 			if ( pDrView->HasMarkedObj() )
//STRIP001 			{
//STRIP001                 long nW = (long) (aMarkRect.GetWidth()  * 1.03);
//STRIP001                 long nH = (long) (aMarkRect.GetHeight() * 1.03);
//STRIP001 				Point aPos = aMarkRect.Center();
//STRIP001 				aPos.X() -= nW / 2;
//STRIP001 				aPos.Y() -= nH / 2;
//STRIP001 				if ( nW && nH )
//STRIP001 				{
//STRIP001 					SetZoomRect(Rectangle(aPos, Size(nW, nH)));
//STRIP001 
//STRIP001 					Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0),
//STRIP001 											  pWindow->GetOutputSizePixel()) );
//STRIP001 					pZoomList->InsertZoomRect(aVisAreaWin);
//STRIP001 				}
//STRIP001 			}
//STRIP001 			Invalidate( SID_ZOOM_IN );
//STRIP001 			Invalidate( SID_ZOOM_OUT );
//STRIP001 			Invalidate( SID_ZOOM_PANNING );
//STRIP001 			Invalidate( SID_ZOOM_TOOLBOX );
//STRIP001 			rReq.Done ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		// Namensverwirrung: SID_SIZE_ALL -> Zoom auf alle Objekte
//STRIP001 		// --> Wird als Optimal im Programm angeboten
//STRIP001 		case SID_SIZE_ALL:	// BASIC
//STRIP001 		{
//STRIP001 			bZoomOnPage = FALSE;
//STRIP001 			SdrPageView* pPageView = pDrView->GetPageViewPvNum( 0 );
//STRIP001 
//STRIP001 			if( pPageView )
//STRIP001 			{
//STRIP001 				Rectangle aBoundRect( pPageView->GetObjList()->GetAllObjBoundRect() );
//STRIP001 
//STRIP001                 long nW = (long) (aBoundRect.GetWidth() * 1.03);
//STRIP001                 long nH = (long) (aBoundRect.GetHeight() * 1.03);
//STRIP001 				Point aPos = aBoundRect.Center();
//STRIP001 				aPos.X() -= nW / 2;
//STRIP001 				aPos.Y() -= nH / 2;
//STRIP001 				if ( nW && nH )
//STRIP001 				{
//STRIP001 					SetZoomRect( Rectangle( aPos, Size( nW, nH ) ) );
//STRIP001 
//STRIP001 					Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0),
//STRIP001 											  pWindow->GetOutputSizePixel()) );
//STRIP001 					pZoomList->InsertZoomRect(aVisAreaWin);
//STRIP001 				}
//STRIP001 
//STRIP001 				Invalidate( SID_ZOOM_IN );
//STRIP001 				Invalidate( SID_ZOOM_OUT );
//STRIP001 				Invalidate( SID_ZOOM_PANNING );
//STRIP001 				Invalidate( SID_ZOOM_TOOLBOX );
//STRIP001 			}
//STRIP001 			rReq.Done ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ZOOM_PREV:
//STRIP001 		{
//STRIP001 			if (pDrView->IsTextEdit())
//STRIP001 			{
//STRIP001 				pDrView->EndTextEdit();
//STRIP001 			}
//STRIP001 
//STRIP001 			if (pZoomList->IsPreviousPossible())
//STRIP001 			{
//STRIP001 				// Vorheriges ZoomRect einstellen
//STRIP001 				SetZoomRect(pZoomList->GetPreviousZoomRect());
//STRIP001 			}
//STRIP001 			rReq.Done ();
//STRIP001 			Invalidate( SID_ZOOM_TOOLBOX );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ZOOM_NEXT:
//STRIP001 		{
//STRIP001 			if (pDrView->IsTextEdit())
//STRIP001 			{
//STRIP001 				pDrView->EndTextEdit();
//STRIP001 			}
//STRIP001 
//STRIP001 			if (pZoomList->IsNextPossible())
//STRIP001 			{
//STRIP001 				// Naechstes ZoomRect einstellen
//STRIP001 				SetZoomRect(pZoomList->GetNextZoomRect());
//STRIP001 			}
//STRIP001 			rReq.Done ();
//STRIP001 			Invalidate( SID_ZOOM_TOOLBOX );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_GLUE_INSERT_POINT:
//STRIP001 		case SID_GLUE_PERCENT:
//STRIP001 		case SID_GLUE_ESCDIR:
//STRIP001 		case SID_GLUE_ESCDIR_LEFT:
//STRIP001 		case SID_GLUE_ESCDIR_RIGHT:
//STRIP001 		case SID_GLUE_ESCDIR_TOP:
//STRIP001 		case SID_GLUE_ESCDIR_BOTTOM:
//STRIP001 		case SID_GLUE_HORZALIGN_CENTER:
//STRIP001 		case SID_GLUE_HORZALIGN_LEFT:
//STRIP001 		case SID_GLUE_HORZALIGN_RIGHT:
//STRIP001 		case SID_GLUE_VERTALIGN_CENTER:
//STRIP001 		case SID_GLUE_VERTALIGN_TOP:
//STRIP001 		case SID_GLUE_VERTALIGN_BOTTOM:
//STRIP001 		{
//STRIP001 			if (pFuActual && pFuActual->ISA(FuEditGluePoints))
//STRIP001 			{
//STRIP001 				((FuEditGluePoints*) pFuActual)->ReceiveRequest(rReq);
//STRIP001 			}
//STRIP001 
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 #ifndef PRODUCT
//STRIP001 		case SID_SHOW_ITEMBROWSER:
//STRIP001 		{
//STRIP001 			pDrView->ShowItemBrowser( !pDrView->IsItemBrowserVisible() );
//STRIP001 
//STRIP001 			rReq.Done ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 #endif
//STRIP001 
//STRIP001         case SID_AUTOSPELL_CHECK:
//STRIP001 		{
//STRIP001             BOOL bOnlineSpell = !pDoc->GetOnlineSpell();
//STRIP001             pDoc->SetOnlineSpell(bOnlineSpell);
//STRIP001 
//STRIP001             Outliner* pOL = pDrView->GetTextEditOutliner();
//STRIP001 
//STRIP001             if (pOL)
//STRIP001             {
//STRIP001                 ULONG nCntrl = pOL->GetControlWord();
//STRIP001 
//STRIP001                 if (bOnlineSpell)
//STRIP001                     nCntrl |= EE_CNTRL_ONLINESPELLING;
//STRIP001                 else
//STRIP001                     nCntrl &= ~EE_CNTRL_ONLINESPELLING;
//STRIP001 
//STRIP001                 pOL->SetControlWord(nCntrl);
//STRIP001             }
//STRIP001 
//STRIP001             pWindow->Invalidate();
//STRIP001 			rReq.Done ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001         case SID_CONVERT_TO_1BIT_THRESHOLD:
//STRIP001         case SID_CONVERT_TO_1BIT_MATRIX:
//STRIP001         case SID_CONVERT_TO_4BIT_GRAYS:
//STRIP001         case SID_CONVERT_TO_4BIT_COLORS:
//STRIP001         case SID_CONVERT_TO_8BIT_GRAYS:
//STRIP001         case SID_CONVERT_TO_8BIT_COLORS:
//STRIP001         case SID_CONVERT_TO_24BIT:
//STRIP001         {
//STRIP001             BmpConversion eBmpConvert = BMP_CONVERSION_NONE;
//STRIP001 
//STRIP001             switch( nSId )
//STRIP001             {
//STRIP001                 case SID_CONVERT_TO_1BIT_THRESHOLD:
//STRIP001                     eBmpConvert = BMP_CONVERSION_1BIT_THRESHOLD;
//STRIP001                     break;
//STRIP001 
//STRIP001                 case SID_CONVERT_TO_1BIT_MATRIX:
//STRIP001                     eBmpConvert = BMP_CONVERSION_1BIT_MATRIX;
//STRIP001                     break;
//STRIP001 
//STRIP001                 case SID_CONVERT_TO_4BIT_GRAYS:
//STRIP001                     eBmpConvert = BMP_CONVERSION_4BIT_GREYS;
//STRIP001                     break;
//STRIP001 
//STRIP001                 case SID_CONVERT_TO_4BIT_COLORS:
//STRIP001                     eBmpConvert = BMP_CONVERSION_4BIT_COLORS;
//STRIP001                     break;
//STRIP001 
//STRIP001                 case SID_CONVERT_TO_8BIT_GRAYS:
//STRIP001                     eBmpConvert = BMP_CONVERSION_8BIT_GREYS;
//STRIP001                     break;
//STRIP001 
//STRIP001                 case SID_CONVERT_TO_8BIT_COLORS:
//STRIP001                     eBmpConvert = BMP_CONVERSION_8BIT_COLORS;
//STRIP001                     break;
//STRIP001 
//STRIP001                 case SID_CONVERT_TO_24BIT:
//STRIP001                     eBmpConvert = BMP_CONVERSION_24BIT;
//STRIP001                     break;
//STRIP001             }
//STRIP001 
//STRIP001             pDrView->BegUndo(String(SdResId(STR_UNDO_COLORRESOLUTION)));
//STRIP001             const SdrMarkList& rMarkList = pDrView->GetMarkList();
//STRIP001 
//STRIP001             for (ULONG i=0; i<rMarkList.GetMarkCount(); i++)
//STRIP001             {
//STRIP001                 SdrObject* pObj = rMarkList.GetMark(i)->GetObj();
//STRIP001 
//STRIP001                 if (pObj->GetObjInventor() == SdrInventor)
//STRIP001                 {
//STRIP001                     if (pObj->GetObjIdentifier() == OBJ_GRAF && !((SdrGrafObj*) pObj)->IsLinkedGraphic())
//STRIP001                     {
//STRIP001                         const Graphic& rGraphic = ((SdrGrafObj*) pObj)->GetGraphic();
//STRIP001 
//STRIP001                         if( rGraphic.GetType() == GRAPHIC_BITMAP )
//STRIP001                         {
//STRIP001                             SdrGrafObj*	pNewObj = (SdrGrafObj*) pObj->Clone();
//STRIP001 
//STRIP001 							if( rGraphic.IsAnimated() )
//STRIP001 							{
//STRIP001 								Animation aAnim( rGraphic.GetAnimation() );
//STRIP001 								aAnim.Convert( eBmpConvert );
//STRIP001 	                            pNewObj->SetGraphic( aAnim );
//STRIP001 							}
//STRIP001 							else
//STRIP001 							{
//STRIP001 								BitmapEx aBmpEx( rGraphic.GetBitmapEx() );
//STRIP001 								aBmpEx.Convert( eBmpConvert );
//STRIP001 	                            pNewObj->SetGraphic( aBmpEx );
//STRIP001 							}
//STRIP001 
//STRIP001                             pDrView->ReplaceObject( pObj, *pDrView->GetPageViewPvNum(0), pNewObj );
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001 
//STRIP001             pDrView->EndUndo();
//STRIP001 			rReq.Done ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_TRANSLITERATE_UPPER:
//STRIP001 		case SID_TRANSLITERATE_LOWER:
//STRIP001 		case SID_TRANSLITERATE_HALFWIDTH:
//STRIP001 		case SID_TRANSLITERATE_FULLWIDTH:
//STRIP001 		case SID_TRANSLITERATE_HIRAGANA:
//STRIP001 		case SID_TRANSLITERATE_KATAGANA:
//STRIP001 		{
//STRIP001 			OutlinerView* pOLV = pView->GetTextEditOutlinerView();
//STRIP001 			if( pOLV )
//STRIP001 			{
//STRIP001 				using namespace ::com::sun::star::i18n;
//STRIP001 				sal_Int32 nType = 0;
//STRIP001 
//STRIP001 				switch( nSId )
//STRIP001 				{
//STRIP001 					case SID_TRANSLITERATE_UPPER:
//STRIP001 						nType = TransliterationModules_LOWERCASE_UPPERCASE;
//STRIP001 						break;
//STRIP001 					case SID_TRANSLITERATE_LOWER:
//STRIP001 						nType = TransliterationModules_UPPERCASE_LOWERCASE;
//STRIP001 						break;
//STRIP001 					case SID_TRANSLITERATE_HALFWIDTH:
//STRIP001 						nType = TransliterationModules_FULLWIDTH_HALFWIDTH;
//STRIP001 						break;
//STRIP001 					case SID_TRANSLITERATE_FULLWIDTH:
//STRIP001 						nType = TransliterationModules_HALFWIDTH_FULLWIDTH;
//STRIP001 						break;
//STRIP001 					case SID_TRANSLITERATE_HIRAGANA:
//STRIP001 						nType = TransliterationModules_KATAKANA_HIRAGANA;
//STRIP001 						break;
//STRIP001 					case SID_TRANSLITERATE_KATAGANA:
//STRIP001 						nType = TransliterationModules_HIRAGANA_KATAKANA;
//STRIP001 						break;
//STRIP001 				}
//STRIP001 
//STRIP001 				pOLV->TransliterateText( nType );
//STRIP001 			}
//STRIP001 
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		// #UndoRedo#
//STRIP001 		case SID_UNDO :
//STRIP001 		{
//STRIP001 			// #96090# moved implementation to BaseClass
//STRIP001 			ImpSidUndo(TRUE, rReq);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SID_REDO :
//STRIP001 		{
//STRIP001 			// #96090# moved implementation to BaseClass
//STRIP001 			ImpSidRedo(TRUE, rReq);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001         default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* URL-Feld einfuegen
|*
\************************************************************************/

//STRIP001 void SdDrawViewShell::InsertURLField(const String& rURL, const String& rText,
//STRIP001 									 const String& rTarget, const Point* pPos)
//STRIP001 {
//STRIP001 	SvxURLField aURLField(rURL, rText, SVXURLFORMAT_REPR);
//STRIP001 	aURLField.SetTargetFrame(rTarget);
//STRIP001 	SvxFieldItem aURLItem(aURLField);
//STRIP001 
//STRIP001     OutlinerView* pOLV = pDrView->GetTextEditOutlinerView();
//STRIP001 
//STRIP001     if (pOLV)
//STRIP001 	{
//STRIP001         ESelection aSel( pOLV->GetSelection() );
//STRIP001         SvxFieldItem aURLItem( SvxURLField( rURL, rText, SVXURLFORMAT_REPR ) );
//STRIP001         pOLV->InsertField( aURLItem );
//STRIP001         if ( aSel.nStartPos <= aSel.nEndPos )
//STRIP001 		    aSel.nEndPos = aSel.nStartPos + 1;
//STRIP001         else
//STRIP001             aSel.nStartPos = aSel.nEndPos + 1;
//STRIP001         pOLV->SetSelection( aSel );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		Outliner* pOutl = pDoc->GetInternalOutliner();
//STRIP001 		pOutl->Init( OUTLINERMODE_TEXTOBJECT );
//STRIP001 		USHORT nOutlMode = pOutl->GetMode();
//STRIP001 		pOutl->QuickInsertField( aURLItem, ESelection() );
//STRIP001 		OutlinerParaObject* pOutlParaObject = pOutl->CreateParaObject();
//STRIP001 
//STRIP001 		SdrRectObj* pRectObj = new SdrRectObj(OBJ_TEXT);
//STRIP001 
//STRIP001 		pOutl->UpdateFields();
//STRIP001 		pOutl->SetUpdateMode( TRUE );
//STRIP001 		Size aSize(pOutl->CalcTextSize());
//STRIP001 		pOutl->SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 		Point aPos;
//STRIP001 
//STRIP001 		if (pPos)
//STRIP001 		{
//STRIP001 			aPos = *pPos;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			Rectangle aRect(aPos, pWindow->GetOutputSizePixel() );
//STRIP001 			aPos = aRect.Center();
//STRIP001 			aPos = pWindow->PixelToLogic(aPos);
//STRIP001 			aPos.X() -= aSize.Width() / 2;
//STRIP001 			aPos.Y() -= aSize.Height() / 2;
//STRIP001 		}
//STRIP001 
//STRIP001 		Rectangle aLogicRect(aPos, aSize);
//STRIP001 		pRectObj->SetLogicRect(aLogicRect);
//STRIP001 		pRectObj->SetOutlinerParaObject( pOutlParaObject );
//STRIP001 		pActualPage->InsertObject(pRectObj);
//STRIP001 		pOutl->Init( nOutlMode );
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* URL-Button einfuegen
|*
\************************************************************************/

//STRIP001 void SdDrawViewShell::InsertURLButton(const String& rURL, const String& rText,
//STRIP001 									  const String& rTarget, const Point* pPos)
//STRIP001 {
//STRIP001     BOOL bNewObj = TRUE;
//STRIP001 
//STRIP001     if (pDrView->GetMarkList().GetMarkCount() > 0)
//STRIP001     {
//STRIP001 		SdrUnoObj* pUnoCtrl = PTR_CAST(SdrUnoObj, pDrView->GetMarkList().GetMark(0)->GetObj());
//STRIP001 
//STRIP001 		if (pUnoCtrl && FmFormInventor == pUnoCtrl->GetObjInventor() &&
//STRIP001    	        pUnoCtrl->GetObjIdentifier() == OBJ_FM_BUTTON)
//STRIP001        	{
//STRIP001                // Markiertes Objekt aendern
//STRIP001             bNewObj = FALSE;
//STRIP001 			uno::Reference< awt::XControlModel > xControlModel( pUnoCtrl->GetUnoControlModel() );
//STRIP001 
//STRIP001    			if( !xControlModel.is() )
//STRIP001    				return;
//STRIP001 
//STRIP001 			uno::Reference< beans::XPropertySet > xPropSet( xControlModel, uno::UNO_QUERY );
//STRIP001 
//STRIP001 			uno::Any aTmp;
//STRIP001 
//STRIP001 			aTmp <<= ::rtl::OUString( rText );
//STRIP001 			xPropSet->setPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Label" )), aTmp );
//STRIP001 
//STRIP001 			aTmp <<= ::rtl::OUString( so3::StaticBaseUrl::SmartRelToAbs( rURL, FALSE,
//STRIP001 																INetURLObject::WAS_ENCODED,
//STRIP001 																INetURLObject::DECODE_UNAMBIGUOUS ) );
//STRIP001 			xPropSet->setPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "TargetURL" )), aTmp );
//STRIP001 
//STRIP001 			if( rTarget.Len() )
//STRIP001 			{
//STRIP001 				aTmp <<= ::rtl::OUString(rTarget);
//STRIP001 				xPropSet->setPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "TargetFrame" )), aTmp );
//STRIP001 			}
//STRIP001 
//STRIP001 			form::FormButtonType eButtonType = form::FormButtonType_URL;
//STRIP001 			aTmp <<= eButtonType;
//STRIP001 			xPropSet->setPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "ButtonType" )), aTmp );
//STRIP001 			if ( Sound::IsSoundFile( rURL ) )
//STRIP001 			{
//STRIP001 				// #105638# OJ
//STRIP001 				aTmp <<= sal_True;
//STRIP001 				xPropSet->setPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "DispatchURLInternal" )), aTmp );
//STRIP001 			}
//STRIP001 	    }
//STRIP001     }
//STRIP001 
//STRIP001     if (bNewObj)
//STRIP001     {
//STRIP001         SdrUnoObj* pUnoCtrl = (SdrUnoObj*) SdrObjFactory::MakeNewObject(FmFormInventor, OBJ_FM_BUTTON,
//STRIP001                                 pDrView->GetPageViewPvNum(0)->GetPage(), pDoc);
//STRIP001 
//STRIP001 		uno::Reference< awt::XControlModel > xControlModel( pUnoCtrl->GetUnoControlModel() );
//STRIP001 
//STRIP001 		if( !xControlModel.is())
//STRIP001 			return;
//STRIP001 
//STRIP001 		uno::Reference< beans::XPropertySet > xPropSet( xControlModel, uno::UNO_QUERY );
//STRIP001 
//STRIP001 		uno::Any aTmp;
//STRIP001 
//STRIP001 		aTmp <<= ::rtl::OUString(rText);
//STRIP001 		xPropSet->setPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Label" )), aTmp );
//STRIP001 
//STRIP001 		aTmp <<= ::rtl::OUString( so3::StaticBaseUrl::SmartRelToAbs( rURL, FALSE,
//STRIP001 															INetURLObject::WAS_ENCODED,
//STRIP001 															INetURLObject::DECODE_UNAMBIGUOUS ) );
//STRIP001 		xPropSet->setPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "TargetURL" )), aTmp );
//STRIP001 
//STRIP001 		if( rTarget.Len() )
//STRIP001 		{
//STRIP001 			aTmp <<= ::rtl::OUString(rTarget);
//STRIP001 			xPropSet->setPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "TargetFrame" )), aTmp );
//STRIP001 		}
//STRIP001 
//STRIP001 		form::FormButtonType eButtonType = form::FormButtonType_URL;
//STRIP001 		aTmp <<= eButtonType;
//STRIP001 		xPropSet->setPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "ButtonType" )), aTmp );
//STRIP001 		// #105638# OJ
//STRIP001 		if ( Sound::IsSoundFile( rURL ) )
//STRIP001 		{
//STRIP001 			aTmp <<= sal_True;
//STRIP001 			xPropSet->setPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "DispatchURLInternal" )), aTmp );
//STRIP001 		}
//STRIP001 
//STRIP001         Point aPos;
//STRIP001 
//STRIP001         if (pPos)
//STRIP001         {
//STRIP001             aPos = *pPos;
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             aPos = Rectangle(aPos, pWindow->GetOutputSizePixel()).Center();
//STRIP001             aPos = pWindow->PixelToLogic(aPos);
//STRIP001         }
//STRIP001 
//STRIP001         Size aSize(4000, 1000);
//STRIP001         aPos.X() -= aSize.Width() / 2;
//STRIP001         aPos.Y() -= aSize.Height() / 2;
//STRIP001         pUnoCtrl->SetLogicRect(Rectangle(aPos, aSize));
//STRIP001 
//STRIP001         ULONG nOptions = SDRINSERT_SETDEFLAYER;
//STRIP001 
//STRIP001         if (GetIPClient() && GetIPClient()->IsInPlaceActive())
//STRIP001         {
//STRIP001             nOptions |= SDRINSERT_DONTMARK;
//STRIP001         }
//STRIP001 
//STRIP001         pDrView->InsertObject(pUnoCtrl, *pDrView->GetPageViewPvNum(0), nOptions);
//STRIP001     }
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SdDrawViewShell::ShowUIControls( sal_Bool bVisible )
//STRIP001 {
//STRIP001 	if( bHasRuler )
//STRIP001 	{
//STRIP001 		if( pHRulerArray[0] )
//STRIP001 			pHRulerArray[0]->Show( bVisible );
//STRIP001 
//STRIP001 		if( pHRulerArray[1] )
//STRIP001 			pHRulerArray[1]->Show( bVisible );
//STRIP001 
//STRIP001 		if( pVRulerArray[0] )
//STRIP001 			pVRulerArray[0]->Show( bVisible );
//STRIP001 
//STRIP001 		if( pVRulerArray[1] )
//STRIP001 			pVRulerArray[1]->Show( bVisible );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pVScrlArray[0] )
//STRIP001 		pVScrlArray[0]->Show( bVisible );
//STRIP001 
//STRIP001 	if( pVScrlArray[1] )
//STRIP001 		pVScrlArray[1]->Show( bVisible );
//STRIP001 
//STRIP001 	if( pHScrlArray[0] )
//STRIP001 		pHScrlArray[0]->Show( bVisible );
//STRIP001 
//STRIP001 	if( pHScrlArray[1] )
//STRIP001 		pHScrlArray[1]->Show( bVisible );
//STRIP001 
//STRIP001 	aVSplit.Show( bVisible );
//STRIP001 	aHSplit.Show( bVisible );
//STRIP001 
//STRIP001 	aDrawBtn.Show( bVisible );
//STRIP001 	aSlideBtn.Show( bVisible );
//STRIP001 	aOutlineBtn.Show( bVisible );
//STRIP001 	aNotesBtn.Show( bVisible );
//STRIP001 	aHandoutBtn.Show( bVisible );
//STRIP001     aPresentationBtn.Show( bVisible );
//STRIP001 	aPageBtn.Show( bVisible );
//STRIP001 	aMasterPageBtn.Show( bVisible );
//STRIP001 	aLayerBtn.Show( bVisible );
//STRIP001 
//STRIP001 	if( bLayerMode )
//STRIP001 		aLayerTab.Show( bVisible );
//STRIP001 	else
//STRIP001 		aTabControl.Show( bVisible );
//STRIP001 
//STRIP001 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
//STRIP001 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
//STRIP001 			if( pWinArray[nX][nY] )
//STRIP001 				pWinArray[nX][nY]->Show( bVisible );
//STRIP001 }

#ifdef WNT
#pragma optimize ( "", on )
#endif


}
