/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_fudraw.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:11:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop
// auto strip #include <sot/object.hxx>
#ifndef _EEITEM_HXX //autogen
#include <bf_svx/eeitem.hxx>
#endif

// auto strip #ifndef _SV_WAITOBJ_HXX
// auto strip #include <vcl/waitobj.hxx>
// auto strip #endif

// auto strip #ifndef _PSTM_HXX
// auto strip #include <tools/pstm.hxx>
// auto strip #endif

#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif

#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif

#ifndef _DATE_HXX
#include <tools/date.hxx>
#endif

#ifndef _TOOLS_TIME_HXX
#include <tools/time.hxx>
#endif

#define ITEMID_FIELD    EE_FEATURE_FIELD
// auto strip #include <bf_svx/flditem.hxx>
// auto strip #ifndef _SVDOGRP_HXX //autogen
// auto strip #include <bf_svx/svdogrp.hxx>
// auto strip #endif
// auto strip #ifndef _URLOBJ_HXX
// auto strip #include <tools/urlobj.hxx>
// auto strip #endif
// auto strip #ifndef _SV_HELP_HXX //autogen
// auto strip #include <vcl/help.hxx>
// auto strip #endif
#ifndef _BMPMASK_HXX_ //autogen
#include <bf_svx/bmpmask.hxx>
#endif
// auto strip #ifndef _SVDOTEXT_HXX //autogen
// auto strip #include <bf_svx/svdotext.hxx>
// auto strip #endif
// auto strip #ifndef _SFXAPP_HXX //autogen
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_BINDINGS_HXX //autogen
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #endif
// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _GOODIES_IMAPOBJ_HXX //autogen
// auto strip #include <svtools/imapobj.hxx>
// auto strip #endif
#include <bf_svx/svxids.hrc>
// auto strip #ifndef _E3D_OBJ3D_HXX //autogen
// auto strip #include <bf_svx/obj3d.hxx>
// auto strip #endif
#ifndef _E3D_POLYSC3D_HXX //autogen
#include <bf_svx/polysc3d.hxx>
#endif
// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif

// auto strip #include "anminfo.hxx"
// auto strip #include "anmdef.hxx"
// auto strip #include "imapinfo.hxx"
#include "app.hrc"
#include "glob.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"

// auto strip #include "app.hxx"
// auto strip #include "grdocsh.hxx"
// auto strip #include "fudraw.hxx"
#include "viewshel.hxx"
// auto strip #include "frmview.hxx"
// auto strip #include "sdview.hxx"
#include "sdwindow.hxx"
// auto strip #include "drawdoc.hxx"
#include "docshell.hxx"
// auto strip #include "sdclient.hxx"
// auto strip #include "sdresid.hxx"
#include "drawview.hxx"
#include "fusel.hxx"
// auto strip #ifndef _AEITEM_HXX //autogen
// auto strip #include <svtools/aeitem.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
namespace binfilter {

using namespace ::com::sun::star;

TYPEINIT1( FuDraw, FuPoor );

/*************************************************************************
|*
|* Base-class for all drawmodul-specific functions
|*
\************************************************************************/

/*N*/ FuDraw::FuDraw(SdViewShell* pViewSh, SdWindow* pWin, SdView* pView,
/*N*/ 			   SdDrawDocument* pDoc, SfxRequest& rReq) :
/*N*/ 	FuPoor(pViewSh, pWin, pView, pDoc, rReq),
/*N*/ 	bMBDown(FALSE),
/*N*/ 	bPermanent(FALSE),
/*N*/ 	bDragHelpLine(FALSE)
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ FuDraw::~FuDraw()
/*N*/ {
/*N*/ 	pView->BrkAction();
/*N*/ }

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/

//STRIP001 BOOL FuDraw::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	// #95491# remember button state for creation of own MouseEvents
//STRIP001 	SetMouseButtonCode(rMEvt.GetButtons());
//STRIP001 
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	bDragHelpLine = FALSE;
//STRIP001 
//STRIP001 	aMDPos = pWindow->PixelToLogic( rMEvt.GetPosPixel() );
//STRIP001 
//STRIP001 	if ( rMEvt.IsLeft() )
//STRIP001 	{
//STRIP001 		FrameView* pFrameView = pViewShell->GetFrameView();
//STRIP001 
//STRIP001 //		  BOOL bOrtho = pView->IsOrthoDesired() || pFrameView->IsOrtho();
//STRIP001 //		  bOrtho = bOrtho != rMEvt.IsShift();
//STRIP001 		BOOL bOrtho = FALSE;
//STRIP001 
//STRIP001 		BOOL bRestricted = TRUE;
//STRIP001 
//STRIP001 		if (pView->IsDragObj())
//STRIP001 		{
//STRIP001 			// object is dragged (move, resize,...)
//STRIP001 			const SdrHdl* pHdl = pView->GetDragStat().GetHdl();
//STRIP001 
//STRIP001 			if (!pHdl || (!pHdl->IsCornerHdl() && !pHdl->IsVertexHdl()))
//STRIP001 			{
//STRIP001 				// Move
//STRIP001 				bRestricted = FALSE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if (bRestricted &&
//STRIP001 			(nSlotId == SID_DRAW_XLINE				 ||
//STRIP001 			 nSlotId == SID_DRAW_CIRCLEARC			 ||
//STRIP001 			 nSlotId == SID_DRAW_SQUARE 			 ||
//STRIP001 			 nSlotId == SID_DRAW_SQUARE_NOFILL		 ||
//STRIP001 			 nSlotId == SID_DRAW_SQUARE_ROUND		 ||
//STRIP001 			 nSlotId == SID_DRAW_SQUARE_ROUND_NOFILL ||
//STRIP001 			 nSlotId == SID_DRAW_CIRCLE 			 ||
//STRIP001 			 nSlotId == SID_DRAW_CIRCLE_NOFILL		 ||
//STRIP001 			 nSlotId == SID_DRAW_CIRCLEPIE			 ||
//STRIP001 			 nSlotId == SID_DRAW_CIRCLEPIE_NOFILL	 ||
//STRIP001 			 nSlotId == SID_DRAW_CIRCLECUT			 ||
//STRIP001 			 nSlotId == SID_DRAW_CIRCLECUT_NOFILL	 ||
//STRIP001 			 nSlotId == SID_DRAW_XPOLYGON			 ||
//STRIP001 			 nSlotId == SID_DRAW_XPOLYGON_NOFILL	 ||
//STRIP001 			 nSlotId == SID_3D_CUBE                  ||
//STRIP001 			 nSlotId == SID_3D_SPHERE                ||
//STRIP001 			 nSlotId == SID_3D_SHELL                 ||
//STRIP001 			 nSlotId == SID_3D_HALF_SPHERE           ||
//STRIP001 			 nSlotId == SID_3D_TORUS                 ||
//STRIP001 			 nSlotId == SID_3D_CYLINDER              ||
//STRIP001 			 nSlotId == SID_3D_CONE                  ||
//STRIP001 			 nSlotId == SID_3D_PYRAMID ))
//STRIP001 		{
//STRIP001 			// Restrict movement:
//STRIP001 			// rectangle->quadrat, ellipse->circle etc.
//STRIP001 			bOrtho = !rMEvt.IsShift();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			bOrtho = rMEvt.IsShift() != pFrameView->IsOrtho();
//STRIP001 		}
//STRIP001 
//STRIP001 		if (!pView->IsSnapEnabled())
//STRIP001 			pView->SetSnapEnabled(TRUE);
//STRIP001 		BOOL bCntrl = rMEvt.IsMod1();
//STRIP001 
//STRIP001 		BOOL bGridSnap = pFrameView->IsGridSnap();
//STRIP001 		bGridSnap = (bCntrl != bGridSnap);
//STRIP001 
//STRIP001 		if (pView->IsGridSnap() != bGridSnap)
//STRIP001 			pView->SetGridSnap(bGridSnap);
//STRIP001 
//STRIP001 		BOOL bBordSnap = pFrameView->IsBordSnap();
//STRIP001 		bBordSnap = (bCntrl != bBordSnap);
//STRIP001 
//STRIP001 		if (pView->IsBordSnap() != bBordSnap)
//STRIP001 			pView->SetBordSnap(bBordSnap);
//STRIP001 
//STRIP001 		BOOL bHlplSnap = pFrameView->IsHlplSnap();
//STRIP001 		bHlplSnap = (bCntrl != bHlplSnap);
//STRIP001 
//STRIP001 		if (pView->IsHlplSnap() != bHlplSnap)
//STRIP001 			pView->SetHlplSnap(bHlplSnap);
//STRIP001 
//STRIP001 		BOOL bOFrmSnap = pFrameView->IsOFrmSnap();
//STRIP001 		bOFrmSnap = (bCntrl != bOFrmSnap);
//STRIP001 
//STRIP001 		if (pView->IsOFrmSnap() != bOFrmSnap)
//STRIP001 			pView->SetOFrmSnap(bOFrmSnap);
//STRIP001 
//STRIP001 		BOOL bOPntSnap = pFrameView->IsOPntSnap();
//STRIP001 		bOPntSnap = (bCntrl != bOPntSnap);
//STRIP001 
//STRIP001 		if (pView->IsOPntSnap() != bOPntSnap)
//STRIP001 			pView->SetOPntSnap(bOPntSnap);
//STRIP001 
//STRIP001 		BOOL bOConSnap = pFrameView->IsOConSnap();
//STRIP001 		bOConSnap = (bCntrl != bOConSnap);
//STRIP001 
//STRIP001 		if (pView->IsOConSnap() != bOConSnap)
//STRIP001 			pView->SetOConSnap(bOConSnap);
//STRIP001 
//STRIP001 		BOOL bAngleSnap = rMEvt.IsShift() == !pFrameView->IsAngleSnapEnabled();
//STRIP001 
//STRIP001 		if (pView->IsAngleSnapEnabled() != bAngleSnap)
//STRIP001 			pView->SetAngleSnapEnabled(bAngleSnap);
//STRIP001 
//STRIP001 		if (pView->IsOrtho() != bOrtho)
//STRIP001 			pView->SetOrtho(bOrtho);
//STRIP001 
//STRIP001 		BOOL bCenter = rMEvt.IsMod2();
//STRIP001 
//STRIP001 		if ( pView->IsCreate1stPointAsCenter() != bCenter ||
//STRIP001 			 pView->IsResizeAtCenter() != bCenter )
//STRIP001 		{
//STRIP001 			pView->SetCreate1stPointAsCenter(bCenter);
//STRIP001 			pView->SetResizeAtCenter(bCenter);
//STRIP001 		}
//STRIP001 
//STRIP001 		SdrPageView* pPV;
//STRIP001 		USHORT nHitLog = USHORT ( pWindow->PixelToLogic(Size(HITPIX,0)).Width() );
//STRIP001 
//STRIP001 		// #76572# look only for HelpLines when they are visible (!)
//STRIP001 		BOOL bHelpLine(FALSE);
//STRIP001 		if(pView->IsHlplVisible())
//STRIP001 			bHelpLine = pView->PickHelpLine(aMDPos, nHitLog, *pWindow, nHelpLine, pPV);
//STRIP001 		BOOL bHitHdl = (pView->HitHandle(aMDPos, *pWindow) != NULL);
//STRIP001 
//STRIP001 		if ( bHelpLine
//STRIP001 			&& !pView->IsCreateObj()
//STRIP001 			&& ((pView->GetEditMode() == SDREDITMODE_EDIT && !bHitHdl) || (rMEvt.IsShift() && bCntrl)) )
//STRIP001 		{
//STRIP001 			pWindow->CaptureMouse();
//STRIP001 			pView->BegDragHelpLine(nHelpLine, pPV);
//STRIP001 			bDragHelpLine = pView->IsDragHelpLine();
//STRIP001 			bReturn = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	ForcePointer(&rMEvt);
//STRIP001 
//STRIP001 	return bReturn;
//STRIP001 //STRIP001 }

/*************************************************************************
|*
|* MouseMove-event
|*
\************************************************************************/

//STRIP001 BOOL FuDraw::MouseMove(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	FrameView* pFrameView = pViewShell->GetFrameView();
//STRIP001 	Point aPos = pWindow->PixelToLogic( rMEvt.GetPosPixel() );
//STRIP001 
//STRIP001 //	  BOOL bOrtho = pView->IsOrthoDesired() || pFrameView->IsOrtho();
//STRIP001 //	  bOrtho = bOrtho != rMEvt.IsShift();
//STRIP001 	BOOL bOrtho = FALSE;
//STRIP001 
//STRIP001 	BOOL bRestricted = TRUE;
//STRIP001 
//STRIP001 	if (pView->IsDragObj())
//STRIP001 	{
//STRIP001 		// object is dragged (move, resize, ...)
//STRIP001 		const SdrHdl* pHdl = pView->GetDragStat().GetHdl();
//STRIP001 
//STRIP001 		if (!pHdl || (!pHdl->IsCornerHdl() && !pHdl->IsVertexHdl()))
//STRIP001 		{
//STRIP001 			// Move
//STRIP001 			bRestricted = FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pView->IsAction())
//STRIP001 	{
//STRIP001 		if (bRestricted &&
//STRIP001 			(nSlotId == SID_DRAW_XLINE               ||
//STRIP001 			 nSlotId == SID_DRAW_CIRCLEARC           ||
//STRIP001 			 nSlotId == SID_DRAW_SQUARE              ||
//STRIP001 			 nSlotId == SID_DRAW_SQUARE_NOFILL       ||
//STRIP001 			 nSlotId == SID_DRAW_SQUARE_ROUND        ||
//STRIP001 			 nSlotId == SID_DRAW_SQUARE_ROUND_NOFILL ||
//STRIP001 			 nSlotId == SID_DRAW_CIRCLE              ||
//STRIP001 			 nSlotId == SID_DRAW_CIRCLE_NOFILL       ||
//STRIP001 			 nSlotId == SID_DRAW_CIRCLEPIE           ||
//STRIP001 			 nSlotId == SID_DRAW_CIRCLEPIE_NOFILL    ||
//STRIP001 			 nSlotId == SID_DRAW_CIRCLECUT           ||
//STRIP001 			 nSlotId == SID_DRAW_CIRCLECUT_NOFILL    ||
//STRIP001 			 nSlotId == SID_DRAW_XPOLYGON            ||
//STRIP001 			 nSlotId == SID_DRAW_XPOLYGON_NOFILL     ||
//STRIP001 			 nSlotId == SID_3D_CUBE                  ||
//STRIP001 			 nSlotId == SID_3D_SPHERE                ||
//STRIP001 			 nSlotId == SID_3D_SHELL                 ||
//STRIP001 			 nSlotId == SID_3D_HALF_SPHERE           ||
//STRIP001 			 nSlotId == SID_3D_TORUS                 ||
//STRIP001 			 nSlotId == SID_3D_CYLINDER              ||
//STRIP001 			 nSlotId == SID_3D_CONE                  ||
//STRIP001 			 nSlotId == SID_3D_PYRAMID ))
//STRIP001 
//STRIP001 		{
//STRIP001 			// Restrict movement:
//STRIP001 			// rectangle->quadrat, ellipse->circle etc.
//STRIP001 			bOrtho = !rMEvt.IsShift();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			bOrtho = rMEvt.IsShift() != pFrameView->IsOrtho();
//STRIP001 		}
//STRIP001 
//STRIP001 		BOOL bCntrl = rMEvt.IsMod1();
//STRIP001 		pView->SetDragWithCopy(rMEvt.IsMod1() && pFrameView->IsDragWithCopy());
//STRIP001 
//STRIP001 		BOOL bGridSnap = pFrameView->IsGridSnap();
//STRIP001 		bGridSnap = (bCntrl != bGridSnap);
//STRIP001 
//STRIP001 		if (pView->IsGridSnap() != bGridSnap)
//STRIP001 			pView->SetGridSnap(bGridSnap);
//STRIP001 
//STRIP001 		BOOL bBordSnap = pFrameView->IsBordSnap();
//STRIP001 		bBordSnap = (bCntrl != bBordSnap);
//STRIP001 
//STRIP001 		if (pView->IsBordSnap() != bBordSnap)
//STRIP001 			pView->SetBordSnap(bBordSnap);
//STRIP001 
//STRIP001 		BOOL bHlplSnap = pFrameView->IsHlplSnap();
//STRIP001 		bHlplSnap = (bCntrl != bHlplSnap);
//STRIP001 
//STRIP001 		if (pView->IsHlplSnap() != bHlplSnap)
//STRIP001 			pView->SetHlplSnap(bHlplSnap);
//STRIP001 
//STRIP001 		BOOL bOFrmSnap = pFrameView->IsOFrmSnap();
//STRIP001 		bOFrmSnap = (bCntrl != bOFrmSnap);
//STRIP001 
//STRIP001 		if (pView->IsOFrmSnap() != bOFrmSnap)
//STRIP001 			pView->SetOFrmSnap(bOFrmSnap);
//STRIP001 
//STRIP001 		BOOL bOPntSnap = pFrameView->IsOPntSnap();
//STRIP001 		bOPntSnap = (bCntrl != bOPntSnap);
//STRIP001 
//STRIP001 		if (pView->IsOPntSnap() != bOPntSnap)
//STRIP001 			pView->SetOPntSnap(bOPntSnap);
//STRIP001 
//STRIP001 		BOOL bOConSnap = pFrameView->IsOConSnap();
//STRIP001 		bOConSnap = (bCntrl != bOConSnap);
//STRIP001 
//STRIP001 		if (pView->IsOConSnap() != bOConSnap)
//STRIP001 			pView->SetOConSnap(bOConSnap);
//STRIP001 
//STRIP001 		BOOL bAngleSnap = rMEvt.IsShift() == !pFrameView->IsAngleSnapEnabled();
//STRIP001 
//STRIP001 		if (pView->IsAngleSnapEnabled() != bAngleSnap)
//STRIP001 			pView->SetAngleSnapEnabled(bAngleSnap);
//STRIP001 
//STRIP001 		if (pView->IsOrtho() != bOrtho)
//STRIP001 			pView->SetOrtho(bOrtho);
//STRIP001 
//STRIP001 		BOOL bCenter = rMEvt.IsMod2();
//STRIP001 
//STRIP001 		if ( pView->IsCreate1stPointAsCenter() != bCenter ||
//STRIP001 			 pView->IsResizeAtCenter() != bCenter )
//STRIP001 		{
//STRIP001 			pView->SetCreate1stPointAsCenter(bCenter);
//STRIP001 			pView->SetResizeAtCenter(bCenter);
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pView->IsDragHelpLine() )
//STRIP001 			pView->MovDragHelpLine(aPos);
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bReturn = pView->MouseMove(rMEvt, pWindow);
//STRIP001 
//STRIP001 	if (pView->IsAction())
//STRIP001 	{
//STRIP001 		// Because the flag set back if necessary in MouseMove
//STRIP001 		if (pView->IsOrtho() != bOrtho)
//STRIP001 			pView->SetOrtho(bOrtho);
//STRIP001 	}
//STRIP001 
//STRIP001 	ForcePointer(&rMEvt);
//STRIP001 
//STRIP001 	return bReturn;
//STRIP001 }

/*************************************************************************
|*
|* MouseButtonUp-event
|*
\************************************************************************/

//STRIP001 BOOL FuDraw::MouseButtonUp(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	if ( pView->IsDragHelpLine() )
//STRIP001 		pView->EndDragHelpLine();
//STRIP001 
//STRIP001 	if ( bDragHelpLine )
//STRIP001 	{
//STRIP001 		Rectangle aOutputArea(Point(0,0), pWindow->GetOutputSizePixel());
//STRIP001 
//STRIP001 		if ( !aOutputArea.IsInside(rMEvt.GetPosPixel()) )
//STRIP001 			pView->GetPageViewPvNum(0)->DeleteHelpLine(nHelpLine);
//STRIP001 
//STRIP001 		pWindow->ReleaseMouse();
//STRIP001 	}
//STRIP001 
//STRIP001 	FrameView* pFrameView = pViewShell->GetFrameView();
//STRIP001 	pView->SetOrtho( pFrameView->IsOrtho() );
//STRIP001 	pView->SetAngleSnapEnabled( pFrameView->IsAngleSnapEnabled() );
//STRIP001 	pView->SetSnapEnabled(TRUE);
//STRIP001 	pView->SetCreate1stPointAsCenter(FALSE);
//STRIP001 	pView->SetResizeAtCenter(FALSE);
//STRIP001 	pView->SetDragWithCopy(pFrameView->IsDragWithCopy());
//STRIP001 	pView->SetGridSnap(pFrameView->IsGridSnap());
//STRIP001 	pView->SetBordSnap(pFrameView->IsBordSnap());
//STRIP001 	pView->SetHlplSnap(pFrameView->IsHlplSnap());
//STRIP001 	pView->SetOFrmSnap(pFrameView->IsOFrmSnap());
//STRIP001 	pView->SetOPntSnap(pFrameView->IsOPntSnap());
//STRIP001 	pView->SetOConSnap(pFrameView->IsOConSnap());
//STRIP001 
//STRIP001 	bIsInDragMode = FALSE;
//STRIP001 	ForcePointer(&rMEvt);
//STRIP001 	FuPoor::MouseButtonUp(rMEvt);
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 //STRIP001 }

/*************************************************************************
|*
|* Process keyboard-events
|*
|* When processing a KeyEvent the returnvalue is TRUE, otherwise FALSE.
|*
\************************************************************************/

//STRIP001 BOOL FuDraw::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	switch ( rKEvt.GetKeyCode().GetCode() )
//STRIP001 	{
//STRIP001 		case KEY_ESCAPE:
//STRIP001 		{
//STRIP001 			bReturn = FuDraw::cancel();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_DELETE:
//STRIP001 		case KEY_BACKSPACE:
//STRIP001 		{
//STRIP001 			if (!pDocSh->IsReadOnly())
//STRIP001 			{
//STRIP001 				if ( pView->IsPresObjSelected(FALSE, TRUE) )
//STRIP001 				{
//STRIP001 					InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE) ) ).Execute();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					// Falls IP-Client aktiv, werden die Pointer
//STRIP001 					// auf das OLE- und das alte Graphic-Object
//STRIP001 					// am SdClient zurueckgesetzt, damit bei
//STRIP001 					// ::SelectionHasChanged nach dem Loeschen
//STRIP001 					// nicht mehr versucht wird, ein Grafik-Objekt
//STRIP001 					// zu restaurieren, das gar nicht mehr existiert.
//STRIP001 					// Alle anderen OLE-Objekte sind davon nicht
//STRIP001 					// betroffen (KA 06.10.95)
//STRIP001 					SdClient* pIPClient = (SdClient*)pViewShell->GetIPClient();
//STRIP001 					if (pIPClient && pIPClient->IsInPlaceActive())
//STRIP001 					{
//STRIP001 						pIPClient->SetSdrGrafObj(NULL);
//STRIP001 					}
//STRIP001 
//STRIP001 					// wait-mousepointer while deleting object
//STRIP001 					WaitObject aWait( (Window*)pViewShell->GetActiveWindow() );
//STRIP001 					// delete object
//STRIP001 					pView->DeleteMarked();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			bReturn = TRUE;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_TAB:
//STRIP001 		{
//STRIP001 			KeyCode aCode = rKEvt.GetKeyCode();
//STRIP001 
//STRIP001 			if ( !aCode.IsMod1() && !aCode.IsMod2() )
//STRIP001 			{
				// #105336# Moved next line which was a bugfix itself into
				// the scope which really does the object selection travel
				// and thus is allowed to call SelectionHasChanged().

				// Switch to FuSelect.
//STRIP001 				pViewShell->GetViewFrame()->GetDispatcher()->Execute(
//STRIP001 					SID_OBJECT_SELECT, 
//STRIP001 					SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 
//STRIP001 				// changeover to the next object
//STRIP001 				if(!pView->MarkNextObj( !aCode.IsShift() ))
//STRIP001 				{
//STRIP001 					// #97016# No next object: go over open end and
//STRIP001 					// get first from the other side
//STRIP001 					pView->UnmarkAllObj();
//STRIP001 					pView->MarkNextObj(!aCode.IsShift());
//STRIP001 				}
//STRIP001 
//STRIP001 				// #97016# II
//STRIP001 				if(pView->HasMarkedObj())
//STRIP001 					pView->MakeVisible(pView->GetAllMarkedRect(), *pWindow);
//STRIP001 
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_END:
//STRIP001 		{
//STRIP001 			KeyCode aCode = rKEvt.GetKeyCode();
//STRIP001 
//STRIP001 			if ( aCode.IsMod1() )
//STRIP001 			{
//STRIP001 				// #97016# mark last object
//STRIP001 				pView->UnmarkAllObj();
//STRIP001 				pView->MarkNextObj(FALSE);
//STRIP001 
//STRIP001 				// #97016# II
//STRIP001 				if(pView->HasMarkedObj())
//STRIP001 					pView->MakeVisible(pView->GetAllMarkedRect(), *pWindow);
//STRIP001 
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_HOME:
//STRIP001 		{
//STRIP001 			KeyCode aCode = rKEvt.GetKeyCode();
//STRIP001 
//STRIP001 			if ( aCode.IsMod1() )
//STRIP001 			{
//STRIP001 				// #97016# mark first object
//STRIP001 				pView->UnmarkAllObj();
//STRIP001 				pView->MarkNextObj(TRUE);
//STRIP001 
//STRIP001 				// #97016# II
//STRIP001 				if(pView->HasMarkedObj())
//STRIP001 					pView->MakeVisible(pView->GetAllMarkedRect(), *pWindow);
//STRIP001 
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!bReturn)
//STRIP001 	{
//STRIP001 		bReturn = FuPoor::KeyInput(rKEvt);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pWindow->ReleaseMouse();
//STRIP001 	}
//STRIP001 
//STRIP001 	return (bReturn);
//STRIP001 //STRIP001 }

/*************************************************************************
|*
|* Fade out the selection-presentation before scrolling
|*
\************************************************************************/

//STRIP001 void FuDraw::ScrollStart()
//STRIP001 {
//STRIP001 	if ( pView->IsShownXorVisible(pWindow) )
//STRIP001 	{
//STRIP001 		pView->HideShownXor(pWindow);
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* After scrolling show the selection-presentation again
|*
\************************************************************************/

//STRIP001 void FuDraw::ScrollEnd()
//STRIP001 {
//STRIP001 	if ( !pView->IsShownXorVisible(pWindow) )
//STRIP001 	{
//STRIP001 		pView->ShowShownXor(pWindow);
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Aktivate function
|*
\************************************************************************/

/*N*/ void FuDraw::Activate()
/*N*/ {
/*N*/ 	FuPoor::Activate();
/*N*/ 	ForcePointer();
/*N*/ }

/*************************************************************************
|*
|* Deaktivate function
|*
\************************************************************************/

/*N*/ void FuDraw::Deactivate()
/*N*/ {
/*N*/ 	FuPoor::Deactivate();
/*N*/ }


/*************************************************************************
|*
|* Toggle mouse-pointer
|*
\************************************************************************/

/*N*/ void FuDraw::ForcePointer(const MouseEvent* pMEvt)
/*N*/ {
/*N*/ 	Point aPnt;
/*N*/ 	USHORT nModifier = 0;
/*N*/ 	BOOL bLeftDown = FALSE;
/*N*/ 	BOOL bDefPointer = TRUE;

/*N*/ 	if (pMEvt)
/*?*/ 	{
/*?*/ 		aPnt = pWindow->PixelToLogic(pMEvt->GetPosPixel());
/*?*/ 		nModifier = pMEvt->GetModifier();
/*?*/ 		bLeftDown = pMEvt->IsLeft();
/*?*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		aPnt = pWindow->PixelToLogic(pWindow->GetPointerPosPixel());
/*N*/ 	}

/*N*/ 	BOOL bIsAction = pView->IsAction();

/*N*/ 	if (pView->IsDragObj())
/*?*/ 	{
/*?*/ 		if (SD_MOD()->GetWaterCan() && !pView->HitHandle(aPnt, *pWindow))
		{
			/******************************************************************
			* Giesskannenmodus
			******************************************************************/
			bDefPointer = FALSE;
			pWindow->SetPointer(Pointer(POINTER_FILL));
		}
/*?*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		SdrHdl* pHdl = pView->HitHandle(aPnt, *pWindow);

/*N*/ 		if (SD_MOD()->GetWaterCan() && !pHdl)
/*?*/ 		{
			/******************************************************************
			* Giesskannenmodus
			******************************************************************/
/*?*/ 			bDefPointer = FALSE;
/*?*/ 			pWindow->SetPointer(Pointer(POINTER_FILL));
/*?*/ 		}
/*N*/ 		else if (!pHdl &&
/*N*/ 				 pViewShell->GetViewFrame()->HasChildWindow(SvxBmpMaskChildWindow::GetChildWindowId()))
/*N*/ 		{
			/******************************************************************
			* Pipettenmodus
			******************************************************************/
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SvxBmpMask* pMask = (SvxBmpMask*) pViewShell->GetViewFrame()->GetChildWindow(SvxBmpMaskChildWindow::GetChildWindowId())->GetWindow();
//STRIP001 
//STRIP001 			if (pMask && pMask->IsEyedropping())
//STRIP001 			{
//STRIP001 				bDefPointer = FALSE;
//STRIP001 				pWindow->SetPointer(Pointer(POINTER_REFHAND));
//STRIP001 			}
/*N*/ 		}
/*N*/ 		else if (!pView->IsAction())
/*N*/ 		{
/*N*/ 			SdrObject* pObj = NULL;
/*N*/ 			SdrPageView* pPV = NULL;
/*N*/ 			SdrViewEvent aVEvt;
/*N*/ 			SdrHitKind eHit = SDRHIT_NONE;
/*N*/ 			SdrDragMode eDragMode = pView->GetDragMode();
/*N*/ 			USHORT nHitLog(USHORT (pWindow->PixelToLogic(Size(HITPIX,0)).Width()));

/*N*/ 			if (pMEvt)
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 eHit = pView->PickAnything(*pMEvt, SDRMOUSEMOVE, aVEvt);
/*?*/ 			}

/*N*/ 			if ((eDragMode == SDRDRAG_ROTATE) && (eHit == SDRHIT_MARKEDOBJECT))
/*?*/ 			{
				// The goal of this request is show always the rotation-arrow for 3D-objects at rotation-modus
				// Independent of the settings at Extras->Optionen->Grafik "Objekte immer verschieben"
				// 2D-objects acquit in an other way. Otherwise, the rotation of 3d-objects around any axises
				// wouldn't be possible per default.
/*?*/ 				const SdrMarkList& rMarkList = pView->GetMarkList();
				SdrObject* pObject = rMarkList.GetMark(0)->GetObj();
				if ((pObject->ISA(E3dObject)) && (rMarkList.GetMarkCount() == 1))
				{
					pWindow->SetPointer(Pointer(POINTER_ROTATE));
					bDefPointer = FALSE;     // Otherwise it'll be calles Joes routine and the mousepointer will reconfigurate again
				}
			}

/*N*/ 			if (eHit == SDRHIT_NONE)
/*N*/ 			{
				// found nothing -> look after at the masterpage
/*N*/ 				pView->PickObj(aPnt, pObj, pPV, SDRSEARCH_ALSOONMASTER);
/*N*/ 			}
/*N*/ 			else if (eHit == SDRHIT_UNMARKEDOBJECT)
/*N*/ 			{
/*N*/ 				pObj = aVEvt.pObj;
/*N*/ 			}
/*N*/ 			else if (eHit == SDRHIT_TEXTEDITOBJ && this->ISA(FuSelection))
/*?*/ 			{
/*?*/ 				UINT16 nSdrObjKind = aVEvt.pObj->GetObjIdentifier();

				if ( nSdrObjKind != OBJ_TEXT		&&
					 nSdrObjKind != OBJ_TITLETEXT	&&
					 nSdrObjKind != OBJ_OUTLINETEXT &&
					 aVEvt.pObj->IsEmptyPresObj() )
				{
					pObj = NULL;
					bDefPointer = FALSE;
					pWindow->SetPointer(Pointer(POINTER_ARROW));
				}
/*?*/ 			}

/*N*/ 			if (pObj && pMEvt && !pMEvt->IsMod2() && this->ISA(FuSelection))
/*?*/ 			{
				// Auf Animation oder ImageMap pruefen
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 		bDefPointer = !SetPointer(pObj, aPnt);

//STRIP001 /*?*/ 				if (bDefPointer && (pObj->ISA(SdrObjGroup) || pObj->ISA(E3dPolyScene)))
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					// In die Gruppe hineinschauen
//STRIP001 /*?*/ 					if (pView->PickObj(aPnt, pObj, pPV, SDRSEARCH_ALSOONMASTER | SDRSEARCH_DEEP))
//STRIP001 /*?*/ 						bDefPointer = !SetPointer(pObj, aPnt);
//STRIP001 /*?*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}

/*N*/ 	if (bDefPointer)
/*N*/ 	{
/*N*/ 		pWindow->SetPointer(pView->GetPreferedPointer(
/*N*/ 							aPnt, pWindow, nModifier, bLeftDown));
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Set cursor for animaton or imagemap
|*
\************************************************************************/

//STRIP001 BOOL FuDraw::SetPointer(SdrObject* pObj, const Point& rPos)
//STRIP001 {
//STRIP001 	BOOL bSet = FALSE;
//STRIP001 
//STRIP001 	BOOL bAnimationInfo = (!pDocSh->ISA(SdGraphicDocShell) &&
//STRIP001 						  pDoc->GetAnimationInfo(pObj)) ? TRUE:FALSE;
//STRIP001 
//STRIP001 	BOOL bImageMapInfo = FALSE;
//STRIP001 
//STRIP001 	if (!bAnimationInfo)
//STRIP001 		bImageMapInfo = pDoc->GetIMapInfo(pObj) ? TRUE:FALSE;
//STRIP001 
//STRIP001 	if (bAnimationInfo || bImageMapInfo)
//STRIP001 	{
//STRIP001 		const SetOfByte* pVisiLayer = &pView->GetPageViewPvNum(0)->GetVisibleLayers();
//STRIP001 		USHORT nHitLog(USHORT (pWindow->PixelToLogic(Size(HITPIX,0)).Width()));
//STRIP001 		long  n2HitLog(nHitLog * 2);
//STRIP001 		Point aHitPosR(rPos);
//STRIP001 		Point aHitPosL(rPos);
//STRIP001 		Point aHitPosT(rPos);
//STRIP001 		Point aHitPosB(rPos);
//STRIP001 
//STRIP001 		aHitPosR.X() += n2HitLog;
//STRIP001 		aHitPosL.X() -= n2HitLog;
//STRIP001 		aHitPosT.Y() += n2HitLog;
//STRIP001 		aHitPosB.Y() -= n2HitLog;
//STRIP001 
//STRIP001 		if ( !pObj->IsClosedObj() ||
//STRIP001 			( pObj->IsHit(aHitPosR, nHitLog, pVisiLayer) &&
//STRIP001 			  pObj->IsHit(aHitPosL, nHitLog, pVisiLayer) &&
//STRIP001 			  pObj->IsHit(aHitPosT, nHitLog, pVisiLayer) &&
//STRIP001 			  pObj->IsHit(aHitPosB, nHitLog, pVisiLayer) ) )
//STRIP001 		{
//STRIP001 			/**********************************************************
//STRIP001 			* hit inside the object (without margin) or open object
//STRIP001 			********************************************************/
//STRIP001 
//STRIP001 			if (bAnimationInfo)
//STRIP001 			{
//STRIP001 				/******************************************************
//STRIP001 				* Click-Action
//STRIP001 				******************************************************/
//STRIP001 				SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObj);
//STRIP001 
//STRIP001 				if ((pView->ISA(SdDrawView)                        &&
//STRIP001 					 ((SdDrawView*) pView)->IsActionMode()         &&
//STRIP001 					  (pInfo->eClickAction == presentation::ClickAction_BOOKMARK  ||
//STRIP001 					   pInfo->eClickAction == presentation::ClickAction_DOCUMENT  ||
//STRIP001 					   pInfo->eClickAction == presentation::ClickAction_PREVPAGE  ||
//STRIP001 					   pInfo->eClickAction == presentation::ClickAction_NEXTPAGE  ||
//STRIP001 					   pInfo->eClickAction == presentation::ClickAction_FIRSTPAGE ||
//STRIP001 					   pInfo->eClickAction == presentation::ClickAction_LASTPAGE  ||
//STRIP001 					   pInfo->eClickAction == presentation::ClickAction_VERB      ||
//STRIP001 					   pInfo->eClickAction == presentation::ClickAction_PROGRAM   ||
//STRIP001 					   pInfo->eClickAction == presentation::ClickAction_MACRO     ||
//STRIP001 					   pInfo->eClickAction == presentation::ClickAction_SOUND))
//STRIP001 																	||
//STRIP001 					  (pView->ISA(SdDrawView)                        &&
//STRIP001 					   ((SdDrawView*) pView)->GetSlideShow()         &&
//STRIP001 						 (pInfo->eClickAction == presentation::ClickAction_VANISH    		  ||
//STRIP001 						  pInfo->eClickAction == presentation::ClickAction_INVISIBLE 		  ||
//STRIP001 						  pInfo->eClickAction == presentation::ClickAction_STOPPRESENTATION ||
//STRIP001 						 (pInfo->bActive &&
//STRIP001 						  ( pInfo->eEffect != presentation::AnimationEffect_NONE ||
//STRIP001 							pInfo->eTextEffect != presentation::AnimationEffect_NONE )))))
//STRIP001 					{
//STRIP001 						// Animations-Objekt
//STRIP001 						bSet = TRUE;
//STRIP001 						pWindow->SetPointer(Pointer(POINTER_REFHAND));
//STRIP001 					}
//STRIP001 			}
//STRIP001 			else if (bImageMapInfo &&
//STRIP001 					 pDoc->GetHitIMapObject(pObj, rPos, *pWindow))
//STRIP001 			{
//STRIP001 				/******************************************************
//STRIP001 				* ImageMap
//STRIP001 				******************************************************/
//STRIP001 				bSet = TRUE;
//STRIP001 				pWindow->SetPointer(Pointer(POINTER_REFHAND));
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bSet;
//STRIP001 }



/*************************************************************************
|*
|* Response of doubleclick
|*
\************************************************************************/

//STRIP001 void FuDraw::DoubleClick(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	SdrObject* pObj = NULL;
//STRIP001 	SdrPageView* pPV = NULL;
//STRIP001 	USHORT nHitLog = USHORT ( pWindow->PixelToLogic(Size(HITPIX,0)).Width() );
//STRIP001 
//STRIP001 	if ( pView->HasMarkedObj() )
//STRIP001 	{
//STRIP001 		const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 
//STRIP001 		if (rMarkList.GetMarkCount() == 1)
//STRIP001 		{
//STRIP001 			SdrMark* pMark = rMarkList.GetMark(0);
//STRIP001 			SdrObject* pObj = pMark->GetObj();
//STRIP001 
//STRIP001 			UINT32 nInv = pObj->GetObjInventor();
//STRIP001 			UINT16 nSdrObjKind = pObj->GetObjIdentifier();
//STRIP001 
//STRIP001 			if (nInv == SdrInventor && nSdrObjKind == OBJ_OLE2)
//STRIP001 			{
//STRIP001 				SdDrawDocShell* pDocSh = pDoc->GetDocSh();
//STRIP001 
//STRIP001 				if ( !pDocSh->IsUIActive() )
//STRIP001 				{
					/**********************************************************
					* aktivate OLE-object
					**********************************************************/
//STRIP001 					pView->HideMarkHdl(NULL);
//STRIP001 					pViewShell->ActivateObject( (SdrOle2Obj*) pObj, 0);
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else if (nInv == SdrInventor &&  nSdrObjKind == OBJ_GRAF && pObj->IsEmptyPresObj() )
//STRIP001 			{
//STRIP001 				pViewShell->GetViewFrame()->
//STRIP001 					GetDispatcher()->Execute( SID_INSERT_GRAPHIC,
//STRIP001 											  SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
//STRIP001 			}
//STRIP001 			else if ( ( pObj->ISA(SdrTextObj) || pObj->ISA(SdrObjGroup) ) &&
//STRIP001 					  !SD_MOD()->GetWaterCan()                            &&
//STRIP001 					  pViewShell->GetFrameView()->IsDoubleClickTextEdit() &&
//STRIP001 					  !pDocSh->IsReadOnly())
//STRIP001 			{
//STRIP001 				SfxUInt16Item aItem(SID_TEXTEDIT, 2);
//STRIP001 				pViewShell->GetViewFrame()->GetDispatcher()->
//STRIP001 								 Execute(SID_TEXTEDIT, SFX_CALLMODE_ASYNCHRON |
//STRIP001 										 SFX_CALLMODE_RECORD, &aItem, 0L);
//STRIP001 			}
//STRIP001 			else if (nInv == SdrInventor &&  nSdrObjKind == OBJ_GRUP)
//STRIP001 			{
//STRIP001 				// hit group -> select subobject
//STRIP001 				pView->UnMarkAll();
//STRIP001 				pView->MarkObj(aMDPos, nHitLog, rMEvt.IsShift(), TRUE);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pViewShell->GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 //STRIP001 }

/*************************************************************************
|*
|* Help-event
|*
\************************************************************************/

//STRIP001 BOOL FuDraw::RequestHelp(const HelpEvent& rHEvt)
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	if (Help::IsBalloonHelpEnabled() || Help::IsQuickHelpEnabled())
//STRIP001 	{
//STRIP001 		SdrViewEvent aVEvt;
//STRIP001 
//STRIP001 		MouseEvent aMEvt(pWindow->GetPointerPosPixel(), 1, 0, MOUSE_LEFT);
//STRIP001 
//STRIP001 		SdrHitKind eHit = pView->PickAnything(aMEvt, SDRMOUSEBUTTONDOWN, aVEvt);
//STRIP001 
//STRIP001 		SdrObject* pObj = aVEvt.pObj;
//STRIP001 
//STRIP001 		if (eHit != SDRHIT_NONE && pObj != NULL)
//STRIP001 		{
//STRIP001 			Point aPosPixel = rHEvt.GetMousePosPixel();
//STRIP001 
//STRIP001 			bReturn = SetHelpText(pObj, aPosPixel, aVEvt);
//STRIP001 
//STRIP001 			if (!bReturn && (pObj->ISA(SdrObjGroup) || pObj->ISA(E3dPolyScene)))
//STRIP001 			{
//STRIP001 				// In die Gruppe hineinschauen
//STRIP001 				SdrPageView* pPV = NULL;
//STRIP001 
//STRIP001 				Point aPos(pWindow->PixelToLogic(pWindow->ScreenToOutputPixel(aPosPixel)));
//STRIP001 
//STRIP001 				if (pView->PickObj(aPos, pObj, pPV, SDRSEARCH_ALSOONMASTER | SDRSEARCH_DEEP))
//STRIP001 					bReturn = SetHelpText(pObj, aPosPixel, aVEvt);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!bReturn)
//STRIP001 	{
//STRIP001 		bReturn = FuPoor::RequestHelp(rHEvt);
//STRIP001 	}
//STRIP001 
//STRIP001 	return(bReturn);
//STRIP001 }



/*************************************************************************
|*
|* Command-event
|*
\************************************************************************/

//STRIP001 BOOL FuDraw::SetHelpText(SdrObject* pObj, const Point& rPosPixel, const SdrViewEvent& rVEvt)
//STRIP001 {
//STRIP001 	BOOL bSet = FALSE;
//STRIP001 	String aHelpText;
//STRIP001 	Point aPos(pWindow->PixelToLogic(pWindow->ScreenToOutputPixel(rPosPixel)));
//STRIP001 
//STRIP001 	// URL fuer IMapObject unter Pointer ist Hilfetext
//STRIP001 	if ( pDoc->GetIMapInfo(pObj) )
//STRIP001 	{
//STRIP001 		IMapObject* pIMapObj = pDoc->GetHitIMapObject(pObj, aPos, *pWindow );
//STRIP001 
//STRIP001 		if ( pIMapObj )
//STRIP001 		{
//STRIP001 			// show name
//STRIP001 			aHelpText = pIMapObj->GetDescription();
//STRIP001 
//STRIP001 			if (aHelpText.Len() == 0)
//STRIP001 			{
//STRIP001 				// show url if no name is available
//STRIP001 				aHelpText = INetURLObject::decode( pIMapObj->GetURL(), '%', INetURLObject::DECODE_WITH_CHARSET );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if (!pDocSh->ISA(SdGraphicDocShell) && pDoc->GetAnimationInfo(pObj))
//STRIP001 	{
//STRIP001 		SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObj);
//STRIP001 
//STRIP001 		switch (pInfo->eClickAction)
//STRIP001 		{
//STRIP001 			case presentation::ClickAction_PREVPAGE:
//STRIP001 			{
//STRIP001 				// jump to the prior page
//STRIP001 				aHelpText = String(SdResId(STR_CLICK_ACTION_PREVPAGE));
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case presentation::ClickAction_NEXTPAGE:
//STRIP001 			{
//STRIP001 				// jump to the next page
//STRIP001 				aHelpText = String(SdResId(STR_CLICK_ACTION_NEXTPAGE));
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case presentation::ClickAction_FIRSTPAGE:
//STRIP001 			{
//STRIP001 				// jump to the first page
//STRIP001 				aHelpText = String(SdResId(STR_CLICK_ACTION_FIRSTPAGE));
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case presentation::ClickAction_LASTPAGE:
//STRIP001 			{
//STRIP001 				// jump to the last page
//STRIP001 				aHelpText = String(SdResId(STR_CLICK_ACTION_LASTPAGE));
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case presentation::ClickAction_BOOKMARK:
//STRIP001 			{
//STRIP001 				// jump to object/page
//STRIP001 				aHelpText = String(SdResId(STR_CLICK_ACTION_BOOKMARK));
//STRIP001 				aHelpText.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 				aHelpText.Append( INetURLObject::decode( pInfo->aBookmark, '%', INetURLObject::DECODE_WITH_CHARSET ) );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case presentation::ClickAction_DOCUMENT:
//STRIP001 			{
//STRIP001 				// jump to document (object/page)
//STRIP001 				aHelpText = String(SdResId(STR_CLICK_ACTION_DOCUMENT));
//STRIP001 				aHelpText.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 				aHelpText.Append( INetURLObject::decode( pInfo->aBookmark, '%', INetURLObject::DECODE_WITH_CHARSET ) );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case presentation::ClickAction_PROGRAM:
//STRIP001 			{
//STRIP001 				// execute program
//STRIP001 				aHelpText = String(SdResId(STR_CLICK_ACTION_PROGRAM));
//STRIP001 				aHelpText.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 				aHelpText.Append( INetURLObject::decode( pInfo->aBookmark, '%', INetURLObject::DECODE_WITH_CHARSET ) );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case presentation::ClickAction_MACRO:
//STRIP001 			{
//STRIP001 				// execute program
//STRIP001 				aHelpText = String(SdResId(STR_CLICK_ACTION_MACRO));
//STRIP001 				aHelpText.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 
//STRIP001 				sal_Unicode cToken = '.';
//STRIP001 				aHelpText.Append( pInfo->aBookmark.GetToken( 2, cToken ) );
//STRIP001 				aHelpText.Append( cToken );
//STRIP001 				aHelpText.Append( pInfo->aBookmark.GetToken( 1, cToken ) );
//STRIP001 				aHelpText.Append( cToken );
//STRIP001 				aHelpText.Append(  pInfo->aBookmark.GetToken( 0, cToken ) );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case presentation::ClickAction_SOUND:
//STRIP001 			{
//STRIP001 				// play-back sound
//STRIP001 				aHelpText = String(SdResId(STR_CLICK_ACTION_SOUND));
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case presentation::ClickAction_VERB:
//STRIP001 			{
//STRIP001 				// execute OLE-verb
//STRIP001 				aHelpText = String(SdResId(STR_CLICK_ACTION_VERB));
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case presentation::ClickAction_STOPPRESENTATION:
//STRIP001 			{
//STRIP001 				// quit presentation
//STRIP001 				aHelpText = String(SdResId(STR_CLICK_ACTION_STOPPRESENTATION));
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if (rVEvt.pURLField)
//STRIP001 	{
		/**************************************************************
		* URL-Field
		**************************************************************/
//STRIP001 		aHelpText = INetURLObject::decode( rVEvt.pURLField->GetURL(), '%', INetURLObject::DECODE_WITH_CHARSET );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (aHelpText.Len())
//STRIP001 	{
//STRIP001 		bSet = TRUE;
//STRIP001 		Rectangle aLogicPix = pWindow->LogicToPixel(pObj->GetLogicRect());
//STRIP001 		Rectangle aScreenRect(pWindow->OutputToScreenPixel(aLogicPix.TopLeft()),
//STRIP001 							  pWindow->OutputToScreenPixel(aLogicPix.BottomRight()));
//STRIP001 
//STRIP001 		if (Help::IsBalloonHelpEnabled())
//STRIP001 			Help::ShowBalloon( (Window*)pWindow, rPosPixel, aScreenRect, aHelpText);
//STRIP001 		else if (Help::IsQuickHelpEnabled())
//STRIP001 			Help::ShowQuickHelp( (Window*)pWindow, aScreenRect, aHelpText);
//STRIP001 	}
//STRIP001 
//STRIP001 	return bSet;
//STRIP001 }


/** is called when the currenct function should be aborted. <p>
	This is used when a function gets a KEY_ESCAPE but can also
	be called directly.

	@returns true if a active function was aborted
*/
//STRIP001 bool FuDraw::cancel()
//STRIP001 {
//STRIP001 	bool bReturn = false;
//STRIP001 
//STRIP001 	if ( pView->IsAction() )
//STRIP001 	{
//STRIP001 		pView->BrkAction();
//STRIP001 		bReturn = true;
//STRIP001 	}
//STRIP001 	else if ( pView->IsTextEdit() )
//STRIP001 	{
//STRIP001 		pView->EndTextEdit();
//STRIP001 		bReturn = true;
//STRIP001 
//STRIP001 		SfxBindings& rBindings = pViewShell->GetViewFrame()->GetBindings();
//STRIP001 		rBindings.Invalidate( SID_PARASPACE_INCREASE );
//STRIP001 		rBindings.Invalidate( SID_PARASPACE_DECREASE );
//STRIP001 	}
//STRIP001 	else if ( pView->HasMarkedObj() )
//STRIP001 	{
//STRIP001 		// #97016# II
//STRIP001 		const SdrHdlList& rHdlList = pView->GetHdlList();
//STRIP001 		SdrHdl* pHdl = rHdlList.GetFocusHdl();
//STRIP001 
//STRIP001 		if(pHdl)
//STRIP001 		{
//STRIP001 			((SdrHdlList&)rHdlList).ResetFocusHdl();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pView->UnmarkAll();
//STRIP001 		}
//STRIP001 
//STRIP001         // Switch to FuSelect.
//STRIP001         pViewShell->GetViewFrame()->GetDispatcher()->Execute(
//STRIP001             SID_OBJECT_SELECT, 
//STRIP001             SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 
//STRIP001 		bReturn = true;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bReturn;
//STRIP001 }
}
