/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_hdrcont.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:28:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #include <vcl/help.hxx>
// auto strip #include <tools/poly.hxx>
// auto strip #include <svtools/colorcfg.hxx>

// auto strip #include "scresid.hxx"
#include "bf_sc.hrc"
// auto strip #include "tabvwsh.hxx"
#include "hdrcont.hxx"
#include "scmod.hxx"		// Optionen
#include "inputopt.hxx"		// Optionen
// auto strip #include "gridmerg.hxx"
namespace binfilter {

// -----------------------------------------------------------------------

#define SC_DRAG_MIN		2

//	passes in paint
//	(selection left/right must be first because the continuous lines
//	are partly overwritten later)

#define SC_HDRPAINT_SEL_RIGHT	0
#define SC_HDRPAINT_SEL_LEFT	1
#define SC_HDRPAINT_TOP			2
#define SC_HDRPAINT_SEL_TOP		3
#define SC_HDRPAINT_SEL_BOTTOM	4
#define SC_HDRPAINT_BOTTOM		5
#define SC_HDRPAINT_TEXT		6
#define SC_HDRPAINT_COUNT		7

//==================================================================

/*M*/ ScHeaderControl::ScHeaderControl( Window* pParent, SelectionEngine* pSelectionEngine,
/*M*/ 									USHORT nNewSize, USHORT nNewFlags ) :
/*M*/ 			Window		( pParent ),
/*M*/ 			pSelEngine	( pSelectionEngine ),
/*M*/ 			nSize		( nNewSize ),
/*M*/ 			nFlags		( nNewFlags ),
/*M*/ 			bVertical	( (nNewFlags & HDR_VERTICAL) != 0 ),
/*M*/ 			bDragging	( FALSE ),
/*M*/ 			bIgnoreMove	( FALSE ),
/*M*/ 			nMarkStart	( 0 ),
/*M*/ 			nMarkEnd	( 0 ),
/*M*/ 			bMarkRange	( FALSE )
/*M*/ {
/*M*/     // --- RTL --- no default mirroring for this window, the spreadsheet itself
/*M*/     // is also not mirrored
/*N*/     // #107811# mirror the vertical window for correct border drawing
/*N*/     EnableRTL ( bVertical );
/*M*/ 
/*M*/ 	aNormFont = GetFont();
/*M*/ 	aNormFont.SetTransparent( TRUE );		//! WEIGHT_NORMAL hart setzen ???
/*M*/ 	aBoldFont = aNormFont;
/*M*/ 	aBoldFont.SetWeight( WEIGHT_BOLD );
/*M*/ 
/*M*/ 	SetFont(aBoldFont);
/*M*/ 	bBoldSet = TRUE;
/*M*/ 
/*M*/ 	Size aSize = LogicToPixel( Size(
/*M*/ 		GetTextWidth( String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("8888")) ),
/*M*/ 		GetTextHeight() ) );
/*M*/ 	aSize.Width()  += 4;	// Platz fuer hervorgehobene Umrandung
/*M*/ 	aSize.Height() += 3;
/*M*/ 	SetSizePixel( aSize );
/*M*/ 
/*M*/ 	nWidth = nSmallWidth = aSize.Width();
/*M*/ 	nBigWidth = LogicToPixel( Size( GetTextWidth(
/*M*/ 		String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("88888")) ), 0 ) ).Width() + 4;
/*M*/ 
/*M*/ 	SetBackground();	// sonst Probleme auf OS/2 !?!?!
/*M*/ }

/*N*/ void ScHeaderControl::SetWidth( long nNew )
/*N*/ {
/*N*/ 	DBG_ASSERT( bVertical, "SetDigits nur fuer Zeilenkoepfe erlaubt" );
/*N*/ 	if ( nNew != nWidth )
/*N*/ 	{
/*N*/ 		Size aSize( nNew, GetSizePixel().Height() );	// Hoehe nicht aendern
/*N*/ 		SetSizePixel( aSize );
/*N*/ 
/*N*/ 		nWidth = nNew;
/*N*/ 
/*N*/ 		Invalidate();		// neu zentrieren
/*N*/ 	}
/*N*/ }

/*N*/ __EXPORT ScHeaderControl::~ScHeaderControl()
/*N*/ {
/*N*/ }

/*N*/ void ScHeaderControl::DoPaint( USHORT nStart, USHORT nEnd )
/*N*/ {
/*N*/ 	Rectangle aRect( Point(0,0), GetOutputSizePixel() );
/*N*/ 	if ( bVertical )
/*N*/ 	{
/*N*/ 		aRect.Top() = GetScrPos( nStart );
/*N*/ 		aRect.Bottom() = GetScrPos( nEnd+1 )-1;
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		aRect.Left() = GetScrPos( nStart );
/*N*/ 		aRect.Right() = GetScrPos( nEnd+1 )-1;
/*N*/ 	}
/*N*/ 	Invalidate(aRect);
/*N*/ }

/*N*/ void ScHeaderControl::SetMark( BOOL bNewSet, USHORT nNewStart, USHORT nNewEnd )
/*N*/ {
/*N*/ 	BOOL bEnabled = SC_MOD()->GetInputOptions().GetMarkHeader();	//! cachen?
/*N*/ 	if (!bEnabled)
/*N*/ 		bNewSet = FALSE;
/*N*/ 
/*N*/ 	//	Variablen setzen
/*N*/ 
/*N*/ 	BOOL bOldSet	 = bMarkRange;
/*N*/ 	USHORT nOldStart = nMarkStart;
/*N*/ 	USHORT nOldEnd	 = nMarkEnd;
/*N*/ 	PutInOrder( nNewStart, nNewEnd );
/*N*/ 	bMarkRange = bNewSet;
/*N*/ 	nMarkStart = nNewStart;
/*N*/ 	nMarkEnd   = nNewEnd;
/*N*/ 
/*N*/ 	//	Paint
/*N*/ 
/*N*/ 	if ( bNewSet )
/*N*/ 	{
/*N*/ 		if ( bOldSet )
/*N*/ 		{
/*N*/ 			if ( nNewStart == nOldStart )
/*N*/ 			{
/*N*/ 				if ( nNewEnd != nOldEnd )
/*?*/ 					DoPaint( Min( nNewEnd, nOldEnd ) + 1, Max( nNewEnd, nOldEnd ) );
/*N*/ 				// sonst nix
/*N*/ 			}
/*N*/ 			else if ( nNewEnd == nOldEnd )
/*?*/ 				DoPaint( Min( nNewStart, nOldStart ), Max( nNewStart, nOldStart ) - 1 );
/*N*/ 			else if ( nNewStart > nOldEnd || nNewEnd < nOldStart )
/*N*/ 			{
/*?*/ 				//	zwei Bereiche...
/*?*/ 				DoPaint( nOldStart, nOldEnd );
/*?*/ 				DoPaint( nNewStart, nNewEnd );
/*N*/ 			}
/*N*/ 			else				//	irgendwie ueberlappend... (kommt eh nicht oft vor)
/*?*/ 				DoPaint( Min( nNewStart, nOldStart ), Max( nNewEnd, nOldEnd ) );
/*N*/ 		}
/*N*/ 		else
/*N*/ 			DoPaint( nNewStart, nNewEnd );		//	komplett neu
/*N*/ 	}
/*N*/ 	else if ( bOldSet )
/*?*/ 		DoPaint( nOldStart, nOldEnd );			//	komplett aufheben
/*N*/ 
/*N*/ 	//	sonst war nix, is nix
/*N*/ }

/*N*/ long ScHeaderControl::GetScrPos( USHORT nEntryNo )
/*N*/ {
/*N*/ 	long nScrPos;
/*N*/ 
/*N*/ 	long nMax = ( bVertical ? GetOutputSizePixel().Height() : GetOutputSizePixel().Width() ) + 1;
/*N*/ 	if (nEntryNo >= nSize)
/*N*/ 		nScrPos = nMax;
/*N*/ 	else
/*N*/ 	{
/*N*/ 		nScrPos = 0;
/*N*/ 		for (USHORT i=GetPos(); i<nEntryNo && nScrPos<nMax; i++)
/*N*/ 		{
/*N*/ 			USHORT nAdd = GetEntrySize(i);
/*N*/ 			if (nAdd)
/*N*/ 				nScrPos += nAdd;
/*N*/ 			else
/*N*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 				USHORT nHidden = GetHiddenCount(i);
//STRIP001 /*?*/ 				if (nHidden)
//STRIP001 /*?*/ 					i += nHidden - 1;
/*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	return nScrPos;
/*N*/ }

//
//		Paint
//

//STRIP001 void __EXPORT ScHeaderControl::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	//	fuer VCL ist es wichtig, wenig Aufrufe zu haben, darum werden die aeusseren
//STRIP001 	//	Linien zusammengefasst
//STRIP001 
//STRIP001 	const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();
//STRIP001 	BOOL bDark = rStyleSettings.GetFaceColor().IsDark();
//STRIP001 	// Use the same distinction for bDark as in Window::DrawSelectionBackground
//STRIP001 
//STRIP001 	Color aTextColor = rStyleSettings.GetButtonTextColor();
//STRIP001 	SetTextColor( aTextColor );
//STRIP001 	aNormFont.SetColor( aTextColor );
//STRIP001 	aBoldFont.SetColor( aTextColor );
//STRIP001 
//STRIP001 	const FunctionSet*	pFuncSet = pSelEngine->GetFunctionSet();
//STRIP001 	String				aString;
//STRIP001 	USHORT				nBarSize;
//STRIP001 	Point				aScrPos;
//STRIP001 	Point				aEndPos;
//STRIP001 	Size				aTextSize;
//STRIP001 	Size				aSize = GetOutputSizePixel();
//STRIP001 
//STRIP001 	if (bVertical)
//STRIP001 		nBarSize = (USHORT) GetSizePixel().Width();
//STRIP001 	else
//STRIP001 		nBarSize = (USHORT) GetSizePixel().Height();
//STRIP001 
//STRIP001 	USHORT	nPos = GetPos();
//STRIP001 
//STRIP001 	long nPStart = bVertical ? rRect.Top() : rRect.Left();
//STRIP001 	long nPEnd = bVertical ? rRect.Bottom() : rRect.Right();
//STRIP001 
//STRIP001 	long nTransStart = nPEnd;
//STRIP001 	long nTransEnd = 0;
//STRIP001 
//STRIP001 	//	aeussere Linien komplett durchzeichnen
//STRIP001 	//	Zuerst Ende der letzten Zelle finden
//STRIP001 
//STRIP001 	long nLineEnd = -1;
//STRIP001 	for (USHORT i=nPos; i<nSize; i++)
//STRIP001 	{
//STRIP001 		USHORT nSizePix = GetEntrySize( i );
//STRIP001 		if (nSizePix)
//STRIP001 		{
//STRIP001 			nLineEnd += nSizePix;
//STRIP001 
//STRIP001 			if ( bMarkRange && i >= nMarkStart && i <= nMarkEnd )
//STRIP001 			{
//STRIP001 				long nLineStart = nLineEnd - nSizePix + 1;
//STRIP001 				if ( nLineStart < nTransStart )
//STRIP001 					nTransStart = nLineStart;
//STRIP001 				if ( nLineEnd > nTransEnd )
//STRIP001 					nTransEnd = nLineEnd;
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( nLineEnd > nPEnd )
//STRIP001 			{
//STRIP001 				nLineEnd = nPEnd;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			USHORT nHidden = GetHiddenCount(i);
//STRIP001 			if (nHidden)
//STRIP001 				i += nHidden - 1;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//	background is different for entry area and behind the entries
//STRIP001 
//STRIP001 	Rectangle aFillRect;
//STRIP001 	SetLineColor();
//STRIP001 
//STRIP001 	if ( nLineEnd >= 0 )
//STRIP001 	{
//STRIP001 		SetFillColor( rStyleSettings.GetFaceColor() );
//STRIP001 		if ( bVertical )
//STRIP001 			aFillRect = Rectangle( 0, 0, nBarSize-1, nLineEnd );
//STRIP001 		else
//STRIP001 			aFillRect = Rectangle( 0, 0, nLineEnd, nBarSize-1 );
//STRIP001 		DrawRect( aFillRect );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nLineEnd < nPEnd )
//STRIP001 	{
//STRIP001         SetFillColor( SC_MOD()->GetColorConfig().GetColorValue(svtools::APPBACKGROUND).nColor );
//STRIP001 		if ( bVertical )
//STRIP001 			aFillRect = Rectangle( 0, nLineEnd+1, nBarSize-1, nPEnd );
//STRIP001 		else
//STRIP001 			aFillRect = Rectangle( nLineEnd+1, 0, nPEnd, nBarSize-1 );
//STRIP001 		DrawRect( aFillRect );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nLineEnd >= nPStart )
//STRIP001 	{
//STRIP001 		if ( nTransEnd >= nTransStart && bDark )
//STRIP001 		{
//STRIP001 			//	solid grey background for dark face color is drawn before lines
//STRIP001 
//STRIP001 			SetLineColor();
//STRIP001 			SetFillColor( COL_LIGHTGRAY );
//STRIP001 			if (bVertical)
//STRIP001 				DrawRect( Rectangle( 0, nTransStart, nBarSize-1, nTransEnd ) );
//STRIP001 			else
//STRIP001 				DrawRect( Rectangle( nTransStart, 0, nTransEnd, nBarSize-1 ) );
//STRIP001 		}
//STRIP001 
//STRIP001 #if 0
//STRIP001 		// 3D border is no longer used
//STRIP001 		SetLineColor( rStyleSettings.GetLightColor() );
//STRIP001 		if (bVertical)
//STRIP001 			DrawLine( Point( 0, nPStart ), Point( 0, nLineEnd ) );
//STRIP001 		else
//STRIP001 			DrawLine( Point( nPStart, 0 ), Point( nLineEnd, 0 ) );
//STRIP001 #endif
//STRIP001 
//STRIP001 		SetLineColor( rStyleSettings.GetDarkShadowColor() );
//STRIP001 		if (bVertical)
//STRIP001 			DrawLine( Point( nBarSize-1, nPStart ), Point( nBarSize-1, nLineEnd ) );
//STRIP001 		else
//STRIP001 			DrawLine( Point( nPStart, nBarSize-1 ), Point( nLineEnd, nBarSize-1 ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	//
//STRIP001 	//	loop through entries several times to avoid changing the line color too often
//STRIP001 	//	and to allow merging of lines
//STRIP001 	//
//STRIP001 
//STRIP001 	ScGridMerger aGrid( this, 1, 1 );
//STRIP001 
//STRIP001 	//	start at SC_HDRPAINT_BOTTOM instead of 0 - selection doesn't get different
//STRIP001 	//	borders, light border at top isn't used anymore
//STRIP001 
//STRIP001 	for (USHORT nPass = SC_HDRPAINT_BOTTOM; nPass < SC_HDRPAINT_COUNT; nPass++)
//STRIP001 	{
//STRIP001 		//	set line color etc. before entry loop
//STRIP001 		switch ( nPass )
//STRIP001 		{
//STRIP001 #if 0
//STRIP001 			case SC_HDRPAINT_SEL_RIGHT:
//STRIP001 				SetLineColor( rStyleSettings.GetShadowColor() );
//STRIP001 				break;
//STRIP001 			case SC_HDRPAINT_SEL_LEFT:
//STRIP001 				SetLineColor( rStyleSettings.GetLightColor() );
//STRIP001 				break;
//STRIP001 			case SC_HDRPAINT_TOP:
//STRIP001 				SetLineColor( rStyleSettings.GetLightColor() );
//STRIP001 				break;
//STRIP001 			case SC_HDRPAINT_SEL_TOP:
//STRIP001 				SetLineColor( rStyleSettings.GetLightColor() );
//STRIP001 				break;
//STRIP001 			case SC_HDRPAINT_SEL_BOTTOM:
//STRIP001 				SetLineColor( rStyleSettings.GetShadowColor() );
//STRIP001 				break;
//STRIP001 #endif
//STRIP001 			case SC_HDRPAINT_BOTTOM:
//STRIP001 				SetLineColor( rStyleSettings.GetDarkShadowColor() );
//STRIP001 				break;
//STRIP001 			case SC_HDRPAINT_TEXT:
//STRIP001 				if ( nTransEnd >= nTransStart && !bDark )
//STRIP001 				{
//STRIP001 					//	Transparent selection background is drawn after lines, before text.
//STRIP001 					//	#109814# Use DrawSelectionBackground to make sure there is a visible
//STRIP001 					//	difference. The case of a dark face color, where DrawSelectionBackground
//STRIP001 					//	would just paint over the lines, is handled separately (bDark).
//STRIP001 					//	Otherwise, GetHighlightColor is used with 80% transparency.
//STRIP001 					//	The window's background color (SetBackground) has to be the background
//STRIP001 					//	of the cell area, for the contrast comparison in DrawSelectionBackground.
//STRIP001 
//STRIP001 					Rectangle aTransRect;
//STRIP001 					if (bVertical)
//STRIP001 						aTransRect = Rectangle( 0, nTransStart, nBarSize-1, nTransEnd );
//STRIP001 					else
//STRIP001 						aTransRect = Rectangle( nTransStart, 0, nTransEnd, nBarSize-1 );
//STRIP001 					SetBackground( Color( rStyleSettings.GetFaceColor() ) );
//STRIP001 					DrawSelectionBackground( aTransRect, 0, TRUE, FALSE, FALSE );
//STRIP001 					SetBackground();
//STRIP001 				}
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT	nCount=0;
//STRIP001 		long	nScrPos=0;
//STRIP001 		do
//STRIP001 		{
//STRIP001 			if (bVertical)
//STRIP001 				aScrPos = Point( 0, nScrPos );
//STRIP001 			else
//STRIP001 				aScrPos = Point( nScrPos, 0 );
//STRIP001 
//STRIP001 			USHORT	nEntryNo = nCount + nPos;
//STRIP001 			if ( nEntryNo >= nSize )				// MAXCOL/MAXROW
//STRIP001 				nScrPos = nPEnd + 1;				//	ausserhalb -> Ende
//STRIP001 			else
//STRIP001 			{
//STRIP001 				USHORT nSizePix = GetEntrySize( nEntryNo );
//STRIP001 
//STRIP001 				if (nSizePix == 0)
//STRIP001 				{
//STRIP001 					USHORT nHidden = GetHiddenCount(nEntryNo);
//STRIP001 					if (nHidden)
//STRIP001 						nCount += nHidden - 1;
//STRIP001 				}
//STRIP001 				else if (nScrPos+nSizePix >= nPStart)
//STRIP001 				{
//STRIP001 					Point aEndPos(aScrPos);
//STRIP001 					if (bVertical)
//STRIP001 						aEndPos = Point( aScrPos.X()+nBarSize-1, aScrPos.Y()+nSizePix-1 );
//STRIP001 					else
//STRIP001 						aEndPos = Point( aScrPos.X()+nSizePix-1, aScrPos.Y()+nBarSize-1 );
//STRIP001 
//STRIP001 					BOOL bMark = bMarkRange && nEntryNo >= nMarkStart && nEntryNo <= nMarkEnd;
//STRIP001 
//STRIP001 					switch ( nPass )
//STRIP001 					{
//STRIP001 #if 0
//STRIP001 						case SC_HDRPAINT_SEL_LEFT:
//STRIP001 							if (bMark)
//STRIP001 							{
//STRIP001 								// continuous line - partly overwritten later
//STRIP001 								if (bVertical)
//STRIP001 									aGrid.AddVerLine( aScrPos.X()+1, aScrPos.Y(), aEndPos.Y() );
//STRIP001 								else
//STRIP001 									aGrid.AddHorLine( aScrPos.X(), aEndPos.X(), aScrPos.Y()+1 );
//STRIP001 							}
//STRIP001 							break;
//STRIP001 
//STRIP001 						case SC_HDRPAINT_SEL_TOP:
//STRIP001 							if (bMark)
//STRIP001 							{
//STRIP001 								if (bVertical)
//STRIP001 									aGrid.AddHorLine( aScrPos.X()+1, aEndPos.X()-2, aScrPos.Y()+1 );
//STRIP001 								else
//STRIP001 									aGrid.AddVerLine( aScrPos.X()+1, aScrPos.Y()+1, aEndPos.Y()-2 );
//STRIP001 							}
//STRIP001 							break;
//STRIP001 
//STRIP001 						case SC_HDRPAINT_SEL_RIGHT:
//STRIP001 							if (bMark)
//STRIP001 							{
//STRIP001 								// continuous line - partly overwritten later
//STRIP001 								if (bVertical)
//STRIP001 									aGrid.AddVerLine( aEndPos.X()-1, aScrPos.Y(), aEndPos.Y() );
//STRIP001 								else
//STRIP001 									aGrid.AddHorLine( aScrPos.X(), aEndPos.X(), aEndPos.Y()-1 );
//STRIP001 							}
//STRIP001 							break;
//STRIP001 
//STRIP001 						case SC_HDRPAINT_SEL_BOTTOM:
//STRIP001 							if (bMark)
//STRIP001 							{
//STRIP001 								if (bVertical)
//STRIP001 									aGrid.AddHorLine( aScrPos.X()+1, aEndPos.X()-1, aEndPos.Y()-1 );
//STRIP001 								else
//STRIP001 									aGrid.AddVerLine( aEndPos.X()-1, aScrPos.Y()+1, aEndPos.Y()-1 );
//STRIP001 							}
//STRIP001 							break;
//STRIP001 
//STRIP001 						case SC_HDRPAINT_TOP:
//STRIP001 							if (bVertical)
//STRIP001 								aGrid.AddHorLine( aScrPos.X(), aEndPos.X()-1, aScrPos.Y() );
//STRIP001 							else
//STRIP001 								aGrid.AddVerLine( aScrPos.X(), aScrPos.Y(), aEndPos.Y()-1 );
//STRIP001 							break;
//STRIP001 #endif
//STRIP001 
//STRIP001 						case SC_HDRPAINT_BOTTOM:
//STRIP001 							if (bVertical)
//STRIP001 								aGrid.AddHorLine( aScrPos.X(), aEndPos.X(), aEndPos.Y() );
//STRIP001 							else
//STRIP001 								aGrid.AddVerLine( aEndPos.X(), aScrPos.Y(), aEndPos.Y() );
//STRIP001 
//STRIP001 							//	thick bottom for hidden rows
//STRIP001 							//	(drawn directly, without aGrid)
//STRIP001 							if ( nEntryNo+1 < nSize )
//STRIP001 								if ( GetEntrySize(nEntryNo+1)==0 )
//STRIP001 								{
//STRIP001 									if (bVertical)
//STRIP001 										DrawLine( Point(aScrPos.X(),aEndPos.Y()-1),
//STRIP001 												  Point(aEndPos.X(),aEndPos.Y()-1) );
//STRIP001 									else
//STRIP001 										DrawLine( Point(aEndPos.X()-1,aScrPos.Y()),
//STRIP001 												  Point(aEndPos.X()-1,aEndPos.Y()) );
//STRIP001 								}
//STRIP001 							break;
//STRIP001 
//STRIP001 						case SC_HDRPAINT_TEXT:
//STRIP001 							if ( nSizePix > 1 )		// minimal check for small columns/rows
//STRIP001 							{
//STRIP001 								if ( bMark != bBoldSet )
//STRIP001 								{
//STRIP001 									if (bMark)
//STRIP001 										SetFont(aBoldFont);
//STRIP001 									else
//STRIP001 										SetFont(aNormFont);
//STRIP001 									bBoldSet = bMark;
//STRIP001 								}
//STRIP001 								aString = GetEntryText( nEntryNo );
//STRIP001 								aTextSize.Width() = GetTextWidth( aString );
//STRIP001 								aTextSize.Height() = GetTextHeight();
//STRIP001 
//STRIP001 								Point aTxtPos(aScrPos);
//STRIP001 								if (bVertical)
//STRIP001 								{
//STRIP001 									aTxtPos.X() += (nBarSize-aTextSize.Width())/2;
//STRIP001 									aTxtPos.Y() += (nSizePix-aTextSize.Height())/2;
//STRIP001 								}
//STRIP001 								else
//STRIP001 								{
//STRIP001 									aTxtPos.X() += (nSizePix-aTextSize.Width()+1)/2;
//STRIP001 									aTxtPos.Y() += (nBarSize-aTextSize.Height()+1)/2;
//STRIP001 								}
//STRIP001 								DrawText( aTxtPos, aString );
//STRIP001 							}
//STRIP001 							break;
//STRIP001 					}
//STRIP001 
//STRIP001 					//	bei Selektion der ganzen Zeile/Spalte:
//STRIP001 					//	InvertRect( Rectangle( aScrPos, aEndPos ) );
//STRIP001 				}
//STRIP001 				nScrPos += nSizePix;	// auch wenn noch oberhalb
//STRIP001 			}
//STRIP001 			++nCount;
//STRIP001 		}
//STRIP001 		while ( nScrPos <= nPEnd );
//STRIP001 
//STRIP001 		aGrid.Flush();
//STRIP001 	}
//STRIP001 }

//
//		Maus - Handling
//

//STRIP001 USHORT ScHeaderControl::GetMousePos( const MouseEvent& rMEvt, BOOL& rBorder )
//STRIP001 {
//STRIP001 	BOOL	bFound=FALSE;
//STRIP001 	USHORT	nCount = 1;
//STRIP001 	USHORT	nPos = GetPos();
//STRIP001 	USHORT	nHitNo = nPos;
//STRIP001 	long	nScrPos;
//STRIP001 	long	nMousePos = bVertical ? rMEvt.GetPosPixel().Y() : rMEvt.GetPosPixel().X();
//STRIP001 	long	nDif;
//STRIP001 	Size	aSize = GetOutputSizePixel();
//STRIP001 
//STRIP001 	nScrPos = GetScrPos( nPos ) - 1;
//STRIP001 	do
//STRIP001 	{
//STRIP001 		USHORT nEntryNo = nCount + nPos;
//STRIP001 
//STRIP001 //		nScrPos = GetScrPos( nEntryNo ) - 1;
//STRIP001 
//STRIP001 		if (nEntryNo >= nSize)
//STRIP001 			nScrPos = ( bVertical ? GetOutputSizePixel().Height() : GetOutputSizePixel().Width() ) + 1;
//STRIP001 		else
//STRIP001 			nScrPos += GetEntrySize( nEntryNo - 1 );		//! GetHiddenCount() ??
//STRIP001 
//STRIP001 		nDif = nMousePos - nScrPos;
//STRIP001 		if (nDif >= -2 && nDif <= 2 && nCount > 0)
//STRIP001 		{
//STRIP001 			bFound=TRUE;
//STRIP001 			nHitNo=nEntryNo-1;
//STRIP001 		}
//STRIP001 		else if (nDif >= 0)
//STRIP001 			nHitNo = nEntryNo;
//STRIP001 		++nCount;
//STRIP001 	}
//STRIP001 	while ( nScrPos < ( bVertical ? aSize.Height() : aSize.Width() ) && nDif > 0 );
//STRIP001 
//STRIP001 	rBorder = bFound;
//STRIP001 	return nHitNo;
//STRIP001 }

//STRIP001 void __EXPORT ScHeaderControl::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	if (IsDisabled())
//STRIP001 		return;
//STRIP001 
//STRIP001 	bIgnoreMove = FALSE;
//STRIP001 	SelectWindow();
//STRIP001 
//STRIP001 	BOOL bFound;
//STRIP001 	USHORT nHitNo = GetMousePos( rMEvt, bFound );
//STRIP001 
//STRIP001 	if ( bFound && rMEvt.IsLeft() && ResizeAllowed() )
//STRIP001 	{
//STRIP001 		nDragNo = nHitNo;
//STRIP001 		USHORT nClicks = rMEvt.GetClicks();
//STRIP001 		if ( nClicks && nClicks%2==0 )
//STRIP001 		{
//STRIP001 			SetEntrySize( nDragNo, HDR_SIZE_OPTIMUM );
//STRIP001 			SetPointer( Pointer( POINTER_ARROW ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if (bVertical)
//STRIP001 				nDragStart = rMEvt.GetPosPixel().Y();
//STRIP001 			else
//STRIP001 				nDragStart = rMEvt.GetPosPixel().X();
//STRIP001 			nDragPos = nDragStart;
//STRIP001 			ShowDragHelp();
//STRIP001 			DrawInvert( nDragPos );
//STRIP001 
//STRIP001 			// CaptureMouse();
//STRIP001 			StartTracking();
//STRIP001 			bDragging = TRUE;
//STRIP001 			bDragMoved = FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if (rMEvt.IsLeft())
//STRIP001 	{
//STRIP001 		pSelEngine->SetWindow( this );
//STRIP001 		Point aPoint;
//STRIP001 		Rectangle aVis( aPoint,GetOutputSizePixel() );
//STRIP001 		if (bVertical)
//STRIP001 			aVis.Left() = LONG_MIN, aVis.Right() = LONG_MAX;
//STRIP001 		else
//STRIP001 			aVis.Top() = LONG_MIN, aVis.Bottom() = LONG_MAX;
//STRIP001 		pSelEngine->SetVisibleArea( aVis );
//STRIP001 
//STRIP001 		SetMarking( TRUE );		//	muss vor SelMouseButtonDown sein
//STRIP001 		pSelEngine->SelMouseButtonDown( rMEvt );
//STRIP001 
//STRIP001 		//	#74215# In column/row headers a simple click already is a selection.
//STRIP001 		//	-> Call SelMouseMove to ensure CreateAnchor is called (and DestroyAnchor
//STRIP001 		//	if the next click is somewhere else with Control key).
//STRIP001 		pSelEngine->SelMouseMove( rMEvt );
//STRIP001 
//STRIP001 		if (IsMouseCaptured())
//STRIP001 		{
//STRIP001 			//	Tracking statt CaptureMouse, damit sauber abgebrochen werden kann
//STRIP001 			//!	Irgendwann sollte die SelectionEngine selber StartTracking rufen!?!
//STRIP001 			ReleaseMouse();
//STRIP001 			StartTracking();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void __EXPORT ScHeaderControl::MouseButtonUp( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	if ( IsDisabled() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	SetMarking( FALSE );
//STRIP001 	bIgnoreMove = FALSE;
//STRIP001 	BOOL bFound;
//STRIP001 	USHORT nHitNo = GetMousePos( rMEvt, bFound );
//STRIP001 
//STRIP001 	if ( bDragging )
//STRIP001 	{
//STRIP001 		DrawInvert( nDragPos );
//STRIP001 		ReleaseMouse();
//STRIP001 		bDragging	= FALSE;
//STRIP001 
//STRIP001 		long nScrPos	= GetScrPos( nDragNo );
//STRIP001 		long nMousePos 	= bVertical ? rMEvt.GetPosPixel().Y() : rMEvt.GetPosPixel().X();
//STRIP001 		long nNewWidth	= nMousePos + 2 - nScrPos;
//STRIP001 
//STRIP001 		if ( nNewWidth < 0 /* && !IsSelected(nDragNo) */ )
//STRIP001 		{
//STRIP001 			USHORT nStart;
//STRIP001 			USHORT nEnd = nDragNo;
//STRIP001 			while (nNewWidth < 0)
//STRIP001 			{
//STRIP001 				nStart = nDragNo;
//STRIP001 				if (nDragNo>0)
//STRIP001 				{
//STRIP001 					--nDragNo;
//STRIP001 					nNewWidth += GetEntrySize( nDragNo );	//! GetHiddenCount() ???
//STRIP001 				}
//STRIP001 				else
//STRIP001 					nNewWidth = 0;
//STRIP001 			}
//STRIP001 			HideEntries( nStart, nEnd );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if (nNewWidth<0) nNewWidth=0;
//STRIP001 			if (bDragMoved)
//STRIP001 				SetEntrySize( nDragNo, (USHORT) nNewWidth );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pSelEngine->SelMouseButtonUp( rMEvt );
//STRIP001 		ReleaseMouse();
//STRIP001 	}
//STRIP001 }

//STRIP001 void __EXPORT ScHeaderControl::MouseMove( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	if ( IsDisabled() )
//STRIP001 	{
//STRIP001 		SetPointer( Pointer( POINTER_ARROW ) );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bFound;
//STRIP001 	USHORT nHitNo = GetMousePos( rMEvt, bFound );
//STRIP001 
//STRIP001 	if ( bDragging )
//STRIP001 	{
//STRIP001 		long nNewPos = bVertical ? rMEvt.GetPosPixel().Y() : rMEvt.GetPosPixel().X();
//STRIP001 		if ( nNewPos != nDragPos )
//STRIP001 		{
//STRIP001 			DrawInvert( nDragPos );
//STRIP001 			nDragPos = nNewPos;
//STRIP001 			ShowDragHelp();
//STRIP001 			DrawInvert( nDragPos );
//STRIP001 
//STRIP001 			if (nDragPos <= nDragStart-SC_DRAG_MIN || nDragPos >= nDragStart+SC_DRAG_MIN)
//STRIP001 				bDragMoved = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( bFound && rMEvt.GetButtons()==0 && ResizeAllowed() )
//STRIP001 			SetPointer( Pointer( bVertical ? POINTER_VSIZEBAR : POINTER_HSIZEBAR ) );
//STRIP001 		else
//STRIP001 			SetPointer( Pointer( POINTER_ARROW ) );
//STRIP001 
//STRIP001 		if (!bIgnoreMove)
//STRIP001 			pSelEngine->SelMouseMove( rMEvt );
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScHeaderControl::Tracking( const TrackingEvent& rTEvt )
//STRIP001 {
//STRIP001 	//	Weil die SelectionEngine kein Tracking kennt, die Events nur auf
//STRIP001 	//	die verschiedenen MouseHandler verteilen...
//STRIP001 
//STRIP001 	if ( rTEvt.IsTrackingCanceled() )
//STRIP001 		StopMarking();
//STRIP001 	else if ( rTEvt.IsTrackingEnded() )
//STRIP001 		MouseButtonUp( rTEvt.GetMouseEvent() );
//STRIP001 	else
//STRIP001 		MouseMove( rTEvt.GetMouseEvent() );
//STRIP001 }

//STRIP001 void __EXPORT ScHeaderControl::Command( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	USHORT nCmd = rCEvt.GetCommand();
//STRIP001 	if ( nCmd == COMMAND_CONTEXTMENU )
//STRIP001 	{
//STRIP001 		StopMarking();		// Selektion / Dragging beenden
//STRIP001 
//STRIP001 		//	Popup ausfuehren
//STRIP001 
//STRIP001 		ScTabViewShell* pViewSh = PTR_CAST( ScTabViewShell,
//STRIP001 											SfxViewShell::Current() );
//STRIP001 		if ( pViewSh )
//STRIP001 		{
//STRIP001 			ScResId aResId( bVertical ? RID_POPUP_ROWHEADER : RID_POPUP_COLHEADER );
//STRIP001 			pViewSh->GetDispatcher()->ExecutePopup( aResId );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( nCmd == COMMAND_STARTDRAG )
//STRIP001 	{
//STRIP001 		pSelEngine->Command( rCEvt );
//STRIP001 	}
//STRIP001 }

/*N*/ void ScHeaderControl::StopMarking()
/*N*/ {
/*N*/ 	if ( bDragging )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 DrawInvert( nDragPos );
//STRIP001 /*?*/ 		bDragging = FALSE;
/*N*/ 	}
/*N*/ 
/*N*/ 	SetMarking( FALSE );
/*N*/ 	bIgnoreMove = TRUE;

	//	#86260# don't call pSelEngine->Reset, so selection across the parts of
	//	a split/frozen view is possible

/*N*/ 	ReleaseMouse();
/*N*/ }

//STRIP001 void ScHeaderControl::ShowDragHelp()
//STRIP001 {
//STRIP001 	if (Help::IsQuickHelpEnabled())
//STRIP001 	{
//STRIP001 		long nVal = nDragPos + 2 - GetScrPos( nDragNo );
//STRIP001 
//STRIP001 		String aHelpStr = GetDragHelp( nVal );
//STRIP001 		Point aPos = OutputToScreenPixel( Point(0,0) );
//STRIP001 		Size aSize = GetSizePixel();
//STRIP001 
//STRIP001 		Point aMousePos = OutputToScreenPixel(GetPointerPosPixel());
//STRIP001 
//STRIP001 		Rectangle aRect;
//STRIP001 		USHORT nAlign;
//STRIP001 		if (!bVertical)
//STRIP001 		{
//STRIP001 			//	oberhalb
//STRIP001 			aRect.Left() = aMousePos.X();
//STRIP001 			aRect.Top()	 = aPos.Y() - 4;
//STRIP001 			nAlign		 = QUICKHELP_BOTTOM|QUICKHELP_CENTER;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			//	rechts oben
//STRIP001 			aRect.Left() = aPos.X() + aSize.Width() + 8;
//STRIP001 			aRect.Top()	 = aMousePos.Y() - 2;
//STRIP001 			nAlign		 = QUICKHELP_LEFT|QUICKHELP_BOTTOM;
//STRIP001 		}
//STRIP001 
//STRIP001 		aRect.Right() 	= aRect.Left();
//STRIP001 		aRect.Bottom()	= aRect.Top();
//STRIP001 
//STRIP001 		Help::ShowQuickHelp(this, aRect, aHelpStr, nAlign);
//STRIP001 	}
//STRIP001 }

//STRIP001 void __EXPORT ScHeaderControl::RequestHelp( const HelpEvent& rHEvt )
//STRIP001 {
//STRIP001 	//	Wenn eigene QuickHelp angezeigt wird, nicht durch RequestHelp
//STRIP001 	//	wieder wegnehmen lassen
//STRIP001 
//STRIP001 	BOOL bOwn = bDragging && Help::IsQuickHelpEnabled();
//STRIP001 	if (!bOwn)
//STRIP001 		Window::RequestHelp(rHEvt);
//STRIP001 }

// -----------------------------------------------------------------------
//					Dummys fuer virtuelle Methoden
// -----------------------------------------------------------------------

//STRIP001 USHORT ScHeaderControl::GetHiddenCount( USHORT nEntryNo )
//STRIP001 {
//STRIP001 	USHORT nHidden = 0;
//STRIP001 	while ( nEntryNo < nSize && GetEntrySize( nEntryNo ) == 0 )
//STRIP001 	{
//STRIP001 		++nEntryNo;
//STRIP001 		++nHidden;
//STRIP001 	}
//STRIP001 	return nHidden;
//STRIP001 }

//STRIP001 BOOL ScHeaderControl::IsDisabled()
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 BOOL ScHeaderControl::ResizeAllowed()
//STRIP001 {
//STRIP001 	return TRUE;
//STRIP001 }

//STRIP001 void ScHeaderControl::SelectWindow()
//STRIP001 {
//STRIP001 }

//STRIP001 void ScHeaderControl::DrawInvert( long nDragPos )
//STRIP001 {
//STRIP001 }

//STRIP001 String ScHeaderControl::GetDragHelp( long nVal )
//STRIP001 {
//STRIP001 	return EMPTY_STRING;
//STRIP001 }

/*N*/ void ScHeaderControl::SetMarking( BOOL bSet )
/*N*/ {
/*N*/ }



}
