/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_formatsh.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:26:04 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------

//svdraw.hxx
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SI_NOSBXCONTROLS
#define _VCONT_HXX
#define _SI_NOOTHERFORMS
#define _VCTRLS_HXX
#define _SI_NOCONTROL
#define _SETBRW_HXX
#define _VCBRW_HXX
#define _SI_NOSBXCONTROLS

//------------------------------------------------------------------

#include "scitems.hxx"
// auto strip #include <bf_svx/eeitem.hxx>
#define ITEMID_FIELD EE_FEATURE_FIELD

// auto strip #include <bf_sfx2/request.hxx>
#include <svtools/whiter.hxx>
// auto strip #include <vcl/msgbox.hxx>

#define _ZFORLIST_DECLARE_TABLE
// auto strip #include <svtools/stritem.hxx>
// auto strip #include <svtools/zformat.hxx>
// auto strip #ifndef _SVTOOLS_LANGUAGEOPTIONS_HXX
// auto strip #include <svtools/languageoptions.hxx>
// auto strip #endif
#include <bf_svx/boxitem.hxx>
// auto strip #include <bf_svx/langitem.hxx>
// auto strip #include <bf_svx/numinf.hxx>
#include <bf_sfx2/dispatch.hxx>
#include <bf_sfx2/templdlg.hxx>
#include <bf_sfx2/tplpitem.hxx>
// auto strip #include <bf_svx/svxenum.hxx>
#include <bf_svx/algitem.hxx>
// auto strip #include <bf_svx/wghtitem.hxx>
// auto strip #include <bf_svx/postitem.hxx>
#include <bf_svx/udlnitem.hxx>
// auto strip #include <bf_svx/bolnitem.hxx>
#include <bf_svx/colritem.hxx>
#include <bf_svx/brshitem.hxx>
#include <bf_svx/frmdiritem.hxx>
#include <bf_svx/scripttypeitem.hxx>
#include <svtools/colorcfg.hxx>
// auto strip #include <bf_svx/shaditem.hxx>

#include "formatsh.hxx"
#include "bf_sc.hrc"
#include "globstr.hrc"
#include "docsh.hxx"
#include "patattr.hxx"
#include "scmod.hxx"
// auto strip #include "styledlg.hxx"
#include "attrdlg.hrc"
#include "stlpool.hxx"
// auto strip #include "stlsheet.hxx"
#include "printfun.hxx"
#include "docpool.hxx"
#include "scresid.hxx"
#include "tabvwsh.hxx"
// auto strip #include "undostyl.hxx"

namespace binfilter {//STRIP009
#define ScFormatShell
#define	TableFont
#define FormatForSelection
#include "scslots.hxx"
#define Interior
// auto strip #include <bf_svx/svxslots.hxx>

/*N*/ TYPEINIT1( ScFormatShell, SfxShell );

/*N*/ SFX_IMPL_INTERFACE(ScFormatShell, SfxShell, ScResId(SCSTR_FORMATSHELL) )
/*N*/ {
/*N*/ 	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_OBJECT | SFX_VISIBILITY_STANDARD |
/*N*/ 								SFX_VISIBILITY_SERVER,
/*N*/ 								ScResId(RID_OBJECTBAR_FORMAT));
/*N*/ 
/*N*/ }


/*N*/ ScFormatShell::ScFormatShell(ScViewData* pData) :
/*N*/ 	SfxShell(pData->GetViewShell()),
/*N*/ 	pViewData(pData)
/*N*/ {
/*N*/ 	ScTabViewShell*	pTabViewShell = GetViewData()->GetViewShell();
/*N*/ 
/*N*/ 	SetPool( &pTabViewShell->GetPool() );
/*N*/ 	SetUndoManager( pViewData->GetSfxDocShell()->GetUndoManager() );
/*N*/ 	SetHelpId(HID_SCSHELL_FORMATSH);
/*N*/ 	SetName(String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("Format")));
/*N*/ }

/*N*/ ScFormatShell::~ScFormatShell()
/*N*/ {
/*N*/ }

//------------------------------------------------------------------

/*N*/ void __EXPORT ScFormatShell::GetStyleState( SfxItemSet& rSet )
/*N*/ {
/*N*/ 	ScDocument*				pDoc  		= GetViewData()->GetDocument();
/*N*/ 	ScTabViewShell*	pTabViewShell  		= GetViewData()->GetViewShell();
/*N*/ 	SfxStyleSheetBasePool*	pStylePool	= pDoc->GetStyleSheetPool();
/*N*/ 	SfxStyleSheetBase*		pStyleSheet = NULL;
/*N*/ 
/*N*/ 	BOOL bProtected = FALSE;
/*N*/ 	USHORT nTabCount = pDoc->GetTableCount();
/*N*/ 	for (USHORT i=0; i<nTabCount; i++)
/*N*/ 		if (pDoc->IsTabProtected(i))				// ueberhaupt eine Tabelle geschuetzt?
/*N*/ 			bProtected = TRUE;
/*N*/ 
/*N*/ 	SfxWhichIter	aIter(rSet);
/*N*/ 	USHORT			nWhich = aIter.FirstWhich();
/*N*/ 	USHORT			nSlotId = 0;
/*N*/ 
/*N*/ 	while ( nWhich )
/*N*/ 	{
/*N*/ 		nSlotId = SfxItemPool::IsWhich( nWhich )
/*N*/ 					? GetPool().GetSlotId( nWhich )
/*N*/ 					: nWhich;
/*N*/ 
/*N*/ 		switch ( nSlotId )
/*N*/ 		{
/*N*/ 			case SID_STYLE_APPLY:
/*N*/ 				if ( !pStylePool )
/*?*/ 					rSet.DisableItem( nSlotId );
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SID_STYLE_FAMILY2:		// Zellvorlagen
/*N*/ 			{
/*N*/ 				SfxStyleSheet* pStyleSheet = (SfxStyleSheet*)
/*N*/ 											 pTabViewShell->GetStyleSheetFromMarked();
/*N*/ 
/*N*/ 				if ( pStyleSheet )
/*N*/ 					rSet.Put( SfxTemplateItem( nSlotId, pStyleSheet->GetName() ) );
/*N*/ 				else
/*?*/ 					rSet.Put( SfxTemplateItem( nSlotId, String() ) );
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*N*/ 			case SID_STYLE_FAMILY4:		// Seitenvorlagen
/*N*/ 			{
/*N*/ 				USHORT			nCurTab		= GetViewData()->GetTabNo();
/*N*/ 				String			aPageStyle  = pDoc->GetPageStyle( nCurTab );
/*N*/ 				SfxStyleSheet*	pStyleSheet = (SfxStyleSheet*)pStylePool->
/*N*/ 									Find( aPageStyle, SFX_STYLE_FAMILY_PAGE );
/*N*/ 
/*N*/ 				if ( pStyleSheet )
/*N*/ 					rSet.Put( SfxTemplateItem( nSlotId, aPageStyle ) );
/*N*/ 				else
/*?*/ 					rSet.Put( SfxTemplateItem( nSlotId, String() ) );
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*N*/ 			case SID_STYLE_WATERCAN:
/*N*/ 			{
/*N*/ 				rSet.Put( SfxBoolItem( nSlotId, SC_MOD()->GetIsWaterCan() ) );
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*N*/ 			case SID_STYLE_UPDATE_BY_EXAMPLE:
/*N*/ 			{
/*N*/ 				ISfxTemplateCommon* pDesigner = SFX_APP()->
/*N*/ 						GetCurrentTemplateCommon(pTabViewShell->GetViewFrame()->GetBindings());
/*N*/ 				BOOL bPage = pDesigner && SFX_STYLE_FAMILY_PAGE == pDesigner->GetActualFamily();
/*N*/ 
/*N*/ 				if ( bProtected || bPage )
/*N*/ 					rSet.DisableItem( nSlotId );
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*N*/ 			case SID_STYLE_EDIT:
/*N*/ 			case SID_STYLE_DELETE:
/*N*/ 			{
/*N*/ 				ISfxTemplateCommon* pDesigner = SFX_APP()->
/*N*/ 						GetCurrentTemplateCommon(pTabViewShell->GetViewFrame()->GetBindings());
/*N*/ 				BOOL bPage = pDesigner && SFX_STYLE_FAMILY_PAGE == pDesigner->GetActualFamily();
/*N*/ 
/*N*/ 				if ( bProtected && !bPage )
/*N*/ 					rSet.DisableItem( nSlotId );
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*N*/ 			default:
/*N*/ 				break;
/*N*/ 		}
/*N*/ 
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------

//STRIP001 void __EXPORT ScFormatShell::ExecuteStyle( SfxRequest& rReq )
//STRIP001 {
//STRIP001 	// Wenn ToolBar vertikal :
//STRIP001 	if ( !rReq.GetArgs() )
//STRIP001 	{
//STRIP001 		pViewData->GetDispatcher().Execute( SID_STYLE_DESIGNER, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	SfxBindings&		rBindings	= pViewData->GetBindings();
//STRIP001 	const SfxItemSet*   pArgs   	= rReq.GetArgs();
//STRIP001 	const USHORT        nSlotId 	= rReq.GetSlot();
//STRIP001 	const USHORT		nCurTab		= GetViewData()->GetTabNo();
//STRIP001 	ScDocShell*			pDocSh		= GetViewData()->GetDocShell();
//STRIP001 	ScTabViewShell*		pTabViewShell= GetViewData()->GetViewShell();
//STRIP001 	ScDocument*         pDoc    	= pDocSh->GetDocument();
//STRIP001 	ScMarkData&			rMark		= GetViewData()->GetMarkData();
//STRIP001 	ScModule*			pScMod		= SC_MOD();
//STRIP001 	String				aRefName;
//STRIP001 	BOOL				bUndo		= pDoc->IsUndoEnabled();
//STRIP001 
//STRIP001 	if (   (nSlotId == SID_STYLE_NEW)
//STRIP001 		|| (nSlotId == SID_STYLE_EDIT)
//STRIP001 		|| (nSlotId == SID_STYLE_DELETE)
//STRIP001 		|| (nSlotId == SID_STYLE_APPLY)
//STRIP001 		|| (nSlotId == SID_STYLE_WATERCAN)
//STRIP001 		|| (nSlotId == SID_STYLE_FAMILY)
//STRIP001 		|| (nSlotId == SID_STYLE_NEW_BY_EXAMPLE)
//STRIP001 		|| (nSlotId == SID_STYLE_UPDATE_BY_EXAMPLE) )
//STRIP001 	{
//STRIP001 		SfxStyleSheetBasePool*  pStylePool	= pDoc->GetStyleSheetPool();
//STRIP001 		SfxStyleSheetBase*      pStyleSheet = NULL;
//STRIP001 
//STRIP001 		BOOL bStyleToMarked = FALSE;
//STRIP001 		BOOL bListAction = FALSE;
//STRIP001 		BOOL bAddUndo = FALSE;			// add ScUndoModifyStyle (style modified)
//STRIP001 		ScStyleSaveData aOldData;		// for undo/redo
//STRIP001 		ScStyleSaveData aNewData;
//STRIP001 
//STRIP001 		SfxStyleFamily eFamily = SFX_STYLE_FAMILY_PARA;
//STRIP001 		const SfxPoolItem* pFamItem;
//STRIP001 		if ( pArgs && SFX_ITEM_SET == pArgs->GetItemState( SID_STYLE_FAMILY, TRUE, &pFamItem ) )
//STRIP001 			eFamily = (SfxStyleFamily)((const SfxUInt16Item*)pFamItem)->GetValue();
//STRIP001 
//STRIP001 		String                  aStyleName;
//STRIP001 		USHORT                  nRetMask = 0xffff;
//STRIP001 //      #96983# only stylist sends focus to sheet
//STRIP001 //        BOOL                    bGrabFocus = ( SID_STYLE_APPLY == nSlotId );
//STRIP001 
//STRIP001 		pStylePool->SetSearchMask( eFamily, SFXSTYLEBIT_ALL );
//STRIP001 
//STRIP001 		switch ( nSlotId )
//STRIP001 		{
//STRIP001 			case SID_STYLE_NEW:
//STRIP001 				{
//STRIP001 					const SfxPoolItem* pNameItem;
//STRIP001 					if (pArgs && SFX_ITEM_SET == pArgs->GetItemState( nSlotId, TRUE, &pNameItem ))
//STRIP001 						aStyleName  = ((const SfxStringItem*)pNameItem)->GetValue();
//STRIP001 
//STRIP001 					const SfxPoolItem* pRefItem=NULL;
//STRIP001 					if (pArgs && SFX_ITEM_SET == pArgs->GetItemState( SID_STYLE_REFERENCE, TRUE, &pRefItem ))
//STRIP001 					{
//STRIP001 						if(pRefItem!=NULL)
//STRIP001 							aRefName  = ((const SfxStringItem*)pRefItem)->GetValue();
//STRIP001 					}
//STRIP001 
//STRIP001 					pStyleSheet = &(pStylePool->Make( aStyleName, eFamily,
//STRIP001 													  SFXSTYLEBIT_USERDEF ) );
//STRIP001 
//STRIP001 					if ( pStyleSheet && pStyleSheet->HasParentSupport() )
//STRIP001 						pStyleSheet->SetParent(aRefName);
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_STYLE_EDIT:
//STRIP001 			case SID_STYLE_DELETE:
//STRIP001 			case SID_STYLE_APPLY:
//STRIP001 			case SID_STYLE_NEW_BY_EXAMPLE:
//STRIP001 				{
//STRIP001 					const SfxPoolItem* pNameItem;
//STRIP001 					if (pArgs && SFX_ITEM_SET == pArgs->GetItemState( nSlotId, TRUE, &pNameItem ))
//STRIP001 						aStyleName  = ((const SfxStringItem*)pNameItem)->GetValue();
//STRIP001 					pStyleSheet = pStylePool->Find( aStyleName, eFamily );
//STRIP001 
//STRIP001 					aOldData.InitFromStyle( pStyleSheet );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_STYLE_WATERCAN:
//STRIP001 			{
//STRIP001 				BOOL bWaterCan = pScMod->GetIsWaterCan();
//STRIP001 
//STRIP001 				if( !bWaterCan )
//STRIP001 				{
//STRIP001 					const SfxPoolItem* pItem;
//STRIP001 
//STRIP001 					if ( SFX_ITEM_SET ==
//STRIP001 						 pArgs->GetItemState( nSlotId, TRUE, &pItem ) )
//STRIP001 					{
//STRIP001 						const SfxStringItem* pStrItem = PTR_CAST(SfxStringItem,pItem);
//STRIP001 						if ( pStrItem )
//STRIP001 						{
//STRIP001 							aStyleName  = pStrItem->GetValue();
//STRIP001 							pStyleSheet = pStylePool->Find( aStyleName, eFamily );
//STRIP001 
//STRIP001 							if ( pStyleSheet )
//STRIP001 							{
//STRIP001 								((ScStyleSheetPool*)pStylePool)->
//STRIP001 										SetActualStyleSheet( pStyleSheet );
//STRIP001 								rReq.Done();
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( !bWaterCan && pStyleSheet )
//STRIP001 				{
//STRIP001 					pScMod->SetWaterCan( TRUE );
//STRIP001 					pTabViewShell->SetActivePointer( Pointer(POINTER_FILL) );
//STRIP001 					rReq.Done();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					pScMod->SetWaterCan( FALSE );
//STRIP001 					pTabViewShell->SetActivePointer( Pointer(POINTER_ARROW) );
//STRIP001 					rReq.Done();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			default:
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		// Neuen Style fuer WaterCan-Mode setzen
//STRIP001 		if ( nSlotId == SID_STYLE_APPLY && pScMod->GetIsWaterCan() && pStyleSheet )
//STRIP001 			((ScStyleSheetPool*)pStylePool)->SetActualStyleSheet( pStyleSheet );
//STRIP001 
//STRIP001 		switch ( eFamily )
//STRIP001 		{
//STRIP001 			case SFX_STYLE_FAMILY_PARA:
//STRIP001 			{
//STRIP001 				switch ( nSlotId )
//STRIP001 				{
//STRIP001 					case SID_STYLE_DELETE:
//STRIP001 					{
//STRIP001 						if ( pStyleSheet )
//STRIP001 						{
//STRIP001 							pTabViewShell->RemoveStyleSheetInUse( (SfxStyleSheet*)pStyleSheet );
//STRIP001 							pStylePool->Erase( pStyleSheet );
//STRIP001 							pTabViewShell->InvalidateAttribs();
//STRIP001 							nRetMask = TRUE;
//STRIP001 							bAddUndo = TRUE;
//STRIP001 							rReq.Done();
//STRIP001 						}
//STRIP001 						else
//STRIP001 							nRetMask = FALSE;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 					case SID_STYLE_APPLY:
//STRIP001 					{
//STRIP001 						if ( pStyleSheet && !pScMod->GetIsWaterCan() )
//STRIP001 						{
//STRIP001 							// Anwenden der Vorlage auf das Dokument
//STRIP001 							pTabViewShell->SetStyleSheetToMarked( (SfxStyleSheet*)pStyleSheet );
//STRIP001 							pTabViewShell->InvalidateAttribs();
//STRIP001 							rReq.Done();
//STRIP001 						}
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 					case SID_STYLE_NEW_BY_EXAMPLE:
//STRIP001 					case SID_STYLE_UPDATE_BY_EXAMPLE:
//STRIP001 					{
//STRIP001 						// Vorlage erzeugen/ersetzen durch Attribute
//STRIP001 						// an der Cursor-Position:
//STRIP001 
//STRIP001 						const ScPatternAttr* pAttrItem = NULL;
//STRIP001 
//STRIP001 						// Die Abfrage, ob markiert ist, war hier immer falsch,
//STRIP001 						// darum jetzt gar nicht mehr, und einfach vom Cursor.
//STRIP001 						// Wenn Attribute aus der Selektion genommen werden sollen,
//STRIP001 						// muss noch darauf geachtet werden, Items aus Vorlagen nicht
//STRIP001 						// zu uebernehmen (GetSelectionPattern sammelt auch Items aus
//STRIP001 						// Vorlagen zusammen) (#44748#)
//STRIP001 						//		pAttrItem = GetSelectionPattern();
//STRIP001 
//STRIP001 						ScViewData* pViewData = GetViewData();
//STRIP001 						USHORT		nCol = pViewData->GetCurX();
//STRIP001 						USHORT		nRow = pViewData->GetCurY();
//STRIP001 						pAttrItem = pDoc->GetPattern( nCol, nRow, nCurTab );
//STRIP001 
//STRIP001 						SfxItemSet aAttrSet = pAttrItem->GetItemSet();
//STRIP001 						aAttrSet.ClearItem( ATTR_MERGE );
//STRIP001 						aAttrSet.ClearItem( ATTR_MERGE_FLAG );
//STRIP001 						//	bedingte Formatierung und Gueltigkeit nicht uebernehmen,
//STRIP001 						//	weil sie in der Vorlage nicht editiert werden koennen
//STRIP001 						aAttrSet.ClearItem( ATTR_VALIDDATA );
//STRIP001 						aAttrSet.ClearItem( ATTR_CONDITIONAL );
//STRIP001 
//STRIP001 						if ( SID_STYLE_NEW_BY_EXAMPLE == nSlotId )
//STRIP001 						{
//STRIP001 							if ( bUndo )
//STRIP001 							{
//STRIP001 								String aUndo = ScGlobal::GetRscString( STR_UNDO_EDITCELLSTYLE );
//STRIP001 								pDocSh->GetUndoManager()->EnterListAction( aUndo, aUndo );
//STRIP001 								bListAction = TRUE;
//STRIP001 							}
//STRIP001 
//STRIP001 							BOOL			bConvertBack = FALSE;
//STRIP001 							SfxStyleSheet*	pSheetInUse = (SfxStyleSheet*)
//STRIP001 														  pTabViewShell->GetStyleSheetFromMarked();
//STRIP001 
//STRIP001 							// wenn neuer Style vorhanden und in der Selektion
//STRIP001 							// verwendet wird, so darf der Parent nicht uebernommen
//STRIP001 							// werden:
//STRIP001 
//STRIP001 							if ( pStyleSheet && pSheetInUse && pStyleSheet == pSheetInUse )
//STRIP001 								pSheetInUse = NULL;
//STRIP001 
//STRIP001 							// wenn bereits vorhanden, erstmal entfernen...
//STRIP001 							if ( pStyleSheet )
//STRIP001 							{
//STRIP001 								// Style-Pointer zu Namen vor Erase,
//STRIP001 								// weil Zellen sonst ungueltige Pointer
//STRIP001 								// enthalten.
//STRIP001 								//!!! bei Gelenheit mal eine Methode, die
//STRIP001 								//    das fuer einen bestimmten Style macht
//STRIP001 								pDoc->StylesToNames();
//STRIP001 								bConvertBack = TRUE;
//STRIP001 								pStylePool->Erase(pStyleSheet);
//STRIP001 							}
//STRIP001 
//STRIP001 							// ...und neu anlegen
//STRIP001 							pStyleSheet = &pStylePool->Make( aStyleName, eFamily,
//STRIP001 															 SFXSTYLEBIT_USERDEF );
//STRIP001 
//STRIP001 							// wenn ein Style vorhanden ist, so wird dieser
//STRIP001 							// Parent der neuen Vorlage:
//STRIP001 							if ( pSheetInUse && pStyleSheet->HasParentSupport() )
//STRIP001 								pStyleSheet->SetParent( pSheetInUse->GetName() );
//STRIP001 
//STRIP001 							if ( bConvertBack )
//STRIP001 								// Namen zu Style-Pointer
//STRIP001 								pDoc->UpdStlShtPtrsFrmNms();
//STRIP001 
//STRIP001 							// Attribute uebernehmen und Style anwenden
//STRIP001 							pStyleSheet->GetItemSet().Put( aAttrSet );
//STRIP001 							pTabViewShell->UpdateStyleSheetInUse( (SfxStyleSheet*)pStyleSheet );
//STRIP001 
//STRIP001 							//	call SetStyleSheetToMarked after adding the ScUndoModifyStyle
//STRIP001 							//	(pStyleSheet pointer is used!)
//STRIP001 							bStyleToMarked = TRUE;
//STRIP001 						}
//STRIP001 						else // ( nSlotId == SID_STYLE_UPDATE_BY_EXAMPLE )
//STRIP001 						{
//STRIP001 							pStyleSheet = (SfxStyleSheet*)pTabViewShell->GetStyleSheetFromMarked();
//STRIP001 
//STRIP001 							if ( pStyleSheet )
//STRIP001 							{
//STRIP001 								aOldData.InitFromStyle( pStyleSheet );
//STRIP001 
//STRIP001 								if ( bUndo )
//STRIP001 								{
//STRIP001 									String aUndo = ScGlobal::GetRscString( STR_UNDO_EDITCELLSTYLE );
//STRIP001 									pDocSh->GetUndoManager()->EnterListAction( aUndo, aUndo );
//STRIP001 									bListAction = TRUE;
//STRIP001 								}
//STRIP001 
//STRIP001 								pStyleSheet->GetItemSet().Put( aAttrSet );
//STRIP001 								pTabViewShell->UpdateStyleSheetInUse( (SfxStyleSheet*)pStyleSheet );
//STRIP001 
//STRIP001 								//	call SetStyleSheetToMarked after adding the ScUndoModifyStyle
//STRIP001 								//	(pStyleSheet pointer is used!)
//STRIP001 								bStyleToMarked = TRUE;
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						aNewData.InitFromStyle( pStyleSheet );
//STRIP001 						bAddUndo = TRUE;
//STRIP001 						rReq.Done();
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 					default:
//STRIP001 						break;
//STRIP001 				}
//STRIP001 			} // case SFX_STYLE_FAMILY_PARA:
//STRIP001 			break;
//STRIP001 
//STRIP001 			case SFX_STYLE_FAMILY_PAGE:
//STRIP001 			{
//STRIP001 				switch ( nSlotId )
//STRIP001 				{
//STRIP001 					case SID_STYLE_DELETE:
//STRIP001 					{
//STRIP001 						nRetMask = ( NULL != pStyleSheet );
//STRIP001 						if ( pStyleSheet )
//STRIP001 						{
//STRIP001 							if ( pDoc->RemovePageStyleInUse( pStyleSheet->GetName() ) )
//STRIP001 							{
//STRIP001 								ScPrintFunc( pDocSh, pTabViewShell->GetPrinter(), nCurTab ).UpdatePages();
//STRIP001 								rBindings.Invalidate( SID_STATUS_PAGESTYLE );
//STRIP001 								rBindings.Invalidate( FID_RESET_PRINTZOOM );
//STRIP001 							}
//STRIP001 							pStylePool->Erase( pStyleSheet );
//STRIP001 							rBindings.Invalidate( SID_STYLE_FAMILY4 );
//STRIP001 							pDocSh->SetDocumentModified();
//STRIP001 							bAddUndo = TRUE;
//STRIP001 							rReq.Done();
//STRIP001 						}
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 					case SID_STYLE_APPLY:
//STRIP001 					{
//STRIP001 						nRetMask = ( NULL != pStyleSheet );
//STRIP001 						if ( pStyleSheet && !pScMod->GetIsWaterCan() )
//STRIP001 						{
//STRIP001 							String aOldName = pDoc->GetPageStyle( nCurTab );
//STRIP001 							if ( aOldName != aStyleName )
//STRIP001 							{
//STRIP001 								pDoc->SetPageStyle( nCurTab, aStyleName );
//STRIP001 								ScPrintFunc( pDocSh, pTabViewShell->GetPrinter(), nCurTab ).UpdatePages();
//STRIP001 								pDocSh->SetDocumentModified();
//STRIP001 								rBindings.Invalidate( SID_STYLE_FAMILY4 );
//STRIP001 								rBindings.Invalidate( SID_STATUS_PAGESTYLE );
//STRIP001 								rBindings.Invalidate( FID_RESET_PRINTZOOM );
//STRIP001 
//STRIP001 								if (bUndo)
//STRIP001 								{
//STRIP001 									pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 											new ScUndoApplyPageStyle( pDocSh,
//STRIP001 												nCurTab, aOldName, aStyleName ) );
//STRIP001 								}
//STRIP001 							}
//STRIP001 							rReq.Done();
//STRIP001 						}
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 					case SID_STYLE_NEW_BY_EXAMPLE:
//STRIP001 					{
//STRIP001 						const String& rStrCurStyle = pDoc->GetPageStyle( nCurTab );
//STRIP001 
//STRIP001 						if ( rStrCurStyle != aStyleName )
//STRIP001 						{
//STRIP001 							SfxStyleSheetBase*	pCurStyle = pStylePool->Find( rStrCurStyle, eFamily );
//STRIP001 							SfxItemSet			aAttrSet  = pCurStyle->GetItemSet();
//STRIP001 							USHORT				nInTab;
//STRIP001 							BOOL				bUsed = pDoc->IsPageStyleInUse( aStyleName, &nInTab );
//STRIP001 
//STRIP001 							// wenn bereits vorhanden, erstmal entfernen...
//STRIP001 							if ( pStyleSheet )
//STRIP001 								pStylePool->Erase( pStyleSheet );
//STRIP001 
//STRIP001 							// ...und neu anlegen
//STRIP001 							pStyleSheet = &pStylePool->Make( aStyleName, eFamily,
//STRIP001 															 SFXSTYLEBIT_USERDEF );
//STRIP001 
//STRIP001 							// Attribute uebernehmen
//STRIP001 							pStyleSheet->GetItemSet().Put( aAttrSet );
//STRIP001 							pDocSh->SetDocumentModified();
//STRIP001 
//STRIP001 							// wenn in Verwendung -> Update
//STRIP001 							if ( bUsed )
//STRIP001 								ScPrintFunc( pDocSh, pTabViewShell->GetPrinter(), nInTab ).UpdatePages();
//STRIP001 
//STRIP001 							aNewData.InitFromStyle( pStyleSheet );
//STRIP001 							bAddUndo = TRUE;
//STRIP001 							rReq.Done();
//STRIP001 							nRetMask = TRUE;
//STRIP001 						}
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 					default:
//STRIP001 						break;
//STRIP001 				} // switch ( nSlotId )
//STRIP001 			} // case SFX_STYLE_FAMILY_PAGE:
//STRIP001 			break;
//STRIP001 
//STRIP001 			default:
//STRIP001 				break;
//STRIP001 		} // switch ( eFamily )
//STRIP001 
//STRIP001 		// Neu anlegen oder bearbeiten ueber Dialog:
//STRIP001 		if ( nSlotId == SID_STYLE_NEW || nSlotId == SID_STYLE_EDIT )
//STRIP001 		{
//STRIP001 			if ( pStyleSheet )
//STRIP001 			{
//STRIP001 				SvxNumberInfoItem* pNumberInfoItem = NULL;
//STRIP001 
//STRIP001 				SfxStyleFamily	eFam    = pStyleSheet->GetFamily();
//STRIP001 				ScDocument*		pDoc    = GetViewData()->GetDocument();
//STRIP001 				ScDocShell*		pDocSh  = GetViewData()->GetDocShell();
//STRIP001 				ScStyleDlg*		pDlg    = NULL;
//STRIP001 				USHORT			nRsc	= 0;
//STRIP001 
//STRIP001 				//	#37034#/#37245# alte Items aus der Vorlage merken
//STRIP001 				SfxItemSet aOldSet = pStyleSheet->GetItemSet();
//STRIP001 				String aOldName = pStyleSheet->GetName();
//STRIP001 
//STRIP001 				switch ( eFam )
//STRIP001 				{
//STRIP001 					case SFX_STYLE_FAMILY_PAGE:
//STRIP001 						nRsc = RID_SCDLG_STYLES_PAGE;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case SFX_STYLE_FAMILY_PARA:
//STRIP001 					default:
//STRIP001 						{
//STRIP001 							SfxItemSet& rSet = pStyleSheet->GetItemSet();
//STRIP001 
//STRIP001 							const SfxPoolItem* pItem;
//STRIP001 							if ( rSet.GetItemState( ATTR_VALUE_FORMAT,
//STRIP001 									FALSE, &pItem ) == SFX_ITEM_SET )
//STRIP001 							{
//STRIP001 								// NumberFormat Value aus Value und Language
//STRIP001 								// erzeugen und eintueten
//STRIP001 								ULONG nFormat =
//STRIP001 									((SfxUInt32Item*)pItem)->GetValue();
//STRIP001 								LanguageType eLang =
//STRIP001 									((SvxLanguageItem*)&rSet.Get(
//STRIP001 									ATTR_LANGUAGE_FORMAT ))->GetLanguage();
//STRIP001 								ULONG nLangFormat = pDoc->GetFormatTable()->
//STRIP001 									GetFormatForLanguageIfBuiltIn( nFormat, eLang );
//STRIP001 								if ( nLangFormat != nFormat )
//STRIP001 								{
//STRIP001 									SfxUInt32Item aNewItem( ATTR_VALUE_FORMAT, nLangFormat );
//STRIP001 									rSet.Put( aNewItem );
//STRIP001 									aOldSet.Put( aNewItem );
//STRIP001 									// auch in aOldSet fuer Vergleich nach dem Dialog,
//STRIP001 									// sonst geht evtl. eine Aenderung der Sprache verloren
//STRIP001 								}
//STRIP001 							}
//STRIP001 
//STRIP001 							pTabViewShell->MakeNumberInfoItem( pDoc, GetViewData(), &pNumberInfoItem );
//STRIP001 							pDocSh->PutItem( *pNumberInfoItem );
//STRIP001 							nRsc = RID_SCDLG_STYLES_PAR;
//STRIP001 
//STRIP001 							//	auf jeden Fall ein SvxBoxInfoItem mit Table = FALSE im Set:
//STRIP001 							//	(wenn gar kein Item da ist, loescht der Dialog auch das
//STRIP001 							//	 BORDER_OUTER SvxBoxItem aus dem Vorlagen-Set)
//STRIP001 
//STRIP001 							if ( rSet.GetItemState( ATTR_BORDER_INNER, FALSE ) != SFX_ITEM_SET )
//STRIP001 							{
//STRIP001 								SvxBoxInfoItem aBoxInfoItem( ATTR_BORDER_INNER );
//STRIP001 								aBoxInfoItem.SetTable(FALSE);		// keine inneren Linien
//STRIP001 								aBoxInfoItem.SetDist(FALSE);
//STRIP001 								aBoxInfoItem.SetMinDist(FALSE);
//STRIP001 								rSet.Put( aBoxInfoItem );
//STRIP001 							}
//STRIP001 						}
//STRIP001 						break;
//STRIP001 				}
//STRIP001 
//STRIP001 				//	If GetDefDialogParent is a dialog, it must be used
//STRIP001 				//	(style catalog)
//STRIP001 
//STRIP001 				Window* pParent = Application::GetDefDialogParent();
//STRIP001 				if ( !pParent || !pParent->IsDialog() )
//STRIP001 				{
//STRIP001 					//	#107256# GetDefDialogParent currently doesn't return the window
//STRIP001 					//	that was set with SetDefDialogParent (but dynamically finds the
//STRIP001 					//	topmost parent of the focus window), so IsDialog above is FALSE
//STRIP001 					//	even if called from the style catalog.
//STRIP001 					//	-> Use NULL if a modal dialog is open, to enable the Dialog's
//STRIP001 					//	default parent handling.
//STRIP001 					if ( Application::IsInModalMode() )
//STRIP001 						pParent = NULL;
//STRIP001 					else
//STRIP001 						pParent = pTabViewShell->GetDialogParent();
//STRIP001 				}
//STRIP001 
//STRIP001 				pTabViewShell->SetInFormatDialog(TRUE);
//STRIP001 
//STRIP001 				pDlg = new ScStyleDlg( pParent, *pStyleSheet, nRsc );
//STRIP001 				short nResult = pDlg->Execute();
//STRIP001 				pTabViewShell->SetInFormatDialog(FALSE);
//STRIP001 
//STRIP001 				if ( nResult == RET_OK )
//STRIP001 				{
//STRIP001 					const SfxItemSet* pOutSet = pDlg->GetOutputItemSet();
//STRIP001 
//STRIP001 					if ( pOutSet )
//STRIP001 					{
//STRIP001 						nRetMask = pStyleSheet->GetMask();
//STRIP001 
//STRIP001 						//	#37034#/#37245# Attribut-Vergleiche (frueher in ModifyStyleSheet)
//STRIP001 						//	jetzt hier mit den alten Werten (Style ist schon veraendert)
//STRIP001 
//STRIP001 						if ( SFX_STYLE_FAMILY_PARA == eFam )
//STRIP001 						{
//STRIP001 //							pDoc->CellStyleChanged( *pStyleSheet, aOldSet );
//STRIP001 
//STRIP001 							SfxItemSet& rNewSet = pStyleSheet->GetItemSet();
//STRIP001 							BOOL bNumFormatChanged;
//STRIP001 							if ( ScGlobal::CheckWidthInvalidate(
//STRIP001 												bNumFormatChanged, aOldSet, rNewSet ) )
//STRIP001 								pDoc->InvalidateTextWidth( NULL, NULL, bNumFormatChanged );
//STRIP001 
//STRIP001 							ULONG nOldFormat = ((const SfxUInt32Item&)aOldSet.
//STRIP001 													Get( ATTR_VALUE_FORMAT )).GetValue();
//STRIP001 							ULONG nNewFormat = ((const SfxUInt32Item&)rNewSet.
//STRIP001 													Get( ATTR_VALUE_FORMAT )).GetValue();
//STRIP001 							if ( nNewFormat != nOldFormat )
//STRIP001 							{
//STRIP001 								SvNumberFormatter* pFormatter = pDoc->GetFormatTable();
//STRIP001 								const SvNumberformat* pOld = pFormatter->GetEntry( nOldFormat );
//STRIP001 								const SvNumberformat* pNew = pFormatter->GetEntry( nNewFormat );
//STRIP001 								if ( pOld && pNew && pOld->GetLanguage() != pNew->GetLanguage() )
//STRIP001 									rNewSet.Put( SvxLanguageItem(
//STRIP001 													pNew->GetLanguage(), ATTR_LANGUAGE_FORMAT ) );
//STRIP001 							}
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							//!	auch fuer Seitenvorlagen die Abfragen hier
//STRIP001 
//STRIP001 							String aNewName = pStyleSheet->GetName();
//STRIP001 							if ( aNewName != aOldName &&
//STRIP001 									pDoc->RenamePageStyleInUse( aOldName, aNewName ) )
//STRIP001 							{
//STRIP001 								rBindings.Invalidate( SID_STATUS_PAGESTYLE );
//STRIP001 								rBindings.Invalidate( FID_RESET_PRINTZOOM );
//STRIP001 							}
//STRIP001 
//STRIP001 							pDoc->ModifyStyleSheet( *pStyleSheet, *pOutSet );
//STRIP001 							rBindings.Invalidate( FID_RESET_PRINTZOOM );
//STRIP001 						}
//STRIP001 
//STRIP001 						pDocSh->SetDocumentModified();
//STRIP001 
//STRIP001 						if ( SFX_STYLE_FAMILY_PARA == eFam )
//STRIP001 						{
//STRIP001 							pTabViewShell->UpdateNumberFormatter( pDoc,
//STRIP001 								(const SvxNumberInfoItem&)
//STRIP001 									*(pDocSh->GetItem(SID_ATTR_NUMBERFORMAT_INFO)) );
//STRIP001 
//STRIP001 							pTabViewShell->UpdateStyleSheetInUse( (SfxStyleSheet*)pStyleSheet );
//STRIP001 							pTabViewShell->InvalidateAttribs();
//STRIP001 						}
//STRIP001 
//STRIP001 						aNewData.InitFromStyle( pStyleSheet );
//STRIP001 						bAddUndo = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if ( nSlotId == SID_STYLE_NEW )
//STRIP001 						pStylePool->Erase( pStyleSheet );
//STRIP001 					else
//STRIP001 					{
//STRIP001 						//	falls zwischendurch etwas mit dem temporaer geaenderten
//STRIP001 						//	ItemSet gepainted wurde:
//STRIP001 						pDocSh->PostPaintGridAll();
//STRIP001 					}
//STRIP001 				}
//STRIP001 				delete pDlg;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 //		if ( nRetMask != 0xffff )// Irgendein Wert MUSS geliefert werden JN
//STRIP001 			rReq.SetReturnValue( SfxUInt16Item( nSlotId, nRetMask ) );
//STRIP001 
//STRIP001 //      #96983# only stylist sends focus to sheet
//STRIP001 //        if ( bGrabFocus )
//STRIP001 //            pTabViewShell->GetActiveWin()->GrabFocus();
//STRIP001 
//STRIP001 		if ( bAddUndo && bUndo)
//STRIP001 			pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 						new ScUndoModifyStyle( pDocSh, eFamily, aOldData, aNewData ) );
//STRIP001 
//STRIP001 		if ( bStyleToMarked )
//STRIP001 		{
//STRIP001 			//	call SetStyleSheetToMarked after adding the ScUndoModifyStyle,
//STRIP001 			//	so redo will find the modified style
//STRIP001 			pTabViewShell->SetStyleSheetToMarked( (SfxStyleSheet*)pStyleSheet );
//STRIP001 			pTabViewShell->InvalidateAttribs();
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bListAction )
//STRIP001 			pDocSh->GetUndoManager()->LeaveListAction();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ERROR( "Unknown slot (ScViewShell::ExecuteStyle)" );
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScFormatShell::ExecuteNumFormat( SfxRequest& rReq )
//STRIP001 {
//STRIP001 	ScModule*			pScMod		= SC_MOD();
//STRIP001 	ScTabViewShell*	pTabViewShell  	= GetViewData()->GetViewShell();
//STRIP001 	SfxBindings&		rBindings	= pTabViewShell->GetViewFrame()->GetBindings();
//STRIP001 	const SfxItemSet*	pReqArgs	= rReq.GetArgs();
//STRIP001 	USHORT				nSlot		= rReq.GetSlot();
//STRIP001 
//STRIP001 	pTabViewShell->HideListBox();					// Autofilter-DropDown-Listbox
//STRIP001 
//STRIP001 									// Eingabe beenden
//STRIP001 	if ( GetViewData()->HasEditView( GetViewData()->GetActivePart() ) )
//STRIP001 	{
//STRIP001 		switch ( nSlot )
//STRIP001 		{
//STRIP001 			case SID_NUMBER_TWODEC:
//STRIP001 			case SID_NUMBER_SCIENTIFIC:
//STRIP001 			case SID_NUMBER_DATE:
//STRIP001 			case SID_NUMBER_CURRENCY:
//STRIP001 			case SID_NUMBER_PERCENT:
//STRIP001 			case SID_NUMBER_STANDARD:
//STRIP001 			case SID_NUMBER_FORMAT:
//STRIP001 			case SID_NUMBER_INCDEC:
//STRIP001 			case SID_NUMBER_DECDEC:
//STRIP001 			case FID_DEFINE_NAME:
//STRIP001 			case FID_USE_NAME:
//STRIP001 			case FID_INSERT_NAME:
//STRIP001 			case SID_SPELLING:
//STRIP001 
//STRIP001 			pScMod->InputEnterHandler();
//STRIP001 			pTabViewShell->UpdateInputHandler();
//STRIP001 			break;
//STRIP001 
//STRIP001 			default:
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	switch ( nSlot )
//STRIP001 	{
//STRIP001 		case SID_NUMBER_TWODEC:
//STRIP001 			pTabViewShell->SetNumberFormat( NUMBERFORMAT_NUMBER, 4 );		// Standard+4 = #.##0,00
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 		case SID_NUMBER_SCIENTIFIC:
//STRIP001 			pTabViewShell->SetNumberFormat( NUMBERFORMAT_SCIENTIFIC );
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 		case SID_NUMBER_DATE:
//STRIP001 			pTabViewShell->SetNumberFormat( NUMBERFORMAT_DATE );
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 		case SID_NUMBER_TIME:
//STRIP001 			pTabViewShell->SetNumberFormat( NUMBERFORMAT_TIME );
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 		case SID_NUMBER_CURRENCY:
//STRIP001 			pTabViewShell->SetNumberFormat( NUMBERFORMAT_CURRENCY );
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 		case SID_NUMBER_PERCENT:
//STRIP001 			pTabViewShell->SetNumberFormat( NUMBERFORMAT_PERCENT );
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 		case SID_NUMBER_STANDARD:
//STRIP001 			pTabViewShell->SetNumberFormat( NUMBERFORMAT_NUMBER );
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 		case SID_NUMBER_INCDEC:
//STRIP001 			pTabViewShell->ChangeNumFmtDecimals( TRUE );
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 		case SID_NUMBER_DECDEC:
//STRIP001 			pTabViewShell->ChangeNumFmtDecimals( FALSE );
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_NUMBER_FORMAT:
//STRIP001 			if ( pReqArgs )
//STRIP001 			{
//STRIP001 				const SfxPoolItem* pItem;
//STRIP001 				if(pReqArgs->GetItemState(nSlot, TRUE, &pItem) == SFX_ITEM_SET)
//STRIP001 				{
//STRIP001 					String aCode = ((const SfxStringItem*)pItem)->GetValue();
//STRIP001 					pTabViewShell->SetNumFmtByStr( aCode );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001         case SID_ATTR_NUMBERFORMAT_VALUE:
//STRIP001 			if ( pReqArgs )
//STRIP001 			{
//STRIP001 				const SfxPoolItem* pItem;
//STRIP001 				if ( pReqArgs->GetItemState( ATTR_VALUE_FORMAT, TRUE, &pItem ) == SFX_ITEM_SET )
//STRIP001 				{
//STRIP001                     // We have to accomplish this using ApplyAttributes()
//STRIP001                     // because we also need the language information to be
//STRIP001                     // considered.
//STRIP001                     const SfxItemSet& rOldSet =
//STRIP001                         pTabViewShell->GetSelectionPattern()->GetItemSet();
//STRIP001                     SfxItemPool* pPool = GetViewData()->GetDocument()->GetPool();
//STRIP001                     SfxItemSet aNewSet( *pPool, ATTR_PATTERN_START, ATTR_PATTERN_END );
//STRIP001                     aNewSet.Put( *pItem );
//STRIP001                     pTabViewShell->ApplyAttributes( &aNewSet, &rOldSet, TRUE );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			DBG_ERROR("falscher Slot bei ExecuteEdit");
//STRIP001 			break;
//STRIP001 	}
//STRIP001 }


//------------------------------------------------------------------

#define APPLY_HOR_JUSTIFY(j) \
	{																		\
		if ( !pHorJustify || (eHorJustify != (j) ) )                        \
			pTabViewShell->ApplyAttr( SvxHorJustifyItem( (j) ) );                          \
		else                                                                \
			pTabViewShell->ApplyAttr( SvxHorJustifyItem( SVX_HOR_JUSTIFY_STANDARD ) );     \
	}

#define APPLY_VER_JUSTIFY(j) \
	{																		\
		if ( !pVerJustify || (eVerJustify != (j) ) )                        \
			pTabViewShell->ApplyAttr( SvxVerJustifyItem( (j) ) );                          \
		else                                                                \
			pTabViewShell->ApplyAttr( SvxVerJustifyItem( SVX_VER_JUSTIFY_STANDARD ) );     \
	}

//STRIP001 void ScFormatShell::ExecuteAlignment( SfxRequest& rReq )
//STRIP001 {
//STRIP001 	ScTabViewShell*	pTabViewShell  		= GetViewData()->GetViewShell();
//STRIP001 	SfxBindings&			rBindings	= pViewData->GetBindings();
//STRIP001 	const SfxItemSet*       pSet		= rReq.GetArgs();
//STRIP001 	USHORT					nSlot		= rReq.GetSlot();
//STRIP001 
//STRIP001 	pTabViewShell->HideListBox();	// Autofilter-DropDown-Listbox
//STRIP001 
//STRIP001 	if( pSet )
//STRIP001 	{
//STRIP001 		const SfxPoolItem* pItem = NULL;
//STRIP001         if( pSet->GetItemState(GetPool().GetWhich(nSlot), TRUE, &pItem  ) == SFX_ITEM_SET )
//STRIP001 		{
//STRIP001 
//STRIP001 			switch ( nSlot )
//STRIP001 			{
//STRIP001                 case SID_ATTR_ALIGN_HOR_JUSTIFY:
//STRIP001                 case SID_ATTR_ALIGN_VER_JUSTIFY:
//STRIP001                 case SID_ATTR_ALIGN_INDENT:
//STRIP001                 case SID_ATTR_ALIGN_HYPHENATION:
//STRIP001                 case SID_ATTR_ALIGN_DEGREES:
//STRIP001                 case SID_ATTR_ALIGN_LOCKPOS:
//STRIP001                 case SID_ATTR_ALIGN_MARGIN:
//STRIP001                 case SID_ATTR_ALIGN_ORIENTATION:
//STRIP001                     pTabViewShell->ApplyAttr( *pItem );
//STRIP001                     break;
//STRIP001 
//STRIP001 				case SID_H_ALIGNCELL:
//STRIP001 				{
//STRIP001 					pTabViewShell->ApplyAttr( SvxHorJustifyItem( (SvxCellHorJustify)((const SvxHorJustifyItem*)pItem)->GetValue() ) );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case SID_V_ALIGNCELL:
//STRIP001 				{
//STRIP001 					pTabViewShell->ApplyAttr( SvxVerJustifyItem( (SvxCellVerJustify)((const SvxVerJustifyItem*)pItem)->GetValue() ) );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				default:
//STRIP001 				DBG_ERROR( "ExecuteAlignment: invalid slot" );
//STRIP001 				return;
//STRIP001 			}
//STRIP001 
//STRIP001 			rBindings.Invalidate( SID_ALIGNLEFT );
//STRIP001 			rBindings.Invalidate( SID_ALIGNRIGHT );
//STRIP001 			rBindings.Invalidate( SID_ALIGNCENTERHOR );
//STRIP001 			rBindings.Invalidate( SID_ALIGNBLOCK );
//STRIP001 			rBindings.Invalidate( SID_ALIGNTOP );
//STRIP001 			rBindings.Invalidate( SID_ALIGNBOTTOM );
//STRIP001 			rBindings.Invalidate( SID_ALIGNCENTERVER );
//STRIP001 			rBindings.Invalidate( SID_V_ALIGNCELL );
//STRIP001 			rBindings.Invalidate( SID_H_ALIGNCELL );
//STRIP001 			rBindings.Update();
//STRIP001 
//STRIP001 			if( ! rReq.IsAPI() )
//STRIP001 				rReq.Done();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScFormatShell::ExecuteTextAttr( SfxRequest& rReq )
//STRIP001 {
//STRIP001 	ScTabViewShell*	pTabViewShell  		= GetViewData()->GetViewShell();
//STRIP001 	SfxBindings&			rBindings	= pViewData->GetBindings();
//STRIP001 	const ScPatternAttr*    pAttrs		= pTabViewShell->GetSelectionPattern();
//STRIP001 	const SfxItemSet*       pSet		= rReq.GetArgs();
//STRIP001 	const SfxItemSet*       pReqArgs	= rReq.GetArgs();
//STRIP001 	USHORT					nSlot		= rReq.GetSlot();
//STRIP001 	SfxAllItemSet*			pNewSet = 0;
//STRIP001 
//STRIP001 	pTabViewShell->HideListBox();					// Autofilter-DropDown-Listbox
//STRIP001 
//STRIP001 	if (  (nSlot == SID_ATTR_CHAR_WEIGHT)
//STRIP001 		||(nSlot == SID_ATTR_CHAR_POSTURE)
//STRIP001 		||(nSlot == SID_ATTR_CHAR_UNDERLINE)
//STRIP001 		||(nSlot == SID_ULINE_VAL_NONE)
//STRIP001 		||(nSlot == SID_ULINE_VAL_SINGLE)
//STRIP001 		||(nSlot == SID_ULINE_VAL_DOUBLE)
//STRIP001 		||(nSlot == SID_ULINE_VAL_DOTTED) )
//STRIP001 	{
//STRIP001 		pNewSet = new SfxAllItemSet( GetPool() );
//STRIP001 
//STRIP001 		switch ( nSlot )
//STRIP001 		{
//STRIP001 			case SID_ATTR_CHAR_WEIGHT:
//STRIP001 			{
//STRIP001 				BYTE nScript = pTabViewShell->GetSelectionScriptType();
//STRIP001 				SfxItemPool& rPool = GetPool();
//STRIP001 				SvxScriptSetItem aSetItem( nSlot, rPool );
//STRIP001 				if ( pSet )
//STRIP001 					aSetItem.PutItemForScriptType( nScript, pSet->Get( ATTR_FONT_WEIGHT ) );
//STRIP001 				else
//STRIP001 				{
//STRIP001 					//	toggle manually
//STRIP001 
//STRIP001 					FontWeight eWeight = WEIGHT_BOLD;
//STRIP001 					SvxScriptSetItem aOldSetItem( nSlot, rPool );
//STRIP001 					aOldSetItem.GetItemSet().Put( pAttrs->GetItemSet(), FALSE );
//STRIP001 					const SfxPoolItem* pCore = aOldSetItem.GetItemOfScript( nScript );
//STRIP001 					if ( pCore && ((const SvxWeightItem*)pCore)->GetWeight() == WEIGHT_BOLD )
//STRIP001 						eWeight = WEIGHT_NORMAL;
//STRIP001 
//STRIP001 					aSetItem.PutItemForScriptType( nScript, SvxWeightItem( eWeight ) );
//STRIP001 				}
//STRIP001 				pTabViewShell->ApplyUserItemSet( aSetItem.GetItemSet() );
//STRIP001 				pNewSet->Put( aSetItem.GetItemSet(), FALSE );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case SID_ATTR_CHAR_POSTURE:
//STRIP001 			{
//STRIP001 				BYTE nScript = pTabViewShell->GetSelectionScriptType();
//STRIP001 				SfxItemPool& rPool = GetPool();
//STRIP001 				SvxScriptSetItem aSetItem( nSlot, rPool );
//STRIP001 				if ( pSet )
//STRIP001 					aSetItem.PutItemForScriptType( nScript, pSet->Get( ATTR_FONT_POSTURE ) );
//STRIP001 				else
//STRIP001 				{
//STRIP001 					//	toggle manually
//STRIP001 
//STRIP001 					FontItalic eItalic = ITALIC_NORMAL;
//STRIP001 					SvxScriptSetItem aOldSetItem( nSlot, rPool );
//STRIP001 					aOldSetItem.GetItemSet().Put( pAttrs->GetItemSet(), FALSE );
//STRIP001 					const SfxPoolItem* pCore = aOldSetItem.GetItemOfScript( nScript );
//STRIP001 					if ( pCore && ((const SvxPostureItem*)pCore)->GetPosture() == ITALIC_NORMAL )
//STRIP001 						eItalic = ITALIC_NONE;
//STRIP001 
//STRIP001 					aSetItem.PutItemForScriptType( nScript, SvxPostureItem( eItalic ) );
//STRIP001 				}
//STRIP001 				pTabViewShell->ApplyUserItemSet( aSetItem.GetItemSet() );
//STRIP001 				pNewSet->Put( aSetItem.GetItemSet(), FALSE );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case SID_ATTR_CHAR_UNDERLINE:
//STRIP001 				{
//STRIP001 					FontUnderline       eUnderline;
//STRIP001 
//STRIP001 					if( pSet )
//STRIP001 					{
//STRIP001 						const SvxUnderlineItem& rUnderline = (const SvxUnderlineItem&)pSet->Get( ATTR_FONT_UNDERLINE );
//STRIP001 
//STRIP001 						if( rUnderline.ISA(SvxUnderlineItem) )
//STRIP001 						{
//STRIP001 							pTabViewShell->ApplyAttr( rUnderline );
//STRIP001 							pNewSet->Put( rUnderline,rUnderline.Which() );
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						SvxUnderlineItem    aUnderline( (const SvxUnderlineItem&)
//STRIP001 														pAttrs->GetItem(
//STRIP001 															ATTR_FONT_UNDERLINE ) );
//STRIP001 						eUnderline = (UNDERLINE_NONE != aUnderline.GetUnderline())
//STRIP001 									? UNDERLINE_NONE
//STRIP001 									: UNDERLINE_SINGLE;
//STRIP001 						aUnderline.SetUnderline( eUnderline );
//STRIP001 						pTabViewShell->ApplyAttr( aUnderline );
//STRIP001 						pNewSet->Put( aUnderline,aUnderline.Which() );
//STRIP001 					}
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ULINE_VAL_NONE:
//STRIP001 				pTabViewShell->ApplyAttr( SvxUnderlineItem( UNDERLINE_NONE, ATTR_FONT_UNDERLINE ) );
//STRIP001 				break;
//STRIP001 			case SID_ULINE_VAL_SINGLE:		// Toggles
//STRIP001 			case SID_ULINE_VAL_DOUBLE:
//STRIP001 			case SID_ULINE_VAL_DOTTED:
//STRIP001 				{
//STRIP001 					FontUnderline eOld = ((const SvxUnderlineItem&)
//STRIP001 											pAttrs->GetItem(ATTR_FONT_UNDERLINE)).GetUnderline();
//STRIP001 					FontUnderline eNew = eOld;
//STRIP001 					switch (nSlot)
//STRIP001 					{
//STRIP001 						case SID_ULINE_VAL_SINGLE:
//STRIP001 							eNew = ( eOld == UNDERLINE_SINGLE ) ? UNDERLINE_NONE : UNDERLINE_SINGLE;
//STRIP001 							break;
//STRIP001 						case SID_ULINE_VAL_DOUBLE:
//STRIP001 							eNew = ( eOld == UNDERLINE_DOUBLE ) ? UNDERLINE_NONE : UNDERLINE_DOUBLE;
//STRIP001 							break;
//STRIP001 						case SID_ULINE_VAL_DOTTED:
//STRIP001 							eNew = ( eOld == UNDERLINE_DOTTED ) ? UNDERLINE_NONE : UNDERLINE_DOTTED;
//STRIP001 							break;
//STRIP001 					}
//STRIP001 					pTabViewShell->ApplyAttr( SvxUnderlineItem( eNew, ATTR_FONT_UNDERLINE ) );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			default:
//STRIP001 				break;
//STRIP001 		}
//STRIP001 		rBindings.Invalidate( nSlot );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		/*
//STRIP001 		 * "Selbstgemachte" RadioButton-Funktionalitaet
//STRIP001 		 * Beim Toggle gibt es den Standard-State, d.h. kein
//STRIP001 		 * Button ist gedrueckt
//STRIP001 		 */
//STRIP001 
//STRIP001 		const SfxItemSet&		 rAttrSet	= pTabViewShell->GetSelectionPattern()->GetItemSet();
//STRIP001 		const SfxPoolItem*       pItem       = NULL;
//STRIP001 		const SvxHorJustifyItem* pHorJustify = NULL;
//STRIP001 		const SvxVerJustifyItem* pVerJustify = NULL;
//STRIP001 		SvxCellHorJustify        eHorJustify = SVX_HOR_JUSTIFY_STANDARD;
//STRIP001 		SvxCellVerJustify        eVerJustify = SVX_VER_JUSTIFY_STANDARD;
//STRIP001 
//STRIP001 		if (rAttrSet.GetItemState(ATTR_HOR_JUSTIFY, TRUE,&pItem ) == SFX_ITEM_SET)
//STRIP001 		{
//STRIP001 			pHorJustify = (const SvxHorJustifyItem*)pItem;
//STRIP001 			eHorJustify = SvxCellHorJustify( pHorJustify->GetValue() );
//STRIP001 		}
//STRIP001 		if (rAttrSet.GetItemState(ATTR_VER_JUSTIFY, TRUE,&pItem ) == SFX_ITEM_SET)
//STRIP001 		{
//STRIP001 			pVerJustify = (const SvxVerJustifyItem*)pItem;
//STRIP001 			eVerJustify = SvxCellVerJustify( pVerJustify->GetValue() );
//STRIP001 		}
//STRIP001 
//STRIP001 		switch ( nSlot )
//STRIP001 		{
//STRIP001 			case SID_ALIGNLEFT:
//STRIP001 				rReq.SetSlot( SID_H_ALIGNCELL );
//STRIP001 				rReq.AppendItem( SvxHorJustifyItem(
//STRIP001 					!pHorJustify || (eHorJustify != SVX_HOR_JUSTIFY_LEFT) ?
//STRIP001 					SVX_HOR_JUSTIFY_LEFT : SVX_HOR_JUSTIFY_STANDARD, SID_H_ALIGNCELL ) );
//STRIP001 				ExecuteSlot( rReq, GetInterface() );
//STRIP001 				return;
//STRIP001 //				APPLY_HOR_JUSTIFY( SVX_HOR_JUSTIFY_LEFT );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ALIGNRIGHT:
//STRIP001 				rReq.SetSlot( SID_H_ALIGNCELL );
//STRIP001 				rReq.AppendItem( SvxHorJustifyItem(
//STRIP001 					!pHorJustify || (eHorJustify != SVX_HOR_JUSTIFY_RIGHT) ?
//STRIP001 					SVX_HOR_JUSTIFY_RIGHT : SVX_HOR_JUSTIFY_STANDARD, SID_H_ALIGNCELL ) );
//STRIP001 				ExecuteSlot( rReq, GetInterface() );
//STRIP001 				return;
//STRIP001 //				APPLY_HOR_JUSTIFY( SVX_HOR_JUSTIFY_RIGHT );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ALIGNCENTERHOR:
//STRIP001 				rReq.SetSlot( SID_H_ALIGNCELL );
//STRIP001 				rReq.AppendItem( SvxHorJustifyItem(
//STRIP001 					!pHorJustify || (eHorJustify != SVX_HOR_JUSTIFY_CENTER) ?
//STRIP001 					SVX_HOR_JUSTIFY_CENTER : SVX_HOR_JUSTIFY_STANDARD, SID_H_ALIGNCELL ) );
//STRIP001 				ExecuteSlot( rReq, GetInterface() );
//STRIP001 				return;
//STRIP001 //				APPLY_HOR_JUSTIFY( SVX_HOR_JUSTIFY_CENTER );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ALIGNBLOCK:
//STRIP001 				rReq.SetSlot( SID_H_ALIGNCELL );
//STRIP001 				rReq.AppendItem( SvxHorJustifyItem(
//STRIP001 					!pHorJustify || (eHorJustify != SVX_HOR_JUSTIFY_BLOCK) ?
//STRIP001 					SVX_HOR_JUSTIFY_BLOCK : SVX_HOR_JUSTIFY_STANDARD, SID_H_ALIGNCELL ) );
//STRIP001 				ExecuteSlot( rReq, GetInterface() );
//STRIP001 				return;
//STRIP001 //				APPLY_HOR_JUSTIFY( SVX_HOR_JUSTIFY_BLOCK );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ALIGNTOP:
//STRIP001 				rReq.SetSlot( SID_V_ALIGNCELL );
//STRIP001 				rReq.AppendItem( SvxVerJustifyItem(
//STRIP001 					!pVerJustify || (eVerJustify != SVX_VER_JUSTIFY_TOP) ?
//STRIP001 					SVX_VER_JUSTIFY_TOP : SVX_VER_JUSTIFY_STANDARD, SID_V_ALIGNCELL ) );
//STRIP001 				ExecuteSlot( rReq, GetInterface() );
//STRIP001 				return;
//STRIP001 //				APPLY_VER_JUSTIFY( SVX_VER_JUSTIFY_TOP );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ALIGNBOTTOM:
//STRIP001 				rReq.SetSlot( SID_V_ALIGNCELL );
//STRIP001 				rReq.AppendItem( SvxVerJustifyItem(
//STRIP001 					!pVerJustify || (eVerJustify != SVX_VER_JUSTIFY_BOTTOM) ?
//STRIP001 					SVX_VER_JUSTIFY_BOTTOM : SVX_VER_JUSTIFY_STANDARD, SID_V_ALIGNCELL ) );
//STRIP001 				ExecuteSlot( rReq, GetInterface() );
//STRIP001 				return;
//STRIP001 //				APPLY_VER_JUSTIFY( SVX_VER_JUSTIFY_BOTTOM );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ALIGNCENTERVER:
//STRIP001 				rReq.SetSlot( SID_V_ALIGNCELL );
//STRIP001 				rReq.AppendItem( SvxVerJustifyItem(
//STRIP001 					!pVerJustify || (eVerJustify != SVX_VER_JUSTIFY_CENTER) ?
//STRIP001 					SVX_VER_JUSTIFY_CENTER : SVX_VER_JUSTIFY_STANDARD, SID_V_ALIGNCELL ) );
//STRIP001 				ExecuteSlot( rReq, GetInterface() );
//STRIP001 				return;
//STRIP001 //				APPLY_VER_JUSTIFY( SVX_VER_JUSTIFY_CENTER );
//STRIP001 				break;
//STRIP001 
//STRIP001 			default:
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	rBindings.Update();
//STRIP001 //	rReq.Done();
//STRIP001 
//STRIP001 	if( pNewSet )
//STRIP001 	{
//STRIP001 		rReq.Done( *pNewSet );
//STRIP001 		delete pNewSet;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		rReq.Done();
//STRIP001 	}
//STRIP001 
//STRIP001 }

#undef APPLY_HOR_JUSTIFY
#undef APPLY_VER_JUSTIFY

//------------------------------------------------------------------

//STRIP001 void ScFormatShell::ExecuteAttr( SfxRequest& rReq )
//STRIP001 {
//STRIP001 	ScTabViewShell*	pTabViewShell  		= GetViewData()->GetViewShell();
//STRIP001 	SfxBindings&		rBindings = pViewData->GetBindings();
//STRIP001 	const SfxItemSet*	pNewAttrs = rReq.GetArgs();
//STRIP001 
//STRIP001 	pTabViewShell->HideListBox();					// Autofilter-DropDown-Listbox
//STRIP001 
//STRIP001 	if ( !pNewAttrs )
//STRIP001 	{
//STRIP001 		USHORT nSlot = rReq.GetSlot();
//STRIP001 
//STRIP001 		switch ( nSlot )
//STRIP001 		{
//STRIP001 			case SID_ATTR_CHAR_FONT:
//STRIP001 			case SID_ATTR_CHAR_FONTHEIGHT:
//STRIP001 				pTabViewShell->ExecuteCellFormatDlg( rReq, TP_FONT );	    // wenn ToolBar vertikal
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ATTR_ALIGN_LINEBREAK:					// ohne Parameter als Toggle
//STRIP001 				{
//STRIP001 					const ScPatternAttr* pAttrs = pTabViewShell->GetSelectionPattern();
//STRIP001 					BOOL bOld = ((const SfxBoolItem&)pAttrs->GetItem(ATTR_LINEBREAK)).GetValue();
//STRIP001 					SfxBoolItem aBreakItem( ATTR_LINEBREAK, !bOld );
//STRIP001 					pTabViewShell->ApplyAttr( aBreakItem );
//STRIP001 
//STRIP001 					SfxAllItemSet aNewSet( GetPool() );
//STRIP001 					aNewSet.Put( aBreakItem,aBreakItem.Which() );
//STRIP001 					rReq.Done( aNewSet );
//STRIP001 
//STRIP001 					rBindings.Invalidate( nSlot );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_BACKGROUND_COLOR:
//STRIP001 				{
//STRIP001 					//	SID_BACKGROUND_COLOR without arguments -> set transparent background
//STRIP001 
//STRIP001 					SvxBrushItem        aBrushItem( (const SvxBrushItem&)
//STRIP001 											pTabViewShell->GetSelectionPattern()->
//STRIP001 												GetItem( ATTR_BACKGROUND ) );
//STRIP001 
//STRIP001 					aBrushItem.SetColor( COL_TRANSPARENT );
//STRIP001 
//STRIP001 					pTabViewShell->ApplyAttr( aBrushItem );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		USHORT nSlot = rReq.GetSlot();
//STRIP001 
//STRIP001 		switch ( nSlot )
//STRIP001 		{
//STRIP001             case SID_ATTR_CHAR_STRIKEOUT:
//STRIP001 			case SID_ATTR_ALIGN_LINEBREAK:
//STRIP001 			case SID_ATTR_CHAR_COLOR:
//STRIP001             case SID_ATTR_CHAR_CONTOUR:
//STRIP001             case SID_ATTR_CHAR_SHADOWED:
//STRIP001             case SID_ATTR_CHAR_RELIEF:
//STRIP001             case SID_SCATTR_PROTECTION :
//STRIP001 				pTabViewShell->ApplyAttr( pNewAttrs->Get( pNewAttrs->GetPool()->GetWhich( nSlot ) ) );
//STRIP001 				rBindings.Invalidate( nSlot );
//STRIP001 				rBindings.Update( nSlot );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ATTR_CHAR_FONT:
//STRIP001 			case SID_ATTR_CHAR_FONTHEIGHT:
//STRIP001 				{
//STRIP001 					BYTE nScript = pTabViewShell->GetSelectionScriptType();
//STRIP001 
//STRIP001 					SfxItemPool& rPool = GetPool();
//STRIP001 					SvxScriptSetItem aSetItem( nSlot, rPool );
//STRIP001 					USHORT nWhich = rPool.GetWhich( nSlot );
//STRIP001 					aSetItem.PutItemForScriptType( nScript, pNewAttrs->Get( nWhich ) );
//STRIP001 
//STRIP001 					pTabViewShell->ApplyUserItemSet( aSetItem.GetItemSet() );
//STRIP001 
//STRIP001 					rBindings.Invalidate( nSlot );
//STRIP001 					rBindings.Update( nSlot );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_FRAME_LINESTYLE:
//STRIP001 				{
//STRIP001 					// Default-Linie aktualisieren
//STRIP001 					const SvxBorderLine* pLine =
//STRIP001 							((const SvxLineItem&)
//STRIP001 								pNewAttrs->Get( SID_FRAME_LINESTYLE )).
//STRIP001 								GetLine();
//STRIP001 
//STRIP001 					if ( pLine )
//STRIP001 					{
//STRIP001 						SvxBorderLine* pDefLine = pTabViewShell->GetDefaultFrameLine();
//STRIP001 
//STRIP001 						if ( pDefLine )
//STRIP001 						{
//STRIP001 							pDefLine->SetOutWidth( pLine->GetOutWidth() );
//STRIP001 							pDefLine->SetInWidth ( pLine->GetInWidth() );
//STRIP001 							pDefLine->SetDistance( pLine->GetDistance() );
//STRIP001 							pTabViewShell->SetSelectionFrameLines( pDefLine, FALSE );
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							pTabViewShell->SetDefaultFrameLine( pLine );
//STRIP001 							pTabViewShell->GetDefaultFrameLine()->SetColor( COL_BLACK );
//STRIP001 							pTabViewShell->SetSelectionFrameLines( pLine, FALSE );
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						Color           aColorBlack( COL_BLACK );
//STRIP001 						SvxBorderLine   aDefLine( &aColorBlack, 20, 0, 0 );
//STRIP001 						pTabViewShell->SetDefaultFrameLine( &aDefLine );
//STRIP001 						pTabViewShell->SetSelectionFrameLines( NULL, FALSE );
//STRIP001 					}
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_FRAME_LINECOLOR:
//STRIP001 				{
//STRIP001 					SvxBorderLine*  pDefLine = pTabViewShell->GetDefaultFrameLine();
//STRIP001 					const Color&    rColor = ((const SvxColorItem&)
//STRIP001 										pNewAttrs->Get( SID_FRAME_LINECOLOR )).
//STRIP001 											GetValue();
//STRIP001 
//STRIP001 					// Default-Linie aktualisieren
//STRIP001 					if ( pDefLine )
//STRIP001 					{
//STRIP001 						pDefLine->SetColor( rColor );
//STRIP001 						pTabViewShell->SetSelectionFrameLines( pDefLine, TRUE );
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						SvxBorderLine   aDefLine( &rColor, 20, 0, 0 );
//STRIP001 						pTabViewShell->SetDefaultFrameLine( &aDefLine );
//STRIP001 						pTabViewShell->SetSelectionFrameLines( &aDefLine, FALSE );
//STRIP001 					}
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ATTR_BORDER_OUTER:
//STRIP001 			case SID_ATTR_BORDER:
//STRIP001 				{
//STRIP001 					SvxBorderLine*          pDefLine = pTabViewShell->GetDefaultFrameLine();
//STRIP001 					const ScPatternAttr*    pOldAttrs = pTabViewShell->GetSelectionPattern();
//STRIP001 					ScDocument*             pDoc = GetViewData()->GetDocument();
//STRIP001 					SfxItemSet*             pOldSet =
//STRIP001 												new SfxItemSet(
//STRIP001 														*(pDoc->GetPool()),
//STRIP001 														ATTR_PATTERN_START,
//STRIP001 														ATTR_PATTERN_END );
//STRIP001 					SfxItemSet*             pNewSet =
//STRIP001 												new SfxItemSet(
//STRIP001 														*(pDoc->GetPool()),
//STRIP001 														ATTR_PATTERN_START,
//STRIP001 														ATTR_PATTERN_END );
//STRIP001 					const SfxPoolItem&      rBorderAttr =
//STRIP001 												pOldAttrs->GetItemSet().
//STRIP001 													Get( ATTR_BORDER );
//STRIP001 
//STRIP001 					// Border-Items vom Controller auswerten:
//STRIP001 					const SfxPoolItem* pItem = 0;
//STRIP001 
//STRIP001 					if ( pNewAttrs->GetItemState( ATTR_BORDER, TRUE, &pItem )
//STRIP001 						 == SFX_ITEM_SET )
//STRIP001 					{
//STRIP001 						//	#100959# The SvxFrameToolBoxControl toolbox controller uses a default
//STRIP001 						//	SvxBorderLine (all widths 0) to mark the lines that should be set.
//STRIP001 						//	Macro recording uses a SvxBoxItem with the real values (OutWidth > 0)
//STRIP001 						//	or NULL pointers for no lines.
//STRIP001 						//	-> Substitute existing lines with pDefLine only if widths are 0.
//STRIP001 						SvxBoxItem aBoxItem ( *(const SvxBoxItem*)pItem );
//STRIP001 						if ( aBoxItem.GetTop() && aBoxItem.GetTop()->GetOutWidth() == 0 )
//STRIP001 							aBoxItem.SetLine( pDefLine, BOX_LINE_TOP );
//STRIP001 						if ( aBoxItem.GetBottom() && aBoxItem.GetBottom()->GetOutWidth() == 0 )
//STRIP001 							aBoxItem.SetLine( pDefLine, BOX_LINE_BOTTOM );
//STRIP001 						if ( aBoxItem.GetLeft() && aBoxItem.GetLeft()->GetOutWidth() == 0 )
//STRIP001 							aBoxItem.SetLine( pDefLine, BOX_LINE_LEFT );
//STRIP001 						if ( aBoxItem.GetRight() && aBoxItem.GetRight()->GetOutWidth() == 0 )
//STRIP001 							aBoxItem.SetLine( pDefLine, BOX_LINE_RIGHT );
//STRIP001 						pNewSet->Put( aBoxItem );
//STRIP001                         rReq.AppendItem( aBoxItem );
//STRIP001 					}
//STRIP001 
//STRIP001 					if ( pNewAttrs->GetItemState( ATTR_BORDER_INNER, TRUE, &pItem )
//STRIP001 						 == SFX_ITEM_SET )
//STRIP001 					{
//STRIP001 						SvxBoxInfoItem aBoxInfoItem( *(const SvxBoxInfoItem*)pItem );
//STRIP001 						if ( aBoxInfoItem.GetHori() && aBoxInfoItem.GetHori()->GetOutWidth() == 0 )
//STRIP001 							aBoxInfoItem.SetLine( pDefLine, BOXINFO_LINE_HORI );
//STRIP001 						if ( aBoxInfoItem.GetVert() && aBoxInfoItem.GetVert()->GetOutWidth() == 0 )
//STRIP001 							aBoxInfoItem.SetLine( pDefLine, BOXINFO_LINE_VERT );
//STRIP001 						pNewSet->Put( aBoxInfoItem );
//STRIP001                         rReq.AppendItem( aBoxInfoItem );
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						SvxBoxInfoItem aBoxInfoItem( ATTR_BORDER_INNER );
//STRIP001 						aBoxInfoItem.SetLine( NULL, BOXINFO_LINE_HORI );
//STRIP001 						aBoxInfoItem.SetLine( NULL, BOXINFO_LINE_VERT );
//STRIP001 						pNewSet->Put( aBoxInfoItem );
//STRIP001 					}
//STRIP001 
//STRIP001 					pOldSet->Put( rBorderAttr );
//STRIP001 					pTabViewShell->ApplyAttributes( pNewSet, pOldSet );
//STRIP001 
//STRIP001 					delete pOldSet;
//STRIP001 					delete pNewSet;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			// ATTR_BACKGROUND (=SID_ATTR_BRUSH) muss ueber zwei IDs
//STRIP001 			// gesetzt werden:
//STRIP001 			case SID_BACKGROUND_COLOR:
//STRIP001 				{
//STRIP001 					const SvxColorItem  rNewColorItem = (const SvxColorItem&)
//STRIP001 											pNewAttrs->Get( SID_BACKGROUND_COLOR );
//STRIP001 
//STRIP001 					SvxBrushItem        aBrushItem( (const SvxBrushItem&)
//STRIP001 											pTabViewShell->GetSelectionPattern()->
//STRIP001 												GetItem( ATTR_BACKGROUND ) );
//STRIP001 
//STRIP001 					aBrushItem.SetColor( rNewColorItem.GetValue() );
//STRIP001 
//STRIP001 					pTabViewShell->ApplyAttr( aBrushItem );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case SID_ATTR_BRUSH:
//STRIP001 				{
//STRIP001 					SvxBrushItem        aBrushItem( (const SvxBrushItem&)
//STRIP001 											pTabViewShell->GetSelectionPattern()->
//STRIP001 												GetItem( ATTR_BACKGROUND ) );
//STRIP001 					const SvxBrushItem& rNewBrushItem = (const SvxBrushItem&)
//STRIP001 											pNewAttrs->Get( GetPool().GetWhich(nSlot) );
//STRIP001 					aBrushItem.SetColor(rNewBrushItem.GetColor());
//STRIP001 					pTabViewShell->ApplyAttr( aBrushItem );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ATTR_BORDER_SHADOW:
//STRIP001 				{
//STRIP001 					const SvxShadowItem& rNewShadowItem = (const SvxShadowItem&)
//STRIP001 											pNewAttrs->Get( ATTR_SHADOW );
//STRIP001 					pTabViewShell->ApplyAttr( rNewShadowItem );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			default:
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( ! rReq.IsAPI() )
//STRIP001 			if( ! rReq.IsDone() )
//STRIP001 				rReq.Done();
//STRIP001 	}
//STRIP001 }

/*N*/ void ScFormatShell::GetAttrState( SfxItemSet& rSet )
/*N*/ {
/*N*/ 	ScTabViewShell*	pTabViewShell  	= GetViewData()->GetViewShell();
/*N*/ 	const SfxItemSet&	 rAttrSet	= pTabViewShell->GetSelectionPattern()->GetItemSet();
/*N*/ 	const SfxItemSet*	 pParentSet = rAttrSet.GetParent();
/*N*/ 	const SvxBorderLine* pLine      = pTabViewShell->GetDefaultFrameLine();
/*N*/ 	const SvxBrushItem&  rBrushItem = (const SvxBrushItem&)rAttrSet.Get( ATTR_BACKGROUND );
/*N*/ 	UINT8				 nTrans		= rBrushItem.GetColor().GetTransparency();
/*N*/ 	SfxWhichIter aIter( rSet );
/*N*/ 	USHORT nWhich = aIter.FirstWhich();
/*N*/ 
/*N*/ 	rSet.Put( rAttrSet, FALSE );
/*N*/ 
/*N*/ 	//	choose font info according to selection script type
/*N*/ 	BYTE nScript = 0;		// GetSelectionScriptType never returns 0
/*N*/ 	if ( rSet.GetItemState( ATTR_FONT ) != SFX_ITEM_UNKNOWN )
/*N*/ 	{
/*N*/ 		if (!nScript) nScript = pTabViewShell->GetSelectionScriptType();
/*N*/ 		ScViewUtil::PutItemScript( rSet, rAttrSet, ATTR_FONT, nScript );
/*N*/ 	}
/*N*/ 	if ( rSet.GetItemState( ATTR_FONT_HEIGHT ) != SFX_ITEM_UNKNOWN )
/*N*/ 	{
/*N*/ 		if (!nScript) nScript = pTabViewShell->GetSelectionScriptType();
/*N*/ 		ScViewUtil::PutItemScript( rSet, rAttrSet, ATTR_FONT_HEIGHT, nScript );
/*N*/ 	}
/*N*/ 
/*N*/ 	while ( nWhich )
/*N*/ 	{
/*N*/ 		switch(nWhich)
/*N*/ 		{
/*N*/ 			case SID_BACKGROUND_COLOR:
/*N*/ 			{
/*N*/ 				Color aColor;
/*N*/ 				if ( nTrans == 255 )
/*N*/                     aColor.SetColor( SC_MOD()->GetColorConfig().GetColorValue(svtools::DOCCOLOR).nColor );
/*N*/ 				else
/*N*/ 					aColor = rBrushItem.GetColor();
/*N*/ 				rSet.Put( SvxColorItem( aColor, SID_BACKGROUND_COLOR ) );
/*N*/ 			}
/*N*/ 			break;
/*N*/ 			case SID_FRAME_LINECOLOR:
/*N*/ 			{
/*N*/ 				rSet.Put( SvxColorItem( pLine ? pLine->GetColor() : Color(),
/*N*/ 										SID_FRAME_LINECOLOR ) );
/*N*/ 			}
/*N*/ 			break;
/*?*/ 			case SID_ATTR_BRUSH:
/*?*/ 			{
/*?*/ 				rSet.Put( rBrushItem, GetPool().GetWhich(nWhich) );
/*?*/ 			}
/*?*/ 			break;
/*			case SID_ATTR_ALIGN_LINEBREAK:
			{
				const SfxBoolItem& rBreakItem = (const SfxBoolItem&)rAttrSet.Get( ATTR_LINEBREAK );
				rSet.Put( rBreakItem, GetPool().GetWhich(nWhich) );
			}
			break;
*/
/*N*/ 		}
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------

/*N*/ void ScFormatShell::GetTextAttrState( SfxItemSet& rSet )
/*N*/ {
/*N*/ 	ScTabViewShell*	pTabViewShell  	= GetViewData()->GetViewShell();
/*N*/ 	const SfxItemSet& rAttrSet	= pTabViewShell->GetSelectionPattern()->GetItemSet();
/*N*/ 	rSet.Put( rAttrSet, FALSE ); // ItemStates mitkopieren
/*N*/ 
/*N*/ 	//	choose font info according to selection script type
/*N*/ 	BYTE nScript = 0;		// GetSelectionScriptType never returns 0
/*N*/ 	if ( rSet.GetItemState( ATTR_FONT_WEIGHT ) != SFX_ITEM_UNKNOWN )
/*N*/ 	{
/*N*/ 		if (!nScript) nScript = pTabViewShell->GetSelectionScriptType();
/*N*/ 		ScViewUtil::PutItemScript( rSet, rAttrSet, ATTR_FONT_WEIGHT, nScript );
/*N*/ 	}
/*N*/ 	if ( rSet.GetItemState( ATTR_FONT_POSTURE ) != SFX_ITEM_UNKNOWN )
/*N*/ 	{
/*N*/ 		if (!nScript) nScript = pTabViewShell->GetSelectionScriptType();
/*N*/ 		ScViewUtil::PutItemScript( rSet, rAttrSet, ATTR_FONT_POSTURE, nScript );
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxItemState eState;
/*N*/ //	const SfxPoolItem* pItem;
/*N*/ 
/*N*/ 	//--------------------------------------------------------------------
/*N*/ 	// eigene Kontrolle ueber RadioButton-Funktionalitaet:
/*N*/ 	//--------------------------------------------------------------------
/*N*/ 	// Unterstreichung
/*N*/ 	//------------------------
/*N*/ 
/*N*/ 	eState = rAttrSet.GetItemState( ATTR_FONT_UNDERLINE, TRUE );
/*N*/ 	if ( eState == SFX_ITEM_DONTCARE )
/*N*/ 	{
/*?*/ 		rSet.InvalidateItem( SID_ULINE_VAL_NONE );
/*?*/ 		rSet.InvalidateItem( SID_ULINE_VAL_SINGLE );
/*?*/ 		rSet.InvalidateItem( SID_ULINE_VAL_DOUBLE );
/*?*/ 		rSet.InvalidateItem( SID_ULINE_VAL_DOTTED );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		FontUnderline eUnderline = ((const SvxUnderlineItem&)
/*N*/ 					rAttrSet.Get(ATTR_FONT_UNDERLINE)).GetUnderline();
/*N*/ 		USHORT nId = SID_ULINE_VAL_NONE;
/*N*/ 		switch (eUnderline)
/*N*/ 		{
/*N*/ 			case UNDERLINE_SINGLE:	nId = SID_ULINE_VAL_SINGLE;	break;
/*N*/ 			case UNDERLINE_DOUBLE:	nId = SID_ULINE_VAL_DOUBLE;	break;
/*N*/ 			case UNDERLINE_DOTTED:	nId = SID_ULINE_VAL_DOTTED;	break;
/*N*/ 			default:
/*N*/ 				break;
/*N*/ 		}
/*N*/ 		rSet.Put( SfxBoolItem( nId, TRUE ) );
/*N*/ 	}
/*N*/ 
/*N*/ 	//------------------------
/*N*/ 	// horizontale Ausrichtung
/*N*/ 	//------------------------
/*N*/ 
/*N*/ 	const SvxHorJustifyItem* pHorJustify = NULL;
/*N*/ 	const SvxVerJustifyItem* pVerJustify = NULL;
/*N*/ 	SvxCellHorJustify        eHorJustify = SVX_HOR_JUSTIFY_STANDARD;
/*N*/ 	SvxCellVerJustify        eVerJustify = SVX_VER_JUSTIFY_STANDARD;
/*N*/ 	USHORT		 			 nWhich		 = 0;
/*N*/ 	BOOL					 bJustifyStd = FALSE;
/*N*/ 	SfxBoolItem				 aBoolItem	 ( 0, TRUE );
/*N*/ 
/*N*/ 	eState 	 = rAttrSet.GetItemState( ATTR_HOR_JUSTIFY, TRUE,
/*N*/ 										(const SfxPoolItem**)&pHorJustify );
/*N*/ 	switch ( eState )
/*N*/ 	{
/*N*/ 		case SFX_ITEM_SET:
/*N*/ 			{
/*N*/ 				eHorJustify = SvxCellHorJustify( pHorJustify->GetValue() );
/*N*/ 
/*N*/ 				switch ( SvxCellHorJustify( pHorJustify->GetValue() ) )
/*N*/ 				{
/*N*/ 					case SVX_HOR_JUSTIFY_STANDARD:
/*N*/ 						break;
/*N*/ 
/*N*/ 					case SVX_HOR_JUSTIFY_LEFT:
/*N*/ 						nWhich = SID_ALIGNLEFT;
/*N*/ 						break;
/*N*/ 
/*N*/ 					case SVX_HOR_JUSTIFY_RIGHT:
/*N*/ 						nWhich = SID_ALIGNRIGHT;
/*N*/ 						break;
/*N*/ 
/*N*/ 					case SVX_HOR_JUSTIFY_CENTER:
/*N*/ 						nWhich = SID_ALIGNCENTERHOR;
/*N*/ 						break;
/*N*/ 
/*N*/ 					case SVX_HOR_JUSTIFY_BLOCK:
/*N*/ 						nWhich = SID_ALIGNBLOCK;
/*N*/ 						break;
/*N*/ 
/*N*/ 					case SVX_HOR_JUSTIFY_REPEAT:
/*N*/ 					default:
/*N*/ 						bJustifyStd = TRUE;
/*N*/ 						break;
/*N*/ 				}
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*?*/ 		case SFX_ITEM_DONTCARE:
/*?*/ 			rSet.InvalidateItem( SID_ALIGNLEFT );
/*?*/ 			rSet.InvalidateItem( SID_ALIGNRIGHT );
/*?*/ 			rSet.InvalidateItem( SID_ALIGNCENTERHOR );
/*?*/ 			rSet.InvalidateItem( SID_ALIGNBLOCK );
/*?*/ 			break;
/*?*/ 
/*N*/ 		default:
/*N*/ 			bJustifyStd = TRUE;
/*N*/ 			break;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( nWhich )
/*N*/ 	{
/*?*/ 		aBoolItem.SetWhich( nWhich );
/*?*/ 		rSet.Put( aBoolItem );
/*N*/ 	}
/*N*/ 	else if ( bJustifyStd )
/*N*/ 	{
/*N*/ 		aBoolItem.SetValue( FALSE );
/*N*/ 		aBoolItem.SetWhich( SID_ALIGNLEFT );	  rSet.Put( aBoolItem );
/*N*/ 		aBoolItem.SetWhich( SID_ALIGNRIGHT );	  rSet.Put( aBoolItem );
/*N*/ 		aBoolItem.SetWhich( SID_ALIGNCENTERHOR ); rSet.Put( aBoolItem );
/*N*/ 		aBoolItem.SetWhich( SID_ALIGNBLOCK );	  rSet.Put( aBoolItem );
/*N*/ 		bJustifyStd = FALSE;
/*N*/ 	}
/*N*/ 
/*N*/ 	//------------------------
/*N*/ 	// vertikale Ausrichtung
/*N*/ 	//------------------------
/*N*/ 
/*N*/ 	nWhich = 0;
/*N*/ 	aBoolItem.SetValue( TRUE );
/*N*/ 
/*N*/ 	eState = rAttrSet.GetItemState( ATTR_VER_JUSTIFY, TRUE,
/*N*/ 									(const SfxPoolItem**)&pVerJustify );
/*N*/ 
/*N*/ 	switch ( eState )
/*N*/ 	{
/*N*/ 		case SFX_ITEM_SET:
/*N*/ 			{
/*N*/ 				eVerJustify = SvxCellVerJustify( pVerJustify->GetValue() );
/*N*/ 
/*N*/ 				switch ( eVerJustify )
/*N*/ 				{
/*N*/ 					case SVX_VER_JUSTIFY_TOP:
/*N*/ 						nWhich = SID_ALIGNTOP;
/*N*/ 						break;
/*N*/ 
/*N*/ 					case SVX_VER_JUSTIFY_BOTTOM:
/*N*/ 						nWhich = SID_ALIGNBOTTOM;
/*N*/ 						break;
/*N*/ 
/*N*/ 					case SVX_VER_JUSTIFY_CENTER:
/*N*/ 						nWhich = SID_ALIGNCENTERVER;
/*N*/ 						break;
/*N*/ 
/*N*/ 					case SVX_VER_JUSTIFY_STANDARD:
/*N*/ 					default:
/*N*/ 						bJustifyStd = TRUE;
/*N*/ 						break;
/*N*/ 				}
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*?*/ 		case SFX_ITEM_DONTCARE:
/*?*/ 			rSet.InvalidateItem( SID_ALIGNTOP );
/*?*/ 			rSet.InvalidateItem( SID_ALIGNBOTTOM );
/*?*/ 			rSet.InvalidateItem( SID_ALIGNCENTERVER );
/*?*/ 			break;
/*?*/ 
/*N*/ 		default:
/*N*/ 			bJustifyStd = TRUE;
/*N*/ 			break;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( nWhich )
/*N*/ 	{
/*N*/ 		aBoolItem.SetWhich( nWhich );
/*N*/ 		rSet.Put( aBoolItem );
/*N*/ 	}
/*N*/ 	else if ( bJustifyStd )
/*N*/ 	{
/*N*/ 		aBoolItem.SetValue( FALSE );
/*N*/ 		aBoolItem.SetWhich( SID_ALIGNTOP );	  	  rSet.Put( aBoolItem );
/*N*/ 		aBoolItem.SetWhich( SID_ALIGNBOTTOM );	  rSet.Put( aBoolItem );
/*N*/ 		aBoolItem.SetWhich( SID_ALIGNCENTERVER ); rSet.Put( aBoolItem );
/*N*/ 	}
/*N*/ }


//------------------------------------------------------------------

//STRIP001 void ScFormatShell::GetBorderState( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	ScTabViewShell*	pTabViewShell  	= GetViewData()->GetViewShell();
//STRIP001 	SvxBoxItem		aBoxItem( ATTR_BORDER );
//STRIP001 	SvxBoxInfoItem	aInfoItem( ATTR_BORDER_INNER );
//STRIP001 
//STRIP001 	pTabViewShell->GetSelectionFrame( aBoxItem, aInfoItem );
//STRIP001 
//STRIP001 	if ( rSet.GetItemState( ATTR_BORDER ) != SFX_ITEM_UNKNOWN )
//STRIP001 		rSet.Put( aBoxItem );
//STRIP001 	if ( rSet.GetItemState( ATTR_BORDER_INNER ) != SFX_ITEM_UNKNOWN )
//STRIP001 		rSet.Put( aInfoItem );
//STRIP001 }

//------------------------------------------------------------------

//STRIP001 void ScFormatShell::GetAlignState( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	ScTabViewShell*	pTabViewShell  	= GetViewData()->GetViewShell();
//STRIP001 	const SfxItemSet& rAttrSet    = pTabViewShell->GetSelectionPattern()->GetItemSet();
//STRIP001 	SfxWhichIter	aIter(rSet);
//STRIP001 	USHORT			nWhich = aIter.FirstWhich();
//STRIP001 
//STRIP001 	while ( nWhich )
//STRIP001 	{
//STRIP001 		switch ( nWhich )
//STRIP001 		{
//STRIP001 			case SID_H_ALIGNCELL:
//STRIP001 			{
//STRIP001 				if ( rAttrSet.GetItemState( ATTR_HOR_JUSTIFY ) != SFX_ITEM_DONTCARE )
//STRIP001 				{
//STRIP001 					SvxCellHorJustify eHorJustify = (SvxCellHorJustify)((const SvxHorJustifyItem&)
//STRIP001 										rAttrSet.Get( ATTR_HOR_JUSTIFY )).GetValue();
//STRIP001 					rSet.Put( SvxHorJustifyItem( eHorJustify, nWhich ));
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			case SID_V_ALIGNCELL:
//STRIP001 			{
//STRIP001 				if ( rAttrSet.GetItemState( ATTR_VER_JUSTIFY ) != SFX_ITEM_DONTCARE )
//STRIP001 				{
//STRIP001 					SvxCellVerJustify eVerJustify = (SvxCellVerJustify)((const SvxVerJustifyItem&)
//STRIP001 										rAttrSet.Get( ATTR_VER_JUSTIFY )).GetValue();
//STRIP001 					rSet.Put( SvxVerJustifyItem( eVerJustify, nWhich ));
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScFormatShell::ExecBckCol( SfxRequest& rReq )
//STRIP001 {
//STRIP001 	ExecuteAttr( rReq );
//STRIP001 }

//STRIP001 void ScFormatShell::GetBckColState( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	GetAttrState( rSet );
//STRIP001 }
//STRIP001 void ScFormatShell::GetNumFormatState( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	ScTabViewShell*	pTabViewShell  	= GetViewData()->GetViewShell();
//STRIP001 	BOOL bOle = pTabViewShell->GetViewFrame()->ISA(SfxInPlaceFrame);
//STRIP001 	BOOL bTabProt = GetViewData()->GetDocument()->IsTabProtected(GetViewData()->GetTabNo());
//STRIP001 	SfxApplication* pSfxApp = SFX_APP();
//STRIP001 
//STRIP001 	ScViewData* pViewData	= GetViewData();
//STRIP001 	ScDocument* pDoc		= pViewData->GetDocument();
//STRIP001 	ScMarkData& rMark		= pViewData->GetMarkData();
//STRIP001 	USHORT		nPosX		= pViewData->GetCurX();
//STRIP001 	USHORT		nPosY		= pViewData->GetCurY();
//STRIP001 	USHORT		nTab		= pViewData->GetTabNo();
//STRIP001 	USHORT		nMyId		= 0;
//STRIP001 
//STRIP001 	USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 	USHORT nTabSelCount = rMark.GetSelectCount();
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 	SfxWhichIter aIter(rSet);
//STRIP001 	USHORT nWhich = aIter.FirstWhich();
//STRIP001 	while ( nWhich )
//STRIP001 	{
//STRIP001 		switch ( nWhich )
//STRIP001 		{
//STRIP001 			case SID_NUMBER_FORMAT:
//STRIP001 				{
//STRIP001 					String aFormatCode;			// bleibt leer, wenn dont-care
//STRIP001 
//STRIP001 					const SfxItemSet& rAttrSet  = pTabViewShell->GetSelectionPattern()->GetItemSet();
//STRIP001 					if ( rAttrSet.GetItemState( ATTR_VALUE_FORMAT ) != SFX_ITEM_DONTCARE )
//STRIP001 					{
//STRIP001 						ULONG nNumberFormat = ((const SfxUInt32Item&)rAttrSet.Get(
//STRIP001 													ATTR_VALUE_FORMAT )).GetValue();
//STRIP001 
//STRIP001 						SvNumberFormatter* pFormatter = pDoc->GetFormatTable();
//STRIP001 						const SvNumberformat* pFormatEntry = pFormatter->GetEntry( nNumberFormat );
//STRIP001 						if ( pFormatEntry )
//STRIP001 							aFormatCode = pFormatEntry->GetFormatstring();
//STRIP001 					}
//STRIP001 
//STRIP001 					rSet.Put( SfxStringItem( nWhich, aFormatCode ) );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 		}
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 }


//STRIP001 void ScFormatShell::ExecuteTextDirection( SfxRequest& rReq )
//STRIP001 {
//STRIP001     ScTabViewShell* pTabViewShell = GetViewData()->GetViewShell();
//STRIP001     pTabViewShell->HideListBox();               // Autofilter-DropDown-Listbox
//STRIP001     if ( GetViewData()->HasEditView( GetViewData()->GetActivePart() ) )
//STRIP001     {
//STRIP001         SC_MOD()->InputEnterHandler();
//STRIP001         pTabViewShell->UpdateInputHandler();
//STRIP001     }
//STRIP001 
//STRIP001     USHORT nSlot = rReq.GetSlot();
//STRIP001     switch( nSlot )
//STRIP001     {
//STRIP001         case SID_TEXTDIRECTION_LEFT_TO_RIGHT:
//STRIP001         case SID_TEXTDIRECTION_TOP_TO_BOTTOM:
//STRIP001         {
//STRIP001             BOOL bVert = (nSlot == SID_TEXTDIRECTION_TOP_TO_BOTTOM);
//STRIP001             SvxCellOrientation eOrient = bVert ? SVX_ORIENTATION_STACKED : SVX_ORIENTATION_STANDARD;
//STRIP001             ScPatternAttr aAttr( GetViewData()->GetDocument()->GetPool() );
//STRIP001             SfxItemSet& rItemSet = aAttr.GetItemSet();
//STRIP001             rItemSet.Put( SvxOrientationItem( eOrient, ATTR_ORIENTATION ) );
//STRIP001             rItemSet.Put( SfxBoolItem( ATTR_VERTICAL_ASIAN, bVert ) );
//STRIP001             pTabViewShell->ApplySelectionPattern( aAttr );
//STRIP001             pTabViewShell->AdjustBlockHeight();
//STRIP001         }
//STRIP001         break;
//STRIP001 
//STRIP001         case SID_ATTR_PARA_LEFT_TO_RIGHT:
//STRIP001         case SID_ATTR_PARA_RIGHT_TO_LEFT:
//STRIP001         {
//STRIP001             SvxFrameDirection eDirection = ( nSlot == SID_ATTR_PARA_LEFT_TO_RIGHT ) ?
//STRIP001                                                 FRMDIR_HORI_LEFT_TOP : FRMDIR_HORI_RIGHT_TOP;
//STRIP001             pTabViewShell->ApplyAttr( SvxFrameDirectionItem( eDirection, ATTR_WRITINGDIR ) );
//STRIP001         }
//STRIP001         break;
//STRIP001     }
//STRIP001 }

/*M*/ void ScFormatShell::GetTextDirectionState( SfxItemSet& rSet )
/*M*/ {
/*M*/     ScTabViewShell* pTabViewShell = GetViewData()->GetViewShell();
/*M*/     const SfxItemSet& rAttrSet = pTabViewShell->GetSelectionPattern()->GetItemSet();
/*M*/ 
/*M*/     BOOL bVertDontCare =
/*M*/         (rAttrSet.GetItemState( ATTR_VERTICAL_ASIAN ) == SFX_ITEM_DONTCARE) ||
/*M*/         (rAttrSet.GetItemState( ATTR_ORIENTATION ) == SFX_ITEM_DONTCARE);
/*M*/     BOOL bLeftRight = !bVertDontCare &&
/*M*/         (((const SvxOrientationItem&) rAttrSet.Get( ATTR_ORIENTATION )).GetValue() != SVX_ORIENTATION_STACKED);
/*M*/     BOOL bTopBottom = !bVertDontCare && !bLeftRight &&
/*M*/         ((const SfxBoolItem&) rAttrSet.Get( ATTR_VERTICAL_ASIAN )).GetValue();
/*M*/ 
/*M*/     BOOL bBidiDontCare = (rAttrSet.GetItemState( ATTR_WRITINGDIR ) == SFX_ITEM_DONTCARE);
/*M*/     EEHorizontalTextDirection eBidiDir = EE_HTEXTDIR_DEFAULT;
/*M*/     if ( !bBidiDontCare )
/*M*/     {
/*M*/         SvxFrameDirection eCellDir = (SvxFrameDirection)((const SvxFrameDirectionItem&)
/*M*/                                         rAttrSet.Get( ATTR_WRITINGDIR )).GetValue();
/*M*/         if ( eCellDir == FRMDIR_ENVIRONMENT )
/*M*/             eBidiDir = (EEHorizontalTextDirection)GetViewData()->GetDocument()->
/*M*/                                 GetEditTextDirection( GetViewData()->GetTabNo() );
/*M*/         else if ( eCellDir == FRMDIR_HORI_RIGHT_TOP )
/*M*/             eBidiDir = EE_HTEXTDIR_R2L;
/*M*/         else
/*M*/             eBidiDir = EE_HTEXTDIR_L2R;
/*M*/     }
/*M*/ 
/*N*/ 	SvtLanguageOptions	aLangOpt;
/*N*/ 	BOOL bDisableCTLFont = !aLangOpt.IsCTLFontEnabled();
/*N*/ 	BOOL bDisableVerticalText = !aLangOpt.IsVerticalTextEnabled();
/*N*/ 
/*N*/     SfxWhichIter aIter( rSet );
/*N*/     USHORT nWhich = aIter.FirstWhich();
/*N*/     while( nWhich )
/*N*/     {
/*N*/         switch( nWhich )
/*N*/         {
/*N*/             case SID_TEXTDIRECTION_LEFT_TO_RIGHT:
/*N*/             case SID_TEXTDIRECTION_TOP_TO_BOTTOM:
/*N*/                 if ( bDisableVerticalText )
/*N*/ 					rSet.DisableItem( nWhich );
/*N*/ 				else
/*N*/ 				{
/*?*/ 					if( bVertDontCare )
/*?*/ 						rSet.InvalidateItem( nWhich );
/*?*/ 					else if ( nWhich == SID_TEXTDIRECTION_LEFT_TO_RIGHT )
/*?*/ 						rSet.Put( SfxBoolItem( nWhich, bLeftRight ) );
/*?*/ 					else
/*?*/ 						rSet.Put( SfxBoolItem( nWhich, bTopBottom ) );
/*N*/ 				}
/*N*/             break;
/*N*/ 
/*N*/             case SID_ATTR_PARA_LEFT_TO_RIGHT:
/*N*/             case SID_ATTR_PARA_RIGHT_TO_LEFT:
/*N*/ 				if ( bDisableCTLFont )
/*N*/ 					rSet.DisableItem( nWhich );
/*N*/ 				else
/*N*/ 				{
/*?*/ 					if ( bTopBottom )
/*?*/ 						rSet.DisableItem( nWhich );
/*?*/ 					else if ( bBidiDontCare )
/*?*/ 						rSet.InvalidateItem( nWhich );
/*?*/ 					else if ( nWhich == SID_ATTR_PARA_LEFT_TO_RIGHT )
/*?*/ 						rSet.Put( SfxBoolItem( nWhich, eBidiDir == EE_HTEXTDIR_L2R ) );
/*?*/ 					else
/*?*/ 						rSet.Put( SfxBoolItem( nWhich, eBidiDir == EE_HTEXTDIR_R2L ) );
/*N*/ 				}
/*N*/         }
/*M*/         nWhich = aIter.NextWhich();
/*M*/     }
/*M*/ }

}
