/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_dbfunc3.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:23:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

// auto strip #include "scitems.hxx"
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #include <vcl/svapp.hxx>
// auto strip #include <vcl/msgbox.hxx>
// auto strip #include <vcl/sound.hxx>
// auto strip #include <vcl/waitobj.hxx>

#include "dbfunc.hxx"
// auto strip #include "global.hxx"
#include "globstr.hrc"
#include "bf_sc.hrc"
// auto strip #include "undotab.hxx"
// auto strip #include "undodat.hxx"
// auto strip #include "dbcolect.hxx"
// auto strip #include "rangenam.hxx"
// auto strip #include "rangeutl.hxx"
#include "docsh.hxx"
#include "olinetab.hxx"
// auto strip #include "consoli.hxx"
// auto strip #include "olinefun.hxx"
// auto strip #include "dpobject.hxx"
// auto strip #include "dpsave.hxx"
// auto strip #include "dbdocfun.hxx"
// auto strip #include "editable.hxx"
namespace binfilter {

// STATIC DATA -----------------------------------------------------------


//==================================================================

//
//			Outliner
//

//	Outline-Gruppierung erzeugen

//STRIP001 void ScDBFunc::MakeOutline( BOOL bColumns, BOOL bRecord )
//STRIP001 {
//STRIP001 	ScRange aRange;
//STRIP001 	if (GetViewData()->GetSimpleArea(aRange))
//STRIP001 	{
//STRIP001 		ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 		ScOutlineDocFunc aFunc(*pDocSh);
//STRIP001 		aFunc.MakeOutline( aRange, bColumns, bRecord, FALSE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		ErrorMessage(STR_NOMULTISELECT);
//STRIP001 }

//	Outline-Gruppierung loeschen

//STRIP001 void ScDBFunc::RemoveOutline( BOOL bColumns, BOOL bRecord )
//STRIP001 {
//STRIP001 	ScRange aRange;
//STRIP001 	if (GetViewData()->GetSimpleArea(aRange))
//STRIP001 	{
//STRIP001 		ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 		ScOutlineDocFunc aFunc(*pDocSh);
//STRIP001 		aFunc.RemoveOutline( aRange, bColumns, bRecord, FALSE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		ErrorMessage(STR_NOMULTISELECT);
//STRIP001 }

//	Menue-Status: Outlines loeschen

/*N*/ void ScDBFunc::TestRemoveOutline( BOOL& rCol, BOOL& rRow )
/*N*/ {
/*N*/ 	BOOL bColFound = FALSE;
/*N*/ 	BOOL bRowFound = FALSE;
/*N*/ 
/*N*/ 	USHORT nStartCol, nStartRow, nStartTab;
/*N*/ 	USHORT nEndCol, nEndRow, nEndTab;
/*N*/ 	if (GetViewData()->GetSimpleArea(nStartCol,nStartRow,nStartTab,nEndCol,nEndRow,nEndTab))
/*N*/ 	{
/*N*/ 		USHORT nTab = nStartTab;
/*N*/ 		ScDocument* pDoc = GetViewData()->GetDocument();
/*N*/ 		ScOutlineTable* pTable = pDoc->GetOutlineTable( nTab );
/*N*/ 		if (pTable)
/*N*/ 		{
/*?*/ 			ScOutlineArray* pArray;
/*?*/ 			ScOutlineEntry* pEntry;
/*?*/ 			USHORT nStart;
/*?*/ 			USHORT nEnd;
/*?*/ 			BOOL bColMarked = ( nStartRow == 0 && nEndRow == MAXROW );
/*?*/ 			BOOL bRowMarked = ( nStartCol == 0 && nEndCol == MAXCOL );
/*?*/ 
/*?*/ 			//	Spalten
/*?*/ 
/*?*/ 			if ( !bRowMarked || bColMarked )		// nicht wenn ganze Zeilen markiert
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pArray = pTable->GetColArray();
//STRIP001 /*?*/ 				ScSubOutlineIterator aColIter( pArray );
//STRIP001 /*?*/ 				while ((pEntry=aColIter.GetNext()) != NULL && !bColFound)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					nStart = pEntry->GetStart();
//STRIP001 /*?*/ 					nEnd   = pEntry->GetEnd();
//STRIP001 /*?*/ 					if ( nStartCol<=nEnd && nEndCol>=nStart )
//STRIP001 /*?*/ 						bColFound = TRUE;
//STRIP001 /*?*/ 				}
/*?*/ 			}
/*?*/ 
/*?*/ 			//	Zeilen
/*?*/ 
/*?*/ 			if ( !bColMarked || bRowMarked )		// nicht wenn ganze Spalten markiert
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pArray = pTable->GetRowArray();
//STRIP001 /*?*/ 				ScSubOutlineIterator aRowIter( pArray );
//STRIP001 /*?*/ 				while ((pEntry=aRowIter.GetNext()) != NULL && !bRowFound)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					nStart = pEntry->GetStart();
//STRIP001 /*?*/ 					nEnd   = pEntry->GetEnd();
//STRIP001 /*?*/ 					if ( nStartRow<=nEnd && nEndRow>=nStart )
//STRIP001 /*?*/ 						bRowFound = TRUE;
//STRIP001 /*?*/ 				}
/*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	rCol = bColFound;
/*N*/ 	rRow = bRowFound;
/*N*/ }

//STRIP001 void ScDBFunc::RemoveAllOutlines( BOOL bRecord )
//STRIP001 {
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScOutlineDocFunc aFunc(*pDocSh);
//STRIP001 
//STRIP001 	HideCursor();
//STRIP001 	BOOL bOk = aFunc.RemoveAllOutlines( nTab, bRecord, FALSE );
//STRIP001 	ShowCursor();
//STRIP001 
//STRIP001 	if (bOk)
//STRIP001 		UpdateScrollBars();
//STRIP001 }

//	Auto-Outlines

//STRIP001 void ScDBFunc::AutoOutline( BOOL bRecord )
//STRIP001 {
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	ScRange aRange( 0,0,nTab, MAXCOL,MAXROW,nTab );		// ganze Tabelle, wenn nichts markiert
//STRIP001 	ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 	if ( rMark.IsMarked() || rMark.IsMultiMarked() )
//STRIP001 	{
//STRIP001 		rMark.MarkToMulti();
//STRIP001 		rMark.GetMultiMarkArea( aRange );
//STRIP001 	}
//STRIP001 
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScOutlineDocFunc aFunc(*pDocSh);
//STRIP001 	aFunc.AutoOutline( aRange, bRecord, FALSE );
//STRIP001 }

//	Outline-Ebene auswaehlen

//STRIP001 void ScDBFunc::SelectLevel( BOOL bColumns, USHORT nLevel, BOOL bRecord, BOOL bPaint )
//STRIP001 {
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScOutlineDocFunc aFunc(*pDocSh);
//STRIP001 
//STRIP001 	HideCursor();
//STRIP001 	BOOL bOk = aFunc.SelectLevel( nTab, bColumns, nLevel, bRecord, bPaint, FALSE );
//STRIP001 	ShowCursor();
//STRIP001 
//STRIP001 	if (bOk)
//STRIP001 		UpdateScrollBars();
//STRIP001 }

//	einzelne Outline-Gruppe einblenden

//STRIP001 void ScDBFunc::ShowOutline( BOOL bColumns, USHORT nLevel, USHORT nEntry, BOOL bRecord, BOOL bPaint )
//STRIP001 {
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScOutlineDocFunc aFunc(*pDocSh);
//STRIP001 
//STRIP001 	HideCursor();
//STRIP001 	BOOL bOk = aFunc.ShowOutline( nTab, bColumns, nLevel, nEntry, bRecord, bPaint, FALSE );
//STRIP001 	ShowCursor();
//STRIP001 
//STRIP001 	if ( bOk && bPaint )
//STRIP001 		UpdateScrollBars();
//STRIP001 }

//	einzelne Outline-Gruppe ausblenden

//STRIP001 void ScDBFunc::HideOutline( BOOL bColumns, USHORT nLevel, USHORT nEntry, BOOL bRecord, BOOL bPaint )
//STRIP001 {
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScOutlineDocFunc aFunc(*pDocSh);
//STRIP001 
//STRIP001 	HideCursor();
//STRIP001 	BOOL bOk = aFunc.HideOutline( nTab, bColumns, nLevel, nEntry, bRecord, bPaint, FALSE );
//STRIP001 	ShowCursor();
//STRIP001 
//STRIP001 	if ( bOk && bPaint )
//STRIP001 		UpdateScrollBars();
//STRIP001 }

//	Menue-Status: markierten Bereich ein-/ausblenden

//STRIP001 BOOL ScDBFunc::OutlinePossible(BOOL bHide)
//STRIP001 {
//STRIP001 	BOOL bEnable = FALSE;
//STRIP001 
//STRIP001 	USHORT nStartCol;
//STRIP001 	USHORT nStartRow;
//STRIP001 	USHORT nStartTab;
//STRIP001 	USHORT nEndCol;
//STRIP001 	USHORT nEndRow;
//STRIP001 	USHORT nEndTab;
//STRIP001 
//STRIP001 	if (GetViewData()->GetSimpleArea(nStartCol,nStartRow,nStartTab,nEndCol,nEndRow,nEndTab))
//STRIP001 	{
//STRIP001 		ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 		USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 		ScOutlineTable* pTable = pDoc->GetOutlineTable( nTab );
//STRIP001 		if (pTable)
//STRIP001 		{
//STRIP001 			ScOutlineArray* pArray;
//STRIP001 			ScOutlineEntry* pEntry;
//STRIP001 			USHORT nStart;
//STRIP001 			USHORT nEnd;
//STRIP001 
//STRIP001 			//	Spalten
//STRIP001 
//STRIP001 			pArray = pTable->GetColArray();
//STRIP001 			ScSubOutlineIterator aColIter( pArray );
//STRIP001 			while ((pEntry=aColIter.GetNext()) != NULL && !bEnable)
//STRIP001 			{
//STRIP001 				nStart = pEntry->GetStart();
//STRIP001 				nEnd   = pEntry->GetEnd();
//STRIP001 				if ( bHide )
//STRIP001 				{
//STRIP001 					if ( nStartCol<=nEnd && nEndCol>=nStart )
//STRIP001 						if (!pEntry->IsHidden())
//STRIP001 							bEnable = TRUE;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if ( nStart>=nStartCol && nEnd<=nEndCol )
//STRIP001 						if (pEntry->IsHidden())
//STRIP001 							bEnable = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			//	Zeilen
//STRIP001 
//STRIP001 			pArray = pTable->GetRowArray();
//STRIP001 			ScSubOutlineIterator aRowIter( pArray );
//STRIP001 			while ((pEntry=aRowIter.GetNext()) != NULL)
//STRIP001 			{
//STRIP001 				nStart = pEntry->GetStart();
//STRIP001 				nEnd   = pEntry->GetEnd();
//STRIP001 				if ( bHide )
//STRIP001 				{
//STRIP001 					if ( nStartRow<=nEnd && nEndRow>=nStart )
//STRIP001 						if (!pEntry->IsHidden())
//STRIP001 							bEnable = TRUE;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if ( nStart>=nStartRow && nEnd<=nEndRow )
//STRIP001 						if (pEntry->IsHidden())
//STRIP001 							bEnable = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bEnable;
//STRIP001 }

//	markierten Bereich einblenden

//STRIP001 void ScDBFunc::ShowMarkedOutlines( BOOL bRecord )
//STRIP001 {
//STRIP001 	ScRange aRange;
//STRIP001 	if (GetViewData()->GetSimpleArea(aRange))
//STRIP001 	{
//STRIP001 		ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 		ScOutlineDocFunc aFunc(*pDocSh);
//STRIP001 		HideCursor();
//STRIP001 		BOOL bDone = aFunc.ShowMarkedOutlines( aRange, bRecord, FALSE );
//STRIP001 		ShowCursor();
//STRIP001 		if (bDone)
//STRIP001 			UpdateScrollBars();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		ErrorMessage(STR_NOMULTISELECT);
//STRIP001 }

//	markierten Bereich ausblenden

//STRIP001 void ScDBFunc::HideMarkedOutlines( BOOL bRecord )
//STRIP001 {
//STRIP001 	ScRange aRange;
//STRIP001 	if (GetViewData()->GetSimpleArea(aRange))
//STRIP001 	{
//STRIP001 		ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 		ScOutlineDocFunc aFunc(*pDocSh);
//STRIP001 		HideCursor();
//STRIP001 		BOOL bDone = aFunc.HideMarkedOutlines( aRange, bRecord, FALSE );
//STRIP001 		ShowCursor();
//STRIP001 		if (bDone)
//STRIP001 			UpdateScrollBars();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		ErrorMessage(STR_NOMULTISELECT);
//STRIP001 }

//	--------------------------------------------------------------------------

//
//			Teilergebnisse
//

//STRIP001 void ScDBFunc::DoSubTotals( const ScSubTotalParam& rParam, BOOL bRecord,
//STRIP001 							const ScSortParam* pForceNewSort )
//STRIP001 {
//STRIP001 	BOOL bDo = !rParam.bRemoveOnly;							// FALSE = nur loeschen
//STRIP001 
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	if (bRecord && !pDoc->IsUndoEnabled())
//STRIP001 		bRecord = FALSE;
//STRIP001 
//STRIP001 	ScDBData* pDBData = pDoc->GetDBAtArea( nTab, rParam.nCol1, rParam.nRow1,
//STRIP001 												rParam.nCol2, rParam.nRow2 );
//STRIP001 	if (!pDBData)
//STRIP001 	{
//STRIP001 		DBG_ERROR( "SubTotals: keine DBData" );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScEditableTester aTester( pDoc, nTab, 0,rParam.nRow1+1, MAXCOL,MAXROW );
//STRIP001 	if (!aTester.IsEditable())
//STRIP001 	{
//STRIP001 		ErrorMessage(aTester.GetMessageId());
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pDoc->HasAttrib( rParam.nCol1, rParam.nRow1+1, nTab,
//STRIP001 						 rParam.nCol2, rParam.nRow2, nTab, HASATTR_MERGED | HASATTR_OVERLAPPED ))
//STRIP001 	{
//STRIP001 		ErrorMessage(STR_MSSG_INSERTCELLS_0);	// nicht in zusammengefasste einfuegen
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	WaitObject aWait( GetViewData()->GetDialogParent() );
//STRIP001 	BOOL bOk = TRUE;
//STRIP001 	BOOL bDelete = FALSE;
//STRIP001 	if (rParam.bReplace)
//STRIP001 		if (pDoc->TestRemoveSubTotals( nTab, rParam ))
//STRIP001 		{
//STRIP001 			bDelete = TRUE;
//STRIP001 			bOk = ( MessBox( GetViewData()->GetDialogParent(), WinBits(WB_YES_NO | WB_DEF_YES),
//STRIP001 				// "StarCalc" "Daten loeschen?"
//STRIP001 				ScGlobal::GetRscString( STR_MSSG_DOSUBTOTALS_0 ),
//STRIP001 				ScGlobal::GetRscString( STR_MSSG_DOSUBTOTALS_1 ) ).Execute()
//STRIP001 				== RET_YES );
//STRIP001 		}
//STRIP001 
//STRIP001 	if (bOk)
//STRIP001 	{
//STRIP001 		ScDocShellModificator aModificator( *pDocSh );
//STRIP001 
//STRIP001 		ScSubTotalParam aNewParam( rParam );		// Bereichsende wird veraendert
//STRIP001 		ScDocument*		pUndoDoc = NULL;
//STRIP001 		ScOutlineTable*	pUndoTab = NULL;
//STRIP001 		ScRangeName*	pUndoRange = NULL;
//STRIP001 		ScDBCollection* pUndoDB = NULL;
//STRIP001 		USHORT 			nTabCount = 0;				// fuer Referenz-Undo
//STRIP001 
//STRIP001 		if (bRecord)										// alte Daten sichern
//STRIP001 		{
//STRIP001 			BOOL bOldFilter = bDo && rParam.bDoSort;
//STRIP001 
//STRIP001 			nTabCount = pDoc->GetTableCount();
//STRIP001 			pUndoDoc = new ScDocument( SCDOCMODE_UNDO );
//STRIP001 			ScOutlineTable* pTable = pDoc->GetOutlineTable( nTab );
//STRIP001 			if (pTable)
//STRIP001 			{
//STRIP001 				pUndoTab = new ScOutlineTable( *pTable );
//STRIP001 
//STRIP001 				USHORT nOutStartCol;							// Zeilen/Spaltenstatus
//STRIP001 				USHORT nOutStartRow;
//STRIP001 				USHORT nOutEndCol;
//STRIP001 				USHORT nOutEndRow;
//STRIP001 				pTable->GetColArray()->GetRange( nOutStartCol, nOutEndCol );
//STRIP001 				pTable->GetRowArray()->GetRange( nOutStartRow, nOutEndRow );
//STRIP001 
//STRIP001 				pUndoDoc->InitUndo( pDoc, nTab, nTab, TRUE, TRUE );
//STRIP001 				pDoc->CopyToDocument( nOutStartCol, 0, nTab, nOutEndCol, MAXROW, nTab, IDF_NONE, FALSE, pUndoDoc );
//STRIP001 				pDoc->CopyToDocument( 0, nOutStartRow, nTab, MAXCOL, nOutEndRow, nTab, IDF_NONE, FALSE, pUndoDoc );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pUndoDoc->InitUndo( pDoc, nTab, nTab, FALSE, bOldFilter );
//STRIP001 
//STRIP001 			//	Datenbereich sichern - incl. Filter-Ergebnis
//STRIP001 			pDoc->CopyToDocument( 0,rParam.nRow1+1,nTab, MAXCOL,rParam.nRow2,nTab,
//STRIP001 									IDF_ALL, FALSE, pUndoDoc );
//STRIP001 
//STRIP001 			//	alle Formeln wegen Referenzen
//STRIP001 			pDoc->CopyToDocument( 0,0,0, MAXCOL,MAXROW,nTabCount-1,
//STRIP001 										IDF_FORMULA, FALSE, pUndoDoc );
//STRIP001 
//STRIP001 			//	DB- und andere Bereiche
//STRIP001 			ScRangeName* pDocRange = pDoc->GetRangeName();
//STRIP001 			if (pDocRange->GetCount())
//STRIP001 				pUndoRange = new ScRangeName( *pDocRange );
//STRIP001 			ScDBCollection* pDocDB = pDoc->GetDBCollection();
//STRIP001 			if (pDocDB->GetCount())
//STRIP001 				pUndoDB = new ScDBCollection( *pDocDB );
//STRIP001 		}
//STRIP001 
//STRIP001 //		pDoc->SetOutlineTable( nTab, NULL );
//STRIP001 		ScOutlineTable*	pOut = pDoc->GetOutlineTable( nTab );
//STRIP001 		if (pOut)
//STRIP001 			pOut->GetRowArray()->RemoveAll();		// nur Zeilen-Outlines loeschen
//STRIP001 
//STRIP001 		if (rParam.bReplace)
//STRIP001 			pDoc->RemoveSubTotals( nTab, aNewParam );
//STRIP001 		BOOL bSuccess = TRUE;
//STRIP001 		if (bDo)
//STRIP001 		{
//STRIP001 			// Sortieren
//STRIP001 			if ( rParam.bDoSort || pForceNewSort )
//STRIP001 			{
//STRIP001 				pDBData->SetArea( nTab, aNewParam.nCol1,aNewParam.nRow1, aNewParam.nCol2,aNewParam.nRow2 );
//STRIP001 
//STRIP001 				//	Teilergebnis-Felder vor die Sortierung setzen
//STRIP001 				//	(doppelte werden weggelassen, kann darum auch wieder aufgerufen werden)
//STRIP001 
//STRIP001 				ScSortParam aOldSort;
//STRIP001 				pDBData->GetSortParam( aOldSort );
//STRIP001 				ScSortParam aSortParam( aNewParam, pForceNewSort ? *pForceNewSort : aOldSort );
//STRIP001 				Sort( aSortParam, FALSE, FALSE );
//STRIP001 			}
//STRIP001 
//STRIP001 			bSuccess = pDoc->DoSubTotals( nTab, aNewParam );
//STRIP001 		}
//STRIP001 		ScRange aDirtyRange( aNewParam.nCol1, aNewParam.nRow1, nTab,
//STRIP001 			aNewParam.nCol2, aNewParam.nRow2, nTab );
//STRIP001 		pDoc->SetDirty( aDirtyRange );
//STRIP001 
//STRIP001 		if (bRecord)
//STRIP001 		{
//STRIP001 //			ScDBData* pUndoDBData = pDBData ? new ScDBData( *pDBData ) : NULL;
//STRIP001 			pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 				new ScUndoSubTotals( pDocSh, nTab,
//STRIP001 										rParam, aNewParam.nRow2,
//STRIP001 										pUndoDoc, pUndoTab, // pUndoDBData,
//STRIP001 										pUndoRange, pUndoDB ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		if (!bSuccess)
//STRIP001 		{
//STRIP001 			// "Kann keine Zeilen einfuegen"
//STRIP001 			ErrorMessage(STR_MSSG_DOSUBTOTALS_2);
//STRIP001 		}
//STRIP001 
//STRIP001 													// merken
//STRIP001 		pDBData->SetSubTotalParam( aNewParam );
//STRIP001 		pDBData->SetArea( nTab, aNewParam.nCol1,aNewParam.nRow1, aNewParam.nCol2,aNewParam.nRow2 );
//STRIP001 		pDoc->CompileDBFormula();
//STRIP001 
//STRIP001 		DoneBlockMode();
//STRIP001 		InitOwnBlockMode();
//STRIP001 		rMark.SetMarkArea( ScRange( aNewParam.nCol1,aNewParam.nRow1,nTab,
//STRIP001 									aNewParam.nCol2,aNewParam.nRow2,nTab ) );
//STRIP001 
//STRIP001 		pDocSh->PostPaint( 0,0,nTab, MAXCOL,MAXROW,nTab,
//STRIP001 												PAINT_GRID | PAINT_LEFT | PAINT_TOP | PAINT_SIZE );
//STRIP001 
//STRIP001 		aModificator.SetDocumentModified();
//STRIP001 
//STRIP001 		SelectionChanged();
//STRIP001 	}
//STRIP001 }

//
//			Consolidate
//

//STRIP001 void ScDBFunc::Consolidate( const ScConsolidateParam& rParam, BOOL bRecord )
//STRIP001 {
//STRIP001 	ScDocShell* pDocShell = GetViewData()->GetDocShell();
//STRIP001 	pDocShell->DoConsolidate( rParam, bRecord );
//STRIP001 	SetTabNo( rParam.nTab, TRUE );
//STRIP001 }

//
//			Pivot
//

//STRIP001 String lcl_MakePivotTabName( const String& rPrefix, USHORT nNumber )
//STRIP001 {
//STRIP001 	String aName = rPrefix;
//STRIP001 	aName += String::CreateFromInt32( nNumber );
//STRIP001 	return aName;
//STRIP001 }

//STRIP001 void ScDBFunc::MakePivotTable( const ScDPSaveData& rData, const ScRange& rDest, BOOL bNewTable,
//STRIP001 								const ScDPObject& rSource, BOOL bApi )
//STRIP001 {
//STRIP001 	//	#70096# error message if no fields are set
//STRIP001 	//	this must be removed when drag&drop of fields from a toolbox is available
//STRIP001 
//STRIP001 	if ( rData.IsEmpty() && !bApi )
//STRIP001 	{
//STRIP001 		ErrorMessage(STR_PIVOT_NODATA);
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScDocShell* pDocSh	= GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc 	= GetViewData()->GetDocument();
//STRIP001 	BOOL bUndo(pDoc->IsUndoEnabled());
//STRIP001 
//STRIP001 	ScRange aDestRange = rDest;
//STRIP001 	if ( bNewTable )
//STRIP001 	{
//STRIP001 		USHORT nSrcTab = GetViewData()->GetTabNo();
//STRIP001 
//STRIP001 		String aName( ScGlobal::GetRscString(STR_PIVOT_TABLE) );
//STRIP001 		String aStr;
//STRIP001 
//STRIP001 		pDoc->GetName( nSrcTab, aStr );
//STRIP001 		aName += '_';
//STRIP001 		aName += aStr;
//STRIP001 		aName += '_';
//STRIP001 
//STRIP001 		USHORT nNewTab = nSrcTab+1;
//STRIP001 
//STRIP001 		USHORT i=1;
//STRIP001 		while ( !pDoc->InsertTab( nNewTab, lcl_MakePivotTabName( aName, i ) ) && i <= MAXTAB )
//STRIP001 			i++;
//STRIP001 
//STRIP001 		BOOL bAppend = ( nNewTab+1 == pDoc->GetTableCount() );
//STRIP001 		if (bUndo)
//STRIP001 		{
//STRIP001 			pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 						new ScUndoInsertTab( pDocSh, nNewTab, bAppend, lcl_MakePivotTabName( aName, i ) ));
//STRIP001 		}
//STRIP001 
//STRIP001 		GetViewData()->InsertTab( nNewTab );
//STRIP001 		SetTabNo( nNewTab, TRUE );
//STRIP001 
//STRIP001 		aDestRange = ScRange( 0, 0, nNewTab );
//STRIP001 	}
//STRIP001 
//STRIP001 	ScDPObject* pDPObj = pDoc->GetDPAtCursor(
//STRIP001 							aDestRange.aStart.Col(), aDestRange.aStart.Row(), aDestRange.aStart.Tab() );
//STRIP001 
//STRIP001 	ScDPObject aObj( rSource );
//STRIP001 	aObj.SetOutRange( aDestRange );
//STRIP001 	aObj.SetSaveData( rData );
//STRIP001 
//STRIP001 	ScDBDocFunc aFunc( *pDocSh );
//STRIP001 	aFunc.DataPilotUpdate( pDPObj, &aObj, TRUE, FALSE );
//STRIP001 
//STRIP001 	CursorPosChanged();		// shells may be switched
//STRIP001 
//STRIP001 	if ( bNewTable )
//STRIP001 	{
//STRIP001 		pDocSh->PostPaintExtras();
//STRIP001 		SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_TABLES_CHANGED ) );
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScDBFunc::DeletePivotTable()
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh	  = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc	  = pDocSh->GetDocument();
//STRIP001 	ScDPObject*	pDPObj    = pDoc->GetDPAtCursor( GetViewData()->GetCurX(),
//STRIP001 												  GetViewData()->GetCurY(),
//STRIP001 												  GetViewData()->GetTabNo() );
//STRIP001 	if ( pDPObj )
//STRIP001 	{
//STRIP001 		ScDBDocFunc aFunc( *pDocSh );
//STRIP001 		aFunc.DataPilotUpdate( pDPObj, NULL, TRUE, FALSE );
//STRIP001 		CursorPosChanged();		// shells may be switched
//STRIP001 	}
//STRIP001 	else
//STRIP001 		ErrorMessage(STR_PIVOT_NOTFOUND);
//STRIP001 }

//STRIP001 void ScDBFunc::RecalcPivotTable()
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh  = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc	= GetViewData()->GetDocument();
//STRIP001 
//STRIP001 	//	old pivot not used any more
//STRIP001 
//STRIP001 	ScDPObject*	pDPObj	= pDoc->GetDPAtCursor( GetViewData()->GetCurX(),
//STRIP001 												  GetViewData()->GetCurY(),
//STRIP001 												  GetViewData()->GetTabNo() );
//STRIP001 	if ( pDPObj )
//STRIP001 	{
//STRIP001 		ScDBDocFunc aFunc( *pDocSh );
//STRIP001 		aFunc.DataPilotUpdate( pDPObj, pDPObj, TRUE, FALSE );
//STRIP001 		CursorPosChanged();		// shells may be switched
//STRIP001 	}
//STRIP001 	else
//STRIP001 		ErrorMessage(STR_PIVOT_NOTFOUND);
//STRIP001 }


//
//			DB-Operationen (Sortieren, Filtern, Teilergebnisse) wiederholen
//

//STRIP001 void ScDBFunc::RepeatDB( BOOL bRecord )
//STRIP001 {
//STRIP001 	USHORT nCurX = GetViewData()->GetCurX();
//STRIP001 	USHORT nCurY = GetViewData()->GetCurY();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 	ScDBData* pDBData = GetDBData();
//STRIP001 	if (bRecord && !pDoc->IsUndoEnabled())
//STRIP001 		bRecord = FALSE;
//STRIP001 
//STRIP001 	ScQueryParam aQueryParam;
//STRIP001 	pDBData->GetQueryParam( aQueryParam );
//STRIP001 	BOOL bQuery = aQueryParam.GetEntry(0).bDoQuery;
//STRIP001 
//STRIP001 	ScSortParam aSortParam;
//STRIP001 	pDBData->GetSortParam( aSortParam );
//STRIP001 	BOOL bSort = aSortParam.bDoSort[0];
//STRIP001 
//STRIP001 	ScSubTotalParam aSubTotalParam;
//STRIP001 	pDBData->GetSubTotalParam( aSubTotalParam );
//STRIP001 	BOOL bSubTotal = aSubTotalParam.bGroupActive[0] && !aSubTotalParam.bRemoveOnly;
//STRIP001 
//STRIP001 	if ( bQuery || bSort || bSubTotal )
//STRIP001 	{
//STRIP001 		BOOL bQuerySize = FALSE;
//STRIP001 		ScRange aOldQuery;
//STRIP001 		ScRange aNewQuery;
//STRIP001 		if (bQuery && !aQueryParam.bInplace)
//STRIP001 		{
//STRIP001 			ScDBData* pDest = pDoc->GetDBAtCursor( aQueryParam.nDestCol, aQueryParam.nDestRow,
//STRIP001 													aQueryParam.nDestTab, TRUE );
//STRIP001 			if (pDest && pDest->IsDoSize())
//STRIP001 			{
//STRIP001 				pDest->GetArea( aOldQuery );
//STRIP001 				bQuerySize = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT nDummy;
//STRIP001 		USHORT nStartCol;
//STRIP001 		USHORT nStartRow;
//STRIP001 		USHORT nEndCol;
//STRIP001 		USHORT nEndRow;
//STRIP001 		pDBData->GetArea( nDummy, nStartCol, nStartRow, nEndCol, nEndRow );
//STRIP001 
//STRIP001 		//!		Undo nur benoetigte Daten ?
//STRIP001 
//STRIP001 		ScDocument* pUndoDoc = NULL;
//STRIP001 		ScOutlineTable* pUndoTab = NULL;
//STRIP001 		ScRangeName* pUndoRange = NULL;
//STRIP001 		ScDBCollection* pUndoDB = NULL;
//STRIP001 
//STRIP001 		if (bRecord)
//STRIP001 		{
//STRIP001 			USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 			pUndoDoc = new ScDocument( SCDOCMODE_UNDO );
//STRIP001 			ScOutlineTable* pTable = pDoc->GetOutlineTable( nTab );
//STRIP001 			if (pTable)
//STRIP001 			{
//STRIP001 				pUndoTab = new ScOutlineTable( *pTable );
//STRIP001 
//STRIP001 				USHORT nOutStartCol;							// Zeilen/Spaltenstatus
//STRIP001 				USHORT nOutStartRow;
//STRIP001 				USHORT nOutEndCol;
//STRIP001 				USHORT nOutEndRow;
//STRIP001 				pTable->GetColArray()->GetRange( nOutStartCol, nOutEndCol );
//STRIP001 				pTable->GetRowArray()->GetRange( nOutStartRow, nOutEndRow );
//STRIP001 
//STRIP001 				pUndoDoc->InitUndo( pDoc, nTab, nTab, TRUE, TRUE );
//STRIP001 				pDoc->CopyToDocument( nOutStartCol, 0, nTab, nOutEndCol, MAXROW, nTab, IDF_NONE, FALSE, pUndoDoc );
//STRIP001 				pDoc->CopyToDocument( 0, nOutStartRow, nTab, MAXCOL, nOutEndRow, nTab, IDF_NONE, FALSE, pUndoDoc );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pUndoDoc->InitUndo( pDoc, nTab, nTab, FALSE, TRUE );
//STRIP001 
//STRIP001 			//	Datenbereich sichern - incl. Filter-Ergebnis
//STRIP001 			pDoc->CopyToDocument( 0,nStartRow,nTab, MAXCOL,nEndRow,nTab, IDF_ALL, FALSE, pUndoDoc );
//STRIP001 
//STRIP001 			//	alle Formeln wegen Referenzen
//STRIP001 			pDoc->CopyToDocument( 0,0,0, MAXCOL,MAXROW,nTabCount-1, IDF_FORMULA, FALSE, pUndoDoc );
//STRIP001 
//STRIP001 			//	DB- und andere Bereiche
//STRIP001 			ScRangeName* pDocRange = pDoc->GetRangeName();
//STRIP001 			if (pDocRange->GetCount())
//STRIP001 				pUndoRange = new ScRangeName( *pDocRange );
//STRIP001 			ScDBCollection* pDocDB = pDoc->GetDBCollection();
//STRIP001 			if (pDocDB->GetCount())
//STRIP001 				pUndoDB = new ScDBCollection( *pDocDB );
//STRIP001 		}
//STRIP001 
//STRIP001 		if (bSort && bSubTotal)
//STRIP001 		{
//STRIP001 			//	Sortieren ohne SubTotals
//STRIP001 
//STRIP001 			aSubTotalParam.bRemoveOnly = TRUE;		// wird unten wieder zurueckgesetzt
//STRIP001 			DoSubTotals( aSubTotalParam, FALSE );
//STRIP001 		}
//STRIP001 
//STRIP001 		if (bSort)
//STRIP001 		{
//STRIP001 			pDBData->GetSortParam( aSortParam );			// Bereich kann sich geaendert haben
//STRIP001 			Sort( aSortParam, FALSE, FALSE);
//STRIP001 		}
//STRIP001 		if (bQuery)
//STRIP001 		{
//STRIP001 			pDBData->GetQueryParam( aQueryParam );			// Bereich kann sich geaendert haben
//STRIP001 			ScRange aAdvSource;
//STRIP001 			if (pDBData->GetAdvancedQuerySource(aAdvSource))
//STRIP001 				Query( aQueryParam, &aAdvSource, FALSE );
//STRIP001 			else
//STRIP001 				Query( aQueryParam, NULL, FALSE );
//STRIP001 
//STRIP001 			//	bei nicht-inplace kann die Tabelle umgestellt worden sein
//STRIP001 			if ( !aQueryParam.bInplace && aQueryParam.nDestTab != nTab )
//STRIP001 				SetTabNo( nTab );
//STRIP001 		}
//STRIP001 		if (bSubTotal)
//STRIP001 		{
//STRIP001 			pDBData->GetSubTotalParam( aSubTotalParam );	// Bereich kann sich geaendert haben
//STRIP001 			aSubTotalParam.bRemoveOnly = FALSE;
//STRIP001 			DoSubTotals( aSubTotalParam, FALSE );
//STRIP001 		}
//STRIP001 
//STRIP001 		if (bRecord)
//STRIP001 		{
//STRIP001 			USHORT nDummy;
//STRIP001 			USHORT nNewEndRow;
//STRIP001 			pDBData->GetArea( nDummy, nDummy,nDummy, nDummy,nNewEndRow );
//STRIP001 
//STRIP001 			const ScRange* pOld = NULL;
//STRIP001 			const ScRange* pNew = NULL;
//STRIP001 			if (bQuerySize)
//STRIP001 			{
//STRIP001 				ScDBData* pDest = pDoc->GetDBAtCursor( aQueryParam.nDestCol, aQueryParam.nDestRow,
//STRIP001 														aQueryParam.nDestTab, TRUE );
//STRIP001 				if (pDest)
//STRIP001 				{
//STRIP001 					pDest->GetArea( aNewQuery );
//STRIP001 					pOld = &aOldQuery;
//STRIP001 					pNew = &aNewQuery;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			GetViewData()->GetDocShell()->GetUndoManager()->AddUndoAction(
//STRIP001 				new ScUndoRepeatDB( GetViewData()->GetDocShell(), nTab,
//STRIP001 										nStartCol, nStartRow, nEndCol, nEndRow,
//STRIP001 										nNewEndRow,
//STRIP001 										nCurX, nCurY,
//STRIP001 										pUndoDoc, pUndoTab,
//STRIP001 										pUndoRange, pUndoDB,
//STRIP001 										pOld, pNew ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		GetViewData()->GetDocShell()->PostPaint( 0,0,nTab, MAXCOL,MAXROW,nTab,
//STRIP001 													PAINT_GRID | PAINT_LEFT | PAINT_TOP | PAINT_SIZE );
//STRIP001 	}
//STRIP001 	else		// "Keine Operationen auszufuehren"
//STRIP001 		ErrorMessage(STR_MSSG_REPEATDB_0);
//STRIP001 }




}
