/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_dbfunc.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:22:46 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

// auto strip #include "scitems.hxx"
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #include <vcl/msgbox.hxx>

// auto strip #include <com/sun/star/sdbc/XResultSet.hpp>

#include "dbfunc.hxx"
#include "docsh.hxx"
// auto strip #include "attrib.hxx"
#include "bf_sc.hrc"
// auto strip #include "undodat.hxx"
#include "dbcolect.hxx"
#include "globstr.hrc"
// auto strip #include "global.hxx"
// auto strip #include "dbdocfun.hxx"
// auto strip #include "editable.hxx"
namespace binfilter {

//==================================================================

/*N*/ ScDBFunc::ScDBFunc( Window* pParent, ScDocShell& rDocSh, ScTabViewShell* pViewShell ) :
/*N*/ 	ScViewFunc( pParent, rDocSh, pViewShell )
/*N*/ {
/*N*/ }

/*N*/ ScDBFunc::ScDBFunc( Window* pParent, const ScDBFunc& rDBFunc, ScTabViewShell* pViewShell ) :
/*N*/ 	ScViewFunc( pParent, rDBFunc, pViewShell )
/*N*/ {
/*N*/ }

/*N*/ ScDBFunc::~ScDBFunc()
/*N*/ {
/*N*/ }

//
//		Hilfsfunktionen
//

//STRIP001 void ScDBFunc::GotoDBArea( const String& rDBName )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 	ScDBCollection* pDBCol = pDoc->GetDBCollection();
//STRIP001 
//STRIP001 	USHORT nFoundAt = 0;
//STRIP001 	if ( pDBCol->SearchName( rDBName, nFoundAt ) )
//STRIP001 	{
//STRIP001 		ScDBData* pData = (*pDBCol)[nFoundAt];
//STRIP001 		DBG_ASSERT( pData, "GotoDBArea: Datenbankbereich nicht gefunden!" );
//STRIP001 
//STRIP001 		if ( pData )
//STRIP001 		{
//STRIP001 			USHORT nTab = 0;
//STRIP001 			USHORT nStartCol = 0;
//STRIP001 			USHORT nStartRow = 0;
//STRIP001 			USHORT nEndCol = 0;
//STRIP001 			USHORT nEndRow = 0;
//STRIP001 
//STRIP001 			pData->GetArea( nTab, nStartCol, nStartRow, nEndCol, nEndRow );
//STRIP001 			SetTabNo( nTab );
//STRIP001 
//STRIP001 			MoveCursorAbs( nStartCol, nStartRow, ScFollowMode( SC_FOLLOW_JUMP ),
//STRIP001 							   FALSE, FALSE );	// bShift,bControl
//STRIP001 			DoneBlockMode();
//STRIP001 			InitBlockMode( nStartCol, nStartRow, nTab );
//STRIP001 			MarkCursor( nEndCol, nEndRow, nTab );
//STRIP001 			SelectionChanged();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//	aktuellen Datenbereich fuer Sortieren / Filtern suchen

/*N*/ ScDBData* ScDBFunc::GetDBData( BOOL bMark, ScGetDBMode eMode )
/*N*/ {
/*N*/ 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
/*N*/ 	ScDBData* pData = NULL;
/*N*/ 	ScRange aRange;
/*N*/ 	if ( GetViewData()->GetSimpleArea(aRange) )
/*N*/ 		pData = pDocSh->GetDBData( aRange, eMode, FALSE );
/*N*/ 	else if ( eMode != SC_DB_OLD )
/*N*/ 		pData = pDocSh->GetDBData(
/*N*/ 					ScRange( GetViewData()->GetCurX(), GetViewData()->GetCurY(),
/*N*/ 							 GetViewData()->GetTabNo() ),
/*N*/ 					eMode, FALSE );
/*N*/ 
/*N*/ 	if ( pData && bMark )
/*N*/ 	{
/*N*/ 		ScRange aFound;
/*N*/ 		pData->GetArea(aFound);
/*N*/ 		MarkRange( aFound, FALSE );
/*N*/ 	}
/*N*/ 	return pData;
/*N*/ }

//	Datenbankbereiche aendern (Dialog)

//STRIP001 void ScDBFunc::NotifyCloseDbNameDlg( const ScDBCollection& rNewColl, const List& rDelAreaList )
//STRIP001 {
//STRIP001 
//STRIP001 	ScDocShell* pDocShell = GetViewData()->GetDocShell();
//STRIP001 	ScDocShellModificator aModificator( *pDocShell );
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScDBCollection* pOldColl = pDoc->GetDBCollection();
//STRIP001 	ScDBCollection* pUndoColl = NULL;
//STRIP001 	ScDBCollection* pRedoColl = NULL;
//STRIP001 	const BOOL bRecord (pDoc->IsUndoEnabled());
//STRIP001 
//STRIP001 	long nDelCount = rDelAreaList.Count();
//STRIP001 	for (long nDelPos=0; nDelPos<nDelCount; nDelPos++)
//STRIP001 	{
//STRIP001 		ScRange* pEntry = (ScRange*) rDelAreaList.GetObject(nDelPos);
//STRIP001 
//STRIP001 		if ( pEntry )
//STRIP001 		{
//STRIP001 			ScAddress& rStart = pEntry->aStart;
//STRIP001 			ScAddress& rEnd   = pEntry->aEnd;
//STRIP001 			pDocShell->DBAreaDeleted( rStart.Tab(),
//STRIP001 									   rStart.Col(), rStart.Row(),
//STRIP001 									   rEnd.Col(),   rEnd.Row() );
//STRIP001 
//STRIP001 			//	Targets am SBA abmelden nicht mehr noetig
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bRecord)
//STRIP001 		pUndoColl = new ScDBCollection( *pOldColl );
//STRIP001 
//STRIP001 	//	neue Targets am SBA anmelden nicht mehr noetig
//STRIP001 
//STRIP001 	pDoc->CompileDBFormula( TRUE );		// CreateFormulaString
//STRIP001 	pDoc->SetDBCollection( new ScDBCollection( rNewColl ) );
//STRIP001 	pDoc->CompileDBFormula( FALSE );	// CompileFormulaString
//STRIP001 	pOldColl = NULL;
//STRIP001 	pDocShell->PostPaint( 0,0,0, MAXCOL,MAXROW,MAXTAB, PAINT_GRID );
//STRIP001 	aModificator.SetDocumentModified();
//STRIP001 	SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_DBAREAS_CHANGED ) );
//STRIP001 
//STRIP001 	if (bRecord)
//STRIP001 	{
//STRIP001 		pRedoColl = new ScDBCollection( rNewColl );
//STRIP001 		pDocShell->GetUndoManager()->AddUndoAction(
//STRIP001 			new ScUndoDBData( pDocShell, pUndoColl, pRedoColl ) );
//STRIP001 	}
//STRIP001 }

//
//		wirkliche Funktionen
//

// Sortieren

//STRIP001 void ScDBFunc::UISort( const ScSortParam& rSortParam, BOOL bRecord )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	ScDBData* pDBData = pDoc->GetDBAtArea( nTab, rSortParam.nCol1, rSortParam.nRow1,
//STRIP001 													rSortParam.nCol2, rSortParam.nRow2 );
//STRIP001 	if (!pDBData)
//STRIP001 	{
//STRIP001 		DBG_ERROR( "Sort: keine DBData" );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScSubTotalParam aSubTotalParam;
//STRIP001 	pDBData->GetSubTotalParam( aSubTotalParam );
//STRIP001 	if (aSubTotalParam.bGroupActive[0] && !aSubTotalParam.bRemoveOnly)
//STRIP001 	{
//STRIP001 		//	Subtotals wiederholen, mit neuer Sortierung
//STRIP001 
//STRIP001 		ScSubTotalParam aSubTotalParam;
//STRIP001 		pDBData->GetSubTotalParam( aSubTotalParam );
//STRIP001 		DoSubTotals( aSubTotalParam, bRecord, &rSortParam );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		Sort( rSortParam, bRecord );		// nur sortieren
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScDBFunc::Sort( const ScSortParam& rSortParam, BOOL bRecord, BOOL bPaint )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	ScDBDocFunc aDBDocFunc( *pDocSh );
//STRIP001 	BOOL bSuccess = aDBDocFunc.Sort( nTab, rSortParam, bRecord, bPaint, FALSE );
//STRIP001 	if ( bSuccess && !rSortParam.bInplace )
//STRIP001 	{
//STRIP001 		//	Ziel markieren
//STRIP001 		ScRange aDestRange( rSortParam.nDestCol, rSortParam.nDestRow, rSortParam.nDestTab,
//STRIP001 							rSortParam.nDestCol + rSortParam.nCol2 - rSortParam.nCol1,
//STRIP001 							rSortParam.nDestRow + rSortParam.nRow2 - rSortParam.nRow1,
//STRIP001 							rSortParam.nDestTab );
//STRIP001 		MarkRange( aDestRange );
//STRIP001 	}
//STRIP001 }

//	Filtern

//STRIP001 void ScDBFunc::Query( const ScQueryParam& rQueryParam, const ScRange* pAdvSource, BOOL bRecord )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	ScDBDocFunc aDBDocFunc( *pDocSh );
//STRIP001 	BOOL bSuccess = aDBDocFunc.Query( nTab, rQueryParam, pAdvSource, bRecord, FALSE );
//STRIP001 
//STRIP001 	if (bSuccess)
//STRIP001 	{
//STRIP001 		BOOL bCopy = !rQueryParam.bInplace;
//STRIP001 		if (bCopy)
//STRIP001 		{
//STRIP001 			//	Zielbereich markieren (DB-Bereich wurde ggf. angelegt)
//STRIP001 			ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 			ScDBData* pDestData = pDoc->GetDBAtCursor(
//STRIP001 											rQueryParam.nDestCol, rQueryParam.nDestRow,
//STRIP001 											rQueryParam.nDestTab, TRUE );
//STRIP001 			if (pDestData)
//STRIP001 			{
//STRIP001 				ScRange aDestRange;
//STRIP001 				pDestData->GetArea(aDestRange);
//STRIP001 				MarkRange( aDestRange );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if (!bCopy)
//STRIP001 			UpdateScrollBars();
//STRIP001 
//STRIP001 		GetViewData()->GetBindings().Invalidate( SID_UNFILTER );
//STRIP001 	}
//STRIP001 }

//	Autofilter-Knoepfe ein-/ausblenden

//STRIP001 void ScDBFunc::ToggleAutoFilter()
//STRIP001 {
//STRIP001 	ScDocShellModificator aModificator( *(GetViewData()->GetDocShell()) );
//STRIP001 
//STRIP001 	ScQueryParam	aParam;
//STRIP001 	ScDocument*		pDoc	= GetViewData()->GetDocument();
//STRIP001 	ScDBData*		pDBData = GetDBData( FALSE );
//STRIP001 
//STRIP001 	pDBData->SetByRow( TRUE );				//! Undo, vorher abfragen ??
//STRIP001 	pDBData->GetQueryParam( aParam );
//STRIP001 
//STRIP001 
//STRIP001 	USHORT  nCol;
//STRIP001 	USHORT  nRow = aParam.nRow1;
//STRIP001 	USHORT  nTab = GetViewData()->GetTabNo();
//STRIP001 	INT16   nFlag;
//STRIP001 	BOOL	bHasAuto = TRUE;
//STRIP001 	BOOL	bHeader  = pDBData->HasHeader();
//STRIP001 	BOOL	bPaint   = FALSE;
//STRIP001 
//STRIP001 	//!		stattdessen aus DB-Bereich abfragen?
//STRIP001 
//STRIP001 	for (nCol=aParam.nCol1; nCol<=aParam.nCol2 && bHasAuto; nCol++)
//STRIP001 	{
//STRIP001 		nFlag = ((ScMergeFlagAttr*) pDoc->
//STRIP001 				GetAttr( nCol, nRow, nTab, ATTR_MERGE_FLAG ))->GetValue();
//STRIP001 
//STRIP001 		if ( (nFlag & SC_MF_AUTO) == 0 )
//STRIP001 			bHasAuto = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bHasAuto)								// aufheben
//STRIP001 	{
//STRIP001 		//	Filterknoepfe ausblenden
//STRIP001 
//STRIP001 		for (nCol=aParam.nCol1; nCol<=aParam.nCol2; nCol++)
//STRIP001 		{
//STRIP001 			nFlag = ((ScMergeFlagAttr*) pDoc->
//STRIP001 					GetAttr( nCol, nRow, nTab, ATTR_MERGE_FLAG ))->GetValue();
//STRIP001 			pDoc->ApplyAttr( nCol, nRow, nTab, ScMergeFlagAttr( nFlag & ~SC_MF_AUTO ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		pDBData->SetAutoFilter(FALSE);
//STRIP001 
//STRIP001 		//	Filter aufheben (incl. Paint / Undo)
//STRIP001 
//STRIP001 		USHORT nEC = aParam.GetEntryCount();
//STRIP001 		for (USHORT i=0; i<nEC; i++)
//STRIP001 			aParam.GetEntry(i).bDoQuery = FALSE;
//STRIP001 		aParam.bDuplicate = TRUE;
//STRIP001 		Query( aParam, NULL, TRUE );
//STRIP001 
//STRIP001 		bPaint = TRUE;
//STRIP001 	}
//STRIP001 	else									// Filterknoepfe einblenden
//STRIP001 	{
//STRIP001 		if ( !pDoc->IsBlockEmpty( nTab,
//STRIP001 								  aParam.nCol1, aParam.nRow1,
//STRIP001 								  aParam.nCol2, aParam.nRow2 ) )
//STRIP001 		{
//STRIP001 			if (!bHeader)
//STRIP001 			{
//STRIP001 				if ( MessBox( GetViewData()->GetDialogParent(), WinBits(WB_YES_NO | WB_DEF_YES),
//STRIP001 						ScGlobal::GetRscString( STR_MSSG_DOSUBTOTALS_0 ),		// "StarCalc"
//STRIP001 						ScGlobal::GetRscString( STR_MSSG_MAKEAUTOFILTER_0 ) 	// Koepfe aus erster Zeile?
//STRIP001 					).Execute() == RET_YES )
//STRIP001 				{
//STRIP001 					pDBData->SetHeader( TRUE ); 	//! Undo ??
//STRIP001 					bHeader = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			pDBData->SetAutoFilter(TRUE);
//STRIP001 
//STRIP001 			for (nCol=aParam.nCol1; nCol<=aParam.nCol2; nCol++)
//STRIP001 			{
//STRIP001 				nFlag = ((ScMergeFlagAttr*) pDoc->
//STRIP001 						GetAttr( nCol, nRow, nTab, ATTR_MERGE_FLAG ))->GetValue();
//STRIP001 				pDoc->ApplyAttr( nCol, nRow, nTab, ScMergeFlagAttr( nFlag | SC_MF_AUTO ) );
//STRIP001 			}
//STRIP001 			GetViewData()->GetDocShell()->PostPaint( aParam.nCol1, nRow, nTab,
//STRIP001 													 aParam.nCol2, nRow, nTab,
//STRIP001 													 PAINT_GRID );
//STRIP001 			bPaint = TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			ErrorBox aErrorBox( GetViewData()->GetDialogParent(), WinBits( WB_OK | WB_DEF_OK ),
//STRIP001 								ScGlobal::GetRscString( STR_ERR_AUTOFILTER ) );
//STRIP001 			aErrorBox.Execute();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bPaint )
//STRIP001 	{
//STRIP001 		aModificator.SetDocumentModified();
//STRIP001 
//STRIP001 		SfxBindings& rBindings = GetViewData()->GetBindings();
//STRIP001 		rBindings.Invalidate( SID_AUTO_FILTER );
//STRIP001 		rBindings.Invalidate( SID_AUTOFILTER_HIDE );
//STRIP001 	}
//STRIP001 }

//		nur ausblenden, keine Daten veraendern

//STRIP001 void ScDBFunc::HideAutoFilter()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 
//STRIP001 	ScQueryParam aParam;
//STRIP001 	ScDBData* pDBData = GetDBData( FALSE );
//STRIP001 
//STRIP001 	USHORT nTab, nCol1, nRow1, nCol2, nRow2;
//STRIP001 	pDBData->GetArea(nTab, nCol1, nRow1, nCol2, nRow2);
//STRIP001 
//STRIP001 	for (USHORT nCol=nCol1; nCol<=nCol2; nCol++)
//STRIP001 	{
//STRIP001 		INT16 nFlag = ((ScMergeFlagAttr*) pDoc->
//STRIP001 								GetAttr( nCol, nRow1, nTab, ATTR_MERGE_FLAG ))->GetValue();
//STRIP001 		pDoc->ApplyAttr( nCol, nRow1, nTab, ScMergeFlagAttr( nFlag & ~SC_MF_AUTO ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	pDBData->SetAutoFilter(FALSE);
//STRIP001 
//STRIP001 	GetViewData()->GetDocShell()->PostPaint( nCol1,nRow1,nTab, nCol2,nRow1,nTab, PAINT_GRID );
//STRIP001 
//STRIP001 	SfxBindings& rBindings = GetViewData()->GetBindings();
//STRIP001 	rBindings.Invalidate( SID_AUTO_FILTER );
//STRIP001 	rBindings.Invalidate( SID_AUTOFILTER_HIDE );
//STRIP001 }

//		Re-Import

//STRIP001 BOOL ScDBFunc::ImportData( const ScImportParam& rParam, BOOL bRecord )
//STRIP001 {
//STRIP001 	BOOL bSuccess = FALSE;
//STRIP001 
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 	ScEditableTester aTester( pDoc, GetViewData()->GetTabNo(), rParam.nCol1,rParam.nRow1,
//STRIP001 															rParam.nCol2,rParam.nRow2 );
//STRIP001 	if ( !aTester.IsEditable() )
//STRIP001 	{
//STRIP001 		ErrorMessage(aTester.GetMessageId());
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScDBDocFunc aDBDocFunc( *GetViewData()->GetDocShell() );
//STRIP001     ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XResultSet > xResultSet;
//STRIP001 	return aDBDocFunc.DoImport( GetViewData()->GetTabNo(), rParam, xResultSet, NULL, bRecord );
//STRIP001 }



}
