/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_futext.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:20:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------

// auto strip #include <bf_svx/svddef.hxx>
// auto strip #include <bf_svx/svdoutl.hxx>
// auto strip #include <bf_svx/outlobj.hxx>

#ifndef _XDEF_HXX
#include <bf_svx/xdef.hxx>
#endif

// auto strip #include <bf_svx/sdtaaitm.hxx>
// auto strip #include <bf_svx/sdtacitm.hxx>
// auto strip #include <bf_svx/svdotext.hxx>
// auto strip #include <bf_svx/svdview.hxx>
// auto strip #include <bf_svx/unolingu.hxx>
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #include <bf_sfx2/viewfrm.hxx>
#include <bf_svx/svxids.hrc>

// auto strip #include "futext.hxx"
// auto strip #include "drwlayer.hxx"
#include "bf_sc.hrc"
// auto strip #include "tabvwsh.hxx"

// #98185# Create default drawing objects via keyboard
// auto strip #include "scresid.hxx"
namespace binfilter {

//	Maximal erlaubte Mausbewegung um noch Drag&Drop zu starten
//!	fusel,fuconstr,futext - zusammenfassen!
#define SC_MAXDRAGMOVE	3

//------------------------------------------------------------------

//STRIP001 void lcl_InvalidateAttribs( SfxBindings& rBindings )
//STRIP001 {
//STRIP001 	rBindings.Invalidate( SID_ATTR_CHAR_WEIGHT );
//STRIP001 	rBindings.Invalidate( SID_ATTR_CHAR_POSTURE );
//STRIP001 	rBindings.Invalidate( SID_ATTR_CHAR_UNDERLINE );
//STRIP001 	rBindings.Invalidate( SID_ULINE_VAL_NONE );
//STRIP001 	rBindings.Invalidate( SID_ULINE_VAL_SINGLE );
//STRIP001 	rBindings.Invalidate( SID_ULINE_VAL_DOUBLE );
//STRIP001 	rBindings.Invalidate( SID_ULINE_VAL_DOTTED );
//STRIP001 	rBindings.Invalidate( SID_ATTR_CHAR_COLOR );
//STRIP001 	rBindings.Invalidate( SID_ATTR_CHAR_FONT );
//STRIP001 	rBindings.Invalidate( SID_ATTR_CHAR_FONTHEIGHT );
//STRIP001 	rBindings.Invalidate( SID_ALIGNLEFT );
//STRIP001 	rBindings.Invalidate( SID_ALIGNCENTERHOR );
//STRIP001 	rBindings.Invalidate( SID_ALIGNRIGHT );
//STRIP001 	rBindings.Invalidate( SID_ALIGNBLOCK );
//STRIP001 	rBindings.Invalidate( SID_ATTR_PARA_LINESPACE_10 );
//STRIP001 	rBindings.Invalidate( SID_ATTR_PARA_LINESPACE_15 );
//STRIP001 	rBindings.Invalidate( SID_ATTR_PARA_LINESPACE_20 );
//STRIP001 	rBindings.Invalidate( SID_SET_SUPER_SCRIPT );
//STRIP001 	rBindings.Invalidate( SID_SET_SUB_SCRIPT );
//STRIP001 	rBindings.Invalidate( SID_HYPERLINK_GETLINK );
//STRIP001 	rBindings.Invalidate( SID_TEXTDIRECTION_LEFT_TO_RIGHT );
//STRIP001 	rBindings.Invalidate( SID_TEXTDIRECTION_TOP_TO_BOTTOM );
//STRIP001     rBindings.Invalidate( SID_ATTR_PARA_LEFT_TO_RIGHT );
//STRIP001     rBindings.Invalidate( SID_ATTR_PARA_RIGHT_TO_LEFT );
//STRIP001 }

//STRIP001 void lcl_UpdateHyphenator( Outliner& rOutliner, SdrObject* pObj )
//STRIP001 {
//STRIP001 	// use hyphenator only if hyphenation attribute is set
//STRIP001 	if ( pObj && ((const SfxBoolItem&)pObj->GetItemSet().Get(EE_PARA_HYPHENATE)).GetValue() ) {
//STRIP001             ::com::sun::star::uno::Reference< ::com::sun::star::linguistic2::XHyphenator> xHyphenator( LinguMgr::GetHyphenator() );
//STRIP001     		rOutliner.SetHyphenator( xHyphenator );
//STRIP001     }
//STRIP001 }

/*************************************************************************
|*
|* Basisklasse fuer Textfunktionen
|*
\************************************************************************/

//STRIP001 FuText::FuText(ScTabViewShell* pViewSh, Window* pWin, SdrView* pView,
//STRIP001 				   SdrModel* pDoc, SfxRequest& rReq) :
//STRIP001 	FuConstruct(pViewSh, pWin, pView, pDoc, rReq),
//STRIP001 	pTextObj(NULL)
//STRIP001 {
//STRIP001 }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

//STRIP001 FuText::~FuText()
//STRIP001 {
//STRIP001 //	StopEditMode();					// in Deactivate !
//STRIP001 }

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/

//STRIP001 BOOL __EXPORT FuText::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	// #95491# remember button state for creation of own MouseEvents
//STRIP001 	SetMouseButtonCode(rMEvt.GetButtons());
//STRIP001 
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	if ( pView->MouseButtonDown(rMEvt, pWindow) )
//STRIP001 		return (TRUE);				   // Event von der SdrView ausgewertet
//STRIP001 
//STRIP001 	if ( pView->IsTextEdit() )
//STRIP001 	{
//STRIP001 		StopEditMode();					   // Danebengeklickt, Ende mit Edit
//STRIP001 		pView->SetCreateMode();
//STRIP001 	}
//STRIP001 
//STRIP001 	aMDPos = pWindow->PixelToLogic( rMEvt.GetPosPixel() );
//STRIP001 
//STRIP001 	if ( rMEvt.IsLeft() )
//STRIP001 	{
//STRIP001 		SdrHdl* pHdl = pView->HitHandle(aMDPos, *pWindow);
//STRIP001 
//STRIP001 		ULONG nHdlNum = pView->GetHdlNum(pHdl);
//STRIP001 
//STRIP001 		if (pHdl != NULL)
//STRIP001 		{
//STRIP001 			if (pView->HasMarkablePoints() && pView->IsPointMarkable(*pHdl))
//STRIP001 			{
//STRIP001 				BOOL bPointMarked=pView->IsPointMarked(*pHdl);
//STRIP001 
//STRIP001 				if ( rMEvt.IsShift() )
//STRIP001 				{
//STRIP001 					if (!bPointMarked)
//STRIP001 					{
//STRIP001 						pView->MarkPoint(*pHdl);
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						pView->UnmarkPoint(*pHdl);
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if (!bPointMarked)
//STRIP001 					{
//STRIP001 						pView->UnmarkAllPoints();
//STRIP001 						pView->MarkPoint(*pHdl);
//STRIP001 					}
//STRIP001 				}
//STRIP001 				pHdl=pView->GetHdl(nHdlNum);
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		SdrObject* pObj;
//STRIP001 		SdrPageView* pPV;
//STRIP001 
//STRIP001 		if ( pHdl != NULL || pView->IsMarkedHit(aMDPos) )
//STRIP001 		{
//STRIP001 			if (pHdl == NULL &&
//STRIP001 //				pView->TakeTextEditObject(aMDPos, pObj, pPV) )
//STRIP001 				pView->PickObj(aMDPos, pObj, pPV, SDRSEARCH_PICKTEXTEDIT) )
//STRIP001 			{
//STRIP001 				SdrOutliner* pO = MakeOutliner();
//STRIP001 				lcl_UpdateHyphenator( *pO, pObj );
//STRIP001 
//STRIP001 				//	vertical flag:
//STRIP001 				//	deduced from slot ids only if text object has no content
//STRIP001 
//STRIP001 				USHORT nSlotID = aSfxRequest.GetSlot();
//STRIP001 				BOOL bVertical = ( nSlotID == SID_DRAW_TEXT_VERTICAL );
//STRIP001 				OutlinerParaObject* pOPO = pObj->GetOutlinerParaObject();
//STRIP001 				if ( pOPO )
//STRIP001 				{
//STRIP001 					if ( nSlotID == SID_DRAW_NOTEEDIT )
//STRIP001 						pOPO->SetVertical( FALSE );			// notes are always horizontal
//STRIP001 					else
//STRIP001 						bVertical = pOPO->IsVertical();		// content wins
//STRIP001 				}
//STRIP001 				pO->SetVertical( bVertical );
//STRIP001 
//STRIP001 				//!??	ohne uebergebenen Outliner stimmen die Defaults nicht ???!?
//STRIP001 				if ( pView->BegTextEdit(pObj, pPV, pWindow, (FASTBOOL)TRUE, pO) )
//STRIP001 				{
//STRIP001 					//	EditEngine-UndoManager anmelden
//STRIP001 					pViewShell->SetDrawTextUndo( &pO->GetUndoManager() );
//STRIP001 
//STRIP001 					OutlinerView* pOLV = pView->GetTextEditOutlinerView();
//STRIP001 					if ( pOLV->MouseButtonDown(rMEvt) )
//STRIP001 						return (TRUE); // Event an den Outliner
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aDragTimer.Start();
//STRIP001 				pView->BegDragObj(aMDPos, (OutputDevice*) NULL, pHdl);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			BOOL bMacro = FALSE;
//STRIP001 
//STRIP001 //			if (bMacro && pView->TakeMacroObject(aMDPos,pObj,pPV))
//STRIP001 			if (bMacro && pView->PickObj(aMDPos, pObj, pPV, SDRSEARCH_PICKMACRO) )
//STRIP001 
//STRIP001 			{
//STRIP001 				pView->BegMacroObj(aMDPos,pObj,pPV,pWindow);
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if (pView->IsEditMode())
//STRIP001 				{
//STRIP001 					BOOL bPointMode=pView->HasMarkablePoints();
//STRIP001 
//STRIP001 					if (!rMEvt.IsShift())
//STRIP001 					{
//STRIP001 						if (bPointMode)
//STRIP001 						{
//STRIP001 							pView->UnmarkAllPoints();
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							pView->UnmarkAll();
//STRIP001 						}
//STRIP001 
//STRIP001 						pView->SetDragMode(SDRDRAG_MOVE);
//STRIP001 						SfxBindings& rBindings = pViewShell->GetViewFrame()->GetBindings();
//STRIP001 						rBindings.Invalidate( SID_OBJECT_ROTATE );
//STRIP001 						rBindings.Invalidate( SID_OBJECT_MIRROR );
//STRIP001 						pHdl=pView->GetHdl(nHdlNum);
//STRIP001 					}
//STRIP001 
//STRIP001 					if ( pView->MarkObj(aMDPos, -2, FALSE, rMEvt.IsMod1()) )
//STRIP001 					{
//STRIP001 						aDragTimer.Start();
//STRIP001 
//STRIP001 						pHdl=pView->HitHandle(aMDPos,*pWindow);
//STRIP001 
//STRIP001 						if (pHdl!=NULL)
//STRIP001 						{
//STRIP001 							pView->MarkPoint(*pHdl);
//STRIP001 							pHdl=pView->GetHdl(nHdlNum);
//STRIP001 						}
//STRIP001 
//STRIP001 						pView->BegDragObj(aMDPos, (OutputDevice*) NULL, pHdl);
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						if (bPointMode)
//STRIP001 						{
//STRIP001 							pView->BegMarkPoints(aMDPos, (OutputDevice*) NULL);
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							pView->BegMarkObj(aMDPos, (OutputDevice*) NULL);
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else if (aSfxRequest.GetSlot() == SID_DRAW_NOTEEDIT )
//STRIP001 				{
//STRIP001 					//	Notizen editieren -> keine neuen Textobjekte erzeugen,
//STRIP001 					//	stattdessen Textmodus verlassen
//STRIP001 
//STRIP001 					pViewShell->GetViewData()->GetDispatcher().
//STRIP001 						Execute(aSfxRequest.GetSlot(), SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD);
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					/**********************************************************
//STRIP001 					* Objekt erzeugen
//STRIP001 					**********************************************************/
//STRIP001 					pView->BegCreateObj(aMDPos, (OutputDevice*) NULL);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!bIsInDragMode)
//STRIP001 	{
//STRIP001 		pWindow->CaptureMouse();
//STRIP001 //		ForcePointer(&rMEvt);
//STRIP001 		lcl_InvalidateAttribs( pViewShell->GetViewFrame()->GetBindings() );
//STRIP001 	}
//STRIP001 
//STRIP001 	pViewShell->SetActivePointer(pView->GetPreferedPointer(
//STRIP001 					pWindow->PixelToLogic(rMEvt.GetPosPixel()), pWindow ));
//STRIP001 
//STRIP001 //	return (bReturn);
//STRIP001 	return TRUE;
//STRIP001 }

/*************************************************************************
|*
|* MouseMove-event
|*
\************************************************************************/

//STRIP001 BOOL __EXPORT FuText::MouseMove(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 //	pViewShell->SetActivePointer(aNewPointer);
//STRIP001 
//STRIP001 	pViewShell->SetActivePointer(pView->GetPreferedPointer(
//STRIP001 					pWindow->PixelToLogic(rMEvt.GetPosPixel()), pWindow ));
//STRIP001 
//STRIP001 	if (aDragTimer.IsActive() )
//STRIP001 	{
//STRIP001 		Point aOldPixel = pWindow->LogicToPixel( aMDPos );
//STRIP001 		Point aNewPixel = rMEvt.GetPosPixel();
//STRIP001 		if ( Abs( aOldPixel.X() - aNewPixel.X() ) > SC_MAXDRAGMOVE ||
//STRIP001 			 Abs( aOldPixel.Y() - aNewPixel.Y() ) > SC_MAXDRAGMOVE )
//STRIP001 			aDragTimer.Stop();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pView->MouseMove(rMEvt, pWindow) )
//STRIP001 		return (TRUE); // Event von der SdrView ausgewertet
//STRIP001 
//STRIP001 	if ( pView->IsAction() )
//STRIP001 	{
//STRIP001 /*		aNewPointer = Pointer(POINTER_TEXT);
//STRIP001 		pViewShell->SetActivePointer(aNewPointer);
//STRIP001 */
//STRIP001 		Point aPix(rMEvt.GetPosPixel());
//STRIP001 		Point aPnt(pWindow->PixelToLogic(aPix));
//STRIP001 
//STRIP001 		ForceScroll(aPix);
//STRIP001 		pView->MovAction(aPnt);
//STRIP001 	}
//STRIP001 
//STRIP001 //	ForcePointer(&rMEvt);
//STRIP001 
//STRIP001 	return (bReturn);
//STRIP001 }

/*************************************************************************
|*
|* MouseButtonUp-event
|*
\************************************************************************/

//STRIP001 BOOL __EXPORT FuText::MouseButtonUp(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	// #95491# remember button state for creation of own MouseEvents
//STRIP001 	SetMouseButtonCode(rMEvt.GetButtons());
//STRIP001 
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	if (aDragTimer.IsActive() )
//STRIP001 	{
//STRIP001 		aDragTimer.Stop();
//STRIP001 	}
//STRIP001 
//STRIP001 	lcl_InvalidateAttribs( pViewShell->GetViewFrame()->GetBindings() );
//STRIP001 
//STRIP001 	Point aPnt( pWindow->PixelToLogic( rMEvt.GetPosPixel() ) );
//STRIP001 
//STRIP001 	if ( pView->MouseButtonUp(rMEvt, pWindow) )
//STRIP001 		return (TRUE); // Event von der SdrView ausgewertet
//STRIP001 
//STRIP001 	if ( pView->IsDragObj() )
//STRIP001 	{
//STRIP001 		pView->EndDragObj( rMEvt.IsShift() );
//STRIP001 		pView->ForceMarkedToAnotherPage();
//STRIP001 	}
//STRIP001 	else if ( pView->IsCreateObj() )
//STRIP001 	{
//STRIP001 		if (rMEvt.IsLeft())
//STRIP001 		{
//STRIP001 			pView->EndCreateObj(SDRCREATE_FORCEEND);
//STRIP001 			if (aSfxRequest.GetSlot() == SID_DRAW_TEXT_MARQUEE)
//STRIP001 			{
//STRIP001 				//	Lauftext-Objekt erzeugen?
//STRIP001 
//STRIP001 				const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 				if (rMarkList.GetMark(0))
//STRIP001 				{
//STRIP001 					SdrObject* pObj = rMarkList.GetMark(0)->GetObj();
//STRIP001 
//STRIP001 					// die fuer das Scrollen benoetigten Attribute setzen
//STRIP001 					SfxItemSet aItemSet( pDrDoc->GetItemPool(),
//STRIP001 											SDRATTR_MISC_FIRST, SDRATTR_MISC_LAST);
//STRIP001 
//STRIP001 					aItemSet.Put( SdrTextAutoGrowWidthItem( FALSE ) );
//STRIP001 					aItemSet.Put( SdrTextAutoGrowHeightItem( FALSE ) );
//STRIP001 					aItemSet.Put( SdrTextAniKindItem( SDRTEXTANI_SLIDE ) );
//STRIP001 					aItemSet.Put( SdrTextAniDirectionItem( SDRTEXTANI_LEFT ) );
//STRIP001 					aItemSet.Put( SdrTextAniCountItem( 1 ) );
//STRIP001 					aItemSet.Put( SdrTextAniAmountItem(
//STRIP001 									(INT16)pWindow->PixelToLogic(Size(2,1)).Width()) );
//STRIP001 //-/					pObj->SetAttributes(aItemSet, FALSE);
//STRIP001 					pObj->SetItemSetAndBroadcast(aItemSet);
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			// #93382# init object different when vertical writing
//STRIP001 			sal_uInt16 nSlotID(aSfxRequest.GetSlot());
//STRIP001 			BOOL bVertical = (SID_DRAW_TEXT_VERTICAL == nSlotID);
//STRIP001 			if(bVertical)
//STRIP001 			{
//STRIP001 				const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 				if(rMarkList.GetMark(0))
//STRIP001 				{
//STRIP001 					SdrObject* pObj = rMarkList.GetMark(0)->GetObj();
//STRIP001 					if(pObj && pObj->ISA(SdrTextObj))
//STRIP001 					{
//STRIP001 						SdrTextObj* pText = (SdrTextObj*)pObj;
//STRIP001 						SfxItemSet aSet(pDrDoc->GetItemPool());
//STRIP001 
//STRIP001 						pText->SetVerticalWriting(TRUE);
//STRIP001 
//STRIP001 						aSet.Put(SdrTextAutoGrowWidthItem(TRUE));
//STRIP001 						aSet.Put(SdrTextAutoGrowHeightItem(FALSE));
//STRIP001 						aSet.Put(SdrTextVertAdjustItem(SDRTEXTVERTADJUST_TOP));
//STRIP001 						aSet.Put(SdrTextHorzAdjustItem(SDRTEXTHORZADJUST_RIGHT));
//STRIP001 						
//STRIP001 						pText->SetItemSet(aSet);
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			
//STRIP001 			SetInEditMode();
//STRIP001 
//STRIP001 				//	Modus verlassen bei einzelnem Klick
//STRIP001 				//	(-> fuconstr)
//STRIP001 
//STRIP001 			if ( !pView->HasMarkedObj() )
//STRIP001 			{
//STRIP001 				pView->MarkObj(aPnt, -2, FALSE, rMEvt.IsMod1());
//STRIP001 
//STRIP001 				SfxDispatcher& rDisp = pViewShell->GetViewData()->GetDispatcher();
//STRIP001 				if ( pView->HasMarkedObj() )
//STRIP001 					rDisp.Execute(SID_OBJECT_SELECT, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD);
//STRIP001 				else
//STRIP001 					rDisp.Execute(aSfxRequest.GetSlot(), SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( pView->IsAction() )
//STRIP001 	{
//STRIP001 		pView->EndAction();
//STRIP001 	}
//STRIP001 
//STRIP001 /*	aNewPointer = Pointer(POINTER_TEXT);
//STRIP001 	pViewShell->SetActivePointer(aNewPointer);
//STRIP001 */
//STRIP001 	ForcePointer(&rMEvt);
//STRIP001 	pWindow->ReleaseMouse();
//STRIP001 
//STRIP001 	if ( !pView->HasMarkedObj() )
//STRIP001 	{
//STRIP001 		SdrObject* pObj;
//STRIP001 		SdrPageView* pPV;
//STRIP001 
//STRIP001 		if ( pView->PickObj(aPnt, pObj, pPV) )
//STRIP001 		{
//STRIP001 			if ( pView->MarkObj(aPnt, -2, FALSE, rMEvt.IsMod1()) )
//STRIP001 			{
//STRIP001 				UINT16 nSdrObjKind = pObj->GetObjIdentifier();
//STRIP001 
//STRIP001 				if (nSdrObjKind != OBJ_TEXT &&
//STRIP001 					nSdrObjKind != OBJ_TITLETEXT &&
//STRIP001 					nSdrObjKind != OBJ_OUTLINETEXT &&
//STRIP001 					! pObj->ISA(SdrTextObj) )
//STRIP001 				{
//STRIP001 //					pViewShell->GetViewData()->GetDispatcher().Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return (bReturn);
//STRIP001 }

/*************************************************************************
|*
|* Maus-Pointer umschalten
|*
\************************************************************************/

//STRIP001 void FuText::ForcePointer(const MouseEvent* pMEvt)
//STRIP001 {
//STRIP001 	pViewShell->SetActivePointer( aNewPointer );
//STRIP001 
//STRIP001 /*
//STRIP001 	if ( !pView->IsAction() )
//STRIP001 	{
//STRIP001 		Point aPnt(pWindow->PixelToLogic( pWindow->ScreenToOutputPixel(
//STRIP001 				   Pointer::GetPosPixel() ) ) );
//STRIP001 		SdrHdl* pHdl=pView->HitHandle(aPnt, *pWindow);
//STRIP001 
//STRIP001 		if (pHdl!=NULL)
//STRIP001 		{
//STRIP001 			pViewShell->SetActivePointer(pHdl->GetPointer() );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SdrObject* pObj;
//STRIP001 			SdrPageView* pPV;
//STRIP001 
//STRIP001 			if ( pView->IsMarkedHit(aPnt) )
//STRIP001 			{
//STRIP001 				if ( pView->TakeTextEditObject(aPnt, pObj, pPV) )
//STRIP001 				{
//STRIP001 					pViewShell->SetActivePointer(Pointer(POINTER_TEXT));
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					pViewShell->SetActivePointer(Pointer(POINTER_MOVE));
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 //				if ( pView->TakeMacroObject(aPnt, pObj, pPV) )
//STRIP001 				if ( pView->PickObj(aPnt, pObj, pPV, SDRSEARCH_PICKMACRO) )
//STRIP001 				{
//STRIP001 					pViewShell->SetActivePointer( pObj->GetMacroPointer() );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					pViewShell->SetActivePointer( aNewPointer );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 */
//STRIP001 }



/*************************************************************************
|*
|* Tastaturereignisse bearbeiten
|*
|* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
|* FALSE.
|*
\************************************************************************/

//STRIP001 BOOL __EXPORT FuText::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	if ( pView->KeyInput(rKEvt, pWindow) )
//STRIP001 	{
//STRIP001 		bReturn = TRUE;
//STRIP001 		lcl_InvalidateAttribs( pViewShell->GetViewFrame()->GetBindings() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		bReturn = FuDraw::KeyInput(rKEvt);
//STRIP001 	}
//STRIP001 
//STRIP001 	return (bReturn);
//STRIP001 }



/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

//STRIP001 void FuText::Activate()
//STRIP001 {
//STRIP001 	pView->SetDragMode(SDRDRAG_MOVE);
//STRIP001 	SfxBindings& rBindings = pViewShell->GetViewFrame()->GetBindings();
//STRIP001 	rBindings.Invalidate( SID_OBJECT_ROTATE );
//STRIP001 	rBindings.Invalidate( SID_OBJECT_MIRROR );
//STRIP001 
//STRIP001 //	Sofort in den Edit Mode setzen
//STRIP001 //	SetInEditMode();
//STRIP001 
//STRIP001 //	if (!pTextObj)
//STRIP001 	{
//STRIP001 		/**********************************************************************
//STRIP001 		* Kein Textobjekt im EditMode, daher CreateMode setzen
//STRIP001 		**********************************************************************/
//STRIP001 		USHORT nObj = OBJ_TEXT;
//STRIP001 
//STRIP001 /*		UINT16 nIdent;
//STRIP001 		UINT32 nInvent;
//STRIP001 		pView->TakeCurrentObj(nIdent, nInvent);
//STRIP001 */
//STRIP001 		pView->SetCurrentObj(nObj);
//STRIP001 
//STRIP001 		pView->SetCreateMode();
//STRIP001 	}
//STRIP001 
//STRIP001 	aNewPointer = Pointer(POINTER_TEXT);
//STRIP001 //	aNewPointer = Pointer(POINTER_CROSS);				//! ???
//STRIP001 
//STRIP001 	aOldPointer = pWindow->GetPointer();
//STRIP001 	pViewShell->SetActivePointer( aNewPointer );
//STRIP001 
//STRIP001 	FuConstruct::Activate();
//STRIP001 }


/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

//STRIP001 void FuText::Deactivate()
//STRIP001 {
//STRIP001 	FuConstruct::Deactivate();
//STRIP001 	pViewShell->SetActivePointer( aOldPointer );
//STRIP001 	StopEditMode();
//STRIP001 }


/*************************************************************************
|*
|* Selektion hat sich geaendert
|*
\************************************************************************/

//STRIP001 void FuText::SelectionHasChanged()
//STRIP001 {
//STRIP001 	pView->SetDragMode(SDRDRAG_MOVE);
//STRIP001 	SfxBindings& rBindings = pViewShell->GetViewFrame()->GetBindings();
//STRIP001 	rBindings.Invalidate( SID_OBJECT_ROTATE );
//STRIP001 	rBindings.Invalidate( SID_OBJECT_MIRROR );
//STRIP001 
//STRIP001 	pTextObj = NULL;
//STRIP001 
//STRIP001 	if ( pView->HasMarkedObj() )
//STRIP001 	{
//STRIP001 		const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 
//STRIP001 		if (rMarkList.GetMarkCount() == 1)
//STRIP001 		{
//STRIP001 			SdrMark* pMark = rMarkList.GetMark(0);
//STRIP001 			SdrObject* pObj = pMark->GetObj();
//STRIP001 
//STRIP001 			UINT16 nSdrObjKind = pObj->GetObjIdentifier();
//STRIP001 
//STRIP001 			if (nSdrObjKind == OBJ_TEXT ||
//STRIP001 				nSdrObjKind == OBJ_TITLETEXT ||
//STRIP001 				nSdrObjKind == OBJ_OUTLINETEXT /* ||
//STRIP001 				pObj->ISA(SdrTextObj) */ )
//STRIP001 			{
//STRIP001 				pTextObj = (SdrTextObj*) pObj;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!pTextObj)
//STRIP001 	{
//STRIP001 		/**********************************************************************
//STRIP001 		* Kein Textobjekt im EditMode, daher CreateMode setzen
//STRIP001 		**********************************************************************/
//STRIP001 		USHORT nObj = OBJ_TEXT;
//STRIP001 		UINT16 nIdent;
//STRIP001 		UINT32 nInvent;
//STRIP001 		pView->TakeCurrentObj(nIdent, nInvent);
//STRIP001 
//STRIP001 //		  if (! pView->IsEditMode() )
//STRIP001 //		  {
//STRIP001 //			  if (nIdent == OBJ_TEXT)
//STRIP001 //			  {
//STRIP001 //				  nObj = OBJ_TEXT;
//STRIP001 //			  }
//STRIP001 //			  else if (nIdent == OBJ_OUTLINETEXT)
//STRIP001 //			  {
//STRIP001 //				  nObj = OBJ_OUTLINETEXT;
//STRIP001 //			  }
//STRIP001 //			  else if (nIdent == OBJ_TITLETEXT)
//STRIP001 //			  {
//STRIP001 //				  nObj = OBJ_TITLETEXT;
//STRIP001 //			  }
//STRIP001 //		  }
//STRIP001 
//STRIP001 		pView->SetCurrentObj(nObj);
//STRIP001 
//STRIP001 		pView->SetCreateMode();
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Objekt in Edit-Mode setzen
|*
\************************************************************************/

//STRIP001 void FuText::SetInEditMode(SdrObject* pObj, const Point* pMousePixel,
//STRIP001 							BOOL bCursorToEnd, const KeyEvent* pInitialKey)
//STRIP001 {
//STRIP001 	//	pObj != NULL, wenn ein spezielles (nicht markiertes) Objekt editiert werden soll
//STRIP001 	//	(-> Legendenobjekt von Notizen)
//STRIP001 	//	wenn pObj == NULL, markiertes Objekt nehmen
//STRIP001 
//STRIP001 	SdrLayer* pLockLayer = NULL;
//STRIP001 	if ( pObj && pObj->GetLayer() == SC_LAYER_INTERN )
//STRIP001 	{
//STRIP001 		//	auf gelocktem Layer kann nicht editiert werden, darum den Layer
//STRIP001 		//	temporaer auf nicht gelockt setzen
//STRIP001 
//STRIP001 		pLockLayer = pDrDoc->GetLayerAdmin().GetLayerPerID(SC_LAYER_INTERN);
//STRIP001 		if (pLockLayer)
//STRIP001 			pView->SetLayerLocked( pLockLayer->GetName(), FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !pObj && pView->HasMarkedObj() )
//STRIP001 	{
//STRIP001 		const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 		if (rMarkList.GetMarkCount() == 1)
//STRIP001 		{
//STRIP001 			SdrMark* pMark = rMarkList.GetMark(0);
//STRIP001 			pObj = pMark->GetObj();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	pTextObj = NULL;
//STRIP001 
//STRIP001 	if ( pObj )
//STRIP001 	{
//STRIP001 		UINT16 nSdrObjKind = pObj->GetObjIdentifier();
//STRIP001 
//STRIP001 		if (nSdrObjKind == OBJ_TEXT ||
//STRIP001 			nSdrObjKind == OBJ_TITLETEXT ||
//STRIP001 			nSdrObjKind == OBJ_OUTLINETEXT ||
//STRIP001 			pObj->ISA(SdrTextObj))
//STRIP001 		{
//STRIP001 			SdrPageView* pPV = pView->GetPageViewPvNum(0);
//STRIP001 			Rectangle aRect = pObj->GetLogicRect();
//STRIP001 			Point aPnt = aRect.Center();
//STRIP001 
//STRIP001 			if ( pObj->HasTextEdit() )
//STRIP001 			{
//STRIP001 				SdrOutliner* pO = MakeOutliner();
//STRIP001 				lcl_UpdateHyphenator( *pO, pObj );
//STRIP001 
//STRIP001 				//	vertical flag:
//STRIP001 				//	deduced from slot ids only if text object has no content
//STRIP001 
//STRIP001 				USHORT nSlotID = aSfxRequest.GetSlot();
//STRIP001 				BOOL bVertical = ( nSlotID == SID_DRAW_TEXT_VERTICAL );
//STRIP001 				OutlinerParaObject* pOPO = pObj->GetOutlinerParaObject();
//STRIP001 				if ( pOPO )
//STRIP001 				{
//STRIP001 					if ( nSlotID == SID_DRAW_NOTEEDIT )
//STRIP001 						pOPO->SetVertical( FALSE );			// notes are always horizontal
//STRIP001 					else
//STRIP001 						bVertical = pOPO->IsVertical();		// content wins
//STRIP001 				}
//STRIP001 				pO->SetVertical( bVertical );
//STRIP001 
//STRIP001 				//!??	ohne uebergebenen Outliner stimmen die Defaults nicht ???!?
//STRIP001 				if ( pView->BegTextEdit(pObj, pPV, pWindow, (FASTBOOL)TRUE, pO) )
//STRIP001 				{
//STRIP001 					//	EditEngine-UndoManager anmelden
//STRIP001 					pViewShell->SetDrawTextUndo( &pO->GetUndoManager() );
//STRIP001 
//STRIP001 					pTextObj = (SdrTextObj*) pObj;
//STRIP001 					pView->SetEditMode();
//STRIP001 
//STRIP001 					//	set text cursor to click position or to end,
//STRIP001 					//	pass initial key event to outliner view
//STRIP001 					if ( pMousePixel || bCursorToEnd || pInitialKey )
//STRIP001 					{
//STRIP001 						OutlinerView* pOLV = pView->GetTextEditOutlinerView();
//STRIP001 						if (pOLV)
//STRIP001 						{
//STRIP001 							if ( pMousePixel )
//STRIP001 							{
//STRIP001 								MouseEvent aEditEvt( *pMousePixel, 1, MOUSE_SYNTHETIC, MOUSE_LEFT, 0 );
//STRIP001 								pOLV->MouseButtonDown(aEditEvt);
//STRIP001 								pOLV->MouseButtonUp(aEditEvt);
//STRIP001 							}
//STRIP001 							else if ( bCursorToEnd )
//STRIP001 							{
//STRIP001 								ESelection aNewSelection(EE_PARA_NOT_FOUND, EE_INDEX_NOT_FOUND, EE_PARA_NOT_FOUND, EE_INDEX_NOT_FOUND);
//STRIP001 								pOLV->SetSelection(aNewSelection);
//STRIP001 							}
//STRIP001 
//STRIP001 							if ( pInitialKey )
//STRIP001 								pOLV->PostKeyEvent( *pInitialKey );
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pLockLayer)
//STRIP001 		pView->SetLayerLocked( pLockLayer->GetName(), TRUE );
//STRIP001 }

// #98185# Create default drawing objects via keyboard
//STRIP001 SdrObject* FuText::CreateDefaultObject(const sal_uInt16 nID, const Rectangle& rRectangle)
//STRIP001 {
//STRIP001 	// case SID_DRAW_TEXT:
//STRIP001 	// case SID_DRAW_TEXT_VERTICAL:
//STRIP001 	// case SID_DRAW_TEXT_MARQUEE:
//STRIP001 	// case SID_DRAW_NOTEEDIT:
//STRIP001 
//STRIP001 	SdrObject* pObj = SdrObjFactory::MakeNewObject(
//STRIP001 		pView->GetCurrentObjInventor(), pView->GetCurrentObjIdentifier(),
//STRIP001 		0L, pDrDoc);
//STRIP001 
//STRIP001 	if(pObj)
//STRIP001 	{
//STRIP001 		if(pObj->ISA(SdrTextObj))
//STRIP001 		{
//STRIP001 			SdrTextObj* pText = (SdrTextObj*)pObj;
//STRIP001 			pText->SetLogicRect(rRectangle);
//STRIP001 
//STRIP001 			//  #105815# don't set default text, start edit mode instead
//STRIP001 			// String aText(ScResId(STR_CAPTION_DEFAULT_TEXT));
//STRIP001 			// pText->SetText(aText);
//STRIP001 
//STRIP001 			sal_Bool bVertical = (SID_DRAW_TEXT_VERTICAL == nID);
//STRIP001 			sal_Bool bMarquee = (SID_DRAW_TEXT_MARQUEE == nID);
//STRIP001 
//STRIP001 			pText->SetVerticalWriting(bVertical);
//STRIP001 
//STRIP001 			if(bVertical)
//STRIP001 			{
//STRIP001 				SdrTextObj* pText = (SdrTextObj*)pObj;
//STRIP001 				SfxItemSet aSet(pDrDoc->GetItemPool());
//STRIP001 
//STRIP001 				aSet.Put(SdrTextAutoGrowWidthItem(TRUE));
//STRIP001 				aSet.Put(SdrTextAutoGrowHeightItem(FALSE));
//STRIP001 				aSet.Put(SdrTextVertAdjustItem(SDRTEXTVERTADJUST_TOP));
//STRIP001 				aSet.Put(SdrTextHorzAdjustItem(SDRTEXTHORZADJUST_RIGHT));
//STRIP001 				
//STRIP001 				pText->SetItemSet(aSet);
//STRIP001 			}
//STRIP001 
//STRIP001 			if(bMarquee)
//STRIP001 			{
//STRIP001 				SfxItemSet aSet(pDrDoc->GetItemPool(), SDRATTR_MISC_FIRST, SDRATTR_MISC_LAST);
//STRIP001 
//STRIP001 				aSet.Put( SdrTextAutoGrowWidthItem( FALSE ) );
//STRIP001 				aSet.Put( SdrTextAutoGrowHeightItem( FALSE ) );
//STRIP001 				aSet.Put( SdrTextAniKindItem( SDRTEXTANI_SLIDE ) );
//STRIP001 				aSet.Put( SdrTextAniDirectionItem( SDRTEXTANI_LEFT ) );
//STRIP001 				aSet.Put( SdrTextAniCountItem( 1 ) );
//STRIP001 				aSet.Put( SdrTextAniAmountItem( (INT16)pWindow->PixelToLogic(Size(2,1)).Width()) );
//STRIP001 
//STRIP001 				pObj->SetItemSetAndBroadcast(aSet);
//STRIP001 			}
//STRIP001 
//STRIP001 			SetInEditMode( pObj );		// #105815# start edit mode
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			DBG_ERROR("Object is NO text object");
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return pObj;
//STRIP001 }

}
