/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_fieldwnd.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:59:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// auto strip #include <vcl/virdev.hxx>
// auto strip #include <vcl/decoview.hxx>
// auto strip #include <vcl/svapp.hxx>

// auto strip #include <tools/debug.hxx>

// auto strip #include "fieldwnd.hxx"
// auto strip #include "pvlaydlg.hxx"
// auto strip #include "pvglob.hxx"

// auto strip #ifndef _SC_ACCESSIBLEDATAPILOTCONTROL_HXX
// auto strip #include "AccessibleDataPilotControl.hxx"
// auto strip #endif
// auto strip #ifndef SC_SCRESID_HXX
// auto strip #include "scresid.hxx"
// auto strip #endif
#ifndef SC_SC_HRC
#include "bf_sc.hrc"
#endif
namespace binfilter {

//===================================================================

//STRIP001 ScDPFieldWindow::ScDPFieldWindow(
//STRIP001         ScDPLayoutDlg* pDialog,
//STRIP001         const ResId& rResId,
//STRIP001         ScDPFieldType eFieldType,
//STRIP001         FixedText* pFtFieldCaption ) :
//STRIP001     Control( pDialog, rResId ),
//STRIP001     pDlg( pDialog ),
//STRIP001     pFtCaption( pFtFieldCaption ),
//STRIP001     eType( eFieldType ),
//STRIP001     nFieldCount( 0 ),
//STRIP001     nFieldSelected( 0 ),
//STRIP001     pAccessible( NULL )
//STRIP001 {
//STRIP001     Init();
//STRIP001     if (eType != TYPE_SELECT && pFtCaption)
//STRIP001     {
//STRIP001         aName = pFtCaption->GetText();
//STRIP001         aName.EraseAllChars('~');
//STRIP001     }
//STRIP001 }

//STRIP001 ScDPFieldWindow::ScDPFieldWindow(
//STRIP001         ScDPLayoutDlg* pDialog,
//STRIP001         const ResId& rResId,
//STRIP001         ScDPFieldType eFieldType,
//STRIP001         const String& rName ) :
//STRIP001     Control( pDialog, rResId ),
//STRIP001     aName(rName),
//STRIP001     pDlg( pDialog ),
//STRIP001     pFtCaption( NULL ),
//STRIP001     eType( eFieldType ),
//STRIP001     nFieldCount( 0 ),
//STRIP001     nFieldSelected( 0 ),
//STRIP001     pAccessible( NULL )
//STRIP001 {
//STRIP001     Init();
//STRIP001 }

//STRIP001 void ScDPFieldWindow::Init()
//STRIP001 {
//STRIP001     aWndRect = Rectangle( GetPosPixel(), GetSizePixel() );
//STRIP001     nFieldSize = (eType == TYPE_SELECT) ? PAGE_SIZE : MAX_FIELDS;
//STRIP001 
//STRIP001     aFieldArr = new String*[ nFieldSize ];
//STRIP001     for( long nIx = 0; nIx < nFieldSize; ++nIx )
//STRIP001         aFieldArr[ nIx ] = NULL;
//STRIP001 
//STRIP001     if( pFtCaption )
//STRIP001 	{
//STRIP001         Size aWinSize( aWndRect.GetSize() );
//STRIP001         Size aTextSize( GetTextWidth( pFtCaption->GetText() ), GetTextHeight() );
//STRIP001         aTextPos.X() = (aWinSize.Width() - aTextSize.Width()) / 2;
//STRIP001         aTextPos.Y() = (aWinSize.Height() - aTextSize.Height()) / 2;
//STRIP001 	}
//STRIP001 
//STRIP001     GetStyleSettings();
//STRIP001 }

//STRIP001 __EXPORT ScDPFieldWindow::~ScDPFieldWindow()
//STRIP001 {
//STRIP001     for( long nIx = 0; nIx < nFieldCount; ++nIx )
//STRIP001         delete aFieldArr[ nIx ];
//STRIP001     delete[] aFieldArr;
//STRIP001 
//STRIP001     if (pAccessible)
//STRIP001     {
//STRIP001         ::com::sun::star::uno::Reference < ::com::sun::star::accessibility::XAccessible > xTempAcc = xAccessible;
//STRIP001         if (xTempAcc.is())
//STRIP001             pAccessible->dispose();
//STRIP001     }
//STRIP001 }

//-------------------------------------------------------------------

//STRIP001 void ScDPFieldWindow::GetStyleSettings()
//STRIP001 {
//STRIP001     const StyleSettings& rStyleSet = GetSettings().GetStyleSettings();
//STRIP001     aFaceColor = rStyleSet.GetFaceColor();
//STRIP001     aWinColor = rStyleSet.GetWindowColor();
//STRIP001     aTextColor = rStyleSet.GetButtonTextColor();
//STRIP001     aWinTextColor = rStyleSet.GetWindowTextColor();
//STRIP001 }

//-------------------------------------------------------------------

//STRIP001 Point ScDPFieldWindow::GetFieldPosition( long nIndex ) const
//STRIP001 {
//STRIP001     Point aPos;
//STRIP001     switch( eType )
//STRIP001 	{
//STRIP001 		case TYPE_COL:
//STRIP001             aPos.X() = OWIDTH * (nIndex % (MAX_FIELDS / 2));
//STRIP001             aPos.Y() = OHEIGHT * (nIndex / (MAX_FIELDS / 2));
//STRIP001 		break;
//STRIP001 		case TYPE_ROW:
//STRIP001 		case TYPE_DATA:
//STRIP001             aPos.X() = 0;
//STRIP001             aPos.Y() = OHEIGHT * nIndex;
//STRIP001 		break;
//STRIP001 		case TYPE_SELECT:
//STRIP001             aPos.X() = (OWIDTH + SSPACE) * (nIndex / LINE_SIZE);
//STRIP001             aPos.Y() = (OHEIGHT + SSPACE) * (nIndex % LINE_SIZE);
//STRIP001         break;
//STRIP001     }
//STRIP001     return aPos;
//STRIP001 }

//STRIP001 Size ScDPFieldWindow::GetFieldSize() const
//STRIP001 {
//STRIP001     return Size( (eType == TYPE_DATA) ? GetSizePixel().Width() : OWIDTH, OHEIGHT );
//STRIP001 }

//STRIP001 Point ScDPFieldWindow::GetLastPosition() const
//STRIP001 {
//STRIP001     return OutputToScreenPixel( GetFieldPosition( nFieldSize - 1 ) );
//STRIP001 }

//STRIP001 BOOL ScDPFieldWindow::GetFieldIndex( const Point& rPos, long& rnIndex ) const
//STRIP001 {
//STRIP001     rnIndex = -1;
//STRIP001     switch( eType )
//STRIP001 	{
//STRIP001 		case TYPE_ROW:
//STRIP001 		case TYPE_DATA:
//STRIP001             rnIndex = rPos.Y() / OHEIGHT;
//STRIP001 		break;
//STRIP001 		case TYPE_COL:
//STRIP001 		{
//STRIP001             long nRow = rPos.Y() / OHEIGHT;
//STRIP001             long nCol = rPos.X() / OWIDTH;
//STRIP001             rnIndex = nRow * MAX_FIELDS / 2 + nCol;
//STRIP001         }
//STRIP001 		break;
//STRIP001 		case TYPE_SELECT:
//STRIP001 		{
//STRIP001             long nRow = rPos.Y() / (OHEIGHT + SSPACE);
//STRIP001             long nCol = rPos.X() / (OWIDTH + SSPACE);
//STRIP001             // is not between controls?
//STRIP001             if( (rPos.Y() % (OHEIGHT + SSPACE) < OHEIGHT) && (rPos.X() % (OWIDTH + SSPACE) < OWIDTH) )
//STRIP001                 rnIndex = nCol * LINE_SIZE + nRow;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001     return IsValidIndex( rnIndex );
//STRIP001 }

//-------------------------------------------------------------------

//STRIP001 void ScDPFieldWindow::DrawBackground( OutputDevice& rDev )
//STRIP001 {
//STRIP001     Point aPos0;
//STRIP001     Size aSize( GetSizePixel() );
//STRIP001 
//STRIP001     if ( eType == TYPE_SELECT )
//STRIP001 	{
//STRIP001         rDev.SetLineColor();
//STRIP001         rDev.SetFillColor( aFaceColor );
//STRIP001         rDev.DrawRect( Rectangle( aPos0, aSize ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001         rDev.SetLineColor( aWinTextColor );
//STRIP001         rDev.SetFillColor( aWinColor );
//STRIP001         rDev.DrawRect( Rectangle( aPos0, aSize ) );
//STRIP001         rDev.SetTextColor( aWinTextColor );
//STRIP001         BOOL bOldRTL = rDev.IsRTLEnabled();
//STRIP001         rDev.EnableRTL( false );
//STRIP001         rDev.DrawCtrlText( aTextPos, GetText() );
//STRIP001         rDev.EnableRTL( bOldRTL );
//STRIP001     }
//STRIP001 }

//STRIP001 void ScDPFieldWindow::DrawField(
//STRIP001         OutputDevice& rDev,
//STRIP001         const Rectangle& rRect,
//STRIP001         const String& rText,
//STRIP001         BOOL bSelected )
//STRIP001 {
//STRIP001 	VirtualDevice aVirDev( rDev );
//STRIP001     aVirDev.EnableRTL( true );
//STRIP001 
//STRIP001     Size aDevSize( rRect.GetSize() );
//STRIP001     long    nWidth       = aDevSize.Width();
//STRIP001     long    nHeight      = aDevSize.Height();
//STRIP001     long    nLabelWidth  = rDev.GetTextWidth( rText );
//STRIP001     long    nLabelHeight = rDev.GetTextHeight();
//STRIP001     Point   aLabelPos(
//STRIP001         ((nWidth > nLabelWidth + 6) ? (nWidth - nLabelWidth) / 2 : 3),
//STRIP001         ((nHeight > nLabelHeight + 6) ? (nHeight - nLabelHeight) / 2 : 3) );
//STRIP001 
//STRIP001     aVirDev.SetOutputSizePixel( aDevSize );
//STRIP001     aVirDev.SetFont( rDev.GetFont() );
//STRIP001     DecorationView aDecoView( &aVirDev );
//STRIP001     aDecoView.DrawButton( Rectangle( Point( 0, 0 ), aDevSize ), bSelected ? BUTTON_DRAW_DEFAULT : 0 );
//STRIP001     aVirDev.SetTextColor( aTextColor );
//STRIP001     aVirDev.EnableRTL( false );
//STRIP001     aVirDev.DrawText( aLabelPos, rText );
//STRIP001     rDev.DrawBitmap( rRect.TopLeft(), aVirDev.GetBitmap( Point( 0, 0 ), aDevSize ) );
//STRIP001 }

//STRIP001 void ScDPFieldWindow::Redraw()
//STRIP001 {
//STRIP001 	VirtualDevice	aVirDev;
//STRIP001     aVirDev.EnableRTL( true );
//STRIP001 
//STRIP001 	Point			aPos0;
//STRIP001 	Size			aSize( GetSizePixel() );
//STRIP001 	Font			aFont( GetFont() );			// Font vom Window
//STRIP001 	aFont.SetTransparent( TRUE );
//STRIP001 	aVirDev.SetFont( aFont );
//STRIP001     aVirDev.SetOutputSizePixel( aSize );
//STRIP001 
//STRIP001     DrawBackground( aVirDev );
//STRIP001 
//STRIP001     nFieldSelected = Max( Min( nFieldSelected, (long)(nFieldCount - 1) ), 0L );
//STRIP001     Rectangle aFieldRect( aPos0, GetFieldSize() );
//STRIP001     for( long nIx = 0; nIx < nFieldCount; ++nIx )
//STRIP001     {
//STRIP001         if( aFieldArr[ nIx ] )
//STRIP001         {
//STRIP001             aFieldRect.SetPos( GetFieldPosition( nIx ) );
//STRIP001             BOOL bSel = HasFocus() && (nIx == nFieldSelected);
//STRIP001             DrawField( aVirDev, aFieldRect, *(aFieldArr[ nIx ]), bSel );
//STRIP001         }
//STRIP001     }
//STRIP001     DrawBitmap( aPos0, aVirDev.GetBitmap( aPos0, aSize ) );
//STRIP001 
//STRIP001     if( HasFocus() && aFieldArr[ nFieldSelected ] )
//STRIP001     {
//STRIP001         long nFieldWidth = aFieldRect.GetWidth();
//STRIP001         long nSelectionWidth = Min( GetTextWidth( *(aFieldArr[ nFieldSelected ]) ) + 4, nFieldWidth - 6 );
//STRIP001         Rectangle aSelection(
//STRIP001             GetFieldPosition( nFieldSelected ) + Point( (nFieldWidth - nSelectionWidth) / 2, 3 ),
//STRIP001             Size( nSelectionWidth, aFieldRect.GetHeight() - 6 ) );
//STRIP001         InvertTracking( aSelection, SHOWTRACK_SMALL | SHOWTRACK_WINDOW );
//STRIP001     }
//STRIP001 
//STRIP001     WinBits nMask = ~(WB_TABSTOP | WB_NOTABSTOP);
//STRIP001     SetStyle( (GetStyle() & nMask) | (nFieldCount ? WB_TABSTOP : WB_NOTABSTOP) );
//STRIP001 }

//-------------------------------------------------------------------

//STRIP001 BOOL ScDPFieldWindow::IsValidIndex( long nIndex ) const
//STRIP001 {
//STRIP001     return (nIndex >= 0) && (nIndex < nFieldSize);
//STRIP001 }

//STRIP001 BOOL ScDPFieldWindow::IsExistingIndex( long nIndex ) const
//STRIP001 {
//STRIP001     return (nIndex >= 0) && (nIndex < nFieldCount);
//STRIP001 }

//STRIP001 long ScDPFieldWindow::CalcNewFieldIndex( short nDX, short nDY ) const
//STRIP001 {
//STRIP001     long nNewField = nFieldSelected;
//STRIP001     switch( eType )
//STRIP001     {
//STRIP001         case TYPE_COL:
//STRIP001             nNewField += nDX + nDY * MAX_FIELDS / 2;
//STRIP001         break;
//STRIP001         case TYPE_ROW:
//STRIP001         case TYPE_DATA:
//STRIP001             nNewField += nDY;
//STRIP001         break;
//STRIP001         case TYPE_SELECT:
//STRIP001             nNewField += nDX * LINE_SIZE + nDY;
//STRIP001         break;
//STRIP001     }
//STRIP001 
//STRIP001     return IsExistingIndex( nNewField ) ? nNewField : nFieldSelected;
//STRIP001 }

//STRIP001 void ScDPFieldWindow::SetSelection( long nIndex )
//STRIP001 {
//STRIP001     nIndex = Max( Min( nIndex, (long)(nFieldCount - 1) ), 0L );
//STRIP001     if( nFieldSelected != nIndex )
//STRIP001     {
//STRIP001         sal_Int32 nOldSelected(nFieldSelected);
//STRIP001         nFieldSelected = nIndex;
//STRIP001         Redraw();
//STRIP001 
//STRIP001         if (pAccessible && HasFocus())
//STRIP001         {
//STRIP001             ::com::sun::star::uno::Reference < ::com::sun::star::accessibility::XAccessible > xTempAcc = xAccessible;
//STRIP001             if (xTempAcc.is())
//STRIP001                 pAccessible->FieldFocusChange(nOldSelected, nFieldSelected);
//STRIP001             else
//STRIP001                 pAccessible = NULL;
//STRIP001         }
//STRIP001     }
//STRIP001 }

//STRIP001 void ScDPFieldWindow::SetSelectionHome()
//STRIP001 {
//STRIP001     if( eType == TYPE_SELECT )
//STRIP001         pDlg->NotifyMoveSlider( KEY_HOME );
//STRIP001     SetSelection( 0 );
//STRIP001 }

//STRIP001 void ScDPFieldWindow::SetSelectionEnd()
//STRIP001 {
//STRIP001     if( eType == TYPE_SELECT )
//STRIP001         pDlg->NotifyMoveSlider( KEY_END );
//STRIP001     SetSelection( nFieldCount - 1 );
//STRIP001 }

//STRIP001 void ScDPFieldWindow::MoveSelection( USHORT nKeyCode, short nDX, short nDY )
//STRIP001 {
//STRIP001     long nNewIndex = CalcNewFieldIndex( nDX, nDY );
//STRIP001     if( (eType == TYPE_SELECT) && (nNewIndex == nFieldSelected) )
//STRIP001     {
//STRIP001         if( pDlg->NotifyMoveSlider( nKeyCode ) )
//STRIP001         {
//STRIP001             switch( nKeyCode )
//STRIP001             {
//STRIP001                 case KEY_UP:    nNewIndex += (LINE_SIZE - 1);   break;
//STRIP001                 case KEY_DOWN:  nNewIndex -= (LINE_SIZE - 1);   break;
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001     SetSelection( nNewIndex );
//STRIP001 }

//STRIP001 void ScDPFieldWindow::ModifySelectionOffset( long nOffsetDiff )
//STRIP001 {
//STRIP001     nFieldSelected -= nOffsetDiff;
//STRIP001     Redraw();
//STRIP001 }

//STRIP001 void ScDPFieldWindow::SelectNext()
//STRIP001 {
//STRIP001     if( eType == TYPE_SELECT )
//STRIP001         MoveSelection( KEY_DOWN, 0, 1 );
//STRIP001 }

//STRIP001 void ScDPFieldWindow::GrabFocusWithSel( long nIndex )
//STRIP001 {
//STRIP001     SetSelection( nIndex );
//STRIP001     if( !HasFocus() )
//STRIP001         GrabFocus();
//STRIP001 }

//STRIP001 void ScDPFieldWindow::MoveField( long nDestIndex )
//STRIP001 {
//STRIP001     if( nDestIndex != nFieldSelected )
//STRIP001     {
//STRIP001         // "recycle" existing functionality
//STRIP001         pDlg->NotifyMouseButtonDown( eType, nFieldSelected );
//STRIP001         pDlg->NotifyMouseButtonUp( OutputToScreenPixel( GetFieldPosition( nDestIndex ) ) );
//STRIP001     }
//STRIP001 }

//STRIP001 void ScDPFieldWindow::MoveFieldRel( short nDX, short nDY )
//STRIP001 {
//STRIP001     MoveField( CalcNewFieldIndex( nDX, nDY ) );
//STRIP001 }

//-------------------------------------------------------------------

//STRIP001 void __EXPORT ScDPFieldWindow::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001     // Now the FixedText has its mnemonic char. Grab the text and hide the
//STRIP001     // FixedText to be able to handle tabstop and mnemonics separately.
//STRIP001     if( pFtCaption )
//STRIP001     {
//STRIP001         SetText( pFtCaption->GetText() );
//STRIP001         pFtCaption->Hide();
//STRIP001     }
//STRIP001     Redraw();
//STRIP001 }

//STRIP001 void __EXPORT ScDPFieldWindow::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001     if( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001 	{
//STRIP001         GetStyleSettings();
//STRIP001         Redraw();
//STRIP001 	}
//STRIP001 	else
//STRIP001         Control::DataChanged( rDCEvt );
//STRIP001 }

//STRIP001 void __EXPORT ScDPFieldWindow::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001     if( rMEvt.IsLeft() )
//STRIP001 	{
//STRIP001         long nIndex = 0;
//STRIP001         if( GetFieldIndex( rMEvt.GetPosPixel(), nIndex ) && aFieldArr[ nIndex ] )
//STRIP001 		{
//STRIP001             GrabFocusWithSel( nIndex );
//STRIP001 
//STRIP001             if( rMEvt.GetClicks() == 1 )
//STRIP001 			{
//STRIP001                 PointerStyle ePtr = pDlg->NotifyMouseButtonDown( eType, nIndex );
//STRIP001 				CaptureMouse();
//STRIP001                 SetPointer( Pointer( ePtr ) );
//STRIP001 			}
//STRIP001 			else
//STRIP001                 pDlg->NotifyDoubleClick( eType, nIndex );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void __EXPORT ScDPFieldWindow::MouseButtonUp( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001     if( rMEvt.IsLeft() )
//STRIP001 	{
//STRIP001         if( rMEvt.GetClicks() == 1 )
//STRIP001 		{
//STRIP001             pDlg->NotifyMouseButtonUp( OutputToScreenPixel( rMEvt.GetPosPixel() ) );
//STRIP001 			SetPointer( Pointer( POINTER_ARROW ) );
//STRIP001 		}
//STRIP001 
//STRIP001         if( IsMouseCaptured() )
//STRIP001 			ReleaseMouse();
//STRIP001 	}
//STRIP001 }

//STRIP001 void __EXPORT ScDPFieldWindow::MouseMove( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001     if( IsMouseCaptured() )
//STRIP001 	{
//STRIP001         PointerStyle ePtr = pDlg->NotifyMouseMove( OutputToScreenPixel( rMEvt.GetPosPixel() ) );
//STRIP001         SetPointer( Pointer( ePtr ) );
//STRIP001 	}
//STRIP001 }

//STRIP001 void __EXPORT ScDPFieldWindow::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001     const KeyCode& rKeyCode = rKEvt.GetKeyCode();
//STRIP001     USHORT nCode = rKeyCode.GetCode();
//STRIP001     BOOL bKeyEvaluated = FALSE;
//STRIP001 
//STRIP001     if( rKeyCode.IsMod1() && (eType != TYPE_SELECT) )
//STRIP001     {
//STRIP001         bKeyEvaluated = TRUE;
//STRIP001         switch( nCode )
//STRIP001         {
//STRIP001             case KEY_UP:    MoveFieldRel( 0, -1 );          break;
//STRIP001             case KEY_DOWN:  MoveFieldRel( 0, 1 );           break;
//STRIP001             case KEY_LEFT:  MoveFieldRel( -1, 0 );          break;
//STRIP001             case KEY_RIGHT: MoveFieldRel( 1, 0 );           break;
//STRIP001             case KEY_HOME:  MoveField( 0 );                 break;
//STRIP001             case KEY_END:   MoveField( nFieldCount - 1 );   break;
//STRIP001             default:        bKeyEvaluated = FALSE;
//STRIP001         }
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         bKeyEvaluated = TRUE;
//STRIP001         switch( nCode )
//STRIP001         {
//STRIP001             case KEY_UP:    MoveSelection( nCode, 0, -1 );          break;
//STRIP001             case KEY_DOWN:  MoveSelection( nCode, 0, 1 );           break;
//STRIP001             case KEY_LEFT:  MoveSelection( nCode, -1, 0 );          break;
//STRIP001             case KEY_RIGHT: MoveSelection( nCode, 1, 0 );           break;
//STRIP001             case KEY_HOME:  SetSelectionHome();                     break;
//STRIP001             case KEY_END:   SetSelectionEnd();                      break;
//STRIP001             case KEY_DELETE:
//STRIP001                 pDlg->NotifyRemoveField( eType, nFieldSelected );   break;
//STRIP001             default:        bKeyEvaluated = FALSE;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     if( !bKeyEvaluated )
//STRIP001         Control::KeyInput( rKEvt );
//STRIP001 }

//STRIP001 void __EXPORT ScDPFieldWindow::GetFocus()
//STRIP001 {
//STRIP001     Control::GetFocus();
//STRIP001     Redraw();
//STRIP001     if( GetGetFocusFlags() & GETFOCUS_MNEMONIC )    // move field on shortcut
//STRIP001         pDlg->NotifyMoveField( eType );
//STRIP001     else                                            // else change focus
//STRIP001         pDlg->NotifyFieldFocus( eType, TRUE );
//STRIP001 
//STRIP001     if (pAccessible)
//STRIP001     {
//STRIP001         ::com::sun::star::uno::Reference < ::com::sun::star::accessibility::XAccessible > xTempAcc = xAccessible;
//STRIP001         if (xTempAcc.is())
//STRIP001             pAccessible->GotFocus();
//STRIP001         else
//STRIP001             pAccessible = NULL;
//STRIP001     }
//STRIP001 }

//STRIP001 void __EXPORT ScDPFieldWindow::LoseFocus()
//STRIP001 {
//STRIP001     Control::LoseFocus();
//STRIP001     Redraw();
//STRIP001     pDlg->NotifyFieldFocus( eType, FALSE );
//STRIP001 
//STRIP001     if (pAccessible)
//STRIP001     {
//STRIP001         ::com::sun::star::uno::Reference < ::com::sun::star::accessibility::XAccessible > xTempAcc = xAccessible;
//STRIP001         if (xTempAcc.is())
//STRIP001             pAccessible->LostFocus();
//STRIP001         else
//STRIP001             pAccessible = NULL;
//STRIP001     }
//STRIP001 }

//-------------------------------------------------------------------

//STRIP001 void ScDPFieldWindow::AddField( const String& rText, long nNewIndex )
//STRIP001 {
//STRIP001     if( IsValidIndex( nNewIndex ) && !aFieldArr[ nNewIndex ] )
//STRIP001     {
//STRIP001         aFieldArr[ nNewIndex ] = new String( rText );
//STRIP001         ++nFieldCount;
//STRIP001 
//STRIP001         if (pAccessible)
//STRIP001         {
//STRIP001             ::com::sun::star::uno::Reference < ::com::sun::star::accessibility::XAccessible > xTempAcc = xAccessible;
//STRIP001             if (xTempAcc.is())
//STRIP001                 pAccessible->AddField(nNewIndex);
//STRIP001             else
//STRIP001                 pAccessible = NULL;
//STRIP001         }
//STRIP001     }
//STRIP001 }

//STRIP001 void ScDPFieldWindow::DelField( long nDelIndex )
//STRIP001 {
//STRIP001     if( IsExistingIndex( nDelIndex  ) )
//STRIP001 	{
//STRIP001         DELETEZ( aFieldArr[ nDelIndex ] );
//STRIP001         for( long nIx = nDelIndex + 1; nIx < nFieldCount; ++nIx )
//STRIP001             aFieldArr[ nIx - 1 ] = aFieldArr[ nIx ];
//STRIP001 
//STRIP001         if (pAccessible) // before decrement fieldcount
//STRIP001         {
//STRIP001             ::com::sun::star::uno::Reference < ::com::sun::star::accessibility::XAccessible > xTempAcc = xAccessible;
//STRIP001             if (xTempAcc.is())
//STRIP001                 pAccessible->RemoveField(nDelIndex);
//STRIP001             else
//STRIP001                 pAccessible = NULL;
//STRIP001         }
//STRIP001 
//STRIP001         --nFieldCount;
//STRIP001         aFieldArr[ nFieldCount ] = NULL;
//STRIP001 		Redraw();
//STRIP001     }
//STRIP001 }

//STRIP001 void ScDPFieldWindow::ClearFields()
//STRIP001 {
//STRIP001     if( eType == TYPE_SELECT )
//STRIP001 	{
//STRIP001         ::com::sun::star::uno::Reference < ::com::sun::star::accessibility::XAccessible > xTempAcc = xAccessible;
//STRIP001         if (!xTempAcc.is() && pAccessible)
//STRIP001             pAccessible = NULL;
//STRIP001 
//STRIP001         while( nFieldCount > 0 )
//STRIP001         {
//STRIP001             DELETEZ( aFieldArr[ nFieldCount - 1 ] );
//STRIP001             if (pAccessible)
//STRIP001                 pAccessible->RemoveField(nFieldCount - 1);
//STRIP001 
//STRIP001             --nFieldCount;
//STRIP001         }
//STRIP001     }
//STRIP001 }

//STRIP001 void ScDPFieldWindow::SetFieldText( const String& rText, long nIndex )
//STRIP001 {
//STRIP001     if( IsExistingIndex( nIndex ) && aFieldArr[ nIndex ] )
//STRIP001 	{
//STRIP001         *(aFieldArr[ nIndex ]) = rText;
//STRIP001 		Redraw();
//STRIP001 
//STRIP001         if (pAccessible)
//STRIP001         {
//STRIP001             ::com::sun::star::uno::Reference < ::com::sun::star::accessibility::XAccessible > xTempAcc = xAccessible;
//STRIP001             if (xTempAcc.is())
//STRIP001                 pAccessible->FieldNameChange(nIndex);
//STRIP001             else
//STRIP001                 pAccessible = NULL;
//STRIP001         }
//STRIP001 	}
//STRIP001 }

//STRIP001 const String& ScDPFieldWindow::GetFieldText( long nIndex ) const
//STRIP001 {
//STRIP001     if( IsExistingIndex( nIndex ) && aFieldArr[ nIndex] )
//STRIP001         return *(aFieldArr[ nIndex ]);
//STRIP001     return EMPTY_STRING;
//STRIP001 }

//-------------------------------------------------------------------

//STRIP001 BOOL ScDPFieldWindow::AddField( const String& rText, const Point& rPos, long& rnIndex )
//STRIP001 {
//STRIP001     if ( nFieldCount == MAX_FIELDS )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001     long nNewIndex = 0;
//STRIP001     if( GetFieldIndex( rPos, nNewIndex ) )
//STRIP001 	{
//STRIP001         if( nNewIndex > nFieldCount )
//STRIP001             nNewIndex = nFieldCount;
//STRIP001 
//STRIP001         if( aFieldArr[ nNewIndex ] )
//STRIP001         {
//STRIP001             DBG_ASSERT( !aFieldArr[ nFieldSize - 1 ], "ScDPFieldWindow::AddField - overflow" );
//STRIP001             for( long nIx = nFieldCount; nIx > nNewIndex; --nIx )
//STRIP001                 aFieldArr[ nIx ] = aFieldArr[ nIx - 1 ];
//STRIP001         }
//STRIP001 
//STRIP001         aFieldArr[ nNewIndex ] = new String( rText );
//STRIP001         ++nFieldCount;
//STRIP001         nFieldSelected = nNewIndex;
//STRIP001 		Redraw();
//STRIP001         rnIndex = nNewIndex;
//STRIP001 
//STRIP001         if (pAccessible)
//STRIP001         {
//STRIP001             ::com::sun::star::uno::Reference < ::com::sun::star::accessibility::XAccessible > xTempAcc = xAccessible;
//STRIP001             if (xTempAcc.is())
//STRIP001                 pAccessible->AddField(nNewIndex);
//STRIP001             else
//STRIP001                 pAccessible = NULL;
//STRIP001         }
//STRIP001 
//STRIP001         return TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return FALSE;
//STRIP001 }

//STRIP001 void ScDPFieldWindow::GetExistingIndex( const Point& rPos, long& rnIndex )
//STRIP001 {
//STRIP001     BOOL bFound = FALSE;
//STRIP001     if ( (eType != TYPE_SELECT) && GetFieldIndex( rPos, rnIndex ) )
//STRIP001     {
//STRIP001         if( rnIndex >= nFieldCount )
//STRIP001             rnIndex = nFieldCount - 1;
//STRIP001 	}
//STRIP001     else
//STRIP001         rnIndex = 0;
//STRIP001 }

//STRIP001 String ScDPFieldWindow::GetDescription()const
//STRIP001 {
//STRIP001     String sDescription;
//STRIP001     switch( eType )
//STRIP001 	{
//STRIP001 		case TYPE_COL:
//STRIP001             sDescription = ScResId(STR_ACC_DATAPILOT_COL_DESCR);
//STRIP001 		break;
//STRIP001 		case TYPE_ROW:
//STRIP001             sDescription = ScResId(STR_ACC_DATAPILOT_ROW_DESCR);
//STRIP001 		break;
//STRIP001 		case TYPE_DATA:
//STRIP001             sDescription = ScResId(STR_ACC_DATAPILOT_DATA_DESCR);
//STRIP001 		break;
//STRIP001 		case TYPE_SELECT:
//STRIP001             sDescription = ScResId(STR_ACC_DATAPILOT_SEL_DESCR);
//STRIP001         break;
//STRIP001     }
//STRIP001     return sDescription;
//STRIP001 }

//STRIP001 ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > ScDPFieldWindow::CreateAccessible()
//STRIP001 {
//STRIP001 	pAccessible =
//STRIP001 		new ScAccessibleDataPilotControl(GetAccessibleParentWindow()->GetAccessible(), this);
//STRIP001 
//STRIP001 	::com::sun::star::uno::Reference < ::com::sun::star::accessibility::XAccessible > xReturn = pAccessible;
//STRIP001 
//STRIP001 	pAccessible->Init();
//STRIP001     xAccessible = xReturn;
//STRIP001 
//STRIP001 	return xReturn;
//STRIP001 }
//===================================================================

}
