/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_transobj.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:49:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// INCLUDE ---------------------------------------------------------------

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

#include "scitems.hxx"
// auto strip #include <bf_svx/eeitem.hxx>
#define ITEMID_FIELD EE_FEATURE_FIELD

// auto strip #include <com/sun/star/uno/Sequence.hxx>

// auto strip #include <so3/svstor.hxx>
// auto strip #include <vcl/svapp.hxx>
// auto strip #include <vcl/virdev.hxx>
// auto strip #include <vos/mutex.hxx>
#include <bf_sfx2/app.hxx>

#include "transobj.hxx"
// auto strip #include "document.hxx"
// auto strip #include "viewopti.hxx"
// auto strip #include "editutil.hxx"
// auto strip #include "impex.hxx"
// auto strip #include "cell.hxx"
// auto strip #include "printfun.hxx"
// auto strip #include "docfunc.hxx"
#include "scmod.hxx"

// for InitDocShell
// auto strip #include <bf_svx/paperinf.hxx>
// auto strip #include <bf_svx/sizeitem.hxx>
// auto strip #include <bf_svx/algitem.hxx>
// auto strip #include <svtools/intitem.hxx>
// auto strip #include <svtools/zforlist.hxx>
// auto strip #include "docsh.hxx"
// auto strip #include "markdata.hxx"
// auto strip #include "stlpool.hxx"
// auto strip #include "viewdata.hxx"
// auto strip #include "dociter.hxx"
#include "cellsuno.hxx"
namespace binfilter {

using namespace ::com::sun::star;

// -----------------------------------------------------------------------

#define SCTRANS_TYPE_IMPEX			1
#define SCTRANS_TYPE_EDIT_RTF		2
#define SCTRANS_TYPE_EDIT_BIN		3
#define SCTRANS_TYPE_EMBOBJ			4

// -----------------------------------------------------------------------

// static
//STRIP001 void ScTransferObj::GetAreaSize( ScDocument* pDoc, USHORT nTab1, USHORT nTab2, USHORT& nRow, USHORT& nCol )
//STRIP001 {
//STRIP001 	USHORT nMaxCol = 0, nMaxRow = 0;
//STRIP001 	for( USHORT nTab = nTab1; nTab <= nTab2; nTab++ )
//STRIP001 	{
//STRIP001 		USHORT nLastCol = 0, nLastRow = 0;
//STRIP001 		// GetPrintArea instead of GetCellArea - include drawing objects
//STRIP001 		if( pDoc->GetPrintArea( nTab, nLastCol, nLastRow ) )
//STRIP001 		{
//STRIP001 			if( nLastCol > nMaxCol )
//STRIP001 				nMaxCol = nLastCol;
//STRIP001 			if( nLastRow > nMaxRow  )
//STRIP001 				nMaxRow = nLastRow;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	nRow = nMaxRow;
//STRIP001 	nCol = nMaxCol;
//STRIP001 }

// static
//STRIP001 void ScTransferObj::PaintToDev( OutputDevice* pDev, ScDocument* pDoc, double nPrintFactor,
//STRIP001 								const ScRange& rBlock, BOOL bMetaFile )
//STRIP001 {
//STRIP001 	if (!pDoc)
//STRIP001 		return;
//STRIP001 
//STRIP001 	Point aPoint;
//STRIP001 	Rectangle aBound( aPoint, pDev->GetOutputSize() ); 		//! use size from clip area?
//STRIP001 
//STRIP001 	ScViewData aViewData(NULL,NULL);
//STRIP001 	aViewData.InitData( pDoc );
//STRIP001 
//STRIP001 	aViewData.SetTabNo( rBlock.aEnd.Tab() );
//STRIP001 	aViewData.SetScreen( rBlock.aStart.Col(), rBlock.aStart.Row(),
//STRIP001 							rBlock.aEnd.Col(), rBlock.aEnd.Row() );
//STRIP001 
//STRIP001 	ScPrintFunc::DrawToDev( pDoc, pDev, nPrintFactor, aBound, &aViewData, bMetaFile );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 ScTransferObj::ScTransferObj( ScDocument* pClipDoc, const TransferableObjectDescriptor& rDesc ) :
//STRIP001 	aObjDesc( rDesc ),
//STRIP001 	pDoc( pClipDoc ),
//STRIP001 	nDragHandleX( 0 ),
//STRIP001 	nDragHandleY( 0 ),
//STRIP001 	nDragSourceFlags( 0 ),
//STRIP001 	bDragWasInternal( FALSE ),
//STRIP001 	bUsedForLink( FALSE )
//STRIP001 {
//STRIP001 	DBG_ASSERT(pDoc->IsClipboard(), "wrong document");
//STRIP001 
//STRIP001 	//
//STRIP001 	// get aBlock from clipboard doc
//STRIP001 	//
//STRIP001 
//STRIP001 	USHORT nCol1;
//STRIP001 	USHORT nRow1;
//STRIP001 	USHORT nCol2;
//STRIP001 	USHORT nRow2;
//STRIP001 	pDoc->GetClipStart( nCol1, nRow1 );
//STRIP001 	pDoc->GetClipArea( nCol2, nRow2, TRUE );	// real source area - include filtered rows
//STRIP001 	nCol2 += nCol1;
//STRIP001 	nRow2 += nRow1;
//STRIP001 
//STRIP001 	USHORT nDummy;
//STRIP001 	pDoc->GetClipArea( nDummy, nNonFiltered, FALSE );
//STRIP001 	++nNonFiltered;		// to get count instead of diff
//STRIP001 
//STRIP001 	USHORT nTab1=0;
//STRIP001 	USHORT nTab2=0;
//STRIP001 	BOOL bFirst = TRUE;
//STRIP001 	for (USHORT i=0; i<=MAXTAB; i++)
//STRIP001 		if (pDoc->HasTable(i))
//STRIP001 		{
//STRIP001 			if (bFirst)
//STRIP001 				nTab1 = i;
//STRIP001 			nTab2 = i;
//STRIP001 			bFirst = FALSE;
//STRIP001 		}
//STRIP001 	DBG_ASSERT(!bFirst, "no sheet selected");
//STRIP001 
//STRIP001 	//	only limit to used cells if whole sheet was marked
//STRIP001 	//	(so empty cell areas can be copied)
//STRIP001 	if ( nCol2>=MAXCOL && nRow2>=MAXROW )
//STRIP001 	{
//STRIP001 		USHORT nMaxRow, nMaxCol;
//STRIP001 		GetAreaSize( pDoc, nTab1, nTab2, nMaxRow, nMaxCol );
//STRIP001 		if( nMaxRow < nRow2 )
//STRIP001 			nRow2 = nMaxRow;
//STRIP001 		if( nMaxCol < nCol2 )
//STRIP001 			nCol2 = nMaxCol;
//STRIP001 	}
//STRIP001 
//STRIP001 	aBlock = ScRange( nCol1, nRow1, nTab1, nCol2, nRow2, nTab2 );
//STRIP001 	nVisibleTab = nTab1;	// valid table as default
//STRIP001 
//STRIP001 	Rectangle aMMRect = pDoc->GetMMRect( nCol1,nRow1, nCol2,nRow2, nTab1 );
//STRIP001     aObjDesc.maSize = aMMRect.GetSize();
//STRIP001 }

//STRIP001 ScTransferObj::~ScTransferObj()
//STRIP001 {
//STRIP001 	Application::GetSolarMutex().acquire();
//STRIP001 
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	if ( pScMod->GetClipData().pCellClipboard == this )
//STRIP001 	{
//STRIP001 		DBG_ERROR("ScTransferObj wasn't released");
//STRIP001 		pScMod->SetClipObject( NULL, NULL );
//STRIP001 	}
//STRIP001 	if ( pScMod->GetDragData().pCellTransfer == this )
//STRIP001 	{
//STRIP001 		DBG_ERROR("ScTransferObj wasn't released");
//STRIP001 		pScMod->ResetDragObject();
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pDoc;		// ScTransferObj is owner of clipboard document
//STRIP001 
//STRIP001 	aDocShellRef.Clear();	// before releasing the mutex
//STRIP001 
//STRIP001     aDrawPersistRef.Clear();                    // after the model
//STRIP001 
//STRIP001 	Application::GetSolarMutex().release();
//STRIP001 }

// static
/*N*/ ScTransferObj* ScTransferObj::GetOwnClipboard( Window* pUIWin )
/*N*/ {
/*N*/ 	ScTransferObj* pObj = SC_MOD()->GetClipData().pCellClipboard;
/*N*/ 	if ( pObj && pUIWin )
/*N*/ 	{
/*?*/ 		//	check formats to see if pObj is really in the system clipboard
/*?*/ 
/*?*/ 		//	pUIWin is NULL when called from core (IsClipboardSource),
/*?*/ 		//	in that case don't access the system clipboard, because the call
/*?*/ 		//	may be from other clipboard operations (like flushing, #86059#)
/*?*/ 
/*?*/ 		TransferableDataHelper aDataHelper( TransferableDataHelper::CreateFromSystemClipboard( pUIWin ) );
/*?*/ 		if ( !aDataHelper.HasFormat( SOT_FORMATSTR_ID_DIF ) )
/*?*/ 		{
/*?*/ //			DBG_ERROR("ScTransferObj wasn't released");
/*?*/ 			pObj = NULL;
/*?*/ 		}
/*N*/ 	}
/*N*/ 	return pObj;
/*N*/ }

//STRIP001 void ScTransferObj::AddSupportedFormats()
//STRIP001 {
//STRIP001 	AddFormat( SOT_FORMATSTR_ID_EMBED_SOURCE );
//STRIP001 	AddFormat( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR );
//STRIP001 	AddFormat( SOT_FORMAT_GDIMETAFILE );
//STRIP001 	AddFormat( SOT_FORMAT_BITMAP );
//STRIP001 
//STRIP001 	// ScImportExport formats
//STRIP001 	AddFormat( SOT_FORMATSTR_ID_HTML );
//STRIP001 	AddFormat( SOT_FORMATSTR_ID_SYLK );
//STRIP001 	AddFormat( SOT_FORMATSTR_ID_LINK );
//STRIP001 	AddFormat( SOT_FORMATSTR_ID_DIF );
//STRIP001 	AddFormat( SOT_FORMAT_STRING );
//STRIP001 
//STRIP001 	AddFormat( SOT_FORMAT_RTF );
//STRIP001 	if ( aBlock.aStart == aBlock.aEnd )
//STRIP001 		AddFormat( SOT_FORMATSTR_ID_EDITENGINE );
//STRIP001 }

//STRIP001 sal_Bool ScTransferObj::GetData( const datatransfer::DataFlavor& rFlavor )
//STRIP001 {
//STRIP001 	sal_uInt32	nFormat = SotExchange::GetFormat( rFlavor );
//STRIP001 	sal_Bool	bOK = sal_False;
//STRIP001 
//STRIP001 	if( HasFormat( nFormat ) )
//STRIP001 	{
//STRIP001 		if ( nFormat == SOT_FORMATSTR_ID_LINKSRCDESCRIPTOR || nFormat == SOT_FORMATSTR_ID_OBJECTDESCRIPTOR )
//STRIP001 		{
//STRIP001 			bOK = SetTransferableObjectDescriptor( aObjDesc, rFlavor );
//STRIP001 		}
//STRIP001 		else if ( ( nFormat == SOT_FORMAT_RTF || nFormat == SOT_FORMATSTR_ID_EDITENGINE ) &&
//STRIP001 						aBlock.aStart == aBlock.aEnd )
//STRIP001 		{
//STRIP001 			//	RTF from a single cell is handled by EditEngine
//STRIP001 
//STRIP001 			USHORT nCol = aBlock.aStart.Col();
//STRIP001 			USHORT nRow = aBlock.aStart.Row();
//STRIP001 			USHORT nTab = aBlock.aStart.Tab();
//STRIP001 
//STRIP001 			const ScPatternAttr* pPattern = pDoc->GetPattern( nCol, nRow, nTab );
//STRIP001 			ScTabEditEngine aEngine( *pPattern, pDoc->GetEditPool() );
//STRIP001 			ScBaseCell* pCell = NULL;
//STRIP001 			pDoc->GetCell( nCol, nRow, nTab, pCell );
//STRIP001 			if (pCell)
//STRIP001 			{
//STRIP001 				if (pCell->GetCellType() == CELLTYPE_EDIT)
//STRIP001 				{
//STRIP001 					const EditTextObject* pObj;
//STRIP001 					((ScEditCell*)pCell)->GetData(pObj);
//STRIP001 					aEngine.SetText( *pObj );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					String aText;
//STRIP001 					pDoc->GetString( nCol, nRow, nTab, aText );
//STRIP001 					aEngine.SetText(aText);
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			bOK = SetObject( &aEngine,
//STRIP001 							(nFormat == FORMAT_RTF) ? SCTRANS_TYPE_EDIT_RTF : SCTRANS_TYPE_EDIT_BIN,
//STRIP001 							rFlavor );
//STRIP001 		}
//STRIP001 		else if ( ScImportExport::IsFormatSupported( nFormat ) || nFormat == SOT_FORMAT_RTF )
//STRIP001 		{
//STRIP001 			//	if this transfer object was used to create a DDE link, filtered rows
//STRIP001 			//	have to be included for subsequent calls (to be consistent with link data)
//STRIP001 			if ( nFormat == SOT_FORMATSTR_ID_LINK )
//STRIP001 				bUsedForLink = TRUE;
//STRIP001 
//STRIP001 			BOOL bIncludeFiltered = pDoc->IsCutMode() || bUsedForLink;
//STRIP001 
//STRIP001 			ScImportExport aObj( pDoc, aBlock );
//STRIP001 			aObj.SetFormulas( pDoc->GetViewOptions().GetOption( VOPT_FORMULAS ) );
//STRIP001 			aObj.SetIncludeFiltered( bIncludeFiltered );
//STRIP001 
//STRIP001 			//	DataType depends on format type:
//STRIP001 
//STRIP001 			if ( rFlavor.DataType.equals( ::getCppuType( (const ::rtl::OUString*) 0 ) ) )
//STRIP001 			{
//STRIP001 				::rtl::OUString aString;
//STRIP001 				if ( aObj.ExportString( aString, nFormat ) )
//STRIP001 					bOK = SetString( aString, rFlavor );
//STRIP001 			}
//STRIP001 			else if ( rFlavor.DataType.equals( ::getCppuType( (const uno::Sequence< sal_Int8 >*) 0 ) ) )
//STRIP001 			{
//STRIP001 				//	SetObject converts a stream into a Int8-Sequence
//STRIP001 				bOK = SetObject( &aObj, SCTRANS_TYPE_IMPEX, rFlavor );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				DBG_ERROR("unknown DataType");
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if ( nFormat == SOT_FORMAT_BITMAP )
//STRIP001 		{
//STRIP001 			Rectangle aMMRect = pDoc->GetMMRect( aBlock.aStart.Col(), aBlock.aStart.Row(),
//STRIP001 												 aBlock.aEnd.Col(), aBlock.aEnd.Row(),
//STRIP001 												 aBlock.aStart.Tab() );
//STRIP001 			VirtualDevice aVirtDev;
//STRIP001 			aVirtDev.SetOutputSizePixel( aVirtDev.LogicToPixel( aMMRect.GetSize(), MAP_100TH_MM ) );
//STRIP001 
//STRIP001 			PaintToDev( &aVirtDev, pDoc, 1.0, aBlock, FALSE );
//STRIP001 
//STRIP001 			aVirtDev.SetMapMode( MapMode( MAP_PIXEL ) );
//STRIP001 			Bitmap aBmp = aVirtDev.GetBitmap( Point(), aVirtDev.GetOutputSize() );
//STRIP001 			bOK = SetBitmap( aBmp, rFlavor );
//STRIP001 		}
//STRIP001 		else if ( nFormat == SOT_FORMAT_GDIMETAFILE )
//STRIP001 		{
//STRIP001 			InitDocShell();
//STRIP001 			SvEmbeddedObject* pEmbObj = aDocShellRef;
//STRIP001 
//STRIP001 			// like SvEmbeddedTransfer::GetData:
//STRIP001 
//STRIP001 			GDIMetaFile		aMtf;
//STRIP001 			VirtualDevice	aVDev;
//STRIP001 			MapMode			aMapMode( pEmbObj->GetMapUnit() );
//STRIP001 			Rectangle		aVisArea( pEmbObj->GetVisArea( ASPECT_CONTENT ) );
//STRIP001 
//STRIP001 			aVDev.EnableOutput( FALSE );
//STRIP001 			aVDev.SetMapMode( aMapMode );
//STRIP001 			aMtf.SetPrefSize( aVisArea.GetSize() );
//STRIP001 			aMtf.SetPrefMapMode( aMapMode );
//STRIP001 			aMtf.Record( &aVDev );
//STRIP001 			
//STRIP001 			pEmbObj->DoDraw( &aVDev, Point(), aVisArea.GetSize(), JobSetup(), ASPECT_CONTENT );
//STRIP001 
//STRIP001 			aMtf.Stop();
//STRIP001 			aMtf.WindStart();
//STRIP001 
//STRIP001 			bOK = SetGDIMetaFile( aMtf, rFlavor );
//STRIP001 		}
//STRIP001 		else if ( nFormat == SOT_FORMATSTR_ID_EMBED_SOURCE )
//STRIP001 		{
//STRIP001 			InitDocShell();			// set aDocShellRef
//STRIP001 
//STRIP001 			SvEmbeddedObject* pEmbObj = aDocShellRef;
//STRIP001 			bOK = SetObject( pEmbObj, SCTRANS_TYPE_EMBOBJ, rFlavor );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bOK;
//STRIP001 }

//STRIP001 sal_Bool ScTransferObj::WriteObject( SotStorageStreamRef& rxOStm, void* pUserObject, sal_uInt32 nUserObjectId,
//STRIP001 										const datatransfer::DataFlavor& rFlavor )
//STRIP001 {
//STRIP001 	// called from SetObject, put data into stream
//STRIP001 
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001 	switch (nUserObjectId)
//STRIP001 	{
//STRIP001 		case SCTRANS_TYPE_IMPEX:
//STRIP001 			{
//STRIP001 				ScImportExport* pImpEx = (ScImportExport*)pUserObject;
//STRIP001 
//STRIP001 				sal_uInt32 nFormat = SotExchange::GetFormat( rFlavor );
//STRIP001 				if ( pImpEx->ExportStream( *rxOStm, nFormat ) )
//STRIP001 					bRet = ( rxOStm->GetError() == ERRCODE_NONE );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SCTRANS_TYPE_EDIT_RTF:
//STRIP001 		case SCTRANS_TYPE_EDIT_BIN:
//STRIP001 			{
//STRIP001 				ScTabEditEngine* pEngine = (ScTabEditEngine*)pUserObject;
//STRIP001 				if ( nUserObjectId == SCTRANS_TYPE_EDIT_RTF )
//STRIP001 				{
//STRIP001 					pEngine->Write( *rxOStm, EE_FORMAT_RTF );
//STRIP001 					bRet = ( rxOStm->GetError() == ERRCODE_NONE );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					//	#107722# can't use Write for EditEngine format because that would
//STRIP001 					//	write old format without support for unicode characters.
//STRIP001 					//	Get the data from the EditEngine's transferable instead.
//STRIP001 
//STRIP001 					USHORT nParCnt = pEngine->GetParagraphCount();
//STRIP001 					if ( nParCnt == 0 )
//STRIP001 						nParCnt = 1;
//STRIP001 					ESelection aSel( 0, 0, nParCnt-1, pEngine->GetTextLen(nParCnt-1) );
//STRIP001 					
//STRIP001 					uno::Reference<datatransfer::XTransferable> xEditTrans = pEngine->CreateTransferable( aSel );
//STRIP001 					TransferableDataHelper aEditHelper( xEditTrans );
//STRIP001 
//STRIP001 					bRet = aEditHelper.GetSotStorageStream( rFlavor, rxOStm );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SCTRANS_TYPE_EMBOBJ:
//STRIP001 			{
//STRIP001 				SvEmbeddedObject* pEmbObj = (SvEmbeddedObject*)pUserObject;
//STRIP001 
//STRIP001 				SvStorageRef xWorkStore( new SvStorage( TRUE, *rxOStm ) );
//STRIP001 				rxOStm->SetBufferSize( 0xff00 );
//STRIP001 
//STRIP001 				// write document storage
//STRIP001 				pEmbObj->SetupStorage( xWorkStore );
//STRIP001 				bRet = pEmbObj->DoSaveAs( xWorkStore );
//STRIP001 				pEmbObj->DoSaveCompleted();
//STRIP001 				xWorkStore->Commit();
//STRIP001 				rxOStm->Commit();
//STRIP001 
//STRIP001 				bRet = ( rxOStm->GetError() == ERRCODE_NONE );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			DBG_ERROR("unknown object id");
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }

//STRIP001 void ScTransferObj::ObjectReleased()
//STRIP001 {
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	if ( pScMod->GetClipData().pCellClipboard == this )
//STRIP001 		pScMod->SetClipObject( NULL, NULL );
//STRIP001 
//STRIP001 	TransferableHelper::ObjectReleased();
//STRIP001 }

//STRIP001 void ScTransferObj::DragFinished( sal_Int8 nDropAction )
//STRIP001 {
//STRIP001 	if ( nDropAction == DND_ACTION_MOVE && !bDragWasInternal && !(nDragSourceFlags & SC_DROP_NAVIGATOR) )
//STRIP001 	{
//STRIP001 		//	move: delete source data
//STRIP001 		ScDocShell* pSourceSh = GetSourceDocShell();
//STRIP001 		if (pSourceSh)
//STRIP001 		{
//STRIP001 			ScMarkData aMarkData = GetSourceMarkData();
//STRIP001 			//	external drag&drop doesn't copy objects, so they also aren't deleted:
//STRIP001 			//	#105703# bApi=TRUE, don't show error messages from drag&drop
//STRIP001 			pSourceSh->GetDocFunc().DeleteContents( aMarkData, IDF_ALL & ~IDF_OBJECTS, TRUE, TRUE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	if ( pScMod->GetDragData().pCellTransfer == this )
//STRIP001 		pScMod->ResetDragObject();
//STRIP001 
//STRIP001 	xDragSourceRanges = NULL;		// don't keep source after dropping
//STRIP001 
//STRIP001 	TransferableHelper::DragFinished( nDropAction );
//STRIP001 }

//STRIP001 void ScTransferObj::SetDragHandlePos( USHORT nX, USHORT nY )
//STRIP001 {
//STRIP001 	nDragHandleX = nX;
//STRIP001 	nDragHandleY = nY;
//STRIP001 }

//STRIP001 void ScTransferObj::SetVisibleTab( USHORT nNew )
//STRIP001 {
//STRIP001 	nVisibleTab = nNew;
//STRIP001 }

//STRIP001 void ScTransferObj::SetDrawPersist( const SvEmbeddedObjectRef& rRef )
//STRIP001 {
//STRIP001     aDrawPersistRef = rRef;
//STRIP001 }

//STRIP001 void ScTransferObj::SetDragSource( ScDocShell* pSourceShell, const ScMarkData& rMark )
//STRIP001 {
//STRIP001 	ScRangeList aRanges;
//STRIP001 	rMark.FillRangeListWithMarks( &aRanges, FALSE );
//STRIP001 	xDragSourceRanges = new ScCellRangesObj( pSourceShell, aRanges );
//STRIP001 }

//STRIP001 void ScTransferObj::SetDragSourceFlags( USHORT nFlags )
//STRIP001 {
//STRIP001 	nDragSourceFlags = nFlags;
//STRIP001 }

//STRIP001 void ScTransferObj::SetDragWasInternal()
//STRIP001 {
//STRIP001 	bDragWasInternal = TRUE;
//STRIP001 }

//STRIP001 ScDocument* ScTransferObj::GetSourceDocument()
//STRIP001 {
//STRIP001 	ScDocShell* pSourceDocSh = GetSourceDocShell();
//STRIP001 	if (pSourceDocSh)
//STRIP001 		return pSourceDocSh->GetDocument();
//STRIP001 	return NULL;
//STRIP001 }

//STRIP001 ScDocShell* ScTransferObj::GetSourceDocShell()
//STRIP001 {
//STRIP001 	ScCellRangesBase* pRangesObj = ScCellRangesBase::getImplementation( xDragSourceRanges );
//STRIP001 	if (pRangesObj)
//STRIP001 		return pRangesObj->GetDocShell();
//STRIP001 	
//STRIP001 	return NULL;	// none set
//STRIP001 }

ScMarkData ScTransferObj::GetSourceMarkData()
{
	ScMarkData aMarkData;
	ScCellRangesBase* pRangesObj = ScCellRangesBase::getImplementation( xDragSourceRanges );
	if (pRangesObj)
	{
		const ScRangeList& rRanges = pRangesObj->GetRangeList();
		aMarkData.MarkFromRangeList( rRanges, FALSE );
	}
	return aMarkData;
}

//
//	initialize aDocShellRef with a live document from the ClipDoc
//

//STRIP001 void ScTransferObj::InitDocShell()
//STRIP001 {
//STRIP001 	if ( !aDocShellRef.Is() )
//STRIP001 	{
//STRIP001 		ScDocShell* pDocSh = new ScDocShell;
//STRIP001 		aDocShellRef = pDocSh;		// ref must be there before InitNew
//STRIP001 
//STRIP001 		pDocSh->DoInitNew(NULL);
//STRIP001 
//STRIP001 		ScDocument* pDestDoc = pDocSh->GetDocument();
//STRIP001 		ScMarkData aDestMark;
//STRIP001 		aDestMark.SelectTable( 0, TRUE );
//STRIP001 
//STRIP001 		String aTabName;
//STRIP001 		pDoc->GetName( aBlock.aStart.Tab(), aTabName );
//STRIP001 		pDestDoc->RenameTab( 0, aTabName, FALSE );			// no UpdateRef (empty)
//STRIP001 
//STRIP001 		pDestDoc->CopyStdStylesFrom( pDoc );
//STRIP001 
//STRIP001 		USHORT nStartX = aBlock.aStart.Col();
//STRIP001 		USHORT nStartY = aBlock.aStart.Row();
//STRIP001 		USHORT nEndX = aBlock.aEnd.Col();
//STRIP001 		USHORT nEndY = aBlock.aEnd.Row();
//STRIP001 
//STRIP001 		//	widths / heights
//STRIP001 		//	(must be copied before CopyFromClip, for drawing objects)
//STRIP001 
//STRIP001 		USHORT nCol;
//STRIP001 		USHORT nRow;
//STRIP001 		USHORT nSrcTab = aBlock.aStart.Tab();
//STRIP001 		for (nCol=nStartX; nCol<=nEndX; nCol++)
//STRIP001 			if ( pDoc->GetColFlags( nCol, nSrcTab ) & CR_HIDDEN )
//STRIP001 				pDestDoc->ShowCol( nCol, 0, FALSE );
//STRIP001 			else
//STRIP001 				pDestDoc->SetColWidth( nCol, 0, pDoc->GetColWidth( nCol, nSrcTab ) );
//STRIP001 		for (nRow=nStartY; nRow<=nEndY; nRow++)
//STRIP001 		{
//STRIP001 			BYTE nSourceFlags = pDoc->GetRowFlags( nRow, nSrcTab );
//STRIP001 			if ( nSourceFlags & CR_HIDDEN )
//STRIP001 				pDestDoc->ShowRow( nRow, 0, FALSE );
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pDestDoc->SetRowHeight( nRow, 0, pDoc->GetRowHeight( nRow, nSrcTab ) );
//STRIP001 
//STRIP001 				//	if height was set manually, that flag has to be copied, too
//STRIP001 				if ( nSourceFlags & CR_MANUALSIZE )
//STRIP001 					pDestDoc->SetRowFlags( nRow, 0, pDestDoc->GetRowFlags( nRow, 0 ) | CR_MANUALSIZE );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pDoc->GetDrawLayer() )
//STRIP001 			pDocSh->MakeDrawLayer();
//STRIP001 
//STRIP001 		//	cell range is copied to the original position, but on the first sheet
//STRIP001 		//	-> bCutMode must be set
//STRIP001 		//	pDoc is always a Clipboard-document
//STRIP001 
//STRIP001 		ScRange aDestRange( nStartX,nStartY,0, nEndX,nEndY,0 );
//STRIP001 		BOOL bWasCut = pDoc->IsCutMode();
//STRIP001 		if (!bWasCut)
//STRIP001 			pDoc->SetClipArea( aDestRange, TRUE );			// Cut
//STRIP001 		pDestDoc->CopyFromClip( aDestRange, aDestMark, IDF_ALL, NULL, pDoc, FALSE );
//STRIP001 		pDoc->SetClipArea( aDestRange, bWasCut );
//STRIP001 
//STRIP001 		StripRefs( pDoc, nStartX,nStartY, nEndX,nEndY, pDestDoc, 0,0 );
//STRIP001 
//STRIP001 		ScRange aMergeRange = aDestRange;
//STRIP001 		pDestDoc->ExtendMerge( aMergeRange, TRUE );
//STRIP001 
//STRIP001 		pDoc->CopyDdeLinks( pDestDoc );			// copy values of DDE Links
//STRIP001 
//STRIP001 		//	page format (grid etc) and page size (maximum size for ole object)
//STRIP001 
//STRIP001 		Size aPaperSize = SvxPaperInfo::GetPaperSize( SVX_PAPER_A4 );		// Twips
//STRIP001 		ScStyleSheetPool* pStylePool = pDoc->GetStyleSheetPool();
//STRIP001 		String aStyleName = pDoc->GetPageStyle( aBlock.aStart.Tab() );
//STRIP001 		SfxStyleSheetBase* pStyleSheet = pStylePool->Find( aStyleName, SFX_STYLE_FAMILY_PAGE );
//STRIP001 		if (pStyleSheet)
//STRIP001 		{
//STRIP001 			const SfxItemSet& rSourceSet = pStyleSheet->GetItemSet();
//STRIP001 			aPaperSize = ((const SvxSizeItem&) rSourceSet.Get(ATTR_PAGE_SIZE)).GetSize();
//STRIP001 
//STRIP001 			//	CopyStyleFrom kopiert SetItems mit richtigem Pool
//STRIP001 			ScStyleSheetPool* pDestPool = pDestDoc->GetStyleSheetPool();
//STRIP001 			pDestPool->CopyStyleFrom( pStylePool, aStyleName, SFX_STYLE_FAMILY_PAGE );
//STRIP001 		}
//STRIP001 
//STRIP001 		ScViewData aViewData( pDocSh, NULL );
//STRIP001 		aViewData.SetScreen( nStartX,nStartY, nEndX,nEndY );
//STRIP001 		aViewData.SetCurX( nStartX );
//STRIP001 		aViewData.SetCurY( nStartY );
//STRIP001 
//STRIP001 		pDestDoc->SetViewOptions( pDoc->GetViewOptions() );
//STRIP001 
//STRIP001 		//		Size
//STRIP001 		//! get while copying sizes
//STRIP001 
//STRIP001 		long nPosX = 0;
//STRIP001 		long nPosY = 0;
//STRIP001 
//STRIP001 		for (nCol=0; nCol<nStartX; nCol++)
//STRIP001 			nPosX += pDestDoc->GetColWidth( nCol, 0 );
//STRIP001 		for (nRow=0; nRow<nStartY; nRow++)
//STRIP001 			nPosY += pDestDoc->FastGetRowHeight( nRow, 0 );
//STRIP001 		nPosX = (long) ( nPosX * HMM_PER_TWIPS );
//STRIP001 		nPosY = (long) ( nPosY * HMM_PER_TWIPS );
//STRIP001 
//STRIP001 
//STRIP001 		aPaperSize.Width()  *= 2;		// limit OLE object to double of page size
//STRIP001 		aPaperSize.Height() *= 2;
//STRIP001 
//STRIP001 		long nSizeX = 0;
//STRIP001 		long nSizeY = 0;
//STRIP001 		for (nCol=nStartX; nCol<=nEndX; nCol++)
//STRIP001 		{
//STRIP001 			long nAdd = pDestDoc->GetColWidth( nCol, 0 );
//STRIP001 			if ( nSizeX+nAdd > aPaperSize.Width() && nSizeX )	// above limit?
//STRIP001 				break;
//STRIP001 			nSizeX += nAdd;
//STRIP001 		}
//STRIP001 		for (nRow=nStartY; nRow<=nEndY; nRow++)
//STRIP001 		{
//STRIP001 			long nAdd = pDestDoc->FastGetRowHeight( nRow, 0 );
//STRIP001 			if ( nSizeY+nAdd > aPaperSize.Height() && nSizeY )	// above limit?
//STRIP001 				break;
//STRIP001 			nSizeY += nAdd;
//STRIP001 		}
//STRIP001 		nSizeX = (long) ( nSizeX * HMM_PER_TWIPS );
//STRIP001 		nSizeY = (long) ( nSizeY * HMM_PER_TWIPS );
//STRIP001 
//STRIP001 //		pDocSh->SetVisAreaSize( Size(nSizeX,nSizeY) );
//STRIP001 
//STRIP001 		Rectangle aNewArea( Point(nPosX,nPosY), Size(nSizeX,nSizeY) );
//STRIP001 		pDocSh->SvInPlaceObject::SetVisArea( aNewArea );
//STRIP001 		pDocSh->SetVisArea( aNewArea );
//STRIP001 
//STRIP001 		pDocSh->UpdateOle(&aViewData, TRUE);
//STRIP001 
//STRIP001 		//!	SetDocumentModified?
//STRIP001 		if ( pDestDoc->IsChartListenerCollectionNeedsUpdate() )
//STRIP001 			pDestDoc->UpdateChartListenerCollection();
//STRIP001 	}
//STRIP001 }

//	static
//STRIP001 SvPersist* ScTransferObj::SetDrawClipDoc( BOOL bAnyOle )
//STRIP001 {
//STRIP001 	// update ScGlobal::pDrawClipDocShellRef
//STRIP001 
//STRIP001     delete ScGlobal::pDrawClipDocShellRef;
//STRIP001     if (bAnyOle)
//STRIP001     {
//STRIP001         ScGlobal::pDrawClipDocShellRef =
//STRIP001                         new ScDocShellRef(new ScDocShell);      // there must be a ref
//STRIP001         (*ScGlobal::pDrawClipDocShellRef)->DoInitNew(NULL);
//STRIP001         return *ScGlobal::pDrawClipDocShellRef;
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         ScGlobal::pDrawClipDocShellRef = NULL;
//STRIP001         return NULL;
//STRIP001     }
//STRIP001 }

//	static
//STRIP001 void ScTransferObj::StripRefs( ScDocument* pDoc,
//STRIP001 					USHORT nStartX, USHORT nStartY, USHORT nEndX, USHORT nEndY,
//STRIP001 					ScDocument* pDestDoc, USHORT nSubX, USHORT nSubY )
//STRIP001 {
//STRIP001 	if (!pDestDoc)
//STRIP001 	{
//STRIP001 		pDestDoc = pDoc;
//STRIP001 		DBG_ASSERT(nSubX==0&&nSubY==0, "can't move within the document");
//STRIP001 	}
//STRIP001 
//STRIP001 	//	In a clipboard doc the data don't have to be on the first sheet
//STRIP001 
//STRIP001 	USHORT nSrcTab = 0;
//STRIP001 	while (nSrcTab<MAXTAB && !pDoc->HasTable(nSrcTab))
//STRIP001 		++nSrcTab;
//STRIP001 	USHORT nDestTab = 0;
//STRIP001 	while (nDestTab<MAXTAB && !pDestDoc->HasTable(nDestTab))
//STRIP001 		++nDestTab;
//STRIP001 
//STRIP001 	if (!pDoc->HasTable(nSrcTab) || !pDestDoc->HasTable(nDestTab))
//STRIP001 	{
//STRIP001 		DBG_ERROR("Sheet not found in ScTransferObj::StripRefs");
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	SvNumberFormatter* pFormatter = pDoc->GetFormatTable();
//STRIP001 	ScTripel aStart, aEnd;
//STRIP001 
//STRIP001 	ScCellIterator aIter( pDoc, nStartX, nStartY, nSrcTab, nEndX, nEndY, nSrcTab );
//STRIP001 	ScBaseCell* pCell = aIter.GetFirst();
//STRIP001 	while (pCell)
//STRIP001 	{
//STRIP001 		if (pCell->GetCellType() == CELLTYPE_FORMULA)
//STRIP001 		{
//STRIP001 			ScFormulaCell* pFCell = (ScFormulaCell*) pCell;
//STRIP001 			BOOL bOut = FALSE;
//STRIP001 			ScDetectiveRefIter aRefIter( pFCell );
//STRIP001 			while ( !bOut && aRefIter.GetNextRef( aStart, aEnd ) )
//STRIP001 			{
//STRIP001 				if ( aStart.GetTab() != nSrcTab || aEnd.GetTab() != nSrcTab ||
//STRIP001 						aStart.GetCol() < nStartX || aEnd.GetCol() > nEndX ||
//STRIP001 						aStart.GetRow() < nStartY || aEnd.GetRow() > nEndY )
//STRIP001 					bOut = TRUE;
//STRIP001 			}
//STRIP001 			if (bOut)
//STRIP001 			{
//STRIP001 				USHORT nCol = aIter.GetCol() - nSubX;
//STRIP001 				USHORT nRow = aIter.GetRow() - nSubY;
//STRIP001 
//STRIP001 				ScBaseCell* pNew = 0;
//STRIP001 				USHORT nErrCode = pFCell->GetErrCode();
//STRIP001 				if (nErrCode)
//STRIP001 				{
//STRIP001 					pNew = new ScStringCell( ScGlobal::GetErrorString(nErrCode) );
//STRIP001 					if ( ((const SvxHorJustifyItem*) pDestDoc->GetAttr(
//STRIP001 							nCol,nRow,nDestTab, ATTR_HOR_JUSTIFY))->GetValue() ==
//STRIP001 							SVX_HOR_JUSTIFY_STANDARD )
//STRIP001 						pDestDoc->ApplyAttr( nCol,nRow,nDestTab,
//STRIP001 								SvxHorJustifyItem(SVX_HOR_JUSTIFY_RIGHT, ATTR_HOR_JUSTIFY) );
//STRIP001 				}
//STRIP001 				else if (pFCell->IsValue())
//STRIP001 				{
//STRIP001 					double fVal = pFCell->GetValue();
//STRIP001 					pNew = new ScValueCell( fVal );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					String aStr;
//STRIP001 					pFCell->GetString(aStr);
//STRIP001 					pNew = new ScStringCell( aStr );
//STRIP001 				}
//STRIP001 				pDestDoc->PutCell( nCol,nRow,nDestTab, pNew );
//STRIP001 
//STRIP001 				//	number formats
//STRIP001 
//STRIP001 				ULONG nOldFormat = ((const SfxUInt32Item*)
//STRIP001 								pDestDoc->GetAttr(nCol,nRow,nDestTab, ATTR_VALUE_FORMAT))->GetValue();
//STRIP001 				if ( (nOldFormat % SV_COUNTRY_LANGUAGE_OFFSET) == 0 )
//STRIP001 				{
//STRIP001 					ULONG nNewFormat = pFCell->GetStandardFormat( *pFormatter,
//STRIP001 						nOldFormat );
//STRIP001 					pDestDoc->ApplyAttr( nCol,nRow,nDestTab,
//STRIP001 								SfxUInt32Item(ATTR_VALUE_FORMAT, nNewFormat) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		pCell = aIter.GetNext();
//STRIP001 	}
//STRIP001 }


}
