/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_sctictac.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:18:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/* Tic-Tac-Toe program by Steve Chapel schapel@cs.ucsb.edu
   Uses alpha-beta pruning minimax search to play a "perfect" game.
   The alpha-beta pruning can be removed, but will increase search time.
   The heuristic and move ordering in BestMove() can also be removed with
	 an increase in search time. */

#include <stdio.h>
#include <ctype.h>

#pragma hdrstop

// auto strip #include "sctictac.hxx"

#ifdef TICTACTOE_SC
// auto strip #include "document.hxx"
// auto strip #include "cell.hxx"
#endif
namespace binfilter {

//STRIP001 const Square_Type ScTicTacToe::Empty = ' ';
//STRIP001 const Square_Type ScTicTacToe::Human = 'X';
//STRIP001 const Square_Type ScTicTacToe::Compi = 'O';
//STRIP001 const int ScTicTacToe::Infinity = 10;		/* Higher value than any score */
//STRIP001 const int ScTicTacToe::Maximum_Moves = ScTicTacToe_Squares;	/* Maximum moves in a game */

/* Array describing the eight combinations of three squares in a row */
//STRIP001 const int ScTicTacToe::Three_in_a_Row[ScTicTacToe_Possible_Wins][3] = {
//STRIP001 	{ 0, 1, 2 },
//STRIP001 	{ 3, 4, 5 },
//STRIP001 	{ 6, 7, 8 },
//STRIP001 	{ 0, 3, 6 },
//STRIP001 	{ 1, 4, 7 },
//STRIP001 	{ 2, 5, 8 },
//STRIP001 	{ 0, 4, 8 },
//STRIP001 	{ 2, 4, 6 }
//STRIP001 };

/* Array used in heuristic formula for each move. */
//STRIP001 const int ScTicTacToe::Heuristic_Array[4][4] = {
//STRIP001 	{	  0,   -10,	 -100, -1000 },
//STRIP001 	{	 10,	 0,		0,	   0 },
//STRIP001 	{	100,	 0,		0,	   0 },
//STRIP001 	{  1000,	 0,		0,	   0 }
//STRIP001 };


//STRIP001 #ifdef TICTACTOE_SC
//STRIP001 ScTicTacToe::ScTicTacToe( ScDocument* pDocP, const ScAddress& rPos ) :
//STRIP001 		pDoc( pDocP ),
//STRIP001 		aPos( rPos ),
//STRIP001 		bInitialized( FALSE ),
//STRIP001 		aStdOut( "Computer plays O, you play X. " )
//STRIP001 {
//STRIP001 }
//STRIP001 #else
//STRIP001 ScTicTacToe::ScTicTacToe() :
//STRIP001 		bInitialized( FALSE ),
//STRIP001 		aStdOut( "Computer plays O, you play X. " )
//STRIP001 {
//STRIP001 }
//STRIP001 #endif


/* Return the other player */
//STRIP001 inline Square_Type ScTicTacToe::Other(Square_Type Player)
//STRIP001 {
//STRIP001 	return Player == Human ? Compi : Human;
//STRIP001 }


/* Make a move on the board */
//STRIP001 inline void ScTicTacToe::Play(int Square, Square_Type Player)
//STRIP001 {
//STRIP001 	Board[Square] = Player;
//STRIP001 }


//STRIP001 #ifdef TICTACTOE_STDOUT
//STRIP001 
//STRIP001 void ScTicTacToe::GetOutput( ByteString& rStr )
//STRIP001 {
//STRIP001 	 rStr = aStdOut;
//STRIP001 	 aStdOut.Erase();
//STRIP001 }

//STRIP001 #else // !TICTACTOE_STDOUT

//STRIP001 void ScTicTacToe::GetOutput( String& rStr )
//STRIP001 {
//STRIP001 	 rStr = String( aStdOut, gsl_getSystemTextEncoding() );
//STRIP001 	 aStdOut.Erase();
//STRIP001 }

//STRIP001 #endif // TICTACTOE_STDOUT


/* Clear the board */
//STRIP001 void ScTicTacToe::Initialize( BOOL bHumanFirst )
//STRIP001 {
//STRIP001 	bInitialized = TRUE;
//STRIP001 	aPlayer = (bHumanFirst ? Human : Compi);
//STRIP001 	nMove = 1;
//STRIP001 	for (int i = 0; i < ScTicTacToe_Squares; i++)
//STRIP001 		Board[i] = Empty;
//STRIP001 }


/* If a player has won, return the winner. If the game is a tie,
   return 'C' (for cat). If the game is not over, return Empty. */
//STRIP001 Square_Type ScTicTacToe::Winner()
//STRIP001 {
//STRIP001 	int i;
//STRIP001 	for (i = 0; i < ScTicTacToe_Possible_Wins; i++)
//STRIP001 	{
//STRIP001 		Square_Type Possible_Winner = Board[Three_in_a_Row[i][0]];
//STRIP001 		if (Possible_Winner != Empty &&
//STRIP001 			Possible_Winner == Board[Three_in_a_Row[i][1]] &&
//STRIP001 			Possible_Winner == Board[Three_in_a_Row[i][2]])
//STRIP001 			return Possible_Winner;
//STRIP001 	}
//STRIP001 
//STRIP001 	for (i = 0; i < ScTicTacToe_Squares; i++)
//STRIP001 	{
//STRIP001 		if (Board[i] == Empty)
//STRIP001 			return Empty;
//STRIP001 	}
//STRIP001 
//STRIP001 	return 'C';
//STRIP001 }


/* Return a heuristic used to determine the order in which the
   children of a node are searched */
//STRIP001 int ScTicTacToe::Evaluate(Square_Type Player)
//STRIP001 {
//STRIP001 	int i;
//STRIP001 	int Heuristic = 0;
//STRIP001 	for (i = 0; i < ScTicTacToe_Possible_Wins; i++)
//STRIP001 	{
//STRIP001 		int j;
//STRIP001 		int Players = 0, Others = 0;
//STRIP001 		for (j = 0; j < 3; j++)
//STRIP001 		{
//STRIP001 			Square_Type Piece = Board[Three_in_a_Row[i][j]];
//STRIP001 			if (Piece == Player)
//STRIP001 				Players++;
//STRIP001 			else if (Piece == Other(Player))
//STRIP001 				Others++;
//STRIP001 		}
//STRIP001 		Heuristic += Heuristic_Array[Players][Others];
//STRIP001 	}
//STRIP001 	return Heuristic;
//STRIP001 }


/* Return the score of the best move found for a board
   The square to move to is returned in *Square */
//STRIP001 int ScTicTacToe::BestMove(Square_Type Player, int *Square,
//STRIP001 		int Move_Nbr, int Alpha, int Beta)
//STRIP001 {
//STRIP001 	int Best_Square = -1;
//STRIP001 	int Moves = 0;
//STRIP001 	int i;
//STRIP001 	Move_Heuristic_Type Move_Heuristic[ScTicTacToe_Squares];
//STRIP001 
//STRIP001 	Total_Nodes++;
//STRIP001 
//STRIP001 	/* Find the heuristic for each move and sort moves in descending order */
//STRIP001 	for (i = 0; i < ScTicTacToe_Squares; i++)
//STRIP001 	{
//STRIP001 		if (Board[i] == Empty)
//STRIP001 		{
//STRIP001 			int Heuristic;
//STRIP001 			int j;
//STRIP001 			Play(i, Player);
//STRIP001 			Heuristic = Evaluate(Player);
//STRIP001 			Play(i, Empty);
//STRIP001 			for (j = Moves-1; j >= 0 &&
//STRIP001 					Move_Heuristic[j].Heuristic < Heuristic; j--)
//STRIP001 			{
//STRIP001 				Move_Heuristic[j + 1].Heuristic = Move_Heuristic[j].Heuristic;
//STRIP001 				Move_Heuristic[j + 1].Square = Move_Heuristic[j].Square;
//STRIP001 			}
//STRIP001 			Move_Heuristic[j + 1].Heuristic = Heuristic;
//STRIP001 			Move_Heuristic[j + 1].Square = i;
//STRIP001 			Moves++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	for (i = 0; i < Moves; i++)
//STRIP001 	{
//STRIP001 		int Score;
//STRIP001 		int Sq = Move_Heuristic[i].Square;
//STRIP001 		Square_Type W;
//STRIP001 
//STRIP001 		/* Make a move and get its score */
//STRIP001 		Play(Sq, Player);
//STRIP001 
//STRIP001 		W = Winner();
//STRIP001 		if (W == Compi)
//STRIP001 			Score = (Maximum_Moves + 1) - Move_Nbr;
//STRIP001 		else if (W == Human)
//STRIP001 			Score = Move_Nbr - (Maximum_Moves + 1);
//STRIP001 		else if (W == 'C')
//STRIP001 			Score = 0;
//STRIP001 		else
//STRIP001 			Score = BestMove(Other(Player), Square, Move_Nbr + 1,
//STRIP001 					Alpha, Beta);
//STRIP001 
//STRIP001 		Play(Sq, Empty);
//STRIP001 
//STRIP001 		/* Perform alpha-beta pruning */
//STRIP001 		if (Player == Compi)
//STRIP001 		{
//STRIP001 			if (Score >= Beta)
//STRIP001 			{
//STRIP001 				*Square = Sq;
//STRIP001 				return Score;
//STRIP001 			}
//STRIP001 			else if (Score > Alpha)
//STRIP001 			{
//STRIP001 				Alpha = Score;
//STRIP001 				Best_Square = Sq;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if (Score <= Alpha)
//STRIP001 			{
//STRIP001 				*Square = Sq;
//STRIP001 				return Score;
//STRIP001 			}
//STRIP001 			else if (Score < Beta)
//STRIP001 			{
//STRIP001 				Beta = Score;
//STRIP001 				Best_Square = Sq;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	*Square = Best_Square;
//STRIP001 	if (Player == Compi)
//STRIP001 		return Alpha;
//STRIP001 	else
//STRIP001 		return Beta;
//STRIP001 }


/* Provide an English description of the score returned by BestMove */
//STRIP001 void ScTicTacToe::Describe(int Score)
//STRIP001 {
//STRIP001 	if (Score < 0)
//STRIP001 		aStdOut += "You have a guaranteed win. ";
//STRIP001 	else if (Score == 0)
//STRIP001 		aStdOut += "I can guarantee a tie. ";
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aStdOut += "I have a guaranteed win by move ";
//STRIP001 		aStdOut += ByteString::CreateFromInt32( Maximum_Moves - Score + 1 );
//STRIP001 		aStdOut += ". ";
//STRIP001 	}
//STRIP001 }


/* Have the human or the computer move */
//STRIP001 void ScTicTacToe::Move( int& Square )
//STRIP001 {
//STRIP001 	if (aPlayer == Compi)
//STRIP001 	{
//STRIP001 		Total_Nodes = 0;
//STRIP001 		Describe(BestMove(aPlayer, &Square, nMove, -Infinity, Infinity));
//STRIP001 		aStdOut += ByteString::CreateFromInt32( Total_Nodes );
//STRIP001 		aStdOut += " nodes examined. ";
//STRIP001 		Play(Square, aPlayer);
//STRIP001 		aStdOut += "Move #";
//STRIP001 		aStdOut += ByteString::CreateFromInt32( nMove );
//STRIP001 		aStdOut += " - O moves to ";
//STRIP001 		aStdOut += ByteString::CreateFromInt32( Square + 1 );
//STRIP001 		aStdOut += ". ";
//STRIP001 		aPlayer = Other( aPlayer );
//STRIP001 		nMove++;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( Square < 0 || Square >= ScTicTacToe_Squares
//STRIP001 				|| Board[Square] != Empty )
//STRIP001 			Square = -1;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			Play(Square, aPlayer);
//STRIP001 			aPlayer = Other( aPlayer );
//STRIP001 			nMove++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


// Try a move
//STRIP001 Square_Type ScTicTacToe::TryMove( int& Square )
//STRIP001 {
//STRIP001 	if ( !bInitialized )
//STRIP001 		Initialize( FALSE );
//STRIP001 
//STRIP001 	Square_Type W = Winner();
//STRIP001 	if ( W == Empty )
//STRIP001 	{
//STRIP001 		Move( Square );
//STRIP001 #ifdef TICTACTOE_STDOUT
//STRIP001 		if ( aStdOut.Len() )
//STRIP001 		{
//STRIP001 			puts( aStdOut.GetBuffer() );
//STRIP001 			aStdOut.Erase();
//STRIP001 		}
//STRIP001 #endif
//STRIP001 		W = Winner();
//STRIP001 	}
//STRIP001 	if ( W == Empty )
//STRIP001 	{
//STRIP001 		if ( aPlayer == Human )
//STRIP001 			PromptHuman();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if (W != 'C')
//STRIP001 		{
//STRIP001 			aStdOut += W;
//STRIP001 			aStdOut += " wins!";
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aStdOut += "It's a tie.";
//STRIP001 	}
//STRIP001 	return W;
//STRIP001 }


//STRIP001 void ScTicTacToe::PromptHuman()
//STRIP001 {
//STRIP001 	aStdOut += "Move #";
//STRIP001 	aStdOut += ByteString::CreateFromInt32( nMove );
//STRIP001 	aStdOut += " - What is X's move?";
//STRIP001 }


//STRIP001 #ifdef TICTACTOE_SC

//STRIP001 void ScTicTacToe::DrawPos( int nSquare, const String& rStr )
//STRIP001 {
//STRIP001 	pDoc->SetString( aPos.Col()+(nSquare%3),
//STRIP001 		aPos.Row()+(nSquare/3), aPos.Tab(), rStr );
//STRIP001 }


//STRIP001 void ScTicTacToe::DrawBoard()
//STRIP001 {
//STRIP001 	String aStr;
//STRIP001 	for ( USHORT j = 0; j < ScTicTacToe_Squares; j++ )
//STRIP001 	{
//STRIP001 		aStr = Board[j];
//STRIP001 		DrawPos( j, aStr );
//STRIP001 	}
//STRIP001 }


// -1 == Fehler/Redraw, 0 == keine Aenderung, >0 == UserMoveSquare+1
//STRIP001 int ScTicTacToe::GetStatus()
//STRIP001 {
//STRIP001 	USHORT nCol, nRow, nTab;
//STRIP001 	nCol = aPos.Col();
//STRIP001 	nRow = aPos.Row();
//STRIP001 	nTab = aPos.Tab();
//STRIP001 	String aStr;
//STRIP001 	int nDiffs = 0;
//STRIP001 	int nSquare;
//STRIP001 	for ( USHORT j = 0; j < ScTicTacToe_Squares; j++ )
//STRIP001 	{
//STRIP001 		pDoc->GetString( nCol+(j%3), nRow+(j/3), nTab, aStr );
//STRIP001 		if ( !aStr.Len() )
//STRIP001 		{
//STRIP001 			if ( Board[j] != Empty )
//STRIP001 				return -1;			// wo was sein muss muss was sein
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aStr.ToUpperAscii();
//STRIP001 			if ( aStr.GetChar(0) != Board[j] )
//STRIP001 			{
//STRIP001 				if ( Board[j] != Empty )
//STRIP001 					return -1;		// bestehendes ueberschrieben
//STRIP001 									// bei erstem Move hat Human angefangen
//STRIP001 				if ( ++nDiffs > 1 )
//STRIP001 					return -1;		// mehr als eine Aenderung
//STRIP001 				nSquare = j;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if ( nDiffs == 1 )
//STRIP001 		return nSquare + 1;
//STRIP001 	return 0;
//STRIP001 }


//STRIP001 Square_Type ScTicTacToe::CalcMove()
//STRIP001 {
//STRIP001 	Square_Type W = Winner();
//STRIP001 	int nStat = GetStatus();
//STRIP001 	if ( nStat || (W == Empty && aPlayer == Compi) )
//STRIP001 	{
//STRIP001 		if ( nStat == -1 || (nStat > 0 && aPlayer == Compi) )
//STRIP001 			DrawBoard();
//STRIP001 		if ( W == Empty && aPlayer == Human )
//STRIP001 		{
//STRIP001 			if ( nStat > 0 )
//STRIP001 			{
//STRIP001 				int nSquare = --nStat;
//STRIP001 				W = TryMove( nStat );
//STRIP001 				if ( nStat == -1 )
//STRIP001 					DrawPos( nSquare, String( ' ' ) );
//STRIP001 				else
//STRIP001 					DrawPos( nStat, String( Human ) );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				PromptHuman();
//STRIP001 		}
//STRIP001 		if ( W == Empty && aPlayer == Compi )
//STRIP001 		{
//STRIP001 			W = TryMove( nStat );		// ComputerMove, nStat egal
//STRIP001 			DrawPos( nStat, String( Compi ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( W == Empty && aPlayer == Human )
//STRIP001 		PromptHuman();
//STRIP001 	return W;
//STRIP001 }

//STRIP001 #endif // TICTACTOE_SC


//STRIP001 #ifdef TICTACTOE_STDOUT
/* Print the board */
//STRIP001 void ScTicTacToe::Print()
//STRIP001 {
//STRIP001 	int i;
//STRIP001 	for (i = 0; i < ScTicTacToe_Squares; i += 3)
//STRIP001 	{
//STRIP001 		if (i > 0)
//STRIP001 			printf("---+---+---\n");
//STRIP001 		printf(" %c | %c | %c \n", Board[i], Board[i + 1], Board[i + 2]);
//STRIP001 	}
//STRIP001 	printf("\n");
//STRIP001 }


/* Play a game of tic-tac-toe */
//STRIP001 void ScTicTacToe::Game()
//STRIP001 {
//STRIP001 	if ( !bInitialized )
//STRIP001 		Initialize( FALSE );
//STRIP001 
//STRIP001 	int Square = (aPlayer == Compi ? 0 : -1);
//STRIP001 	Square_Type W = Winner();
//STRIP001 	while( W == Empty )
//STRIP001 	{
//STRIP001 		Print();
//STRIP001 		W = TryMove( Square );
//STRIP001 		if ( W == Empty )
//STRIP001 		{
//STRIP001 			if ( aPlayer == Human )
//STRIP001 			{
//STRIP001 				if ( Square != -1 )
//STRIP001 					Print();	// empty board already printed if human moves first
//STRIP001 				do
//STRIP001 				{
//STRIP001 					puts( aStdOut.GetBuffer() );
//STRIP001 					aStdOut.Erase();
//STRIP001 					scanf("%d", &Square);
//STRIP001 					Square--;
//STRIP001 					W = TryMove( Square );
//STRIP001 				} while ( Square == -1 );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	Print();
//STRIP001 	puts( aStdOut.GetBuffer() );
//STRIP001 	aStdOut.Erase();
//STRIP001 }
//STRIP001 #endif	// TICTACTOE_STDOUT


//STRIP001 #ifdef TICTACTOE_MAIN
//STRIP001 int main()
//STRIP001 {
//STRIP001 	char Answer[80];
//STRIP001 
//STRIP001 	printf("Welcome to Tic-Tac-Toe!\n\n");
//STRIP001 	printf("Here is the board numbering:\n");
//STRIP001 	printf(" 1 | 2 | 3\n");
//STRIP001 	printf("---+---+---\n");
//STRIP001 	printf(" 4 | 5 | 6\n");
//STRIP001 	printf("---+---+---\n");
//STRIP001 	printf(" 7 | 8 | 9\n");
//STRIP001 	printf("\n");
//STRIP001 //    printf("Computer plays X, you play O.\n");
//STRIP001 
//STRIP001 	ScTicTacToe aTTT;
//STRIP001 	ByteString aStr;
//STRIP001 	aTTT.GetOutput( aStr );
//STRIP001 	puts( aStr.GetBuffer() );
//STRIP001 
//STRIP001 	do
//STRIP001 	{
//STRIP001 		printf("\nDo you want to move first? ");
//STRIP001 		scanf("%s", Answer);
//STRIP001 		aTTT.Initialize( toupper(Answer[0]) == 'Y' );
//STRIP001 		aTTT.Game();
//STRIP001 		printf("\nDo you want to play again? ");
//STRIP001 		scanf("%s", Answer);
//STRIP001 	} while (toupper(Answer[0]) == 'Y');
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 #endif	// TICTACTOE_MAIN

}
