--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with GNAT.Sockets;

package body Narval.Actors.Actives.Stand_Alone_Actors.Example is

   ----------------------------
   -- Travail_En_Acquisition --
   ----------------------------

   procedure Buffer_Handling
     (Object : access Stand_Alone_Actor_Exemple_Type) is
   begin
      delay 1.0;
      Log4ada.Loggers.Info_Out (Object.Logger'Access,
                                "I do nothing, but I do it well :)");
   end Buffer_Handling;

   procedure Initialise (Object : access Stand_Alone_Actor_Exemple_Type;
                         Actor_Name : String) is
      Parameter : Parameters.Parameter_Access;
      use Parameters;
      use Ada.Strings.Unbounded;
   begin
      Stand_Alone_Actors.Initialise (Stand_Alone_Actor_Access (Object),
                                     Actor_Name);
      Parameter := new Parameter_Type'(Container_Kind => Unsigned_16_Type,
                                       Mode => Read_Write,
                                       Monitor => Never,
                                       Name =>
                                         To_Unbounded_String ("test_port"),
                                       Run_Parameter => False,
                                       Editor => None,
                                       Unsigned_16_Value => 10201);
      Object.Port := 10201;
      Parameter_Vector_Package.Append (Object.Parameters_List,
                                       Parameter);
      Parameter := new Parameter_Type'(Container_Kind => Boolean_Type,
                                       Mode => Read_Write,
                                       Monitor => Never,
                                       Name =>
                                         To_Unbounded_String ("test_running"),
                                       Run_Parameter => False,
                                       Editor => None,
                                       Boolean_Value => False);
      Parameter_Vector_Package.Append (Object.Parameters_List,
                                       Parameter);
   end Initialise;

   procedure Parameter_Changed (Object : access Stand_Alone_Actor_Exemple_Type;
                                Parameter : Parameters.Parameter_Access) is
      use Ada.Strings.Unbounded;
   begin
      if Parameter.Name = "test_running" then
         if Parameter.Boolean_Value then
            select
               Object.Task_Test.Start;
            or
               delay 0.1;
               Log4ada.Loggers.Warn_Out
                 (Object.Logger'Access,
                  "attempt to start already running task");
            end select;
         else
            select
               Object.Task_Test.Stop;
            or
               delay 0.1;
               Log4ada.Loggers.Warn_Out
                 (Object.Logger'Access,
                  "attempt to stop already stopped task");
            end select;
         end if;
      elsif Parameter.Name = "test_port" then
         Object.Port := Positive (Parameter.Unsigned_16_Value);
      else
         Stand_Alone_Actors.Parameter_Changed
           (Stand_Alone_Actor_Access (Object), Parameter);
      end if;
   end Parameter_Changed;

   task body Task_Test_Type is
      use GNAT.Sockets;
      Address  : Sock_Addr_Type;
      Server   : Socket_Type;
      Socket   : Socket_Type;
      Channel  : Stream_Access;
      Request : Request_Type := (Non_Blocking_IO, True);
      use Ada.Strings.Unbounded;
   begin
      loop
         select
            accept Start;
         or
            terminate;
         end select;
         Address.Addr := Addresses (Get_Host_By_Name (Host_Name), 1);
         Address.Port := GNAT.Sockets.Port_Type (Wrapper.Port);
         Create_Socket (Server);
         Set_Socket_Option
           (Server,
            Socket_Level,
            (Reuse_Address, True));
         Bind_Socket (Server, Address);
         Listen_Socket (Server);
         Control_Socket (Server, Request);
         loop
            begin
               Accept_Socket (Server, Socket, Address);
               Channel := Stream (Socket);
               String'Output (Channel, To_String ("Hi from actor " &
                                                  Wrapper.Name));
               Close_Socket (Socket);
            exception
               when GNAT.Sockets.Socket_Error =>
                  Log4ada.Loggers.Info_Out (Wrapper.Logger'Access,
                                            "nobody trying to connect");
               when E : others =>
                  Log4ada.Loggers.Warn_Out (Wrapper.Logger'Access,
                                            "exception in Task_Test_Type", E);
            end;
            select
               accept Stop;
               exit;
            or
               delay 1.0;
            end select;
         end loop;
         Close_Socket (Server);
      end loop;
   end Task_Test_Type;

end Narval.Actors.Actives.Stand_Alone_Actors.Example;
