"use strict";

var helpers = require("../helpers/helpers");

exports["EET"] = {

	"guess:by:offset" : helpers.makeTestGuess("EET", { offset: true, expect: "Europe/Athens" }),

	"guess:by:abbr" : helpers.makeTestGuess("EET", { abbr: true, expect: "Europe/Athens" }),

	"1977" : helpers.makeTestYear("EET", [
		["1977-04-03T00:59:59+00:00", "02:59:59", "EET", -120],
		["1977-04-03T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1977-09-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1977-09-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1978" : helpers.makeTestYear("EET", [
		["1978-04-02T00:59:59+00:00", "02:59:59", "EET", -120],
		["1978-04-02T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1978-10-01T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1978-10-01T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1979" : helpers.makeTestYear("EET", [
		["1979-04-01T00:59:59+00:00", "02:59:59", "EET", -120],
		["1979-04-01T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1979-09-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1979-09-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1980" : helpers.makeTestYear("EET", [
		["1980-04-06T00:59:59+00:00", "02:59:59", "EET", -120],
		["1980-04-06T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1980-09-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1980-09-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1981" : helpers.makeTestYear("EET", [
		["1981-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["1981-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1981-09-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1981-09-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1982" : helpers.makeTestYear("EET", [
		["1982-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["1982-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1982-09-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1982-09-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1983" : helpers.makeTestYear("EET", [
		["1983-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["1983-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1983-09-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1983-09-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1984" : helpers.makeTestYear("EET", [
		["1984-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["1984-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1984-09-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1984-09-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1985" : helpers.makeTestYear("EET", [
		["1985-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["1985-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1985-09-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1985-09-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1986" : helpers.makeTestYear("EET", [
		["1986-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["1986-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1986-09-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1986-09-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1987" : helpers.makeTestYear("EET", [
		["1987-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["1987-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1987-09-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1987-09-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1988" : helpers.makeTestYear("EET", [
		["1988-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["1988-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1988-09-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1988-09-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1989" : helpers.makeTestYear("EET", [
		["1989-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["1989-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1989-09-24T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1989-09-24T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1990" : helpers.makeTestYear("EET", [
		["1990-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["1990-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1990-09-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1990-09-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1991" : helpers.makeTestYear("EET", [
		["1991-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["1991-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1991-09-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1991-09-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1992" : helpers.makeTestYear("EET", [
		["1992-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["1992-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1992-09-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1992-09-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1993" : helpers.makeTestYear("EET", [
		["1993-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["1993-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1993-09-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1993-09-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1994" : helpers.makeTestYear("EET", [
		["1994-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["1994-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1994-09-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1994-09-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1995" : helpers.makeTestYear("EET", [
		["1995-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["1995-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1995-09-24T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1995-09-24T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1996" : helpers.makeTestYear("EET", [
		["1996-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["1996-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1996-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1996-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1997" : helpers.makeTestYear("EET", [
		["1997-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["1997-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1997-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1997-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1998" : helpers.makeTestYear("EET", [
		["1998-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["1998-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1998-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1998-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1999" : helpers.makeTestYear("EET", [
		["1999-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["1999-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1999-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1999-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2000" : helpers.makeTestYear("EET", [
		["2000-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2000-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2000-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2000-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2001" : helpers.makeTestYear("EET", [
		["2001-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2001-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2001-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2001-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2002" : helpers.makeTestYear("EET", [
		["2002-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2002-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2002-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2002-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2003" : helpers.makeTestYear("EET", [
		["2003-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2003-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2003-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2003-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2004" : helpers.makeTestYear("EET", [
		["2004-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2004-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2004-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2004-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2005" : helpers.makeTestYear("EET", [
		["2005-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2005-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2005-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2005-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2006" : helpers.makeTestYear("EET", [
		["2006-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2006-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2006-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2006-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2007" : helpers.makeTestYear("EET", [
		["2007-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2007-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2007-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2007-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2008" : helpers.makeTestYear("EET", [
		["2008-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2008-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2008-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2008-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2009" : helpers.makeTestYear("EET", [
		["2009-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2009-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2009-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2009-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2010" : helpers.makeTestYear("EET", [
		["2010-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2010-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2010-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2010-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2011" : helpers.makeTestYear("EET", [
		["2011-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2011-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2011-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2011-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2012" : helpers.makeTestYear("EET", [
		["2012-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2012-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2012-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2012-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2013" : helpers.makeTestYear("EET", [
		["2013-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2013-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2013-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2013-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2014" : helpers.makeTestYear("EET", [
		["2014-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2014-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2014-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2014-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2015" : helpers.makeTestYear("EET", [
		["2015-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2015-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2015-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2015-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2016" : helpers.makeTestYear("EET", [
		["2016-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2016-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2016-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2016-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2017" : helpers.makeTestYear("EET", [
		["2017-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2017-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2017-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2017-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2018" : helpers.makeTestYear("EET", [
		["2018-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2018-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2018-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2018-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2019" : helpers.makeTestYear("EET", [
		["2019-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2019-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2019-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2019-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2020" : helpers.makeTestYear("EET", [
		["2020-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2020-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2020-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2020-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2021" : helpers.makeTestYear("EET", [
		["2021-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2021-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2021-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2021-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2022" : helpers.makeTestYear("EET", [
		["2022-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2022-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2022-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2022-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2023" : helpers.makeTestYear("EET", [
		["2023-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2023-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2023-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2023-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2024" : helpers.makeTestYear("EET", [
		["2024-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2024-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2024-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2024-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2025" : helpers.makeTestYear("EET", [
		["2025-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2025-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2025-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2025-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2026" : helpers.makeTestYear("EET", [
		["2026-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2026-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2026-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2026-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2027" : helpers.makeTestYear("EET", [
		["2027-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2027-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2027-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2027-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2028" : helpers.makeTestYear("EET", [
		["2028-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2028-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2028-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2028-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2029" : helpers.makeTestYear("EET", [
		["2029-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2029-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2029-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2029-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2030" : helpers.makeTestYear("EET", [
		["2030-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2030-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2030-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2030-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2031" : helpers.makeTestYear("EET", [
		["2031-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2031-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2031-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2031-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2032" : helpers.makeTestYear("EET", [
		["2032-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2032-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2032-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2032-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2033" : helpers.makeTestYear("EET", [
		["2033-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2033-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2033-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2033-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2034" : helpers.makeTestYear("EET", [
		["2034-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2034-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2034-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2034-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2035" : helpers.makeTestYear("EET", [
		["2035-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2035-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2035-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2035-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2036" : helpers.makeTestYear("EET", [
		["2036-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2036-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2036-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2036-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2037" : helpers.makeTestYear("EET", [
		["2037-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2037-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2037-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2037-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	])
};