/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file HiLoTextAttributes.h
    \brief Definition of HiLoText Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:45 2012
*/
   

#ifndef HiLoTextAttributes_H
#define HiLoTextAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class HiLoTextAttributes 
{
public:
//  --  constructor
    HiLoTextAttributes();
    
//  --  destructor
    virtual ~HiLoTextAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const HiLoTextAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Text to represent local maxima 
    \param hi_text Setting contour_hi_text - default=H
*/
	void setHi_text(const string& hi_text) 
		{ hi_text_ =  hi_text; } 
	const string& getHi_text() const 
		{ return hi_text_; } 
        
/*!
    Magics Information:
    \brief  Text to represent local minima 
    \param lo_text Setting contour_lo_text - default=L
*/
	void setLo_text(const string& lo_text) 
		{ lo_text_ =  lo_text; } 
	const string& getLo_text() const 
		{ return lo_text_; } 
        
/*!
    Magics Information:
    \brief  Blank around highs and lows (ON/OFF)
    \param blanking Setting contour_hilo_blanking - default=off
*/
	void setBlanking(bool blanking) 
		{ blanking_ =  blanking; } 
	bool getBlanking() const 
		{ return blanking_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string hi_text_;
	string lo_text_;
	bool blanking_;

private:
  
	friend ostream& operator<<(ostream& s,const HiLoTextAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
