/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisTitleAttributes.h
    \brief Definition of AxisTitle Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:46 2012
*/
   

#ifndef AxisTitleAttributes_H
#define AxisTitleAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class AxisTitleAttributes 
{
public:
//  --  constructor
    AxisTitleAttributes();
    
//  --  destructor
    virtual ~AxisTitleAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const AxisTitleAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

	void setXmlData(const string& data)  { lines_.push_back(data); } 
/*!
    Magics Information:
    \brief  Colour of axis title
    \param colour Setting axis_title_colour - default=automatic
*/
	void setColour(Colour* colour) 
		{ auto_ptr<Colour> tmp(colour); colour_ = tmp; } 
	const Colour&  getColour() const 
		{ return *colour_; }
/*!
    Magics Information:
    \brief  Height of axis title
    \param height Setting axis_title_height - default=0.4
*/
	void setHeight(double height) 
		{ height_ =  height; } 
	double getHeight() const 
		{ return height_; } 
        
/*!
    Magics Information:
    \brief  Orientation of the axis title (HORIZONTAL/VERTICAL/PARALLEL) 
    \param orientation Setting axis_title_orientation - default=parallel
*/
	void setOrientation(const string& orientation) 
		{ orientation_ =  orientation; } 
	const string& getOrientation() const 
		{ return orientation_; } 
        
/*!
    Magics Information:
    \brief  The axis title text 
    \param text Setting axis_title_text - default=
*/
	void setText(const string& text) 
		{ text_ =  text; } 
	const string& getText() const 
		{ return text_; } 
        
/*!
    Magics Information:
    \brief  The axis title text 
    \param lines Setting axis_title_lines - default=stringarray()
*/
	void setLines(stringarray lines) 
		{ lines_ =  lines; } 
	stringarray getLines() const 
		{ return lines_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string axis_title_lines_;
	auto_ptr<Colour> colour_;
	double height_;
	string orientation_;
	string text_;
	stringarray lines_;

private:
  
	friend ostream& operator<<(ostream& s,const AxisTitleAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
