/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisMethodAttributes.cc
    \brief Implemtation of AxisMethod Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Mar  5 17:12:46 2012
*/    

#include "AxisMethodAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


AxisMethodAttributes::AxisMethodAttributes():
	min_(ParameterManager::getDouble("axis_min_value")),
	max_(ParameterManager::getDouble("axis_max_value")),
	interval_(ParameterManager::getDouble("axis_tick_interval")),
	minor_tick_count_(ParameterManager::getInt("axis_minor_tick_count"))
{
} 



AxisMethodAttributes::~AxisMethodAttributes()
{
}

    
void AxisMethodAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "axis";

	setAttribute(prefix, "axis_min_value", min_, params);
	setAttribute(prefix, "axis_max_value", max_, params);
	setAttribute(prefix, "axis_tick_interval", interval_, params);
	setAttribute(prefix, "axis_minor_tick_count", minor_tick_count_, params);
}

void AxisMethodAttributes::copy(const AxisMethodAttributes& other)
{
	min_ = other.min_;
	max_ = other.max_;
	interval_ = other.interval_;
	minor_tick_count_ = other.minor_tick_count_;
} 


bool AxisMethodAttributes::accept(const string& node)
{	
	if ( magCompare(node, "")  )
		return true;
	return false;
}

void AxisMethodAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	set(node.attributes());
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void AxisMethodAttributes::print(ostream& out)  const
{
	out << "AxisMethodAttributes[";
	out << "min = " << min_;
	out << ", max = " << max_;
	out << ", interval = " << interval_;
	out << ", minor_tick_count = " << minor_tick_count_;
	out << "]" << "\n";
}


void AxisMethodAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
     out <<  "\"\"";
	 out << ", \"axis_min_value\":";
	 niceprint(out,min_);
	 out << ", \"axis_max_value\":";
	 niceprint(out,max_);
	 out << ", \"axis_tick_interval\":";
	 niceprint(out,interval_);
	 out << ", \"axis_minor_tick_count\":";
	 niceprint(out,minor_tick_count_);
}
static MagicsParameter<double> axis_min_value("axis_min_value", 0, " Default has changed from 'No Default' to 0 ");
static MagicsParameter<double> axis_max_value("axis_max_value", 0, " Default has changed from 'No Default' to 0 ");
static MagicsParameter<double> axis_tick_interval("axis_tick_interval", INT_MAX, "Default changed from '1/7 of axis length' to'INT_MAX' ");
static MagicsParameter<int> axis_minor_tick_count("axis_minor_tick_count", 4, "");
