/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisGridAttributes.h
    \brief Definition of AxisGrid Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:46 2012
*/
   

#ifndef AxisGridAttributes_H
#define AxisGridAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class AxisGridAttributes 
{
public:
//  --  constructor
    AxisGridAttributes();
    
//  --  destructor
    virtual ~AxisGridAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const AxisGridAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief Colour of grid lines
    \param colour Setting axis_grid_colour - default=yellow
*/
	void setColour(Colour* colour) 
		{ auto_ptr<Colour> tmp(colour); colour_ = tmp; } 
	const Colour&  getColour() const 
		{ return *colour_; }
/*!
    Magics Information:
    \brief  Thickness of grid lines 
    \param thickness Setting axis_grid_thickness - default=1
*/
	void setThickness(int thickness) 
		{ thickness_ =  thickness; } 
	int getThickness() const 
		{ return thickness_; } 
        
/*!
    Magics Information:
    \brief  Line style of grid (SOLID/DASH/DOT/CHAIN_DOT/CHAIN_DASH) 
    \param style Setting axis_grid_line_style - default=solid
*/
	void setStyle(LineStyle style) 
		{ style_ =  style; } 
	LineStyle getStyle() const 
		{ return style_; } 
        
/*!
    Magics Information:
    \brief  value to be used as reference for the grid
    \param reference_level Setting axis_grid_reference_level - default=INT_MAX
*/
	void setReference_level(double reference_level) 
		{ reference_level_ =  reference_level; } 
	double getReference_level() const 
		{ return reference_level_; } 
        
/*!
    Magics Information:
    \brief  Thickness of the reference grid line 
    \param reference_thickness Setting axis_grid_reference_thickness - default=2
*/
	void setReference_thickness(int reference_thickness) 
		{ reference_thickness_ =  reference_thickness; } 
	int getReference_thickness() const 
		{ return reference_thickness_; } 
        
/*!
    Magics Information:
    \brief  Line style of the reference  grid line (SOLID/DASH/DOT/CHAIN_DOT/CHAIN_DASH) 
    \param reference_style Setting axis_grid_reference_line_style - default=solid
*/
	void setReference_style(LineStyle reference_style) 
		{ reference_style_ =  reference_style; } 
	LineStyle getReference_style() const 
		{ return reference_style_; } 
        
/*!
    Magics Information:
    \brief  Colour of the reference  grid line
    \param reference_colour Setting axis_grid_reference_colour - default=automatic
*/
	void setReference_colour(Colour* reference_colour) 
		{ auto_ptr<Colour> tmp(reference_colour); reference_colour_ = tmp; } 
	const Colour&  getReference_colour() const 
		{ return *reference_colour_; }
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	auto_ptr<Colour> colour_;
	int thickness_;
	LineStyle style_;
	double reference_level_;
	int reference_thickness_;
	LineStyle reference_style_;
	auto_ptr<Colour> reference_colour_;

private:
  
	friend ostream& operator<<(ostream& s,const AxisGridAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
