/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file GribDecoderAttributes.h
    \brief Definition of GribDecoder Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:43 2012
*/
   

#ifndef GribDecoderAttributes_H
#define GribDecoderAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "WindMode.h"
#include "GribAddressMode.h"

namespace magics {

class XmlNode;



class GribDecoderAttributes 
{
public:
//  --  constructor
    GribDecoderAttributes();
    
//  --  destructor
    virtual ~GribDecoderAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const GribDecoderAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  The name of the input file containing the GRIB code field(s) 
    \param file_name Setting grib_input_file_name - default=
*/
	void setFile_name(const string& file_name) 
		{ file_name_ =  file_name; } 
	const string& getFile_name() const 
		{ return file_name_; } 
        
/*!
    Magics Information:
    \brief Id used to identify a grib file in the title production
    \param id Setting grib_id - default=
*/
	void setId(const string& id) 
		{ id_ =  id; } 
	const string& getId() const 
		{ return id_; } 
        
/*!
    Magics Information:
    \brief  Scaling of the decoded field (ON/OFF) 
    \param scaling Setting grib_automatic_scaling - default=on
*/
	void setScaling(bool scaling) 
		{ scaling_ =  scaling; } 
	bool getScaling() const 
		{ return scaling_; } 
        
/*!
    Magics Information:
    \brief  Scaling of the decoded derived field (ON/OFF). A field is considered derived if the GRIB_API key generatingProcessIdentifier is 254. 
    \param derived_scaling Setting grib_automatic_derived_scaling - default=off
*/
	void setDerived_scaling(bool derived_scaling) 
		{ derived_scaling_ =  derived_scaling; } 
	bool getDerived_scaling() const 
		{ return derived_scaling_; } 
        
/*!
    Magics Information:
    \brief  Apply a scaling factor to the field. 
    \param scaling_factor Setting grib_scaling_factor - default=1
*/
	void setScaling_factor(double scaling_factor) 
		{ scaling_factor_ =  scaling_factor; } 
	double getScaling_factor() const 
		{ return scaling_factor_; } 
        
/*!
    Magics Information:
    \brief  Apply a scaling offset to the field. 
    \param scaling_offset Setting grib_scaling_offset - default=0
*/
	void setScaling_offset(double scaling_offset) 
		{ scaling_offset_ =  scaling_offset; } 
	double getScaling_offset() const 
		{ return scaling_offset_; } 
        
/*!
    Magics Information:
    \brief Automatic preparation of text from the GRIB code field (ON/OFF) 
    \param text Setting grib_text - default=on
*/
	void setText(bool text) 
		{ text_ =  text; } 
	bool getText() const 
		{ return text_; } 
        
/*!
    Magics Information:
    \brief  Include the name or number of the experiment, used to generate the GRIB code field, in the automatic text  (ON/OFF)  
    \param expver Setting grib_text_experiment - default=off
*/
	void setExpver(bool expver) 
		{ expver_ =  expver; } 
	bool getExpver() const 
		{ return expver_; } 
        
/*!
    Magics Information:
    \brief  Include the units of the input field in the automatic text  (ON/OFF) 
    \param units Setting grib_text_units - default=off
*/
	void setUnits(bool units) 
		{ units_ =  units; } 
	bool getUnits() const 
		{ return units_; } 
        
/*!
    Magics Information:
    \brief  Automatic setting of MAGICS contour/wind parameters by PGRIB (ON/OFF) 
    \param specification Setting grib_specification - default=on
*/
	void setSpecification(bool specification) 
		{ specification_ =  specification; } 
	bool getSpecification() const 
		{ return specification_; } 
        
/*!
    Magics Information:
    \brief  Normally GRIB fields are stored as records on a file. If the BYTE offset method is being used, the parameter GRIB_FILE_ADDRESS_MODE should be set to 'BYTE_OFFSET'.(RECORD_NUMBER/BYTE_OFFSET) 
    \param address_mode Setting grib_file_address_mode - default=record
*/
	void setAddress_mode(GribAddressMode* address_mode) 
		{ auto_ptr<GribAddressMode> tmp(address_mode); address_mode_ = tmp; } 
	const GribAddressMode&  getAddress_mode() const 
		{ return *address_mode_; }
/*!
    Magics Information:
    \brief  The incoming wind field may contain data other than wind components, e.g. wave height and direction.
	                 grib_wind_mode should be set to indicate how to interpret the incoming wind field, 
	                 as u/v components, vorticity/divergence or speed/direction (uv/vd/sd).
         
    \param wind_mode Setting grib_wind_mode - default=uv
*/
	void setWind_mode(WindMode* wind_mode) 
		{ auto_ptr<WindMode> tmp(wind_mode); wind_mode_ = tmp; } 
	const WindMode&  getWind_mode() const 
		{ return *wind_mode_; }
/*!
    Magics Information:
    \brief  The position in the input file of a field other than a wind component 
    \param grib_field_position Setting grib_field_position - default=1
*/
	void setGrib_field_position(int grib_field_position) 
		{ grib_field_position_ =  grib_field_position; } 
	int getGrib_field_position() const 
		{ return grib_field_position_; } 
        
/*!
    Magics Information:
    \brief  The position in the input file of a wind component field 
    \param position_1 Setting grib_wind_position_1 - default=1
*/
	void setPosition_1(int position_1) 
		{ position_1_ =  position_1; } 
	int getPosition_1() const 
		{ return position_1_; } 
        
/*!
    Magics Information:
    \brief  The position in the input file of a wind component field 
    \param position_2 Setting grib_wind_position_2 - default=2
*/
	void setPosition_2(int position_2) 
		{ position_2_ =  position_2; } 
	int getPosition_2() const 
		{ return position_2_; } 
        
/*!
    Magics Information:
    \brief  When MAGICS is decoding GRIB code, this is the value to be assigned to field values where data is missing, as indicated by the bit map in the GRIB file. 
    \param missing_value Setting grib_missing_value_indicator - default=-1.5e+21
*/
	void setMissing_value(double missing_value) 
		{ missing_value_ =  missing_value; } 
	double getMissing_value() const 
		{ return missing_value_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string file_name_;
	string id_;
	bool scaling_;
	bool derived_scaling_;
	double scaling_factor_;
	double scaling_offset_;
	bool text_;
	bool expver_;
	bool units_;
	bool specification_;
	auto_ptr<GribAddressMode> address_mode_;
	auto_ptr<WindMode> wind_mode_;
	int grib_field_position_;
	int position_1_;
	int position_2_;
	double missing_value_;

private:
  
	friend ostream& operator<<(ostream& s,const GribDecoderAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
