/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file UserLogoPlottingAttributes.h
    \brief Definition of UserLogoPlotting Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:45 2012
*/
   

#ifndef UserLogoPlottingAttributes_H
#define UserLogoPlottingAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class UserLogoPlottingAttributes 
{
public:
//  --  constructor
    UserLogoPlottingAttributes();
    
//  --  destructor
    virtual ~UserLogoPlottingAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const UserLogoPlottingAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Logo's Path 
    \param path Setting user_logo_filename - default=
*/
	void setPath(const string& path) 
		{ path_ =  path; } 
	const string& getPath() const 
		{ return path_; } 
        
/*!
    Magics Information:
    \brief Specify the format of the logo
    \param format Setting user_logo_format - default=PNG
*/
	void setFormat(const string& format) 
		{ format_ =  format; } 
	const string& getFormat() const 
		{ return format_; } 
        
/*!
    Magics Information:
    \brief Units used to define the position of the logo: cm or percent
    \param units Setting user_logo_position_units - default=cm
*/
	void setUnits(const string& units) 
		{ units_ =  units; } 
	const string& getUnits() const 
		{ return units_; } 
        
/*!
    Magics Information:
    \brief  Y position of the imported image 
    \param y Setting user_logo_y_position - default=2.5
*/
	void setY(double y) 
		{ y_ =  y; } 
	double getY() const 
		{ return y_; } 
        
/*!
    Magics Information:
    \brief  X position of the imported image 
    \param x Setting user_logo_x_position - default=80
*/
	void setX(double x) 
		{ x_ =  x; } 
	double getX() const 
		{ return x_; } 
        
/*!
    Magics Information:
    \brief  Y position of the imported image 
    \param bottom Setting user_logo_bottom - default=
*/
	void setBottom(const string& bottom) 
		{ bottom_ =  bottom; } 
	const string& getBottom() const 
		{ return bottom_; } 
        
/*!
    Magics Information:
    \brief  X position of the imported image 
    \param left Setting user_logo_left - default=
*/
	void setLeft(const string& left) 
		{ left_ =  left; } 
	const string& getLeft() const 
		{ return left_; } 
        
/*!
    Magics Information:
    \brief  width of the imported image (-1 means use the dimension of the image) 
    \param width Setting user_logo_width - default=-1
*/
	void setWidth(double width) 
		{ width_ =  width; } 
	double getWidth() const 
		{ return width_; } 
        
/*!
    Magics Information:
    \brief  height of the imported image (-1 means use the dimension of the image) 
    \param height Setting user_logo_height - default=-1
*/
	void setHeight(double height) 
		{ height_ =  height; } 
	double getHeight() const 
		{ return height_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string path_;
	string format_;
	string units_;
	double y_;
	double x_;
	string bottom_;
	string left_;
	double width_;
	double height_;

private:
  
	friend ostream& operator<<(ostream& s,const UserLogoPlottingAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
