#include "include/support.h"
#include "include/command.h"
#include "include/message.h"

class LWCommandAnd: public LWCommand {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	(void) context;
	
	g_return_val_if_fail (argc == 2, NULL);
	
	gint r = args[0]->toInt() && args[1]->toInt();
	
	return new LWValue (r);
}

gchar *getName ()
{
	return "and";
}	

gchar *getHint ()
{
	return _("And");
}

guint getPriority ()
{
	return 5;
}

LWLink getLinkType ()
{
	return LW_LINK_LEFT;
}

gboolean hasReturn()
{
	return TRUE;
}

void checkArgc (guint n)
{
	if (n != 2) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}	

};

LWSymbol *new_LWCommandAnd()
{
	return new LWCommandAnd();
}
