/* (C) Marcin Kwadrans <quar@vitea.pl> */

/*! \file command.h 
	\brief Obsługa poleceń
*/
#ifndef __LW_COMMAND_H
#define __LW_COMMAND_H

#include "symbol.h"
#include "value.h"
#include "wizard.h"

typedef enum LWLink {
LW_LINK_LEFT=0,
LW_LINK_RIGHT=1
};

/*! \struct LWContext
	\brief Struktura kontekstu

	Zawiera wskaźniki do bierzącej instrukcji, stosu i obiektu czarodzieja
	w środowisku z niej dziedziczy.
*/
struct LWContext {
GNode *instrPtr;
GQueue *stack;
GQueue *queue_keys;
LWWizard *wizard;
};

/*! \class LWCommand
	\brief Klasa polecenia

	Abstrakcyjna klasa polecenia. Każde polecenie zdefiniowane
	w środowisku z niej dziedziczy.
*/
class LWCommand: public LWSymbol {
private:
LWValue *arg[2];
guint argc;
void getArguments (LWValue *args[], GQueue *stack);
void freeArguments (LWValue *args[]);
void setReturn (LWValue *value, GQueue *stack);
protected:
LWCommand ();
virtual void checkArgument (guint n, LWValue *value);
virtual void checkArgc (guint argc);
virtual LWValue *execute1 (LWContext *context, guint argc, LWValue *args[]) = 0;
virtual void reset1 ();
public:
void reset();
void execute (LWContext *context);
void setArgument (guint n, LWValue *value);
void setArgc (guint n);
virtual gboolean hasReturn ();
virtual gboolean isLoop();
virtual gboolean isParity();
virtual gboolean canBeSkiped ();
virtual guint getPriority ();
virtual LWLink getLinkType ();
gboolean canClone ();
gboolean isCommand ();
};

#endif
