#ifndef _KVI_SYSTRAY_H_INCLUDED_
#define _KVI_SYSTRAY_H_INCLUDED_

//
//   File : kvi_systray.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_systray.h)
//   Last major modification : Tue Apr 13 1999 17:55:01 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"

#include <qwidget.h>
#include <qpixmap.h>
#include <qiconset.h>
#include <qlist.h>
//#warning "Check <time.h> localtime() gmtime() time() in configure"
#include <time.h>
#include <sys/types.h> //time_t is defined in time.h or here ?
#include <unistd.h>

#include <X11/Xlib.h>
#ifdef COMPILE_USE_AA_FONTS
	#include <X11/Xft/Xft.h>
#endif

#include <qtoolbar.h>
#include <qlist.h>

class KviSysTray;
class KviFrame;

class KviSysTrayIconDisplay : public QWidget
{
	Q_OBJECT
public:
	KviSysTrayIconDisplay(KviSysTray * parent);
	~KviSysTrayIconDisplay();
protected:
	KviSysTray * m_pSysTray;
	QIconSet * m_pIcon;
public:
	void setIcon(QPixmap * pix); // the pixmap is copied!
protected:
	virtual void paintEvent(QPaintEvent *e);
	virtual void mousePressEvent(QMouseEvent *e);
};

class KviSysTrayWidget : public QWidget
{
	Q_OBJECT
public:
	KviSysTrayWidget(KviSysTray * parent,const char *tooltip,const char * name = 0);
	~KviSysTrayWidget();
public:
	KviSysTray * m_pSysTray;
	void * m_plugin_handle;
public:
	virtual QPixmap * icon();
protected:
	void paintDefaultBackground(HANDLE hMemBuf,GC the_gc);
	void paintDefaultFrame(HANDLE hMemBuf,GC the_gc);
};

class KviSysTrayLogo : public KviSysTrayWidget
{
	Q_OBJECT
public:
	KviSysTrayLogo(KviSysTray * parent);
	~KviSysTrayLogo();
protected:
	virtual void paintEvent(QPaintEvent *e);
};

class KviSysTrayClock : public KviSysTrayWidget
{
	Q_OBJECT
public:
	KviSysTrayClock(KviSysTray * parent);
	KviSysTrayClock(KviSysTray * parent,const char *tooltip,const char * name);
	~KviSysTrayClock();
protected:
	int m_timer;
public:
	virtual void hide();
	virtual void show();
protected:
	virtual void timerEvent(QTimerEvent *e);
	virtual void paintEvent(QPaintEvent *e);
	virtual struct tm * getTime(const time_t * timep);
	virtual QPixmap * icon();
};

class KviSysTrayUtcClock : public KviSysTrayClock
{
	Q_OBJECT
public:
	KviSysTrayUtcClock(KviSysTray * parent);
	~KviSysTrayUtcClock();
protected:
	virtual struct tm * getTime(const time_t * timep);
	virtual QPixmap * icon();
};

class KviSysTrayOnLineTimer : public KviSysTrayWidget
{
	Q_OBJECT
public:
	KviSysTrayOnLineTimer(KviSysTray * parent);
	~KviSysTrayOnLineTimer();
protected:
	int m_timer;
	time_t m_iConnectionStartTime;
public:
	void run();
	void stop();
	virtual void hide();
	virtual void show();
	void getConnectionTime(KviStr &buffer);
	int getIntConnectionTime();
	unsigned int getConnectionStartTime(){ return (unsigned int)m_iConnectionStartTime; }
protected:
	virtual QPixmap * icon();
	virtual void timerEvent(QTimerEvent *e);
	virtual void paintEvent(QPaintEvent *e);
};

class KviSysTrayIoLed : public KviSysTrayWidget
{
	friend class KviIrcSocket;
	Q_OBJECT
public:
	KviSysTrayIoLed(KviSysTray * parent);
	~KviSysTrayIoLed();
protected:
	int m_timer;
	int m_iInLed;
	int m_iOutLed;
public:
	void clear();
	virtual void hide();
	virtual void show();
protected:
	void dataMessageReceived();
	void dataMessageSent();
	virtual QPixmap * icon();
	virtual void timerEvent(QTimerEvent *e);
	virtual void paintEvent(QPaintEvent *e);
};

class KviSysTray : public QWidget
{
	Q_OBJECT
public:
	KviSysTray(QWidget * parent);
	~KviSysTray();
public:
	QList<KviSysTrayWidget> * m_pWidgetList;
protected:
	KviSysTrayIconDisplay * m_pIconDisplay;
	KviSysTrayWidget        * m_pCurrentWidget;
	QPixmap * m_pMemBuffer;
public:
	KviSysTrayWidget * currentWidget(){ return m_pCurrentWidget; };
	void rotateMode();
	KviSysTrayWidget * findSysTrayWidget(const char *classname);
	void addPluginWidget(KviSysTrayWidget *w, bool bShow = true);
	bool setCurrentWidget(KviSysTrayWidget *w);
	void removeWidget(KviSysTrayWidget * w,bool bDelete = true);
	void killPluginWidgets(void * plugin_handle);
	virtual QSize sizeHint();
protected:
	virtual void resizeEvent(QResizeEvent *e);
public:
	inline QPixmap * getMemoryBuffer(){ return m_pMemBuffer; };
	inline HANDLE    getMemoryBufferHandle(){ return m_pMemBuffer->handle(); };
	unsigned long    getBackgroundPixel();
	unsigned long    getForegroundPixel();
};

class KviSysTrayBar : public QToolBar
{
	Q_OBJECT
public:
	KviSysTrayBar(KviFrame *parent,QMainWindow::ToolBarDock dock);
	~KviSysTrayBar();
public:
	KviSysTray *m_pSysTray;
};

#endif //!_KVI_SYSTRAY_H_INCLUDED_
