#ifndef _KVI_SCRIPTSOCKET_H_INCLUDED_
#define _KVI_SCRIPTSOCKET_H_INCLUDED_

//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_scriptobject.h"

#include <qsocketnotifier.h>

class KviScriptSocket : public KviScriptObject
{
	Q_OBJECT
	public:
		KviScriptSocket(KviScriptObjectController * cntrl,KviScriptObject * p,const char *name,KviScriptObjectClassDefinition * pDef);
		~KviScriptSocket();
	protected:
		int               m_sock;
		int               m_type;
		int               m_protocol;
		int               m_domain;
		int               m_error;
		int               m_iReadBufLen;
		char            * m_pReadBuffer;
		enum DataMode { Ascii , Hex };
		enum SockState { Ready , Connecting , Connected , Listening };
		DataMode          m_mode;
		SockState         m_state;
		KviStr            m_szHostIp;
		KviStr            m_szPort;
		QSocketNotifier * m_pRsn;
		QSocketNotifier * m_pTmpSn;
		int               m_incomingConnectionSock;
		KviStr            m_szIncomingConnectionPort;
		KviStr            m_szIncomingConnectionHostIp;
		KviStr            m_szLocalHostIp;
	public:
		static void initializeClassDefinition(KviScriptObjectClassDefinition *d);
		int builtinFunction_MODE(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETDOMAIN(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETTYPE(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETMODE(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETPROTOCOL(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_WRITE(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_WRITEHEX(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_CLOSE(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_PROTOCOL(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_TYPE(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_HOST(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_PORT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_STATE(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_DOMAIN(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_CONNECT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_LISTEN(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_LASTERROR(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_ACCEPT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_LOCALHOST(QList<KviStr> * params,KviStr &buffer);
	private:
		void setLocalHostIp();
		bool doListen(KviStr *szLocalAddr,KviStr *szPort);
		bool doConnect(KviStr * szHost,KviStr *szPort);
		void setErrorFromSystemError(int errorNum);
		void reset();
		void handleInvalidSocketRead(int readedLength);
		int writeData(char * buffer,int len);
		bool doAccept(const char *sockObjectId);
		bool hasPendingConnection(){ return (m_incomingConnectionSock != -1); };
	private slots:
		void writeNotifierFired(int fd);
		void listenNotifierFired(int fd);
		void receivedData(int fd);
};



#endif //_KVI_SCRIPTSOCKET_H_DEFINED_
