//
//   File : kvi_dlguser.cpp (/usr/build/NEW_kvirc/kvirc/kvirc/kvi_dlguser.cpp)
//   Last major modification : Sat Dec 11 1999 14:07:39 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define _KVI_DLGUSER_CPP_

#include "kvi_options.h"
#include "kvi_dlguser.h"
#include "kvi_defines.h"
#include "kvi_locale.h"
#include "kvi_app.h"
#include "kvi_selectors.h"

#include <qlayout.h>

/*
	@quickhelp: KviDlgOptUser
	@widget: User options dialog
		Here you set your basic IRC preferences:<br>
		Edit your nickname in the <a href="qh_qwidget_nicknametab.kvihelp">nickname tab</a>.<br>
		Edit your default user mode in the <a href="qh_qwidget_defumodetab.kvihelp">default user mode tab</a>.<br>
*/

KviDlgOptUser::KviDlgOptUser(QWidget *parent)
:QTabDialog(parent,"dlguser")
{
	setCaption(__tr("KVIrc: User Configuration"));

	//
	// Nickname tab...
	//

	/*
		@quickhelp: QWidget_NicknameTab
		@widget: Nickname tab
			The options in this tab are strictly required to connect to an IRC server.<br>
			The <b>nickname</b> is a name that the IRC server will use to identify you.<br>
			Your nickname should be <b>unique</a> in the whole IRC network that you're going to connect to.<br>
			So it may happen that the nickname you've choosen is already used by someone else.<br>
			For this reason you can specify an <b>alternative nickname</b>.<br>
			The <b>user name</b> will be declared to the server at connect time.<br>
			The server may choose to accept this one, or to check your real username by
			connecting to your ident service.<br>
			The <b>real name</b> will be shown to other users when they will perform a <a href="whois.kvihelp">WHOIS</a> on you.<br>
			You can put any (reasonably short) string here.<br>
	*/

	QWidget * tab = new QWidget(this,"nicknametab");
	QGridLayout *g = new QGridLayout(tab,4,1,10,4);

	KviNewStringSelector *c;

	c=new KviNewStringSelector(tab,_i18n_("Nickname:"),&(g_pOptions->m_szNickName1));
	g->addWidget(c,0,0);
	c=new KviNewStringSelector(tab,_i18n_("Alt. nickname:"),&(g_pOptions->m_szNickName2));
	g->addWidget(c,1,0);
	c=new KviNewStringSelector(tab,_i18n_("Username:"),&(g_pOptions->m_szUserName));
	g->addWidget(c,2,0);
	c=new KviNewStringSelector(tab,_i18n_("Real name:"),&(g_pOptions->m_szRealName));
	g->addWidget(c,3,0);

	addTab(tab,_i18n_("&Identity"));

	//
	// Protection tab
	//

	/*
		@quickhelp: QWidget_DefUModeTab
		@widget: Default user mode tab
			Here you can choose the default user modes that KVIrc will attempt to set for you at connect time.<br>
			When you're <b>invisible</b>, other users will be not able to "see" you unless they know your nickname.<br>
			The generic <b>+s</b> flag makes you become a recipient for the server notices.
			Many servers have also other flags that allow you to choose the type of the notices you want to receive.<br>
			Note: Some servers will automatically set for you some user modes and not all modes may be supported.<br>
	*/


	tab=new QWidget(this,"defumodetab");
	g=new QGridLayout(tab,3,1,10,4);

	KviNewBoolSelector *b;

	b=new KviNewBoolSelector(tab,_i18n_("Invisible (Mode +i)"),&(g_pOptions->m_bModeIOnConnect));
	g->addWidget(b,0,0);
	b=new KviNewBoolSelector(tab,_i18n_("Receive server notices (Mode +s)"),&(g_pOptions->m_bModeSOnConnect));
	g->addWidget(b,1,0);
	b=new KviNewBoolSelector(tab,_i18n_("Receive wallops (Mode +w)"),&(g_pOptions->m_bModeWOnConnect));
	g->addWidget(b,2,0);

	addTab(tab,_i18n_("Default &Modes"));

	setHelpButton(_CHAR_2_QSTRING(__tr("What's &This?")));
	connect(this,SIGNAL(helpButtonPressed()),g_pApp,SLOT(slot_whatIsThisRequest()));
	setOkButton(__tr("&OK"));
	setCancelButton(__tr("&Cancel"));
}

KviDlgOptUser::~KviDlgOptUser()
{
}

void KviDlgOptUser::done(int r)
{
	QTabDialog::done(r);
	if(r == Accepted)
	{
		KviNewBoolSelector::commitAll(this);
		KviNewStringSelector::commitAll(this);
	}
	emit finished((r == Accepted));
}

void KviDlgOptUser::closeEvent(QCloseEvent *)
{
	emit finished(false);
}

#include "m_kvi_dlguser.moc"
