#ifndef _KVI_DCC_MANAGER_H_INCLUDED_
#define _KVI_DCC_MANAGER_H_INCLUDED_

//
//   File : kvi_dcc_manager.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_dcc_manager.h)
//   Last major modification : Sat May 15 1999 16:06:07 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

class KviFrame;

#include <qobject.h>

#include "kvi_string.h"
#include "kvi_ircuser.h"

#include <qmessagebox.h>
#include <qfiledialog.h>

typedef struct KviDccSendRequestStruct
{
	KviStr nick;
	KviStr username;
	KviStr host;
	KviStr fileName;
	KviStr filePath;
	KviStr originalFileName;
	unsigned long fileLength;
	unsigned long uAddress;
	unsigned long resumeValue;
	unsigned short uPort;
};


class KviDccManager;
class KviFrame;
class KviDccChat;

class KviDccChatMessageBox : public QMessageBox
{
	Q_OBJECT
public:
	KviDccChatMessageBox(KviFrame * parent,const char *nick,const char *username,const char *host,unsigned long int uAddress,unsigned short uPort,bool bVoice = false);
	~KviDccChatMessageBox();
public:
	KviStr m_nick;
	KviStr m_username;
	KviStr m_host;
	unsigned long m_uAddress;
	unsigned short m_uPort;
protected:
	virtual void done(int result);
signals:
	void dccRequestAccepted(const char *n,const char *u,const char *h,unsigned long a,unsigned short p);
};

class KviDccSendMessageBox : public QMessageBox
{
	Q_OBJECT
public:
	KviDccSendMessageBox(KviFrame * parent,KviDccSendRequestStruct * dccSend);
	~KviDccSendMessageBox();
public:
	KviDccSendRequestStruct * m_dccSend;
protected:
	virtual void done(int result);
signals:
	void dccRequestAccepted(KviDccSendRequestStruct *dccSend);
};

class KviDccSendResumeMessageBox : public QMessageBox
{
	Q_OBJECT
public:
	KviDccSendResumeMessageBox(KviFrame * parent,KviDccSendRequestStruct * dccSend);
	~KviDccSendResumeMessageBox();
public:
	KviDccSendRequestStruct * m_dccSend;
protected:
	virtual void done(int result);
signals:
	void dccSendResumeSelectionDone(KviDccSendRequestStruct *dccSend);
};

class KviDccSendRenameMessageBox : public QMessageBox
{
	Q_OBJECT
public:
	KviDccSendRenameMessageBox(KviFrame * parent,KviDccSendRequestStruct * dccSend);
	~KviDccSendRenameMessageBox();
public:
	KviDccSendRequestStruct * m_dccSend;
protected:
	virtual void done(int result);
signals:
	void dccSendRenameSelectionDone(KviDccSendRequestStruct *dccSend);
};

class KviDccSendFileDialog : public QFileDialog
{
	Q_OBJECT
public:
	KviDccSendFileDialog(KviFrame * parent,KviDccSendRequestStruct *dccSend,bool bOutgoingDcc);
	~KviDccSendFileDialog();
public:
	KviDccSendRequestStruct * m_dccSend;
protected:
	virtual void done(int result);
signals:
	void dccSaveNameSelected(KviDccSendRequestStruct *dccSend);
};

typedef struct _KviDccRequest
{
	KviStr szType;
	KviStr szParam;
	KviStr szAddress;
	KviStr szPort;
	KviStr szLast;
	KviStr szGarbage;
	KviStr szOriginalRequest;
	unsigned short uPort;
	unsigned long uAddress;
} KviDccRequest;

class KviDccManager : public QObject
{
	Q_OBJECT
public:
	KviDccManager(KviFrame * frame);
	~KviDccManager();
public:
	KviFrame * m_pFrm;
public:
	void handleDccRequest(KviIrcUser &source,KviDccRequest * dcc);

	void handleDccChat(KviIrcUser &source,unsigned long uAddress,unsigned short uPort);
	void handleDccVoice(KviIrcUser &source,unsigned long uAddress,unsigned short uPort);
	void handleDccSend(KviIrcUser &source,KviStr &filename,unsigned long fileLen,unsigned long uAddress,unsigned short uPort);
	void handleDccAccept(KviIrcUser &source,KviStr &filename,unsigned short uPort,unsigned long uResumePos);
	void handleDccResume(KviIrcUser &source,KviStr &filename,unsigned short uPort,unsigned long uResumePos);

	KviDccChat * requestDccChat(const char *nick,const char *userandhost = 0);
	void requestDccVoice(const char *nick);
	void requestDccSend(const char *nick,const char *filename);

	unsigned short int getDccSendListenPort();
public slots:
	void acceptDccChat(const char *nick,const char *username,const char *host,unsigned long uAddress,unsigned short uPort);
	void acceptDccVoice(const char *nick,const char *username,const char *host,unsigned long uAddress,unsigned short uPort);
	void acceptDccSend(KviDccSendRequestStruct *dccSend);
	void dccSendFileNameSelected(KviDccSendRequestStruct *dccSend);
	void dccSendResumeSelectionDone(KviDccSendRequestStruct *dccSend);
	void dccSendFileToSendSelected(KviDccSendRequestStruct *dccSend);
};

#endif //!_KVI_DCC_MANAGER_H_INCLUDED_
