#ifndef _KVI_FILEUTILS_H_INCLUDED_
#define _KVI_FILEUTILS_H_INCLUDED_

//
//   File : kvi_fileutils.h (/usr/build/NEW_kvirc/kvirc/kvicore/kvi_fileutils.h)
//   Last major modification : Fri Dec 25 1998 18:27:04 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"

#include <qfile.h>
#include <qstringlist.h>

#ifdef _KVI_FILEUTILS_CPP_
	#define __kvi_extern
#else
	#define __kvi_extern extern
#endif

__kvi_extern bool kvi_isAbsolutePath(const char *path);
__kvi_extern bool kvi_fileExists(const char *path);
__kvi_extern bool kvi_fileIsReadable(const char *path);
__kvi_extern bool kvi_directoryExists(const char *path);
__kvi_extern bool kvi_makeDir(const char *path);

/**
* Reads a single line from the file and returns false if EOF was encountered.
*/
__kvi_extern bool kvi_readLine(QFile *f,KviStr &str);
/**
* Same as above but strips whitespace too.
*/
__kvi_extern bool kvi_readStrippedLine(QFile *f,KviStr &str);
/**
* Reads stripped lines until a non empty one is found...
* An empty line may be returned if EOF is found before reading any significant data.
*/
__kvi_extern bool kvi_readFirstNonEmptyStrippedLine(QFile *f,KviStr &str);
/**
* Writes a data line to the file f and returns false if an error occurs
*/
__kvi_extern bool kvi_writeLine(QFile *f,const char *line);

__kvi_extern QString kvi_askForDirectoryName(const char * basePath = 0);
__kvi_extern QString kvi_askForOpenFileName(const char *basePath = 0,const char *filter = 0);
__kvi_extern QStringList kvi_askForOpenFileNames(const char * basePath = 0,const char * filter = 0);
__kvi_extern QString kvi_askForSaveFileName(const char *baseFileName = 0);

__kvi_extern bool kvi_loadFile(const char *path,KviStr &buffer);
__kvi_extern bool kvi_writeFile(const char *path,KviStr &buffer);
__kvi_extern bool kvi_copyFile(const char *src,const char *dst);
__kvi_extern bool kvi_renameFile(const char *src,const char *dst);

#endif //_KVI_FILEUTILS_H_INCLUDED_
