#!/bin/bash

# Arguments:
# $1 = files to search
# $2 = filename to produce
# $3 = search string

set -e

if test -z "$1"; then
	echo "Search error : missing files to search"
	exit -1
fi

if test -z "$2"; then
	echo "Search error : missing target filename"
	exit -1
fi

if test -z "$3"; then
	echo "Search error : missing search string"
	exit -1
fi

# Build the search criteria string...not so funky, but works
SEARCH_CRITERIA="$3"
SEARCH_WORDS="$3"
if test -n "$4"; then
	SEARCH_WORDS="$SEARCH_WORDS $4"
	SEARCH_CRITERIA="$SEARCH_CRITERIA AND $4"
fi
if test -n "$5"; then
	SEARCH_WORDS="$SEARCH_WORDS $5"
	SEARCH_CRITERIA="$SEARCH_CRITERIA AND $5"
fi
if test -n "$6"; then
	SEARCH_WORDS="$SEARCH_WORDS $6"
	SEARCH_CRITERIA="$SEARCH_CRITERIA AND $6"
fi
if test -n "$7"; then
	SEARCH_WORDS="$SEARCH_WORDS $7"
	SEARCH_CRITERIA="$SEARCH_CRITERIA AND $7"
fi
if test -n "$8"; then
	SEARCH_WORDS="$SEARCH_WORDS $8"
	SEARCH_CRITERIA="$SEARCH_CRITERIA AND $8"
fi
if test -n "$9"; then
	SEARCH_WORDS="$SEARCH_WORDS $9"
	SEARCH_CRITERIA="$SEARCH_CRITERIA AND $9"
fi

# Now grep the files
SEARCH_RESULT=""
for a_word in $SEARCH_WORDS; do	
	if test -z "$SEARCH_RESULT"; then
		SEARCH_RESULT=`grep -i -l $a_word $1`
	else
		SEARCH_RESULT=`grep -i -l $a_word $SEARCH_RESULT`
	fi
	if test -z "$SEARCH_RESULT"; then
		echo "<doctitle>Search results for \"$SEARCH_CRITERIA\"</doctitle><docbody><hr><br>No matches found</docbody>" > $2
		exit 0
	fi
done

RESULT_DOC="<doctitle>Search results for \"$SEARCH_CRITERIA\"</doctitle><docbody><hr><br>"
DOCS_COUNT="0"

for a_file in $SEARCH_RESULT; do

	RESULT_DESCRIPTION="<b>["
	for a_word in $SEARCH_WORDS; do
		WORD_MATCHES=`grep -i -h -c $a_word "$a_file"`
		RESULT_DESCRIPTION="$RESULT_DESCRIPTION $a_word:$WORD_MATCHES  "
	done
	RESULT_DESCRIPTION="$RESULT_DESCRIPTION ]</b>"
	
	DOC_TITLE=`grep -i -h doctitle "$a_file" | sed -e 's/doctitle/b/g'`
	if test -z "$DOC_TITLE"; then
		DOC_TITLE="<b>Untitled</b>"
	fi	
	DOC_PREMATCH=`grep -i -h -A 7 docbody "$a_file" | tac | tail -n 7 | tac`
	DOC_MATCH=`echo "$DOC_PREMATCH" | sed -e 's/</\&lt;/g' -e 's/>/\&gt;/g'`
	DOC_MATCH=`echo "$DOC_MATCH" | sed -e 's/\&lt;br\&gt;/<br>/g'`
	DOC_MATCH=`echo "$DOC_MATCH" | sed -e 's/\&lt;hr\&gt;/<br>/g'`
	DOC_MATCH=`echo "$DOC_MATCH" | sed -e 's/\&lt;docbody\&gt;//g'`
	DOC_MATCH=`echo "$DOC_MATCH" | sed -e 's/\&lt;\/docbody\&gt;//g'`
	DOC_MATCH=`echo "$DOC_MATCH" | sed -e 's/\&lt;docsubtitle\&gt;//g'`
	DOC_MATCH=`echo "$DOC_MATCH" | sed -e 's/\&lt;\/docsubtitle\&gt;/<br>/g'`
	if test -z "$DOC_MATCH"; then
		DOC_MATCH="No document body found"
	fi
	DOCS_COUNT=`expr $DOCS_COUNT + 1`
	RESULT_DOC="$RESULT_DOC<a href=\"$a_file\"><b>$DOCS_COUNT</b>. $DOC_TITLE</a><br><I>...$DOC_MATCH...</I><br><b>$RESULT_DESCRIPTION</b><br><br>"
done
RESULT_DOC="$RESULT_DOC<hr><br>Found $DOCS_COUNT matches</docbody>"
echo "$RESULT_DOC" > $2
