/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef KBIBTEXWEBQUERYPUBMED_H
#define KBIBTEXWEBQUERYPUBMED_H

#include <qwidget.h>
#include <qlistview.h>
#include <qxml.h>
#include <qvaluelist.h>

#include <kdialogbase.h>
#include <webquery.h>

#include <entry.h>

class QComboBox;
class QListView;
class QStringList;
class QBuffer;
class QDomElement;
class QDate;
class QLineEdit;
class QSpinBox;
class QHttp;
class BibTeX::File;

namespace KBibTeX
{
    class PubMedWizard;

    class WebQueryPubMed : public WebQuery
    {
    public:
        WebQueryPubMed( QWidget* parent, const char* name = 0 );
        ~WebQueryPubMed();

        BibTeX::File* query( );

        QString title();
        int uniqueId();

    private:
        PubMedWizard *wizard;
    };

    class PubMedWizard: public KDialogBase
    {
        Q_OBJECT
    public:
        PubMedWizard ( const QString &caption, QWidget* parent, const char* name = 0 );
        ~PubMedWizard();

        BibTeX::File *result();

    public slots:
        int exec();

        void accept();

    private slots:
        void startSearch();
        void databaseQueryDone( bool );
        void fetchingSummaryDone( bool );
        void listViewResultsSelectionChanged( );

    private:
        QHttp *http;
        QBuffer *buffer;
        QLineEdit *m_lineEditQuery;
        QSpinBox *m_spinBoxMaxHits;
        QPushButton *m_pushButtonSearch;
        QListView *m_listViewResults;
        BibTeX::File *bibtexFile;

        void setupGUI();
    };

    class StructureParserQuery : public QXmlDefaultHandler
    {
    public:
        StructureParserQuery( QListView *listView );
        StructureParserQuery( QValueList<int> *intList );
        ~StructureParserQuery( );

        bool startElement( const QString&, const QString&, const QString&, const QXmlAttributes& );
        bool endElement( const QString&, const QString&, const QString& );
        bool characters ( const QString & ch );

    private:
        QListView *m_listView;
        QValueList<int> *m_intList;
        QString concatString;
        QString lastDbName;
        QString lastMenuName;
        QString lastCount;
    };

    class ResultParser
    {
    public:
        ResultParser( QListView *listView, const QDomElement& rootElement );
        ~ResultParser();

    private:
        void parsePubmedArticle( const QDomElement& element, BibTeX::Entry *entry );
        void parseMedlineCitation( const QDomElement& element, BibTeX::Entry *entry );
        void parseArticle( const QDomElement& element, BibTeX::Entry *entry );
        void parseJournal( const QDomElement& element, BibTeX::Entry *entry );
        void parseJournalIssue( const QDomElement& element, BibTeX::Entry *entry );
        void parsePubDate( const QDomElement& element, BibTeX::Entry *entry );
        void parseAuthorList( const QDomElement& element, BibTeX::Entry *entry );
    };

    class DatabasesListViewItem: public QListViewItem
    {
    public:
        DatabasesListViewItem ( QListView * parent, const QString&dbName, const QString&dbTitle, int numHits );

        QString dbName();
    private:
        QString m_dbName;
    };

    class ResultsListViewItem: public QListViewItem
    {
    public:
        ResultsListViewItem ( QListView * parent, BibTeX::Entry *entry );
        ~ResultsListViewItem();

        BibTeX::Entry* entry();
    private:
        BibTeX::Entry *m_entry;
    };
}

#endif
