/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef BIBTEXVALUE_H
#define BIBTEXVALUE_H

#include <qobject.h>
#include <qvaluelist.h>

namespace BibTeX
{
    class ValueItem
    {
    public:
        ValueItem( const QString& text, bool isStringKey );
        ValueItem( ValueItem *other );

        QString text() const;
        bool isStringKey() const;
        void setText( const QString &text );
        void setIsStringKey( bool isStringKey );

        bool containsPattern( const QString & pattern, bool caseSensitive ) const;

    protected:
        QString m_text;
        bool m_isStringKey;
    };

    class Value
    {
    public:
        Value( );
        Value( const Value* other );
        virtual ~Value( );

        virtual void add( ValueItem* valueItem );
        virtual void clear();
        BibTeX::ValueItem *first();

        bool isEmpty() const;
        int count() const;
        virtual bool containsPattern( const QString & pattern, bool caseSensitive ) const;

        static bool checkIsStringKey( const QString &text );

        QValueList<ValueItem*>::const_iterator begin() const;
        QValueList<ValueItem*>::const_iterator end() const;

        QString plainString() const;
        QString debugString() const;

    protected:
        QValueList<ValueItem*> m_valueItems;
    };

    class Person
    {
    public:
        Person( const QString& text );
        Person( const QString& firstName, const QString& lastName );
        Person( const Person* other );

        void setText( const QString &text );
        QString text() const;
        QString lastName() const;
        QString firstName() const;

        bool containsPattern( const QString & pattern, bool caseSensitive ) const;

    private:
        QString m_lastName;
        QString m_firstName;

        void parseText( const QString& text );
    };

    class ValuePersons: public Value
    {
    public:
        ValuePersons( );
        ValuePersons( const BibTeX::ValuePersons* other );
        ~ValuePersons();

        void add ( ValueItem* valueItem );
        void clear();
        bool containsPattern( const QString & pattern, bool caseSensitive ) const;

        QValueList<Person*> persons() const;

    private:
        QValueList<Person*> m_persons;
    };

}

#endif
