/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef DocumentListView_H
#define DocumentListView_H

#include <klistview.h>
#include <kxmlguifactory.h>

#include <fileimporter.h>
#include <settings.h>
#include <file.h>

class QString;
class KURL;
class KActionMenu;
class KPopupMenu;

namespace KBibTeX
{
    class DocumentWidget;
    class DocumentListViewItem;

    class DocumentListView : public KListView
    {
        Q_OBJECT
    public:
        DocumentListView( KBibTeX::DocumentWidget *docWidget, bool isReadOnly, QWidget *parent = 0, const char *name = 0 );
        ~DocumentListView();

        void setFactory( KXMLGUIFactory *factory, KXMLGUIClient *client );

        bool setBibTeXFile( BibTeX::File *bibtexFile );
        BibTeX::File* getBibTeXFile( );
        bool insertItems( BibTeX::File *items, KBibTeX::DocumentListViewItem *after = NULL );

        void deleteSelected();
        void copySelected();
        void copyRefSelected();
        void cutSelected();
        bool paste();

        void updateVisiblity();

        void deferredInitialization();
        void restoreState();

        void setViewShowColumnsMenu( KActionMenu *actionMenu );

    signals:
        void modified();

    public slots:
        void slotDoubleClick( QListViewItem * item = NULL );
        BibTeX::Element* editElement( QListViewItem * item = NULL );
        void filterText( const QString& text, BibTeX::EntryField::FieldType fieldType );
        void setReadOnly( bool isReadOnly );
        void activateShowColumnMenu( int id );

    private slots:
        void setSortingColumn( int column );
        void showBibtexListContextMenu( KListView *, QListViewItem *, const QPoint &p );
        void slotDropped( QDropEvent* event, QListViewItem* item );
        void saveColumnIndex( int col = -1 );
        void restoreColumnIndex();
        void saveColumnWidths( int col = -1 );
        void restoreColumnWidths();
        void restoreSortingColumn();
        void makeNewItemsUnread();

    protected:
        //     void resizeEvent( QResizeEvent * e );
        //     void contentsDragEnterEvent( QDragEnterEvent *e );
        //         void dropEvent( QDropEvent *e );
        bool acceptDrag( QDropEvent* e ) const;
        //     void contentsDropEvent( QDropEvent *e );
        //     void startDrag();

        virtual bool eventFilter( QObject *watched, QEvent *e );

        virtual void keyPressEvent ( QKeyEvent *e );

    private:
        static const int maxColumns = 256;
        KBibTeX::DocumentWidget *m_docWidget;
        BibTeX::File *m_bibtexFile;
        KPopupMenu *m_contextMenu;
        KPopupMenu *m_headerMenu;
        KActionMenu *m_columnVisibleAction;
        bool m_isReadOnly;
        QValueList<DocumentListViewItem*> m_unreadItems;

        QString m_filter;
        BibTeX::EntryField::FieldType m_filterFieldType;
        int m_newElementCounter;

        void setItems();
        //         void appendBibTeXFile( BibTeX::File *bibtexfile );
        QString selectedAsString();

        void showColumn( int col, int colWidth = 0xffff );
        void hideColumn( int col );
        void buildColumns();
    };
}

#endif
